/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.media.AudioTrack;
import android.speech.tts.AbstractEventLogger;
import android.speech.tts.BlockingAudioTrack;
import android.speech.tts.PlaybackQueueItem;
import android.speech.tts.TextToSpeechService;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class SynthesisPlaybackQueueItem
extends PlaybackQueueItem
implements AudioTrack.OnPlaybackPositionUpdateListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "TTS.SynthQueueItem";
    private static boolean DBG = false;
    private static long MAX_UNCONSUMED_AUDIO_MS = 500L;
    private Lock mListLock;
    private Condition mReadReady;
    private Condition mNotFull;
    private LinkedList<ListEntry> mDataBufferList;
    private int mUnconsumedBytes;
    private volatile boolean mStopped;
    private volatile boolean mDone;
    private volatile int mStatusCode;
    private BlockingAudioTrack mAudioTrack;
    private AbstractEventLogger mLogger;
    private ConcurrentLinkedQueue<ProgressMarker> markerList;

    private void $$robo$$android_speech_tts_SynthesisPlaybackQueueItem$__constructor__(TextToSpeechService.AudioOutputParams audioParams, int sampleRate, int audioFormat, int channelCount, TextToSpeechService.UtteranceProgressDispatcher dispatcher, Object callerIdentity, AbstractEventLogger logger) {
        this.mListLock = new ReentrantLock();
        this.mReadReady = this.mListLock.newCondition();
        this.mNotFull = this.mListLock.newCondition();
        this.mDataBufferList = new LinkedList();
        this.markerList = new ConcurrentLinkedQueue();
        this.mUnconsumedBytes = 0;
        this.mStopped = false;
        this.mDone = false;
        this.mStatusCode = 0;
        this.mAudioTrack = new BlockingAudioTrack(audioParams, sampleRate, audioFormat, channelCount);
        this.mLogger = logger;
    }

    private final void $$robo$$android_speech_tts_SynthesisPlaybackQueueItem$run() {
        TextToSpeechService.UtteranceProgressDispatcher dispatcher = this.getDispatcher();
        dispatcher.dispatchOnStart();
        if (!this.mAudioTrack.init()) {
            dispatcher.dispatchOnError(-5);
            return;
        }
        this.mAudioTrack.setPlaybackPositionUpdateListener(this);
        this.updateMarker();
        try {
            byte[] buffer = null;
            while ((buffer = this.take()) != null) {
                this.mAudioTrack.write(buffer);
                this.mLogger.onAudioDataWritten();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.mAudioTrack.waitAndRelease();
        if (this.mStatusCode == 0) {
            dispatcher.dispatchOnSuccess();
        } else if (this.mStatusCode == -2) {
            dispatcher.dispatchOnStop();
        } else {
            dispatcher.dispatchOnError(this.mStatusCode);
        }
        this.mLogger.onCompleted(this.mStatusCode);
    }

    private final void $$robo$$android_speech_tts_SynthesisPlaybackQueueItem$stop(int statusCode) {
        try {
            this.mListLock.lock();
            this.mStopped = true;
            this.mStatusCode = statusCode;
            this.mReadReady.signal();
            this.mNotFull.signal();
        }
        finally {
            this.mListLock.unlock();
        }
        this.mAudioTrack.stop();
    }

    private final void $$robo$$android_speech_tts_SynthesisPlaybackQueueItem$done() {
        try {
            this.mListLock.lock();
            this.mDone = true;
            this.mReadReady.signal();
            this.mNotFull.signal();
        }
        finally {
            this.mListLock.unlock();
        }
    }

    private final void $$robo$$android_speech_tts_SynthesisPlaybackQueueItem$updateMarker() {
        ProgressMarker marker = this.markerList.peek();
        if (marker != null) {
            int markerInFrames = marker.frames == 0 ? 1 : marker.frames;
            this.mAudioTrack.setNotificationMarkerPosition(markerInFrames);
        }
    }

    private final void $$robo$$android_speech_tts_SynthesisPlaybackQueueItem$rangeStart(int markerInFrames, int start, int end) {
        this.markerList.add(new ProgressMarker(this, markerInFrames, start, end));
        this.updateMarker();
    }

    private final void $$robo$$android_speech_tts_SynthesisPlaybackQueueItem$onMarkerReached(AudioTrack track) {
        ProgressMarker marker = this.markerList.poll();
        if (marker == null) {
            Log.e("TTS.SynthQueueItem", "onMarkerReached reached called but no marker in queue");
            return;
        }
        this.getDispatcher().dispatchOnRangeStart(marker.start, marker.end, marker.frames);
        this.updateMarker();
    }

    private final void $$robo$$android_speech_tts_SynthesisPlaybackQueueItem$onPeriodicNotification(AudioTrack track) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_speech_tts_SynthesisPlaybackQueueItem$put(byte[] buffer) throws InterruptedException {
        try {
            this.mListLock.lock();
            long unconsumedAudioMs = 0L;
            while ((unconsumedAudioMs = this.mAudioTrack.getAudioLengthMs(this.mUnconsumedBytes)) > 500L && !this.mStopped) {
                this.mNotFull.await();
            }
            if (this.mStopped) {
                return;
            }
            this.mDataBufferList.add(new ListEntry(buffer));
            this.mUnconsumedBytes += buffer.length;
            this.mReadReady.signal();
        }
        finally {
            this.mListLock.unlock();
        }
    }

    private final byte[] $$robo$$android_speech_tts_SynthesisPlaybackQueueItem$take() throws InterruptedException {
        try {
            this.mListLock.lock();
            while (this.mDataBufferList.size() == 0 && !this.mStopped && !this.mDone) {
                this.mReadReady.await();
            }
            if (this.mStopped) {
                byte[] byArray = null;
                return byArray;
            }
            ListEntry entry = this.mDataBufferList.poll();
            if (entry == null) {
                byte[] byArray = null;
                return byArray;
            }
            this.mUnconsumedBytes -= entry.mBytes.length;
            this.mNotFull.signal();
            byte[] byArray = entry.mBytes;
            return byArray;
        }
        finally {
            this.mListLock.unlock();
        }
    }

    private void __constructor__(TextToSpeechService.AudioOutputParams audioOutputParams, int n, int n2, int n3, TextToSpeechService.UtteranceProgressDispatcher utteranceProgressDispatcher, Object object, AbstractEventLogger abstractEventLogger) {
        this.$$robo$$android_speech_tts_SynthesisPlaybackQueueItem$__constructor__(audioOutputParams, n, n2, n3, utteranceProgressDispatcher, object, abstractEventLogger);
    }

    SynthesisPlaybackQueueItem(TextToSpeechService.AudioOutputParams audioOutputParams, int n, int n2, int n3, TextToSpeechService.UtteranceProgressDispatcher utteranceProgressDispatcher, Object object, AbstractEventLogger abstractEventLogger) {
        super(utteranceProgressDispatcher, object);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_SynthesisPlaybackQueueItem$__constructor__(android.speech.tts.TextToSpeechService$AudioOutputParams int int int android.speech.tts.TextToSpeechService$UtteranceProgressDispatcher java.lang.Object android.speech.tts.AbstractEventLogger ), 0, this, audioOutputParams, n, n2, n3, utteranceProgressDispatcher, object, abstractEventLogger);
    }

    @Override
    public void run() {
        InvokeDynamicSupport.bootstrap("run", $$robo$$android_speech_tts_SynthesisPlaybackQueueItem$run(), 0, this);
    }

    @Override
    void stop(int n) {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_speech_tts_SynthesisPlaybackQueueItem$stop(int ), 0, this, n);
    }

    void done() {
        InvokeDynamicSupport.bootstrap("done", $$robo$$android_speech_tts_SynthesisPlaybackQueueItem$done(), 0, this);
    }

    void updateMarker() {
        InvokeDynamicSupport.bootstrap("updateMarker", $$robo$$android_speech_tts_SynthesisPlaybackQueueItem$updateMarker(), 0, this);
    }

    void rangeStart(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("rangeStart", $$robo$$android_speech_tts_SynthesisPlaybackQueueItem$rangeStart(int int int ), 0, this, n, n2, n3);
    }

    @Override
    public void onMarkerReached(AudioTrack audioTrack) {
        InvokeDynamicSupport.bootstrap("onMarkerReached", $$robo$$android_speech_tts_SynthesisPlaybackQueueItem$onMarkerReached(android.media.AudioTrack ), 0, this, audioTrack);
    }

    @Override
    public void onPeriodicNotification(AudioTrack audioTrack) {
        InvokeDynamicSupport.bootstrap("onPeriodicNotification", $$robo$$android_speech_tts_SynthesisPlaybackQueueItem$onPeriodicNotification(android.media.AudioTrack ), 0, this, audioTrack);
    }

    void put(byte[] byArray) throws InterruptedException {
        InvokeDynamicSupport.bootstrap("put", $$robo$$android_speech_tts_SynthesisPlaybackQueueItem$put(byte[] ), 0, this, byArray);
    }

    private byte[] take() throws InterruptedException {
        return InvokeDynamicSupport.bootstrap("take", $$robo$$android_speech_tts_SynthesisPlaybackQueueItem$take(), 0, this);
    }

    public /* synthetic */ SynthesisPlaybackQueueItem() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SynthesisPlaybackQueueItem)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class ListEntry
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        byte[] mBytes;

        private void $$robo$$android_speech_tts_SynthesisPlaybackQueueItem_ListEntry$__constructor__(byte[] bytes) {
            this.mBytes = bytes;
        }

        private void __constructor__(byte[] byArray) {
            this.$$robo$$android_speech_tts_SynthesisPlaybackQueueItem_ListEntry$__constructor__(byArray);
        }

        ListEntry(byte[] byArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_SynthesisPlaybackQueueItem_ListEntry$__constructor__(byte[] ), 0, this, byArray);
        }

        public /* synthetic */ ListEntry() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ListEntry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ProgressMarker
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int frames;
        public int start;
        public int end;
        /* synthetic */ SynthesisPlaybackQueueItem this$0;

        private void $$robo$$android_speech_tts_SynthesisPlaybackQueueItem_ProgressMarker$__constructor__(SynthesisPlaybackQueueItem synthesisPlaybackQueueItem, int frames, int start, int end) {
            this.frames = frames;
            this.start = start;
            this.end = end;
        }

        private void __constructor__(SynthesisPlaybackQueueItem synthesisPlaybackQueueItem, int n, int n2, int n3) {
            this.$$robo$$android_speech_tts_SynthesisPlaybackQueueItem_ProgressMarker$__constructor__(synthesisPlaybackQueueItem, n, n2, n3);
        }

        public ProgressMarker(SynthesisPlaybackQueueItem synthesisPlaybackQueueItem, int n, int n2, int n3) {
            this.this$0 = synthesisPlaybackQueueItem;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_SynthesisPlaybackQueueItem_ProgressMarker$__constructor__(android.speech.tts.SynthesisPlaybackQueueItem int int int ), 0, this, synthesisPlaybackQueueItem, n, n2, n3);
        }

        public /* synthetic */ ProgressMarker() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProgressMarker)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

