/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.os.Bundle;
import android.telecom.AudioState;
import android.telecom.Call;
import android.telecom.CallAudioState;
import android.telecom.InCallAdapter;
import android.telecom.InCallService;
import android.telecom.Log;
import android.telecom.ParcelableCall;
import android.util.ArrayMap;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@Deprecated
@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class Phone
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Map<String, Call> mCallByTelecomCallId;
    private List<Call> mCalls;
    private List<Call> mUnmodifiableCalls;
    private InCallAdapter mInCallAdapter;
    private CallAudioState mCallAudioState;
    private List<Listener> mListeners;
    private boolean mCanAddCall;
    private String mCallingPackage;
    private int mTargetSdkVersion;

    private void $$robo$$android_telecom_Phone$__constructor__(InCallAdapter adapter, String callingPackage, int targetSdkVersion) {
        this.mCallByTelecomCallId = new ArrayMap<String, Call>();
        this.mCalls = new CopyOnWriteArrayList<Call>();
        this.mUnmodifiableCalls = Collections.unmodifiableList(this.mCalls);
        this.mListeners = new CopyOnWriteArrayList<Listener>();
        this.mCanAddCall = true;
        this.mInCallAdapter = adapter;
        this.mCallingPackage = callingPackage;
        this.mTargetSdkVersion = targetSdkVersion;
    }

    private final void $$robo$$android_telecom_Phone$internalAddCall(ParcelableCall parcelableCall) {
        Call call = new Call(this, parcelableCall.getId(), this.mInCallAdapter, parcelableCall.getState(), this.mCallingPackage, this.mTargetSdkVersion);
        this.mCallByTelecomCallId.put(parcelableCall.getId(), call);
        this.mCalls.add(call);
        this.checkCallTree(parcelableCall);
        call.internalUpdate(parcelableCall, this.mCallByTelecomCallId);
        this.fireCallAdded(call);
    }

    private final void $$robo$$android_telecom_Phone$internalRemoveCall(Call call) {
        this.mCallByTelecomCallId.remove(call.internalGetCallId());
        this.mCalls.remove(call);
        InCallService.VideoCall videoCall = call.getVideoCall();
        if (videoCall != null) {
            videoCall.destroy();
        }
        this.fireCallRemoved(call);
    }

    private final void $$robo$$android_telecom_Phone$internalUpdateCall(ParcelableCall parcelableCall) {
        Call call = this.mCallByTelecomCallId.get(parcelableCall.getId());
        if (call != null) {
            this.checkCallTree(parcelableCall);
            call.internalUpdate(parcelableCall, this.mCallByTelecomCallId);
        }
    }

    private final void $$robo$$android_telecom_Phone$internalSetPostDialWait(String telecomId, String remaining) {
        Call call = this.mCallByTelecomCallId.get(telecomId);
        if (call != null) {
            call.internalSetPostDialWait(remaining);
        }
    }

    private final void $$robo$$android_telecom_Phone$internalCallAudioStateChanged(CallAudioState callAudioState) {
        if (!Objects.equals(this.mCallAudioState, callAudioState)) {
            this.mCallAudioState = callAudioState;
            this.fireCallAudioStateChanged(callAudioState);
        }
    }

    private final Call $$robo$$android_telecom_Phone$internalGetCallByTelecomId(String telecomId) {
        return this.mCallByTelecomCallId.get(telecomId);
    }

    private final void $$robo$$android_telecom_Phone$internalBringToForeground(boolean showDialpad) {
        this.fireBringToForeground(showDialpad);
    }

    private final void $$robo$$android_telecom_Phone$internalSetCanAddCall(boolean canAddCall) {
        if (this.mCanAddCall != canAddCall) {
            this.mCanAddCall = canAddCall;
            this.fireCanAddCallChanged(canAddCall);
        }
    }

    private final void $$robo$$android_telecom_Phone$internalSilenceRinger() {
        this.fireSilenceRinger();
    }

    private final void $$robo$$android_telecom_Phone$internalOnConnectionEvent(String telecomId, String event, Bundle extras) {
        Call call = this.mCallByTelecomCallId.get(telecomId);
        if (call != null) {
            call.internalOnConnectionEvent(event, extras);
        }
    }

    private final void $$robo$$android_telecom_Phone$internalOnRttUpgradeRequest(String callId, int requestId) {
        Call call = this.mCallByTelecomCallId.get(callId);
        if (call != null) {
            call.internalOnRttUpgradeRequest(requestId);
        }
    }

    private final void $$robo$$android_telecom_Phone$internalOnRttInitiationFailure(String callId, int reason) {
        Call call = this.mCallByTelecomCallId.get(callId);
        if (call != null) {
            call.internalOnRttInitiationFailure(reason);
        }
    }

    private final void $$robo$$android_telecom_Phone$destroy() {
        for (Call call : this.mCalls) {
            InCallService.VideoCall videoCall = call.getVideoCall();
            if (videoCall != null) {
                videoCall.destroy();
            }
            if (call.getState() == 7) continue;
            call.internalSetDisconnected();
        }
    }

    private final void $$robo$$android_telecom_Phone$addListener(Listener listener) {
        this.mListeners.add(listener);
    }

    private final void $$robo$$android_telecom_Phone$removeListener(Listener listener) {
        if (listener != null) {
            this.mListeners.remove(listener);
        }
    }

    private final List<Call> $$robo$$android_telecom_Phone$getCalls() {
        return this.mUnmodifiableCalls;
    }

    private final boolean $$robo$$android_telecom_Phone$canAddCall() {
        return this.mCanAddCall;
    }

    private final void $$robo$$android_telecom_Phone$setMuted(boolean state) {
        this.mInCallAdapter.mute(state);
    }

    private final void $$robo$$android_telecom_Phone$setAudioRoute(int route) {
        this.mInCallAdapter.setAudioRoute(route);
    }

    private final void $$robo$$android_telecom_Phone$setProximitySensorOn() {
        this.mInCallAdapter.turnProximitySensorOn();
    }

    private final void $$robo$$android_telecom_Phone$setProximitySensorOff(boolean screenOnImmediately) {
        this.mInCallAdapter.turnProximitySensorOff(screenOnImmediately);
    }

    @Deprecated
    private final AudioState $$robo$$android_telecom_Phone$getAudioState() {
        return new AudioState(this.mCallAudioState);
    }

    private final CallAudioState $$robo$$android_telecom_Phone$getCallAudioState() {
        return this.mCallAudioState;
    }

    private final void $$robo$$android_telecom_Phone$fireCallAdded(Call call) {
        for (Listener listener : this.mListeners) {
            listener.onCallAdded(this, call);
        }
    }

    private final void $$robo$$android_telecom_Phone$fireCallRemoved(Call call) {
        for (Listener listener : this.mListeners) {
            listener.onCallRemoved(this, call);
        }
    }

    private final void $$robo$$android_telecom_Phone$fireCallAudioStateChanged(CallAudioState audioState) {
        for (Listener listener : this.mListeners) {
            listener.onCallAudioStateChanged(this, audioState);
            listener.onAudioStateChanged(this, new AudioState(audioState));
        }
    }

    private final void $$robo$$android_telecom_Phone$fireBringToForeground(boolean showDialpad) {
        for (Listener listener : this.mListeners) {
            listener.onBringToForeground(this, showDialpad);
        }
    }

    private final void $$robo$$android_telecom_Phone$fireCanAddCallChanged(boolean canAddCall) {
        for (Listener listener : this.mListeners) {
            listener.onCanAddCallChanged(this, canAddCall);
        }
    }

    private final void $$robo$$android_telecom_Phone$fireSilenceRinger() {
        for (Listener listener : this.mListeners) {
            listener.onSilenceRinger(this);
        }
    }

    private final void $$robo$$android_telecom_Phone$checkCallTree(ParcelableCall parcelableCall) {
        if (parcelableCall.getChildCallIds() != null) {
            for (int i = 0; i < parcelableCall.getChildCallIds().size(); ++i) {
                if (this.mCallByTelecomCallId.containsKey(parcelableCall.getChildCallIds().get(i))) continue;
                Log.wtf((Object)this, "ParcelableCall %s has nonexistent child %s", parcelableCall.getId(), parcelableCall.getChildCallIds().get(i));
            }
        }
    }

    private void __constructor__(InCallAdapter inCallAdapter, String string2, int n) {
        this.$$robo$$android_telecom_Phone$__constructor__(inCallAdapter, string2, n);
    }

    Phone(InCallAdapter inCallAdapter, String string2, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Phone$__constructor__(android.telecom.InCallAdapter java.lang.String int ), 0, this, inCallAdapter, string2, n);
    }

    void internalAddCall(ParcelableCall parcelableCall) {
        InvokeDynamicSupport.bootstrap("internalAddCall", $$robo$$android_telecom_Phone$internalAddCall(android.telecom.ParcelableCall ), 0, this, parcelableCall);
    }

    void internalRemoveCall(Call call) {
        InvokeDynamicSupport.bootstrap("internalRemoveCall", $$robo$$android_telecom_Phone$internalRemoveCall(android.telecom.Call ), 0, this, call);
    }

    void internalUpdateCall(ParcelableCall parcelableCall) {
        InvokeDynamicSupport.bootstrap("internalUpdateCall", $$robo$$android_telecom_Phone$internalUpdateCall(android.telecom.ParcelableCall ), 0, this, parcelableCall);
    }

    void internalSetPostDialWait(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("internalSetPostDialWait", $$robo$$android_telecom_Phone$internalSetPostDialWait(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    void internalCallAudioStateChanged(CallAudioState callAudioState) {
        InvokeDynamicSupport.bootstrap("internalCallAudioStateChanged", $$robo$$android_telecom_Phone$internalCallAudioStateChanged(android.telecom.CallAudioState ), 0, this, callAudioState);
    }

    Call internalGetCallByTelecomId(String string2) {
        return InvokeDynamicSupport.bootstrap("internalGetCallByTelecomId", $$robo$$android_telecom_Phone$internalGetCallByTelecomId(java.lang.String ), 0, this, string2);
    }

    void internalBringToForeground(boolean bl) {
        InvokeDynamicSupport.bootstrap("internalBringToForeground", $$robo$$android_telecom_Phone$internalBringToForeground(boolean ), 0, this, bl);
    }

    void internalSetCanAddCall(boolean bl) {
        InvokeDynamicSupport.bootstrap("internalSetCanAddCall", $$robo$$android_telecom_Phone$internalSetCanAddCall(boolean ), 0, this, bl);
    }

    void internalSilenceRinger() {
        InvokeDynamicSupport.bootstrap("internalSilenceRinger", $$robo$$android_telecom_Phone$internalSilenceRinger(), 0, this);
    }

    void internalOnConnectionEvent(String string2, String string3, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("internalOnConnectionEvent", $$robo$$android_telecom_Phone$internalOnConnectionEvent(java.lang.String java.lang.String android.os.Bundle ), 0, this, string2, string3, bundle);
    }

    void internalOnRttUpgradeRequest(String string2, int n) {
        InvokeDynamicSupport.bootstrap("internalOnRttUpgradeRequest", $$robo$$android_telecom_Phone$internalOnRttUpgradeRequest(java.lang.String int ), 0, this, string2, n);
    }

    void internalOnRttInitiationFailure(String string2, int n) {
        InvokeDynamicSupport.bootstrap("internalOnRttInitiationFailure", $$robo$$android_telecom_Phone$internalOnRttInitiationFailure(java.lang.String int ), 0, this, string2, n);
    }

    void destroy() {
        InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_telecom_Phone$destroy(), 0, this);
    }

    public void addListener(Listener listener) {
        InvokeDynamicSupport.bootstrap("addListener", $$robo$$android_telecom_Phone$addListener(android.telecom.Phone$Listener ), 0, this, listener);
    }

    public void removeListener(Listener listener) {
        InvokeDynamicSupport.bootstrap("removeListener", $$robo$$android_telecom_Phone$removeListener(android.telecom.Phone$Listener ), 0, this, listener);
    }

    public List<Call> getCalls() {
        return InvokeDynamicSupport.bootstrap("getCalls", $$robo$$android_telecom_Phone$getCalls(), 0, this);
    }

    public boolean canAddCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("canAddCall", $$robo$$android_telecom_Phone$canAddCall(), 0, this);
    }

    public void setMuted(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMuted", $$robo$$android_telecom_Phone$setMuted(boolean ), 0, this, bl);
    }

    public void setAudioRoute(int n) {
        InvokeDynamicSupport.bootstrap("setAudioRoute", $$robo$$android_telecom_Phone$setAudioRoute(int ), 0, this, n);
    }

    public void setProximitySensorOn() {
        InvokeDynamicSupport.bootstrap("setProximitySensorOn", $$robo$$android_telecom_Phone$setProximitySensorOn(), 0, this);
    }

    public void setProximitySensorOff(boolean bl) {
        InvokeDynamicSupport.bootstrap("setProximitySensorOff", $$robo$$android_telecom_Phone$setProximitySensorOff(boolean ), 0, this, bl);
    }

    @Deprecated
    public AudioState getAudioState() {
        return InvokeDynamicSupport.bootstrap("getAudioState", $$robo$$android_telecom_Phone$getAudioState(), 0, this);
    }

    public CallAudioState getCallAudioState() {
        return InvokeDynamicSupport.bootstrap("getCallAudioState", $$robo$$android_telecom_Phone$getCallAudioState(), 0, this);
    }

    private void fireCallAdded(Call call) {
        InvokeDynamicSupport.bootstrap("fireCallAdded", $$robo$$android_telecom_Phone$fireCallAdded(android.telecom.Call ), 0, this, call);
    }

    private void fireCallRemoved(Call call) {
        InvokeDynamicSupport.bootstrap("fireCallRemoved", $$robo$$android_telecom_Phone$fireCallRemoved(android.telecom.Call ), 0, this, call);
    }

    private void fireCallAudioStateChanged(CallAudioState callAudioState) {
        InvokeDynamicSupport.bootstrap("fireCallAudioStateChanged", $$robo$$android_telecom_Phone$fireCallAudioStateChanged(android.telecom.CallAudioState ), 0, this, callAudioState);
    }

    private void fireBringToForeground(boolean bl) {
        InvokeDynamicSupport.bootstrap("fireBringToForeground", $$robo$$android_telecom_Phone$fireBringToForeground(boolean ), 0, this, bl);
    }

    private void fireCanAddCallChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("fireCanAddCallChanged", $$robo$$android_telecom_Phone$fireCanAddCallChanged(boolean ), 0, this, bl);
    }

    private void fireSilenceRinger() {
        InvokeDynamicSupport.bootstrap("fireSilenceRinger", $$robo$$android_telecom_Phone$fireSilenceRinger(), 0, this);
    }

    private void checkCallTree(ParcelableCall parcelableCall) {
        InvokeDynamicSupport.bootstrap("checkCallTree", $$robo$$android_telecom_Phone$checkCallTree(android.telecom.ParcelableCall ), 0, this, parcelableCall);
    }

    public /* synthetic */ Phone() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Phone)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class Listener
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_telecom_Phone_Listener$__constructor__() {
        }

        @Deprecated
        private final void $$robo$$android_telecom_Phone_Listener$onAudioStateChanged(Phone phone, AudioState audioState) {
        }

        private final void $$robo$$android_telecom_Phone_Listener$onCallAudioStateChanged(Phone phone, CallAudioState callAudioState) {
        }

        private final void $$robo$$android_telecom_Phone_Listener$onBringToForeground(Phone phone, boolean showDialpad) {
        }

        private final void $$robo$$android_telecom_Phone_Listener$onCallAdded(Phone phone, Call call) {
        }

        private final void $$robo$$android_telecom_Phone_Listener$onCallRemoved(Phone phone, Call call) {
        }

        private final void $$robo$$android_telecom_Phone_Listener$onCanAddCallChanged(Phone phone, boolean canAddCall) {
        }

        private final void $$robo$$android_telecom_Phone_Listener$onSilenceRinger(Phone phone) {
        }

        private void __constructor__() {
            this.$$robo$$android_telecom_Phone_Listener$__constructor__();
        }

        public Listener() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Phone_Listener$__constructor__(), 0, this);
        }

        @Deprecated
        public void onAudioStateChanged(Phone phone, AudioState audioState) {
            InvokeDynamicSupport.bootstrap("onAudioStateChanged", $$robo$$android_telecom_Phone_Listener$onAudioStateChanged(android.telecom.Phone android.telecom.AudioState ), 0, this, phone, audioState);
        }

        public void onCallAudioStateChanged(Phone phone, CallAudioState callAudioState) {
            InvokeDynamicSupport.bootstrap("onCallAudioStateChanged", $$robo$$android_telecom_Phone_Listener$onCallAudioStateChanged(android.telecom.Phone android.telecom.CallAudioState ), 0, this, phone, callAudioState);
        }

        public void onBringToForeground(Phone phone, boolean bl) {
            InvokeDynamicSupport.bootstrap("onBringToForeground", $$robo$$android_telecom_Phone_Listener$onBringToForeground(android.telecom.Phone boolean ), 0, this, phone, bl);
        }

        public void onCallAdded(Phone phone, Call call) {
            InvokeDynamicSupport.bootstrap("onCallAdded", $$robo$$android_telecom_Phone_Listener$onCallAdded(android.telecom.Phone android.telecom.Call ), 0, this, phone, call);
        }

        public void onCallRemoved(Phone phone, Call call) {
            InvokeDynamicSupport.bootstrap("onCallRemoved", $$robo$$android_telecom_Phone_Listener$onCallRemoved(android.telecom.Phone android.telecom.Call ), 0, this, phone, call);
        }

        public void onCanAddCallChanged(Phone phone, boolean bl) {
            InvokeDynamicSupport.bootstrap("onCanAddCallChanged", $$robo$$android_telecom_Phone_Listener$onCanAddCallChanged(android.telecom.Phone boolean ), 0, this, phone, bl);
        }

        public void onSilenceRinger(Phone phone) {
            InvokeDynamicSupport.bootstrap("onSilenceRinger", $$robo$$android_telecom_Phone_Listener$onSilenceRinger(android.telecom.Phone ), 0, this, phone);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Listener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

