/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.net.Uri;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.telecom.AudioState;
import android.telecom.CallAudioState;
import android.telecom.Connection;
import android.telecom.ConnectionRequest;
import android.telecom.DisconnectCause;
import android.telecom.Log;
import android.telecom.ParcelableConnection;
import android.telecom.RemoteConference;
import android.telecom.StatusHints;
import android.telecom.VideoCallbackServant;
import android.telecom.VideoProfile;
import android.view.Surface;
import com.android.internal.telecom.IConnectionService;
import com.android.internal.telecom.IVideoCallback;
import com.android.internal.telecom.IVideoProvider;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class RemoteConnection
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private IConnectionService mConnectionService;
    private String mConnectionId;
    private Set<CallbackRecord> mCallbackRecords;
    private List<RemoteConnection> mConferenceableConnections;
    private List<RemoteConnection> mUnmodifiableconferenceableConnections;
    private int mState;
    private DisconnectCause mDisconnectCause;
    private boolean mRingbackRequested;
    private boolean mConnected;
    private int mConnectionCapabilities;
    private int mConnectionProperties;
    private int mVideoState;
    private VideoProvider mVideoProvider;
    private boolean mIsVoipAudioMode;
    private StatusHints mStatusHints;
    private Uri mAddress;
    private int mAddressPresentation;
    private String mCallerDisplayName;
    private int mCallerDisplayNamePresentation;
    private RemoteConference mConference;
    private Bundle mExtras;

    private void $$robo$$android_telecom_RemoteConnection$__constructor__(String id2, IConnectionService connectionService, ConnectionRequest request) {
        this.mCallbackRecords = Collections.newSetFromMap(new ConcurrentHashMap(8, 0.9f, 1));
        this.mConferenceableConnections = new ArrayList<RemoteConnection>();
        this.mUnmodifiableconferenceableConnections = Collections.unmodifiableList(this.mConferenceableConnections);
        this.mState = 1;
        this.mConnectionId = id2;
        this.mConnectionService = connectionService;
        this.mConnected = true;
        this.mState = 0;
    }

    private void $$robo$$android_telecom_RemoteConnection$__constructor__(String callId, IConnectionService connectionService, ParcelableConnection connection, String callingPackage, int targetSdkVersion) {
        this.mCallbackRecords = Collections.newSetFromMap(new ConcurrentHashMap(8, 0.9f, 1));
        this.mConferenceableConnections = new ArrayList<RemoteConnection>();
        this.mUnmodifiableconferenceableConnections = Collections.unmodifiableList(this.mConferenceableConnections);
        this.mState = 1;
        this.mConnectionId = callId;
        this.mConnectionService = connectionService;
        this.mConnected = true;
        this.mState = connection.getState();
        this.mDisconnectCause = connection.getDisconnectCause();
        this.mRingbackRequested = connection.isRingbackRequested();
        this.mConnectionCapabilities = connection.getConnectionCapabilities();
        this.mConnectionProperties = connection.getConnectionProperties();
        this.mVideoState = connection.getVideoState();
        IVideoProvider videoProvider = connection.getVideoProvider();
        this.mVideoProvider = videoProvider != null ? new VideoProvider(videoProvider, callingPackage, targetSdkVersion) : null;
        this.mIsVoipAudioMode = connection.getIsVoipAudioMode();
        this.mStatusHints = connection.getStatusHints();
        this.mAddress = connection.getHandle();
        this.mAddressPresentation = connection.getHandlePresentation();
        this.mCallerDisplayName = connection.getCallerDisplayName();
        this.mCallerDisplayNamePresentation = connection.getCallerDisplayNamePresentation();
        this.mConference = null;
        this.putExtras(connection.getExtras());
        Bundle newExtras = new Bundle();
        newExtras.putString("android.telecom.extra.ORIGINAL_CONNECTION_ID", callId);
        this.putExtras(newExtras);
    }

    private void $$robo$$android_telecom_RemoteConnection$__constructor__(DisconnectCause disconnectCause) {
        this.mCallbackRecords = Collections.newSetFromMap(new ConcurrentHashMap(8, 0.9f, 1));
        this.mConferenceableConnections = new ArrayList<RemoteConnection>();
        this.mUnmodifiableconferenceableConnections = Collections.unmodifiableList(this.mConferenceableConnections);
        this.mState = 1;
        this.mConnectionId = "NULL";
        this.mConnected = false;
        this.mState = 6;
        this.mDisconnectCause = disconnectCause;
    }

    private final void $$robo$$android_telecom_RemoteConnection$registerCallback(Callback callback) {
        this.registerCallback(callback, new Handler());
    }

    private final void $$robo$$android_telecom_RemoteConnection$registerCallback(Callback callback, Handler handler) {
        this.unregisterCallback(callback);
        if (callback != null && handler != null) {
            this.mCallbackRecords.add(new CallbackRecord(callback, handler));
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$unregisterCallback(Callback callback) {
        if (callback != null) {
            for (CallbackRecord record : this.mCallbackRecords) {
                if (record.getCallback() != callback) continue;
                this.mCallbackRecords.remove(record);
                break;
            }
        }
    }

    private final int $$robo$$android_telecom_RemoteConnection$getState() {
        return this.mState;
    }

    private final DisconnectCause $$robo$$android_telecom_RemoteConnection$getDisconnectCause() {
        return this.mDisconnectCause;
    }

    private final int $$robo$$android_telecom_RemoteConnection$getConnectionCapabilities() {
        return this.mConnectionCapabilities;
    }

    private final int $$robo$$android_telecom_RemoteConnection$getConnectionProperties() {
        return this.mConnectionProperties;
    }

    private final boolean $$robo$$android_telecom_RemoteConnection$isVoipAudioMode() {
        return this.mIsVoipAudioMode;
    }

    private final StatusHints $$robo$$android_telecom_RemoteConnection$getStatusHints() {
        return this.mStatusHints;
    }

    private final Uri $$robo$$android_telecom_RemoteConnection$getAddress() {
        return this.mAddress;
    }

    private final int $$robo$$android_telecom_RemoteConnection$getAddressPresentation() {
        return this.mAddressPresentation;
    }

    private final CharSequence $$robo$$android_telecom_RemoteConnection$getCallerDisplayName() {
        return this.mCallerDisplayName;
    }

    private final int $$robo$$android_telecom_RemoteConnection$getCallerDisplayNamePresentation() {
        return this.mCallerDisplayNamePresentation;
    }

    private final int $$robo$$android_telecom_RemoteConnection$getVideoState() {
        return this.mVideoState;
    }

    private final VideoProvider $$robo$$android_telecom_RemoteConnection$getVideoProvider() {
        return this.mVideoProvider;
    }

    private final Bundle $$robo$$android_telecom_RemoteConnection$getExtras() {
        return this.mExtras;
    }

    private final boolean $$robo$$android_telecom_RemoteConnection$isRingbackRequested() {
        return this.mRingbackRequested;
    }

    private final void $$robo$$android_telecom_RemoteConnection$abort() {
        try {
            if (this.mConnected) {
                this.mConnectionService.abort(this.mConnectionId, null);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$answer() {
        try {
            if (this.mConnected) {
                this.mConnectionService.answer(this.mConnectionId, null);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$answer(int videoState) {
        try {
            if (this.mConnected) {
                this.mConnectionService.answerVideo(this.mConnectionId, videoState, null);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$reject() {
        try {
            if (this.mConnected) {
                this.mConnectionService.reject(this.mConnectionId, null);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$hold() {
        try {
            if (this.mConnected) {
                this.mConnectionService.hold(this.mConnectionId, null);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$unhold() {
        try {
            if (this.mConnected) {
                this.mConnectionService.unhold(this.mConnectionId, null);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$disconnect() {
        try {
            if (this.mConnected) {
                this.mConnectionService.disconnect(this.mConnectionId, null);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$playDtmfTone(char digit) {
        try {
            if (this.mConnected) {
                this.mConnectionService.playDtmfTone(this.mConnectionId, digit, null);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$stopDtmfTone() {
        try {
            if (this.mConnected) {
                this.mConnectionService.stopDtmfTone(this.mConnectionId, null);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$postDialContinue(boolean proceed) {
        try {
            if (this.mConnected) {
                this.mConnectionService.onPostDialContinue(this.mConnectionId, proceed, null);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$pullExternalCall() {
        try {
            if (this.mConnected) {
                this.mConnectionService.pullExternalCall(this.mConnectionId, null);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Deprecated
    private final void $$robo$$android_telecom_RemoteConnection$setAudioState(AudioState state) {
        this.setCallAudioState(new CallAudioState(state));
    }

    private final void $$robo$$android_telecom_RemoteConnection$setCallAudioState(CallAudioState state) {
        try {
            if (this.mConnected) {
                this.mConnectionService.onCallAudioStateChanged(this.mConnectionId, state, null);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$startRtt(Connection.RttTextStream rttTextStream) {
        try {
            if (this.mConnected) {
                this.mConnectionService.startRtt(this.mConnectionId, rttTextStream.getFdFromInCall(), rttTextStream.getFdToInCall(), null);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$stopRtt() {
        try {
            if (this.mConnected) {
                this.mConnectionService.stopRtt(this.mConnectionId, null);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$sendRttUpgradeResponse(Connection.RttTextStream rttTextStream) {
        try {
            if (this.mConnected) {
                if (rttTextStream == null) {
                    this.mConnectionService.respondToRttUpgradeRequest(this.mConnectionId, null, null, null);
                } else {
                    this.mConnectionService.respondToRttUpgradeRequest(this.mConnectionId, rttTextStream.getFdFromInCall(), rttTextStream.getFdToInCall(), null);
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final List<RemoteConnection> $$robo$$android_telecom_RemoteConnection$getConferenceableConnections() {
        return this.mUnmodifiableconferenceableConnections;
    }

    private final RemoteConference $$robo$$android_telecom_RemoteConnection$getConference() {
        return this.mConference;
    }

    private final String $$robo$$android_telecom_RemoteConnection$getId() {
        return this.mConnectionId;
    }

    private final IConnectionService $$robo$$android_telecom_RemoteConnection$getConnectionService() {
        return this.mConnectionService;
    }

    private final void $$robo$$android_telecom_RemoteConnection$setState(int state) {
        if (this.mState != state) {
            this.mState = state;
            for (CallbackRecord record : this.mCallbackRecords) {
                RemoteConnection connection = this;
                Callback callback = record.getCallback();
                record.getHandler().post(new Runnable(this, callback, connection, state){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ Callback val$callback;
                    /* synthetic */ RemoteConnection val$connection;
                    /* synthetic */ int val$state;
                    /* synthetic */ RemoteConnection this$0;

                    private void $$robo$$android_telecom_RemoteConnection_1$__constructor__(RemoteConnection this$0, Callback callback, RemoteConnection remoteConnection, int n) {
                    }

                    private final void $$robo$$android_telecom_RemoteConnection_1$run() {
                        this.val$callback.onStateChanged(this.val$connection, this.val$state);
                    }

                    private void __constructor__(RemoteConnection remoteConnection, Callback callback, RemoteConnection remoteConnection2, int n) {
                        this.$$robo$$android_telecom_RemoteConnection_1$__constructor__(remoteConnection, callback, remoteConnection2, n);
                    }
                    {
                        this.this$0 = remoteConnection;
                        this.val$callback = callback;
                        this.val$connection = remoteConnection2;
                        this.val$state = n;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection_1$__constructor__(android.telecom.RemoteConnection android.telecom.RemoteConnection$Callback android.telecom.RemoteConnection int ), 0, this, remoteConnection, callback, remoteConnection2, n);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_RemoteConnection_1$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setDisconnected(DisconnectCause disconnectCause) {
        if (this.mState != 6) {
            this.mState = 6;
            this.mDisconnectCause = disconnectCause;
            for (CallbackRecord record : this.mCallbackRecords) {
                RemoteConnection connection = this;
                Callback callback = record.getCallback();
                record.getHandler().post(new Runnable(this, callback, connection, disconnectCause){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ Callback val$callback;
                    /* synthetic */ RemoteConnection val$connection;
                    /* synthetic */ DisconnectCause val$disconnectCause;
                    /* synthetic */ RemoteConnection this$0;

                    private void $$robo$$android_telecom_RemoteConnection_2$__constructor__(RemoteConnection this$0, Callback callback, RemoteConnection remoteConnection, DisconnectCause disconnectCause) {
                    }

                    private final void $$robo$$android_telecom_RemoteConnection_2$run() {
                        this.val$callback.onDisconnected(this.val$connection, this.val$disconnectCause);
                    }

                    private void __constructor__(RemoteConnection remoteConnection, Callback callback, RemoteConnection remoteConnection2, DisconnectCause disconnectCause) {
                        this.$$robo$$android_telecom_RemoteConnection_2$__constructor__(remoteConnection, callback, remoteConnection2, disconnectCause);
                    }
                    {
                        this.this$0 = remoteConnection;
                        this.val$callback = callback;
                        this.val$connection = remoteConnection2;
                        this.val$disconnectCause = disconnectCause;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection_2$__constructor__(android.telecom.RemoteConnection android.telecom.RemoteConnection$Callback android.telecom.RemoteConnection android.telecom.DisconnectCause ), 0, this, remoteConnection, callback, remoteConnection2, disconnectCause);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_RemoteConnection_2$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setRingbackRequested(boolean ringback) {
        if (this.mRingbackRequested != ringback) {
            this.mRingbackRequested = ringback;
            for (CallbackRecord record : this.mCallbackRecords) {
                RemoteConnection connection = this;
                Callback callback = record.getCallback();
                record.getHandler().post(new Runnable(this, callback, connection, ringback){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ Callback val$callback;
                    /* synthetic */ RemoteConnection val$connection;
                    /* synthetic */ boolean val$ringback;
                    /* synthetic */ RemoteConnection this$0;

                    private void $$robo$$android_telecom_RemoteConnection_3$__constructor__(RemoteConnection this$0, Callback callback, RemoteConnection remoteConnection, boolean bl) {
                    }

                    private final void $$robo$$android_telecom_RemoteConnection_3$run() {
                        this.val$callback.onRingbackRequested(this.val$connection, this.val$ringback);
                    }

                    private void __constructor__(RemoteConnection remoteConnection, Callback callback, RemoteConnection remoteConnection2, boolean bl) {
                        this.$$robo$$android_telecom_RemoteConnection_3$__constructor__(remoteConnection, callback, remoteConnection2, bl);
                    }
                    {
                        this.this$0 = remoteConnection;
                        this.val$callback = callback;
                        this.val$connection = remoteConnection2;
                        this.val$ringback = bl;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection_3$__constructor__(android.telecom.RemoteConnection android.telecom.RemoteConnection$Callback android.telecom.RemoteConnection boolean ), 0, this, remoteConnection, callback, remoteConnection2, bl);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_RemoteConnection_3$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setConnectionCapabilities(int connectionCapabilities) {
        this.mConnectionCapabilities = connectionCapabilities;
        for (CallbackRecord record : this.mCallbackRecords) {
            RemoteConnection connection = this;
            Callback callback = record.getCallback();
            record.getHandler().post(new Runnable(this, callback, connection, connectionCapabilities){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Callback val$callback;
                /* synthetic */ RemoteConnection val$connection;
                /* synthetic */ int val$connectionCapabilities;
                /* synthetic */ RemoteConnection this$0;

                private void $$robo$$android_telecom_RemoteConnection_4$__constructor__(RemoteConnection this$0, Callback callback, RemoteConnection remoteConnection, int n) {
                }

                private final void $$robo$$android_telecom_RemoteConnection_4$run() {
                    this.val$callback.onConnectionCapabilitiesChanged(this.val$connection, this.val$connectionCapabilities);
                }

                private void __constructor__(RemoteConnection remoteConnection, Callback callback, RemoteConnection remoteConnection2, int n) {
                    this.$$robo$$android_telecom_RemoteConnection_4$__constructor__(remoteConnection, callback, remoteConnection2, n);
                }
                {
                    this.this$0 = remoteConnection;
                    this.val$callback = callback;
                    this.val$connection = remoteConnection2;
                    this.val$connectionCapabilities = n;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection_4$__constructor__(android.telecom.RemoteConnection android.telecom.RemoteConnection$Callback android.telecom.RemoteConnection int ), 0, this, remoteConnection, callback, remoteConnection2, n);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_RemoteConnection_4$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setConnectionProperties(int connectionProperties) {
        this.mConnectionProperties = connectionProperties;
        for (CallbackRecord record : this.mCallbackRecords) {
            RemoteConnection connection = this;
            Callback callback = record.getCallback();
            record.getHandler().post(new Runnable(this, callback, connection, connectionProperties){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Callback val$callback;
                /* synthetic */ RemoteConnection val$connection;
                /* synthetic */ int val$connectionProperties;
                /* synthetic */ RemoteConnection this$0;

                private void $$robo$$android_telecom_RemoteConnection_5$__constructor__(RemoteConnection this$0, Callback callback, RemoteConnection remoteConnection, int n) {
                }

                private final void $$robo$$android_telecom_RemoteConnection_5$run() {
                    this.val$callback.onConnectionPropertiesChanged(this.val$connection, this.val$connectionProperties);
                }

                private void __constructor__(RemoteConnection remoteConnection, Callback callback, RemoteConnection remoteConnection2, int n) {
                    this.$$robo$$android_telecom_RemoteConnection_5$__constructor__(remoteConnection, callback, remoteConnection2, n);
                }
                {
                    this.this$0 = remoteConnection;
                    this.val$callback = callback;
                    this.val$connection = remoteConnection2;
                    this.val$connectionProperties = n;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection_5$__constructor__(android.telecom.RemoteConnection android.telecom.RemoteConnection$Callback android.telecom.RemoteConnection int ), 0, this, remoteConnection, callback, remoteConnection2, n);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_RemoteConnection_5$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setDestroyed() {
        if (!this.mCallbackRecords.isEmpty()) {
            if (this.mState != 6) {
                this.setDisconnected(new DisconnectCause(1, "Connection destroyed."));
            }
            for (CallbackRecord record : this.mCallbackRecords) {
                RemoteConnection connection = this;
                Callback callback = record.getCallback();
                record.getHandler().post(new Runnable(this, callback, connection){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ Callback val$callback;
                    /* synthetic */ RemoteConnection val$connection;
                    /* synthetic */ RemoteConnection this$0;

                    private void $$robo$$android_telecom_RemoteConnection_6$__constructor__(RemoteConnection this$0, Callback callback, RemoteConnection remoteConnection) {
                    }

                    private final void $$robo$$android_telecom_RemoteConnection_6$run() {
                        this.val$callback.onDestroyed(this.val$connection);
                    }

                    private void __constructor__(RemoteConnection remoteConnection, Callback callback, RemoteConnection remoteConnection2) {
                        this.$$robo$$android_telecom_RemoteConnection_6$__constructor__(remoteConnection, callback, remoteConnection2);
                    }
                    {
                        this.this$0 = remoteConnection;
                        this.val$callback = callback;
                        this.val$connection = remoteConnection2;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection_6$__constructor__(android.telecom.RemoteConnection android.telecom.RemoteConnection$Callback android.telecom.RemoteConnection ), 0, this, remoteConnection, callback, remoteConnection2);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_RemoteConnection_6$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
            this.mCallbackRecords.clear();
            this.mConnected = false;
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setPostDialWait(String remainingDigits) {
        for (CallbackRecord record : this.mCallbackRecords) {
            RemoteConnection connection = this;
            Callback callback = record.getCallback();
            record.getHandler().post(new Runnable(this, callback, connection, remainingDigits){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Callback val$callback;
                /* synthetic */ RemoteConnection val$connection;
                /* synthetic */ String val$remainingDigits;
                /* synthetic */ RemoteConnection this$0;

                private void $$robo$$android_telecom_RemoteConnection_7$__constructor__(RemoteConnection this$0, Callback callback, RemoteConnection remoteConnection, String string2) {
                }

                private final void $$robo$$android_telecom_RemoteConnection_7$run() {
                    this.val$callback.onPostDialWait(this.val$connection, this.val$remainingDigits);
                }

                private void __constructor__(RemoteConnection remoteConnection, Callback callback, RemoteConnection remoteConnection2, String string2) {
                    this.$$robo$$android_telecom_RemoteConnection_7$__constructor__(remoteConnection, callback, remoteConnection2, string2);
                }
                {
                    this.this$0 = remoteConnection;
                    this.val$callback = callback;
                    this.val$connection = remoteConnection2;
                    this.val$remainingDigits = string2;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection_7$__constructor__(android.telecom.RemoteConnection android.telecom.RemoteConnection$Callback android.telecom.RemoteConnection java.lang.String ), 0, this, remoteConnection, callback, remoteConnection2, string2);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_RemoteConnection_7$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$onPostDialChar(char nextChar) {
        for (CallbackRecord record : this.mCallbackRecords) {
            RemoteConnection connection = this;
            Callback callback = record.getCallback();
            record.getHandler().post(new Runnable(this, callback, connection, nextChar){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Callback val$callback;
                /* synthetic */ RemoteConnection val$connection;
                /* synthetic */ char val$nextChar;
                /* synthetic */ RemoteConnection this$0;

                private void $$robo$$android_telecom_RemoteConnection_8$__constructor__(RemoteConnection this$0, Callback callback, RemoteConnection remoteConnection, char c) {
                }

                private final void $$robo$$android_telecom_RemoteConnection_8$run() {
                    this.val$callback.onPostDialChar(this.val$connection, this.val$nextChar);
                }

                private void __constructor__(RemoteConnection remoteConnection, Callback callback, RemoteConnection remoteConnection2, char c) {
                    this.$$robo$$android_telecom_RemoteConnection_8$__constructor__(remoteConnection, callback, remoteConnection2, c);
                }
                {
                    this.this$0 = remoteConnection;
                    this.val$callback = callback;
                    this.val$connection = remoteConnection2;
                    this.val$nextChar = c;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection_8$__constructor__(android.telecom.RemoteConnection android.telecom.RemoteConnection$Callback android.telecom.RemoteConnection char ), 0, this, remoteConnection, callback, remoteConnection2, c);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_RemoteConnection_8$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setVideoState(int videoState) {
        this.mVideoState = videoState;
        for (CallbackRecord record : this.mCallbackRecords) {
            RemoteConnection connection = this;
            Callback callback = record.getCallback();
            record.getHandler().post(new Runnable(this, callback, connection, videoState){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Callback val$callback;
                /* synthetic */ RemoteConnection val$connection;
                /* synthetic */ int val$videoState;
                /* synthetic */ RemoteConnection this$0;

                private void $$robo$$android_telecom_RemoteConnection_9$__constructor__(RemoteConnection this$0, Callback callback, RemoteConnection remoteConnection, int n) {
                }

                private final void $$robo$$android_telecom_RemoteConnection_9$run() {
                    this.val$callback.onVideoStateChanged(this.val$connection, this.val$videoState);
                }

                private void __constructor__(RemoteConnection remoteConnection, Callback callback, RemoteConnection remoteConnection2, int n) {
                    this.$$robo$$android_telecom_RemoteConnection_9$__constructor__(remoteConnection, callback, remoteConnection2, n);
                }
                {
                    this.this$0 = remoteConnection;
                    this.val$callback = callback;
                    this.val$connection = remoteConnection2;
                    this.val$videoState = n;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection_9$__constructor__(android.telecom.RemoteConnection android.telecom.RemoteConnection$Callback android.telecom.RemoteConnection int ), 0, this, remoteConnection, callback, remoteConnection2, n);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_RemoteConnection_9$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setVideoProvider(VideoProvider videoProvider) {
        this.mVideoProvider = videoProvider;
        for (CallbackRecord record : this.mCallbackRecords) {
            RemoteConnection connection = this;
            Callback callback = record.getCallback();
            record.getHandler().post(new Runnable(this, callback, connection, videoProvider){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Callback val$callback;
                /* synthetic */ RemoteConnection val$connection;
                /* synthetic */ VideoProvider val$videoProvider;
                /* synthetic */ RemoteConnection this$0;

                private void $$robo$$android_telecom_RemoteConnection_10$__constructor__(RemoteConnection this$0, Callback callback, RemoteConnection remoteConnection, VideoProvider videoProvider) {
                }

                private final void $$robo$$android_telecom_RemoteConnection_10$run() {
                    this.val$callback.onVideoProviderChanged(this.val$connection, this.val$videoProvider);
                }

                private void __constructor__(RemoteConnection remoteConnection, Callback callback, RemoteConnection remoteConnection2, VideoProvider videoProvider) {
                    this.$$robo$$android_telecom_RemoteConnection_10$__constructor__(remoteConnection, callback, remoteConnection2, videoProvider);
                }
                {
                    this.this$0 = remoteConnection;
                    this.val$callback = callback;
                    this.val$connection = remoteConnection2;
                    this.val$videoProvider = videoProvider;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection_10$__constructor__(android.telecom.RemoteConnection android.telecom.RemoteConnection$Callback android.telecom.RemoteConnection android.telecom.RemoteConnection$VideoProvider ), 0, this, remoteConnection, callback, remoteConnection2, videoProvider);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_RemoteConnection_10$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setIsVoipAudioMode(boolean isVoip) {
        this.mIsVoipAudioMode = isVoip;
        for (CallbackRecord record : this.mCallbackRecords) {
            RemoteConnection connection = this;
            Callback callback = record.getCallback();
            record.getHandler().post(new Runnable(this, callback, connection, isVoip){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Callback val$callback;
                /* synthetic */ RemoteConnection val$connection;
                /* synthetic */ boolean val$isVoip;
                /* synthetic */ RemoteConnection this$0;

                private void $$robo$$android_telecom_RemoteConnection_11$__constructor__(RemoteConnection this$0, Callback callback, RemoteConnection remoteConnection, boolean bl) {
                }

                private final void $$robo$$android_telecom_RemoteConnection_11$run() {
                    this.val$callback.onVoipAudioChanged(this.val$connection, this.val$isVoip);
                }

                private void __constructor__(RemoteConnection remoteConnection, Callback callback, RemoteConnection remoteConnection2, boolean bl) {
                    this.$$robo$$android_telecom_RemoteConnection_11$__constructor__(remoteConnection, callback, remoteConnection2, bl);
                }
                {
                    this.this$0 = remoteConnection;
                    this.val$callback = callback;
                    this.val$connection = remoteConnection2;
                    this.val$isVoip = bl;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection_11$__constructor__(android.telecom.RemoteConnection android.telecom.RemoteConnection$Callback android.telecom.RemoteConnection boolean ), 0, this, remoteConnection, callback, remoteConnection2, bl);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_RemoteConnection_11$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setStatusHints(StatusHints statusHints) {
        this.mStatusHints = statusHints;
        for (CallbackRecord record : this.mCallbackRecords) {
            RemoteConnection connection = this;
            Callback callback = record.getCallback();
            record.getHandler().post(new Runnable(this, callback, connection, statusHints){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Callback val$callback;
                /* synthetic */ RemoteConnection val$connection;
                /* synthetic */ StatusHints val$statusHints;
                /* synthetic */ RemoteConnection this$0;

                private void $$robo$$android_telecom_RemoteConnection_12$__constructor__(RemoteConnection this$0, Callback callback, RemoteConnection remoteConnection, StatusHints statusHints) {
                }

                private final void $$robo$$android_telecom_RemoteConnection_12$run() {
                    this.val$callback.onStatusHintsChanged(this.val$connection, this.val$statusHints);
                }

                private void __constructor__(RemoteConnection remoteConnection, Callback callback, RemoteConnection remoteConnection2, StatusHints statusHints) {
                    this.$$robo$$android_telecom_RemoteConnection_12$__constructor__(remoteConnection, callback, remoteConnection2, statusHints);
                }
                {
                    this.this$0 = remoteConnection;
                    this.val$callback = callback;
                    this.val$connection = remoteConnection2;
                    this.val$statusHints = statusHints;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection_12$__constructor__(android.telecom.RemoteConnection android.telecom.RemoteConnection$Callback android.telecom.RemoteConnection android.telecom.StatusHints ), 0, this, remoteConnection, callback, remoteConnection2, statusHints);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_RemoteConnection_12$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setAddress(Uri address, int presentation) {
        this.mAddress = address;
        this.mAddressPresentation = presentation;
        for (CallbackRecord record : this.mCallbackRecords) {
            RemoteConnection connection = this;
            Callback callback = record.getCallback();
            record.getHandler().post(new Runnable(this, callback, connection, address, presentation){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Callback val$callback;
                /* synthetic */ RemoteConnection val$connection;
                /* synthetic */ Uri val$address;
                /* synthetic */ int val$presentation;
                /* synthetic */ RemoteConnection this$0;

                private void $$robo$$android_telecom_RemoteConnection_13$__constructor__(RemoteConnection this$0, Callback callback, RemoteConnection remoteConnection, Uri uri, int n) {
                }

                private final void $$robo$$android_telecom_RemoteConnection_13$run() {
                    this.val$callback.onAddressChanged(this.val$connection, this.val$address, this.val$presentation);
                }

                private void __constructor__(RemoteConnection remoteConnection, Callback callback, RemoteConnection remoteConnection2, Uri uri, int n) {
                    this.$$robo$$android_telecom_RemoteConnection_13$__constructor__(remoteConnection, callback, remoteConnection2, uri, n);
                }
                {
                    this.this$0 = remoteConnection;
                    this.val$callback = callback;
                    this.val$connection = remoteConnection2;
                    this.val$address = uri;
                    this.val$presentation = n;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection_13$__constructor__(android.telecom.RemoteConnection android.telecom.RemoteConnection$Callback android.telecom.RemoteConnection android.net.Uri int ), 0, this, remoteConnection, callback, remoteConnection2, uri, n);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_RemoteConnection_13$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setCallerDisplayName(String callerDisplayName, int presentation) {
        this.mCallerDisplayName = callerDisplayName;
        this.mCallerDisplayNamePresentation = presentation;
        for (CallbackRecord record : this.mCallbackRecords) {
            RemoteConnection connection = this;
            Callback callback = record.getCallback();
            record.getHandler().post(new Runnable(this, callback, connection, callerDisplayName, presentation){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Callback val$callback;
                /* synthetic */ RemoteConnection val$connection;
                /* synthetic */ String val$callerDisplayName;
                /* synthetic */ int val$presentation;
                /* synthetic */ RemoteConnection this$0;

                private void $$robo$$android_telecom_RemoteConnection_14$__constructor__(RemoteConnection this$0, Callback callback, RemoteConnection remoteConnection, String string2, int n) {
                }

                private final void $$robo$$android_telecom_RemoteConnection_14$run() {
                    this.val$callback.onCallerDisplayNameChanged(this.val$connection, this.val$callerDisplayName, this.val$presentation);
                }

                private void __constructor__(RemoteConnection remoteConnection, Callback callback, RemoteConnection remoteConnection2, String string2, int n) {
                    this.$$robo$$android_telecom_RemoteConnection_14$__constructor__(remoteConnection, callback, remoteConnection2, string2, n);
                }
                {
                    this.this$0 = remoteConnection;
                    this.val$callback = callback;
                    this.val$connection = remoteConnection2;
                    this.val$callerDisplayName = string2;
                    this.val$presentation = n;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection_14$__constructor__(android.telecom.RemoteConnection android.telecom.RemoteConnection$Callback android.telecom.RemoteConnection java.lang.String int ), 0, this, remoteConnection, callback, remoteConnection2, string2, n);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_RemoteConnection_14$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setConferenceableConnections(List<RemoteConnection> conferenceableConnections) {
        this.mConferenceableConnections.clear();
        this.mConferenceableConnections.addAll(conferenceableConnections);
        for (CallbackRecord record : this.mCallbackRecords) {
            RemoteConnection connection = this;
            Callback callback = record.getCallback();
            record.getHandler().post(new Runnable(this, callback, connection){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Callback val$callback;
                /* synthetic */ RemoteConnection val$connection;
                /* synthetic */ RemoteConnection this$0;

                private void $$robo$$android_telecom_RemoteConnection_15$__constructor__(RemoteConnection this$0, Callback callback, RemoteConnection remoteConnection) {
                }

                private final void $$robo$$android_telecom_RemoteConnection_15$run() {
                    this.val$callback.onConferenceableConnectionsChanged(this.val$connection, this.this$0.mUnmodifiableconferenceableConnections);
                }

                private void __constructor__(RemoteConnection remoteConnection, Callback callback, RemoteConnection remoteConnection2) {
                    this.$$robo$$android_telecom_RemoteConnection_15$__constructor__(remoteConnection, callback, remoteConnection2);
                }
                {
                    this.this$0 = remoteConnection;
                    this.val$callback = callback;
                    this.val$connection = remoteConnection2;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection_15$__constructor__(android.telecom.RemoteConnection android.telecom.RemoteConnection$Callback android.telecom.RemoteConnection ), 0, this, remoteConnection, callback, remoteConnection2);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_RemoteConnection_15$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setConference(RemoteConference conference) {
        if (this.mConference != conference) {
            this.mConference = conference;
            for (CallbackRecord record : this.mCallbackRecords) {
                RemoteConnection connection = this;
                Callback callback = record.getCallback();
                record.getHandler().post(new Runnable(this, callback, connection, conference){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ Callback val$callback;
                    /* synthetic */ RemoteConnection val$connection;
                    /* synthetic */ RemoteConference val$conference;
                    /* synthetic */ RemoteConnection this$0;

                    private void $$robo$$android_telecom_RemoteConnection_16$__constructor__(RemoteConnection this$0, Callback callback, RemoteConnection remoteConnection, RemoteConference remoteConference) {
                    }

                    private final void $$robo$$android_telecom_RemoteConnection_16$run() {
                        this.val$callback.onConferenceChanged(this.val$connection, this.val$conference);
                    }

                    private void __constructor__(RemoteConnection remoteConnection, Callback callback, RemoteConnection remoteConnection2, RemoteConference remoteConference) {
                        this.$$robo$$android_telecom_RemoteConnection_16$__constructor__(remoteConnection, callback, remoteConnection2, remoteConference);
                    }
                    {
                        this.this$0 = remoteConnection;
                        this.val$callback = callback;
                        this.val$connection = remoteConnection2;
                        this.val$conference = remoteConference;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection_16$__constructor__(android.telecom.RemoteConnection android.telecom.RemoteConnection$Callback android.telecom.RemoteConnection android.telecom.RemoteConference ), 0, this, remoteConnection, callback, remoteConnection2, remoteConference);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_RemoteConnection_16$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$putExtras(Bundle extras) {
        if (extras == null) {
            return;
        }
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        try {
            this.mExtras.putAll(extras);
        }
        catch (BadParcelableException bpe) {
            Log.w(this, "putExtras: could not unmarshal extras; exception = " + bpe, new Object[0]);
        }
        this.notifyExtrasChanged();
    }

    private final void $$robo$$android_telecom_RemoteConnection$removeExtras(List<String> keys) {
        if (this.mExtras == null || keys == null || keys.isEmpty()) {
            return;
        }
        for (String key : keys) {
            this.mExtras.remove(key);
        }
        this.notifyExtrasChanged();
    }

    private final void $$robo$$android_telecom_RemoteConnection$notifyExtrasChanged() {
        for (CallbackRecord record : this.mCallbackRecords) {
            RemoteConnection connection = this;
            Callback callback = record.getCallback();
            record.getHandler().post(new Runnable(this, callback, connection){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Callback val$callback;
                /* synthetic */ RemoteConnection val$connection;
                /* synthetic */ RemoteConnection this$0;

                private void $$robo$$android_telecom_RemoteConnection_17$__constructor__(RemoteConnection this$0, Callback callback, RemoteConnection remoteConnection) {
                }

                private final void $$robo$$android_telecom_RemoteConnection_17$run() {
                    this.val$callback.onExtrasChanged(this.val$connection, this.this$0.mExtras);
                }

                private void __constructor__(RemoteConnection remoteConnection, Callback callback, RemoteConnection remoteConnection2) {
                    this.$$robo$$android_telecom_RemoteConnection_17$__constructor__(remoteConnection, callback, remoteConnection2);
                }
                {
                    this.this$0 = remoteConnection;
                    this.val$callback = callback;
                    this.val$connection = remoteConnection2;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection_17$__constructor__(android.telecom.RemoteConnection android.telecom.RemoteConnection$Callback android.telecom.RemoteConnection ), 0, this, remoteConnection, callback, remoteConnection2);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_RemoteConnection_17$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$onConnectionEvent(String event, Bundle extras) {
        for (CallbackRecord record : this.mCallbackRecords) {
            RemoteConnection connection = this;
            Callback callback = record.getCallback();
            record.getHandler().post(new Runnable(this, callback, connection, event, extras){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Callback val$callback;
                /* synthetic */ RemoteConnection val$connection;
                /* synthetic */ String val$event;
                /* synthetic */ Bundle val$extras;
                /* synthetic */ RemoteConnection this$0;

                private void $$robo$$android_telecom_RemoteConnection_18$__constructor__(RemoteConnection this$0, Callback callback, RemoteConnection remoteConnection, String string2, Bundle bundle) {
                }

                private final void $$robo$$android_telecom_RemoteConnection_18$run() {
                    this.val$callback.onConnectionEvent(this.val$connection, this.val$event, this.val$extras);
                }

                private void __constructor__(RemoteConnection remoteConnection, Callback callback, RemoteConnection remoteConnection2, String string2, Bundle bundle) {
                    this.$$robo$$android_telecom_RemoteConnection_18$__constructor__(remoteConnection, callback, remoteConnection2, string2, bundle);
                }
                {
                    this.this$0 = remoteConnection;
                    this.val$callback = callback;
                    this.val$connection = remoteConnection2;
                    this.val$event = string2;
                    this.val$extras = bundle;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection_18$__constructor__(android.telecom.RemoteConnection android.telecom.RemoteConnection$Callback android.telecom.RemoteConnection java.lang.String android.os.Bundle ), 0, this, remoteConnection, callback, remoteConnection2, string2, bundle);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_RemoteConnection_18$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$onRttInitiationSuccess() {
        for (CallbackRecord record : this.mCallbackRecords) {
            RemoteConnection connection = this;
            Callback callback = record.getCallback();
            record.getHandler().post(() -> callback.onRttInitiationSuccess(connection));
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$onRttInitiationFailure(int reason) {
        for (CallbackRecord record : this.mCallbackRecords) {
            RemoteConnection connection = this;
            Callback callback = record.getCallback();
            record.getHandler().post(() -> callback.onRttInitiationFailure(connection, reason));
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$onRttSessionRemotelyTerminated() {
        for (CallbackRecord record : this.mCallbackRecords) {
            RemoteConnection connection = this;
            Callback callback = record.getCallback();
            record.getHandler().post(() -> callback.onRttSessionRemotelyTerminated(connection));
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$onRemoteRttRequest() {
        for (CallbackRecord record : this.mCallbackRecords) {
            RemoteConnection connection = this;
            Callback callback = record.getCallback();
            record.getHandler().post(() -> callback.onRemoteRttRequest(connection));
        }
    }

    private static final RemoteConnection $$robo$$android_telecom_RemoteConnection$failure(DisconnectCause disconnectCause) {
        return new RemoteConnection(disconnectCause);
    }

    private void __constructor__(String string2, IConnectionService iConnectionService, ConnectionRequest connectionRequest) {
        this.$$robo$$android_telecom_RemoteConnection$__constructor__(string2, iConnectionService, connectionRequest);
    }

    RemoteConnection(String string2, IConnectionService iConnectionService, ConnectionRequest connectionRequest) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection$__constructor__(java.lang.String com.android.internal.telecom.IConnectionService android.telecom.ConnectionRequest ), 0, this, string2, iConnectionService, connectionRequest);
    }

    private void __constructor__(String string2, IConnectionService iConnectionService, ParcelableConnection parcelableConnection, String string3, int n) {
        this.$$robo$$android_telecom_RemoteConnection$__constructor__(string2, iConnectionService, parcelableConnection, string3, n);
    }

    RemoteConnection(String string2, IConnectionService iConnectionService, ParcelableConnection parcelableConnection, String string3, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection$__constructor__(java.lang.String com.android.internal.telecom.IConnectionService android.telecom.ParcelableConnection java.lang.String int ), 0, this, string2, iConnectionService, parcelableConnection, string3, n);
    }

    private void __constructor__(DisconnectCause disconnectCause) {
        this.$$robo$$android_telecom_RemoteConnection$__constructor__(disconnectCause);
    }

    RemoteConnection(DisconnectCause disconnectCause) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection$__constructor__(android.telecom.DisconnectCause ), 0, this, disconnectCause);
    }

    public void registerCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_telecom_RemoteConnection$registerCallback(android.telecom.RemoteConnection$Callback ), 0, this, callback);
    }

    public void registerCallback(Callback callback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_telecom_RemoteConnection$registerCallback(android.telecom.RemoteConnection$Callback android.os.Handler ), 0, this, callback, handler);
    }

    public void unregisterCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("unregisterCallback", $$robo$$android_telecom_RemoteConnection$unregisterCallback(android.telecom.RemoteConnection$Callback ), 0, this, callback);
    }

    public int getState() {
        return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_telecom_RemoteConnection$getState(), 0, this);
    }

    public DisconnectCause getDisconnectCause() {
        return InvokeDynamicSupport.bootstrap("getDisconnectCause", $$robo$$android_telecom_RemoteConnection$getDisconnectCause(), 0, this);
    }

    public int getConnectionCapabilities() {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionCapabilities", $$robo$$android_telecom_RemoteConnection$getConnectionCapabilities(), 0, this);
    }

    public int getConnectionProperties() {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionProperties", $$robo$$android_telecom_RemoteConnection$getConnectionProperties(), 0, this);
    }

    public boolean isVoipAudioMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVoipAudioMode", $$robo$$android_telecom_RemoteConnection$isVoipAudioMode(), 0, this);
    }

    public StatusHints getStatusHints() {
        return InvokeDynamicSupport.bootstrap("getStatusHints", $$robo$$android_telecom_RemoteConnection$getStatusHints(), 0, this);
    }

    public Uri getAddress() {
        return InvokeDynamicSupport.bootstrap("getAddress", $$robo$$android_telecom_RemoteConnection$getAddress(), 0, this);
    }

    public int getAddressPresentation() {
        return (int)InvokeDynamicSupport.bootstrap("getAddressPresentation", $$robo$$android_telecom_RemoteConnection$getAddressPresentation(), 0, this);
    }

    public CharSequence getCallerDisplayName() {
        return InvokeDynamicSupport.bootstrap("getCallerDisplayName", $$robo$$android_telecom_RemoteConnection$getCallerDisplayName(), 0, this);
    }

    public int getCallerDisplayNamePresentation() {
        return (int)InvokeDynamicSupport.bootstrap("getCallerDisplayNamePresentation", $$robo$$android_telecom_RemoteConnection$getCallerDisplayNamePresentation(), 0, this);
    }

    public int getVideoState() {
        return (int)InvokeDynamicSupport.bootstrap("getVideoState", $$robo$$android_telecom_RemoteConnection$getVideoState(), 0, this);
    }

    public VideoProvider getVideoProvider() {
        return InvokeDynamicSupport.bootstrap("getVideoProvider", $$robo$$android_telecom_RemoteConnection$getVideoProvider(), 0, this);
    }

    public Bundle getExtras() {
        return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_telecom_RemoteConnection$getExtras(), 0, this);
    }

    public boolean isRingbackRequested() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRingbackRequested", $$robo$$android_telecom_RemoteConnection$isRingbackRequested(), 0, this);
    }

    public void abort() {
        InvokeDynamicSupport.bootstrap("abort", $$robo$$android_telecom_RemoteConnection$abort(), 0, this);
    }

    public void answer() {
        InvokeDynamicSupport.bootstrap("answer", $$robo$$android_telecom_RemoteConnection$answer(), 0, this);
    }

    public void answer(int n) {
        InvokeDynamicSupport.bootstrap("answer", $$robo$$android_telecom_RemoteConnection$answer(int ), 0, this, n);
    }

    public void reject() {
        InvokeDynamicSupport.bootstrap("reject", $$robo$$android_telecom_RemoteConnection$reject(), 0, this);
    }

    public void hold() {
        InvokeDynamicSupport.bootstrap("hold", $$robo$$android_telecom_RemoteConnection$hold(), 0, this);
    }

    public void unhold() {
        InvokeDynamicSupport.bootstrap("unhold", $$robo$$android_telecom_RemoteConnection$unhold(), 0, this);
    }

    public void disconnect() {
        InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_telecom_RemoteConnection$disconnect(), 0, this);
    }

    public void playDtmfTone(char c) {
        InvokeDynamicSupport.bootstrap("playDtmfTone", $$robo$$android_telecom_RemoteConnection$playDtmfTone(char ), 0, this, c);
    }

    public void stopDtmfTone() {
        InvokeDynamicSupport.bootstrap("stopDtmfTone", $$robo$$android_telecom_RemoteConnection$stopDtmfTone(), 0, this);
    }

    public void postDialContinue(boolean bl) {
        InvokeDynamicSupport.bootstrap("postDialContinue", $$robo$$android_telecom_RemoteConnection$postDialContinue(boolean ), 0, this, bl);
    }

    public void pullExternalCall() {
        InvokeDynamicSupport.bootstrap("pullExternalCall", $$robo$$android_telecom_RemoteConnection$pullExternalCall(), 0, this);
    }

    @Deprecated
    public void setAudioState(AudioState audioState) {
        InvokeDynamicSupport.bootstrap("setAudioState", $$robo$$android_telecom_RemoteConnection$setAudioState(android.telecom.AudioState ), 0, this, audioState);
    }

    public void setCallAudioState(CallAudioState callAudioState) {
        InvokeDynamicSupport.bootstrap("setCallAudioState", $$robo$$android_telecom_RemoteConnection$setCallAudioState(android.telecom.CallAudioState ), 0, this, callAudioState);
    }

    public void startRtt(Connection.RttTextStream rttTextStream) {
        InvokeDynamicSupport.bootstrap("startRtt", $$robo$$android_telecom_RemoteConnection$startRtt(android.telecom.Connection$RttTextStream ), 0, this, rttTextStream);
    }

    public void stopRtt() {
        InvokeDynamicSupport.bootstrap("stopRtt", $$robo$$android_telecom_RemoteConnection$stopRtt(), 0, this);
    }

    public void sendRttUpgradeResponse(Connection.RttTextStream rttTextStream) {
        InvokeDynamicSupport.bootstrap("sendRttUpgradeResponse", $$robo$$android_telecom_RemoteConnection$sendRttUpgradeResponse(android.telecom.Connection$RttTextStream ), 0, this, rttTextStream);
    }

    public List<RemoteConnection> getConferenceableConnections() {
        return InvokeDynamicSupport.bootstrap("getConferenceableConnections", $$robo$$android_telecom_RemoteConnection$getConferenceableConnections(), 0, this);
    }

    public RemoteConference getConference() {
        return InvokeDynamicSupport.bootstrap("getConference", $$robo$$android_telecom_RemoteConnection$getConference(), 0, this);
    }

    String getId() {
        return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_telecom_RemoteConnection$getId(), 0, this);
    }

    IConnectionService getConnectionService() {
        return InvokeDynamicSupport.bootstrap("getConnectionService", $$robo$$android_telecom_RemoteConnection$getConnectionService(), 0, this);
    }

    void setState(int n) {
        InvokeDynamicSupport.bootstrap("setState", $$robo$$android_telecom_RemoteConnection$setState(int ), 0, this, n);
    }

    void setDisconnected(DisconnectCause disconnectCause) {
        InvokeDynamicSupport.bootstrap("setDisconnected", $$robo$$android_telecom_RemoteConnection$setDisconnected(android.telecom.DisconnectCause ), 0, this, disconnectCause);
    }

    void setRingbackRequested(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRingbackRequested", $$robo$$android_telecom_RemoteConnection$setRingbackRequested(boolean ), 0, this, bl);
    }

    void setConnectionCapabilities(int n) {
        InvokeDynamicSupport.bootstrap("setConnectionCapabilities", $$robo$$android_telecom_RemoteConnection$setConnectionCapabilities(int ), 0, this, n);
    }

    void setConnectionProperties(int n) {
        InvokeDynamicSupport.bootstrap("setConnectionProperties", $$robo$$android_telecom_RemoteConnection$setConnectionProperties(int ), 0, this, n);
    }

    void setDestroyed() {
        InvokeDynamicSupport.bootstrap("setDestroyed", $$robo$$android_telecom_RemoteConnection$setDestroyed(), 0, this);
    }

    void setPostDialWait(String string2) {
        InvokeDynamicSupport.bootstrap("setPostDialWait", $$robo$$android_telecom_RemoteConnection$setPostDialWait(java.lang.String ), 0, this, string2);
    }

    void onPostDialChar(char c) {
        InvokeDynamicSupport.bootstrap("onPostDialChar", $$robo$$android_telecom_RemoteConnection$onPostDialChar(char ), 0, this, c);
    }

    void setVideoState(int n) {
        InvokeDynamicSupport.bootstrap("setVideoState", $$robo$$android_telecom_RemoteConnection$setVideoState(int ), 0, this, n);
    }

    void setVideoProvider(VideoProvider videoProvider) {
        InvokeDynamicSupport.bootstrap("setVideoProvider", $$robo$$android_telecom_RemoteConnection$setVideoProvider(android.telecom.RemoteConnection$VideoProvider ), 0, this, videoProvider);
    }

    void setIsVoipAudioMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIsVoipAudioMode", $$robo$$android_telecom_RemoteConnection$setIsVoipAudioMode(boolean ), 0, this, bl);
    }

    void setStatusHints(StatusHints statusHints) {
        InvokeDynamicSupport.bootstrap("setStatusHints", $$robo$$android_telecom_RemoteConnection$setStatusHints(android.telecom.StatusHints ), 0, this, statusHints);
    }

    void setAddress(Uri uri, int n) {
        InvokeDynamicSupport.bootstrap("setAddress", $$robo$$android_telecom_RemoteConnection$setAddress(android.net.Uri int ), 0, this, uri, n);
    }

    void setCallerDisplayName(String string2, int n) {
        InvokeDynamicSupport.bootstrap("setCallerDisplayName", $$robo$$android_telecom_RemoteConnection$setCallerDisplayName(java.lang.String int ), 0, this, string2, n);
    }

    void setConferenceableConnections(List<RemoteConnection> list) {
        InvokeDynamicSupport.bootstrap("setConferenceableConnections", $$robo$$android_telecom_RemoteConnection$setConferenceableConnections(java.util.List<android.telecom.RemoteConnection> ), 0, this, list);
    }

    void setConference(RemoteConference remoteConference) {
        InvokeDynamicSupport.bootstrap("setConference", $$robo$$android_telecom_RemoteConnection$setConference(android.telecom.RemoteConference ), 0, this, remoteConference);
    }

    void putExtras(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("putExtras", $$robo$$android_telecom_RemoteConnection$putExtras(android.os.Bundle ), 0, this, bundle);
    }

    void removeExtras(List<String> list) {
        InvokeDynamicSupport.bootstrap("removeExtras", $$robo$$android_telecom_RemoteConnection$removeExtras(java.util.List<java.lang.String> ), 0, this, list);
    }

    private void notifyExtrasChanged() {
        InvokeDynamicSupport.bootstrap("notifyExtrasChanged", $$robo$$android_telecom_RemoteConnection$notifyExtrasChanged(), 0, this);
    }

    void onConnectionEvent(String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onConnectionEvent", $$robo$$android_telecom_RemoteConnection$onConnectionEvent(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
    }

    void onRttInitiationSuccess() {
        InvokeDynamicSupport.bootstrap("onRttInitiationSuccess", $$robo$$android_telecom_RemoteConnection$onRttInitiationSuccess(), 0, this);
    }

    void onRttInitiationFailure(int n) {
        InvokeDynamicSupport.bootstrap("onRttInitiationFailure", $$robo$$android_telecom_RemoteConnection$onRttInitiationFailure(int ), 0, this, n);
    }

    void onRttSessionRemotelyTerminated() {
        InvokeDynamicSupport.bootstrap("onRttSessionRemotelyTerminated", $$robo$$android_telecom_RemoteConnection$onRttSessionRemotelyTerminated(), 0, this);
    }

    void onRemoteRttRequest() {
        InvokeDynamicSupport.bootstrap("onRemoteRttRequest", $$robo$$android_telecom_RemoteConnection$onRemoteRttRequest(), 0, this);
    }

    public static RemoteConnection failure(DisconnectCause disconnectCause) {
        return InvokeDynamicSupport.bootstrapStatic("failure", $$robo$$android_telecom_RemoteConnection$failure(android.telecom.DisconnectCause ), 0, (DisconnectCause)disconnectCause);
    }

    public /* synthetic */ RemoteConnection() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RemoteConnection)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class CallbackRecord
    extends Callback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Callback mCallback;
        private Handler mHandler;

        private void $$robo$$android_telecom_RemoteConnection_CallbackRecord$__constructor__(Callback callback, Handler handler) {
            this.mCallback = callback;
            this.mHandler = handler;
        }

        private final Callback $$robo$$android_telecom_RemoteConnection_CallbackRecord$getCallback() {
            return this.mCallback;
        }

        private final Handler $$robo$$android_telecom_RemoteConnection_CallbackRecord$getHandler() {
            return this.mHandler;
        }

        private void __constructor__(Callback callback, Handler handler) {
            this.$$robo$$android_telecom_RemoteConnection_CallbackRecord$__constructor__(callback, handler);
        }

        public CallbackRecord(Callback callback, Handler handler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection_CallbackRecord$__constructor__(android.telecom.RemoteConnection$Callback android.os.Handler ), 0, this, callback, handler);
        }

        public Callback getCallback() {
            return InvokeDynamicSupport.bootstrap("getCallback", $$robo$$android_telecom_RemoteConnection_CallbackRecord$getCallback(), 0, this);
        }

        public Handler getHandler() {
            return InvokeDynamicSupport.bootstrap("getHandler", $$robo$$android_telecom_RemoteConnection_CallbackRecord$getHandler(), 0, this);
        }

        public /* synthetic */ CallbackRecord() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackRecord)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class VideoProvider
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private IVideoCallback mVideoCallbackDelegate;
        private VideoCallbackServant mVideoCallbackServant;
        private IVideoProvider mVideoProviderBinder;
        private String mCallingPackage;
        private int mTargetSdkVersion;
        private Set<Callback> mCallbacks;

        private void $$robo$$android_telecom_RemoteConnection_VideoProvider$__constructor__(IVideoProvider videoProviderBinder, String callingPackage, int targetSdkVersion) {
            this.mVideoCallbackDelegate = new IVideoCallback(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ VideoProvider this$0;

                private void $$robo$$android_telecom_RemoteConnection_VideoProvider_1$__constructor__(VideoProvider this$0) {
                }

                private final void $$robo$$android_telecom_RemoteConnection_VideoProvider_1$receiveSessionModifyRequest(VideoProfile videoProfile) {
                    for (Callback l : this.this$0.mCallbacks) {
                        l.onSessionModifyRequestReceived(this.this$0, videoProfile);
                    }
                }

                private final void $$robo$$android_telecom_RemoteConnection_VideoProvider_1$receiveSessionModifyResponse(int status, VideoProfile requestedProfile, VideoProfile responseProfile) {
                    for (Callback l : this.this$0.mCallbacks) {
                        l.onSessionModifyResponseReceived(this.this$0, status, requestedProfile, responseProfile);
                    }
                }

                private final void $$robo$$android_telecom_RemoteConnection_VideoProvider_1$handleCallSessionEvent(int event) {
                    for (Callback l : this.this$0.mCallbacks) {
                        l.onCallSessionEvent(this.this$0, event);
                    }
                }

                private final void $$robo$$android_telecom_RemoteConnection_VideoProvider_1$changePeerDimensions(int width, int height) {
                    for (Callback l : this.this$0.mCallbacks) {
                        l.onPeerDimensionsChanged(this.this$0, width, height);
                    }
                }

                private final void $$robo$$android_telecom_RemoteConnection_VideoProvider_1$changeCallDataUsage(long dataUsage) {
                    for (Callback l : this.this$0.mCallbacks) {
                        l.onCallDataUsageChanged(this.this$0, dataUsage);
                    }
                }

                private final void $$robo$$android_telecom_RemoteConnection_VideoProvider_1$changeCameraCapabilities(VideoProfile.CameraCapabilities cameraCapabilities) {
                    for (Callback l : this.this$0.mCallbacks) {
                        l.onCameraCapabilitiesChanged(this.this$0, cameraCapabilities);
                    }
                }

                private final void $$robo$$android_telecom_RemoteConnection_VideoProvider_1$changeVideoQuality(int videoQuality) {
                    for (Callback l : this.this$0.mCallbacks) {
                        l.onVideoQualityChanged(this.this$0, videoQuality);
                    }
                }

                private final IBinder $$robo$$android_telecom_RemoteConnection_VideoProvider_1$asBinder() {
                    return null;
                }

                private void __constructor__(VideoProvider videoProvider) {
                    this.$$robo$$android_telecom_RemoteConnection_VideoProvider_1$__constructor__(videoProvider);
                }
                {
                    this.this$0 = videoProvider;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection_VideoProvider_1$__constructor__(android.telecom.RemoteConnection$VideoProvider ), 0, this, videoProvider);
                }

                @Override
                public void receiveSessionModifyRequest(VideoProfile videoProfile) {
                    InvokeDynamicSupport.bootstrap("receiveSessionModifyRequest", $$robo$$android_telecom_RemoteConnection_VideoProvider_1$receiveSessionModifyRequest(android.telecom.VideoProfile ), 0, this, videoProfile);
                }

                @Override
                public void receiveSessionModifyResponse(int n, VideoProfile videoProfile, VideoProfile videoProfile2) {
                    InvokeDynamicSupport.bootstrap("receiveSessionModifyResponse", $$robo$$android_telecom_RemoteConnection_VideoProvider_1$receiveSessionModifyResponse(int android.telecom.VideoProfile android.telecom.VideoProfile ), 0, this, n, videoProfile, videoProfile2);
                }

                @Override
                public void handleCallSessionEvent(int n) {
                    InvokeDynamicSupport.bootstrap("handleCallSessionEvent", $$robo$$android_telecom_RemoteConnection_VideoProvider_1$handleCallSessionEvent(int ), 0, this, n);
                }

                @Override
                public void changePeerDimensions(int n, int n2) {
                    InvokeDynamicSupport.bootstrap("changePeerDimensions", $$robo$$android_telecom_RemoteConnection_VideoProvider_1$changePeerDimensions(int int ), 0, this, n, n2);
                }

                @Override
                public void changeCallDataUsage(long l) {
                    InvokeDynamicSupport.bootstrap("changeCallDataUsage", $$robo$$android_telecom_RemoteConnection_VideoProvider_1$changeCallDataUsage(long ), 0, this, l);
                }

                @Override
                public void changeCameraCapabilities(VideoProfile.CameraCapabilities cameraCapabilities) {
                    InvokeDynamicSupport.bootstrap("changeCameraCapabilities", $$robo$$android_telecom_RemoteConnection_VideoProvider_1$changeCameraCapabilities(android.telecom.VideoProfile$CameraCapabilities ), 0, this, cameraCapabilities);
                }

                @Override
                public void changeVideoQuality(int n) {
                    InvokeDynamicSupport.bootstrap("changeVideoQuality", $$robo$$android_telecom_RemoteConnection_VideoProvider_1$changeVideoQuality(int ), 0, this, n);
                }

                @Override
                public IBinder asBinder() {
                    return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_telecom_RemoteConnection_VideoProvider_1$asBinder(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mVideoCallbackServant = new VideoCallbackServant(this.mVideoCallbackDelegate);
            this.mCallbacks = Collections.newSetFromMap(new ConcurrentHashMap(8, 0.9f, 1));
            this.mVideoProviderBinder = videoProviderBinder;
            this.mCallingPackage = callingPackage;
            this.mTargetSdkVersion = targetSdkVersion;
            try {
                this.mVideoProviderBinder.addVideoCallback(this.mVideoCallbackServant.getStub().asBinder());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private final void $$robo$$android_telecom_RemoteConnection_VideoProvider$registerCallback(Callback l) {
            this.mCallbacks.add(l);
        }

        private final void $$robo$$android_telecom_RemoteConnection_VideoProvider$unregisterCallback(Callback l) {
            this.mCallbacks.remove(l);
        }

        private final void $$robo$$android_telecom_RemoteConnection_VideoProvider$setCamera(String cameraId) {
            try {
                this.mVideoProviderBinder.setCamera(cameraId, this.mCallingPackage, this.mTargetSdkVersion);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private final void $$robo$$android_telecom_RemoteConnection_VideoProvider$setPreviewSurface(Surface surface) {
            try {
                this.mVideoProviderBinder.setPreviewSurface(surface);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private final void $$robo$$android_telecom_RemoteConnection_VideoProvider$setDisplaySurface(Surface surface) {
            try {
                this.mVideoProviderBinder.setDisplaySurface(surface);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private final void $$robo$$android_telecom_RemoteConnection_VideoProvider$setDeviceOrientation(int rotation) {
            try {
                this.mVideoProviderBinder.setDeviceOrientation(rotation);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private final void $$robo$$android_telecom_RemoteConnection_VideoProvider$setZoom(float value) {
            try {
                this.mVideoProviderBinder.setZoom(value);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private final void $$robo$$android_telecom_RemoteConnection_VideoProvider$sendSessionModifyRequest(VideoProfile fromProfile, VideoProfile toProfile) {
            try {
                this.mVideoProviderBinder.sendSessionModifyRequest(fromProfile, toProfile);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private final void $$robo$$android_telecom_RemoteConnection_VideoProvider$sendSessionModifyResponse(VideoProfile responseProfile) {
            try {
                this.mVideoProviderBinder.sendSessionModifyResponse(responseProfile);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private final void $$robo$$android_telecom_RemoteConnection_VideoProvider$requestCameraCapabilities() {
            try {
                this.mVideoProviderBinder.requestCameraCapabilities();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private final void $$robo$$android_telecom_RemoteConnection_VideoProvider$requestCallDataUsage() {
            try {
                this.mVideoProviderBinder.requestCallDataUsage();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private final void $$robo$$android_telecom_RemoteConnection_VideoProvider$setPauseImage(Uri uri) {
            try {
                this.mVideoProviderBinder.setPauseImage(uri);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private void __constructor__(IVideoProvider iVideoProvider, String string2, int n) {
            this.$$robo$$android_telecom_RemoteConnection_VideoProvider$__constructor__(iVideoProvider, string2, n);
        }

        VideoProvider(IVideoProvider iVideoProvider, String string2, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection_VideoProvider$__constructor__(com.android.internal.telecom.IVideoProvider java.lang.String int ), 0, this, iVideoProvider, string2, n);
        }

        public void registerCallback(Callback callback) {
            InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_telecom_RemoteConnection_VideoProvider$registerCallback(android.telecom.RemoteConnection$VideoProvider$Callback ), 0, this, callback);
        }

        public void unregisterCallback(Callback callback) {
            InvokeDynamicSupport.bootstrap("unregisterCallback", $$robo$$android_telecom_RemoteConnection_VideoProvider$unregisterCallback(android.telecom.RemoteConnection$VideoProvider$Callback ), 0, this, callback);
        }

        public void setCamera(String string2) {
            InvokeDynamicSupport.bootstrap("setCamera", $$robo$$android_telecom_RemoteConnection_VideoProvider$setCamera(java.lang.String ), 0, this, string2);
        }

        public void setPreviewSurface(Surface surface) {
            InvokeDynamicSupport.bootstrap("setPreviewSurface", $$robo$$android_telecom_RemoteConnection_VideoProvider$setPreviewSurface(android.view.Surface ), 0, this, surface);
        }

        public void setDisplaySurface(Surface surface) {
            InvokeDynamicSupport.bootstrap("setDisplaySurface", $$robo$$android_telecom_RemoteConnection_VideoProvider$setDisplaySurface(android.view.Surface ), 0, this, surface);
        }

        public void setDeviceOrientation(int n) {
            InvokeDynamicSupport.bootstrap("setDeviceOrientation", $$robo$$android_telecom_RemoteConnection_VideoProvider$setDeviceOrientation(int ), 0, this, n);
        }

        public void setZoom(float f) {
            InvokeDynamicSupport.bootstrap("setZoom", $$robo$$android_telecom_RemoteConnection_VideoProvider$setZoom(float ), 0, this, f);
        }

        public void sendSessionModifyRequest(VideoProfile videoProfile, VideoProfile videoProfile2) {
            InvokeDynamicSupport.bootstrap("sendSessionModifyRequest", $$robo$$android_telecom_RemoteConnection_VideoProvider$sendSessionModifyRequest(android.telecom.VideoProfile android.telecom.VideoProfile ), 0, this, videoProfile, videoProfile2);
        }

        public void sendSessionModifyResponse(VideoProfile videoProfile) {
            InvokeDynamicSupport.bootstrap("sendSessionModifyResponse", $$robo$$android_telecom_RemoteConnection_VideoProvider$sendSessionModifyResponse(android.telecom.VideoProfile ), 0, this, videoProfile);
        }

        public void requestCameraCapabilities() {
            InvokeDynamicSupport.bootstrap("requestCameraCapabilities", $$robo$$android_telecom_RemoteConnection_VideoProvider$requestCameraCapabilities(), 0, this);
        }

        public void requestCallDataUsage() {
            InvokeDynamicSupport.bootstrap("requestCallDataUsage", $$robo$$android_telecom_RemoteConnection_VideoProvider$requestCallDataUsage(), 0, this);
        }

        public void setPauseImage(Uri uri) {
            InvokeDynamicSupport.bootstrap("setPauseImage", $$robo$$android_telecom_RemoteConnection_VideoProvider$setPauseImage(android.net.Uri ), 0, this, uri);
        }

        public /* synthetic */ VideoProvider() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VideoProvider)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static abstract class Callback
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_telecom_RemoteConnection_VideoProvider_Callback$__constructor__() {
            }

            private final void $$robo$$android_telecom_RemoteConnection_VideoProvider_Callback$onSessionModifyRequestReceived(VideoProvider videoProvider, VideoProfile videoProfile) {
            }

            private final void $$robo$$android_telecom_RemoteConnection_VideoProvider_Callback$onSessionModifyResponseReceived(VideoProvider videoProvider, int status, VideoProfile requestedProfile, VideoProfile responseProfile) {
            }

            private final void $$robo$$android_telecom_RemoteConnection_VideoProvider_Callback$onCallSessionEvent(VideoProvider videoProvider, int event) {
            }

            private final void $$robo$$android_telecom_RemoteConnection_VideoProvider_Callback$onPeerDimensionsChanged(VideoProvider videoProvider, int width, int height) {
            }

            private final void $$robo$$android_telecom_RemoteConnection_VideoProvider_Callback$onCallDataUsageChanged(VideoProvider videoProvider, long dataUsage) {
            }

            private final void $$robo$$android_telecom_RemoteConnection_VideoProvider_Callback$onCameraCapabilitiesChanged(VideoProvider videoProvider, VideoProfile.CameraCapabilities cameraCapabilities) {
            }

            private final void $$robo$$android_telecom_RemoteConnection_VideoProvider_Callback$onVideoQualityChanged(VideoProvider videoProvider, int videoQuality) {
            }

            private void __constructor__() {
                this.$$robo$$android_telecom_RemoteConnection_VideoProvider_Callback$__constructor__();
            }

            public Callback() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection_VideoProvider_Callback$__constructor__(), 0, this);
            }

            public void onSessionModifyRequestReceived(VideoProvider videoProvider, VideoProfile videoProfile) {
                InvokeDynamicSupport.bootstrap("onSessionModifyRequestReceived", $$robo$$android_telecom_RemoteConnection_VideoProvider_Callback$onSessionModifyRequestReceived(android.telecom.RemoteConnection$VideoProvider android.telecom.VideoProfile ), 0, this, videoProvider, videoProfile);
            }

            public void onSessionModifyResponseReceived(VideoProvider videoProvider, int n, VideoProfile videoProfile, VideoProfile videoProfile2) {
                InvokeDynamicSupport.bootstrap("onSessionModifyResponseReceived", $$robo$$android_telecom_RemoteConnection_VideoProvider_Callback$onSessionModifyResponseReceived(android.telecom.RemoteConnection$VideoProvider int android.telecom.VideoProfile android.telecom.VideoProfile ), 0, this, videoProvider, n, videoProfile, videoProfile2);
            }

            public void onCallSessionEvent(VideoProvider videoProvider, int n) {
                InvokeDynamicSupport.bootstrap("onCallSessionEvent", $$robo$$android_telecom_RemoteConnection_VideoProvider_Callback$onCallSessionEvent(android.telecom.RemoteConnection$VideoProvider int ), 0, this, videoProvider, n);
            }

            public void onPeerDimensionsChanged(VideoProvider videoProvider, int n, int n2) {
                InvokeDynamicSupport.bootstrap("onPeerDimensionsChanged", $$robo$$android_telecom_RemoteConnection_VideoProvider_Callback$onPeerDimensionsChanged(android.telecom.RemoteConnection$VideoProvider int int ), 0, this, videoProvider, n, n2);
            }

            public void onCallDataUsageChanged(VideoProvider videoProvider, long l) {
                InvokeDynamicSupport.bootstrap("onCallDataUsageChanged", $$robo$$android_telecom_RemoteConnection_VideoProvider_Callback$onCallDataUsageChanged(android.telecom.RemoteConnection$VideoProvider long ), 0, this, videoProvider, l);
            }

            public void onCameraCapabilitiesChanged(VideoProvider videoProvider, VideoProfile.CameraCapabilities cameraCapabilities) {
                InvokeDynamicSupport.bootstrap("onCameraCapabilitiesChanged", $$robo$$android_telecom_RemoteConnection_VideoProvider_Callback$onCameraCapabilitiesChanged(android.telecom.RemoteConnection$VideoProvider android.telecom.VideoProfile$CameraCapabilities ), 0, this, videoProvider, cameraCapabilities);
            }

            public void onVideoQualityChanged(VideoProvider videoProvider, int n) {
                InvokeDynamicSupport.bootstrap("onVideoQualityChanged", $$robo$$android_telecom_RemoteConnection_VideoProvider_Callback$onVideoQualityChanged(android.telecom.RemoteConnection$VideoProvider int ), 0, this, videoProvider, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static abstract class Callback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_telecom_RemoteConnection_Callback$__constructor__() {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onStateChanged(RemoteConnection connection, int state) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onDisconnected(RemoteConnection connection, DisconnectCause disconnectCause) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onRingbackRequested(RemoteConnection connection, boolean ringback) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onConnectionCapabilitiesChanged(RemoteConnection connection, int connectionCapabilities) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onConnectionPropertiesChanged(RemoteConnection connection, int connectionProperties) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onPostDialWait(RemoteConnection connection, String remainingPostDialSequence) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onPostDialChar(RemoteConnection connection, char nextChar) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onVoipAudioChanged(RemoteConnection connection, boolean isVoip) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onStatusHintsChanged(RemoteConnection connection, StatusHints statusHints) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onAddressChanged(RemoteConnection connection, Uri address, int presentation) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onCallerDisplayNameChanged(RemoteConnection connection, String callerDisplayName, int presentation) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onVideoStateChanged(RemoteConnection connection, int videoState) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onDestroyed(RemoteConnection connection) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onConferenceableConnectionsChanged(RemoteConnection connection, List<RemoteConnection> conferenceableConnections) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onVideoProviderChanged(RemoteConnection connection, VideoProvider videoProvider) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onConferenceChanged(RemoteConnection connection, RemoteConference conference) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onExtrasChanged(RemoteConnection connection, Bundle extras) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onConnectionEvent(RemoteConnection connection, String event, Bundle extras) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onRttInitiationSuccess(RemoteConnection connection) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onRttInitiationFailure(RemoteConnection connection, int reason) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onRttSessionRemotelyTerminated(RemoteConnection connection) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onRemoteRttRequest(RemoteConnection connection) {
        }

        private void __constructor__() {
            this.$$robo$$android_telecom_RemoteConnection_Callback$__constructor__();
        }

        public Callback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection_Callback$__constructor__(), 0, this);
        }

        public void onStateChanged(RemoteConnection remoteConnection, int n) {
            InvokeDynamicSupport.bootstrap("onStateChanged", $$robo$$android_telecom_RemoteConnection_Callback$onStateChanged(android.telecom.RemoteConnection int ), 0, this, remoteConnection, n);
        }

        public void onDisconnected(RemoteConnection remoteConnection, DisconnectCause disconnectCause) {
            InvokeDynamicSupport.bootstrap("onDisconnected", $$robo$$android_telecom_RemoteConnection_Callback$onDisconnected(android.telecom.RemoteConnection android.telecom.DisconnectCause ), 0, this, remoteConnection, disconnectCause);
        }

        public void onRingbackRequested(RemoteConnection remoteConnection, boolean bl) {
            InvokeDynamicSupport.bootstrap("onRingbackRequested", $$robo$$android_telecom_RemoteConnection_Callback$onRingbackRequested(android.telecom.RemoteConnection boolean ), 0, this, remoteConnection, bl);
        }

        public void onConnectionCapabilitiesChanged(RemoteConnection remoteConnection, int n) {
            InvokeDynamicSupport.bootstrap("onConnectionCapabilitiesChanged", $$robo$$android_telecom_RemoteConnection_Callback$onConnectionCapabilitiesChanged(android.telecom.RemoteConnection int ), 0, this, remoteConnection, n);
        }

        public void onConnectionPropertiesChanged(RemoteConnection remoteConnection, int n) {
            InvokeDynamicSupport.bootstrap("onConnectionPropertiesChanged", $$robo$$android_telecom_RemoteConnection_Callback$onConnectionPropertiesChanged(android.telecom.RemoteConnection int ), 0, this, remoteConnection, n);
        }

        public void onPostDialWait(RemoteConnection remoteConnection, String string2) {
            InvokeDynamicSupport.bootstrap("onPostDialWait", $$robo$$android_telecom_RemoteConnection_Callback$onPostDialWait(android.telecom.RemoteConnection java.lang.String ), 0, this, remoteConnection, string2);
        }

        public void onPostDialChar(RemoteConnection remoteConnection, char c) {
            InvokeDynamicSupport.bootstrap("onPostDialChar", $$robo$$android_telecom_RemoteConnection_Callback$onPostDialChar(android.telecom.RemoteConnection char ), 0, this, remoteConnection, c);
        }

        public void onVoipAudioChanged(RemoteConnection remoteConnection, boolean bl) {
            InvokeDynamicSupport.bootstrap("onVoipAudioChanged", $$robo$$android_telecom_RemoteConnection_Callback$onVoipAudioChanged(android.telecom.RemoteConnection boolean ), 0, this, remoteConnection, bl);
        }

        public void onStatusHintsChanged(RemoteConnection remoteConnection, StatusHints statusHints) {
            InvokeDynamicSupport.bootstrap("onStatusHintsChanged", $$robo$$android_telecom_RemoteConnection_Callback$onStatusHintsChanged(android.telecom.RemoteConnection android.telecom.StatusHints ), 0, this, remoteConnection, statusHints);
        }

        public void onAddressChanged(RemoteConnection remoteConnection, Uri uri, int n) {
            InvokeDynamicSupport.bootstrap("onAddressChanged", $$robo$$android_telecom_RemoteConnection_Callback$onAddressChanged(android.telecom.RemoteConnection android.net.Uri int ), 0, this, remoteConnection, uri, n);
        }

        public void onCallerDisplayNameChanged(RemoteConnection remoteConnection, String string2, int n) {
            InvokeDynamicSupport.bootstrap("onCallerDisplayNameChanged", $$robo$$android_telecom_RemoteConnection_Callback$onCallerDisplayNameChanged(android.telecom.RemoteConnection java.lang.String int ), 0, this, remoteConnection, string2, n);
        }

        public void onVideoStateChanged(RemoteConnection remoteConnection, int n) {
            InvokeDynamicSupport.bootstrap("onVideoStateChanged", $$robo$$android_telecom_RemoteConnection_Callback$onVideoStateChanged(android.telecom.RemoteConnection int ), 0, this, remoteConnection, n);
        }

        public void onDestroyed(RemoteConnection remoteConnection) {
            InvokeDynamicSupport.bootstrap("onDestroyed", $$robo$$android_telecom_RemoteConnection_Callback$onDestroyed(android.telecom.RemoteConnection ), 0, this, remoteConnection);
        }

        public void onConferenceableConnectionsChanged(RemoteConnection remoteConnection, List<RemoteConnection> list) {
            InvokeDynamicSupport.bootstrap("onConferenceableConnectionsChanged", $$robo$$android_telecom_RemoteConnection_Callback$onConferenceableConnectionsChanged(android.telecom.RemoteConnection java.util.List<android.telecom.RemoteConnection> ), 0, this, remoteConnection, list);
        }

        public void onVideoProviderChanged(RemoteConnection remoteConnection, VideoProvider videoProvider) {
            InvokeDynamicSupport.bootstrap("onVideoProviderChanged", $$robo$$android_telecom_RemoteConnection_Callback$onVideoProviderChanged(android.telecom.RemoteConnection android.telecom.RemoteConnection$VideoProvider ), 0, this, remoteConnection, videoProvider);
        }

        public void onConferenceChanged(RemoteConnection remoteConnection, RemoteConference remoteConference) {
            InvokeDynamicSupport.bootstrap("onConferenceChanged", $$robo$$android_telecom_RemoteConnection_Callback$onConferenceChanged(android.telecom.RemoteConnection android.telecom.RemoteConference ), 0, this, remoteConnection, remoteConference);
        }

        public void onExtrasChanged(RemoteConnection remoteConnection, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onExtrasChanged", $$robo$$android_telecom_RemoteConnection_Callback$onExtrasChanged(android.telecom.RemoteConnection android.os.Bundle ), 0, this, remoteConnection, bundle);
        }

        public void onConnectionEvent(RemoteConnection remoteConnection, String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onConnectionEvent", $$robo$$android_telecom_RemoteConnection_Callback$onConnectionEvent(android.telecom.RemoteConnection java.lang.String android.os.Bundle ), 0, this, remoteConnection, string2, bundle);
        }

        public void onRttInitiationSuccess(RemoteConnection remoteConnection) {
            InvokeDynamicSupport.bootstrap("onRttInitiationSuccess", $$robo$$android_telecom_RemoteConnection_Callback$onRttInitiationSuccess(android.telecom.RemoteConnection ), 0, this, remoteConnection);
        }

        public void onRttInitiationFailure(RemoteConnection remoteConnection, int n) {
            InvokeDynamicSupport.bootstrap("onRttInitiationFailure", $$robo$$android_telecom_RemoteConnection_Callback$onRttInitiationFailure(android.telecom.RemoteConnection int ), 0, this, remoteConnection, n);
        }

        public void onRttSessionRemotelyTerminated(RemoteConnection remoteConnection) {
            InvokeDynamicSupport.bootstrap("onRttSessionRemotelyTerminated", $$robo$$android_telecom_RemoteConnection_Callback$onRttSessionRemotelyTerminated(android.telecom.RemoteConnection ), 0, this, remoteConnection);
        }

        public void onRemoteRttRequest(RemoteConnection remoteConnection) {
            InvokeDynamicSupport.bootstrap("onRemoteRttRequest", $$robo$$android_telecom_RemoteConnection_Callback$onRemoteRttRequest(android.telecom.RemoteConnection ), 0, this, remoteConnection);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

