/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.telephony.SubscriptionManager;
import android.telephony.mbms.DownloadRequest;
import android.telephony.mbms.DownloadStateCallback;
import android.telephony.mbms.FileInfo;
import android.telephony.mbms.InternalDownloadSessionCallback;
import android.telephony.mbms.InternalDownloadStateCallback;
import android.telephony.mbms.MbmsDownloadSessionCallback;
import android.telephony.mbms.MbmsUtils;
import android.telephony.mbms.vendor.IMbmsDownloadService;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MbmsDownloadSession
implements AutoCloseable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG;
    public static String MBMS_DOWNLOAD_SERVICE_ACTION = "android.telephony.action.EmbmsDownload";
    public static String EXTRA_MBMS_DOWNLOAD_RESULT = "android.telephony.extra.MBMS_DOWNLOAD_RESULT";
    public static String EXTRA_MBMS_FILE_INFO = "android.telephony.extra.MBMS_FILE_INFO";
    public static String EXTRA_MBMS_COMPLETED_FILE_URI = "android.telephony.extra.MBMS_COMPLETED_FILE_URI";
    public static String EXTRA_MBMS_DOWNLOAD_REQUEST = "android.telephony.extra.MBMS_DOWNLOAD_REQUEST";
    public static String DEFAULT_TOP_LEVEL_TEMP_DIRECTORY = "androidMbmsTempFileRoot";
    public static int RESULT_SUCCESSFUL = 1;
    public static int RESULT_CANCELLED = 2;
    public static int RESULT_EXPIRED = 3;
    public static int RESULT_IO_ERROR = 4;
    public static int STATUS_UNKNOWN = 0;
    public static int STATUS_ACTIVELY_DOWNLOADING = 1;
    public static int STATUS_PENDING_DOWNLOAD = 2;
    public static int STATUS_PENDING_REPAIR = 3;
    public static int STATUS_PENDING_DOWNLOAD_WINDOW = 4;
    private static AtomicBoolean sIsInitialized;
    private Context mContext;
    private int mSubscriptionId;
    private IBinder.DeathRecipient mDeathRecipient;
    private AtomicReference<IMbmsDownloadService> mService;
    private InternalDownloadSessionCallback mInternalCallback;
    private Map<DownloadStateCallback, InternalDownloadStateCallback> mInternalDownloadCallbacks;

    private void $$robo$$android_telephony_MbmsDownloadSession$__constructor__(Context context, MbmsDownloadSessionCallback callback, int subscriptionId, Handler handler) {
        this.mSubscriptionId = -1;
        this.mDeathRecipient = new IBinder.DeathRecipient(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MbmsDownloadSession this$0;

            private void $$robo$$android_telephony_MbmsDownloadSession_1$__constructor__(MbmsDownloadSession this$0) {
            }

            private final void $$robo$$android_telephony_MbmsDownloadSession_1$binderDied() {
                this.this$0.sendErrorToApp(3, "Received death notification");
            }

            private void __constructor__(MbmsDownloadSession mbmsDownloadSession) {
                this.$$robo$$android_telephony_MbmsDownloadSession_1$__constructor__(mbmsDownloadSession);
            }
            {
                this.this$0 = mbmsDownloadSession;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_MbmsDownloadSession_1$__constructor__(android.telephony.MbmsDownloadSession ), 0, this, mbmsDownloadSession);
            }

            @Override
            public void binderDied() {
                InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_telephony_MbmsDownloadSession_1$binderDied(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mService = new AtomicReference<Object>(null);
        this.mInternalDownloadCallbacks = new HashMap<DownloadStateCallback, InternalDownloadStateCallback>();
        this.mContext = context;
        this.mSubscriptionId = subscriptionId;
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper());
        }
        this.mInternalCallback = new InternalDownloadSessionCallback(callback, handler);
    }

    private static final MbmsDownloadSession $$robo$$android_telephony_MbmsDownloadSession$create(Context context, MbmsDownloadSessionCallback callback, Handler handler) {
        return MbmsDownloadSession.create(context, callback, SubscriptionManager.getDefaultSubscriptionId(), handler);
    }

    private static final MbmsDownloadSession $$robo$$android_telephony_MbmsDownloadSession$create(Context context, MbmsDownloadSessionCallback callback, int subscriptionId, Handler handler) {
        if (!sIsInitialized.compareAndSet(false, true)) {
            throw new IllegalStateException("Cannot have two active instances");
        }
        MbmsDownloadSession session = new MbmsDownloadSession(context, callback, subscriptionId, handler);
        int result = session.bindAndInitialize();
        if (result != 0) {
            sIsInitialized.set(false);
            handler.post(new Runnable(callback, result){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ MbmsDownloadSessionCallback val$callback;
                /* synthetic */ int val$result;

                private void $$robo$$android_telephony_MbmsDownloadSession_2$__constructor__(MbmsDownloadSessionCallback mbmsDownloadSessionCallback, int n) {
                }

                private final void $$robo$$android_telephony_MbmsDownloadSession_2$run() {
                    this.val$callback.onError(this.val$result, null);
                }

                private void __constructor__(MbmsDownloadSessionCallback mbmsDownloadSessionCallback, int n) {
                    this.$$robo$$android_telephony_MbmsDownloadSession_2$__constructor__(mbmsDownloadSessionCallback, n);
                }
                {
                    this.val$callback = mbmsDownloadSessionCallback;
                    this.val$result = n;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_MbmsDownloadSession_2$__constructor__(android.telephony.mbms.MbmsDownloadSessionCallback int ), 0, this, mbmsDownloadSessionCallback, n);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telephony_MbmsDownloadSession_2$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            return null;
        }
        return session;
    }

    private final int $$robo$$android_telephony_MbmsDownloadSession$bindAndInitialize() {
        return MbmsUtils.startBinding(this.mContext, "android.telephony.action.EmbmsDownload", new ServiceConnection(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MbmsDownloadSession this$0;

            private void $$robo$$android_telephony_MbmsDownloadSession_3$__constructor__(MbmsDownloadSession this$0) {
            }

            private final void $$robo$$android_telephony_MbmsDownloadSession_3$onServiceConnected(ComponentName name, IBinder service) {
                int result;
                IMbmsDownloadService downloadService = IMbmsDownloadService.Stub.asInterface(service);
                try {
                    result = downloadService.initialize(this.this$0.mSubscriptionId, this.this$0.mInternalCallback);
                }
                catch (RemoteException e) {
                    Log.e(LOG_TAG, "Service died before initialization");
                    sIsInitialized.set(false);
                    return;
                }
                catch (RuntimeException e) {
                    Log.e(LOG_TAG, "Runtime exception during initialization");
                    this.this$0.sendErrorToApp(103, e.toString());
                    sIsInitialized.set(false);
                    return;
                }
                if (result != 0) {
                    this.this$0.sendErrorToApp(result, "Error returned during initialization");
                    sIsInitialized.set(false);
                    return;
                }
                try {
                    downloadService.asBinder().linkToDeath(this.this$0.mDeathRecipient, 0);
                }
                catch (RemoteException e) {
                    this.this$0.sendErrorToApp(3, "Middleware lost during initialization");
                    sIsInitialized.set(false);
                    return;
                }
                this.this$0.mService.set(downloadService);
            }

            private final void $$robo$$android_telephony_MbmsDownloadSession_3$onServiceDisconnected(ComponentName name) {
                sIsInitialized.set(false);
                this.this$0.mService.set(null);
            }

            private void __constructor__(MbmsDownloadSession mbmsDownloadSession) {
                this.$$robo$$android_telephony_MbmsDownloadSession_3$__constructor__(mbmsDownloadSession);
            }
            {
                this.this$0 = mbmsDownloadSession;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_MbmsDownloadSession_3$__constructor__(android.telephony.MbmsDownloadSession ), 0, this, mbmsDownloadSession);
            }

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_telephony_MbmsDownloadSession_3$onServiceConnected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_telephony_MbmsDownloadSession_3$onServiceDisconnected(android.content.ComponentName ), 0, this, componentName);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_telephony_MbmsDownloadSession$requestUpdateFileServices(List<String> classList) {
        IMbmsDownloadService downloadService = this.mService.get();
        if (downloadService == null) {
            throw new IllegalStateException("Middleware not yet bound");
        }
        try {
            int returnCode = downloadService.requestUpdateFileServices(this.mSubscriptionId, classList);
            if (returnCode != 0) {
                this.sendErrorToApp(returnCode, null);
            }
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "Remote process died");
            this.mService.set(null);
            this.sendErrorToApp(3, null);
        }
    }

    private final void $$robo$$android_telephony_MbmsDownloadSession$setTempFileRootDirectory(File tempFileRootDirectory) {
        String filePath;
        IMbmsDownloadService downloadService = this.mService.get();
        if (downloadService == null) {
            throw new IllegalStateException("Middleware not yet bound");
        }
        try {
            this.validateTempFileRootSanity(tempFileRootDirectory);
        }
        catch (IOException e) {
            throw new IllegalStateException("Got IOException checking directory sanity");
        }
        try {
            filePath = tempFileRootDirectory.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to canonicalize the provided path: " + e);
        }
        try {
            int result = downloadService.setTempFileRootDirectory(this.mSubscriptionId, filePath);
            if (result != 0) {
                this.sendErrorToApp(result, null);
            }
        }
        catch (RemoteException e) {
            this.mService.set(null);
            this.sendErrorToApp(3, null);
            return;
        }
        SharedPreferences prefs = this.mContext.getSharedPreferences("MbmsTempFileRootPrefs", 0);
        prefs.edit().putString("mbms_temp_file_root", filePath).apply();
    }

    private final void $$robo$$android_telephony_MbmsDownloadSession$validateTempFileRootSanity(File tempFileRootDirectory) throws IOException {
        if (!tempFileRootDirectory.exists()) {
            throw new IllegalArgumentException("Provided directory does not exist");
        }
        if (!tempFileRootDirectory.isDirectory()) {
            throw new IllegalArgumentException("Provided File is not a directory");
        }
        String canonicalTempFilePath = tempFileRootDirectory.getCanonicalPath();
        if (this.mContext.getDataDir().getCanonicalPath().equals(canonicalTempFilePath)) {
            throw new IllegalArgumentException("Temp file root cannot be your data dir");
        }
        if (this.mContext.getCacheDir().getCanonicalPath().equals(canonicalTempFilePath)) {
            throw new IllegalArgumentException("Temp file root cannot be your cache dir");
        }
        if (this.mContext.getFilesDir().getCanonicalPath().equals(canonicalTempFilePath)) {
            throw new IllegalArgumentException("Temp file root cannot be your files dir");
        }
    }

    private final File $$robo$$android_telephony_MbmsDownloadSession$getTempFileRootDirectory() {
        SharedPreferences prefs = this.mContext.getSharedPreferences("MbmsTempFileRootPrefs", 0);
        String path = prefs.getString("mbms_temp_file_root", null);
        if (path != null) {
            return new File(path);
        }
        return null;
    }

    private final void $$robo$$android_telephony_MbmsDownloadSession$download(DownloadRequest request) {
        IMbmsDownloadService downloadService = this.mService.get();
        if (downloadService == null) {
            throw new IllegalStateException("Middleware not yet bound");
        }
        SharedPreferences prefs = this.mContext.getSharedPreferences("MbmsTempFileRootPrefs", 0);
        if (prefs.getString("mbms_temp_file_root", null) == null) {
            File tempRootDirectory = new File(this.mContext.getFilesDir(), "androidMbmsTempFileRoot");
            tempRootDirectory.mkdirs();
            this.setTempFileRootDirectory(tempRootDirectory);
        }
        this.writeDownloadRequestToken(request);
        try {
            downloadService.download(request);
        }
        catch (RemoteException e) {
            this.mService.set(null);
            this.sendErrorToApp(3, null);
        }
    }

    private final List<DownloadRequest> $$robo$$android_telephony_MbmsDownloadSession$listPendingDownloads() {
        IMbmsDownloadService downloadService = this.mService.get();
        if (downloadService == null) {
            throw new IllegalStateException("Middleware not yet bound");
        }
        try {
            return downloadService.listPendingDownloads(this.mSubscriptionId);
        }
        catch (RemoteException e) {
            this.mService.set(null);
            this.sendErrorToApp(3, null);
            return Collections.emptyList();
        }
    }

    private final void $$robo$$android_telephony_MbmsDownloadSession$registerStateCallback(DownloadRequest request, DownloadStateCallback callback, Handler handler) {
        IMbmsDownloadService downloadService = this.mService.get();
        if (downloadService == null) {
            throw new IllegalStateException("Middleware not yet bound");
        }
        InternalDownloadStateCallback internalCallback = new InternalDownloadStateCallback(callback, handler);
        try {
            int result = downloadService.registerStateCallback(request, internalCallback, callback.getCallbackFilterFlags());
            if (result != 0) {
                if (result == 402) {
                    throw new IllegalArgumentException("Unknown download request.");
                }
                this.sendErrorToApp(result, null);
                return;
            }
        }
        catch (RemoteException e) {
            this.mService.set(null);
            this.sendErrorToApp(3, null);
            return;
        }
        this.mInternalDownloadCallbacks.put(callback, internalCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_telephony_MbmsDownloadSession$unregisterStateCallback(DownloadRequest request, DownloadStateCallback callback) {
        try {
            IMbmsDownloadService downloadService = this.mService.get();
            if (downloadService == null) {
                throw new IllegalStateException("Middleware not yet bound");
            }
            InternalDownloadStateCallback internalCallback = this.mInternalDownloadCallbacks.get(callback);
            try {
                int result = downloadService.unregisterStateCallback(request, internalCallback);
                if (result != 0) {
                    if (result == 402) {
                        throw new IllegalArgumentException("Unknown download request.");
                    }
                    this.sendErrorToApp(result, null);
                }
            }
            catch (RemoteException e) {
                this.mService.set(null);
                this.sendErrorToApp(3, null);
            }
        }
        finally {
            InternalDownloadStateCallback internalCallback = this.mInternalDownloadCallbacks.remove(callback);
            if (internalCallback != null) {
                internalCallback.stop();
            }
        }
    }

    private final void $$robo$$android_telephony_MbmsDownloadSession$cancelDownload(DownloadRequest downloadRequest) {
        IMbmsDownloadService downloadService = this.mService.get();
        if (downloadService == null) {
            throw new IllegalStateException("Middleware not yet bound");
        }
        try {
            int result = downloadService.cancelDownload(downloadRequest);
            if (result != 0) {
                if (result == 402) {
                    throw new IllegalArgumentException("Unknown download request.");
                }
                this.sendErrorToApp(result, null);
                return;
            }
        }
        catch (RemoteException e) {
            this.mService.set(null);
            this.sendErrorToApp(3, null);
            return;
        }
        this.deleteDownloadRequestToken(downloadRequest);
    }

    private final int $$robo$$android_telephony_MbmsDownloadSession$getDownloadStatus(DownloadRequest downloadRequest, FileInfo fileInfo) {
        IMbmsDownloadService downloadService = this.mService.get();
        if (downloadService == null) {
            throw new IllegalStateException("Middleware not yet bound");
        }
        try {
            return downloadService.getDownloadStatus(downloadRequest, fileInfo);
        }
        catch (RemoteException e) {
            this.mService.set(null);
            this.sendErrorToApp(3, null);
            return 0;
        }
    }

    private final void $$robo$$android_telephony_MbmsDownloadSession$resetDownloadKnowledge(DownloadRequest downloadRequest) {
        IMbmsDownloadService downloadService = this.mService.get();
        if (downloadService == null) {
            throw new IllegalStateException("Middleware not yet bound");
        }
        try {
            int result = downloadService.resetDownloadKnowledge(downloadRequest);
            if (result != 0) {
                if (result == 402) {
                    throw new IllegalArgumentException("Unknown download request.");
                }
                this.sendErrorToApp(result, null);
            }
        }
        catch (RemoteException e) {
            this.mService.set(null);
            this.sendErrorToApp(3, null);
        }
    }

    private final void $$robo$$android_telephony_MbmsDownloadSession$close() {
        try {
            IMbmsDownloadService downloadService = this.mService.get();
            if (downloadService == null) {
                Log.i(LOG_TAG, "Service already dead");
                return;
            }
            downloadService.dispose(this.mSubscriptionId);
        }
        catch (RemoteException e) {
            Log.i(LOG_TAG, "Remote exception while disposing of service");
        }
        finally {
            this.mService.set(null);
            sIsInitialized.set(false);
            this.mInternalCallback.stop();
        }
    }

    private final void $$robo$$android_telephony_MbmsDownloadSession$writeDownloadRequestToken(DownloadRequest request) {
        File token = this.getDownloadRequestTokenPath(request);
        if (!token.getParentFile().exists()) {
            token.getParentFile().mkdirs();
        }
        if (token.exists()) {
            Log.w(LOG_TAG, "Download token " + token.getName() + " already exists");
            return;
        }
        try {
            if (!token.createNewFile()) {
                throw new RuntimeException("Failed to create download token for request " + request);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create download token for request " + request + " due to IOException " + e);
        }
    }

    private final void $$robo$$android_telephony_MbmsDownloadSession$deleteDownloadRequestToken(DownloadRequest request) {
        File token = this.getDownloadRequestTokenPath(request);
        if (!token.isFile()) {
            Log.w(LOG_TAG, "Attempting to delete non-existent download token at " + token);
            return;
        }
        if (!token.delete()) {
            Log.w(LOG_TAG, "Couldn't delete download token at " + token);
        }
    }

    private final File $$robo$$android_telephony_MbmsDownloadSession$getDownloadRequestTokenPath(DownloadRequest request) {
        File tempFileLocation = MbmsUtils.getEmbmsTempFileDirForService(this.mContext, request.getFileServiceId());
        String downloadTokenFileName = request.getHash() + ".download_token";
        return new File(tempFileLocation, downloadTokenFileName);
    }

    private final void $$robo$$android_telephony_MbmsDownloadSession$sendErrorToApp(int errorCode, String message) {
        try {
            this.mInternalCallback.onError(errorCode, message);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    static void __staticInitializer__() {
        LOG_TAG = MbmsDownloadSession.class.getSimpleName();
        sIsInitialized = new AtomicBoolean(false);
    }

    private void __constructor__(Context context, MbmsDownloadSessionCallback mbmsDownloadSessionCallback, int n, Handler handler) {
        this.$$robo$$android_telephony_MbmsDownloadSession$__constructor__(context, mbmsDownloadSessionCallback, n, handler);
    }

    private MbmsDownloadSession(Context context, MbmsDownloadSessionCallback mbmsDownloadSessionCallback, int n, Handler handler) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_MbmsDownloadSession$__constructor__(android.content.Context android.telephony.mbms.MbmsDownloadSessionCallback int android.os.Handler ), 0, this, context, mbmsDownloadSessionCallback, n, handler);
    }

    public static MbmsDownloadSession create(Context context, MbmsDownloadSessionCallback mbmsDownloadSessionCallback, Handler handler) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_telephony_MbmsDownloadSession$create(android.content.Context android.telephony.mbms.MbmsDownloadSessionCallback android.os.Handler ), 0, (Context)context, (MbmsDownloadSessionCallback)mbmsDownloadSessionCallback, (Handler)handler);
    }

    public static MbmsDownloadSession create(Context context, MbmsDownloadSessionCallback mbmsDownloadSessionCallback, int n, Handler handler) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_telephony_MbmsDownloadSession$create(android.content.Context android.telephony.mbms.MbmsDownloadSessionCallback int android.os.Handler ), 0, (Context)context, (MbmsDownloadSessionCallback)mbmsDownloadSessionCallback, (int)n, (Handler)handler);
    }

    private int bindAndInitialize() {
        return (int)InvokeDynamicSupport.bootstrap("bindAndInitialize", $$robo$$android_telephony_MbmsDownloadSession$bindAndInitialize(), 0, this);
    }

    public void requestUpdateFileServices(List<String> list) {
        InvokeDynamicSupport.bootstrap("requestUpdateFileServices", $$robo$$android_telephony_MbmsDownloadSession$requestUpdateFileServices(java.util.List<java.lang.String> ), 0, this, list);
    }

    public void setTempFileRootDirectory(File file) {
        InvokeDynamicSupport.bootstrap("setTempFileRootDirectory", $$robo$$android_telephony_MbmsDownloadSession$setTempFileRootDirectory(java.io.File ), 0, this, file);
    }

    private void validateTempFileRootSanity(File file) throws IOException {
        InvokeDynamicSupport.bootstrap("validateTempFileRootSanity", $$robo$$android_telephony_MbmsDownloadSession$validateTempFileRootSanity(java.io.File ), 0, this, file);
    }

    public File getTempFileRootDirectory() {
        return InvokeDynamicSupport.bootstrap("getTempFileRootDirectory", $$robo$$android_telephony_MbmsDownloadSession$getTempFileRootDirectory(), 0, this);
    }

    public void download(DownloadRequest downloadRequest) {
        InvokeDynamicSupport.bootstrap("download", $$robo$$android_telephony_MbmsDownloadSession$download(android.telephony.mbms.DownloadRequest ), 0, this, downloadRequest);
    }

    public List<DownloadRequest> listPendingDownloads() {
        return InvokeDynamicSupport.bootstrap("listPendingDownloads", $$robo$$android_telephony_MbmsDownloadSession$listPendingDownloads(), 0, this);
    }

    public void registerStateCallback(DownloadRequest downloadRequest, DownloadStateCallback downloadStateCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerStateCallback", $$robo$$android_telephony_MbmsDownloadSession$registerStateCallback(android.telephony.mbms.DownloadRequest android.telephony.mbms.DownloadStateCallback android.os.Handler ), 0, this, downloadRequest, downloadStateCallback, handler);
    }

    public void unregisterStateCallback(DownloadRequest downloadRequest, DownloadStateCallback downloadStateCallback) {
        InvokeDynamicSupport.bootstrap("unregisterStateCallback", $$robo$$android_telephony_MbmsDownloadSession$unregisterStateCallback(android.telephony.mbms.DownloadRequest android.telephony.mbms.DownloadStateCallback ), 0, this, downloadRequest, downloadStateCallback);
    }

    public void cancelDownload(DownloadRequest downloadRequest) {
        InvokeDynamicSupport.bootstrap("cancelDownload", $$robo$$android_telephony_MbmsDownloadSession$cancelDownload(android.telephony.mbms.DownloadRequest ), 0, this, downloadRequest);
    }

    public int getDownloadStatus(DownloadRequest downloadRequest, FileInfo fileInfo) {
        return (int)InvokeDynamicSupport.bootstrap("getDownloadStatus", $$robo$$android_telephony_MbmsDownloadSession$getDownloadStatus(android.telephony.mbms.DownloadRequest android.telephony.mbms.FileInfo ), 0, this, downloadRequest, fileInfo);
    }

    public void resetDownloadKnowledge(DownloadRequest downloadRequest) {
        InvokeDynamicSupport.bootstrap("resetDownloadKnowledge", $$robo$$android_telephony_MbmsDownloadSession$resetDownloadKnowledge(android.telephony.mbms.DownloadRequest ), 0, this, downloadRequest);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_telephony_MbmsDownloadSession$close(), 0, this);
    }

    private void writeDownloadRequestToken(DownloadRequest downloadRequest) {
        InvokeDynamicSupport.bootstrap("writeDownloadRequestToken", $$robo$$android_telephony_MbmsDownloadSession$writeDownloadRequestToken(android.telephony.mbms.DownloadRequest ), 0, this, downloadRequest);
    }

    private void deleteDownloadRequestToken(DownloadRequest downloadRequest) {
        InvokeDynamicSupport.bootstrap("deleteDownloadRequestToken", $$robo$$android_telephony_MbmsDownloadSession$deleteDownloadRequestToken(android.telephony.mbms.DownloadRequest ), 0, this, downloadRequest);
    }

    private File getDownloadRequestTokenPath(DownloadRequest downloadRequest) {
        return InvokeDynamicSupport.bootstrap("getDownloadRequestTokenPath", $$robo$$android_telephony_MbmsDownloadSession$getDownloadRequestTokenPath(android.telephony.mbms.DownloadRequest ), 0, this, downloadRequest);
    }

    private void sendErrorToApp(int n, String string2) {
        InvokeDynamicSupport.bootstrap("sendErrorToApp", $$robo$$android_telephony_MbmsDownloadSession$sendErrorToApp(int java.lang.String ), 0, this, n, string2);
    }

    static {
        RobolectricInternals.classInitializing(MbmsDownloadSession.class);
    }

    public /* synthetic */ MbmsDownloadSession() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MbmsDownloadSession)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DownloadStatus {
    }
}

