/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.location.CountryDetector;
import android.net.Uri;
import android.os.PersistableBundle;
import android.os.SystemProperties;
import android.telephony.CarrierConfigManager;
import android.telephony.JapanesePhoneNumberFormatter;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.Editable;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.TtsSpan;
import android.util.SparseIntArray;
import com.android.i18n.phonenumbers.NumberParseException;
import com.android.i18n.phonenumbers.PhoneNumberUtil;
import com.android.i18n.phonenumbers.Phonenumber;
import com.android.i18n.phonenumbers.ShortNumberInfo;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PhoneNumberUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static char PAUSE = ',';
    public static char WAIT = ';';
    public static char WILD = 'N';
    private static String CLIR_ON = "*31#";
    private static String CLIR_OFF = "#31#";
    public static int TOA_International = 145;
    public static int TOA_Unknown = 129;
    static String LOG_TAG = "PhoneNumberUtils";
    private static boolean DBG = false;
    private static Pattern GLOBAL_PHONE_NUMBER_PATTERN;
    public static int FORMAT_UNKNOWN = 0;
    public static int FORMAT_NANP = 1;
    public static int FORMAT_JAPAN = 2;
    private static String[] NANP_COUNTRIES;
    private static String KOREA_ISO_COUNTRY_CODE = "KR";
    private static String JAPAN_ISO_COUNTRY_CODE = "JP";
    private static int NANP_STATE_DIGIT = 1;
    private static int NANP_STATE_PLUS = 2;
    private static int NANP_STATE_ONE = 3;
    private static int NANP_STATE_DASH = 4;
    static int MIN_MATCH = 7;
    private static SparseIntArray KEYPAD_MAP;
    private static char PLUS_SIGN_CHAR = '+';
    private static String PLUS_SIGN_STRING = "+";
    private static String NANP_IDP_STRING = "011";
    private static int NANP_LENGTH = 10;
    private static boolean[] COUNTRY_CALLING_CALL;
    private static int CCC_LENGTH;
    private static String[] sConvertToEmergencyMap;

    private void $$robo$$android_telephony_PhoneNumberUtils$__constructor__() {
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isISODigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$is12Key(char c) {
        return c >= '0' && c <= '9' || c == '*' || c == '#';
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isDialable(char c) {
        return c >= '0' && c <= '9' || c == '*' || c == '#' || c == '+' || c == 'N';
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isReallyDialable(char c) {
        return c >= '0' && c <= '9' || c == '*' || c == '#' || c == '+';
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isNonSeparator(char c) {
        return c >= '0' && c <= '9' || c == '*' || c == '#' || c == '+' || c == 'N' || c == ';' || c == ',';
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isStartsPostDial(char c) {
        return c == ',' || c == ';';
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isPause(char c) {
        return c == 'p' || c == 'P';
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isToneWait(char c) {
        return c == 'w' || c == 'W';
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isSeparator(char ch) {
        return !(PhoneNumberUtils.isDialable(ch) || 'a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String $$robo$$android_telephony_PhoneNumberUtils$getNumberFromIntent(Intent intent, Context context) {
        String number = null;
        Uri uri = intent.getData();
        if (uri == null) {
            return null;
        }
        String scheme = uri.getScheme();
        if (scheme.equals("tel") || scheme.equals("sip")) {
            return uri.getSchemeSpecificPart();
        }
        if (context == null) {
            return null;
        }
        String type = intent.resolveType(context);
        String phoneColumn = null;
        String authority = uri.getAuthority();
        if ("contacts".equals(authority)) {
            phoneColumn = "number";
        } else if ("com.android.contacts".equals(authority)) {
            phoneColumn = "data1";
        }
        try (Cursor c = null;){
            c = context.getContentResolver().query(uri, new String[]{phoneColumn}, null, null, null);
            if (c != null && c.moveToFirst()) {
                number = c.getString(c.getColumnIndex(phoneColumn));
            }
        }
        return number;
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$extractNetworkPortion(String phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        int len = phoneNumber.length();
        StringBuilder ret = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = phoneNumber.charAt(i);
            int digit = Character.digit(c, 10);
            if (digit != -1) {
                ret.append(digit);
                continue;
            }
            if (c == '+') {
                String prefix = ret.toString();
                if (prefix.length() != 0 && !prefix.equals("*31#") && !prefix.equals("#31#")) continue;
                ret.append(c);
                continue;
            }
            if (PhoneNumberUtils.isDialable(c)) {
                ret.append(c);
                continue;
            }
            if (PhoneNumberUtils.isStartsPostDial(c)) break;
        }
        return ret.toString();
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$extractNetworkPortionAlt(String phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        int len = phoneNumber.length();
        StringBuilder ret = new StringBuilder(len);
        boolean haveSeenPlus = false;
        for (int i = 0; i < len; ++i) {
            char c = phoneNumber.charAt(i);
            if (c == '+') {
                if (haveSeenPlus) continue;
                haveSeenPlus = true;
            }
            if (PhoneNumberUtils.isDialable(c)) {
                ret.append(c);
                continue;
            }
            if (PhoneNumberUtils.isStartsPostDial(c)) break;
        }
        return ret.toString();
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$stripSeparators(String phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        int len = phoneNumber.length();
        StringBuilder ret = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = phoneNumber.charAt(i);
            int digit = Character.digit(c, 10);
            if (digit != -1) {
                ret.append(digit);
                continue;
            }
            if (!PhoneNumberUtils.isNonSeparator(c)) continue;
            ret.append(c);
        }
        return ret.toString();
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$convertAndStrip(String phoneNumber) {
        return PhoneNumberUtils.stripSeparators(PhoneNumberUtils.convertKeypadLettersToDigits(phoneNumber));
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$convertPreDial(String phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        int len = phoneNumber.length();
        StringBuilder ret = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = phoneNumber.charAt(i);
            if (PhoneNumberUtils.isPause(c)) {
                c = ',';
            } else if (PhoneNumberUtils.isToneWait(c)) {
                c = ';';
            }
            ret.append(c);
        }
        return ret.toString();
    }

    private static final int $$robo$$android_telephony_PhoneNumberUtils$minPositive(int a, int b) {
        if (a >= 0 && b >= 0) {
            return a < b ? a : b;
        }
        if (a >= 0) {
            return a;
        }
        if (b >= 0) {
            return b;
        }
        return -1;
    }

    private static final void $$robo$$android_telephony_PhoneNumberUtils$log(String msg) {
        Rlog.d("PhoneNumberUtils", msg);
    }

    private static final int $$robo$$android_telephony_PhoneNumberUtils$indexOfLastNetworkChar(String a) {
        int wIndex;
        int origLength = a.length();
        int pIndex = a.indexOf(44);
        int trimIndex = PhoneNumberUtils.minPositive(pIndex, wIndex = a.indexOf(59));
        if (trimIndex < 0) {
            return origLength - 1;
        }
        return trimIndex - 1;
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$extractPostDialPortion(String phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        int trimIndex = PhoneNumberUtils.indexOfLastNetworkChar(phoneNumber);
        int s = phoneNumber.length();
        for (int i = trimIndex + 1; i < s; ++i) {
            char c = phoneNumber.charAt(i);
            if (!PhoneNumberUtils.isNonSeparator(c)) continue;
            ret.append(c);
        }
        return ret.toString();
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$compare(String a, String b) {
        return PhoneNumberUtils.compare(a, b, false);
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$compare(Context context, String a, String b) {
        boolean useStrict = context.getResources().getBoolean(17957051);
        return PhoneNumberUtils.compare(a, b, useStrict);
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$compare(String a, String b, boolean useStrictComparation) {
        return useStrictComparation ? PhoneNumberUtils.compareStrictly(a, b) : PhoneNumberUtils.compareLoosely(a, b);
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$compareLoosely(String a, String b) {
        int numNonDialableCharsInA = 0;
        int numNonDialableCharsInB = 0;
        if (a == null || b == null) {
            return a == b;
        }
        if (a.length() == 0 || b.length() == 0) {
            return false;
        }
        int ia = PhoneNumberUtils.indexOfLastNetworkChar(a);
        int ib = PhoneNumberUtils.indexOfLastNetworkChar(b);
        int matched = 0;
        while (ia >= 0 && ib >= 0) {
            char cb;
            boolean skipCmp = false;
            char ca = a.charAt(ia);
            if (!PhoneNumberUtils.isDialable(ca)) {
                --ia;
                skipCmp = true;
                ++numNonDialableCharsInA;
            }
            if (!PhoneNumberUtils.isDialable(cb = b.charAt(ib))) {
                --ib;
                skipCmp = true;
                ++numNonDialableCharsInB;
            }
            if (skipCmp) continue;
            if (cb != ca && ca != 'N' && cb != 'N') break;
            --ia;
            --ib;
            ++matched;
        }
        if (matched < 7) {
            int effectiveBLen;
            int effectiveALen = a.length() - numNonDialableCharsInA;
            return effectiveALen == (effectiveBLen = b.length() - numNonDialableCharsInB) && effectiveALen == matched;
        }
        if (matched >= 7 && (ia < 0 || ib < 0)) {
            return true;
        }
        if (PhoneNumberUtils.matchIntlPrefix(a, ia + 1) && PhoneNumberUtils.matchIntlPrefix(b, ib + 1)) {
            return true;
        }
        if (PhoneNumberUtils.matchTrunkPrefix(a, ia + 1) && PhoneNumberUtils.matchIntlPrefixAndCC(b, ib + 1)) {
            return true;
        }
        return PhoneNumberUtils.matchTrunkPrefix(b, ib + 1) && PhoneNumberUtils.matchIntlPrefixAndCC(a, ia + 1);
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$compareStrictly(String a, String b) {
        return PhoneNumberUtils.compareStrictly(a, b, true);
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$compareStrictly(String a, String b, boolean acceptInvalidCCCPrefix) {
        char chA;
        if (a == null || b == null) {
            return a == b;
        }
        if (a.length() == 0 && b.length() == 0) {
            return false;
        }
        int forwardIndexA = 0;
        int forwardIndexB = 0;
        CountryCallingCodeAndNewIndex cccA = PhoneNumberUtils.tryGetCountryCallingCodeAndNewIndex(a, acceptInvalidCCCPrefix);
        CountryCallingCodeAndNewIndex cccB = PhoneNumberUtils.tryGetCountryCallingCodeAndNewIndex(b, acceptInvalidCCCPrefix);
        boolean bothHasCountryCallingCode = false;
        boolean okToIgnorePrefix = true;
        boolean trunkPrefixIsOmittedA = false;
        boolean trunkPrefixIsOmittedB = false;
        if (cccA != null && cccB != null) {
            if (cccA.countryCallingCode != cccB.countryCallingCode) {
                return false;
            }
            okToIgnorePrefix = false;
            bothHasCountryCallingCode = true;
            forwardIndexA = cccA.newIndex;
            forwardIndexB = cccB.newIndex;
        } else if (cccA == null && cccB == null) {
            okToIgnorePrefix = false;
        } else {
            int tmp;
            if (cccA != null) {
                forwardIndexA = cccA.newIndex;
            } else {
                tmp = PhoneNumberUtils.tryGetTrunkPrefixOmittedIndex(b, 0);
                if (tmp >= 0) {
                    forwardIndexA = tmp;
                    trunkPrefixIsOmittedA = true;
                }
            }
            if (cccB != null) {
                forwardIndexB = cccB.newIndex;
            } else {
                tmp = PhoneNumberUtils.tryGetTrunkPrefixOmittedIndex(b, 0);
                if (tmp >= 0) {
                    forwardIndexB = tmp;
                    trunkPrefixIsOmittedB = true;
                }
            }
        }
        int backwardIndexA = a.length() - 1;
        int backwardIndexB = b.length() - 1;
        while (backwardIndexA >= forwardIndexA && backwardIndexB >= forwardIndexB) {
            boolean skip_compare = false;
            chA = a.charAt(backwardIndexA);
            char chB = b.charAt(backwardIndexB);
            if (PhoneNumberUtils.isSeparator(chA)) {
                --backwardIndexA;
                skip_compare = true;
            }
            if (PhoneNumberUtils.isSeparator(chB)) {
                --backwardIndexB;
                skip_compare = true;
            }
            if (skip_compare) continue;
            if (chA != chB) {
                return false;
            }
            --backwardIndexA;
            --backwardIndexB;
        }
        if (okToIgnorePrefix) {
            if (trunkPrefixIsOmittedA && forwardIndexA <= backwardIndexA || !PhoneNumberUtils.checkPrefixIsIgnorable(a, forwardIndexA, backwardIndexA)) {
                if (acceptInvalidCCCPrefix) {
                    return PhoneNumberUtils.compare(a, b, false);
                }
                return false;
            }
            if (trunkPrefixIsOmittedB && forwardIndexB <= backwardIndexB || !PhoneNumberUtils.checkPrefixIsIgnorable(b, forwardIndexA, backwardIndexB)) {
                if (acceptInvalidCCCPrefix) {
                    return PhoneNumberUtils.compare(a, b, false);
                }
                return false;
            }
        } else {
            boolean maybeNamp;
            boolean bl = maybeNamp = !bothHasCountryCallingCode;
            while (backwardIndexA >= forwardIndexA) {
                chA = a.charAt(backwardIndexA);
                if (PhoneNumberUtils.isDialable(chA)) {
                    if (maybeNamp && PhoneNumberUtils.tryGetISODigit(chA) == 1) {
                        maybeNamp = false;
                    } else {
                        return false;
                    }
                }
                --backwardIndexA;
            }
            while (backwardIndexB >= forwardIndexB) {
                char chB = b.charAt(backwardIndexB);
                if (PhoneNumberUtils.isDialable(chB)) {
                    if (maybeNamp && PhoneNumberUtils.tryGetISODigit(chB) == 1) {
                        maybeNamp = false;
                    } else {
                        return false;
                    }
                }
                --backwardIndexB;
            }
        }
        return true;
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$toCallerIDMinMatch(String phoneNumber) {
        String np = PhoneNumberUtils.extractNetworkPortionAlt(phoneNumber);
        return PhoneNumberUtils.internalGetStrippedReversed(np, 7);
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$getStrippedReversed(String phoneNumber) {
        String np = PhoneNumberUtils.extractNetworkPortionAlt(phoneNumber);
        if (np == null) {
            return null;
        }
        return PhoneNumberUtils.internalGetStrippedReversed(np, np.length());
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$internalGetStrippedReversed(String np, int numDigits) {
        if (np == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder(numDigits);
        int length = np.length();
        int s = length;
        for (int i = length - 1; i >= 0 && s - i <= numDigits; --i) {
            char c = np.charAt(i);
            ret.append(c);
        }
        return ret.toString();
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$stringFromStringAndTOA(String s, int TOA) {
        if (s == null) {
            return null;
        }
        if (TOA == 145 && s.length() > 0 && s.charAt(0) != '+') {
            return "+" + s;
        }
        return s;
    }

    private static final int $$robo$$android_telephony_PhoneNumberUtils$toaFromString(String s) {
        if (s != null && s.length() > 0 && s.charAt(0) == '+') {
            return 145;
        }
        return 129;
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$calledPartyBCDToString(byte[] bytes, int offset, int length) {
        boolean prependPlus = false;
        StringBuilder ret = new StringBuilder(1 + length * 2);
        if (length < 2) {
            return "";
        }
        if ((bytes[offset] & 0xF0) == 144) {
            prependPlus = true;
        }
        PhoneNumberUtils.internalCalledPartyBCDFragmentToString(ret, bytes, offset + 1, length - 1);
        if (prependPlus && ret.length() == 0) {
            return "";
        }
        if (prependPlus) {
            String retString = ret.toString();
            Pattern p = Pattern.compile("(^[#*])(.*)([#*])(.*)(#)$");
            Matcher m = p.matcher(retString);
            if (m.matches()) {
                if ("".equals(m.group(2))) {
                    ret = new StringBuilder();
                    ret.append(m.group(1));
                    ret.append(m.group(3));
                    ret.append(m.group(4));
                    ret.append(m.group(5));
                    ret.append("+");
                } else {
                    ret = new StringBuilder();
                    ret.append(m.group(1));
                    ret.append(m.group(2));
                    ret.append(m.group(3));
                    ret.append("+");
                    ret.append(m.group(4));
                    ret.append(m.group(5));
                }
            } else {
                p = Pattern.compile("(^[#*])(.*)([#*])(.*)");
                m = p.matcher(retString);
                if (m.matches()) {
                    ret = new StringBuilder();
                    ret.append(m.group(1));
                    ret.append(m.group(2));
                    ret.append(m.group(3));
                    ret.append("+");
                    ret.append(m.group(4));
                } else {
                    ret = new StringBuilder();
                    ret.append('+');
                    ret.append(retString);
                }
            }
        }
        return ret.toString();
    }

    private static final void $$robo$$android_telephony_PhoneNumberUtils$internalCalledPartyBCDFragmentToString(StringBuilder sb, byte[] bytes, int offset, int length) {
        for (int i = offset; i < length + offset; ++i) {
            char c = PhoneNumberUtils.bcdToChar((byte)(bytes[i] & 0xF));
            if (c == '\u0000') {
                return;
            }
            sb.append(c);
            byte b = (byte)(bytes[i] >> 4 & 0xF);
            if (b == 15 && i + 1 == length + offset) break;
            c = PhoneNumberUtils.bcdToChar(b);
            if (c == '\u0000') {
                return;
            }
            sb.append(c);
        }
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$calledPartyBCDFragmentToString(byte[] bytes, int offset, int length) {
        StringBuilder ret = new StringBuilder(length * 2);
        PhoneNumberUtils.internalCalledPartyBCDFragmentToString(ret, bytes, offset, length);
        return ret.toString();
    }

    private static final char $$robo$$android_telephony_PhoneNumberUtils$bcdToChar(byte b) {
        if (b < 10) {
            return (char)(48 + b);
        }
        switch (b) {
            case 10: {
                return '*';
            }
            case 11: {
                return '#';
            }
            case 12: {
                return ',';
            }
            case 13: {
                return 'N';
            }
        }
        return '\u0000';
    }

    private static final int $$robo$$android_telephony_PhoneNumberUtils$charToBCD(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c == '*') {
            return 10;
        }
        if (c == '#') {
            return 11;
        }
        if (c == ',') {
            return 12;
        }
        if (c == 'N') {
            return 13;
        }
        if (c == ';') {
            return 14;
        }
        throw new RuntimeException("invalid char for BCD " + c);
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isWellFormedSmsAddress(String address) {
        String networkPortion = PhoneNumberUtils.extractNetworkPortion(address);
        return !networkPortion.equals("+") && !TextUtils.isEmpty(networkPortion) && PhoneNumberUtils.isDialable(networkPortion);
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isGlobalPhoneNumber(String phoneNumber) {
        if (TextUtils.isEmpty(phoneNumber)) {
            return false;
        }
        Matcher match = GLOBAL_PHONE_NUMBER_PATTERN.matcher(phoneNumber);
        return match.matches();
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isDialable(String address) {
        int count = address.length();
        for (int i = 0; i < count; ++i) {
            if (PhoneNumberUtils.isDialable(address.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isNonSeparator(String address) {
        int count = address.length();
        for (int i = 0; i < count; ++i) {
            if (PhoneNumberUtils.isNonSeparator(address.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static final byte[] $$robo$$android_telephony_PhoneNumberUtils$networkPortionToCalledPartyBCD(String s) {
        String networkPortion = PhoneNumberUtils.extractNetworkPortion(s);
        return PhoneNumberUtils.numberToCalledPartyBCDHelper(networkPortion, false);
    }

    private static final byte[] $$robo$$android_telephony_PhoneNumberUtils$networkPortionToCalledPartyBCDWithLength(String s) {
        String networkPortion = PhoneNumberUtils.extractNetworkPortion(s);
        return PhoneNumberUtils.numberToCalledPartyBCDHelper(networkPortion, true);
    }

    private static final byte[] $$robo$$android_telephony_PhoneNumberUtils$numberToCalledPartyBCD(String number) {
        return PhoneNumberUtils.numberToCalledPartyBCDHelper(number, false);
    }

    private static final byte[] $$robo$$android_telephony_PhoneNumberUtils$numberToCalledPartyBCDHelper(String number, boolean includeLength) {
        boolean hasPlus;
        int numberLenReal;
        int numberLenEffective = numberLenReal = number.length();
        boolean bl = hasPlus = number.indexOf(43) != -1;
        if (hasPlus) {
            --numberLenEffective;
        }
        if (numberLenEffective == 0) {
            return null;
        }
        int resultLen = (numberLenEffective + 1) / 2;
        int extraBytes = 1;
        if (includeLength) {
            ++extraBytes;
        }
        byte[] result = new byte[resultLen += extraBytes];
        int digitCount = 0;
        for (int i = 0; i < numberLenReal; ++i) {
            char c = number.charAt(i);
            if (c == '+') continue;
            int shift = digitCount & true ? 4 : 0;
            int n = extraBytes + (digitCount >> 1);
            result[n] = (byte)(result[n] | (byte)((PhoneNumberUtils.charToBCD(c) & 0xF) << shift));
            ++digitCount;
        }
        if (digitCount & true) {
            int n = extraBytes + (digitCount >> 1);
            result[n] = (byte)(result[n] | 0xF0);
        }
        int offset = 0;
        if (includeLength) {
            result[offset++] = (byte)(resultLen - 1);
        }
        result[offset] = (byte)(hasPlus ? 145 : 129);
        return result;
    }

    @Deprecated
    private static final String $$robo$$android_telephony_PhoneNumberUtils$formatNumber(String source) {
        SpannableStringBuilder text = new SpannableStringBuilder(source);
        PhoneNumberUtils.formatNumber(text, PhoneNumberUtils.getFormatTypeForLocale(Locale.getDefault()));
        return text.toString();
    }

    @Deprecated
    private static final String $$robo$$android_telephony_PhoneNumberUtils$formatNumber(String source, int defaultFormattingType) {
        SpannableStringBuilder text = new SpannableStringBuilder(source);
        PhoneNumberUtils.formatNumber(text, defaultFormattingType);
        return text.toString();
    }

    @Deprecated
    private static final int $$robo$$android_telephony_PhoneNumberUtils$getFormatTypeForLocale(Locale locale) {
        String country = locale.getCountry();
        return PhoneNumberUtils.getFormatTypeFromCountryCode(country);
    }

    @Deprecated
    private static final void $$robo$$android_telephony_PhoneNumberUtils$formatNumber(Editable text, int defaultFormattingType) {
        int formatType = defaultFormattingType;
        if (text.length() > 2 && text.charAt(0) == '+') {
            formatType = text.charAt(1) == '1' ? 1 : (text.length() >= 3 && text.charAt(1) == '8' && text.charAt(2) == '1' ? 2 : 0);
        }
        switch (formatType) {
            case 1: {
                PhoneNumberUtils.formatNanpNumber(text);
                return;
            }
            case 2: {
                PhoneNumberUtils.formatJapaneseNumber(text);
                return;
            }
            case 0: {
                PhoneNumberUtils.removeDashes(text);
                return;
            }
        }
    }

    @Deprecated
    private static final void $$robo$$android_telephony_PhoneNumberUtils$formatNanpNumber(Editable text) {
        int i;
        int length = text.length();
        if (length > "+1-nnn-nnn-nnnn".length()) {
            return;
        }
        if (length <= 5) {
            return;
        }
        CharSequence saved = text.subSequence(0, length);
        PhoneNumberUtils.removeDashes(text);
        length = text.length();
        int[] dashPositions = new int[3];
        int numDashes = 0;
        int state = 1;
        int numDigits = 0;
        block6: for (i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '1': {
                    if (numDigits == 0 || state == 2) {
                        state = 3;
                        continue block6;
                    }
                }
                case '0': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (state == 2) {
                        text.replace(0, length, saved);
                        return;
                    }
                    if (state == 3) {
                        dashPositions[numDashes++] = i;
                    } else if (state != 4 && (numDigits == 3 || numDigits == 6)) {
                        dashPositions[numDashes++] = i;
                    }
                    state = 1;
                    ++numDigits;
                    continue block6;
                }
                case '-': {
                    state = 4;
                    continue block6;
                }
                case '+': {
                    if (i == 0) {
                        state = 2;
                        continue block6;
                    }
                }
                default: {
                    text.replace(0, length, saved);
                    return;
                }
            }
        }
        if (numDigits == 7) {
            --numDashes;
        }
        for (i = 0; i < numDashes; ++i) {
            int pos = dashPositions[i];
            text.replace(pos + i, pos + i, "-");
        }
        for (int len = text.length(); len > 0 && text.charAt(len - 1) == '-'; --len) {
            text.delete(len - 1, len);
        }
    }

    @Deprecated
    private static final void $$robo$$android_telephony_PhoneNumberUtils$formatJapaneseNumber(Editable text) {
        JapanesePhoneNumberFormatter.format(text);
    }

    private static final void $$robo$$android_telephony_PhoneNumberUtils$removeDashes(Editable text) {
        int p = 0;
        while (p < text.length()) {
            if (text.charAt(p) == '-') {
                text.delete(p, p + 1);
                continue;
            }
            ++p;
        }
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$formatNumberToE164(String phoneNumber, String defaultCountryIso) {
        return PhoneNumberUtils.formatNumberInternal(phoneNumber, defaultCountryIso, PhoneNumberUtil.PhoneNumberFormat.E164);
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$formatNumberToRFC3966(String phoneNumber, String defaultCountryIso) {
        return PhoneNumberUtils.formatNumberInternal(phoneNumber, defaultCountryIso, PhoneNumberUtil.PhoneNumberFormat.RFC3966);
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$formatNumberInternal(String rawPhoneNumber, String defaultCountryIso, PhoneNumberUtil.PhoneNumberFormat formatIdentifier) {
        PhoneNumberUtil util = PhoneNumberUtil.getInstance();
        try {
            Phonenumber.PhoneNumber phoneNumber = util.parse(rawPhoneNumber, defaultCountryIso);
            if (util.isValidNumber(phoneNumber)) {
                return util.format(phoneNumber, formatIdentifier);
            }
        }
        catch (NumberParseException numberParseException) {
            // empty catch block
        }
        return null;
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isInternationalNumber(String phoneNumber, String defaultCountryIso) {
        if (TextUtils.isEmpty(phoneNumber)) {
            return false;
        }
        if (phoneNumber.startsWith("#") || phoneNumber.startsWith("*")) {
            return false;
        }
        PhoneNumberUtil util = PhoneNumberUtil.getInstance();
        try {
            Phonenumber.PhoneNumber pn = util.parseAndKeepRawInput(phoneNumber, defaultCountryIso);
            return pn.getCountryCode() != util.getCountryCodeForRegion(defaultCountryIso);
        }
        catch (NumberParseException e) {
            return false;
        }
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$formatNumber(String phoneNumber, String defaultCountryIso) {
        if (phoneNumber.startsWith("#") || phoneNumber.startsWith("*")) {
            return phoneNumber;
        }
        PhoneNumberUtil util = PhoneNumberUtil.getInstance();
        String result = null;
        try {
            Phonenumber.PhoneNumber pn = util.parseAndKeepRawInput(phoneNumber, defaultCountryIso);
            result = "KR".equalsIgnoreCase(defaultCountryIso) && pn.getCountryCode() == util.getCountryCodeForRegion("KR") && pn.getCountryCodeSource() == Phonenumber.PhoneNumber.CountryCodeSource.FROM_NUMBER_WITH_PLUS_SIGN ? util.format(pn, PhoneNumberUtil.PhoneNumberFormat.NATIONAL) : ("JP".equalsIgnoreCase(defaultCountryIso) && pn.getCountryCode() == util.getCountryCodeForRegion("JP") && pn.getCountryCodeSource() == Phonenumber.PhoneNumber.CountryCodeSource.FROM_NUMBER_WITH_PLUS_SIGN ? util.format(pn, PhoneNumberUtil.PhoneNumberFormat.NATIONAL) : util.formatInOriginalFormat(pn, defaultCountryIso));
        }
        catch (NumberParseException numberParseException) {
            // empty catch block
        }
        return result;
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$formatNumber(String phoneNumber, String phoneNumberE164, String defaultCountryIso) {
        String result;
        int len = phoneNumber.length();
        for (int i = 0; i < len; ++i) {
            if (PhoneNumberUtils.isDialable(phoneNumber.charAt(i))) continue;
            return phoneNumber;
        }
        PhoneNumberUtil util = PhoneNumberUtil.getInstance();
        if (phoneNumberE164 != null && phoneNumberE164.length() >= 2 && phoneNumberE164.charAt(0) == '+') {
            try {
                Phonenumber.PhoneNumber pn = util.parse(phoneNumberE164, "ZZ");
                String regionCode = util.getRegionCodeForNumber(pn);
                if (!TextUtils.isEmpty(regionCode) && PhoneNumberUtils.normalizeNumber(phoneNumber).indexOf(phoneNumberE164.substring(1)) <= 0) {
                    defaultCountryIso = regionCode;
                }
            }
            catch (NumberParseException pn) {
                // empty catch block
            }
        }
        return (result = PhoneNumberUtils.formatNumber(phoneNumber, defaultCountryIso)) != null ? result : phoneNumber;
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$normalizeNumber(String phoneNumber) {
        if (TextUtils.isEmpty(phoneNumber)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int len = phoneNumber.length();
        for (int i = 0; i < len; ++i) {
            char c = phoneNumber.charAt(i);
            int digit = Character.digit(c, 10);
            if (digit != -1) {
                sb.append(digit);
                continue;
            }
            if (sb.length() == 0 && c == '+') {
                sb.append(c);
                continue;
            }
            if ((c < 'a' || c > 'z') && (c < 'A' || c > 'Z')) continue;
            return PhoneNumberUtils.normalizeNumber(PhoneNumberUtils.convertKeypadLettersToDigits(phoneNumber));
        }
        return sb.toString();
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$replaceUnicodeDigits(String number) {
        StringBuilder normalizedDigits = new StringBuilder(number.length());
        for (char c : number.toCharArray()) {
            int digit = Character.digit(c, 10);
            if (digit != -1) {
                normalizedDigits.append(digit);
                continue;
            }
            normalizedDigits.append(c);
        }
        return normalizedDigits.toString();
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isEmergencyNumber(String number) {
        return PhoneNumberUtils.isEmergencyNumber(PhoneNumberUtils.getDefaultVoiceSubId(), number);
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isEmergencyNumber(int subId, String number) {
        return PhoneNumberUtils.isEmergencyNumberInternal(subId, number, true);
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isPotentialEmergencyNumber(String number) {
        return PhoneNumberUtils.isPotentialEmergencyNumber(PhoneNumberUtils.getDefaultVoiceSubId(), number);
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isPotentialEmergencyNumber(int subId, String number) {
        return PhoneNumberUtils.isEmergencyNumberInternal(subId, number, false);
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isEmergencyNumberInternal(String number, boolean useExactMatch) {
        return PhoneNumberUtils.isEmergencyNumberInternal(PhoneNumberUtils.getDefaultVoiceSubId(), number, useExactMatch);
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isEmergencyNumberInternal(int subId, String number, boolean useExactMatch) {
        return PhoneNumberUtils.isEmergencyNumberInternal(subId, number, null, useExactMatch);
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isEmergencyNumber(String number, String defaultCountryIso) {
        return PhoneNumberUtils.isEmergencyNumber(PhoneNumberUtils.getDefaultVoiceSubId(), number, defaultCountryIso);
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isEmergencyNumber(int subId, String number, String defaultCountryIso) {
        return PhoneNumberUtils.isEmergencyNumberInternal(subId, number, defaultCountryIso, true);
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isPotentialEmergencyNumber(String number, String defaultCountryIso) {
        return PhoneNumberUtils.isPotentialEmergencyNumber(PhoneNumberUtils.getDefaultVoiceSubId(), number, defaultCountryIso);
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isPotentialEmergencyNumber(int subId, String number, String defaultCountryIso) {
        return PhoneNumberUtils.isEmergencyNumberInternal(subId, number, defaultCountryIso, false);
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isEmergencyNumberInternal(String number, String defaultCountryIso, boolean useExactMatch) {
        return PhoneNumberUtils.isEmergencyNumberInternal(PhoneNumberUtils.getDefaultVoiceSubId(), number, defaultCountryIso, useExactMatch);
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isEmergencyNumberInternal(int subId, String number, String defaultCountryIso, boolean useExactMatch) {
        if (number == null) {
            return false;
        }
        if (PhoneNumberUtils.isUriNumber(number)) {
            return false;
        }
        number = PhoneNumberUtils.extractNetworkPortionAlt(number);
        String emergencyNumbers = "";
        int slotId = SubscriptionManager.getSlotIndex(subId);
        String ecclist = slotId <= 0 ? "ril.ecclist" : "ril.ecclist" + slotId;
        emergencyNumbers = SystemProperties.get(ecclist, "");
        Rlog.d("PhoneNumberUtils", "slotId:" + slotId + " subId:" + subId + " country:" + defaultCountryIso + " emergencyNumbers: " + emergencyNumbers);
        if (TextUtils.isEmpty(emergencyNumbers)) {
            emergencyNumbers = SystemProperties.get("ro.ril.ecclist");
        }
        if (!TextUtils.isEmpty(emergencyNumbers)) {
            for (String emergencyNum : emergencyNumbers.split(",")) {
                if (!(useExactMatch || "BR".equalsIgnoreCase(defaultCountryIso) ? number.equals(emergencyNum) : number.startsWith(emergencyNum))) continue;
                return true;
            }
            return false;
        }
        Rlog.d("PhoneNumberUtils", "System property doesn't provide any emergency numbers. Use embedded logic for determining ones.");
        emergencyNumbers = slotId < 0 ? "112,911,000,08,110,118,119,999" : "112,911";
        for (String emergencyNum : emergencyNumbers.split(",")) {
            if (!(useExactMatch ? number.equals(emergencyNum) : number.startsWith(emergencyNum))) continue;
            return true;
        }
        if (defaultCountryIso != null) {
            ShortNumberInfo info = ShortNumberInfo.getInstance();
            if (useExactMatch) {
                return info.isEmergencyNumber(number, defaultCountryIso);
            }
            return info.connectsToEmergencyNumber(number, defaultCountryIso);
        }
        return false;
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isLocalEmergencyNumber(Context context, String number) {
        return PhoneNumberUtils.isLocalEmergencyNumber(context, PhoneNumberUtils.getDefaultVoiceSubId(), number);
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isLocalEmergencyNumber(Context context, int subId, String number) {
        return PhoneNumberUtils.isLocalEmergencyNumberInternal(subId, number, context, true);
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isPotentialLocalEmergencyNumber(Context context, String number) {
        return PhoneNumberUtils.isPotentialLocalEmergencyNumber(context, PhoneNumberUtils.getDefaultVoiceSubId(), number);
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isPotentialLocalEmergencyNumber(Context context, int subId, String number) {
        return PhoneNumberUtils.isLocalEmergencyNumberInternal(subId, number, context, false);
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isLocalEmergencyNumberInternal(String number, Context context, boolean useExactMatch) {
        return PhoneNumberUtils.isLocalEmergencyNumberInternal(PhoneNumberUtils.getDefaultVoiceSubId(), number, context, useExactMatch);
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isLocalEmergencyNumberInternal(int subId, String number, Context context, boolean useExactMatch) {
        String countryIso;
        CountryDetector detector = (CountryDetector)context.getSystemService("country_detector");
        if (detector != null && detector.detectCountry() != null) {
            countryIso = detector.detectCountry().getCountryIso();
        } else {
            Locale locale = context.getResources().getConfiguration().locale;
            countryIso = locale.getCountry();
            Rlog.w("PhoneNumberUtils", "No CountryDetector; falling back to countryIso based on locale: " + countryIso);
        }
        return PhoneNumberUtils.isEmergencyNumberInternal(subId, number, countryIso, useExactMatch);
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isVoiceMailNumber(String number) {
        return PhoneNumberUtils.isVoiceMailNumber(SubscriptionManager.getDefaultSubscriptionId(), number);
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isVoiceMailNumber(int subId, String number) {
        return PhoneNumberUtils.isVoiceMailNumber(null, subId, number);
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isVoiceMailNumber(Context context, int subId, String number) {
        PersistableBundle b;
        CarrierConfigManager configManager;
        String mdn;
        String vmNumber;
        try {
            TelephonyManager tm = context == null ? TelephonyManager.getDefault() : TelephonyManager.from(context);
            vmNumber = tm.getVoiceMailNumber(subId);
            mdn = tm.getLine1Number(subId);
        }
        catch (SecurityException ex) {
            return false;
        }
        number = PhoneNumberUtils.extractNetworkPortionAlt(number);
        if (TextUtils.isEmpty(number)) {
            return false;
        }
        boolean compareWithMdn = false;
        if (context != null && (configManager = (CarrierConfigManager)context.getSystemService("carrier_config")) != null && (b = configManager.getConfigForSubId(subId)) != null) {
            compareWithMdn = b.getBoolean("mdn_is_additional_voicemail_number_bool");
        }
        if (compareWithMdn) {
            return PhoneNumberUtils.compare(number, vmNumber) || PhoneNumberUtils.compare(number, mdn);
        }
        return PhoneNumberUtils.compare(number, vmNumber);
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$convertKeypadLettersToDigits(String input) {
        if (input == null) {
            return input;
        }
        int len = input.length();
        if (len == 0) {
            return input;
        }
        char[] out = input.toCharArray();
        for (int i = 0; i < len; ++i) {
            char c = out[i];
            out[i] = (char)KEYPAD_MAP.get(c, c);
        }
        return new String(out);
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$cdmaCheckAndProcessPlusCode(String dialStr) {
        if (!TextUtils.isEmpty(dialStr) && PhoneNumberUtils.isReallyDialable(dialStr.charAt(0)) && PhoneNumberUtils.isNonSeparator(dialStr)) {
            String currIso = TelephonyManager.getDefault().getNetworkCountryIso();
            String defaultIso = TelephonyManager.getDefault().getSimCountryIso();
            if (!TextUtils.isEmpty(currIso) && !TextUtils.isEmpty(defaultIso)) {
                return PhoneNumberUtils.cdmaCheckAndProcessPlusCodeByNumberFormat(dialStr, PhoneNumberUtils.getFormatTypeFromCountryCode(currIso), PhoneNumberUtils.getFormatTypeFromCountryCode(defaultIso));
            }
        }
        return dialStr;
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$cdmaCheckAndProcessPlusCodeForSms(String dialStr) {
        String defaultIso;
        if (!TextUtils.isEmpty(dialStr) && PhoneNumberUtils.isReallyDialable(dialStr.charAt(0)) && PhoneNumberUtils.isNonSeparator(dialStr) && !TextUtils.isEmpty(defaultIso = TelephonyManager.getDefault().getSimCountryIso())) {
            int format = PhoneNumberUtils.getFormatTypeFromCountryCode(defaultIso);
            return PhoneNumberUtils.cdmaCheckAndProcessPlusCodeByNumberFormat(dialStr, format, format);
        }
        return dialStr;
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$cdmaCheckAndProcessPlusCodeByNumberFormat(String dialStr, int currFormat, int defaultFormat) {
        boolean useNanp;
        String retStr = dialStr;
        boolean bl = useNanp = currFormat == defaultFormat && currFormat == 1;
        if (dialStr != null && dialStr.lastIndexOf("+") != -1) {
            String postDialStr = null;
            String tempDialStr = dialStr;
            retStr = null;
            do {
                String networkDialStr = useNanp ? PhoneNumberUtils.extractNetworkPortion(tempDialStr) : PhoneNumberUtils.extractNetworkPortionAlt(tempDialStr);
                if (!TextUtils.isEmpty(networkDialStr = PhoneNumberUtils.processPlusCode(networkDialStr, useNanp))) {
                    retStr = retStr == null ? networkDialStr : retStr.concat(networkDialStr);
                } else {
                    Rlog.e("checkAndProcessPlusCode: null newDialStr", networkDialStr);
                    return dialStr;
                }
                postDialStr = PhoneNumberUtils.extractPostDialPortion(tempDialStr);
                if (TextUtils.isEmpty(postDialStr)) continue;
                int dialableIndex = PhoneNumberUtils.findDialableIndexFromPostDialStr(postDialStr);
                if (dialableIndex >= 1) {
                    retStr = PhoneNumberUtils.appendPwCharBackToOrigDialStr(dialableIndex, retStr, postDialStr);
                    tempDialStr = postDialStr.substring(dialableIndex);
                    continue;
                }
                if (dialableIndex < 0) {
                    postDialStr = "";
                }
                Rlog.e("wrong postDialStr=", postDialStr);
            } while (!TextUtils.isEmpty(postDialStr) && !TextUtils.isEmpty(tempDialStr));
        }
        return retStr;
    }

    private static final CharSequence $$robo$$android_telephony_PhoneNumberUtils$createTtsSpannable(CharSequence phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        Spannable spannable = Spannable.Factory.getInstance().newSpannable(phoneNumber);
        PhoneNumberUtils.addTtsSpan(spannable, 0, spannable.length());
        return spannable;
    }

    private static final void $$robo$$android_telephony_PhoneNumberUtils$addTtsSpan(Spannable s, int start, int endExclusive) {
        s.setSpan(PhoneNumberUtils.createTtsSpan(s.subSequence(start, endExclusive).toString()), start, endExclusive, 33);
    }

    @Deprecated
    private static final CharSequence $$robo$$android_telephony_PhoneNumberUtils$ttsSpanAsPhoneNumber(CharSequence phoneNumber) {
        return PhoneNumberUtils.createTtsSpannable(phoneNumber);
    }

    @Deprecated
    private static final void $$robo$$android_telephony_PhoneNumberUtils$ttsSpanAsPhoneNumber(Spannable s, int start, int end) {
        PhoneNumberUtils.addTtsSpan(s, start, end);
    }

    private static final TtsSpan $$robo$$android_telephony_PhoneNumberUtils$createTtsSpan(String phoneNumberString) {
        if (phoneNumberString == null) {
            return null;
        }
        PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
        Phonenumber.PhoneNumber phoneNumber = null;
        try {
            phoneNumber = phoneNumberUtil.parse(phoneNumberString, null);
        }
        catch (NumberParseException numberParseException) {
            // empty catch block
        }
        TtsSpan.TelephoneBuilder builder = new TtsSpan.TelephoneBuilder();
        if (phoneNumber == null) {
            builder.setNumberParts(PhoneNumberUtils.splitAtNonNumerics(phoneNumberString));
        } else {
            if (phoneNumber.hasCountryCode()) {
                builder.setCountryCode(Integer.toString(phoneNumber.getCountryCode()));
            }
            builder.setNumberParts(Long.toString(phoneNumber.getNationalNumber()));
        }
        return builder.build();
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$splitAtNonNumerics(CharSequence number) {
        StringBuilder sb = new StringBuilder(number.length());
        for (int i = 0; i < number.length(); ++i) {
            sb.append(PhoneNumberUtils.is12Key(number.charAt(i)) ? Character.valueOf(number.charAt(i)) : " ");
        }
        return sb.toString().replaceAll(" +", " ").trim();
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$getCurrentIdp(boolean useNanp) {
        String ps = null;
        ps = useNanp ? "011" : SystemProperties.get("gsm.operator.idpstring", "+");
        return ps;
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isTwoToNine(char c) {
        return c >= '2' && c <= '9';
    }

    private static final int $$robo$$android_telephony_PhoneNumberUtils$getFormatTypeFromCountryCode(String country) {
        int length = NANP_COUNTRIES.length;
        for (int i = 0; i < length; ++i) {
            if (NANP_COUNTRIES[i].compareToIgnoreCase(country) != 0) continue;
            return 1;
        }
        if ("jp".compareToIgnoreCase(country) == 0) {
            return 2;
        }
        return 0;
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isNanp(String dialStr) {
        boolean retVal = false;
        if (dialStr != null) {
            if (dialStr.length() == 10 && PhoneNumberUtils.isTwoToNine(dialStr.charAt(0)) && PhoneNumberUtils.isTwoToNine(dialStr.charAt(3))) {
                retVal = true;
                for (int i = 1; i < 10; ++i) {
                    char c = dialStr.charAt(i);
                    if (PhoneNumberUtils.isISODigit(c)) continue;
                    retVal = false;
                    break;
                }
            }
        } else {
            Rlog.e("isNanp: null dialStr passed in", dialStr);
        }
        return retVal;
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isOneNanp(String dialStr) {
        boolean retVal = false;
        if (dialStr != null) {
            String newDialStr = dialStr.substring(1);
            if (dialStr.charAt(0) == '1' && PhoneNumberUtils.isNanp(newDialStr)) {
                retVal = true;
            }
        } else {
            Rlog.e("isOneNanp: null dialStr passed in", dialStr);
        }
        return retVal;
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isUriNumber(String number) {
        return number != null && (number.contains("@") || number.contains("%40"));
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$getUsernameFromUriNumber(String number) {
        int delimiterIndex = number.indexOf(64);
        if (delimiterIndex < 0) {
            delimiterIndex = number.indexOf("%40");
        }
        if (delimiterIndex < 0) {
            Rlog.w("PhoneNumberUtils", "getUsernameFromUriNumber: no delimiter found in SIP addr '" + number + "'");
            delimiterIndex = number.length();
        }
        return number.substring(0, delimiterIndex);
    }

    private static final Uri $$robo$$android_telephony_PhoneNumberUtils$convertSipUriToTelUri(Uri source) {
        String scheme = source.getScheme();
        if (!"sip".equals(scheme)) {
            return source;
        }
        String number = source.getSchemeSpecificPart();
        String[] numberParts = number.split("[@;:]");
        if (numberParts.length == 0) {
            return source;
        }
        number = numberParts[0];
        return Uri.fromParts("tel", number, null);
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$processPlusCode(String networkDialStr, boolean useNanp) {
        String retStr = networkDialStr;
        if (networkDialStr != null && networkDialStr.charAt(0) == '+' && networkDialStr.length() > 1) {
            String newStr = networkDialStr.substring(1);
            retStr = useNanp && PhoneNumberUtils.isOneNanp(newStr) ? newStr : networkDialStr.replaceFirst("[+]", PhoneNumberUtils.getCurrentIdp(useNanp));
        }
        return retStr;
    }

    private static final int $$robo$$android_telephony_PhoneNumberUtils$findDialableIndexFromPostDialStr(String postDialStr) {
        for (int index = 0; index < postDialStr.length(); ++index) {
            char c = postDialStr.charAt(index);
            if (!PhoneNumberUtils.isReallyDialable(c)) continue;
            return index;
        }
        return -1;
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$appendPwCharBackToOrigDialStr(int dialableIndex, String origStr, String dialStr) {
        String retStr;
        if (dialableIndex == 1) {
            StringBuilder ret = new StringBuilder(origStr);
            ret = ret.append(dialStr.charAt(0));
            retStr = ret.toString();
        } else {
            String nonDigitStr = dialStr.substring(0, dialableIndex);
            retStr = origStr.concat(nonDigitStr);
        }
        return retStr;
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$matchIntlPrefix(String a, int len) {
        int state = 0;
        block5: for (int i = 0; i < len; ++i) {
            char c = a.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '+') {
                        state = 1;
                        continue block5;
                    }
                    if (c == '0') {
                        state = 2;
                        continue block5;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block5;
                    return false;
                }
                case 2: {
                    if (c == '0') {
                        state = 3;
                        continue block5;
                    }
                    if (c == '1') {
                        state = 4;
                        continue block5;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block5;
                    return false;
                }
                case 4: {
                    if (c == '1') {
                        state = 5;
                        continue block5;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block5;
                    return false;
                }
                default: {
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block5;
                    return false;
                }
            }
        }
        return state == 1 || state == 3 || state == 5;
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$matchIntlPrefixAndCC(String a, int len) {
        int state = 0;
        block7: for (int i = 0; i < len; ++i) {
            char c = a.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '+') {
                        state = 1;
                        continue block7;
                    }
                    if (c == '0') {
                        state = 2;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                case 2: {
                    if (c == '0') {
                        state = 3;
                        continue block7;
                    }
                    if (c == '1') {
                        state = 4;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                case 4: {
                    if (c == '1') {
                        state = 5;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                case 1: 
                case 3: 
                case 5: {
                    if (PhoneNumberUtils.isISODigit(c)) {
                        state = 6;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                case 6: 
                case 7: {
                    if (PhoneNumberUtils.isISODigit(c)) {
                        ++state;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                default: {
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
            }
        }
        return state == 6 || state == 7 || state == 8;
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$matchTrunkPrefix(String a, int len) {
        boolean found = false;
        for (int i = 0; i < len; ++i) {
            char c = a.charAt(i);
            if (c == '0' && !found) {
                found = true;
                continue;
            }
            if (!PhoneNumberUtils.isNonSeparator(c)) continue;
            return false;
        }
        return found;
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$isCountryCallingCode(int countryCallingCodeCandidate) {
        return countryCallingCodeCandidate > 0 && countryCallingCodeCandidate < CCC_LENGTH && COUNTRY_CALLING_CALL[countryCallingCodeCandidate];
    }

    private static final int $$robo$$android_telephony_PhoneNumberUtils$tryGetISODigit(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        return -1;
    }

    private static final CountryCallingCodeAndNewIndex $$robo$$android_telephony_PhoneNumberUtils$tryGetCountryCallingCodeAndNewIndex(String str, boolean acceptThailandCase) {
        int state = 0;
        int ccc = 0;
        int length = str.length();
        block8: for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            switch (state) {
                case 0: {
                    if (ch == '+') {
                        state = 1;
                        continue block8;
                    }
                    if (ch == '0') {
                        state = 2;
                        continue block8;
                    }
                    if (ch == '1') {
                        if (acceptThailandCase) {
                            state = 8;
                            continue block8;
                        }
                        return null;
                    }
                    if (!PhoneNumberUtils.isDialable(ch)) continue block8;
                    return null;
                }
                case 2: {
                    if (ch == '0') {
                        state = 3;
                        continue block8;
                    }
                    if (ch == '1') {
                        state = 4;
                        continue block8;
                    }
                    if (!PhoneNumberUtils.isDialable(ch)) continue block8;
                    return null;
                }
                case 4: {
                    if (ch == '1') {
                        state = 5;
                        continue block8;
                    }
                    if (!PhoneNumberUtils.isDialable(ch)) continue block8;
                    return null;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    int ret = PhoneNumberUtils.tryGetISODigit(ch);
                    if (ret > 0) {
                        if ((ccc = ccc * 10 + ret) >= 100 || PhoneNumberUtils.isCountryCallingCode(ccc)) {
                            return new CountryCallingCodeAndNewIndex(ccc, i + 1);
                        }
                        if (state == 1 || state == 3 || state == 5) {
                            state = 6;
                            continue block8;
                        }
                        ++state;
                        continue block8;
                    }
                    if (!PhoneNumberUtils.isDialable(ch)) continue block8;
                    return null;
                }
                case 8: {
                    if (ch == '6') {
                        state = 9;
                        continue block8;
                    }
                    if (!PhoneNumberUtils.isDialable(ch)) continue block8;
                    return null;
                }
                case 9: {
                    if (ch == '6') {
                        return new CountryCallingCodeAndNewIndex(66, i + 1);
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    private static final int $$robo$$android_telephony_PhoneNumberUtils$tryGetTrunkPrefixOmittedIndex(String str, int currentIndex) {
        int length = str.length();
        for (int i = currentIndex; i < length; ++i) {
            char ch = str.charAt(i);
            if (PhoneNumberUtils.tryGetISODigit(ch) >= 0) {
                return i + 1;
            }
            if (!PhoneNumberUtils.isDialable(ch)) continue;
            return -1;
        }
        return -1;
    }

    private static final boolean $$robo$$android_telephony_PhoneNumberUtils$checkPrefixIsIgnorable(String str, int forwardIndex, int backwardIndex) {
        boolean trunk_prefix_was_read = false;
        while (backwardIndex >= forwardIndex) {
            if (PhoneNumberUtils.tryGetISODigit(str.charAt(backwardIndex)) >= 0) {
                if (trunk_prefix_was_read) {
                    return false;
                }
                trunk_prefix_was_read = true;
            } else if (PhoneNumberUtils.isDialable(str.charAt(backwardIndex))) {
                return false;
            }
            --backwardIndex;
        }
        return true;
    }

    private static final int $$robo$$android_telephony_PhoneNumberUtils$getDefaultVoiceSubId() {
        return SubscriptionManager.getDefaultVoiceSubscriptionId();
    }

    private static final String $$robo$$android_telephony_PhoneNumberUtils$convertToEmergencyNumber(Context context, String number) {
        if (context == null || TextUtils.isEmpty(number)) {
            return number;
        }
        String normalizedNumber = PhoneNumberUtils.normalizeNumber(number);
        if (PhoneNumberUtils.isEmergencyNumber(normalizedNumber)) {
            return number;
        }
        if (sConvertToEmergencyMap == null) {
            sConvertToEmergencyMap = context.getResources().getStringArray(17235993);
        }
        if (sConvertToEmergencyMap == null || sConvertToEmergencyMap.length == 0) {
            return number;
        }
        for (String convertMap : sConvertToEmergencyMap) {
            String[] entry = null;
            String[] filterNumbers = null;
            String convertedNumber = null;
            if (!TextUtils.isEmpty(convertMap)) {
                entry = convertMap.split(":");
            }
            if (entry != null && entry.length == 2) {
                convertedNumber = entry[1];
                if (!TextUtils.isEmpty(entry[0])) {
                    filterNumbers = entry[0].split(",");
                }
            }
            if (TextUtils.isEmpty(convertedNumber) || filterNumbers == null || filterNumbers.length == 0) continue;
            for (String filterNumber : filterNumbers) {
                if (TextUtils.isEmpty(filterNumber) || !filterNumber.equals(normalizedNumber)) continue;
                return convertedNumber;
            }
        }
        return number;
    }

    static void __staticInitializer__() {
        GLOBAL_PHONE_NUMBER_PATTERN = Pattern.compile("[\\+]?[0-9.-]+");
        NANP_COUNTRIES = new String[]{"US", "CA", "AS", "AI", "AG", "BS", "BB", "BM", "VG", "KY", "DM", "DO", "GD", "GU", "JM", "PR", "MS", "MP", "KN", "LC", "VC", "TT", "TC", "VI"};
        KEYPAD_MAP = new SparseIntArray();
        KEYPAD_MAP.put(97, 50);
        KEYPAD_MAP.put(98, 50);
        KEYPAD_MAP.put(99, 50);
        KEYPAD_MAP.put(65, 50);
        KEYPAD_MAP.put(66, 50);
        KEYPAD_MAP.put(67, 50);
        KEYPAD_MAP.put(100, 51);
        KEYPAD_MAP.put(101, 51);
        KEYPAD_MAP.put(102, 51);
        KEYPAD_MAP.put(68, 51);
        KEYPAD_MAP.put(69, 51);
        KEYPAD_MAP.put(70, 51);
        KEYPAD_MAP.put(103, 52);
        KEYPAD_MAP.put(104, 52);
        KEYPAD_MAP.put(105, 52);
        KEYPAD_MAP.put(71, 52);
        KEYPAD_MAP.put(72, 52);
        KEYPAD_MAP.put(73, 52);
        KEYPAD_MAP.put(106, 53);
        KEYPAD_MAP.put(107, 53);
        KEYPAD_MAP.put(108, 53);
        KEYPAD_MAP.put(74, 53);
        KEYPAD_MAP.put(75, 53);
        KEYPAD_MAP.put(76, 53);
        KEYPAD_MAP.put(109, 54);
        KEYPAD_MAP.put(110, 54);
        KEYPAD_MAP.put(111, 54);
        KEYPAD_MAP.put(77, 54);
        KEYPAD_MAP.put(78, 54);
        KEYPAD_MAP.put(79, 54);
        KEYPAD_MAP.put(112, 55);
        KEYPAD_MAP.put(113, 55);
        KEYPAD_MAP.put(114, 55);
        KEYPAD_MAP.put(115, 55);
        KEYPAD_MAP.put(80, 55);
        KEYPAD_MAP.put(81, 55);
        KEYPAD_MAP.put(82, 55);
        KEYPAD_MAP.put(83, 55);
        KEYPAD_MAP.put(116, 56);
        KEYPAD_MAP.put(117, 56);
        KEYPAD_MAP.put(118, 56);
        KEYPAD_MAP.put(84, 56);
        KEYPAD_MAP.put(85, 56);
        KEYPAD_MAP.put(86, 56);
        KEYPAD_MAP.put(119, 57);
        KEYPAD_MAP.put(120, 57);
        KEYPAD_MAP.put(121, 57);
        KEYPAD_MAP.put(122, 57);
        KEYPAD_MAP.put(87, 57);
        KEYPAD_MAP.put(88, 57);
        KEYPAD_MAP.put(89, 57);
        KEYPAD_MAP.put(90, 57);
        COUNTRY_CALLING_CALL = new boolean[]{true, true, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true, true, false, true, true, true, true, true, false, true, false, false, true, true, false, false, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, false, true, false, false, true, true, true, true, true, true, true, false, false, true, false};
        CCC_LENGTH = COUNTRY_CALLING_CALL.length;
        sConvertToEmergencyMap = null;
    }

    private void __constructor__() {
        this.$$robo$$android_telephony_PhoneNumberUtils$__constructor__();
    }

    public PhoneNumberUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_PhoneNumberUtils$__constructor__(), 0, this);
    }

    public static boolean isISODigit(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isISODigit", $$robo$$android_telephony_PhoneNumberUtils$isISODigit(char ), 0, (char)c);
    }

    public static boolean is12Key(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("is12Key", $$robo$$android_telephony_PhoneNumberUtils$is12Key(char ), 0, (char)c);
    }

    public static boolean isDialable(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDialable", $$robo$$android_telephony_PhoneNumberUtils$isDialable(char ), 0, (char)c);
    }

    public static boolean isReallyDialable(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isReallyDialable", $$robo$$android_telephony_PhoneNumberUtils$isReallyDialable(char ), 0, (char)c);
    }

    public static boolean isNonSeparator(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNonSeparator", $$robo$$android_telephony_PhoneNumberUtils$isNonSeparator(char ), 0, (char)c);
    }

    public static boolean isStartsPostDial(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isStartsPostDial", $$robo$$android_telephony_PhoneNumberUtils$isStartsPostDial(char ), 0, (char)c);
    }

    private static boolean isPause(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPause", $$robo$$android_telephony_PhoneNumberUtils$isPause(char ), 0, (char)c);
    }

    private static boolean isToneWait(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isToneWait", $$robo$$android_telephony_PhoneNumberUtils$isToneWait(char ), 0, (char)c);
    }

    private static boolean isSeparator(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSeparator", $$robo$$android_telephony_PhoneNumberUtils$isSeparator(char ), 0, (char)c);
    }

    public static String getNumberFromIntent(Intent intent, Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getNumberFromIntent", $$robo$$android_telephony_PhoneNumberUtils$getNumberFromIntent(android.content.Intent android.content.Context ), 0, (Intent)intent, (Context)context);
    }

    public static String extractNetworkPortion(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("extractNetworkPortion", $$robo$$android_telephony_PhoneNumberUtils$extractNetworkPortion(java.lang.String ), 0, (String)string2);
    }

    public static String extractNetworkPortionAlt(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("extractNetworkPortionAlt", $$robo$$android_telephony_PhoneNumberUtils$extractNetworkPortionAlt(java.lang.String ), 0, (String)string2);
    }

    public static String stripSeparators(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("stripSeparators", $$robo$$android_telephony_PhoneNumberUtils$stripSeparators(java.lang.String ), 0, (String)string2);
    }

    public static String convertAndStrip(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("convertAndStrip", $$robo$$android_telephony_PhoneNumberUtils$convertAndStrip(java.lang.String ), 0, (String)string2);
    }

    public static String convertPreDial(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("convertPreDial", $$robo$$android_telephony_PhoneNumberUtils$convertPreDial(java.lang.String ), 0, (String)string2);
    }

    private static int minPositive(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("minPositive", $$robo$$android_telephony_PhoneNumberUtils$minPositive(int int ), 0, (int)n, (int)n2);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$android_telephony_PhoneNumberUtils$log(java.lang.String ), 0, (String)string2);
    }

    private static int indexOfLastNetworkChar(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("indexOfLastNetworkChar", $$robo$$android_telephony_PhoneNumberUtils$indexOfLastNetworkChar(java.lang.String ), 0, (String)string2);
    }

    public static String extractPostDialPortion(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("extractPostDialPortion", $$robo$$android_telephony_PhoneNumberUtils$extractPostDialPortion(java.lang.String ), 0, (String)string2);
    }

    public static boolean compare(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("compare", $$robo$$android_telephony_PhoneNumberUtils$compare(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static boolean compare(Context context, String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("compare", $$robo$$android_telephony_PhoneNumberUtils$compare(android.content.Context java.lang.String java.lang.String ), 0, (Context)context, (String)string2, (String)string3);
    }

    public static boolean compare(String string2, String string3, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("compare", $$robo$$android_telephony_PhoneNumberUtils$compare(java.lang.String java.lang.String boolean ), 0, (String)string2, (String)string3, (boolean)bl);
    }

    public static boolean compareLoosely(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("compareLoosely", $$robo$$android_telephony_PhoneNumberUtils$compareLoosely(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static boolean compareStrictly(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("compareStrictly", $$robo$$android_telephony_PhoneNumberUtils$compareStrictly(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static boolean compareStrictly(String string2, String string3, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("compareStrictly", $$robo$$android_telephony_PhoneNumberUtils$compareStrictly(java.lang.String java.lang.String boolean ), 0, (String)string2, (String)string3, (boolean)bl);
    }

    public static String toCallerIDMinMatch(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("toCallerIDMinMatch", $$robo$$android_telephony_PhoneNumberUtils$toCallerIDMinMatch(java.lang.String ), 0, (String)string2);
    }

    public static String getStrippedReversed(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getStrippedReversed", $$robo$$android_telephony_PhoneNumberUtils$getStrippedReversed(java.lang.String ), 0, (String)string2);
    }

    private static String internalGetStrippedReversed(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("internalGetStrippedReversed", $$robo$$android_telephony_PhoneNumberUtils$internalGetStrippedReversed(java.lang.String int ), 0, (String)string2, (int)n);
    }

    public static String stringFromStringAndTOA(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("stringFromStringAndTOA", $$robo$$android_telephony_PhoneNumberUtils$stringFromStringAndTOA(java.lang.String int ), 0, (String)string2, (int)n);
    }

    public static int toaFromString(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("toaFromString", $$robo$$android_telephony_PhoneNumberUtils$toaFromString(java.lang.String ), 0, (String)string2);
    }

    public static String calledPartyBCDToString(byte[] byArray, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("calledPartyBCDToString", $$robo$$android_telephony_PhoneNumberUtils$calledPartyBCDToString(byte[] int int ), 0, (byte[])byArray, (int)n, (int)n2);
    }

    private static void internalCalledPartyBCDFragmentToString(StringBuilder stringBuilder, byte[] byArray, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("internalCalledPartyBCDFragmentToString", $$robo$$android_telephony_PhoneNumberUtils$internalCalledPartyBCDFragmentToString(java.lang.StringBuilder byte[] int int ), 0, (StringBuilder)stringBuilder, (byte[])byArray, (int)n, (int)n2);
    }

    public static String calledPartyBCDFragmentToString(byte[] byArray, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("calledPartyBCDFragmentToString", $$robo$$android_telephony_PhoneNumberUtils$calledPartyBCDFragmentToString(byte[] int int ), 0, (byte[])byArray, (int)n, (int)n2);
    }

    private static char bcdToChar(byte by) {
        return (char)InvokeDynamicSupport.bootstrapStatic("bcdToChar", $$robo$$android_telephony_PhoneNumberUtils$bcdToChar(byte ), 0, (byte)by);
    }

    private static int charToBCD(char c) {
        return (int)InvokeDynamicSupport.bootstrapStatic("charToBCD", $$robo$$android_telephony_PhoneNumberUtils$charToBCD(char ), 0, (char)c);
    }

    public static boolean isWellFormedSmsAddress(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isWellFormedSmsAddress", $$robo$$android_telephony_PhoneNumberUtils$isWellFormedSmsAddress(java.lang.String ), 0, (String)string2);
    }

    public static boolean isGlobalPhoneNumber(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isGlobalPhoneNumber", $$robo$$android_telephony_PhoneNumberUtils$isGlobalPhoneNumber(java.lang.String ), 0, (String)string2);
    }

    private static boolean isDialable(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDialable", $$robo$$android_telephony_PhoneNumberUtils$isDialable(java.lang.String ), 0, (String)string2);
    }

    private static boolean isNonSeparator(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNonSeparator", $$robo$$android_telephony_PhoneNumberUtils$isNonSeparator(java.lang.String ), 0, (String)string2);
    }

    public static byte[] networkPortionToCalledPartyBCD(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("networkPortionToCalledPartyBCD", $$robo$$android_telephony_PhoneNumberUtils$networkPortionToCalledPartyBCD(java.lang.String ), 0, (String)string2);
    }

    public static byte[] networkPortionToCalledPartyBCDWithLength(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("networkPortionToCalledPartyBCDWithLength", $$robo$$android_telephony_PhoneNumberUtils$networkPortionToCalledPartyBCDWithLength(java.lang.String ), 0, (String)string2);
    }

    public static byte[] numberToCalledPartyBCD(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("numberToCalledPartyBCD", $$robo$$android_telephony_PhoneNumberUtils$numberToCalledPartyBCD(java.lang.String ), 0, (String)string2);
    }

    private static byte[] numberToCalledPartyBCDHelper(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("numberToCalledPartyBCDHelper", $$robo$$android_telephony_PhoneNumberUtils$numberToCalledPartyBCDHelper(java.lang.String boolean ), 0, (String)string2, (boolean)bl);
    }

    @Deprecated
    public static String formatNumber(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("formatNumber", $$robo$$android_telephony_PhoneNumberUtils$formatNumber(java.lang.String ), 0, (String)string2);
    }

    @Deprecated
    public static String formatNumber(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("formatNumber", $$robo$$android_telephony_PhoneNumberUtils$formatNumber(java.lang.String int ), 0, (String)string2, (int)n);
    }

    @Deprecated
    public static int getFormatTypeForLocale(Locale locale) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getFormatTypeForLocale", $$robo$$android_telephony_PhoneNumberUtils$getFormatTypeForLocale(java.util.Locale ), 0, (Locale)locale);
    }

    @Deprecated
    public static void formatNumber(Editable editable, int n) {
        InvokeDynamicSupport.bootstrapStatic("formatNumber", $$robo$$android_telephony_PhoneNumberUtils$formatNumber(android.text.Editable int ), 0, (Editable)editable, (int)n);
    }

    @Deprecated
    public static void formatNanpNumber(Editable editable) {
        InvokeDynamicSupport.bootstrapStatic("formatNanpNumber", $$robo$$android_telephony_PhoneNumberUtils$formatNanpNumber(android.text.Editable ), 0, (Editable)editable);
    }

    @Deprecated
    public static void formatJapaneseNumber(Editable editable) {
        InvokeDynamicSupport.bootstrapStatic("formatJapaneseNumber", $$robo$$android_telephony_PhoneNumberUtils$formatJapaneseNumber(android.text.Editable ), 0, (Editable)editable);
    }

    private static void removeDashes(Editable editable) {
        InvokeDynamicSupport.bootstrapStatic("removeDashes", $$robo$$android_telephony_PhoneNumberUtils$removeDashes(android.text.Editable ), 0, (Editable)editable);
    }

    public static String formatNumberToE164(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("formatNumberToE164", $$robo$$android_telephony_PhoneNumberUtils$formatNumberToE164(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static String formatNumberToRFC3966(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("formatNumberToRFC3966", $$robo$$android_telephony_PhoneNumberUtils$formatNumberToRFC3966(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    private static String formatNumberInternal(String string2, String string3, PhoneNumberUtil.PhoneNumberFormat phoneNumberFormat) {
        return InvokeDynamicSupport.bootstrapStatic("formatNumberInternal", $$robo$$android_telephony_PhoneNumberUtils$formatNumberInternal(java.lang.String java.lang.String com.android.i18n.phonenumbers.PhoneNumberUtil$PhoneNumberFormat ), 0, (String)string2, (String)string3, (PhoneNumberUtil.PhoneNumberFormat)phoneNumberFormat);
    }

    public static boolean isInternationalNumber(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isInternationalNumber", $$robo$$android_telephony_PhoneNumberUtils$isInternationalNumber(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static String formatNumber(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("formatNumber", $$robo$$android_telephony_PhoneNumberUtils$formatNumber(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static String formatNumber(String string2, String string3, String string4) {
        return InvokeDynamicSupport.bootstrapStatic("formatNumber", $$robo$$android_telephony_PhoneNumberUtils$formatNumber(java.lang.String java.lang.String java.lang.String ), 0, (String)string2, (String)string3, (String)string4);
    }

    public static String normalizeNumber(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("normalizeNumber", $$robo$$android_telephony_PhoneNumberUtils$normalizeNumber(java.lang.String ), 0, (String)string2);
    }

    public static String replaceUnicodeDigits(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("replaceUnicodeDigits", $$robo$$android_telephony_PhoneNumberUtils$replaceUnicodeDigits(java.lang.String ), 0, (String)string2);
    }

    public static boolean isEmergencyNumber(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isEmergencyNumber", $$robo$$android_telephony_PhoneNumberUtils$isEmergencyNumber(java.lang.String ), 0, (String)string2);
    }

    public static boolean isEmergencyNumber(int n, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isEmergencyNumber", $$robo$$android_telephony_PhoneNumberUtils$isEmergencyNumber(int java.lang.String ), 0, (int)n, (String)string2);
    }

    public static boolean isPotentialEmergencyNumber(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPotentialEmergencyNumber", $$robo$$android_telephony_PhoneNumberUtils$isPotentialEmergencyNumber(java.lang.String ), 0, (String)string2);
    }

    public static boolean isPotentialEmergencyNumber(int n, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPotentialEmergencyNumber", $$robo$$android_telephony_PhoneNumberUtils$isPotentialEmergencyNumber(int java.lang.String ), 0, (int)n, (String)string2);
    }

    private static boolean isEmergencyNumberInternal(String string2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isEmergencyNumberInternal", $$robo$$android_telephony_PhoneNumberUtils$isEmergencyNumberInternal(java.lang.String boolean ), 0, (String)string2, (boolean)bl);
    }

    private static boolean isEmergencyNumberInternal(int n, String string2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isEmergencyNumberInternal", $$robo$$android_telephony_PhoneNumberUtils$isEmergencyNumberInternal(int java.lang.String boolean ), 0, (int)n, (String)string2, (boolean)bl);
    }

    public static boolean isEmergencyNumber(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isEmergencyNumber", $$robo$$android_telephony_PhoneNumberUtils$isEmergencyNumber(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static boolean isEmergencyNumber(int n, String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isEmergencyNumber", $$robo$$android_telephony_PhoneNumberUtils$isEmergencyNumber(int java.lang.String java.lang.String ), 0, (int)n, (String)string2, (String)string3);
    }

    public static boolean isPotentialEmergencyNumber(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPotentialEmergencyNumber", $$robo$$android_telephony_PhoneNumberUtils$isPotentialEmergencyNumber(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static boolean isPotentialEmergencyNumber(int n, String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPotentialEmergencyNumber", $$robo$$android_telephony_PhoneNumberUtils$isPotentialEmergencyNumber(int java.lang.String java.lang.String ), 0, (int)n, (String)string2, (String)string3);
    }

    private static boolean isEmergencyNumberInternal(String string2, String string3, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isEmergencyNumberInternal", $$robo$$android_telephony_PhoneNumberUtils$isEmergencyNumberInternal(java.lang.String java.lang.String boolean ), 0, (String)string2, (String)string3, (boolean)bl);
    }

    private static boolean isEmergencyNumberInternal(int n, String string2, String string3, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isEmergencyNumberInternal", $$robo$$android_telephony_PhoneNumberUtils$isEmergencyNumberInternal(int java.lang.String java.lang.String boolean ), 0, (int)n, (String)string2, (String)string3, (boolean)bl);
    }

    public static boolean isLocalEmergencyNumber(Context context, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLocalEmergencyNumber", $$robo$$android_telephony_PhoneNumberUtils$isLocalEmergencyNumber(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    public static boolean isLocalEmergencyNumber(Context context, int n, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLocalEmergencyNumber", $$robo$$android_telephony_PhoneNumberUtils$isLocalEmergencyNumber(android.content.Context int java.lang.String ), 0, (Context)context, (int)n, (String)string2);
    }

    public static boolean isPotentialLocalEmergencyNumber(Context context, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPotentialLocalEmergencyNumber", $$robo$$android_telephony_PhoneNumberUtils$isPotentialLocalEmergencyNumber(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    public static boolean isPotentialLocalEmergencyNumber(Context context, int n, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPotentialLocalEmergencyNumber", $$robo$$android_telephony_PhoneNumberUtils$isPotentialLocalEmergencyNumber(android.content.Context int java.lang.String ), 0, (Context)context, (int)n, (String)string2);
    }

    private static boolean isLocalEmergencyNumberInternal(String string2, Context context, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLocalEmergencyNumberInternal", $$robo$$android_telephony_PhoneNumberUtils$isLocalEmergencyNumberInternal(java.lang.String android.content.Context boolean ), 0, (String)string2, (Context)context, (boolean)bl);
    }

    private static boolean isLocalEmergencyNumberInternal(int n, String string2, Context context, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLocalEmergencyNumberInternal", $$robo$$android_telephony_PhoneNumberUtils$isLocalEmergencyNumberInternal(int java.lang.String android.content.Context boolean ), 0, (int)n, (String)string2, (Context)context, (boolean)bl);
    }

    public static boolean isVoiceMailNumber(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isVoiceMailNumber", $$robo$$android_telephony_PhoneNumberUtils$isVoiceMailNumber(java.lang.String ), 0, (String)string2);
    }

    public static boolean isVoiceMailNumber(int n, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isVoiceMailNumber", $$robo$$android_telephony_PhoneNumberUtils$isVoiceMailNumber(int java.lang.String ), 0, (int)n, (String)string2);
    }

    public static boolean isVoiceMailNumber(Context context, int n, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isVoiceMailNumber", $$robo$$android_telephony_PhoneNumberUtils$isVoiceMailNumber(android.content.Context int java.lang.String ), 0, (Context)context, (int)n, (String)string2);
    }

    public static String convertKeypadLettersToDigits(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("convertKeypadLettersToDigits", $$robo$$android_telephony_PhoneNumberUtils$convertKeypadLettersToDigits(java.lang.String ), 0, (String)string2);
    }

    public static String cdmaCheckAndProcessPlusCode(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("cdmaCheckAndProcessPlusCode", $$robo$$android_telephony_PhoneNumberUtils$cdmaCheckAndProcessPlusCode(java.lang.String ), 0, (String)string2);
    }

    public static String cdmaCheckAndProcessPlusCodeForSms(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("cdmaCheckAndProcessPlusCodeForSms", $$robo$$android_telephony_PhoneNumberUtils$cdmaCheckAndProcessPlusCodeForSms(java.lang.String ), 0, (String)string2);
    }

    public static String cdmaCheckAndProcessPlusCodeByNumberFormat(String string2, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("cdmaCheckAndProcessPlusCodeByNumberFormat", $$robo$$android_telephony_PhoneNumberUtils$cdmaCheckAndProcessPlusCodeByNumberFormat(java.lang.String int int ), 0, (String)string2, (int)n, (int)n2);
    }

    public static CharSequence createTtsSpannable(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrapStatic("createTtsSpannable", $$robo$$android_telephony_PhoneNumberUtils$createTtsSpannable(java.lang.CharSequence ), 0, (CharSequence)charSequence);
    }

    public static void addTtsSpan(Spannable spannable, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("addTtsSpan", $$robo$$android_telephony_PhoneNumberUtils$addTtsSpan(android.text.Spannable int int ), 0, (Spannable)spannable, (int)n, (int)n2);
    }

    @Deprecated
    public static CharSequence ttsSpanAsPhoneNumber(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrapStatic("ttsSpanAsPhoneNumber", $$robo$$android_telephony_PhoneNumberUtils$ttsSpanAsPhoneNumber(java.lang.CharSequence ), 0, (CharSequence)charSequence);
    }

    @Deprecated
    public static void ttsSpanAsPhoneNumber(Spannable spannable, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("ttsSpanAsPhoneNumber", $$robo$$android_telephony_PhoneNumberUtils$ttsSpanAsPhoneNumber(android.text.Spannable int int ), 0, (Spannable)spannable, (int)n, (int)n2);
    }

    public static TtsSpan createTtsSpan(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createTtsSpan", $$robo$$android_telephony_PhoneNumberUtils$createTtsSpan(java.lang.String ), 0, (String)string2);
    }

    private static String splitAtNonNumerics(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrapStatic("splitAtNonNumerics", $$robo$$android_telephony_PhoneNumberUtils$splitAtNonNumerics(java.lang.CharSequence ), 0, (CharSequence)charSequence);
    }

    private static String getCurrentIdp(boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getCurrentIdp", $$robo$$android_telephony_PhoneNumberUtils$getCurrentIdp(boolean ), 0, (boolean)bl);
    }

    private static boolean isTwoToNine(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isTwoToNine", $$robo$$android_telephony_PhoneNumberUtils$isTwoToNine(char ), 0, (char)c);
    }

    private static int getFormatTypeFromCountryCode(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getFormatTypeFromCountryCode", $$robo$$android_telephony_PhoneNumberUtils$getFormatTypeFromCountryCode(java.lang.String ), 0, (String)string2);
    }

    public static boolean isNanp(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNanp", $$robo$$android_telephony_PhoneNumberUtils$isNanp(java.lang.String ), 0, (String)string2);
    }

    private static boolean isOneNanp(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isOneNanp", $$robo$$android_telephony_PhoneNumberUtils$isOneNanp(java.lang.String ), 0, (String)string2);
    }

    public static boolean isUriNumber(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isUriNumber", $$robo$$android_telephony_PhoneNumberUtils$isUriNumber(java.lang.String ), 0, (String)string2);
    }

    public static String getUsernameFromUriNumber(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getUsernameFromUriNumber", $$robo$$android_telephony_PhoneNumberUtils$getUsernameFromUriNumber(java.lang.String ), 0, (String)string2);
    }

    public static Uri convertSipUriToTelUri(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("convertSipUriToTelUri", $$robo$$android_telephony_PhoneNumberUtils$convertSipUriToTelUri(android.net.Uri ), 0, (Uri)uri);
    }

    private static String processPlusCode(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("processPlusCode", $$robo$$android_telephony_PhoneNumberUtils$processPlusCode(java.lang.String boolean ), 0, (String)string2, (boolean)bl);
    }

    private static int findDialableIndexFromPostDialStr(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("findDialableIndexFromPostDialStr", $$robo$$android_telephony_PhoneNumberUtils$findDialableIndexFromPostDialStr(java.lang.String ), 0, (String)string2);
    }

    private static String appendPwCharBackToOrigDialStr(int n, String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("appendPwCharBackToOrigDialStr", $$robo$$android_telephony_PhoneNumberUtils$appendPwCharBackToOrigDialStr(int java.lang.String java.lang.String ), 0, (int)n, (String)string2, (String)string3);
    }

    private static boolean matchIntlPrefix(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("matchIntlPrefix", $$robo$$android_telephony_PhoneNumberUtils$matchIntlPrefix(java.lang.String int ), 0, (String)string2, (int)n);
    }

    private static boolean matchIntlPrefixAndCC(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("matchIntlPrefixAndCC", $$robo$$android_telephony_PhoneNumberUtils$matchIntlPrefixAndCC(java.lang.String int ), 0, (String)string2, (int)n);
    }

    private static boolean matchTrunkPrefix(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("matchTrunkPrefix", $$robo$$android_telephony_PhoneNumberUtils$matchTrunkPrefix(java.lang.String int ), 0, (String)string2, (int)n);
    }

    private static boolean isCountryCallingCode(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isCountryCallingCode", $$robo$$android_telephony_PhoneNumberUtils$isCountryCallingCode(int ), 0, (int)n);
    }

    private static int tryGetISODigit(char c) {
        return (int)InvokeDynamicSupport.bootstrapStatic("tryGetISODigit", $$robo$$android_telephony_PhoneNumberUtils$tryGetISODigit(char ), 0, (char)c);
    }

    private static CountryCallingCodeAndNewIndex tryGetCountryCallingCodeAndNewIndex(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("tryGetCountryCallingCodeAndNewIndex", $$robo$$android_telephony_PhoneNumberUtils$tryGetCountryCallingCodeAndNewIndex(java.lang.String boolean ), 0, (String)string2, (boolean)bl);
    }

    private static int tryGetTrunkPrefixOmittedIndex(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("tryGetTrunkPrefixOmittedIndex", $$robo$$android_telephony_PhoneNumberUtils$tryGetTrunkPrefixOmittedIndex(java.lang.String int ), 0, (String)string2, (int)n);
    }

    private static boolean checkPrefixIsIgnorable(String string2, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkPrefixIsIgnorable", $$robo$$android_telephony_PhoneNumberUtils$checkPrefixIsIgnorable(java.lang.String int int ), 0, (String)string2, (int)n, (int)n2);
    }

    private static int getDefaultVoiceSubId() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultVoiceSubId", $$robo$$android_telephony_PhoneNumberUtils$getDefaultVoiceSubId(), 0);
    }

    public static String convertToEmergencyNumber(Context context, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("convertToEmergencyNumber", $$robo$$android_telephony_PhoneNumberUtils$convertToEmergencyNumber(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(PhoneNumberUtils.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PhoneNumberUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class CountryCallingCodeAndNewIndex
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int countryCallingCode;
        public int newIndex;

        private void $$robo$$android_telephony_PhoneNumberUtils_CountryCallingCodeAndNewIndex$__constructor__(int countryCode, int newIndex) {
            this.countryCallingCode = countryCode;
            this.newIndex = newIndex;
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_telephony_PhoneNumberUtils_CountryCallingCodeAndNewIndex$__constructor__(n, n2);
        }

        public CountryCallingCodeAndNewIndex(int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_PhoneNumberUtils_CountryCallingCodeAndNewIndex$__constructor__(int int ), 0, this, n, n2);
        }

        public /* synthetic */ CountryCallingCodeAndNewIndex() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CountryCallingCodeAndNewIndex)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

