/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.content.res.Resources;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.Rlog;
import android.util.Log;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SignalStrength
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "SignalStrength";
    private static boolean DBG = false;
    public static int SIGNAL_STRENGTH_NONE_OR_UNKNOWN = 0;
    public static int SIGNAL_STRENGTH_POOR = 1;
    public static int SIGNAL_STRENGTH_MODERATE = 2;
    public static int SIGNAL_STRENGTH_GOOD = 3;
    public static int SIGNAL_STRENGTH_GREAT = 4;
    public static int NUM_SIGNAL_STRENGTH_BINS = 5;
    public static String[] SIGNAL_STRENGTH_NAMES;
    public static int INVALID = Integer.MAX_VALUE;
    private int mGsmSignalStrength;
    private int mGsmBitErrorRate;
    private int mCdmaDbm;
    private int mCdmaEcio;
    private int mEvdoDbm;
    private int mEvdoEcio;
    private int mEvdoSnr;
    private int mLteSignalStrength;
    private int mLteRsrp;
    private int mLteRsrq;
    private int mLteRssnr;
    private int mLteCqi;
    private int mLteRsrpBoost;
    private int mTdScdmaRscp;
    private boolean isGsm;
    public static Parcelable.Creator<SignalStrength> CREATOR;

    private static final SignalStrength $$robo$$android_telephony_SignalStrength$newFromBundle(Bundle m) {
        SignalStrength ret = new SignalStrength();
        ret.setFromNotifierBundle(m);
        return ret;
    }

    private void $$robo$$android_telephony_SignalStrength$__constructor__() {
        this.mGsmSignalStrength = 99;
        this.mGsmBitErrorRate = -1;
        this.mCdmaDbm = -1;
        this.mCdmaEcio = -1;
        this.mEvdoDbm = -1;
        this.mEvdoEcio = -1;
        this.mEvdoSnr = -1;
        this.mLteSignalStrength = 99;
        this.mLteRsrp = Integer.MAX_VALUE;
        this.mLteRsrq = Integer.MAX_VALUE;
        this.mLteRssnr = Integer.MAX_VALUE;
        this.mLteCqi = Integer.MAX_VALUE;
        this.mLteRsrpBoost = 0;
        this.mTdScdmaRscp = Integer.MAX_VALUE;
        this.isGsm = true;
    }

    private void $$robo$$android_telephony_SignalStrength$__constructor__(boolean gsmFlag) {
        this.mGsmSignalStrength = 99;
        this.mGsmBitErrorRate = -1;
        this.mCdmaDbm = -1;
        this.mCdmaEcio = -1;
        this.mEvdoDbm = -1;
        this.mEvdoEcio = -1;
        this.mEvdoSnr = -1;
        this.mLteSignalStrength = 99;
        this.mLteRsrp = Integer.MAX_VALUE;
        this.mLteRsrq = Integer.MAX_VALUE;
        this.mLteRssnr = Integer.MAX_VALUE;
        this.mLteCqi = Integer.MAX_VALUE;
        this.mLteRsrpBoost = 0;
        this.mTdScdmaRscp = Integer.MAX_VALUE;
        this.isGsm = gsmFlag;
    }

    private void $$robo$$android_telephony_SignalStrength$__constructor__(int gsmSignalStrength, int gsmBitErrorRate, int cdmaDbm, int cdmaEcio, int evdoDbm, int evdoEcio, int evdoSnr, int lteSignalStrength, int lteRsrp, int lteRsrq, int lteRssnr, int lteCqi, int lteRsrpBoost, int tdScdmaRscp, boolean gsmFlag) {
        this.initialize(gsmSignalStrength, gsmBitErrorRate, cdmaDbm, cdmaEcio, evdoDbm, evdoEcio, evdoSnr, lteSignalStrength, lteRsrp, lteRsrq, lteRssnr, lteCqi, lteRsrpBoost, gsmFlag);
        this.mTdScdmaRscp = tdScdmaRscp;
    }

    private void $$robo$$android_telephony_SignalStrength$__constructor__(int gsmSignalStrength, int gsmBitErrorRate, int cdmaDbm, int cdmaEcio, int evdoDbm, int evdoEcio, int evdoSnr, int lteSignalStrength, int lteRsrp, int lteRsrq, int lteRssnr, int lteCqi, int tdScdmaRscp, boolean gsmFlag) {
        this.initialize(gsmSignalStrength, gsmBitErrorRate, cdmaDbm, cdmaEcio, evdoDbm, evdoEcio, evdoSnr, lteSignalStrength, lteRsrp, lteRsrq, lteRssnr, lteCqi, 0, gsmFlag);
        this.mTdScdmaRscp = tdScdmaRscp;
    }

    private void $$robo$$android_telephony_SignalStrength$__constructor__(int gsmSignalStrength, int gsmBitErrorRate, int cdmaDbm, int cdmaEcio, int evdoDbm, int evdoEcio, int evdoSnr, int lteSignalStrength, int lteRsrp, int lteRsrq, int lteRssnr, int lteCqi, boolean gsmFlag) {
        this.initialize(gsmSignalStrength, gsmBitErrorRate, cdmaDbm, cdmaEcio, evdoDbm, evdoEcio, evdoSnr, lteSignalStrength, lteRsrp, lteRsrq, lteRssnr, lteCqi, 0, gsmFlag);
    }

    private void $$robo$$android_telephony_SignalStrength$__constructor__(int gsmSignalStrength, int gsmBitErrorRate, int cdmaDbm, int cdmaEcio, int evdoDbm, int evdoEcio, int evdoSnr, boolean gsmFlag) {
        this.initialize(gsmSignalStrength, gsmBitErrorRate, cdmaDbm, cdmaEcio, evdoDbm, evdoEcio, evdoSnr, 99, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, gsmFlag);
    }

    private void $$robo$$android_telephony_SignalStrength$__constructor__(SignalStrength s) {
        this.copyFrom(s);
    }

    private final void $$robo$$android_telephony_SignalStrength$initialize(int gsmSignalStrength, int gsmBitErrorRate, int cdmaDbm, int cdmaEcio, int evdoDbm, int evdoEcio, int evdoSnr, boolean gsm) {
        this.initialize(gsmSignalStrength, gsmBitErrorRate, cdmaDbm, cdmaEcio, evdoDbm, evdoEcio, evdoSnr, 99, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, gsm);
    }

    private final void $$robo$$android_telephony_SignalStrength$initialize(int gsmSignalStrength, int gsmBitErrorRate, int cdmaDbm, int cdmaEcio, int evdoDbm, int evdoEcio, int evdoSnr, int lteSignalStrength, int lteRsrp, int lteRsrq, int lteRssnr, int lteCqi, int lteRsrpBoost, boolean gsm) {
        this.mGsmSignalStrength = gsmSignalStrength;
        this.mGsmBitErrorRate = gsmBitErrorRate;
        this.mCdmaDbm = cdmaDbm;
        this.mCdmaEcio = cdmaEcio;
        this.mEvdoDbm = evdoDbm;
        this.mEvdoEcio = evdoEcio;
        this.mEvdoSnr = evdoSnr;
        this.mLteSignalStrength = lteSignalStrength;
        this.mLteRsrp = lteRsrp;
        this.mLteRsrq = lteRsrq;
        this.mLteRssnr = lteRssnr;
        this.mLteCqi = lteCqi;
        this.mLteRsrpBoost = lteRsrpBoost;
        this.mTdScdmaRscp = Integer.MAX_VALUE;
        this.isGsm = gsm;
    }

    private final void $$robo$$android_telephony_SignalStrength$copyFrom(SignalStrength s) {
        this.mGsmSignalStrength = s.mGsmSignalStrength;
        this.mGsmBitErrorRate = s.mGsmBitErrorRate;
        this.mCdmaDbm = s.mCdmaDbm;
        this.mCdmaEcio = s.mCdmaEcio;
        this.mEvdoDbm = s.mEvdoDbm;
        this.mEvdoEcio = s.mEvdoEcio;
        this.mEvdoSnr = s.mEvdoSnr;
        this.mLteSignalStrength = s.mLteSignalStrength;
        this.mLteRsrp = s.mLteRsrp;
        this.mLteRsrq = s.mLteRsrq;
        this.mLteRssnr = s.mLteRssnr;
        this.mLteCqi = s.mLteCqi;
        this.mLteRsrpBoost = s.mLteRsrpBoost;
        this.mTdScdmaRscp = s.mTdScdmaRscp;
        this.isGsm = s.isGsm;
    }

    private void $$robo$$android_telephony_SignalStrength$__constructor__(Parcel in) {
        this.mGsmSignalStrength = in.readInt();
        this.mGsmBitErrorRate = in.readInt();
        this.mCdmaDbm = in.readInt();
        this.mCdmaEcio = in.readInt();
        this.mEvdoDbm = in.readInt();
        this.mEvdoEcio = in.readInt();
        this.mEvdoSnr = in.readInt();
        this.mLteSignalStrength = in.readInt();
        this.mLteRsrp = in.readInt();
        this.mLteRsrq = in.readInt();
        this.mLteRssnr = in.readInt();
        this.mLteCqi = in.readInt();
        this.mLteRsrpBoost = in.readInt();
        this.mTdScdmaRscp = in.readInt();
        this.isGsm = in.readInt() != 0;
    }

    private static final SignalStrength $$robo$$android_telephony_SignalStrength$makeSignalStrengthFromRilParcel(Parcel in) {
        SignalStrength ss = new SignalStrength();
        ss.mGsmSignalStrength = in.readInt();
        ss.mGsmBitErrorRate = in.readInt();
        ss.mCdmaDbm = in.readInt();
        ss.mCdmaEcio = in.readInt();
        ss.mEvdoDbm = in.readInt();
        ss.mEvdoEcio = in.readInt();
        ss.mEvdoSnr = in.readInt();
        ss.mLteSignalStrength = in.readInt();
        ss.mLteRsrp = in.readInt();
        ss.mLteRsrq = in.readInt();
        ss.mLteRssnr = in.readInt();
        ss.mLteCqi = in.readInt();
        ss.mTdScdmaRscp = in.readInt();
        return ss;
    }

    private final void $$robo$$android_telephony_SignalStrength$writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mGsmSignalStrength);
        out.writeInt(this.mGsmBitErrorRate);
        out.writeInt(this.mCdmaDbm);
        out.writeInt(this.mCdmaEcio);
        out.writeInt(this.mEvdoDbm);
        out.writeInt(this.mEvdoEcio);
        out.writeInt(this.mEvdoSnr);
        out.writeInt(this.mLteSignalStrength);
        out.writeInt(this.mLteRsrp);
        out.writeInt(this.mLteRsrq);
        out.writeInt(this.mLteRssnr);
        out.writeInt(this.mLteCqi);
        out.writeInt(this.mLteRsrpBoost);
        out.writeInt(this.mTdScdmaRscp);
        out.writeInt(this.isGsm ? 1 : 0);
    }

    private final int $$robo$$android_telephony_SignalStrength$describeContents() {
        return 0;
    }

    private final void $$robo$$android_telephony_SignalStrength$validateInput() {
        this.mGsmSignalStrength = this.mGsmSignalStrength >= 0 ? this.mGsmSignalStrength : 99;
        this.mCdmaDbm = this.mCdmaDbm > 0 ? -this.mCdmaDbm : -120;
        this.mCdmaEcio = this.mCdmaEcio > 0 ? -this.mCdmaEcio : -160;
        this.mEvdoDbm = this.mEvdoDbm > 0 ? -this.mEvdoDbm : -120;
        this.mEvdoEcio = this.mEvdoEcio >= 0 ? -this.mEvdoEcio : -1;
        this.mEvdoSnr = this.mEvdoSnr > 0 && this.mEvdoSnr <= 8 ? this.mEvdoSnr : -1;
        this.mLteSignalStrength = this.mLteSignalStrength >= 0 ? this.mLteSignalStrength : 99;
        this.mLteRsrp = this.mLteRsrp >= 44 && this.mLteRsrp <= 140 ? -this.mLteRsrp : Integer.MAX_VALUE;
        this.mLteRsrq = this.mLteRsrq >= 3 && this.mLteRsrq <= 20 ? -this.mLteRsrq : Integer.MAX_VALUE;
        this.mLteRssnr = this.mLteRssnr >= -200 && this.mLteRssnr <= 300 ? this.mLteRssnr : Integer.MAX_VALUE;
        this.mTdScdmaRscp = this.mTdScdmaRscp >= 25 && this.mTdScdmaRscp <= 120 ? -this.mTdScdmaRscp : Integer.MAX_VALUE;
    }

    private final void $$robo$$android_telephony_SignalStrength$setGsm(boolean gsmFlag) {
        this.isGsm = gsmFlag;
    }

    private final void $$robo$$android_telephony_SignalStrength$setLteRsrpBoost(int lteRsrpBoost) {
        this.mLteRsrpBoost = lteRsrpBoost;
    }

    private final int $$robo$$android_telephony_SignalStrength$getGsmSignalStrength() {
        return this.mGsmSignalStrength;
    }

    private final int $$robo$$android_telephony_SignalStrength$getGsmBitErrorRate() {
        return this.mGsmBitErrorRate;
    }

    private final int $$robo$$android_telephony_SignalStrength$getCdmaDbm() {
        return this.mCdmaDbm;
    }

    private final int $$robo$$android_telephony_SignalStrength$getCdmaEcio() {
        return this.mCdmaEcio;
    }

    private final int $$robo$$android_telephony_SignalStrength$getEvdoDbm() {
        return this.mEvdoDbm;
    }

    private final int $$robo$$android_telephony_SignalStrength$getEvdoEcio() {
        return this.mEvdoEcio;
    }

    private final int $$robo$$android_telephony_SignalStrength$getEvdoSnr() {
        return this.mEvdoSnr;
    }

    private final int $$robo$$android_telephony_SignalStrength$getLteSignalStrength() {
        return this.mLteSignalStrength;
    }

    private final int $$robo$$android_telephony_SignalStrength$getLteRsrp() {
        return this.mLteRsrp;
    }

    private final int $$robo$$android_telephony_SignalStrength$getLteRsrq() {
        return this.mLteRsrq;
    }

    private final int $$robo$$android_telephony_SignalStrength$getLteRssnr() {
        return this.mLteRssnr;
    }

    private final int $$robo$$android_telephony_SignalStrength$getLteCqi() {
        return this.mLteCqi;
    }

    private final int $$robo$$android_telephony_SignalStrength$getLteRsrpBoost() {
        return this.mLteRsrpBoost;
    }

    private final int $$robo$$android_telephony_SignalStrength$getLevel() {
        int level = 0;
        if (this.isGsm) {
            level = this.getLteLevel();
            if (level == 0 && (level = this.getTdScdmaLevel()) == 0) {
                level = this.getGsmLevel();
            }
        } else {
            int cdmaLevel = this.getCdmaLevel();
            int evdoLevel = this.getEvdoLevel();
            level = evdoLevel == 0 ? cdmaLevel : (cdmaLevel == 0 ? evdoLevel : (cdmaLevel < evdoLevel ? cdmaLevel : evdoLevel));
        }
        return level;
    }

    private final int $$robo$$android_telephony_SignalStrength$getAsuLevel() {
        int asuLevel = 0;
        if (this.isGsm) {
            asuLevel = this.getLteLevel() == 0 ? (this.getTdScdmaLevel() == 0 ? this.getGsmAsuLevel() : this.getTdScdmaAsuLevel()) : this.getLteAsuLevel();
        } else {
            int cdmaAsuLevel = this.getCdmaAsuLevel();
            int evdoAsuLevel = this.getEvdoAsuLevel();
            asuLevel = evdoAsuLevel == 0 ? cdmaAsuLevel : (cdmaAsuLevel == 0 ? evdoAsuLevel : (cdmaAsuLevel < evdoAsuLevel ? cdmaAsuLevel : evdoAsuLevel));
        }
        return asuLevel;
    }

    private final int $$robo$$android_telephony_SignalStrength$getDbm() {
        int dBm = Integer.MAX_VALUE;
        if (this.isGsm()) {
            dBm = this.getLteDbm();
            if (dBm == Integer.MAX_VALUE) {
                dBm = this.getTdScdmaLevel() == 0 ? this.getGsmDbm() : this.getTdScdmaDbm();
            }
        } else {
            int cdmaDbm = this.getCdmaDbm();
            int evdoDbm = this.getEvdoDbm();
            return evdoDbm == -120 ? cdmaDbm : (cdmaDbm == -120 ? evdoDbm : (cdmaDbm < evdoDbm ? cdmaDbm : evdoDbm));
        }
        return dBm;
    }

    private final int $$robo$$android_telephony_SignalStrength$getGsmDbm() {
        int gsmSignalStrength = this.getGsmSignalStrength();
        int asu = gsmSignalStrength == 99 ? -1 : gsmSignalStrength;
        int dBm = asu != -1 ? -113 + 2 * asu : -1;
        return dBm;
    }

    private final int $$robo$$android_telephony_SignalStrength$getGsmLevel() {
        int asu = this.getGsmSignalStrength();
        int level = asu <= 2 || asu == 99 ? 0 : (asu >= 12 ? 4 : (asu >= 8 ? 3 : (asu >= 5 ? 2 : 1)));
        return level;
    }

    private final int $$robo$$android_telephony_SignalStrength$getGsmAsuLevel() {
        int level = this.getGsmSignalStrength();
        return level;
    }

    private final int $$robo$$android_telephony_SignalStrength$getCdmaLevel() {
        int cdmaDbm = this.getCdmaDbm();
        int cdmaEcio = this.getCdmaEcio();
        int levelDbm = cdmaDbm >= -75 ? 4 : (cdmaDbm >= -85 ? 3 : (cdmaDbm >= -95 ? 2 : (cdmaDbm >= -100 ? 1 : 0)));
        int levelEcio = cdmaEcio >= -90 ? 4 : (cdmaEcio >= -110 ? 3 : (cdmaEcio >= -130 ? 2 : (cdmaEcio >= -150 ? 1 : 0)));
        int level = levelDbm < levelEcio ? levelDbm : levelEcio;
        return level;
    }

    private final int $$robo$$android_telephony_SignalStrength$getCdmaAsuLevel() {
        int cdmaDbm = this.getCdmaDbm();
        int cdmaEcio = this.getCdmaEcio();
        int cdmaAsuLevel = cdmaDbm >= -75 ? 16 : (cdmaDbm >= -82 ? 8 : (cdmaDbm >= -90 ? 4 : (cdmaDbm >= -95 ? 2 : (cdmaDbm >= -100 ? 1 : 99))));
        int ecioAsuLevel = cdmaEcio >= -90 ? 16 : (cdmaEcio >= -100 ? 8 : (cdmaEcio >= -115 ? 4 : (cdmaEcio >= -130 ? 2 : (cdmaEcio >= -150 ? 1 : 99))));
        int level = cdmaAsuLevel < ecioAsuLevel ? cdmaAsuLevel : ecioAsuLevel;
        return level;
    }

    private final int $$robo$$android_telephony_SignalStrength$getEvdoLevel() {
        int evdoDbm = this.getEvdoDbm();
        int evdoSnr = this.getEvdoSnr();
        int levelEvdoDbm = evdoDbm >= -65 ? 4 : (evdoDbm >= -75 ? 3 : (evdoDbm >= -90 ? 2 : (evdoDbm >= -105 ? 1 : 0)));
        int levelEvdoSnr = evdoSnr >= 7 ? 4 : (evdoSnr >= 5 ? 3 : (evdoSnr >= 3 ? 2 : (evdoSnr >= 1 ? 1 : 0)));
        int level = levelEvdoDbm < levelEvdoSnr ? levelEvdoDbm : levelEvdoSnr;
        return level;
    }

    private final int $$robo$$android_telephony_SignalStrength$getEvdoAsuLevel() {
        int evdoDbm = this.getEvdoDbm();
        int evdoSnr = this.getEvdoSnr();
        int levelEvdoDbm = evdoDbm >= -65 ? 16 : (evdoDbm >= -75 ? 8 : (evdoDbm >= -85 ? 4 : (evdoDbm >= -95 ? 2 : (evdoDbm >= -105 ? 1 : 99))));
        int levelEvdoSnr = evdoSnr >= 7 ? 16 : (evdoSnr >= 6 ? 8 : (evdoSnr >= 5 ? 4 : (evdoSnr >= 3 ? 2 : (evdoSnr >= 1 ? 1 : 99))));
        int level = levelEvdoDbm < levelEvdoSnr ? levelEvdoDbm : levelEvdoSnr;
        return level;
    }

    private final int $$robo$$android_telephony_SignalStrength$getLteDbm() {
        return this.mLteRsrp;
    }

    private final int $$robo$$android_telephony_SignalStrength$getLteLevel() {
        int rssiIconLevel = 0;
        int rsrpIconLevel = -1;
        int snrIconLevel = -1;
        int[] threshRsrp = Resources.getSystem().getIntArray(17236011);
        if (threshRsrp.length != 6) {
            Log.wtf("SignalStrength", "getLteLevel - config_lteDbmThresholds has invalid num of elements. Cannot evaluate RSRP signal.");
        } else if (this.mLteRsrp > threshRsrp[5]) {
            rsrpIconLevel = -1;
        } else if (this.mLteRsrp >= threshRsrp[4] - this.mLteRsrpBoost) {
            rsrpIconLevel = 4;
        } else if (this.mLteRsrp >= threshRsrp[3] - this.mLteRsrpBoost) {
            rsrpIconLevel = 3;
        } else if (this.mLteRsrp >= threshRsrp[2] - this.mLteRsrpBoost) {
            rsrpIconLevel = 2;
        } else if (this.mLteRsrp >= threshRsrp[1] - this.mLteRsrpBoost) {
            rsrpIconLevel = 1;
        } else if (this.mLteRsrp >= threshRsrp[0]) {
            rsrpIconLevel = 0;
        }
        if (this.mLteRssnr > 300) {
            snrIconLevel = -1;
        } else if (this.mLteRssnr >= 130) {
            snrIconLevel = 4;
        } else if (this.mLteRssnr >= 45) {
            snrIconLevel = 3;
        } else if (this.mLteRssnr >= 10) {
            snrIconLevel = 2;
        } else if (this.mLteRssnr >= -30) {
            snrIconLevel = 1;
        } else if (this.mLteRssnr >= -200) {
            snrIconLevel = 0;
        }
        if (snrIconLevel != -1 && rsrpIconLevel != -1) {
            return rsrpIconLevel < snrIconLevel ? rsrpIconLevel : snrIconLevel;
        }
        if (snrIconLevel != -1) {
            return snrIconLevel;
        }
        if (rsrpIconLevel != -1) {
            return rsrpIconLevel;
        }
        if (this.mLteSignalStrength > 63) {
            rssiIconLevel = 0;
        } else if (this.mLteSignalStrength >= 12) {
            rssiIconLevel = 4;
        } else if (this.mLteSignalStrength >= 8) {
            rssiIconLevel = 3;
        } else if (this.mLteSignalStrength >= 5) {
            rssiIconLevel = 2;
        } else if (this.mLteSignalStrength >= 0) {
            rssiIconLevel = 1;
        }
        return rssiIconLevel;
    }

    private final int $$robo$$android_telephony_SignalStrength$getLteAsuLevel() {
        int lteAsuLevel = 99;
        int lteDbm = this.getLteDbm();
        lteAsuLevel = lteDbm == Integer.MAX_VALUE ? 255 : lteDbm + 140;
        return lteAsuLevel;
    }

    private final boolean $$robo$$android_telephony_SignalStrength$isGsm() {
        return this.isGsm;
    }

    private final int $$robo$$android_telephony_SignalStrength$getTdScdmaDbm() {
        return this.mTdScdmaRscp;
    }

    private final int $$robo$$android_telephony_SignalStrength$getTdScdmaLevel() {
        int tdScdmaDbm = this.getTdScdmaDbm();
        int level = tdScdmaDbm > -25 || tdScdmaDbm == Integer.MAX_VALUE ? 0 : (tdScdmaDbm >= -49 ? 4 : (tdScdmaDbm >= -73 ? 3 : (tdScdmaDbm >= -97 ? 2 : (tdScdmaDbm >= -110 ? 1 : 0))));
        return level;
    }

    private final int $$robo$$android_telephony_SignalStrength$getTdScdmaAsuLevel() {
        int tdScdmaDbm = this.getTdScdmaDbm();
        int tdScdmaAsuLevel = tdScdmaDbm == Integer.MAX_VALUE ? 255 : tdScdmaDbm + 120;
        return tdScdmaAsuLevel;
    }

    private final int $$robo$$android_telephony_SignalStrength$hashCode() {
        int primeNum = 31;
        return this.mGsmSignalStrength * primeNum + this.mGsmBitErrorRate * primeNum + this.mCdmaDbm * primeNum + this.mCdmaEcio * primeNum + this.mEvdoDbm * primeNum + this.mEvdoEcio * primeNum + this.mEvdoSnr * primeNum + this.mLteSignalStrength * primeNum + this.mLteRsrp * primeNum + this.mLteRsrq * primeNum + this.mLteRssnr * primeNum + this.mLteCqi * primeNum + this.mLteRsrpBoost * primeNum + this.mTdScdmaRscp * primeNum + (this.isGsm ? 1 : 0);
    }

    private final boolean $$robo$$android_telephony_SignalStrength$equals(Object o) {
        SignalStrength s;
        try {
            s = (SignalStrength)o;
        }
        catch (ClassCastException ex) {
            return false;
        }
        if (o == null) {
            return false;
        }
        return this.mGsmSignalStrength == s.mGsmSignalStrength && this.mGsmBitErrorRate == s.mGsmBitErrorRate && this.mCdmaDbm == s.mCdmaDbm && this.mCdmaEcio == s.mCdmaEcio && this.mEvdoDbm == s.mEvdoDbm && this.mEvdoEcio == s.mEvdoEcio && this.mEvdoSnr == s.mEvdoSnr && this.mLteSignalStrength == s.mLteSignalStrength && this.mLteRsrp == s.mLteRsrp && this.mLteRsrq == s.mLteRsrq && this.mLteRssnr == s.mLteRssnr && this.mLteCqi == s.mLteCqi && this.mLteRsrpBoost == s.mLteRsrpBoost && this.mTdScdmaRscp == s.mTdScdmaRscp && this.isGsm == s.isGsm;
    }

    private final String $$robo$$android_telephony_SignalStrength$toString() {
        return "SignalStrength: " + this.mGsmSignalStrength + " " + this.mGsmBitErrorRate + " " + this.mCdmaDbm + " " + this.mCdmaEcio + " " + this.mEvdoDbm + " " + this.mEvdoEcio + " " + this.mEvdoSnr + " " + this.mLteSignalStrength + " " + this.mLteRsrp + " " + this.mLteRsrq + " " + this.mLteRssnr + " " + this.mLteCqi + " " + this.mLteRsrpBoost + " " + this.mTdScdmaRscp + " " + (this.isGsm ? "gsm|lte" : "cdma");
    }

    private final void $$robo$$android_telephony_SignalStrength$setFromNotifierBundle(Bundle m) {
        this.mGsmSignalStrength = m.getInt("GsmSignalStrength");
        this.mGsmBitErrorRate = m.getInt("GsmBitErrorRate");
        this.mCdmaDbm = m.getInt("CdmaDbm");
        this.mCdmaEcio = m.getInt("CdmaEcio");
        this.mEvdoDbm = m.getInt("EvdoDbm");
        this.mEvdoEcio = m.getInt("EvdoEcio");
        this.mEvdoSnr = m.getInt("EvdoSnr");
        this.mLteSignalStrength = m.getInt("LteSignalStrength");
        this.mLteRsrp = m.getInt("LteRsrp");
        this.mLteRsrq = m.getInt("LteRsrq");
        this.mLteRssnr = m.getInt("LteRssnr");
        this.mLteCqi = m.getInt("LteCqi");
        this.mLteRsrpBoost = m.getInt("lteRsrpBoost");
        this.mTdScdmaRscp = m.getInt("TdScdma");
        this.isGsm = m.getBoolean("isGsm");
    }

    private final void $$robo$$android_telephony_SignalStrength$fillInNotifierBundle(Bundle m) {
        m.putInt("GsmSignalStrength", this.mGsmSignalStrength);
        m.putInt("GsmBitErrorRate", this.mGsmBitErrorRate);
        m.putInt("CdmaDbm", this.mCdmaDbm);
        m.putInt("CdmaEcio", this.mCdmaEcio);
        m.putInt("EvdoDbm", this.mEvdoDbm);
        m.putInt("EvdoEcio", this.mEvdoEcio);
        m.putInt("EvdoSnr", this.mEvdoSnr);
        m.putInt("LteSignalStrength", this.mLteSignalStrength);
        m.putInt("LteRsrp", this.mLteRsrp);
        m.putInt("LteRsrq", this.mLteRsrq);
        m.putInt("LteRssnr", this.mLteRssnr);
        m.putInt("LteCqi", this.mLteCqi);
        m.putInt("lteRsrpBoost", this.mLteRsrpBoost);
        m.putInt("TdScdma", this.mTdScdmaRscp);
        m.putBoolean("isGsm", this.isGsm);
    }

    private static final void $$robo$$android_telephony_SignalStrength$log(String s) {
        Rlog.w("SignalStrength", s);
    }

    static void __staticInitializer__() {
        SIGNAL_STRENGTH_NAMES = new String[]{"none", "poor", "moderate", "good", "great"};
        CREATOR = new Parcelable.Creator(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_telephony_SignalStrength_1$__constructor__() {
            }

            private final SignalStrength $$robo$$android_telephony_SignalStrength_1$createFromParcel(Parcel in) {
                return new SignalStrength(in);
            }

            private final SignalStrength[] $$robo$$android_telephony_SignalStrength_1$newArray(int size) {
                return new SignalStrength[size];
            }

            private void __constructor__() {
                this.$$robo$$android_telephony_SignalStrength_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SignalStrength_1$__constructor__(), 0, this);
            }

            public SignalStrength createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_telephony_SignalStrength_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public SignalStrength[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_telephony_SignalStrength_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static SignalStrength newFromBundle(Bundle bundle) {
        return InvokeDynamicSupport.bootstrapStatic("newFromBundle", $$robo$$android_telephony_SignalStrength$newFromBundle(android.os.Bundle ), 0, (Bundle)bundle);
    }

    private void __constructor__() {
        this.$$robo$$android_telephony_SignalStrength$__constructor__();
    }

    public SignalStrength() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SignalStrength$__constructor__(), 0, this);
    }

    private void __constructor__(boolean bl) {
        this.$$robo$$android_telephony_SignalStrength$__constructor__(bl);
    }

    public SignalStrength(boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SignalStrength$__constructor__(boolean ), 0, this, bl);
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, boolean bl) {
        this.$$robo$$android_telephony_SignalStrength$__constructor__(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, bl);
    }

    public SignalStrength(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SignalStrength$__constructor__(int int int int int int int int int int int int int int boolean ), 0, this, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, bl);
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, boolean bl) {
        this.$$robo$$android_telephony_SignalStrength$__constructor__(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, bl);
    }

    public SignalStrength(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SignalStrength$__constructor__(int int int int int int int int int int int int int boolean ), 0, this, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, bl);
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, boolean bl) {
        this.$$robo$$android_telephony_SignalStrength$__constructor__(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, bl);
    }

    public SignalStrength(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SignalStrength$__constructor__(int int int int int int int int int int int int boolean ), 0, this, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, bl);
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        this.$$robo$$android_telephony_SignalStrength$__constructor__(n, n2, n3, n4, n5, n6, n7, bl);
    }

    public SignalStrength(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SignalStrength$__constructor__(int int int int int int int boolean ), 0, this, n, n2, n3, n4, n5, n6, n7, bl);
    }

    private void __constructor__(SignalStrength signalStrength) {
        this.$$robo$$android_telephony_SignalStrength$__constructor__(signalStrength);
    }

    public SignalStrength(SignalStrength signalStrength) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SignalStrength$__constructor__(android.telephony.SignalStrength ), 0, this, signalStrength);
    }

    public void initialize(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_telephony_SignalStrength$initialize(int int int int int int int boolean ), 0, this, n, n2, n3, n4, n5, n6, n7, bl);
    }

    public void initialize(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, boolean bl) {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_telephony_SignalStrength$initialize(int int int int int int int int int int int int int boolean ), 0, this, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, bl);
    }

    protected void copyFrom(SignalStrength signalStrength) {
        InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$android_telephony_SignalStrength$copyFrom(android.telephony.SignalStrength ), 0, this, signalStrength);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_telephony_SignalStrength$__constructor__(parcel);
    }

    public SignalStrength(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SignalStrength$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public static SignalStrength makeSignalStrengthFromRilParcel(Parcel parcel) {
        return InvokeDynamicSupport.bootstrapStatic("makeSignalStrengthFromRilParcel", $$robo$$android_telephony_SignalStrength$makeSignalStrengthFromRilParcel(android.os.Parcel ), 0, (Parcel)parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_telephony_SignalStrength$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_telephony_SignalStrength$describeContents(), 0, this);
    }

    public void validateInput() {
        InvokeDynamicSupport.bootstrap("validateInput", $$robo$$android_telephony_SignalStrength$validateInput(), 0, this);
    }

    public void setGsm(boolean bl) {
        InvokeDynamicSupport.bootstrap("setGsm", $$robo$$android_telephony_SignalStrength$setGsm(boolean ), 0, this, bl);
    }

    public void setLteRsrpBoost(int n) {
        InvokeDynamicSupport.bootstrap("setLteRsrpBoost", $$robo$$android_telephony_SignalStrength$setLteRsrpBoost(int ), 0, this, n);
    }

    public int getGsmSignalStrength() {
        return (int)InvokeDynamicSupport.bootstrap("getGsmSignalStrength", $$robo$$android_telephony_SignalStrength$getGsmSignalStrength(), 0, this);
    }

    public int getGsmBitErrorRate() {
        return (int)InvokeDynamicSupport.bootstrap("getGsmBitErrorRate", $$robo$$android_telephony_SignalStrength$getGsmBitErrorRate(), 0, this);
    }

    public int getCdmaDbm() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaDbm", $$robo$$android_telephony_SignalStrength$getCdmaDbm(), 0, this);
    }

    public int getCdmaEcio() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaEcio", $$robo$$android_telephony_SignalStrength$getCdmaEcio(), 0, this);
    }

    public int getEvdoDbm() {
        return (int)InvokeDynamicSupport.bootstrap("getEvdoDbm", $$robo$$android_telephony_SignalStrength$getEvdoDbm(), 0, this);
    }

    public int getEvdoEcio() {
        return (int)InvokeDynamicSupport.bootstrap("getEvdoEcio", $$robo$$android_telephony_SignalStrength$getEvdoEcio(), 0, this);
    }

    public int getEvdoSnr() {
        return (int)InvokeDynamicSupport.bootstrap("getEvdoSnr", $$robo$$android_telephony_SignalStrength$getEvdoSnr(), 0, this);
    }

    public int getLteSignalStrength() {
        return (int)InvokeDynamicSupport.bootstrap("getLteSignalStrength", $$robo$$android_telephony_SignalStrength$getLteSignalStrength(), 0, this);
    }

    public int getLteRsrp() {
        return (int)InvokeDynamicSupport.bootstrap("getLteRsrp", $$robo$$android_telephony_SignalStrength$getLteRsrp(), 0, this);
    }

    public int getLteRsrq() {
        return (int)InvokeDynamicSupport.bootstrap("getLteRsrq", $$robo$$android_telephony_SignalStrength$getLteRsrq(), 0, this);
    }

    public int getLteRssnr() {
        return (int)InvokeDynamicSupport.bootstrap("getLteRssnr", $$robo$$android_telephony_SignalStrength$getLteRssnr(), 0, this);
    }

    public int getLteCqi() {
        return (int)InvokeDynamicSupport.bootstrap("getLteCqi", $$robo$$android_telephony_SignalStrength$getLteCqi(), 0, this);
    }

    public int getLteRsrpBoost() {
        return (int)InvokeDynamicSupport.bootstrap("getLteRsrpBoost", $$robo$$android_telephony_SignalStrength$getLteRsrpBoost(), 0, this);
    }

    public int getLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getLevel", $$robo$$android_telephony_SignalStrength$getLevel(), 0, this);
    }

    public int getAsuLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getAsuLevel", $$robo$$android_telephony_SignalStrength$getAsuLevel(), 0, this);
    }

    public int getDbm() {
        return (int)InvokeDynamicSupport.bootstrap("getDbm", $$robo$$android_telephony_SignalStrength$getDbm(), 0, this);
    }

    public int getGsmDbm() {
        return (int)InvokeDynamicSupport.bootstrap("getGsmDbm", $$robo$$android_telephony_SignalStrength$getGsmDbm(), 0, this);
    }

    public int getGsmLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getGsmLevel", $$robo$$android_telephony_SignalStrength$getGsmLevel(), 0, this);
    }

    public int getGsmAsuLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getGsmAsuLevel", $$robo$$android_telephony_SignalStrength$getGsmAsuLevel(), 0, this);
    }

    public int getCdmaLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaLevel", $$robo$$android_telephony_SignalStrength$getCdmaLevel(), 0, this);
    }

    public int getCdmaAsuLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaAsuLevel", $$robo$$android_telephony_SignalStrength$getCdmaAsuLevel(), 0, this);
    }

    public int getEvdoLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getEvdoLevel", $$robo$$android_telephony_SignalStrength$getEvdoLevel(), 0, this);
    }

    public int getEvdoAsuLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getEvdoAsuLevel", $$robo$$android_telephony_SignalStrength$getEvdoAsuLevel(), 0, this);
    }

    public int getLteDbm() {
        return (int)InvokeDynamicSupport.bootstrap("getLteDbm", $$robo$$android_telephony_SignalStrength$getLteDbm(), 0, this);
    }

    public int getLteLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getLteLevel", $$robo$$android_telephony_SignalStrength$getLteLevel(), 0, this);
    }

    public int getLteAsuLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getLteAsuLevel", $$robo$$android_telephony_SignalStrength$getLteAsuLevel(), 0, this);
    }

    public boolean isGsm() {
        return (boolean)InvokeDynamicSupport.bootstrap("isGsm", $$robo$$android_telephony_SignalStrength$isGsm(), 0, this);
    }

    public int getTdScdmaDbm() {
        return (int)InvokeDynamicSupport.bootstrap("getTdScdmaDbm", $$robo$$android_telephony_SignalStrength$getTdScdmaDbm(), 0, this);
    }

    public int getTdScdmaLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getTdScdmaLevel", $$robo$$android_telephony_SignalStrength$getTdScdmaLevel(), 0, this);
    }

    public int getTdScdmaAsuLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getTdScdmaAsuLevel", $$robo$$android_telephony_SignalStrength$getTdScdmaAsuLevel(), 0, this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_telephony_SignalStrength$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_telephony_SignalStrength$equals(java.lang.Object ), 0, this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_telephony_SignalStrength$toString(), 0, this);
    }

    private void setFromNotifierBundle(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("setFromNotifierBundle", $$robo$$android_telephony_SignalStrength$setFromNotifierBundle(android.os.Bundle ), 0, this, bundle);
    }

    public void fillInNotifierBundle(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("fillInNotifierBundle", $$robo$$android_telephony_SignalStrength$fillInNotifierBundle(android.os.Bundle ), 0, this, bundle);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$android_telephony_SignalStrength$log(java.lang.String ), 0, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(SignalStrength.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SignalStrength)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

