/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.Rlog;
import android.telephony.UiccAccessRule;
import android.util.DisplayMetrics;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SubscriptionInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int TEXT_SIZE = 16;
    private int mId;
    private String mIccId;
    private int mSimSlotIndex;
    private CharSequence mDisplayName;
    private CharSequence mCarrierName;
    private int mNameSource;
    private int mIconTint;
    private String mNumber;
    private int mDataRoaming;
    private Bitmap mIconBitmap;
    private int mMcc;
    private int mMnc;
    private String mCountryIso;
    private boolean mIsEmbedded;
    private UiccAccessRule[] mAccessRules;
    public static Parcelable.Creator<SubscriptionInfo> CREATOR;

    private void $$robo$$android_telephony_SubscriptionInfo$__constructor__(int id2, String iccId, int simSlotIndex, CharSequence displayName, CharSequence carrierName, int nameSource, int iconTint, String number, int roaming, Bitmap icon, int mcc, int mnc, String countryIso) {
    }

    private void $$robo$$android_telephony_SubscriptionInfo$__constructor__(int id2, String iccId, int simSlotIndex, CharSequence displayName, CharSequence carrierName, int nameSource, int iconTint, String number, int roaming, Bitmap icon, int mcc, int mnc, String countryIso, boolean isEmbedded, UiccAccessRule[] accessRules) {
        this.mId = id2;
        this.mIccId = iccId;
        this.mSimSlotIndex = simSlotIndex;
        this.mDisplayName = displayName;
        this.mCarrierName = carrierName;
        this.mNameSource = nameSource;
        this.mIconTint = iconTint;
        this.mNumber = number;
        this.mDataRoaming = roaming;
        this.mIconBitmap = icon;
        this.mMcc = mcc;
        this.mMnc = mnc;
        this.mCountryIso = countryIso;
        this.mIsEmbedded = isEmbedded;
        this.mAccessRules = accessRules;
    }

    private final int $$robo$$android_telephony_SubscriptionInfo$getSubscriptionId() {
        return this.mId;
    }

    private final String $$robo$$android_telephony_SubscriptionInfo$getIccId() {
        return this.mIccId;
    }

    private final int $$robo$$android_telephony_SubscriptionInfo$getSimSlotIndex() {
        return this.mSimSlotIndex;
    }

    private final CharSequence $$robo$$android_telephony_SubscriptionInfo$getDisplayName() {
        return this.mDisplayName;
    }

    private final void $$robo$$android_telephony_SubscriptionInfo$setDisplayName(CharSequence name) {
        this.mDisplayName = name;
    }

    private final CharSequence $$robo$$android_telephony_SubscriptionInfo$getCarrierName() {
        return this.mCarrierName;
    }

    private final void $$robo$$android_telephony_SubscriptionInfo$setCarrierName(CharSequence name) {
        this.mCarrierName = name;
    }

    private final int $$robo$$android_telephony_SubscriptionInfo$getNameSource() {
        return this.mNameSource;
    }

    private final Bitmap $$robo$$android_telephony_SubscriptionInfo$createIconBitmap(Context context) {
        int width = this.mIconBitmap.getWidth();
        int height = this.mIconBitmap.getHeight();
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        Bitmap workingBitmap = Bitmap.createBitmap(metrics, width, height, this.mIconBitmap.getConfig());
        Canvas canvas = new Canvas(workingBitmap);
        Paint paint = new Paint();
        paint.setColorFilter(new PorterDuffColorFilter(this.mIconTint, PorterDuff.Mode.SRC_ATOP));
        canvas.drawBitmap(this.mIconBitmap, 0.0f, 0.0f, paint);
        paint.setColorFilter(null);
        paint.setAntiAlias(true);
        paint.setTypeface(Typeface.create("sans-serif", 0));
        paint.setColor(-1);
        paint.setTextSize(16.0f * metrics.density);
        String index = String.format("%d", this.mSimSlotIndex + 1);
        Rect textBound = new Rect();
        paint.getTextBounds(index, 0, 1, textBound);
        float xOffset = (float)width / 2.0f - (float)textBound.centerX();
        float yOffset = (float)height / 2.0f - (float)textBound.centerY();
        canvas.drawText(index, xOffset, yOffset, paint);
        return workingBitmap;
    }

    private final int $$robo$$android_telephony_SubscriptionInfo$getIconTint() {
        return this.mIconTint;
    }

    private final void $$robo$$android_telephony_SubscriptionInfo$setIconTint(int iconTint) {
        this.mIconTint = iconTint;
    }

    private final String $$robo$$android_telephony_SubscriptionInfo$getNumber() {
        return this.mNumber;
    }

    private final int $$robo$$android_telephony_SubscriptionInfo$getDataRoaming() {
        return this.mDataRoaming;
    }

    private final int $$robo$$android_telephony_SubscriptionInfo$getMcc() {
        return this.mMcc;
    }

    private final int $$robo$$android_telephony_SubscriptionInfo$getMnc() {
        return this.mMnc;
    }

    private final String $$robo$$android_telephony_SubscriptionInfo$getCountryIso() {
        return this.mCountryIso;
    }

    private final boolean $$robo$$android_telephony_SubscriptionInfo$isEmbedded() {
        return this.mIsEmbedded;
    }

    private final boolean $$robo$$android_telephony_SubscriptionInfo$canManageSubscription(Context context) {
        return this.canManageSubscription(context, context.getPackageName());
    }

    private final boolean $$robo$$android_telephony_SubscriptionInfo$canManageSubscription(Context context, String packageName) {
        PackageInfo packageInfo;
        if (!this.isEmbedded()) {
            throw new UnsupportedOperationException("Not an embedded subscription");
        }
        if (this.mAccessRules == null) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        try {
            packageInfo = packageManager.getPackageInfo(packageName, 64);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new IllegalArgumentException("Unknown package: " + packageName, e);
        }
        for (UiccAccessRule rule : this.mAccessRules) {
            if (rule.getCarrierPrivilegeStatus(packageInfo) != 1) continue;
            return true;
        }
        return false;
    }

    private final UiccAccessRule[] $$robo$$android_telephony_SubscriptionInfo$getAccessRules() {
        if (!this.isEmbedded()) {
            throw new UnsupportedOperationException("Not an embedded subscription");
        }
        return this.mAccessRules;
    }

    private final void $$robo$$android_telephony_SubscriptionInfo$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mId);
        dest.writeString(this.mIccId);
        dest.writeInt(this.mSimSlotIndex);
        dest.writeCharSequence(this.mDisplayName);
        dest.writeCharSequence(this.mCarrierName);
        dest.writeInt(this.mNameSource);
        dest.writeInt(this.mIconTint);
        dest.writeString(this.mNumber);
        dest.writeInt(this.mDataRoaming);
        dest.writeInt(this.mMcc);
        dest.writeInt(this.mMnc);
        dest.writeString(this.mCountryIso);
        this.mIconBitmap.writeToParcel(dest, flags);
        dest.writeBoolean(this.mIsEmbedded);
        dest.writeTypedArray(this.mAccessRules, flags);
    }

    private final int $$robo$$android_telephony_SubscriptionInfo$describeContents() {
        return 0;
    }

    private static final String $$robo$$android_telephony_SubscriptionInfo$givePrintableIccid(String iccId) {
        String iccIdToPrint = null;
        if (iccId != null) {
            iccIdToPrint = iccId.length() > 9 && !Build.IS_DEBUGGABLE ? iccId.substring(0, 9) + Rlog.pii(false, (Object)iccId.substring(9)) : iccId;
        }
        return iccIdToPrint;
    }

    private final String $$robo$$android_telephony_SubscriptionInfo$toString() {
        String iccIdToPrint = SubscriptionInfo.givePrintableIccid(this.mIccId);
        return "{id=" + this.mId + ", iccId=" + iccIdToPrint + " simSlotIndex=" + this.mSimSlotIndex + " displayName=" + this.mDisplayName + " carrierName=" + this.mCarrierName + " nameSource=" + this.mNameSource + " iconTint=" + this.mIconTint + " dataRoaming=" + this.mDataRoaming + " iconBitmap=" + this.mIconBitmap + " mcc " + this.mMcc + " mnc " + this.mMnc + " isEmbedded " + this.mIsEmbedded + " accessRules " + Arrays.toString(this.mAccessRules) + "}";
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<SubscriptionInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_telephony_SubscriptionInfo_1$__constructor__() {
            }

            private final SubscriptionInfo $$robo$$android_telephony_SubscriptionInfo_1$createFromParcel(Parcel source) {
                int id2 = source.readInt();
                String iccId = source.readString();
                int simSlotIndex = source.readInt();
                CharSequence displayName = source.readCharSequence();
                CharSequence carrierName = source.readCharSequence();
                int nameSource = source.readInt();
                int iconTint = source.readInt();
                String number = source.readString();
                int dataRoaming = source.readInt();
                int mcc = source.readInt();
                int mnc = source.readInt();
                String countryIso = source.readString();
                Bitmap iconBitmap = Bitmap.CREATOR.createFromParcel(source);
                boolean isEmbedded = source.readBoolean();
                UiccAccessRule[] accessRules = source.createTypedArray(UiccAccessRule.CREATOR);
                return new SubscriptionInfo(id2, iccId, simSlotIndex, displayName, carrierName, nameSource, iconTint, number, dataRoaming, iconBitmap, mcc, mnc, countryIso, isEmbedded, accessRules);
            }

            private final SubscriptionInfo[] $$robo$$android_telephony_SubscriptionInfo_1$newArray(int size) {
                return new SubscriptionInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_telephony_SubscriptionInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SubscriptionInfo_1$__constructor__(), 0, this);
            }

            @Override
            public SubscriptionInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_telephony_SubscriptionInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public SubscriptionInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_telephony_SubscriptionInfo_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int n, String string2, int n2, CharSequence charSequence, CharSequence charSequence2, int n3, int n4, String string3, int n5, Bitmap bitmap, int n6, int n7, String string4) {
        this.$$robo$$android_telephony_SubscriptionInfo$__constructor__(n, string2, n2, charSequence, charSequence2, n3, n4, string3, n5, bitmap, n6, n7, string4);
    }

    public SubscriptionInfo(int n, String string2, int n2, CharSequence charSequence, CharSequence charSequence2, int n3, int n4, String string3, int n5, Bitmap bitmap, int n6, int n7, String string4) {
        this(n, string2, n2, charSequence, charSequence2, n3, n4, string3, n5, bitmap, n6, n7, string4, false, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SubscriptionInfo$__constructor__(int java.lang.String int java.lang.CharSequence java.lang.CharSequence int int java.lang.String int android.graphics.Bitmap int int java.lang.String ), 0, this, n, string2, n2, charSequence, charSequence2, n3, n4, string3, n5, bitmap, n6, n7, string4);
    }

    private void __constructor__(int n, String string2, int n2, CharSequence charSequence, CharSequence charSequence2, int n3, int n4, String string3, int n5, Bitmap bitmap, int n6, int n7, String string4, boolean bl, UiccAccessRule[] uiccAccessRuleArray) {
        this.$$robo$$android_telephony_SubscriptionInfo$__constructor__(n, string2, n2, charSequence, charSequence2, n3, n4, string3, n5, bitmap, n6, n7, string4, bl, uiccAccessRuleArray);
    }

    public SubscriptionInfo(int n, String string2, int n2, CharSequence charSequence, CharSequence charSequence2, int n3, int n4, String string3, int n5, Bitmap bitmap, int n6, int n7, String string4, boolean bl, UiccAccessRule[] uiccAccessRuleArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SubscriptionInfo$__constructor__(int java.lang.String int java.lang.CharSequence java.lang.CharSequence int int java.lang.String int android.graphics.Bitmap int int java.lang.String boolean android.telephony.UiccAccessRule[] ), 0, this, n, string2, n2, charSequence, charSequence2, n3, n4, string3, n5, bitmap, n6, n7, string4, bl, uiccAccessRuleArray);
    }

    public int getSubscriptionId() {
        return (int)InvokeDynamicSupport.bootstrap("getSubscriptionId", $$robo$$android_telephony_SubscriptionInfo$getSubscriptionId(), 0, this);
    }

    public String getIccId() {
        return InvokeDynamicSupport.bootstrap("getIccId", $$robo$$android_telephony_SubscriptionInfo$getIccId(), 0, this);
    }

    public int getSimSlotIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getSimSlotIndex", $$robo$$android_telephony_SubscriptionInfo$getSimSlotIndex(), 0, this);
    }

    public CharSequence getDisplayName() {
        return InvokeDynamicSupport.bootstrap("getDisplayName", $$robo$$android_telephony_SubscriptionInfo$getDisplayName(), 0, this);
    }

    public void setDisplayName(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setDisplayName", $$robo$$android_telephony_SubscriptionInfo$setDisplayName(java.lang.CharSequence ), 0, this, charSequence);
    }

    public CharSequence getCarrierName() {
        return InvokeDynamicSupport.bootstrap("getCarrierName", $$robo$$android_telephony_SubscriptionInfo$getCarrierName(), 0, this);
    }

    public void setCarrierName(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setCarrierName", $$robo$$android_telephony_SubscriptionInfo$setCarrierName(java.lang.CharSequence ), 0, this, charSequence);
    }

    public int getNameSource() {
        return (int)InvokeDynamicSupport.bootstrap("getNameSource", $$robo$$android_telephony_SubscriptionInfo$getNameSource(), 0, this);
    }

    public Bitmap createIconBitmap(Context context) {
        return InvokeDynamicSupport.bootstrap("createIconBitmap", $$robo$$android_telephony_SubscriptionInfo$createIconBitmap(android.content.Context ), 0, this, context);
    }

    public int getIconTint() {
        return (int)InvokeDynamicSupport.bootstrap("getIconTint", $$robo$$android_telephony_SubscriptionInfo$getIconTint(), 0, this);
    }

    public void setIconTint(int n) {
        InvokeDynamicSupport.bootstrap("setIconTint", $$robo$$android_telephony_SubscriptionInfo$setIconTint(int ), 0, this, n);
    }

    public String getNumber() {
        return InvokeDynamicSupport.bootstrap("getNumber", $$robo$$android_telephony_SubscriptionInfo$getNumber(), 0, this);
    }

    public int getDataRoaming() {
        return (int)InvokeDynamicSupport.bootstrap("getDataRoaming", $$robo$$android_telephony_SubscriptionInfo$getDataRoaming(), 0, this);
    }

    public int getMcc() {
        return (int)InvokeDynamicSupport.bootstrap("getMcc", $$robo$$android_telephony_SubscriptionInfo$getMcc(), 0, this);
    }

    public int getMnc() {
        return (int)InvokeDynamicSupport.bootstrap("getMnc", $$robo$$android_telephony_SubscriptionInfo$getMnc(), 0, this);
    }

    public String getCountryIso() {
        return InvokeDynamicSupport.bootstrap("getCountryIso", $$robo$$android_telephony_SubscriptionInfo$getCountryIso(), 0, this);
    }

    public boolean isEmbedded() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmbedded", $$robo$$android_telephony_SubscriptionInfo$isEmbedded(), 0, this);
    }

    public boolean canManageSubscription(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrap("canManageSubscription", $$robo$$android_telephony_SubscriptionInfo$canManageSubscription(android.content.Context ), 0, this, context);
    }

    public boolean canManageSubscription(Context context, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("canManageSubscription", $$robo$$android_telephony_SubscriptionInfo$canManageSubscription(android.content.Context java.lang.String ), 0, this, context, string2);
    }

    public UiccAccessRule[] getAccessRules() {
        return InvokeDynamicSupport.bootstrap("getAccessRules", $$robo$$android_telephony_SubscriptionInfo$getAccessRules(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_telephony_SubscriptionInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_telephony_SubscriptionInfo$describeContents(), 0, this);
    }

    public static String givePrintableIccid(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("givePrintableIccid", $$robo$$android_telephony_SubscriptionInfo$givePrintableIccid(java.lang.String ), 0, (String)string2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_telephony_SubscriptionInfo$toString(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(SubscriptionInfo.class);
    }

    public /* synthetic */ SubscriptionInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SubscriptionInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

