/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.CellInfo;
import android.telephony.NetworkScan;
import android.telephony.NetworkScanRequest;
import android.telephony.Rlog;
import android.util.SparseArray;
import com.android.internal.telephony.ITelephony;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class TelephonyScanManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "TelephonyScanManager";
    public static String SCAN_RESULT_KEY = "scanResult";
    public static int CALLBACK_SCAN_RESULTS = 1;
    public static int CALLBACK_SCAN_ERROR = 2;
    public static int CALLBACK_SCAN_COMPLETE = 3;
    private Looper mLooper;
    private Messenger mMessenger;
    private SparseArray<NetworkScanInfo> mScanInfo;

    private void $$robo$$android_telephony_TelephonyScanManager$__constructor__() {
        this.mScanInfo = new SparseArray();
        HandlerThread thread = new HandlerThread("TelephonyScanManager");
        thread.start();
        this.mLooper = thread.getLooper();
        this.mMessenger = new Messenger((Handler)new ShadowedObject(this, this.mLooper){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TelephonyScanManager this$0;

            private void $$robo$$android_telephony_TelephonyScanManager_1$__constructor__(TelephonyScanManager this$0, Looper looper) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_telephony_TelephonyScanManager_1$handleMessage(Message message) {
                NetworkScanInfo nsi;
                Preconditions.checkNotNull(message, "message cannot be null");
                SparseArray sparseArray = this.this$0.mScanInfo;
                synchronized (sparseArray) {
                    nsi = (NetworkScanInfo)this.this$0.mScanInfo.get(message.arg2);
                }
                if (nsi == null) {
                    throw new RuntimeException("Failed to find NetworkScanInfo with id " + message.arg2);
                }
                NetworkScanCallback callback = nsi.mCallback;
                if (callback == null) {
                    throw new RuntimeException("Failed to find NetworkScanCallback with id " + message.arg2);
                }
                switch (message.what) {
                    case 1: {
                        try {
                            Bundle b = message.getData();
                            Parcelable[] parcelables = b.getParcelableArray("scanResult");
                            CellInfo[] ci = new CellInfo[parcelables.length];
                            for (int i = 0; i < parcelables.length; ++i) {
                                ci[i] = (CellInfo)parcelables[i];
                            }
                            callback.onResults(Arrays.asList(ci));
                        }
                        catch (Exception e) {
                            Rlog.e("TelephonyScanManager", "Exception in networkscan callback onResults", e);
                        }
                        break;
                    }
                    case 2: {
                        try {
                            callback.onError(message.arg1);
                        }
                        catch (Exception e) {
                            Rlog.e("TelephonyScanManager", "Exception in networkscan callback onError", e);
                        }
                        break;
                    }
                    case 3: {
                        try {
                            callback.onComplete();
                            this.this$0.mScanInfo.remove(message.arg2);
                        }
                        catch (Exception e) {
                            Rlog.e("TelephonyScanManager", "Exception in networkscan callback onComplete", e);
                        }
                        break;
                    }
                    default: {
                        Rlog.e("TelephonyScanManager", "Unhandled message " + Integer.toHexString(message.what));
                    }
                }
            }

            private void __constructor__(TelephonyScanManager telephonyScanManager, Looper looper) {
                this.$$robo$$android_telephony_TelephonyScanManager_1$__constructor__(telephonyScanManager, looper);
            }
            {
                this.this$0 = telephonyScanManager;
                super(looper);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_TelephonyScanManager_1$__constructor__(android.telephony.TelephonyScanManager android.os.Looper ), 0, this, telephonyScanManager, looper);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_telephony_TelephonyScanManager_1$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final NetworkScan $$robo$$android_telephony_TelephonyScanManager$requestNetworkScan(int subId, NetworkScanRequest request, NetworkScanCallback callback) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                int scanId = telephony.requestNetworkScan(subId, request, this.mMessenger, new Binder());
                this.saveScanInfo(scanId, request, callback);
                return new NetworkScan(scanId, subId);
            }
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyScanManager", "requestNetworkScan RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyScanManager", "requestNetworkScan NPE", ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_telephony_TelephonyScanManager$saveScanInfo(int id2, NetworkScanRequest request, NetworkScanCallback callback) {
        SparseArray<NetworkScanInfo> sparseArray = this.mScanInfo;
        synchronized (sparseArray) {
            this.mScanInfo.put(id2, new NetworkScanInfo(request, callback));
        }
    }

    private final ITelephony $$robo$$android_telephony_TelephonyScanManager$getITelephony() {
        return ITelephony.Stub.asInterface(ServiceManager.getService("phone"));
    }

    private void __constructor__() {
        this.$$robo$$android_telephony_TelephonyScanManager$__constructor__();
    }

    public TelephonyScanManager() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_TelephonyScanManager$__constructor__(), 0, this);
    }

    public NetworkScan requestNetworkScan(int n, NetworkScanRequest networkScanRequest, NetworkScanCallback networkScanCallback) {
        return InvokeDynamicSupport.bootstrap("requestNetworkScan", $$robo$$android_telephony_TelephonyScanManager$requestNetworkScan(int android.telephony.NetworkScanRequest android.telephony.TelephonyScanManager$NetworkScanCallback ), 0, this, n, networkScanRequest, networkScanCallback);
    }

    private void saveScanInfo(int n, NetworkScanRequest networkScanRequest, NetworkScanCallback networkScanCallback) {
        InvokeDynamicSupport.bootstrap("saveScanInfo", $$robo$$android_telephony_TelephonyScanManager$saveScanInfo(int android.telephony.NetworkScanRequest android.telephony.TelephonyScanManager$NetworkScanCallback ), 0, this, n, networkScanRequest, networkScanCallback);
    }

    private ITelephony getITelephony() {
        return InvokeDynamicSupport.bootstrap("getITelephony", $$robo$$android_telephony_TelephonyScanManager$getITelephony(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TelephonyScanManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class NetworkScanInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private NetworkScanRequest mRequest;
        private NetworkScanCallback mCallback;

        private void $$robo$$android_telephony_TelephonyScanManager_NetworkScanInfo$__constructor__(NetworkScanRequest request, NetworkScanCallback callback) {
            this.mRequest = request;
            this.mCallback = callback;
        }

        private void __constructor__(NetworkScanRequest networkScanRequest, NetworkScanCallback networkScanCallback) {
            this.$$robo$$android_telephony_TelephonyScanManager_NetworkScanInfo$__constructor__(networkScanRequest, networkScanCallback);
        }

        NetworkScanInfo(NetworkScanRequest networkScanRequest, NetworkScanCallback networkScanCallback) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_TelephonyScanManager_NetworkScanInfo$__constructor__(android.telephony.NetworkScanRequest android.telephony.TelephonyScanManager$NetworkScanCallback ), 0, this, networkScanRequest, networkScanCallback);
        }

        public /* synthetic */ NetworkScanInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkScanInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class NetworkScanCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_telephony_TelephonyScanManager_NetworkScanCallback$__constructor__() {
        }

        private final void $$robo$$android_telephony_TelephonyScanManager_NetworkScanCallback$onResults(List<CellInfo> results) {
        }

        private final void $$robo$$android_telephony_TelephonyScanManager_NetworkScanCallback$onComplete() {
        }

        private final void $$robo$$android_telephony_TelephonyScanManager_NetworkScanCallback$onError(int error) {
        }

        private void __constructor__() {
            this.$$robo$$android_telephony_TelephonyScanManager_NetworkScanCallback$__constructor__();
        }

        public NetworkScanCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_TelephonyScanManager_NetworkScanCallback$__constructor__(), 0, this);
        }

        public void onResults(List<CellInfo> list) {
            InvokeDynamicSupport.bootstrap("onResults", $$robo$$android_telephony_TelephonyScanManager_NetworkScanCallback$onResults(java.util.List<android.telephony.CellInfo> ), 0, this, list);
        }

        public void onComplete() {
            InvokeDynamicSupport.bootstrap("onComplete", $$robo$$android_telephony_TelephonyScanManager_NetworkScanCallback$onComplete(), 0, this);
        }

        public void onError(int n) {
            InvokeDynamicSupport.bootstrap("onError", $$robo$$android_telephony_TelephonyScanManager_NetworkScanCallback$onError(int ), 0, this, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkScanCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

