/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.app.PendingIntent;
import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.telephony.ims.feature.ImsFeature;
import android.telephony.ims.feature.MMTelFeature;
import android.telephony.ims.feature.RcsFeature;
import android.util.Log;
import android.util.SparseArray;
import com.android.ims.ImsCallProfile;
import com.android.ims.internal.IImsCallSession;
import com.android.ims.internal.IImsCallSessionListener;
import com.android.ims.internal.IImsConfig;
import com.android.ims.internal.IImsEcbm;
import com.android.ims.internal.IImsFeatureStatusCallback;
import com.android.ims.internal.IImsMultiEndpoint;
import com.android.ims.internal.IImsRegistrationListener;
import com.android.ims.internal.IImsUt;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ImsService
extends Service
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "ImsService";
    public static String SERVICE_INTERFACE = "android.telephony.ims.ImsService";
    private SparseArray<SparseArray<ImsFeature>> mFeatures;
    protected IBinder mImsServiceController;

    private void $$robo$$android_telephony_ims_ImsService$__constructor__() {
        this.mFeatures = new SparseArray();
        this.mImsServiceController = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsService this$0;

            private void $$robo$$android_telephony_ims_ImsService_1$__constructor__(ImsService this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_telephony_ims_ImsService_1$createImsFeature(int slotId, int feature, IImsFeatureStatusCallback c) throws RemoteException {
                SparseArray sparseArray = this.this$0.mFeatures;
                synchronized (sparseArray) {
                    this.this$0.enforceCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE", "createImsFeature");
                    this.this$0.onCreateImsFeatureInternal(slotId, feature, c);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_telephony_ims_ImsService_1$removeImsFeature(int slotId, int feature, IImsFeatureStatusCallback c) throws RemoteException {
                SparseArray sparseArray = this.this$0.mFeatures;
                synchronized (sparseArray) {
                    this.this$0.enforceCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE", "removeImsFeature");
                    this.this$0.onRemoveImsFeatureInternal(slotId, feature, c);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_telephony_ims_ImsService_1$startSession(int slotId, int featureType, PendingIntent incomingCallIntent, IImsRegistrationListener listener) throws RemoteException {
                this.this$0.enforceCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE", "startSession");
                SparseArray sparseArray = this.this$0.mFeatures;
                synchronized (sparseArray) {
                    MMTelFeature feature = this.this$0.resolveMMTelFeature(slotId, featureType);
                    if (feature != null) {
                        return feature.startSession(incomingCallIntent, listener);
                    }
                }
                return 0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_telephony_ims_ImsService_1$endSession(int slotId, int featureType, int sessionId) throws RemoteException {
                SparseArray sparseArray = this.this$0.mFeatures;
                synchronized (sparseArray) {
                    this.this$0.enforceCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE", "endSession");
                    MMTelFeature feature = this.this$0.resolveMMTelFeature(slotId, featureType);
                    if (feature != null) {
                        feature.endSession(sessionId);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_telephony_ims_ImsService_1$isConnected(int slotId, int featureType, int callSessionType, int callType) throws RemoteException {
                this.this$0.enforceReadPhoneStatePermission("isConnected");
                SparseArray sparseArray = this.this$0.mFeatures;
                synchronized (sparseArray) {
                    MMTelFeature feature = this.this$0.resolveMMTelFeature(slotId, featureType);
                    if (feature != null) {
                        return feature.isConnected(callSessionType, callType);
                    }
                }
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_telephony_ims_ImsService_1$isOpened(int slotId, int featureType) throws RemoteException {
                this.this$0.enforceReadPhoneStatePermission("isOpened");
                SparseArray sparseArray = this.this$0.mFeatures;
                synchronized (sparseArray) {
                    MMTelFeature feature = this.this$0.resolveMMTelFeature(slotId, featureType);
                    if (feature != null) {
                        return feature.isOpened();
                    }
                }
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_telephony_ims_ImsService_1$getFeatureStatus(int slotId, int featureType) throws RemoteException {
                this.this$0.enforceReadPhoneStatePermission("getFeatureStatus");
                int status = 0;
                SparseArray sparseArray = this.this$0.mFeatures;
                synchronized (sparseArray) {
                    ImsFeature feature;
                    SparseArray featureMap = (SparseArray)this.this$0.mFeatures.get(slotId);
                    if (featureMap != null && (feature = this.this$0.getImsFeatureFromType(featureMap, featureType)) != null) {
                        status = feature.getFeatureState();
                    }
                }
                return status;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_telephony_ims_ImsService_1$addRegistrationListener(int slotId, int featureType, IImsRegistrationListener listener) throws RemoteException {
                this.this$0.enforceReadPhoneStatePermission("addRegistrationListener");
                SparseArray sparseArray = this.this$0.mFeatures;
                synchronized (sparseArray) {
                    MMTelFeature feature = this.this$0.resolveMMTelFeature(slotId, featureType);
                    if (feature != null) {
                        feature.addRegistrationListener(listener);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_telephony_ims_ImsService_1$removeRegistrationListener(int slotId, int featureType, IImsRegistrationListener listener) throws RemoteException {
                this.this$0.enforceReadPhoneStatePermission("removeRegistrationListener");
                SparseArray sparseArray = this.this$0.mFeatures;
                synchronized (sparseArray) {
                    MMTelFeature feature = this.this$0.resolveMMTelFeature(slotId, featureType);
                    if (feature != null) {
                        feature.removeRegistrationListener(listener);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final ImsCallProfile $$robo$$android_telephony_ims_ImsService_1$createCallProfile(int slotId, int featureType, int sessionId, int callSessionType, int callType) throws RemoteException {
                this.this$0.enforceCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE", "createCallProfile");
                SparseArray sparseArray = this.this$0.mFeatures;
                synchronized (sparseArray) {
                    MMTelFeature feature = this.this$0.resolveMMTelFeature(slotId, featureType);
                    if (feature != null) {
                        return feature.createCallProfile(sessionId, callSessionType, callType);
                    }
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final IImsCallSession $$robo$$android_telephony_ims_ImsService_1$createCallSession(int slotId, int featureType, int sessionId, ImsCallProfile profile, IImsCallSessionListener listener) throws RemoteException {
                this.this$0.enforceCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE", "createCallSession");
                SparseArray sparseArray = this.this$0.mFeatures;
                synchronized (sparseArray) {
                    MMTelFeature feature = this.this$0.resolveMMTelFeature(slotId, featureType);
                    if (feature != null) {
                        return feature.createCallSession(sessionId, profile, listener);
                    }
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final IImsCallSession $$robo$$android_telephony_ims_ImsService_1$getPendingCallSession(int slotId, int featureType, int sessionId, String callId) throws RemoteException {
                this.this$0.enforceCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE", "getPendingCallSession");
                SparseArray sparseArray = this.this$0.mFeatures;
                synchronized (sparseArray) {
                    MMTelFeature feature = this.this$0.resolveMMTelFeature(slotId, featureType);
                    if (feature != null) {
                        return feature.getPendingCallSession(sessionId, callId);
                    }
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final IImsUt $$robo$$android_telephony_ims_ImsService_1$getUtInterface(int slotId, int featureType) throws RemoteException {
                this.this$0.enforceCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE", "getUtInterface");
                SparseArray sparseArray = this.this$0.mFeatures;
                synchronized (sparseArray) {
                    MMTelFeature feature = this.this$0.resolveMMTelFeature(slotId, featureType);
                    if (feature != null) {
                        return feature.getUtInterface();
                    }
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final IImsConfig $$robo$$android_telephony_ims_ImsService_1$getConfigInterface(int slotId, int featureType) throws RemoteException {
                this.this$0.enforceCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE", "getConfigInterface");
                SparseArray sparseArray = this.this$0.mFeatures;
                synchronized (sparseArray) {
                    MMTelFeature feature = this.this$0.resolveMMTelFeature(slotId, featureType);
                    if (feature != null) {
                        return feature.getConfigInterface();
                    }
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_telephony_ims_ImsService_1$turnOnIms(int slotId, int featureType) throws RemoteException {
                this.this$0.enforceCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE", "turnOnIms");
                SparseArray sparseArray = this.this$0.mFeatures;
                synchronized (sparseArray) {
                    MMTelFeature feature = this.this$0.resolveMMTelFeature(slotId, featureType);
                    if (feature != null) {
                        feature.turnOnIms();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_telephony_ims_ImsService_1$turnOffIms(int slotId, int featureType) throws RemoteException {
                this.this$0.enforceCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE", "turnOffIms");
                SparseArray sparseArray = this.this$0.mFeatures;
                synchronized (sparseArray) {
                    MMTelFeature feature = this.this$0.resolveMMTelFeature(slotId, featureType);
                    if (feature != null) {
                        feature.turnOffIms();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final IImsEcbm $$robo$$android_telephony_ims_ImsService_1$getEcbmInterface(int slotId, int featureType) throws RemoteException {
                this.this$0.enforceCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE", "getEcbmInterface");
                SparseArray sparseArray = this.this$0.mFeatures;
                synchronized (sparseArray) {
                    MMTelFeature feature = this.this$0.resolveMMTelFeature(slotId, featureType);
                    if (feature != null) {
                        return feature.getEcbmInterface();
                    }
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_telephony_ims_ImsService_1$setUiTTYMode(int slotId, int featureType, int uiTtyMode, Message onComplete) throws RemoteException {
                this.this$0.enforceCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE", "setUiTTYMode");
                SparseArray sparseArray = this.this$0.mFeatures;
                synchronized (sparseArray) {
                    MMTelFeature feature = this.this$0.resolveMMTelFeature(slotId, featureType);
                    if (feature != null) {
                        feature.setUiTTYMode(uiTtyMode, onComplete);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final IImsMultiEndpoint $$robo$$android_telephony_ims_ImsService_1$getMultiEndpointInterface(int slotId, int featureType) throws RemoteException {
                this.this$0.enforceCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE", "getMultiEndpointInterface");
                SparseArray sparseArray = this.this$0.mFeatures;
                synchronized (sparseArray) {
                    MMTelFeature feature = this.this$0.resolveMMTelFeature(slotId, featureType);
                    if (feature != null) {
                        return feature.getMultiEndpointInterface();
                    }
                }
                return null;
            }

            private void __constructor__(ImsService imsService) {
                this.$$robo$$android_telephony_ims_ImsService_1$__constructor__(imsService);
            }
            {
                this.this$0 = imsService;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ims_ImsService_1$__constructor__(android.telephony.ims.ImsService ), 0, this, imsService);
            }

            @Override
            public void createImsFeature(int n, int n2, IImsFeatureStatusCallback iImsFeatureStatusCallback) throws RemoteException {
                InvokeDynamicSupport.bootstrap("createImsFeature", $$robo$$android_telephony_ims_ImsService_1$createImsFeature(int int com.android.ims.internal.IImsFeatureStatusCallback ), 0, this, n, n2, iImsFeatureStatusCallback);
            }

            @Override
            public void removeImsFeature(int n, int n2, IImsFeatureStatusCallback iImsFeatureStatusCallback) throws RemoteException {
                InvokeDynamicSupport.bootstrap("removeImsFeature", $$robo$$android_telephony_ims_ImsService_1$removeImsFeature(int int com.android.ims.internal.IImsFeatureStatusCallback ), 0, this, n, n2, iImsFeatureStatusCallback);
            }

            @Override
            public int startSession(int n, int n2, PendingIntent pendingIntent, IImsRegistrationListener iImsRegistrationListener) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("startSession", $$robo$$android_telephony_ims_ImsService_1$startSession(int int android.app.PendingIntent com.android.ims.internal.IImsRegistrationListener ), 0, this, n, n2, pendingIntent, iImsRegistrationListener);
            }

            @Override
            public void endSession(int n, int n2, int n3) throws RemoteException {
                InvokeDynamicSupport.bootstrap("endSession", $$robo$$android_telephony_ims_ImsService_1$endSession(int int int ), 0, this, n, n2, n3);
            }

            @Override
            public boolean isConnected(int n, int n2, int n3, int n4) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isConnected", $$robo$$android_telephony_ims_ImsService_1$isConnected(int int int int ), 0, this, n, n2, n3, n4);
            }

            @Override
            public boolean isOpened(int n, int n2) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isOpened", $$robo$$android_telephony_ims_ImsService_1$isOpened(int int ), 0, this, n, n2);
            }

            @Override
            public int getFeatureStatus(int n, int n2) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getFeatureStatus", $$robo$$android_telephony_ims_ImsService_1$getFeatureStatus(int int ), 0, this, n, n2);
            }

            @Override
            public void addRegistrationListener(int n, int n2, IImsRegistrationListener iImsRegistrationListener) throws RemoteException {
                InvokeDynamicSupport.bootstrap("addRegistrationListener", $$robo$$android_telephony_ims_ImsService_1$addRegistrationListener(int int com.android.ims.internal.IImsRegistrationListener ), 0, this, n, n2, iImsRegistrationListener);
            }

            @Override
            public void removeRegistrationListener(int n, int n2, IImsRegistrationListener iImsRegistrationListener) throws RemoteException {
                InvokeDynamicSupport.bootstrap("removeRegistrationListener", $$robo$$android_telephony_ims_ImsService_1$removeRegistrationListener(int int com.android.ims.internal.IImsRegistrationListener ), 0, this, n, n2, iImsRegistrationListener);
            }

            @Override
            public ImsCallProfile createCallProfile(int n, int n2, int n3, int n4, int n5) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("createCallProfile", $$robo$$android_telephony_ims_ImsService_1$createCallProfile(int int int int int ), 0, this, n, n2, n3, n4, n5);
            }

            @Override
            public IImsCallSession createCallSession(int n, int n2, int n3, ImsCallProfile imsCallProfile, IImsCallSessionListener iImsCallSessionListener) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("createCallSession", $$robo$$android_telephony_ims_ImsService_1$createCallSession(int int int com.android.ims.ImsCallProfile com.android.ims.internal.IImsCallSessionListener ), 0, this, n, n2, n3, imsCallProfile, iImsCallSessionListener);
            }

            @Override
            public IImsCallSession getPendingCallSession(int n, int n2, int n3, String string2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getPendingCallSession", $$robo$$android_telephony_ims_ImsService_1$getPendingCallSession(int int int java.lang.String ), 0, this, n, n2, n3, string2);
            }

            @Override
            public IImsUt getUtInterface(int n, int n2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getUtInterface", $$robo$$android_telephony_ims_ImsService_1$getUtInterface(int int ), 0, this, n, n2);
            }

            @Override
            public IImsConfig getConfigInterface(int n, int n2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getConfigInterface", $$robo$$android_telephony_ims_ImsService_1$getConfigInterface(int int ), 0, this, n, n2);
            }

            @Override
            public void turnOnIms(int n, int n2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("turnOnIms", $$robo$$android_telephony_ims_ImsService_1$turnOnIms(int int ), 0, this, n, n2);
            }

            @Override
            public void turnOffIms(int n, int n2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("turnOffIms", $$robo$$android_telephony_ims_ImsService_1$turnOffIms(int int ), 0, this, n, n2);
            }

            @Override
            public IImsEcbm getEcbmInterface(int n, int n2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getEcbmInterface", $$robo$$android_telephony_ims_ImsService_1$getEcbmInterface(int int ), 0, this, n, n2);
            }

            @Override
            public void setUiTTYMode(int n, int n2, int n3, Message message) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setUiTTYMode", $$robo$$android_telephony_ims_ImsService_1$setUiTTYMode(int int int android.os.Message ), 0, this, n, n2, n3, message);
            }

            @Override
            public IImsMultiEndpoint getMultiEndpointInterface(int n, int n2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getMultiEndpointInterface", $$robo$$android_telephony_ims_ImsService_1$getMultiEndpointInterface(int int ), 0, this, n, n2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final IBinder $$robo$$android_telephony_ims_ImsService$onBind(Intent intent) {
        if ("android.telephony.ims.ImsService".equals(intent.getAction())) {
            return this.mImsServiceController;
        }
        return null;
    }

    private final void $$robo$$android_telephony_ims_ImsService$onCreateImsFeatureInternal(int slotId, int featureType, IImsFeatureStatusCallback c) {
        ImsFeature f;
        SparseArray<ImsFeature> featureMap = this.mFeatures.get(slotId);
        if (featureMap == null) {
            featureMap = new SparseArray();
            this.mFeatures.put(slotId, featureMap);
        }
        if ((f = this.makeImsFeature(slotId, featureType)) != null) {
            f.setContext(this);
            f.setSlotId(slotId);
            f.addImsFeatureStatusCallback(c);
            featureMap.put(featureType, f);
        }
    }

    private final void $$robo$$android_telephony_ims_ImsService$onRemoveImsFeatureInternal(int slotId, int featureType, IImsFeatureStatusCallback c) {
        SparseArray<ImsFeature> featureMap = this.mFeatures.get(slotId);
        if (featureMap == null) {
            return;
        }
        ImsFeature featureToRemove = this.getImsFeatureFromType(featureMap, featureType);
        if (featureToRemove != null) {
            featureMap.remove(featureType);
            featureToRemove.notifyFeatureRemoved(slotId);
            featureToRemove.removeImsFeatureStatusCallback(c);
        }
    }

    private final MMTelFeature $$robo$$android_telephony_ims_ImsService$resolveMMTelFeature(int slotId, int featureType) {
        SparseArray<ImsFeature> features = this.getImsFeatureMap(slotId);
        MMTelFeature feature = null;
        if (features != null) {
            feature = this.resolveImsFeature(features, featureType, MMTelFeature.class);
        }
        return feature;
    }

    private final <T extends ImsFeature> T $$robo$$android_telephony_ims_ImsService$resolveImsFeature(SparseArray<ImsFeature> set, int featureType, Class<T> className) {
        ImsFeature feature = this.getImsFeatureFromType(set, featureType);
        if (feature == null) {
            return null;
        }
        try {
            return (T)((ImsFeature)className.cast(feature));
        }
        catch (ClassCastException e) {
            Log.e("ImsService", "Can not cast ImsFeature! Exception: " + e.getMessage());
            return null;
        }
    }

    private final SparseArray<ImsFeature> $$robo$$android_telephony_ims_ImsService$getImsFeatureMap(int slotId) {
        return this.mFeatures.get(slotId);
    }

    private final ImsFeature $$robo$$android_telephony_ims_ImsService$getImsFeatureFromType(SparseArray<ImsFeature> set, int featureType) {
        return set.get(featureType);
    }

    private final ImsFeature $$robo$$android_telephony_ims_ImsService$makeImsFeature(int slotId, int feature) {
        switch (feature) {
            case 0: {
                return this.onCreateEmergencyMMTelImsFeature(slotId);
            }
            case 1: {
                return this.onCreateMMTelImsFeature(slotId);
            }
            case 2: {
                return this.onCreateRcsFeature(slotId);
            }
        }
        return null;
    }

    private final void $$robo$$android_telephony_ims_ImsService$enforceReadPhoneStatePermission(String fn) {
        if (this.checkCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE") != 0) {
            this.enforceCallingOrSelfPermission("android.permission.READ_PHONE_STATE", fn);
        }
    }

    private final MMTelFeature $$robo$$android_telephony_ims_ImsService$onCreateEmergencyMMTelImsFeature(int slotId) {
        return null;
    }

    private final MMTelFeature $$robo$$android_telephony_ims_ImsService$onCreateMMTelImsFeature(int slotId) {
        return null;
    }

    private final RcsFeature $$robo$$android_telephony_ims_ImsService$onCreateRcsFeature(int slotId) {
        return null;
    }

    private void __constructor__() {
        this.$$robo$$android_telephony_ims_ImsService$__constructor__();
    }

    public ImsService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ims_ImsService$__constructor__(), 0, this);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_telephony_ims_ImsService$onBind(android.content.Intent ), 0, this, intent);
    }

    private void onCreateImsFeatureInternal(int n, int n2, IImsFeatureStatusCallback iImsFeatureStatusCallback) {
        InvokeDynamicSupport.bootstrap("onCreateImsFeatureInternal", $$robo$$android_telephony_ims_ImsService$onCreateImsFeatureInternal(int int com.android.ims.internal.IImsFeatureStatusCallback ), 0, this, n, n2, iImsFeatureStatusCallback);
    }

    private void onRemoveImsFeatureInternal(int n, int n2, IImsFeatureStatusCallback iImsFeatureStatusCallback) {
        InvokeDynamicSupport.bootstrap("onRemoveImsFeatureInternal", $$robo$$android_telephony_ims_ImsService$onRemoveImsFeatureInternal(int int com.android.ims.internal.IImsFeatureStatusCallback ), 0, this, n, n2, iImsFeatureStatusCallback);
    }

    private MMTelFeature resolveMMTelFeature(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("resolveMMTelFeature", $$robo$$android_telephony_ims_ImsService$resolveMMTelFeature(int int ), 0, this, n, n2);
    }

    private <T extends ImsFeature> T resolveImsFeature(SparseArray<ImsFeature> sparseArray, int n, Class<T> clazz) {
        return (T)InvokeDynamicSupport.bootstrap("resolveImsFeature", $$robo$$android_telephony_ims_ImsService$resolveImsFeature(android.util.SparseArray<android.telephony.ims.feature.ImsFeature> int java.lang.Class<T> ), 0, this, sparseArray, n, clazz);
    }

    public SparseArray<ImsFeature> getImsFeatureMap(int n) {
        return InvokeDynamicSupport.bootstrap("getImsFeatureMap", $$robo$$android_telephony_ims_ImsService$getImsFeatureMap(int ), 0, this, n);
    }

    public ImsFeature getImsFeatureFromType(SparseArray<ImsFeature> sparseArray, int n) {
        return InvokeDynamicSupport.bootstrap("getImsFeatureFromType", $$robo$$android_telephony_ims_ImsService$getImsFeatureFromType(android.util.SparseArray<android.telephony.ims.feature.ImsFeature> int ), 0, this, sparseArray, n);
    }

    private ImsFeature makeImsFeature(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("makeImsFeature", $$robo$$android_telephony_ims_ImsService$makeImsFeature(int int ), 0, this, n, n2);
    }

    private void enforceReadPhoneStatePermission(String string2) {
        InvokeDynamicSupport.bootstrap("enforceReadPhoneStatePermission", $$robo$$android_telephony_ims_ImsService$enforceReadPhoneStatePermission(java.lang.String ), 0, this, string2);
    }

    public MMTelFeature onCreateEmergencyMMTelImsFeature(int n) {
        return InvokeDynamicSupport.bootstrap("onCreateEmergencyMMTelImsFeature", $$robo$$android_telephony_ims_ImsService$onCreateEmergencyMMTelImsFeature(int ), 0, this, n);
    }

    public MMTelFeature onCreateMMTelImsFeature(int n) {
        return InvokeDynamicSupport.bootstrap("onCreateMMTelImsFeature", $$robo$$android_telephony_ims_ImsService$onCreateMMTelImsFeature(int ), 0, this, n);
    }

    public RcsFeature onCreateRcsFeature(int n) {
        return InvokeDynamicSupport.bootstrap("onCreateRcsFeature", $$robo$$android_telephony_ims_ImsService$onCreateRcsFeature(int ), 0, this, n);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

