/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.feature;

import android.content.Context;
import android.content.Intent;
import android.os.RemoteException;
import android.util.Log;
import com.android.ims.internal.IImsFeatureStatusCallback;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class ImsFeature
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "ImsFeature";
    public static String ACTION_IMS_SERVICE_UP = "com.android.ims.IMS_SERVICE_UP";
    public static String ACTION_IMS_SERVICE_DOWN = "com.android.ims.IMS_SERVICE_DOWN";
    public static String EXTRA_PHONE_ID = "android:phone_id";
    public static int INVALID = -1;
    public static int EMERGENCY_MMTEL = 0;
    public static int MMTEL = 1;
    public static int RCS = 2;
    public static int MAX = 3;
    public static int STATE_NOT_AVAILABLE = 0;
    public static int STATE_INITIALIZING = 1;
    public static int STATE_READY = 2;
    private List<INotifyFeatureRemoved> mRemovedListeners;
    private Set<IImsFeatureStatusCallback> mStatusCallbacks;
    private int mState;
    private int mSlotId;
    private Context mContext;

    private void $$robo$$android_telephony_ims_feature_ImsFeature$__constructor__() {
        this.mRemovedListeners = new ArrayList<INotifyFeatureRemoved>();
        this.mStatusCallbacks = Collections.newSetFromMap(new WeakHashMap());
        this.mState = 0;
        this.mSlotId = -1;
    }

    private final void $$robo$$android_telephony_ims_feature_ImsFeature$setContext(Context context) {
        this.mContext = context;
    }

    private final void $$robo$$android_telephony_ims_feature_ImsFeature$setSlotId(int slotId) {
        this.mSlotId = slotId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_telephony_ims_feature_ImsFeature$addFeatureRemovedListener(INotifyFeatureRemoved listener) {
        List<INotifyFeatureRemoved> list = this.mRemovedListeners;
        synchronized (list) {
            this.mRemovedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_telephony_ims_feature_ImsFeature$removeFeatureRemovedListener(INotifyFeatureRemoved listener) {
        List<INotifyFeatureRemoved> list = this.mRemovedListeners;
        synchronized (list) {
            this.mRemovedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_telephony_ims_feature_ImsFeature$notifyFeatureRemoved(int slotId) {
        List<INotifyFeatureRemoved> list = this.mRemovedListeners;
        synchronized (list) {
            this.mRemovedListeners.forEach(l -> l.onFeatureRemoved(slotId));
            this.onFeatureRemoved();
        }
    }

    private final int $$robo$$android_telephony_ims_feature_ImsFeature$getFeatureState() {
        return this.mState;
    }

    private final void $$robo$$android_telephony_ims_feature_ImsFeature$setFeatureState(int state) {
        if (this.mState != state) {
            this.mState = state;
            this.notifyFeatureState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_telephony_ims_feature_ImsFeature$addImsFeatureStatusCallback(IImsFeatureStatusCallback c) {
        if (c == null) {
            return;
        }
        try {
            c.notifyImsFeatureStatus(this.mState);
            Set<IImsFeatureStatusCallback> set = this.mStatusCallbacks;
            synchronized (set) {
                this.mStatusCallbacks.add(c);
            }
        }
        catch (RemoteException e) {
            Log.w("ImsFeature", "Couldn't notify feature state: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_telephony_ims_feature_ImsFeature$removeImsFeatureStatusCallback(IImsFeatureStatusCallback c) {
        if (c == null) {
            return;
        }
        Set<IImsFeatureStatusCallback> set = this.mStatusCallbacks;
        synchronized (set) {
            this.mStatusCallbacks.remove(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_telephony_ims_feature_ImsFeature$notifyFeatureState(int state) {
        Set<IImsFeatureStatusCallback> set = this.mStatusCallbacks;
        synchronized (set) {
            Iterator<IImsFeatureStatusCallback> iter = this.mStatusCallbacks.iterator();
            while (iter.hasNext()) {
                IImsFeatureStatusCallback callback = iter.next();
                try {
                    Log.i("ImsFeature", "notifying ImsFeatureState=" + state);
                    callback.notifyImsFeatureStatus(state);
                }
                catch (RemoteException e) {
                    iter.remove();
                    Log.w("ImsFeature", "Couldn't notify feature state: " + e.getMessage());
                }
            }
        }
        this.sendImsServiceIntent(state);
    }

    private final void $$robo$$android_telephony_ims_feature_ImsFeature$sendImsServiceIntent(int state) {
        Intent intent;
        if (this.mContext == null || this.mSlotId == -1) {
            return;
        }
        switch (state) {
            case 0: 
            case 1: {
                intent = new Intent("com.android.ims.IMS_SERVICE_DOWN");
                break;
            }
            case 2: {
                intent = new Intent("com.android.ims.IMS_SERVICE_UP");
                break;
            }
            default: {
                intent = new Intent("com.android.ims.IMS_SERVICE_DOWN");
            }
        }
        intent.putExtra("android:phone_id", this.mSlotId);
        this.mContext.sendBroadcast(intent);
    }

    public abstract void onFeatureRemoved();

    private void __constructor__() {
        this.$$robo$$android_telephony_ims_feature_ImsFeature$__constructor__();
    }

    public ImsFeature() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ims_feature_ImsFeature$__constructor__(), 0, this);
    }

    public void setContext(Context context) {
        InvokeDynamicSupport.bootstrap("setContext", $$robo$$android_telephony_ims_feature_ImsFeature$setContext(android.content.Context ), 0, this, context);
    }

    public void setSlotId(int n) {
        InvokeDynamicSupport.bootstrap("setSlotId", $$robo$$android_telephony_ims_feature_ImsFeature$setSlotId(int ), 0, this, n);
    }

    public void addFeatureRemovedListener(INotifyFeatureRemoved iNotifyFeatureRemoved) {
        InvokeDynamicSupport.bootstrap("addFeatureRemovedListener", $$robo$$android_telephony_ims_feature_ImsFeature$addFeatureRemovedListener(android.telephony.ims.feature.ImsFeature$INotifyFeatureRemoved ), 0, this, iNotifyFeatureRemoved);
    }

    public void removeFeatureRemovedListener(INotifyFeatureRemoved iNotifyFeatureRemoved) {
        InvokeDynamicSupport.bootstrap("removeFeatureRemovedListener", $$robo$$android_telephony_ims_feature_ImsFeature$removeFeatureRemovedListener(android.telephony.ims.feature.ImsFeature$INotifyFeatureRemoved ), 0, this, iNotifyFeatureRemoved);
    }

    public void notifyFeatureRemoved(int n) {
        InvokeDynamicSupport.bootstrap("notifyFeatureRemoved", $$robo$$android_telephony_ims_feature_ImsFeature$notifyFeatureRemoved(int ), 0, this, n);
    }

    public int getFeatureState() {
        return (int)InvokeDynamicSupport.bootstrap("getFeatureState", $$robo$$android_telephony_ims_feature_ImsFeature$getFeatureState(), 0, this);
    }

    protected void setFeatureState(int n) {
        InvokeDynamicSupport.bootstrap("setFeatureState", $$robo$$android_telephony_ims_feature_ImsFeature$setFeatureState(int ), 0, this, n);
    }

    public void addImsFeatureStatusCallback(IImsFeatureStatusCallback iImsFeatureStatusCallback) {
        InvokeDynamicSupport.bootstrap("addImsFeatureStatusCallback", $$robo$$android_telephony_ims_feature_ImsFeature$addImsFeatureStatusCallback(com.android.ims.internal.IImsFeatureStatusCallback ), 0, this, iImsFeatureStatusCallback);
    }

    public void removeImsFeatureStatusCallback(IImsFeatureStatusCallback iImsFeatureStatusCallback) {
        InvokeDynamicSupport.bootstrap("removeImsFeatureStatusCallback", $$robo$$android_telephony_ims_feature_ImsFeature$removeImsFeatureStatusCallback(com.android.ims.internal.IImsFeatureStatusCallback ), 0, this, iImsFeatureStatusCallback);
    }

    private void notifyFeatureState(int n) {
        InvokeDynamicSupport.bootstrap("notifyFeatureState", $$robo$$android_telephony_ims_feature_ImsFeature$notifyFeatureState(int ), 0, this, n);
    }

    private void sendImsServiceIntent(int n) {
        InvokeDynamicSupport.bootstrap("sendImsServiceIntent", $$robo$$android_telephony_ims_feature_ImsFeature$sendImsServiceIntent(int ), 0, this, n);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsFeature)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface INotifyFeatureRemoved
    extends InstrumentedInterface {
        public void onFeatureRemoved(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ImsState {
    }
}

