/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.mbms;

import android.content.Intent;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.mbms.FileServiceInfo;
import android.util.Base64;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class DownloadRequest
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int CURRENT_VERSION = 1;
    private static String LOG_TAG = "MbmsDownloadRequest";
    public static int MAX_APP_INTENT_SIZE = 50000;
    public static int MAX_DESTINATION_URI_SIZE = 50000;
    private String fileServiceId;
    private Uri sourceUri;
    private int subscriptionId;
    private String serializedResultIntentForApp;
    private int version;
    public static Parcelable.Creator<DownloadRequest> CREATOR;

    private void $$robo$$android_telephony_mbms_DownloadRequest$__constructor__(String fileServiceId, Uri source, int sub, String appIntent, int version) {
        this.fileServiceId = fileServiceId;
        this.sourceUri = source;
        this.subscriptionId = sub;
        this.serializedResultIntentForApp = appIntent;
        this.version = version;
    }

    private static final DownloadRequest $$robo$$android_telephony_mbms_DownloadRequest$copy(DownloadRequest other) {
        return new DownloadRequest(other);
    }

    private void $$robo$$android_telephony_mbms_DownloadRequest$__constructor__(DownloadRequest dr) {
        this.fileServiceId = dr.fileServiceId;
        this.sourceUri = dr.sourceUri;
        this.subscriptionId = dr.subscriptionId;
        this.serializedResultIntentForApp = dr.serializedResultIntentForApp;
        this.version = dr.version;
    }

    private void $$robo$$android_telephony_mbms_DownloadRequest$__constructor__(Parcel in) {
        this.fileServiceId = in.readString();
        this.sourceUri = (Uri)in.readParcelable(this.getClass().getClassLoader());
        this.subscriptionId = in.readInt();
        this.serializedResultIntentForApp = in.readString();
        this.version = in.readInt();
    }

    private final int $$robo$$android_telephony_mbms_DownloadRequest$describeContents() {
        return 0;
    }

    private final void $$robo$$android_telephony_mbms_DownloadRequest$writeToParcel(Parcel out, int flags) {
        out.writeString(this.fileServiceId);
        out.writeParcelable(this.sourceUri, flags);
        out.writeInt(this.subscriptionId);
        out.writeString(this.serializedResultIntentForApp);
        out.writeInt(this.version);
    }

    private final String $$robo$$android_telephony_mbms_DownloadRequest$getFileServiceId() {
        return this.fileServiceId;
    }

    private final Uri $$robo$$android_telephony_mbms_DownloadRequest$getSourceUri() {
        return this.sourceUri;
    }

    private final int $$robo$$android_telephony_mbms_DownloadRequest$getSubscriptionId() {
        return this.subscriptionId;
    }

    private final Intent $$robo$$android_telephony_mbms_DownloadRequest$getIntentForApp() {
        try {
            return Intent.parseUri(this.serializedResultIntentForApp, 0);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private final byte[] $$robo$$android_telephony_mbms_DownloadRequest$getOpaqueData() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream stream = new ObjectOutputStream(byteArrayOutputStream);
            OpaqueDataContainer container = new OpaqueDataContainer(this.serializedResultIntentForApp, this.version);
            stream.writeObject(container);
            stream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            Log.e("MbmsDownloadRequest", "Got IOException trying to serialize opaque data");
            return null;
        }
    }

    private final int $$robo$$android_telephony_mbms_DownloadRequest$getVersion() {
        return this.version;
    }

    private static final int $$robo$$android_telephony_mbms_DownloadRequest$getMaxAppIntentSize() {
        return 50000;
    }

    private static final int $$robo$$android_telephony_mbms_DownloadRequest$getMaxDestinationUriSize() {
        return 50000;
    }

    private final boolean $$robo$$android_telephony_mbms_DownloadRequest$isMultipartDownload() {
        return this.getSourceUri().getLastPathSegment() != null && this.getSourceUri().getLastPathSegment().contains("*");
    }

    private final String $$robo$$android_telephony_mbms_DownloadRequest$getHash() {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not get sha256 hash object");
        }
        if (this.version >= 1) {
            digest.update(this.sourceUri.toString().getBytes(StandardCharsets.UTF_8));
            if (this.serializedResultIntentForApp != null) {
                digest.update(this.serializedResultIntentForApp.getBytes(StandardCharsets.UTF_8));
            }
        }
        return Base64.encodeToString(digest.digest(), 10);
    }

    private final boolean $$robo$$android_telephony_mbms_DownloadRequest$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof DownloadRequest)) {
            return false;
        }
        DownloadRequest request = (DownloadRequest)o;
        return this.subscriptionId == request.subscriptionId && this.version == request.version && Objects.equals(this.fileServiceId, request.fileServiceId) && Objects.equals(this.sourceUri, request.sourceUri) && Objects.equals(this.serializedResultIntentForApp, request.serializedResultIntentForApp);
    }

    private final int $$robo$$android_telephony_mbms_DownloadRequest$hashCode() {
        return Objects.hash(this.fileServiceId, this.sourceUri, this.subscriptionId, this.serializedResultIntentForApp, this.version);
    }

    private /* synthetic */ void $$robo$$android_telephony_mbms_DownloadRequest$__constructor__(String x0, Uri x1, int x2, String x3, int x4, 1 x5) {
    }

    private /* synthetic */ void $$robo$$android_telephony_mbms_DownloadRequest$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<DownloadRequest>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_telephony_mbms_DownloadRequest_1$__constructor__() {
            }

            private final DownloadRequest $$robo$$android_telephony_mbms_DownloadRequest_1$createFromParcel(Parcel in) {
                return new DownloadRequest(in);
            }

            private final DownloadRequest[] $$robo$$android_telephony_mbms_DownloadRequest_1$newArray(int size) {
                return new DownloadRequest[size];
            }

            private void __constructor__() {
                this.$$robo$$android_telephony_mbms_DownloadRequest_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_mbms_DownloadRequest_1$__constructor__(), 0, this);
            }

            @Override
            public DownloadRequest createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_telephony_mbms_DownloadRequest_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public DownloadRequest[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_telephony_mbms_DownloadRequest_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(String string2, Uri uri, int n, String string3, int n2) {
        this.$$robo$$android_telephony_mbms_DownloadRequest$__constructor__(string2, uri, n, string3, n2);
    }

    private DownloadRequest(String string2, Uri uri, int n, String string3, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_mbms_DownloadRequest$__constructor__(java.lang.String android.net.Uri int java.lang.String int ), 0, this, string2, uri, n, string3, n2);
    }

    public static DownloadRequest copy(DownloadRequest downloadRequest) {
        return InvokeDynamicSupport.bootstrapStatic("copy", $$robo$$android_telephony_mbms_DownloadRequest$copy(android.telephony.mbms.DownloadRequest ), 0, (DownloadRequest)downloadRequest);
    }

    private void __constructor__(DownloadRequest downloadRequest) {
        this.$$robo$$android_telephony_mbms_DownloadRequest$__constructor__(downloadRequest);
    }

    private DownloadRequest(DownloadRequest downloadRequest) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_mbms_DownloadRequest$__constructor__(android.telephony.mbms.DownloadRequest ), 0, this, downloadRequest);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_telephony_mbms_DownloadRequest$__constructor__(parcel);
    }

    private DownloadRequest(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_mbms_DownloadRequest$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_telephony_mbms_DownloadRequest$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_telephony_mbms_DownloadRequest$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public String getFileServiceId() {
        return InvokeDynamicSupport.bootstrap("getFileServiceId", $$robo$$android_telephony_mbms_DownloadRequest$getFileServiceId(), 0, this);
    }

    public Uri getSourceUri() {
        return InvokeDynamicSupport.bootstrap("getSourceUri", $$robo$$android_telephony_mbms_DownloadRequest$getSourceUri(), 0, this);
    }

    public int getSubscriptionId() {
        return (int)InvokeDynamicSupport.bootstrap("getSubscriptionId", $$robo$$android_telephony_mbms_DownloadRequest$getSubscriptionId(), 0, this);
    }

    public Intent getIntentForApp() {
        return InvokeDynamicSupport.bootstrap("getIntentForApp", $$robo$$android_telephony_mbms_DownloadRequest$getIntentForApp(), 0, this);
    }

    public byte[] getOpaqueData() {
        return InvokeDynamicSupport.bootstrap("getOpaqueData", $$robo$$android_telephony_mbms_DownloadRequest$getOpaqueData(), 0, this);
    }

    public int getVersion() {
        return (int)InvokeDynamicSupport.bootstrap("getVersion", $$robo$$android_telephony_mbms_DownloadRequest$getVersion(), 0, this);
    }

    public static int getMaxAppIntentSize() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMaxAppIntentSize", $$robo$$android_telephony_mbms_DownloadRequest$getMaxAppIntentSize(), 0);
    }

    public static int getMaxDestinationUriSize() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMaxDestinationUriSize", $$robo$$android_telephony_mbms_DownloadRequest$getMaxDestinationUriSize(), 0);
    }

    public boolean isMultipartDownload() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMultipartDownload", $$robo$$android_telephony_mbms_DownloadRequest$isMultipartDownload(), 0, this);
    }

    public String getHash() {
        return InvokeDynamicSupport.bootstrap("getHash", $$robo$$android_telephony_mbms_DownloadRequest$getHash(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_telephony_mbms_DownloadRequest$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_telephony_mbms_DownloadRequest$hashCode(), 0, this);
    }

    private /* synthetic */ void __constructor__(String string2, Uri uri, int n, String string3, int n2, 1 var6_6) {
        this.$$robo$$android_telephony_mbms_DownloadRequest$__constructor__(string2, uri, n, string3, n2, var6_6);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_telephony_mbms_DownloadRequest$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(DownloadRequest.class);
    }

    public /* synthetic */ DownloadRequest() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DownloadRequest)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String fileServiceId;
        private Uri source;
        private int subscriptionId;
        private String appIntent;
        private int version;

        private void $$robo$$android_telephony_mbms_DownloadRequest_Builder$__constructor__(Uri sourceUri) {
            this.version = 1;
            if (sourceUri == null) {
                throw new IllegalArgumentException("Source URI must be non-null.");
            }
            this.source = sourceUri;
        }

        private final Builder $$robo$$android_telephony_mbms_DownloadRequest_Builder$setServiceInfo(FileServiceInfo serviceInfo) {
            this.fileServiceId = serviceInfo.getServiceId();
            return this;
        }

        private final Builder $$robo$$android_telephony_mbms_DownloadRequest_Builder$setServiceId(String serviceId) {
            this.fileServiceId = serviceId;
            return this;
        }

        private final Builder $$robo$$android_telephony_mbms_DownloadRequest_Builder$setSubscriptionId(int subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        private final Builder $$robo$$android_telephony_mbms_DownloadRequest_Builder$setAppIntent(Intent intent) {
            this.appIntent = intent.toUri(0);
            if (this.appIntent.length() > 50000) {
                throw new IllegalArgumentException("App intent must not exceed length 50000");
            }
            return this;
        }

        private final Builder $$robo$$android_telephony_mbms_DownloadRequest_Builder$setOpaqueData(byte[] data) {
            try {
                ObjectInputStream stream = new ObjectInputStream(new ByteArrayInputStream(data));
                OpaqueDataContainer dataContainer = (OpaqueDataContainer)stream.readObject();
                this.version = dataContainer.version;
                this.appIntent = dataContainer.appIntent;
            }
            catch (IOException e) {
                Log.e("MbmsDownloadRequest", "Got IOException trying to parse opaque data");
                throw new IllegalArgumentException(e);
            }
            catch (ClassNotFoundException e) {
                Log.e("MbmsDownloadRequest", "Got ClassNotFoundException trying to parse opaque data");
                throw new IllegalArgumentException(e);
            }
            return this;
        }

        private final DownloadRequest $$robo$$android_telephony_mbms_DownloadRequest_Builder$build() {
            return new DownloadRequest(this.fileServiceId, this.source, this.subscriptionId, this.appIntent, this.version);
        }

        private void __constructor__(Uri uri) {
            this.$$robo$$android_telephony_mbms_DownloadRequest_Builder$__constructor__(uri);
        }

        public Builder(Uri uri) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_mbms_DownloadRequest_Builder$__constructor__(android.net.Uri ), 0, this, uri);
        }

        public Builder setServiceInfo(FileServiceInfo fileServiceInfo) {
            return InvokeDynamicSupport.bootstrap("setServiceInfo", $$robo$$android_telephony_mbms_DownloadRequest_Builder$setServiceInfo(android.telephony.mbms.FileServiceInfo ), 0, this, fileServiceInfo);
        }

        public Builder setServiceId(String string2) {
            return InvokeDynamicSupport.bootstrap("setServiceId", $$robo$$android_telephony_mbms_DownloadRequest_Builder$setServiceId(java.lang.String ), 0, this, string2);
        }

        public Builder setSubscriptionId(int n) {
            return InvokeDynamicSupport.bootstrap("setSubscriptionId", $$robo$$android_telephony_mbms_DownloadRequest_Builder$setSubscriptionId(int ), 0, this, n);
        }

        public Builder setAppIntent(Intent intent) {
            return InvokeDynamicSupport.bootstrap("setAppIntent", $$robo$$android_telephony_mbms_DownloadRequest_Builder$setAppIntent(android.content.Intent ), 0, this, intent);
        }

        public Builder setOpaqueData(byte[] byArray) {
            return InvokeDynamicSupport.bootstrap("setOpaqueData", $$robo$$android_telephony_mbms_DownloadRequest_Builder$setOpaqueData(byte[] ), 0, this, byArray);
        }

        public DownloadRequest build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_telephony_mbms_DownloadRequest_Builder$build(), 0, this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class OpaqueDataContainer
    implements Serializable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String appIntent;
        private int version;

        private void $$robo$$android_telephony_mbms_DownloadRequest_OpaqueDataContainer$__constructor__(String appIntent, int version) {
            this.appIntent = appIntent;
            this.version = version;
        }

        private void __constructor__(String string2, int n) {
            this.$$robo$$android_telephony_mbms_DownloadRequest_OpaqueDataContainer$__constructor__(string2, n);
        }

        public OpaqueDataContainer(String string2, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_mbms_DownloadRequest_OpaqueDataContainer$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        public /* synthetic */ OpaqueDataContainer() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OpaqueDataContainer)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

