/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.mbms;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.telephony.mbms.DownloadRequest;
import android.telephony.mbms.FileInfo;
import android.telephony.mbms.MbmsTempFileProvider;
import android.telephony.mbms.MbmsUtils;
import android.telephony.mbms.UriPathPair;
import android.util.Log;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MbmsDownloadReceiver
extends BroadcastReceiver
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String DOWNLOAD_TOKEN_SUFFIX = ".download_token";
    public static String MBMS_FILE_PROVIDER_META_DATA_KEY = "mbms-file-provider-authority";
    public static int RESULT_OK = 0;
    public static int RESULT_INVALID_ACTION = 1;
    public static int RESULT_MALFORMED_INTENT = 2;
    public static int RESULT_BAD_TEMP_FILE_ROOT = 3;
    public static int RESULT_DOWNLOAD_FINALIZATION_ERROR = 4;
    public static int RESULT_TEMP_FILE_GENERATION_ERROR = 5;
    public static int RESULT_APP_NOTIFICATION_ERROR = 6;
    private static String LOG_TAG = "MbmsDownloadReceiver";
    private static String TEMP_FILE_SUFFIX = ".embms.temp";
    private static String TEMP_FILE_STAGING_LOCATION = "staged_completed_files";
    private static int MAX_TEMP_FILE_RETRIES = 5;
    private String mFileProviderAuthorityCache;
    private String mMiddlewarePackageNameCache;

    private void $$robo$$android_telephony_mbms_MbmsDownloadReceiver$__constructor__() {
        this.mFileProviderAuthorityCache = null;
        this.mMiddlewarePackageNameCache = null;
    }

    private final void $$robo$$android_telephony_mbms_MbmsDownloadReceiver$onReceive(Context context, Intent intent) {
        if (!this.verifyIntentContents(context, intent)) {
            this.setResultCode(2);
            return;
        }
        if (!Objects.equals(intent.getStringExtra("android.telephony.mbms.extra.TEMP_FILE_ROOT"), MbmsTempFileProvider.getEmbmsTempFileDir(context).getPath())) {
            this.setResultCode(3);
            return;
        }
        if ("android.telephony.mbms.action.DOWNLOAD_RESULT_INTERNAL".equals(intent.getAction())) {
            this.moveDownloadedFile(context, intent);
            this.cleanupPostMove(context, intent);
        } else if ("android.telephony.mbms.action.FILE_DESCRIPTOR_REQUEST".equals(intent.getAction())) {
            this.generateTempFiles(context, intent);
        } else if ("android.telephony.mbms.action.CLEANUP".equals(intent.getAction())) {
            this.cleanupTempFiles(context, intent);
        } else {
            this.setResultCode(1);
        }
    }

    private final boolean $$robo$$android_telephony_mbms_MbmsDownloadReceiver$verifyIntentContents(Context context, Intent intent) {
        if ("android.telephony.mbms.action.DOWNLOAD_RESULT_INTERNAL".equals(intent.getAction())) {
            if (!intent.hasExtra("android.telephony.extra.MBMS_DOWNLOAD_RESULT")) {
                Log.w("MbmsDownloadReceiver", "Download result did not include a result code. Ignoring.");
                return false;
            }
            if (1 != intent.getIntExtra("android.telephony.extra.MBMS_DOWNLOAD_RESULT", 2)) {
                return true;
            }
            if (!intent.hasExtra("android.telephony.extra.MBMS_DOWNLOAD_REQUEST")) {
                Log.w("MbmsDownloadReceiver", "Download result did not include the associated request. Ignoring.");
                return false;
            }
            if (!intent.hasExtra("android.telephony.mbms.extra.TEMP_FILE_ROOT")) {
                Log.w("MbmsDownloadReceiver", "Download result did not include the temp file root. Ignoring.");
                return false;
            }
            if (!intent.hasExtra("android.telephony.extra.MBMS_FILE_INFO")) {
                Log.w("MbmsDownloadReceiver", "Download result did not include the associated file info. Ignoring.");
                return false;
            }
            if (!intent.hasExtra("android.telephony.mbms.extra.FINAL_URI")) {
                Log.w("MbmsDownloadReceiver", "Download result did not include the path to the final temp file. Ignoring.");
                return false;
            }
            DownloadRequest request = (DownloadRequest)intent.getParcelableExtra("android.telephony.extra.MBMS_DOWNLOAD_REQUEST");
            String expectedTokenFileName = request.getHash() + ".download_token";
            File expectedTokenFile = new File(MbmsUtils.getEmbmsTempFileDirForService(context, request.getFileServiceId()), expectedTokenFileName);
            if (!expectedTokenFile.exists()) {
                Log.w("MbmsDownloadReceiver", "Supplied download request does not match a token that we have. Expected " + expectedTokenFile);
                return false;
            }
        } else if ("android.telephony.mbms.action.FILE_DESCRIPTOR_REQUEST".equals(intent.getAction())) {
            if (!intent.hasExtra("android.telephony.mbms.extra.SERVICE_ID")) {
                Log.w("MbmsDownloadReceiver", "Temp file request did not include the associated service id. Ignoring.");
                return false;
            }
            if (!intent.hasExtra("android.telephony.mbms.extra.TEMP_FILE_ROOT")) {
                Log.w("MbmsDownloadReceiver", "Download result did not include the temp file root. Ignoring.");
                return false;
            }
        } else if ("android.telephony.mbms.action.CLEANUP".equals(intent.getAction())) {
            if (!intent.hasExtra("android.telephony.mbms.extra.SERVICE_ID")) {
                Log.w("MbmsDownloadReceiver", "Cleanup request did not include the associated service id. Ignoring.");
                return false;
            }
            if (!intent.hasExtra("android.telephony.mbms.extra.TEMP_FILE_ROOT")) {
                Log.w("MbmsDownloadReceiver", "Cleanup request did not include the temp file root. Ignoring.");
                return false;
            }
            if (!intent.hasExtra("android.telephony.mbms.extra.TEMP_FILES_IN_USE")) {
                Log.w("MbmsDownloadReceiver", "Cleanup request did not include the list of temp files in use. Ignoring.");
                return false;
            }
        }
        return true;
    }

    private final void $$robo$$android_telephony_mbms_MbmsDownloadReceiver$moveDownloadedFile(Context context, Intent intent) {
        Uri stagedFileLocation;
        DownloadRequest request = (DownloadRequest)intent.getParcelableExtra("android.telephony.extra.MBMS_DOWNLOAD_REQUEST");
        Intent intentForApp = request.getIntentForApp();
        if (intentForApp == null) {
            Log.i("MbmsDownloadReceiver", "Malformed app notification intent");
            this.setResultCode(6);
            return;
        }
        int result = intent.getIntExtra("android.telephony.extra.MBMS_DOWNLOAD_RESULT", 2);
        intentForApp.putExtra("android.telephony.extra.MBMS_DOWNLOAD_RESULT", result);
        if (result != 1) {
            Log.i("MbmsDownloadReceiver", "Download request indicated a failed download. Aborting.");
            context.sendBroadcast(intentForApp);
            return;
        }
        Uri finalTempFile = (Uri)intent.getParcelableExtra("android.telephony.mbms.extra.FINAL_URI");
        if (!MbmsDownloadReceiver.verifyTempFilePath(context, request.getFileServiceId(), finalTempFile)) {
            Log.w("MbmsDownloadReceiver", "Download result specified an invalid temp file " + finalTempFile);
            this.setResultCode(4);
            return;
        }
        FileInfo completedFileInfo = (FileInfo)intent.getParcelableExtra("android.telephony.extra.MBMS_FILE_INFO");
        Path stagingDirectory = FileSystems.getDefault().getPath(MbmsTempFileProvider.getEmbmsTempFileDir(context).getPath(), "staged_completed_files");
        try {
            stagedFileLocation = MbmsDownloadReceiver.stageTempFile(finalTempFile, stagingDirectory);
        }
        catch (IOException e) {
            Log.w("MbmsDownloadReceiver", "Failed to move temp file to final destination");
            this.setResultCode(4);
            return;
        }
        intentForApp.putExtra("android.telephony.extra.MBMS_COMPLETED_FILE_URI", stagedFileLocation);
        intentForApp.putExtra("android.telephony.extra.MBMS_FILE_INFO", completedFileInfo);
        intentForApp.putExtra("android.telephony.extra.MBMS_DOWNLOAD_REQUEST", request);
        context.sendBroadcast(intentForApp);
        this.setResultCode(0);
    }

    private final void $$robo$$android_telephony_mbms_MbmsDownloadReceiver$cleanupPostMove(Context context, Intent intent) {
        DownloadRequest request = (DownloadRequest)intent.getParcelableExtra("android.telephony.extra.MBMS_DOWNLOAD_REQUEST");
        if (request == null) {
            Log.w("MbmsDownloadReceiver", "Intent does not include a DownloadRequest. Ignoring.");
            return;
        }
        ArrayList tempFiles = intent.getParcelableArrayListExtra("android.telephony.mbms.extra.TEMP_LIST");
        if (tempFiles == null) {
            return;
        }
        for (Uri tempFileUri : tempFiles) {
            if (!MbmsDownloadReceiver.verifyTempFilePath(context, request.getFileServiceId(), tempFileUri)) continue;
            File tempFile = new File(tempFileUri.getSchemeSpecificPart());
            tempFile.delete();
        }
    }

    private final void $$robo$$android_telephony_mbms_MbmsDownloadReceiver$generateTempFiles(Context context, Intent intent) {
        String serviceId = intent.getStringExtra("android.telephony.mbms.extra.SERVICE_ID");
        if (serviceId == null) {
            Log.w("MbmsDownloadReceiver", "Temp file request did not include the associated service id. Ignoring.");
            this.setResultCode(2);
            return;
        }
        int fdCount = intent.getIntExtra("android.telephony.mbms.extra.FD_COUNT", 0);
        ArrayList<Uri> pausedList = intent.getParcelableArrayListExtra("android.telephony.mbms.extra.PAUSED_LIST");
        if (fdCount == 0 && (pausedList == null || pausedList.size() == 0)) {
            Log.i("MbmsDownloadReceiver", "No temp files actually requested. Ending.");
            this.setResultCode(0);
            this.setResultExtras(Bundle.EMPTY);
            return;
        }
        ArrayList<UriPathPair> freshTempFiles = this.generateFreshTempFiles(context, serviceId, fdCount);
        ArrayList<UriPathPair> pausedFiles = this.generateUrisForPausedFiles(context, serviceId, pausedList);
        Bundle result = new Bundle();
        result.putParcelableArrayList("android.telephony.mbms.extra.FREE_URI_LIST", freshTempFiles);
        result.putParcelableArrayList("android.telephony.mbms.extra.PAUSED_URI_LIST", pausedFiles);
        this.setResultCode(0);
        this.setResultExtras(result);
    }

    private final ArrayList<UriPathPair> $$robo$$android_telephony_mbms_MbmsDownloadReceiver$generateFreshTempFiles(Context context, String serviceId, int freshFdCount) {
        File tempFileDir = MbmsUtils.getEmbmsTempFileDirForService(context, serviceId);
        if (!tempFileDir.exists()) {
            tempFileDir.mkdirs();
        }
        ArrayList<UriPathPair> result = new ArrayList<UriPathPair>(freshFdCount);
        for (int i = 0; i < freshFdCount; ++i) {
            File tempFile = MbmsDownloadReceiver.generateSingleTempFile(tempFileDir);
            if (tempFile == null) {
                this.setResultCode(5);
                Log.w("MbmsDownloadReceiver", "Failed to generate a temp file. Moving on.");
                continue;
            }
            Uri fileUri = Uri.fromFile(tempFile);
            Uri contentUri = MbmsTempFileProvider.getUriForFile(context, this.getFileProviderAuthorityCached(context), tempFile);
            context.grantUriPermission(this.getMiddlewarePackageCached(context), contentUri, 3);
            result.add(new UriPathPair(fileUri, contentUri));
        }
        return result;
    }

    private static final File $$robo$$android_telephony_mbms_MbmsDownloadReceiver$generateSingleTempFile(File tempFileDir) {
        for (int numTries = 0; numTries < 5; ++numTries) {
            String fileName = UUID.randomUUID() + ".embms.temp";
            File tempFile = new File(tempFileDir, fileName);
            try {
                if (!tempFile.createNewFile()) continue;
                return tempFile.getCanonicalFile();
            }
            catch (IOException e) {
                continue;
            }
        }
        return null;
    }

    private final ArrayList<UriPathPair> $$robo$$android_telephony_mbms_MbmsDownloadReceiver$generateUrisForPausedFiles(Context context, String serviceId, List<Uri> pausedFiles) {
        if (pausedFiles == null) {
            return new ArrayList<UriPathPair>(0);
        }
        ArrayList<UriPathPair> result = new ArrayList<UriPathPair>(pausedFiles.size());
        for (Uri fileUri : pausedFiles) {
            if (!MbmsDownloadReceiver.verifyTempFilePath(context, serviceId, fileUri)) {
                Log.w("MbmsDownloadReceiver", "Supplied file " + fileUri + " is not a valid temp file to resume");
                this.setResultCode(5);
                continue;
            }
            File tempFile = new File(fileUri.getSchemeSpecificPart());
            if (!tempFile.exists()) {
                Log.w("MbmsDownloadReceiver", "Supplied file " + fileUri + " does not exist.");
                this.setResultCode(5);
                continue;
            }
            Uri contentUri = MbmsTempFileProvider.getUriForFile(context, this.getFileProviderAuthorityCached(context), tempFile);
            context.grantUriPermission(this.getMiddlewarePackageCached(context), contentUri, 3);
            result.add(new UriPathPair(fileUri, contentUri));
        }
        return result;
    }

    private final void $$robo$$android_telephony_mbms_MbmsDownloadReceiver$cleanupTempFiles(Context context, Intent intent) {
        File[] filesToDelete;
        String serviceId = intent.getStringExtra("android.telephony.mbms.extra.SERVICE_ID");
        File tempFileDir = MbmsUtils.getEmbmsTempFileDirForService(context, serviceId);
        ArrayList filesInUse = intent.getParcelableArrayListExtra("android.telephony.mbms.extra.TEMP_FILES_IN_USE");
        for (File fileToDelete : filesToDelete = tempFileDir.listFiles(new FileFilter(this, filesInUse){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ List val$filesInUse;
            /* synthetic */ MbmsDownloadReceiver this$0;

            private void $$robo$$android_telephony_mbms_MbmsDownloadReceiver_1$__constructor__(MbmsDownloadReceiver this$0, List list) {
            }

            private final boolean $$robo$$android_telephony_mbms_MbmsDownloadReceiver_1$accept(File file) {
                File canonicalFile;
                try {
                    canonicalFile = file.getCanonicalFile();
                }
                catch (IOException e) {
                    Log.w("MbmsDownloadReceiver", "Got IOException canonicalizing " + file + ", not deleting.");
                    return false;
                }
                if (!canonicalFile.getName().endsWith(".embms.temp")) {
                    return false;
                }
                Uri fileInUseUri = Uri.fromFile(canonicalFile);
                return !this.val$filesInUse.contains(fileInUseUri);
            }

            private void __constructor__(MbmsDownloadReceiver mbmsDownloadReceiver, List list) {
                this.$$robo$$android_telephony_mbms_MbmsDownloadReceiver_1$__constructor__(mbmsDownloadReceiver, list);
            }
            {
                this.this$0 = mbmsDownloadReceiver;
                this.val$filesInUse = list;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_mbms_MbmsDownloadReceiver_1$__constructor__(android.telephony.mbms.MbmsDownloadReceiver java.util.List ), 0, this, mbmsDownloadReceiver, list);
            }

            @Override
            public boolean accept(File file) {
                return (boolean)InvokeDynamicSupport.bootstrap("accept", $$robo$$android_telephony_mbms_MbmsDownloadReceiver_1$accept(java.io.File ), 0, this, file);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        })) {
            fileToDelete.delete();
        }
    }

    private static final Uri $$robo$$android_telephony_mbms_MbmsDownloadReceiver$stageTempFile(Uri fromPath, Path stagingDirectory) throws IOException {
        if (!"file".equals(fromPath.getScheme())) {
            Log.w("MbmsDownloadReceiver", "Moving source uri " + fromPath + " does not have a file scheme");
            return null;
        }
        Path fromFile = FileSystems.getDefault().getPath(fromPath.getPath(), new String[0]);
        if (!Files.isDirectory(stagingDirectory, new LinkOption[0])) {
            Files.createDirectory(stagingDirectory, new FileAttribute[0]);
        }
        Path result = Files.move(fromFile, stagingDirectory.resolve(fromFile.getFileName()), new CopyOption[0]);
        return Uri.fromFile(result.toFile());
    }

    private static final boolean $$robo$$android_telephony_mbms_MbmsDownloadReceiver$verifyTempFilePath(Context context, String serviceId, Uri filePath) {
        if (!"file".equals(filePath.getScheme())) {
            Log.w("MbmsDownloadReceiver", "Uri " + filePath + " does not have a file scheme");
            return false;
        }
        String path = filePath.getSchemeSpecificPart();
        File tempFile = new File(path);
        if (!tempFile.exists()) {
            Log.w("MbmsDownloadReceiver", "File at " + path + " does not exist.");
            return false;
        }
        return MbmsUtils.isContainedIn(MbmsUtils.getEmbmsTempFileDirForService(context, serviceId), tempFile);
    }

    private final String $$robo$$android_telephony_mbms_MbmsDownloadReceiver$getFileProviderAuthorityCached(Context context) {
        if (this.mFileProviderAuthorityCache != null) {
            return this.mFileProviderAuthorityCache;
        }
        this.mFileProviderAuthorityCache = MbmsDownloadReceiver.getFileProviderAuthority(context);
        return this.mFileProviderAuthorityCache;
    }

    private static final String $$robo$$android_telephony_mbms_MbmsDownloadReceiver$getFileProviderAuthority(Context context) {
        ApplicationInfo appInfo;
        try {
            appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Package manager couldn't find " + context.getPackageName());
        }
        if (appInfo.metaData == null) {
            throw new RuntimeException("App must declare the file provider authority as metadata in the manifest.");
        }
        String authority = appInfo.metaData.getString("mbms-file-provider-authority");
        if (authority == null) {
            throw new RuntimeException("App must declare the file provider authority as metadata in the manifest.");
        }
        return authority;
    }

    private final String $$robo$$android_telephony_mbms_MbmsDownloadReceiver$getMiddlewarePackageCached(Context context) {
        if (this.mMiddlewarePackageNameCache == null) {
            this.mMiddlewarePackageNameCache = MbmsUtils.getMiddlewareServiceInfo((Context)context, (String)"android.telephony.action.EmbmsDownload").packageName;
        }
        return this.mMiddlewarePackageNameCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean $$robo$$android_telephony_mbms_MbmsDownloadReceiver$manualMove(File src, File dst) {
        InputStream in = null;
        OutputStream out = null;
        try {
            int len;
            if (!dst.exists()) {
                dst.createNewFile();
            }
            in = new FileInputStream(src);
            out = new FileOutputStream(dst);
            byte[] buffer = new byte[2048];
            do {
                len = in.read(buffer);
                out.write(buffer, 0, len);
            } while (len > 0);
        }
        catch (IOException e) {
            Log.w("MbmsDownloadReceiver", "Manual file move failed due to exception " + e);
            if (dst.exists()) {
                dst.delete();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                Log.w("MbmsDownloadReceiver", "Error closing streams: " + e);
            }
        }
        return true;
    }

    private void __constructor__() {
        this.$$robo$$android_telephony_mbms_MbmsDownloadReceiver$__constructor__();
    }

    public MbmsDownloadReceiver() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_mbms_MbmsDownloadReceiver$__constructor__(), 0, this);
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        InvokeDynamicSupport.bootstrap("onReceive", $$robo$$android_telephony_mbms_MbmsDownloadReceiver$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
    }

    private boolean verifyIntentContents(Context context, Intent intent) {
        return (boolean)InvokeDynamicSupport.bootstrap("verifyIntentContents", $$robo$$android_telephony_mbms_MbmsDownloadReceiver$verifyIntentContents(android.content.Context android.content.Intent ), 0, this, context, intent);
    }

    private void moveDownloadedFile(Context context, Intent intent) {
        InvokeDynamicSupport.bootstrap("moveDownloadedFile", $$robo$$android_telephony_mbms_MbmsDownloadReceiver$moveDownloadedFile(android.content.Context android.content.Intent ), 0, this, context, intent);
    }

    private void cleanupPostMove(Context context, Intent intent) {
        InvokeDynamicSupport.bootstrap("cleanupPostMove", $$robo$$android_telephony_mbms_MbmsDownloadReceiver$cleanupPostMove(android.content.Context android.content.Intent ), 0, this, context, intent);
    }

    private void generateTempFiles(Context context, Intent intent) {
        InvokeDynamicSupport.bootstrap("generateTempFiles", $$robo$$android_telephony_mbms_MbmsDownloadReceiver$generateTempFiles(android.content.Context android.content.Intent ), 0, this, context, intent);
    }

    private ArrayList<UriPathPair> generateFreshTempFiles(Context context, String string2, int n) {
        return InvokeDynamicSupport.bootstrap("generateFreshTempFiles", $$robo$$android_telephony_mbms_MbmsDownloadReceiver$generateFreshTempFiles(android.content.Context java.lang.String int ), 0, this, context, string2, n);
    }

    private static File generateSingleTempFile(File file) {
        return InvokeDynamicSupport.bootstrapStatic("generateSingleTempFile", $$robo$$android_telephony_mbms_MbmsDownloadReceiver$generateSingleTempFile(java.io.File ), 0, (File)file);
    }

    private ArrayList<UriPathPair> generateUrisForPausedFiles(Context context, String string2, List<Uri> list) {
        return InvokeDynamicSupport.bootstrap("generateUrisForPausedFiles", $$robo$$android_telephony_mbms_MbmsDownloadReceiver$generateUrisForPausedFiles(android.content.Context java.lang.String java.util.List<android.net.Uri> ), 0, this, context, string2, list);
    }

    private void cleanupTempFiles(Context context, Intent intent) {
        InvokeDynamicSupport.bootstrap("cleanupTempFiles", $$robo$$android_telephony_mbms_MbmsDownloadReceiver$cleanupTempFiles(android.content.Context android.content.Intent ), 0, this, context, intent);
    }

    private static Uri stageTempFile(Uri uri, Path path) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("stageTempFile", $$robo$$android_telephony_mbms_MbmsDownloadReceiver$stageTempFile(android.net.Uri java.nio.file.Path ), 0, (Uri)uri, (Path)path);
    }

    private static boolean verifyTempFilePath(Context context, String string2, Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("verifyTempFilePath", $$robo$$android_telephony_mbms_MbmsDownloadReceiver$verifyTempFilePath(android.content.Context java.lang.String android.net.Uri ), 0, (Context)context, (String)string2, (Uri)uri);
    }

    private String getFileProviderAuthorityCached(Context context) {
        return InvokeDynamicSupport.bootstrap("getFileProviderAuthorityCached", $$robo$$android_telephony_mbms_MbmsDownloadReceiver$getFileProviderAuthorityCached(android.content.Context ), 0, this, context);
    }

    private static String getFileProviderAuthority(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getFileProviderAuthority", $$robo$$android_telephony_mbms_MbmsDownloadReceiver$getFileProviderAuthority(android.content.Context ), 0, (Context)context);
    }

    private String getMiddlewarePackageCached(Context context) {
        return InvokeDynamicSupport.bootstrap("getMiddlewarePackageCached", $$robo$$android_telephony_mbms_MbmsDownloadReceiver$getMiddlewarePackageCached(android.content.Context ), 0, this, context);
    }

    private static boolean manualMove(File file, File file2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("manualMove", $$robo$$android_telephony_mbms_MbmsDownloadReceiver$manualMove(java.io.File java.io.File ), 0, (File)file, (File)file2);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MbmsDownloadReceiver)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

