/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.mbms;

import android.net.Uri;
import android.os.RemoteException;
import android.telephony.MbmsStreamingSession;
import android.telephony.mbms.InternalStreamingServiceCallback;
import android.telephony.mbms.StreamingServiceInfo;
import android.telephony.mbms.vendor.IMbmsStreamingService;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class StreamingService
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "MbmsStreamingService";
    public static int STATE_STOPPED = 1;
    public static int STATE_STARTED = 2;
    public static int STATE_STALLED = 3;
    public static int REASON_NONE = 0;
    public static int REASON_BY_USER_REQUEST = 1;
    public static int REASON_END_OF_SESSION = 2;
    public static int REASON_FREQUENCY_CONFLICT = 3;
    public static int REASON_OUT_OF_MEMORY = 4;
    public static int REASON_NOT_CONNECTED_TO_HOMECARRIER_LTE = 5;
    public static int REASON_LEFT_MBMS_BROADCAST_AREA = 6;
    public static int BROADCAST_METHOD = 1;
    public static int UNICAST_METHOD = 2;
    private int mSubscriptionId;
    private MbmsStreamingSession mParentSession;
    private StreamingServiceInfo mServiceInfo;
    private InternalStreamingServiceCallback mCallback;
    private IMbmsStreamingService mService;

    private void $$robo$$android_telephony_mbms_StreamingService$__constructor__(int subscriptionId, IMbmsStreamingService service, MbmsStreamingSession session, StreamingServiceInfo streamingServiceInfo, InternalStreamingServiceCallback callback) {
        this.mSubscriptionId = subscriptionId;
        this.mParentSession = session;
        this.mService = service;
        this.mServiceInfo = streamingServiceInfo;
        this.mCallback = callback;
    }

    private final Uri $$robo$$android_telephony_mbms_StreamingService$getPlaybackUri() {
        if (this.mService == null) {
            throw new IllegalStateException("No streaming service attached");
        }
        try {
            return this.mService.getPlaybackUri(this.mSubscriptionId, this.mServiceInfo.getServiceId());
        }
        catch (RemoteException e) {
            Log.w("MbmsStreamingService", "Remote process died");
            this.mService = null;
            this.mParentSession.onStreamingServiceStopped(this);
            this.sendErrorToApp(3, null);
            return null;
        }
    }

    private final StreamingServiceInfo $$robo$$android_telephony_mbms_StreamingService$getInfo() {
        return this.mServiceInfo;
    }

    private final void $$robo$$android_telephony_mbms_StreamingService$stopStreaming() {
        if (this.mService == null) {
            throw new IllegalStateException("No streaming service attached");
        }
        try {
            this.mService.stopStreaming(this.mSubscriptionId, this.mServiceInfo.getServiceId());
        }
        catch (RemoteException e) {
            Log.w("MbmsStreamingService", "Remote process died");
            this.mService = null;
            this.sendErrorToApp(3, null);
        }
        finally {
            this.mParentSession.onStreamingServiceStopped(this);
        }
    }

    private final InternalStreamingServiceCallback $$robo$$android_telephony_mbms_StreamingService$getCallback() {
        return this.mCallback;
    }

    private final void $$robo$$android_telephony_mbms_StreamingService$sendErrorToApp(int errorCode, String message) {
        try {
            this.mCallback.onError(errorCode, message);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void __constructor__(int n, IMbmsStreamingService iMbmsStreamingService, MbmsStreamingSession mbmsStreamingSession, StreamingServiceInfo streamingServiceInfo, InternalStreamingServiceCallback internalStreamingServiceCallback) {
        this.$$robo$$android_telephony_mbms_StreamingService$__constructor__(n, iMbmsStreamingService, mbmsStreamingSession, streamingServiceInfo, internalStreamingServiceCallback);
    }

    public StreamingService(int n, IMbmsStreamingService iMbmsStreamingService, MbmsStreamingSession mbmsStreamingSession, StreamingServiceInfo streamingServiceInfo, InternalStreamingServiceCallback internalStreamingServiceCallback) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_mbms_StreamingService$__constructor__(int android.telephony.mbms.vendor.IMbmsStreamingService android.telephony.MbmsStreamingSession android.telephony.mbms.StreamingServiceInfo android.telephony.mbms.InternalStreamingServiceCallback ), 0, this, n, iMbmsStreamingService, mbmsStreamingSession, streamingServiceInfo, internalStreamingServiceCallback);
    }

    public Uri getPlaybackUri() {
        return InvokeDynamicSupport.bootstrap("getPlaybackUri", $$robo$$android_telephony_mbms_StreamingService$getPlaybackUri(), 0, this);
    }

    public StreamingServiceInfo getInfo() {
        return InvokeDynamicSupport.bootstrap("getInfo", $$robo$$android_telephony_mbms_StreamingService$getInfo(), 0, this);
    }

    public void stopStreaming() {
        InvokeDynamicSupport.bootstrap("stopStreaming", $$robo$$android_telephony_mbms_StreamingService$stopStreaming(), 0, this);
    }

    public InternalStreamingServiceCallback getCallback() {
        return InvokeDynamicSupport.bootstrap("getCallback", $$robo$$android_telephony_mbms_StreamingService$getCallback(), 0, this);
    }

    private void sendErrorToApp(int n, String string2) {
        InvokeDynamicSupport.bootstrap("sendErrorToApp", $$robo$$android_telephony_mbms_StreamingService$sendErrorToApp(int java.lang.String ), 0, this, n, string2);
    }

    public /* synthetic */ StreamingService() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StreamingService)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StreamingStateChangeReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StreamingState {
    }
}

