/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.text.AndroidBidi;
import android.text.GetChars;
import android.text.MeasuredText;
import android.text.SpanSet;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextLine;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.TextKeyListener;
import android.text.style.AlignmentSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineBackgroundSpan;
import android.text.style.ParagraphStyle;
import android.text.style.ReplacementSpan;
import android.text.style.TabStopSpan;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class Layout
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int BREAK_STRATEGY_SIMPLE = 0;
    public static int BREAK_STRATEGY_HIGH_QUALITY = 1;
    public static int BREAK_STRATEGY_BALANCED = 2;
    public static int HYPHENATION_FREQUENCY_NONE = 0;
    public static int HYPHENATION_FREQUENCY_NORMAL = 1;
    public static int HYPHENATION_FREQUENCY_FULL = 2;
    private static ParagraphStyle[] NO_PARA_SPANS;
    public static int JUSTIFICATION_MODE_NONE = 0;
    public static int JUSTIFICATION_MODE_INTER_WORD = 1;
    private CharSequence mText;
    private TextPaint mPaint;
    private int mWidth;
    private Alignment mAlignment;
    private float mSpacingMult;
    private float mSpacingAdd;
    private static Rect sTempRect;
    private boolean mSpannedText;
    private TextDirectionHeuristic mTextDir;
    private SpanSet<LineBackgroundSpan> mLineBackgroundSpans;
    private int mJustificationMode;
    public static int DIR_LEFT_TO_RIGHT = 1;
    public static int DIR_RIGHT_TO_LEFT = -1;
    static int DIR_REQUEST_LTR = 1;
    static int DIR_REQUEST_RTL = -1;
    static int DIR_REQUEST_DEFAULT_LTR = 2;
    static int DIR_REQUEST_DEFAULT_RTL = -2;
    static int RUN_LENGTH_MASK = 0x3FFFFFF;
    static int RUN_LEVEL_SHIFT = 26;
    static int RUN_LEVEL_MASK = 63;
    static int RUN_RTL_FLAG = 0x4000000;
    private static int TAB_INCREMENT = 20;
    public static Directions DIRS_ALL_LEFT_TO_RIGHT;
    public static Directions DIRS_ALL_RIGHT_TO_LEFT;

    private static final float $$robo$$android_text_Layout$getDesiredWidth(CharSequence source, TextPaint paint) {
        return Layout.getDesiredWidth(source, 0, source.length(), paint);
    }

    private static final float $$robo$$android_text_Layout$getDesiredWidth(CharSequence source, int start, int end, TextPaint paint) {
        return Layout.getDesiredWidth(source, start, end, paint, TextDirectionHeuristics.FIRSTSTRONG_LTR);
    }

    private static final float $$robo$$android_text_Layout$getDesiredWidth(CharSequence source, int start, int end, TextPaint paint, TextDirectionHeuristic textDir) {
        float need = 0.0f;
        int i = start;
        while (i <= end) {
            float w;
            int next = TextUtils.indexOf(source, '\n', i, end);
            if (next < 0) {
                next = end;
            }
            if ((w = Layout.measurePara(paint, source, i, next, textDir)) > need) {
                need = w;
            }
            i = ++next;
        }
        return need;
    }

    private void $$robo$$android_text_Layout$__constructor__(CharSequence text, TextPaint paint, int width, Alignment align, float spacingMult, float spacingAdd) {
    }

    private void $$robo$$android_text_Layout$__constructor__(CharSequence text, TextPaint paint, int width, Alignment align, TextDirectionHeuristic textDir, float spacingMult, float spacingAdd) {
        this.mAlignment = Alignment.ALIGN_NORMAL;
        if (width < 0) {
            throw new IllegalArgumentException("Layout: " + width + " < 0");
        }
        if (paint != null) {
            paint.bgColor = 0;
            paint.baselineShift = 0;
        }
        this.mText = text;
        this.mPaint = paint;
        this.mWidth = width;
        this.mAlignment = align;
        this.mSpacingMult = spacingMult;
        this.mSpacingAdd = spacingAdd;
        this.mSpannedText = text instanceof Spanned;
        this.mTextDir = textDir;
    }

    private final void $$robo$$android_text_Layout$setJustificationMode(int justificationMode) {
        this.mJustificationMode = justificationMode;
    }

    private final void $$robo$$android_text_Layout$replaceWith(CharSequence text, TextPaint paint, int width, Alignment align, float spacingmult, float spacingadd) {
        if (width < 0) {
            throw new IllegalArgumentException("Layout: " + width + " < 0");
        }
        this.mText = text;
        this.mPaint = paint;
        this.mWidth = width;
        this.mAlignment = align;
        this.mSpacingMult = spacingmult;
        this.mSpacingAdd = spacingadd;
        this.mSpannedText = text instanceof Spanned;
    }

    private final void $$robo$$android_text_Layout$draw(Canvas c) {
        this.draw(c, null, null, 0);
    }

    private final void $$robo$$android_text_Layout$draw(Canvas canvas, Path highlight, Paint highlightPaint, int cursorOffsetVertical) {
        long lineRange = this.getLineRangeForDraw(canvas);
        int firstLine = TextUtils.unpackRangeStartFromLong(lineRange);
        int lastLine = TextUtils.unpackRangeEndFromLong(lineRange);
        if (lastLine < 0) {
            return;
        }
        this.drawBackground(canvas, highlight, highlightPaint, cursorOffsetVertical, firstLine, lastLine);
        this.drawText(canvas, firstLine, lastLine);
    }

    private final boolean $$robo$$android_text_Layout$isJustificationRequired(int lineNum) {
        if (this.mJustificationMode == 0) {
            return false;
        }
        int lineEnd = this.getLineEnd(lineNum);
        return lineEnd < this.mText.length() && this.mText.charAt(lineEnd - 1) != '\n';
    }

    private final float $$robo$$android_text_Layout$getJustifyWidth(int lineNum) {
        Alignment align;
        Alignment paraAlign = this.mAlignment;
        TabStops tabStops = null;
        boolean tabStopsIsInitialized = false;
        int left = 0;
        int right = this.mWidth;
        int dir = this.getParagraphDirection(lineNum);
        Object[] spans = NO_PARA_SPANS;
        if (this.mSpannedText) {
            int n;
            boolean isFirstParaLine;
            Spanned sp = (Spanned)this.mText;
            int start = this.getLineStart(lineNum);
            boolean bl = isFirstParaLine = start == 0 || this.mText.charAt(start - 1) == '\n';
            if (isFirstParaLine) {
                int spanEnd = sp.nextSpanTransition(start, this.mText.length(), ParagraphStyle.class);
                spans = Layout.getParagraphSpans(sp, start, spanEnd, ParagraphStyle.class);
                for (int n2 = spans.length - 1; n2 >= 0; --n2) {
                    if (!(spans[n2] instanceof AlignmentSpan)) continue;
                    paraAlign = ((AlignmentSpan)spans[n2]).getAlignment();
                    break;
                }
            }
            int length = spans.length;
            boolean useFirstLineMargin = isFirstParaLine;
            for (n = 0; n < length; ++n) {
                if (!(spans[n] instanceof LeadingMarginSpan.LeadingMarginSpan2)) continue;
                int count = ((LeadingMarginSpan.LeadingMarginSpan2)spans[n]).getLeadingMarginLineCount();
                int startLine = this.getLineForOffset(sp.getSpanStart(spans[n]));
                if (lineNum >= startLine + count) continue;
                useFirstLineMargin = true;
                break;
            }
            for (n = 0; n < length; ++n) {
                if (!(spans[n] instanceof LeadingMarginSpan)) continue;
                LeadingMarginSpan margin = (LeadingMarginSpan)spans[n];
                if (dir == -1) {
                    right -= margin.getLeadingMargin(useFirstLineMargin);
                    continue;
                }
                left += margin.getLeadingMargin(useFirstLineMargin);
            }
        }
        if (this.getLineContainsTab(lineNum)) {
            tabStops = new TabStops(20, spans);
        }
        int indentWidth = (align = paraAlign == Alignment.ALIGN_LEFT ? (dir == 1 ? Alignment.ALIGN_NORMAL : Alignment.ALIGN_OPPOSITE) : (paraAlign == Alignment.ALIGN_RIGHT ? (dir == 1 ? Alignment.ALIGN_OPPOSITE : Alignment.ALIGN_NORMAL) : paraAlign)) == Alignment.ALIGN_NORMAL ? (dir == 1 ? this.getIndentAdjust(lineNum, Alignment.ALIGN_LEFT) : -this.getIndentAdjust(lineNum, Alignment.ALIGN_RIGHT)) : (align == Alignment.ALIGN_OPPOSITE ? (dir == 1 ? -this.getIndentAdjust(lineNum, Alignment.ALIGN_RIGHT) : this.getIndentAdjust(lineNum, Alignment.ALIGN_LEFT)) : this.getIndentAdjust(lineNum, Alignment.ALIGN_CENTER));
        return right - left - indentWidth;
    }

    private final void $$robo$$android_text_Layout$drawText(Canvas canvas, int firstLine, int lastLine) {
        int previousLineBottom = this.getLineTop(firstLine);
        int previousLineEnd = this.getLineStart(firstLine);
        Object[] spans = NO_PARA_SPANS;
        int spanEnd = 0;
        TextPaint paint = this.mPaint;
        CharSequence buf = this.mText;
        Alignment paraAlign = this.mAlignment;
        TabStops tabStops = null;
        boolean tabStopsIsInitialized = false;
        TextLine tl = TextLine.obtain();
        for (int lineNum = firstLine; lineNum <= lastLine; ++lineNum) {
            int x;
            int indentWidth;
            Alignment align;
            boolean hasTab;
            int lbottom;
            int start = previousLineEnd;
            previousLineEnd = this.getLineStart(lineNum + 1);
            boolean justify = this.isJustificationRequired(lineNum);
            int end = this.getLineVisibleEnd(lineNum, start, previousLineEnd);
            int ltop = previousLineBottom;
            previousLineBottom = lbottom = this.getLineTop(lineNum + 1);
            int lbaseline = lbottom - this.getLineDescent(lineNum);
            int dir = this.getParagraphDirection(lineNum);
            int left = 0;
            int right = this.mWidth;
            if (this.mSpannedText) {
                int n;
                boolean isFirstParaLine;
                Spanned sp = (Spanned)buf;
                int textLength = buf.length();
                boolean bl = isFirstParaLine = start == 0 || buf.charAt(start - 1) == '\n';
                if (start >= spanEnd && (lineNum == firstLine || isFirstParaLine)) {
                    spanEnd = sp.nextSpanTransition(start, textLength, ParagraphStyle.class);
                    spans = Layout.getParagraphSpans(sp, start, spanEnd, ParagraphStyle.class);
                    paraAlign = this.mAlignment;
                    for (int n2 = spans.length - 1; n2 >= 0; --n2) {
                        if (!(spans[n2] instanceof AlignmentSpan)) continue;
                        paraAlign = ((AlignmentSpan)spans[n2]).getAlignment();
                        break;
                    }
                    tabStopsIsInitialized = false;
                }
                int length = spans.length;
                boolean useFirstLineMargin = isFirstParaLine;
                for (n = 0; n < length; ++n) {
                    if (!(spans[n] instanceof LeadingMarginSpan.LeadingMarginSpan2)) continue;
                    int count = ((LeadingMarginSpan.LeadingMarginSpan2)spans[n]).getLeadingMarginLineCount();
                    int startLine = this.getLineForOffset(sp.getSpanStart(spans[n]));
                    if (lineNum >= startLine + count) continue;
                    useFirstLineMargin = true;
                    break;
                }
                for (n = 0; n < length; ++n) {
                    if (!(spans[n] instanceof LeadingMarginSpan)) continue;
                    LeadingMarginSpan margin = (LeadingMarginSpan)spans[n];
                    if (dir == -1) {
                        margin.drawLeadingMargin(canvas, paint, right, dir, ltop, lbaseline, lbottom, buf, start, end, isFirstParaLine, this);
                        right -= margin.getLeadingMargin(useFirstLineMargin);
                        continue;
                    }
                    margin.drawLeadingMargin(canvas, paint, left, dir, ltop, lbaseline, lbottom, buf, start, end, isFirstParaLine, this);
                    left += margin.getLeadingMargin(useFirstLineMargin);
                }
            }
            if ((hasTab = this.getLineContainsTab(lineNum)) && !tabStopsIsInitialized) {
                if (tabStops == null) {
                    tabStops = new TabStops(20, spans);
                } else {
                    tabStops.reset(20, spans);
                }
                tabStopsIsInitialized = true;
            }
            if ((align = paraAlign) == Alignment.ALIGN_LEFT) {
                align = dir == 1 ? Alignment.ALIGN_NORMAL : Alignment.ALIGN_OPPOSITE;
            } else if (align == Alignment.ALIGN_RIGHT) {
                Alignment alignment = align = dir == 1 ? Alignment.ALIGN_OPPOSITE : Alignment.ALIGN_NORMAL;
            }
            if (align == Alignment.ALIGN_NORMAL) {
                if (dir == 1) {
                    indentWidth = this.getIndentAdjust(lineNum, Alignment.ALIGN_LEFT);
                    x = left + indentWidth;
                } else {
                    indentWidth = -this.getIndentAdjust(lineNum, Alignment.ALIGN_RIGHT);
                    x = right - indentWidth;
                }
            } else {
                int max = (int)this.getLineExtent(lineNum, tabStops, false);
                if (align == Alignment.ALIGN_OPPOSITE) {
                    if (dir == 1) {
                        indentWidth = -this.getIndentAdjust(lineNum, Alignment.ALIGN_RIGHT);
                        x = right - max - indentWidth;
                    } else {
                        indentWidth = this.getIndentAdjust(lineNum, Alignment.ALIGN_LEFT);
                        x = left - max + indentWidth;
                    }
                } else {
                    indentWidth = this.getIndentAdjust(lineNum, Alignment.ALIGN_CENTER);
                    x = (right + left - (max &= 0xFFFFFFFE) >> 1) + indentWidth;
                }
            }
            paint.setHyphenEdit(this.getHyphen(lineNum));
            Directions directions = this.getLineDirections(lineNum);
            if (!(directions != DIRS_ALL_LEFT_TO_RIGHT || this.mSpannedText || hasTab || justify)) {
                canvas.drawText(buf, start, end, (float)x, (float)lbaseline, (Paint)paint);
            } else {
                tl.set(paint, buf, start, end, dir, directions, hasTab, tabStops);
                if (justify) {
                    tl.justify(right - left - indentWidth);
                }
                tl.draw(canvas, x, ltop, lbaseline, lbottom);
            }
            paint.setHyphenEdit(0);
        }
        TextLine.recycle(tl);
    }

    private final void $$robo$$android_text_Layout$drawBackground(Canvas canvas, Path highlight, Paint highlightPaint, int cursorOffsetVertical, int firstLine, int lastLine) {
        if (this.mSpannedText) {
            if (this.mLineBackgroundSpans == null) {
                this.mLineBackgroundSpans = new SpanSet<LineBackgroundSpan>(LineBackgroundSpan.class);
            }
            Spanned buffer = (Spanned)this.mText;
            int textLength = buffer.length();
            this.mLineBackgroundSpans.init(buffer, 0, textLength);
            if (this.mLineBackgroundSpans.numberOfSpans > 0) {
                int previousLineBottom = this.getLineTop(firstLine);
                int previousLineEnd = this.getLineStart(firstLine);
                ParagraphStyle[] spans = NO_PARA_SPANS;
                int spansLength = 0;
                TextPaint paint = this.mPaint;
                int spanEnd = 0;
                int width = this.mWidth;
                for (int i = firstLine; i <= lastLine; ++i) {
                    int lbottom;
                    int end;
                    int start = previousLineEnd;
                    previousLineEnd = end = this.getLineStart(i + 1);
                    int ltop = previousLineBottom;
                    previousLineBottom = lbottom = this.getLineTop(i + 1);
                    int lbaseline = lbottom - this.getLineDescent(i);
                    if (start >= spanEnd) {
                        spanEnd = this.mLineBackgroundSpans.getNextTransition(start, textLength);
                        spansLength = 0;
                        if (start != end || start == 0) {
                            for (int j = 0; j < this.mLineBackgroundSpans.numberOfSpans; ++j) {
                                if (this.mLineBackgroundSpans.spanStarts[j] >= end || this.mLineBackgroundSpans.spanEnds[j] <= start) continue;
                                spans = GrowingArrayUtils.append(spans, spansLength, ((LineBackgroundSpan[])this.mLineBackgroundSpans.spans)[j]);
                                ++spansLength;
                            }
                        }
                    }
                    for (int n = 0; n < spansLength; ++n) {
                        LineBackgroundSpan lineBackgroundSpan = (LineBackgroundSpan)spans[n];
                        lineBackgroundSpan.drawBackground(canvas, paint, 0, width, ltop, lbaseline, lbottom, buffer, start, end, i);
                    }
                }
            }
            this.mLineBackgroundSpans.recycle();
        }
        if (highlight != null) {
            if (cursorOffsetVertical != 0) {
                canvas.translate(0.0f, cursorOffsetVertical);
            }
            canvas.drawPath(highlight, highlightPaint);
            if (cursorOffsetVertical != 0) {
                canvas.translate(0.0f, -cursorOffsetVertical);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long $$robo$$android_text_Layout$getLineRangeForDraw(Canvas canvas) {
        int dbottom;
        int dtop;
        Rect rect = sTempRect;
        synchronized (rect) {
            if (!canvas.getClipBounds(sTempRect)) {
                return TextUtils.packRangeInLong(0, -1);
            }
            dtop = Layout.sTempRect.top;
            dbottom = Layout.sTempRect.bottom;
        }
        int top = Math.max(dtop, 0);
        int bottom = Math.min(this.getLineTop(this.getLineCount()), dbottom);
        if (top >= bottom) {
            return TextUtils.packRangeInLong(0, -1);
        }
        return TextUtils.packRangeInLong(this.getLineForVertical(top), this.getLineForVertical(bottom));
    }

    private final int $$robo$$android_text_Layout$getLineStartPos(int line, int left, int right) {
        int x;
        Alignment align = this.getParagraphAlignment(line);
        int dir = this.getParagraphDirection(line);
        if (align == Alignment.ALIGN_LEFT) {
            align = dir == 1 ? Alignment.ALIGN_NORMAL : Alignment.ALIGN_OPPOSITE;
        } else if (align == Alignment.ALIGN_RIGHT) {
            Alignment alignment = align = dir == 1 ? Alignment.ALIGN_OPPOSITE : Alignment.ALIGN_NORMAL;
        }
        if (align == Alignment.ALIGN_NORMAL) {
            x = dir == 1 ? left + this.getIndentAdjust(line, Alignment.ALIGN_LEFT) : right + this.getIndentAdjust(line, Alignment.ALIGN_RIGHT);
        } else {
            int spanEnd;
            int start;
            Spanned spanned;
            Object[] tabSpans;
            TabStops tabStops = null;
            if (this.mSpannedText && this.getLineContainsTab(line) && (tabSpans = Layout.getParagraphSpans(spanned = (Spanned)this.mText, start = this.getLineStart(line), spanEnd = spanned.nextSpanTransition(start, spanned.length(), TabStopSpan.class), TabStopSpan.class)).length > 0) {
                tabStops = new TabStops(20, tabSpans);
            }
            int max = (int)this.getLineExtent(line, tabStops, false);
            x = align == Alignment.ALIGN_OPPOSITE ? (dir == 1 ? right - max + this.getIndentAdjust(line, Alignment.ALIGN_RIGHT) : left - max + this.getIndentAdjust(line, Alignment.ALIGN_LEFT)) : left + right - (max &= 0xFFFFFFFE) >> 1 + this.getIndentAdjust(line, Alignment.ALIGN_CENTER);
        }
        return x;
    }

    private final CharSequence $$robo$$android_text_Layout$getText() {
        return this.mText;
    }

    private final TextPaint $$robo$$android_text_Layout$getPaint() {
        return this.mPaint;
    }

    private final int $$robo$$android_text_Layout$getWidth() {
        return this.mWidth;
    }

    private final int $$robo$$android_text_Layout$getEllipsizedWidth() {
        return this.mWidth;
    }

    private final void $$robo$$android_text_Layout$increaseWidthTo(int wid) {
        if (wid < this.mWidth) {
            throw new RuntimeException("attempted to reduce Layout width");
        }
        this.mWidth = wid;
    }

    private final int $$robo$$android_text_Layout$getHeight() {
        return this.getLineTop(this.getLineCount());
    }

    private final int $$robo$$android_text_Layout$getHeight(boolean cap) {
        return this.getHeight();
    }

    private final Alignment $$robo$$android_text_Layout$getAlignment() {
        return this.mAlignment;
    }

    private final float $$robo$$android_text_Layout$getSpacingMultiplier() {
        return this.mSpacingMult;
    }

    private final float $$robo$$android_text_Layout$getSpacingAdd() {
        return this.mSpacingAdd;
    }

    private final TextDirectionHeuristic $$robo$$android_text_Layout$getTextDirectionHeuristic() {
        return this.mTextDir;
    }

    public abstract int getLineCount();

    private final int $$robo$$android_text_Layout$getLineBounds(int line, Rect bounds) {
        if (bounds != null) {
            bounds.left = 0;
            bounds.top = this.getLineTop(line);
            bounds.right = this.mWidth;
            bounds.bottom = this.getLineTop(line + 1);
        }
        return this.getLineBaseline(line);
    }

    public abstract int getLineTop(int var1);

    public abstract int getLineDescent(int var1);

    public abstract int getLineStart(int var1);

    public abstract int getParagraphDirection(int var1);

    public abstract boolean getLineContainsTab(int var1);

    public abstract Directions getLineDirections(int var1);

    public abstract int getTopPadding();

    public abstract int getBottomPadding();

    private final int $$robo$$android_text_Layout$getHyphen(int line) {
        return 0;
    }

    private final int $$robo$$android_text_Layout$getIndentAdjust(int line, Alignment alignment) {
        return 0;
    }

    private final boolean $$robo$$android_text_Layout$isLevelBoundary(int offset) {
        int line = this.getLineForOffset(offset);
        Directions dirs = this.getLineDirections(line);
        if (dirs == DIRS_ALL_LEFT_TO_RIGHT || dirs == DIRS_ALL_RIGHT_TO_LEFT) {
            return false;
        }
        int[] runs = dirs.mDirections;
        int lineStart = this.getLineStart(line);
        int lineEnd = this.getLineEnd(line);
        if (offset == lineStart || offset == lineEnd) {
            int paraLevel = this.getParagraphDirection(line) == 1 ? 0 : 1;
            int runIndex = offset == lineStart ? 0 : runs.length - 2;
            return (runs[runIndex + 1] >>> 26 & 0x3F) != paraLevel;
        }
        offset -= lineStart;
        for (int i = 0; i < runs.length; i += 2) {
            if (offset != runs[i]) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_text_Layout$isRtlCharAt(int offset) {
        int line = this.getLineForOffset(offset);
        Directions dirs = this.getLineDirections(line);
        if (dirs == DIRS_ALL_LEFT_TO_RIGHT) {
            return false;
        }
        if (dirs == DIRS_ALL_RIGHT_TO_LEFT) {
            return true;
        }
        int[] runs = dirs.mDirections;
        int lineStart = this.getLineStart(line);
        for (int i = 0; i < runs.length; i += 2) {
            int start = lineStart + runs[i];
            int limit = start + (runs[i + 1] & 0x3FFFFFF);
            if (offset < start || offset >= limit) continue;
            int level = runs[i + 1] >>> 26 & 0x3F;
            return (level & 1) != 0;
        }
        return false;
    }

    private final long $$robo$$android_text_Layout$getRunRange(int offset) {
        int line = this.getLineForOffset(offset);
        Directions dirs = this.getLineDirections(line);
        if (dirs == DIRS_ALL_LEFT_TO_RIGHT || dirs == DIRS_ALL_RIGHT_TO_LEFT) {
            return TextUtils.packRangeInLong(0, this.getLineEnd(line));
        }
        int[] runs = dirs.mDirections;
        int lineStart = this.getLineStart(line);
        for (int i = 0; i < runs.length; i += 2) {
            int start = lineStart + runs[i];
            int limit = start + (runs[i + 1] & 0x3FFFFFF);
            if (offset < start || offset >= limit) continue;
            return TextUtils.packRangeInLong(start, limit);
        }
        return TextUtils.packRangeInLong(0, this.getLineEnd(line));
    }

    private final boolean $$robo$$android_text_Layout$primaryIsTrailingPrevious(int offset) {
        int line = this.getLineForOffset(offset);
        int lineStart = this.getLineStart(line);
        int lineEnd = this.getLineEnd(line);
        int[] runs = this.getLineDirections((int)line).mDirections;
        int levelAt = -1;
        for (int i = 0; i < runs.length; i += 2) {
            int start = lineStart + runs[i];
            int limit = start + (runs[i + 1] & 0x3FFFFFF);
            if (limit > lineEnd) {
                limit = lineEnd;
            }
            if (offset < start || offset >= limit) continue;
            if (offset > start) {
                return false;
            }
            levelAt = runs[i + 1] >>> 26 & 0x3F;
            break;
        }
        if (levelAt == -1) {
            levelAt = this.getParagraphDirection(line) == 1 ? 0 : 1;
        }
        int levelBefore = -1;
        if (offset == lineStart) {
            levelBefore = this.getParagraphDirection(line) == 1 ? 0 : 1;
        } else {
            --offset;
            for (int i = 0; i < runs.length; i += 2) {
                int start = lineStart + runs[i];
                int limit = start + (runs[i + 1] & 0x3FFFFFF);
                if (limit > lineEnd) {
                    limit = lineEnd;
                }
                if (offset < start || offset >= limit) continue;
                levelBefore = runs[i + 1] >>> 26 & 0x3F;
                break;
            }
        }
        return levelBefore < levelAt;
    }

    private final float $$robo$$android_text_Layout$getPrimaryHorizontal(int offset) {
        return this.getPrimaryHorizontal(offset, false);
    }

    private final float $$robo$$android_text_Layout$getPrimaryHorizontal(int offset, boolean clamped) {
        boolean trailing = this.primaryIsTrailingPrevious(offset);
        return this.getHorizontal(offset, trailing, clamped);
    }

    private final float $$robo$$android_text_Layout$getSecondaryHorizontal(int offset) {
        return this.getSecondaryHorizontal(offset, false);
    }

    private final float $$robo$$android_text_Layout$getSecondaryHorizontal(int offset, boolean clamped) {
        boolean trailing = this.primaryIsTrailingPrevious(offset);
        return this.getHorizontal(offset, !trailing, clamped);
    }

    private final float $$robo$$android_text_Layout$getHorizontal(int offset, boolean primary) {
        return primary ? this.getPrimaryHorizontal(offset) : this.getSecondaryHorizontal(offset);
    }

    private final float $$robo$$android_text_Layout$getHorizontal(int offset, boolean trailing, boolean clamped) {
        int line = this.getLineForOffset(offset);
        return this.getHorizontal(offset, trailing, line, clamped);
    }

    private final float $$robo$$android_text_Layout$getHorizontal(int offset, boolean trailing, int line, boolean clamped) {
        Object[] tabs;
        int start = this.getLineStart(line);
        int end = this.getLineEnd(line);
        int dir = this.getParagraphDirection(line);
        boolean hasTab = this.getLineContainsTab(line);
        Directions directions = this.getLineDirections(line);
        TabStops tabStops = null;
        if (hasTab && this.mText instanceof Spanned && (tabs = Layout.getParagraphSpans((Spanned)this.mText, start, end, TabStopSpan.class)).length > 0) {
            tabStops = new TabStops(20, tabs);
        }
        TextLine tl = TextLine.obtain();
        tl.set(this.mPaint, this.mText, start, end, dir, directions, hasTab, tabStops);
        float wid = tl.measure(offset - start, trailing, null);
        TextLine.recycle(tl);
        if (clamped && wid > (float)this.mWidth) {
            wid = this.mWidth;
        }
        int left = this.getParagraphLeft(line);
        int right = this.getParagraphRight(line);
        return (float)this.getLineStartPos(line, left, right) + wid;
    }

    private final float $$robo$$android_text_Layout$getLineLeft(int line) {
        int dir = this.getParagraphDirection(line);
        Alignment align = this.getParagraphAlignment(line);
        if (align == Alignment.ALIGN_LEFT) {
            return 0.0f;
        }
        if (align == Alignment.ALIGN_NORMAL) {
            if (dir == -1) {
                return (float)this.getParagraphRight(line) - this.getLineMax(line);
            }
            return 0.0f;
        }
        if (align == Alignment.ALIGN_RIGHT) {
            return (float)this.mWidth - this.getLineMax(line);
        }
        if (align == Alignment.ALIGN_OPPOSITE) {
            if (dir == -1) {
                return 0.0f;
            }
            return (float)this.mWidth - this.getLineMax(line);
        }
        int left = this.getParagraphLeft(line);
        int right = this.getParagraphRight(line);
        int max = (int)this.getLineMax(line) & 0xFFFFFFFE;
        return left + (right - left - max) / 2;
    }

    private final float $$robo$$android_text_Layout$getLineRight(int line) {
        int dir = this.getParagraphDirection(line);
        Alignment align = this.getParagraphAlignment(line);
        if (align == Alignment.ALIGN_LEFT) {
            return (float)this.getParagraphLeft(line) + this.getLineMax(line);
        }
        if (align == Alignment.ALIGN_NORMAL) {
            if (dir == -1) {
                return this.mWidth;
            }
            return (float)this.getParagraphLeft(line) + this.getLineMax(line);
        }
        if (align == Alignment.ALIGN_RIGHT) {
            return this.mWidth;
        }
        if (align == Alignment.ALIGN_OPPOSITE) {
            if (dir == -1) {
                return this.getLineMax(line);
            }
            return this.mWidth;
        }
        int left = this.getParagraphLeft(line);
        int right = this.getParagraphRight(line);
        int max = (int)this.getLineMax(line) & 0xFFFFFFFE;
        return right - (right - left - max) / 2;
    }

    private final float $$robo$$android_text_Layout$getLineMax(int line) {
        float margin = this.getParagraphLeadingMargin(line);
        float signedExtent = this.getLineExtent(line, false);
        return margin + (signedExtent >= 0.0f ? signedExtent : -signedExtent);
    }

    private final float $$robo$$android_text_Layout$getLineWidth(int line) {
        float margin = this.getParagraphLeadingMargin(line);
        float signedExtent = this.getLineExtent(line, true);
        return margin + (signedExtent >= 0.0f ? signedExtent : -signedExtent);
    }

    private final float $$robo$$android_text_Layout$getLineExtent(int line, boolean full) {
        Directions directions;
        Object[] tabs;
        int start = this.getLineStart(line);
        int end = full ? this.getLineEnd(line) : this.getLineVisibleEnd(line);
        boolean hasTabs = this.getLineContainsTab(line);
        TabStops tabStops = null;
        if (hasTabs && this.mText instanceof Spanned && (tabs = Layout.getParagraphSpans((Spanned)this.mText, start, end, TabStopSpan.class)).length > 0) {
            tabStops = new TabStops(20, tabs);
        }
        if ((directions = this.getLineDirections(line)) == null) {
            return 0.0f;
        }
        int dir = this.getParagraphDirection(line);
        TextLine tl = TextLine.obtain();
        this.mPaint.setHyphenEdit(this.getHyphen(line));
        tl.set(this.mPaint, this.mText, start, end, dir, directions, hasTabs, tabStops);
        if (this.isJustificationRequired(line)) {
            tl.justify(this.getJustifyWidth(line));
        }
        float width = tl.metrics(null);
        this.mPaint.setHyphenEdit(0);
        TextLine.recycle(tl);
        return width;
    }

    private final float $$robo$$android_text_Layout$getLineExtent(int line, TabStops tabStops, boolean full) {
        int start = this.getLineStart(line);
        int end = full ? this.getLineEnd(line) : this.getLineVisibleEnd(line);
        boolean hasTabs = this.getLineContainsTab(line);
        Directions directions = this.getLineDirections(line);
        int dir = this.getParagraphDirection(line);
        TextLine tl = TextLine.obtain();
        this.mPaint.setHyphenEdit(this.getHyphen(line));
        tl.set(this.mPaint, this.mText, start, end, dir, directions, hasTabs, tabStops);
        if (this.isJustificationRequired(line)) {
            tl.justify(this.getJustifyWidth(line));
        }
        float width = tl.metrics(null);
        this.mPaint.setHyphenEdit(0);
        TextLine.recycle(tl);
        return width;
    }

    private final int $$robo$$android_text_Layout$getLineForVertical(int vertical) {
        int high = this.getLineCount();
        int low = -1;
        while (high - low > 1) {
            int guess = (high + low) / 2;
            if (this.getLineTop(guess) > vertical) {
                high = guess;
                continue;
            }
            low = guess;
        }
        if (low < 0) {
            return 0;
        }
        return low;
    }

    private final int $$robo$$android_text_Layout$getLineForOffset(int offset) {
        int high = this.getLineCount();
        int low = -1;
        while (high - low > 1) {
            int guess = (high + low) / 2;
            if (this.getLineStart(guess) > offset) {
                high = guess;
                continue;
            }
            low = guess;
        }
        if (low < 0) {
            return 0;
        }
        return low;
    }

    private final int $$robo$$android_text_Layout$getOffsetForHorizontal(int line, float horiz) {
        return this.getOffsetForHorizontal(line, horiz, true);
    }

    private final int $$robo$$android_text_Layout$getOffsetForHorizontal(int line, float horiz, boolean primary) {
        int lineEndOffset = this.getLineEnd(line);
        int lineStartOffset = this.getLineStart(line);
        Directions dirs = this.getLineDirections(line);
        TextLine tl = TextLine.obtain();
        tl.set(this.mPaint, this.mText, lineStartOffset, lineEndOffset, this.getParagraphDirection(line), dirs, false, null);
        int max = line == this.getLineCount() - 1 ? lineEndOffset : tl.getOffsetToLeftRightOf(lineEndOffset - lineStartOffset, !this.isRtlCharAt(lineEndOffset - 1)) + lineStartOffset;
        int best = lineStartOffset;
        float bestdist = Math.abs(this.getHorizontal(best, primary) - horiz);
        for (int i = 0; i < dirs.mDirections.length; i += 2) {
            float dist;
            int aft;
            int swap;
            int here = lineStartOffset + dirs.mDirections[i];
            int there = here + (dirs.mDirections[i + 1] & 0x3FFFFFF);
            boolean isRtl = (dirs.mDirections[i + 1] & 0x4000000) != 0;
            int n = swap = isRtl ? -1 : 1;
            if (there > max) {
                there = max;
            }
            int high = there - 1 + 1;
            int low = here + 1 - 1;
            while (high - low > 1) {
                int guess = (high + low) / 2;
                int adguess = this.getOffsetAtStartOf(guess);
                if (this.getHorizontal(adguess, primary) * (float)swap >= horiz * (float)swap) {
                    high = guess;
                    continue;
                }
                low = guess;
            }
            if (low < here + 1) {
                low = here + 1;
            }
            if (low < there && (low = tl.getOffsetToLeftRightOf((aft = tl.getOffsetToLeftRightOf(low - lineStartOffset, isRtl) + lineStartOffset) - lineStartOffset, !isRtl) + lineStartOffset) >= here && low < there) {
                float other;
                float dist2 = Math.abs(this.getHorizontal(low, primary) - horiz);
                if (aft < there && (other = Math.abs(this.getHorizontal(aft, primary) - horiz)) < dist2) {
                    dist2 = other;
                    low = aft;
                }
                if (dist2 < bestdist) {
                    bestdist = dist2;
                    best = low;
                }
            }
            if (!((dist = Math.abs(this.getHorizontal(here, primary) - horiz)) < bestdist)) continue;
            bestdist = dist;
            best = here;
        }
        float dist = Math.abs(this.getHorizontal(max, primary) - horiz);
        if (dist <= bestdist) {
            bestdist = dist;
            best = max;
        }
        TextLine.recycle(tl);
        return best;
    }

    private final int $$robo$$android_text_Layout$getLineEnd(int line) {
        return this.getLineStart(line + 1);
    }

    private final int $$robo$$android_text_Layout$getLineVisibleEnd(int line) {
        return this.getLineVisibleEnd(line, this.getLineStart(line), this.getLineStart(line + 1));
    }

    private final int $$robo$$android_text_Layout$getLineVisibleEnd(int line, int start, int end) {
        CharSequence text = this.mText;
        if (line == this.getLineCount() - 1) {
            return end;
        }
        while (end > start) {
            char ch = text.charAt(end - 1);
            if (ch == '\n') {
                return end - 1;
            }
            if (!TextLine.isLineEndSpace(ch)) break;
            --end;
        }
        return end;
    }

    private final int $$robo$$android_text_Layout$getLineBottom(int line) {
        return this.getLineTop(line + 1);
    }

    private final int $$robo$$android_text_Layout$getLineBaseline(int line) {
        return this.getLineTop(line + 1) - this.getLineDescent(line);
    }

    private final int $$robo$$android_text_Layout$getLineAscent(int line) {
        return this.getLineTop(line) - (this.getLineTop(line + 1) - this.getLineDescent(line));
    }

    private final int $$robo$$android_text_Layout$getOffsetToLeftOf(int offset) {
        return this.getOffsetToLeftRightOf(offset, true);
    }

    private final int $$robo$$android_text_Layout$getOffsetToRightOf(int offset) {
        return this.getOffsetToLeftRightOf(offset, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int $$robo$$android_text_Layout$getOffsetToLeftRightOf(int caret, boolean toLeft) {
        boolean advance;
        int line = this.getLineForOffset(caret);
        int lineStart = this.getLineStart(line);
        int lineEnd = this.getLineEnd(line);
        int lineDir = this.getParagraphDirection(line);
        boolean lineChanged = false;
        boolean bl = advance = toLeft == (lineDir == -1);
        if (advance) {
            if (caret == lineEnd) {
                if (line >= this.getLineCount() - 1) return caret;
                lineChanged = true;
                ++line;
            }
        } else if (caret == lineStart) {
            if (line <= 0) return caret;
            lineChanged = true;
            --line;
        }
        if (lineChanged) {
            lineStart = this.getLineStart(line);
            lineEnd = this.getLineEnd(line);
            int newDir = this.getParagraphDirection(line);
            if (newDir != lineDir) {
                toLeft = !toLeft;
                lineDir = newDir;
            }
        }
        Directions directions = this.getLineDirections(line);
        TextLine tl = TextLine.obtain();
        tl.set(this.mPaint, this.mText, lineStart, lineEnd, lineDir, directions, false, null);
        caret = lineStart + tl.getOffsetToLeftRightOf(caret - lineStart, toLeft);
        tl = TextLine.recycle(tl);
        return caret;
    }

    private final int $$robo$$android_text_Layout$getOffsetAtStartOf(int offset) {
        char c1;
        if (offset == 0) {
            return 0;
        }
        CharSequence text = this.mText;
        char c = text.charAt(offset);
        if (c >= '\udc00' && c <= '\udfff' && (c1 = text.charAt(offset - 1)) >= '\ud800' && c1 <= '\udbff') {
            --offset;
        }
        if (this.mSpannedText) {
            ReplacementSpan[] spans = ((Spanned)text).getSpans(offset, offset, ReplacementSpan.class);
            for (int i = 0; i < spans.length; ++i) {
                int start = ((Spanned)text).getSpanStart(spans[i]);
                int end = ((Spanned)text).getSpanEnd(spans[i]);
                if (start >= offset || end <= offset) continue;
                offset = start;
            }
        }
        return offset;
    }

    private final boolean $$robo$$android_text_Layout$shouldClampCursor(int line) {
        switch (1.$SwitchMap$android$text$Layout$Alignment[this.getParagraphAlignment(line).ordinal()]) {
            case 1: {
                return true;
            }
            case 2: {
                return this.getParagraphDirection(line) > 0;
            }
        }
        return false;
    }

    private final void $$robo$$android_text_Layout$getCursorPath(int point, Path dest, CharSequence editingBuffer) {
        dest.reset();
        int line = this.getLineForOffset(point);
        int top = this.getLineTop(line);
        int bottom = this.getLineTop(line + 1);
        boolean clamped = this.shouldClampCursor(line);
        float h1 = this.getPrimaryHorizontal(point, clamped) - 0.5f;
        float h2 = this.isLevelBoundary(point) ? this.getSecondaryHorizontal(point, clamped) - 0.5f : h1;
        int caps = TextKeyListener.getMetaState(editingBuffer, 1) | TextKeyListener.getMetaState(editingBuffer, 2048);
        int fn = TextKeyListener.getMetaState(editingBuffer, 2);
        int dist = 0;
        if (caps != 0 || fn != 0) {
            dist = bottom - top >> 2;
            if (fn != 0) {
                top += dist;
            }
            if (caps != 0) {
                bottom -= dist;
            }
        }
        if (h1 < 0.5f) {
            h1 = 0.5f;
        }
        if (h2 < 0.5f) {
            h2 = 0.5f;
        }
        if (Float.compare(h1, h2) == 0) {
            dest.moveTo(h1, top);
            dest.lineTo(h1, bottom);
        } else {
            dest.moveTo(h1, top);
            dest.lineTo(h1, top + bottom >> 1);
            dest.moveTo(h2, top + bottom >> 1);
            dest.lineTo(h2, bottom);
        }
        if (caps == 2) {
            dest.moveTo(h2, bottom);
            dest.lineTo(h2 - (float)dist, bottom + dist);
            dest.lineTo(h2, bottom);
            dest.lineTo(h2 + (float)dist, bottom + dist);
        } else if (caps == 1) {
            dest.moveTo(h2, bottom);
            dest.lineTo(h2 - (float)dist, bottom + dist);
            dest.moveTo(h2 - (float)dist, (float)(bottom + dist) - 0.5f);
            dest.lineTo(h2 + (float)dist, (float)(bottom + dist) - 0.5f);
            dest.moveTo(h2 + (float)dist, bottom + dist);
            dest.lineTo(h2, bottom);
        }
        if (fn == 2) {
            dest.moveTo(h1, top);
            dest.lineTo(h1 - (float)dist, top - dist);
            dest.lineTo(h1, top);
            dest.lineTo(h1 + (float)dist, top - dist);
        } else if (fn == 1) {
            dest.moveTo(h1, top);
            dest.lineTo(h1 - (float)dist, top - dist);
            dest.moveTo(h1 - (float)dist, (float)(top - dist) + 0.5f);
            dest.lineTo(h1 + (float)dist, (float)(top - dist) + 0.5f);
            dest.moveTo(h1 + (float)dist, top - dist);
            dest.lineTo(h1, top);
        }
    }

    private final void $$robo$$android_text_Layout$addSelection(int line, int start, int end, int top, int bottom, Path dest) {
        int linestart = this.getLineStart(line);
        int lineend = this.getLineEnd(line);
        Directions dirs = this.getLineDirections(line);
        if (lineend > linestart && this.mText.charAt(lineend - 1) == '\n') {
            --lineend;
        }
        for (int i = 0; i < dirs.mDirections.length; i += 2) {
            int en;
            int st;
            int here = linestart + dirs.mDirections[i];
            int there = here + (dirs.mDirections[i + 1] & 0x3FFFFFF);
            if (there > lineend) {
                there = lineend;
            }
            if (start > there || end < here || (st = Math.max(start, here)) == (en = Math.min(end, there))) continue;
            float h1 = this.getHorizontal(st, false, line, false);
            float h2 = this.getHorizontal(en, true, line, false);
            float left = Math.min(h1, h2);
            float right = Math.max(h1, h2);
            dest.addRect(left, top, right, bottom, Path.Direction.CW);
        }
    }

    private final void $$robo$$android_text_Layout$getSelectionPath(int start, int end, Path dest) {
        dest.reset();
        if (start == end) {
            return;
        }
        if (end < start) {
            int temp = end;
            end = start;
            start = temp;
        }
        int startline = this.getLineForOffset(start);
        int endline = this.getLineForOffset(end);
        int top = this.getLineTop(startline);
        int bottom = this.getLineBottom(endline);
        if (startline == endline) {
            this.addSelection(startline, start, end, top, bottom, dest);
        } else {
            float width = this.mWidth;
            this.addSelection(startline, start, this.getLineEnd(startline), top, this.getLineBottom(startline), dest);
            if (this.getParagraphDirection(startline) == -1) {
                dest.addRect(this.getLineLeft(startline), top, 0.0f, this.getLineBottom(startline), Path.Direction.CW);
            } else {
                dest.addRect(this.getLineRight(startline), top, width, this.getLineBottom(startline), Path.Direction.CW);
            }
            for (int i = startline + 1; i < endline; ++i) {
                top = this.getLineTop(i);
                bottom = this.getLineBottom(i);
                dest.addRect(0.0f, top, width, bottom, Path.Direction.CW);
            }
            top = this.getLineTop(endline);
            bottom = this.getLineBottom(endline);
            this.addSelection(endline, this.getLineStart(endline), end, top, bottom, dest);
            if (this.getParagraphDirection(endline) == -1) {
                dest.addRect(width, top, this.getLineRight(endline), bottom, Path.Direction.CW);
            } else {
                dest.addRect(0.0f, top, this.getLineLeft(endline), bottom, Path.Direction.CW);
            }
        }
    }

    private final Alignment $$robo$$android_text_Layout$getParagraphAlignment(int line) {
        Spanned sp;
        AlignmentSpan[] spans;
        int spanLength;
        Alignment align = this.mAlignment;
        if (this.mSpannedText && (spanLength = (spans = Layout.getParagraphSpans(sp = (Spanned)this.mText, this.getLineStart(line), this.getLineEnd(line), AlignmentSpan.class)).length) > 0) {
            align = spans[spanLength - 1].getAlignment();
        }
        return align;
    }

    private final int $$robo$$android_text_Layout$getParagraphLeft(int line) {
        int left = 0;
        int dir = this.getParagraphDirection(line);
        if (dir == -1 || !this.mSpannedText) {
            return left;
        }
        return this.getParagraphLeadingMargin(line);
    }

    private final int $$robo$$android_text_Layout$getParagraphRight(int line) {
        int right = this.mWidth;
        int dir = this.getParagraphDirection(line);
        if (dir == 1 || !this.mSpannedText) {
            return right;
        }
        return right - this.getParagraphLeadingMargin(line);
    }

    private final int $$robo$$android_text_Layout$getParagraphLeadingMargin(int line) {
        int i;
        boolean isFirstParaLine;
        int lineEnd;
        int spanEnd;
        if (!this.mSpannedText) {
            return 0;
        }
        Spanned spanned = (Spanned)this.mText;
        int lineStart = this.getLineStart(line);
        LeadingMarginSpan[] spans = Layout.getParagraphSpans(spanned, lineStart, spanEnd = spanned.nextSpanTransition(lineStart, lineEnd = this.getLineEnd(line), LeadingMarginSpan.class), LeadingMarginSpan.class);
        if (spans.length == 0) {
            return 0;
        }
        int margin = 0;
        boolean useFirstLineMargin = isFirstParaLine = lineStart == 0 || spanned.charAt(lineStart - 1) == '\n';
        for (i = 0; i < spans.length; ++i) {
            int count;
            if (!(spans[i] instanceof LeadingMarginSpan.LeadingMarginSpan2)) continue;
            int spStart = spanned.getSpanStart(spans[i]);
            int spanLine = this.getLineForOffset(spStart);
            useFirstLineMargin |= line < spanLine + (count = ((LeadingMarginSpan.LeadingMarginSpan2)spans[i]).getLeadingMarginLineCount());
        }
        for (i = 0; i < spans.length; ++i) {
            LeadingMarginSpan span = spans[i];
            margin += span.getLeadingMargin(useFirstLineMargin);
        }
        return margin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final float $$robo$$android_text_Layout$measurePara(TextPaint paint, CharSequence text, int start, int end, TextDirectionHeuristic textDir) {
        MeasuredText mt = MeasuredText.obtain();
        TextLine tl = TextLine.obtain();
        try {
            int dir;
            Directions directions;
            mt.setPara(text, start, end, textDir, null);
            if (mt.mEasy) {
                directions = DIRS_ALL_LEFT_TO_RIGHT;
                dir = 1;
            } else {
                directions = AndroidBidi.directions(mt.mDir, mt.mLevels, 0, mt.mChars, 0, mt.mLen);
                dir = mt.mDir;
            }
            char[] chars = mt.mChars;
            int len = mt.mLen;
            boolean hasTabs = false;
            TabStops tabStops = null;
            int margin = 0;
            if (text instanceof Spanned) {
                LeadingMarginSpan[] spans;
                Spanned spanned = (Spanned)text;
                for (LeadingMarginSpan lms : spans = Layout.getParagraphSpans(spanned, start, end, LeadingMarginSpan.class)) {
                    margin += lms.getLeadingMargin(true);
                }
            }
            for (int i = 0; i < len; ++i) {
                int spanEnd;
                Spanned spanned;
                Object[] spans;
                if (chars[i] != '\t') continue;
                hasTabs = true;
                if (!(text instanceof Spanned) || (spans = Layout.getParagraphSpans(spanned = (Spanned)text, start, spanEnd = spanned.nextSpanTransition(start, end, TabStopSpan.class), TabStopSpan.class)).length <= 0) break;
                tabStops = new TabStops(20, spans);
                break;
            }
            tl.set(paint, text, start, end, dir, directions, hasTabs, tabStops);
            float f = (float)margin + Math.abs(tl.metrics(null));
            return f;
        }
        finally {
            TextLine.recycle(tl);
            MeasuredText.recycle(mt);
        }
    }

    private static final float $$robo$$android_text_Layout$nextTab(CharSequence text, int start, int end, float h, Object[] tabs) {
        float nh = Float.MAX_VALUE;
        boolean alltabs = false;
        if (text instanceof Spanned) {
            if (tabs == null) {
                tabs = Layout.getParagraphSpans((Spanned)text, start, end, TabStopSpan.class);
                alltabs = true;
            }
            for (int i = 0; i < tabs.length; ++i) {
                int where;
                if (!alltabs && !(tabs[i] instanceof TabStopSpan) || !((float)(where = ((TabStopSpan)tabs[i]).getTabStop()) < nh) || !((float)where > h)) continue;
                nh = where;
            }
            if (nh != Float.MAX_VALUE) {
                return nh;
            }
        }
        return (int)((h + 20.0f) / 20.0f) * 20;
    }

    private final boolean $$robo$$android_text_Layout$isSpanned() {
        return this.mSpannedText;
    }

    private static final <T> T[] $$robo$$android_text_Layout$getParagraphSpans(Spanned text, int start, int end, Class<T> type) {
        if (start == end && start > 0) {
            return ArrayUtils.emptyArray(type);
        }
        if (text instanceof SpannableStringBuilder) {
            return ((SpannableStringBuilder)text).getSpans(start, end, type, false);
        }
        return text.getSpans(start, end, type);
    }

    private final char $$robo$$android_text_Layout$getEllipsisChar(TextUtils.TruncateAt method) {
        return method == TextUtils.TruncateAt.END_SMALL ? TextUtils.ELLIPSIS_TWO_DOTS[0] : TextUtils.ELLIPSIS_NORMAL[0];
    }

    private final void $$robo$$android_text_Layout$ellipsize(int start, int end, int line, char[] dest, int destoff, TextUtils.TruncateAt method) {
        int ellipsisCount = this.getEllipsisCount(line);
        if (ellipsisCount == 0) {
            return;
        }
        int ellipsisStart = this.getEllipsisStart(line);
        int linestart = this.getLineStart(line);
        for (int i = ellipsisStart; i < ellipsisStart + ellipsisCount; ++i) {
            int c = i == ellipsisStart ? (int)this.getEllipsisChar(method) : 65279;
            int a = i + linestart;
            if (a < start || a >= end) continue;
            dest[destoff + a - start] = c;
        }
    }

    public abstract int getEllipsisStart(int var1);

    public abstract int getEllipsisCount(int var1);

    static void __staticInitializer__() {
        NO_PARA_SPANS = ArrayUtils.emptyArray(ParagraphStyle.class);
        sTempRect = new Rect();
        DIRS_ALL_LEFT_TO_RIGHT = new Directions(new int[]{0, 0x3FFFFFF});
        DIRS_ALL_RIGHT_TO_LEFT = new Directions(new int[]{0, 0x7FFFFFF});
    }

    public static float getDesiredWidth(CharSequence charSequence, TextPaint textPaint) {
        return (float)InvokeDynamicSupport.bootstrapStatic("getDesiredWidth", $$robo$$android_text_Layout$getDesiredWidth(java.lang.CharSequence android.text.TextPaint ), 0, (CharSequence)charSequence, (TextPaint)textPaint);
    }

    public static float getDesiredWidth(CharSequence charSequence, int n, int n2, TextPaint textPaint) {
        return (float)InvokeDynamicSupport.bootstrapStatic("getDesiredWidth", $$robo$$android_text_Layout$getDesiredWidth(java.lang.CharSequence int int android.text.TextPaint ), 0, (CharSequence)charSequence, (int)n, (int)n2, (TextPaint)textPaint);
    }

    public static float getDesiredWidth(CharSequence charSequence, int n, int n2, TextPaint textPaint, TextDirectionHeuristic textDirectionHeuristic) {
        return (float)InvokeDynamicSupport.bootstrapStatic("getDesiredWidth", $$robo$$android_text_Layout$getDesiredWidth(java.lang.CharSequence int int android.text.TextPaint android.text.TextDirectionHeuristic ), 0, (CharSequence)charSequence, (int)n, (int)n2, (TextPaint)textPaint, (TextDirectionHeuristic)textDirectionHeuristic);
    }

    private void __constructor__(CharSequence charSequence, TextPaint textPaint, int n, Alignment alignment, float f, float f2) {
        this.$$robo$$android_text_Layout$__constructor__(charSequence, textPaint, n, alignment, f, f2);
    }

    protected Layout(CharSequence charSequence, TextPaint textPaint, int n, Alignment alignment, float f, float f2) {
        this(charSequence, textPaint, n, alignment, TextDirectionHeuristics.FIRSTSTRONG_LTR, f, f2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_Layout$__constructor__(java.lang.CharSequence android.text.TextPaint int android.text.Layout$Alignment float float ), 0, this, charSequence, textPaint, n, alignment, f, f2);
    }

    private void __constructor__(CharSequence charSequence, TextPaint textPaint, int n, Alignment alignment, TextDirectionHeuristic textDirectionHeuristic, float f, float f2) {
        this.$$robo$$android_text_Layout$__constructor__(charSequence, textPaint, n, alignment, textDirectionHeuristic, f, f2);
    }

    protected Layout(CharSequence charSequence, TextPaint textPaint, int n, Alignment alignment, TextDirectionHeuristic textDirectionHeuristic, float f, float f2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_Layout$__constructor__(java.lang.CharSequence android.text.TextPaint int android.text.Layout$Alignment android.text.TextDirectionHeuristic float float ), 0, this, charSequence, textPaint, n, alignment, textDirectionHeuristic, f, f2);
    }

    protected void setJustificationMode(int n) {
        InvokeDynamicSupport.bootstrap("setJustificationMode", $$robo$$android_text_Layout$setJustificationMode(int ), 0, this, n);
    }

    void replaceWith(CharSequence charSequence, TextPaint textPaint, int n, Alignment alignment, float f, float f2) {
        InvokeDynamicSupport.bootstrap("replaceWith", $$robo$$android_text_Layout$replaceWith(java.lang.CharSequence android.text.TextPaint int android.text.Layout$Alignment float float ), 0, this, charSequence, textPaint, n, alignment, f, f2);
    }

    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_text_Layout$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    public void draw(Canvas canvas, Path path, Paint paint, int n) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_text_Layout$draw(android.graphics.Canvas android.graphics.Path android.graphics.Paint int ), 0, this, canvas, path, paint, n);
    }

    private boolean isJustificationRequired(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isJustificationRequired", $$robo$$android_text_Layout$isJustificationRequired(int ), 0, this, n);
    }

    private float getJustifyWidth(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getJustifyWidth", $$robo$$android_text_Layout$getJustifyWidth(int ), 0, this, n);
    }

    public void drawText(Canvas canvas, int n, int n2) {
        InvokeDynamicSupport.bootstrap("drawText", $$robo$$android_text_Layout$drawText(android.graphics.Canvas int int ), 0, this, canvas, n, n2);
    }

    public void drawBackground(Canvas canvas, Path path, Paint paint, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("drawBackground", $$robo$$android_text_Layout$drawBackground(android.graphics.Canvas android.graphics.Path android.graphics.Paint int int int ), 0, this, canvas, path, paint, n, n2, n3);
    }

    public long getLineRangeForDraw(Canvas canvas) {
        return (long)InvokeDynamicSupport.bootstrap("getLineRangeForDraw", $$robo$$android_text_Layout$getLineRangeForDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    private int getLineStartPos(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("getLineStartPos", $$robo$$android_text_Layout$getLineStartPos(int int int ), 0, this, n, n2, n3);
    }

    public CharSequence getText() {
        return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_text_Layout$getText(), 0, this);
    }

    public TextPaint getPaint() {
        return InvokeDynamicSupport.bootstrap("getPaint", $$robo$$android_text_Layout$getPaint(), 0, this);
    }

    public int getWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_text_Layout$getWidth(), 0, this);
    }

    public int getEllipsizedWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getEllipsizedWidth", $$robo$$android_text_Layout$getEllipsizedWidth(), 0, this);
    }

    public void increaseWidthTo(int n) {
        InvokeDynamicSupport.bootstrap("increaseWidthTo", $$robo$$android_text_Layout$increaseWidthTo(int ), 0, this, n);
    }

    public int getHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_text_Layout$getHeight(), 0, this);
    }

    public int getHeight(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_text_Layout$getHeight(boolean ), 0, this, bl);
    }

    public Alignment getAlignment() {
        return InvokeDynamicSupport.bootstrap("getAlignment", $$robo$$android_text_Layout$getAlignment(), 0, this);
    }

    public float getSpacingMultiplier() {
        return (float)InvokeDynamicSupport.bootstrap("getSpacingMultiplier", $$robo$$android_text_Layout$getSpacingMultiplier(), 0, this);
    }

    public float getSpacingAdd() {
        return (float)InvokeDynamicSupport.bootstrap("getSpacingAdd", $$robo$$android_text_Layout$getSpacingAdd(), 0, this);
    }

    public TextDirectionHeuristic getTextDirectionHeuristic() {
        return InvokeDynamicSupport.bootstrap("getTextDirectionHeuristic", $$robo$$android_text_Layout$getTextDirectionHeuristic(), 0, this);
    }

    public int getLineBounds(int n, Rect rect) {
        return (int)InvokeDynamicSupport.bootstrap("getLineBounds", $$robo$$android_text_Layout$getLineBounds(int android.graphics.Rect ), 0, this, n, rect);
    }

    public int getHyphen(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getHyphen", $$robo$$android_text_Layout$getHyphen(int ), 0, this, n);
    }

    public int getIndentAdjust(int n, Alignment alignment) {
        return (int)InvokeDynamicSupport.bootstrap("getIndentAdjust", $$robo$$android_text_Layout$getIndentAdjust(int android.text.Layout$Alignment ), 0, this, n, alignment);
    }

    public boolean isLevelBoundary(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isLevelBoundary", $$robo$$android_text_Layout$isLevelBoundary(int ), 0, this, n);
    }

    public boolean isRtlCharAt(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isRtlCharAt", $$robo$$android_text_Layout$isRtlCharAt(int ), 0, this, n);
    }

    public long getRunRange(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getRunRange", $$robo$$android_text_Layout$getRunRange(int ), 0, this, n);
    }

    private boolean primaryIsTrailingPrevious(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("primaryIsTrailingPrevious", $$robo$$android_text_Layout$primaryIsTrailingPrevious(int ), 0, this, n);
    }

    public float getPrimaryHorizontal(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getPrimaryHorizontal", $$robo$$android_text_Layout$getPrimaryHorizontal(int ), 0, this, n);
    }

    public float getPrimaryHorizontal(int n, boolean bl) {
        return (float)InvokeDynamicSupport.bootstrap("getPrimaryHorizontal", $$robo$$android_text_Layout$getPrimaryHorizontal(int boolean ), 0, this, n, bl);
    }

    public float getSecondaryHorizontal(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getSecondaryHorizontal", $$robo$$android_text_Layout$getSecondaryHorizontal(int ), 0, this, n);
    }

    public float getSecondaryHorizontal(int n, boolean bl) {
        return (float)InvokeDynamicSupport.bootstrap("getSecondaryHorizontal", $$robo$$android_text_Layout$getSecondaryHorizontal(int boolean ), 0, this, n, bl);
    }

    private float getHorizontal(int n, boolean bl) {
        return (float)InvokeDynamicSupport.bootstrap("getHorizontal", $$robo$$android_text_Layout$getHorizontal(int boolean ), 0, this, n, bl);
    }

    private float getHorizontal(int n, boolean bl, boolean bl2) {
        return (float)InvokeDynamicSupport.bootstrap("getHorizontal", $$robo$$android_text_Layout$getHorizontal(int boolean boolean ), 0, this, n, bl, bl2);
    }

    private float getHorizontal(int n, boolean bl, int n2, boolean bl2) {
        return (float)InvokeDynamicSupport.bootstrap("getHorizontal", $$robo$$android_text_Layout$getHorizontal(int boolean int boolean ), 0, this, n, bl, n2, bl2);
    }

    public float getLineLeft(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getLineLeft", $$robo$$android_text_Layout$getLineLeft(int ), 0, this, n);
    }

    public float getLineRight(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getLineRight", $$robo$$android_text_Layout$getLineRight(int ), 0, this, n);
    }

    public float getLineMax(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getLineMax", $$robo$$android_text_Layout$getLineMax(int ), 0, this, n);
    }

    public float getLineWidth(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getLineWidth", $$robo$$android_text_Layout$getLineWidth(int ), 0, this, n);
    }

    private float getLineExtent(int n, boolean bl) {
        return (float)InvokeDynamicSupport.bootstrap("getLineExtent", $$robo$$android_text_Layout$getLineExtent(int boolean ), 0, this, n, bl);
    }

    private float getLineExtent(int n, TabStops tabStops, boolean bl) {
        return (float)InvokeDynamicSupport.bootstrap("getLineExtent", $$robo$$android_text_Layout$getLineExtent(int android.text.Layout$TabStops boolean ), 0, this, n, tabStops, bl);
    }

    public int getLineForVertical(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLineForVertical", $$robo$$android_text_Layout$getLineForVertical(int ), 0, this, n);
    }

    public int getLineForOffset(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLineForOffset", $$robo$$android_text_Layout$getLineForOffset(int ), 0, this, n);
    }

    public int getOffsetForHorizontal(int n, float f) {
        return (int)InvokeDynamicSupport.bootstrap("getOffsetForHorizontal", $$robo$$android_text_Layout$getOffsetForHorizontal(int float ), 0, this, n, f);
    }

    public int getOffsetForHorizontal(int n, float f, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getOffsetForHorizontal", $$robo$$android_text_Layout$getOffsetForHorizontal(int float boolean ), 0, this, n, f, bl);
    }

    public int getLineEnd(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLineEnd", $$robo$$android_text_Layout$getLineEnd(int ), 0, this, n);
    }

    public int getLineVisibleEnd(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLineVisibleEnd", $$robo$$android_text_Layout$getLineVisibleEnd(int ), 0, this, n);
    }

    private int getLineVisibleEnd(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("getLineVisibleEnd", $$robo$$android_text_Layout$getLineVisibleEnd(int int int ), 0, this, n, n2, n3);
    }

    public int getLineBottom(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLineBottom", $$robo$$android_text_Layout$getLineBottom(int ), 0, this, n);
    }

    public int getLineBaseline(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLineBaseline", $$robo$$android_text_Layout$getLineBaseline(int ), 0, this, n);
    }

    public int getLineAscent(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLineAscent", $$robo$$android_text_Layout$getLineAscent(int ), 0, this, n);
    }

    public int getOffsetToLeftOf(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getOffsetToLeftOf", $$robo$$android_text_Layout$getOffsetToLeftOf(int ), 0, this, n);
    }

    public int getOffsetToRightOf(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getOffsetToRightOf", $$robo$$android_text_Layout$getOffsetToRightOf(int ), 0, this, n);
    }

    private int getOffsetToLeftRightOf(int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getOffsetToLeftRightOf", $$robo$$android_text_Layout$getOffsetToLeftRightOf(int boolean ), 0, this, n, bl);
    }

    private int getOffsetAtStartOf(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getOffsetAtStartOf", $$robo$$android_text_Layout$getOffsetAtStartOf(int ), 0, this, n);
    }

    public boolean shouldClampCursor(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldClampCursor", $$robo$$android_text_Layout$shouldClampCursor(int ), 0, this, n);
    }

    public void getCursorPath(int n, Path path, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("getCursorPath", $$robo$$android_text_Layout$getCursorPath(int android.graphics.Path java.lang.CharSequence ), 0, this, n, path, charSequence);
    }

    private void addSelection(int n, int n2, int n3, int n4, int n5, Path path) {
        InvokeDynamicSupport.bootstrap("addSelection", $$robo$$android_text_Layout$addSelection(int int int int int android.graphics.Path ), 0, this, n, n2, n3, n4, n5, path);
    }

    public void getSelectionPath(int n, int n2, Path path) {
        InvokeDynamicSupport.bootstrap("getSelectionPath", $$robo$$android_text_Layout$getSelectionPath(int int android.graphics.Path ), 0, this, n, n2, path);
    }

    public Alignment getParagraphAlignment(int n) {
        return InvokeDynamicSupport.bootstrap("getParagraphAlignment", $$robo$$android_text_Layout$getParagraphAlignment(int ), 0, this, n);
    }

    public int getParagraphLeft(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getParagraphLeft", $$robo$$android_text_Layout$getParagraphLeft(int ), 0, this, n);
    }

    public int getParagraphRight(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getParagraphRight", $$robo$$android_text_Layout$getParagraphRight(int ), 0, this, n);
    }

    private int getParagraphLeadingMargin(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getParagraphLeadingMargin", $$robo$$android_text_Layout$getParagraphLeadingMargin(int ), 0, this, n);
    }

    static float measurePara(TextPaint textPaint, CharSequence charSequence, int n, int n2, TextDirectionHeuristic textDirectionHeuristic) {
        return (float)InvokeDynamicSupport.bootstrapStatic("measurePara", $$robo$$android_text_Layout$measurePara(android.text.TextPaint java.lang.CharSequence int int android.text.TextDirectionHeuristic ), 0, (TextPaint)textPaint, (CharSequence)charSequence, (int)n, (int)n2, (TextDirectionHeuristic)textDirectionHeuristic);
    }

    static float nextTab(CharSequence charSequence, int n, int n2, float f, Object[] objectArray) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nextTab", $$robo$$android_text_Layout$nextTab(java.lang.CharSequence int int float java.lang.Object[] ), 0, (CharSequence)charSequence, (int)n, (int)n2, (float)f, (Object[])objectArray);
    }

    protected boolean isSpanned() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSpanned", $$robo$$android_text_Layout$isSpanned(), 0, this);
    }

    static <T> T[] getParagraphSpans(Spanned spanned, int n, int n2, Class<T> clazz) {
        return InvokeDynamicSupport.bootstrapStatic("getParagraphSpans", $$robo$$android_text_Layout$getParagraphSpans(android.text.Spanned int int java.lang.Class<T> ), 0, (Spanned)spanned, (int)n, (int)n2, clazz);
    }

    private char getEllipsisChar(TextUtils.TruncateAt truncateAt) {
        return (char)InvokeDynamicSupport.bootstrap("getEllipsisChar", $$robo$$android_text_Layout$getEllipsisChar(android.text.TextUtils$TruncateAt ), 0, this, truncateAt);
    }

    private void ellipsize(int n, int n2, int n3, char[] cArray, int n4, TextUtils.TruncateAt truncateAt) {
        InvokeDynamicSupport.bootstrap("ellipsize", $$robo$$android_text_Layout$ellipsize(int int int char[] int android.text.TextUtils$TruncateAt ), 0, this, n, n2, n3, cArray, n4, truncateAt);
    }

    static {
        RobolectricInternals.classInitializing(Layout.class);
    }

    public /* synthetic */ Layout() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Layout)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Alignment
    extends Enum<Alignment> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ Alignment ALIGN_NORMAL;
        public static /* enum */ Alignment ALIGN_OPPOSITE;
        public static /* enum */ Alignment ALIGN_CENTER;
        public static /* enum */ Alignment ALIGN_LEFT;
        public static /* enum */ Alignment ALIGN_RIGHT;
        private static /* synthetic */ Alignment[] $VALUES;

        private static final Alignment[] $$robo$$android_text_Layout_Alignment$values() {
            return (Alignment[])$VALUES.clone();
        }

        private static final Alignment $$robo$$android_text_Layout_Alignment$valueOf(String name) {
            return Enum.valueOf(Alignment.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_text_Layout_Alignment$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            ALIGN_NORMAL = new Alignment();
            ALIGN_OPPOSITE = new Alignment();
            ALIGN_CENTER = new Alignment();
            ALIGN_LEFT = new Alignment();
            ALIGN_RIGHT = new Alignment();
            $VALUES = new Alignment[]{ALIGN_NORMAL, ALIGN_OPPOSITE, ALIGN_CENTER, ALIGN_LEFT, ALIGN_RIGHT};
        }

        public static Alignment[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_text_Layout_Alignment$values(), 0);
        }

        public static Alignment valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_text_Layout_Alignment$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_text_Layout_Alignment$__constructor__(string2, n);
        }

        private Alignment() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_Layout_Alignment$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(Alignment.class);
        }

        public /* synthetic */ Alignment() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Alignment)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class SpannedEllipsizer
    extends Ellipsizer
    implements Spanned,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Spanned mSpanned;

        private void $$robo$$android_text_Layout_SpannedEllipsizer$__constructor__(CharSequence display) {
            this.mSpanned = (Spanned)display;
        }

        private final <T> T[] $$robo$$android_text_Layout_SpannedEllipsizer$getSpans(int start, int end, Class<T> type) {
            return this.mSpanned.getSpans(start, end, type);
        }

        private final int $$robo$$android_text_Layout_SpannedEllipsizer$getSpanStart(Object tag) {
            return this.mSpanned.getSpanStart(tag);
        }

        private final int $$robo$$android_text_Layout_SpannedEllipsizer$getSpanEnd(Object tag) {
            return this.mSpanned.getSpanEnd(tag);
        }

        private final int $$robo$$android_text_Layout_SpannedEllipsizer$getSpanFlags(Object tag) {
            return this.mSpanned.getSpanFlags(tag);
        }

        private final int $$robo$$android_text_Layout_SpannedEllipsizer$nextSpanTransition(int start, int limit, Class type) {
            return this.mSpanned.nextSpanTransition(start, limit, type);
        }

        private final CharSequence $$robo$$android_text_Layout_SpannedEllipsizer$subSequence(int start, int end) {
            char[] s = new char[end - start];
            this.getChars(start, end, s, 0);
            SpannableString ss = new SpannableString(new String(s));
            TextUtils.copySpansFrom(this.mSpanned, start, end, Object.class, ss, 0);
            return ss;
        }

        private void __constructor__(CharSequence charSequence) {
            this.$$robo$$android_text_Layout_SpannedEllipsizer$__constructor__(charSequence);
        }

        public SpannedEllipsizer(CharSequence charSequence) {
            super(charSequence);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_Layout_SpannedEllipsizer$__constructor__(java.lang.CharSequence ), 0, this, charSequence);
        }

        @Override
        public <T> T[] getSpans(int n, int n2, Class<T> clazz) {
            return InvokeDynamicSupport.bootstrap("getSpans", $$robo$$android_text_Layout_SpannedEllipsizer$getSpans(int int java.lang.Class<T> ), 0, this, n, n2, clazz);
        }

        @Override
        public int getSpanStart(Object object) {
            return (int)InvokeDynamicSupport.bootstrap("getSpanStart", $$robo$$android_text_Layout_SpannedEllipsizer$getSpanStart(java.lang.Object ), 0, this, object);
        }

        @Override
        public int getSpanEnd(Object object) {
            return (int)InvokeDynamicSupport.bootstrap("getSpanEnd", $$robo$$android_text_Layout_SpannedEllipsizer$getSpanEnd(java.lang.Object ), 0, this, object);
        }

        @Override
        public int getSpanFlags(Object object) {
            return (int)InvokeDynamicSupport.bootstrap("getSpanFlags", $$robo$$android_text_Layout_SpannedEllipsizer$getSpanFlags(java.lang.Object ), 0, this, object);
        }

        @Override
        public int nextSpanTransition(int n, int n2, Class clazz) {
            return (int)InvokeDynamicSupport.bootstrap("nextSpanTransition", $$robo$$android_text_Layout_SpannedEllipsizer$nextSpanTransition(int int java.lang.Class ), 0, this, n, n2, clazz);
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("subSequence", $$robo$$android_text_Layout_SpannedEllipsizer$subSequence(int int ), 0, this, n, n2);
        }

        public /* synthetic */ SpannedEllipsizer() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SpannedEllipsizer)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Ellipsizer
    implements CharSequence,
    GetChars,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        CharSequence mText;
        Layout mLayout;
        int mWidth;
        TextUtils.TruncateAt mMethod;

        private void $$robo$$android_text_Layout_Ellipsizer$__constructor__(CharSequence s) {
            this.mText = s;
        }

        private final char $$robo$$android_text_Layout_Ellipsizer$charAt(int off) {
            char[] buf = TextUtils.obtain(1);
            this.getChars(off, off + 1, buf, 0);
            char ret = buf[0];
            TextUtils.recycle(buf);
            return ret;
        }

        private final void $$robo$$android_text_Layout_Ellipsizer$getChars(int start, int end, char[] dest, int destoff) {
            int line1 = this.mLayout.getLineForOffset(start);
            int line2 = this.mLayout.getLineForOffset(end);
            TextUtils.getChars(this.mText, start, end, dest, destoff);
            for (int i = line1; i <= line2; ++i) {
                this.mLayout.ellipsize(start, end, i, dest, destoff, this.mMethod);
            }
        }

        private final int $$robo$$android_text_Layout_Ellipsizer$length() {
            return this.mText.length();
        }

        private final CharSequence $$robo$$android_text_Layout_Ellipsizer$subSequence(int start, int end) {
            char[] s = new char[end - start];
            this.getChars(start, end, s, 0);
            return new String(s);
        }

        private final String $$robo$$android_text_Layout_Ellipsizer$toString() {
            char[] s = new char[this.length()];
            this.getChars(0, this.length(), s, 0);
            return new String(s);
        }

        private void __constructor__(CharSequence charSequence) {
            this.$$robo$$android_text_Layout_Ellipsizer$__constructor__(charSequence);
        }

        public Ellipsizer(CharSequence charSequence) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_Layout_Ellipsizer$__constructor__(java.lang.CharSequence ), 0, this, charSequence);
        }

        @Override
        public char charAt(int n) {
            return (char)InvokeDynamicSupport.bootstrap("charAt", $$robo$$android_text_Layout_Ellipsizer$charAt(int ), 0, this, n);
        }

        @Override
        public void getChars(int n, int n2, char[] cArray, int n3) {
            InvokeDynamicSupport.bootstrap("getChars", $$robo$$android_text_Layout_Ellipsizer$getChars(int int char[] int ), 0, this, n, n2, cArray, n3);
        }

        @Override
        public int length() {
            return (int)InvokeDynamicSupport.bootstrap("length", $$robo$$android_text_Layout_Ellipsizer$length(), 0, this);
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("subSequence", $$robo$$android_text_Layout_Ellipsizer$subSequence(int int ), 0, this, n, n2);
        }

        @Override
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_text_Layout_Ellipsizer$toString(), 0, this);
        }

        public /* synthetic */ Ellipsizer() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Ellipsizer)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Directions
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int[] mDirections;

        private void $$robo$$android_text_Layout_Directions$__constructor__(int[] dirs) {
            this.mDirections = dirs;
        }

        private void __constructor__(int[] nArray) {
            this.$$robo$$android_text_Layout_Directions$__constructor__(nArray);
        }

        public Directions(int[] nArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_Layout_Directions$__constructor__(int[] ), 0, this, nArray);
        }

        public /* synthetic */ Directions() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Directions)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class TabStops
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int[] mStops;
        private int mNumStops;
        private int mIncrement;

        private void $$robo$$android_text_Layout_TabStops$__constructor__(int increment, Object[] spans) {
            this.reset(increment, spans);
        }

        private final void $$robo$$android_text_Layout_TabStops$reset(int increment, Object[] spans) {
            this.mIncrement = increment;
            int ns = 0;
            if (spans != null) {
                int[] stops = this.mStops;
                for (Object o : spans) {
                    if (!(o instanceof TabStopSpan)) continue;
                    if (stops == null) {
                        stops = new int[10];
                    } else if (ns == stops.length) {
                        int[] nstops = new int[ns * 2];
                        for (int i = 0; i < ns; ++i) {
                            nstops[i] = stops[i];
                        }
                        stops = nstops;
                    }
                    stops[ns++] = ((TabStopSpan)o).getTabStop();
                }
                if (ns > 1) {
                    Arrays.sort(stops, 0, ns);
                }
                if (stops != this.mStops) {
                    this.mStops = stops;
                }
            }
            this.mNumStops = ns;
        }

        private final float $$robo$$android_text_Layout_TabStops$nextTab(float h) {
            int ns = this.mNumStops;
            if (ns > 0) {
                int[] stops = this.mStops;
                for (int i = 0; i < ns; ++i) {
                    int stop = stops[i];
                    if (!((float)stop > h)) continue;
                    return stop;
                }
            }
            return TabStops.nextDefaultStop(h, this.mIncrement);
        }

        private static final float $$robo$$android_text_Layout_TabStops$nextDefaultStop(float h, int inc) {
            return (int)((h + (float)inc) / (float)inc) * inc;
        }

        private void __constructor__(int n, Object[] objectArray) {
            this.$$robo$$android_text_Layout_TabStops$__constructor__(n, objectArray);
        }

        TabStops(int n, Object[] objectArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_Layout_TabStops$__constructor__(int java.lang.Object[] ), 0, this, n, objectArray);
        }

        void reset(int n, Object[] objectArray) {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_text_Layout_TabStops$reset(int java.lang.Object[] ), 0, this, n, objectArray);
        }

        float nextTab(float f) {
            return (float)InvokeDynamicSupport.bootstrap("nextTab", $$robo$$android_text_Layout_TabStops$nextTab(float ), 0, this, f);
        }

        public static float nextDefaultStop(float f, int n) {
            return (float)InvokeDynamicSupport.bootstrapStatic("nextDefaultStop", $$robo$$android_text_Layout_TabStops$nextDefaultStop(float int ), 0, (float)f, (int)n);
        }

        public /* synthetic */ TabStops() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TabStops)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface JustificationMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HyphenationFrequency {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BreakStrategy {
    }
}

