/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Paint;
import android.os.LocaleList;
import android.text.AndroidBidi;
import android.text.Hyphenator;
import android.text.Layout;
import android.text.MeasuredText;
import android.text.Spanned;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineHeightSpan;
import android.text.style.MetricAffectingSpan;
import android.text.style.TabStopSpan;
import android.util.Log;
import android.util.Pools;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class StaticLayout
extends Layout
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "StaticLayout";
    private int mLineCount;
    private int mTopPadding;
    private int mBottomPadding;
    private int mColumns;
    private int mEllipsizedWidth;
    private boolean mEllipsized;
    private int mMaxLineHeight;
    private static int COLUMNS_NORMAL = 4;
    private static int COLUMNS_ELLIPSIZE = 6;
    private static int START = 0;
    private static int DIR = 0;
    private static int TAB = 0;
    private static int TOP = 1;
    private static int DESCENT = 2;
    private static int HYPHEN = 3;
    private static int ELLIPSIS_START = 4;
    private static int ELLIPSIS_COUNT = 5;
    private int[] mLines;
    private Layout.Directions[] mLineDirections;
    private int mMaximumVisibleLineCount;
    private static int START_MASK = 0x1FFFFFFF;
    private static int DIR_SHIFT = 30;
    private static int TAB_MASK = 0x20000000;
    private static int HYPHEN_MASK = 255;
    private static int TAB_INCREMENT = 20;
    private static char CHAR_NEW_LINE = '\n';
    private static double EXTRA_ROUNDING = 0.5;
    private static int DEFAULT_MAX_LINE_HEIGHT = -1;
    private int[] mLeftIndents;
    private int[] mRightIndents;

    private void $$robo$$android_text_StaticLayout$__constructor__(CharSequence source, TextPaint paint, int width, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad) {
    }

    private void $$robo$$android_text_StaticLayout$__constructor__(CharSequence source, TextPaint paint, int width, Layout.Alignment align, TextDirectionHeuristic textDir, float spacingmult, float spacingadd, boolean includepad) {
    }

    private void $$robo$$android_text_StaticLayout$__constructor__(CharSequence source, int bufstart, int bufend, TextPaint paint, int outerwidth, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad) {
    }

    private void $$robo$$android_text_StaticLayout$__constructor__(CharSequence source, int bufstart, int bufend, TextPaint paint, int outerwidth, Layout.Alignment align, TextDirectionHeuristic textDir, float spacingmult, float spacingadd, boolean includepad) {
    }

    private void $$robo$$android_text_StaticLayout$__constructor__(CharSequence source, int bufstart, int bufend, TextPaint paint, int outerwidth, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad, TextUtils.TruncateAt ellipsize, int ellipsizedWidth) {
    }

    private void $$robo$$android_text_StaticLayout$__constructor__(CharSequence source, int bufstart, int bufend, TextPaint paint, int outerwidth, Layout.Alignment align, TextDirectionHeuristic textDir, float spacingmult, float spacingadd, boolean includepad, TextUtils.TruncateAt ellipsize, int ellipsizedWidth, int maxLines) {
        this.mMaxLineHeight = -1;
        this.mMaximumVisibleLineCount = Integer.MAX_VALUE;
        Builder b = Builder.obtain(source, bufstart, bufend, paint, outerwidth).setAlignment(align).setTextDirection(textDir).setLineSpacing(spacingadd, spacingmult).setIncludePad(includepad).setEllipsizedWidth(ellipsizedWidth).setEllipsize(ellipsize).setMaxLines(maxLines);
        if (ellipsize != null) {
            Layout.Ellipsizer e = (Layout.Ellipsizer)this.getText();
            e.mLayout = this;
            e.mWidth = ellipsizedWidth;
            e.mMethod = ellipsize;
            this.mEllipsizedWidth = ellipsizedWidth;
            this.mColumns = 6;
        } else {
            this.mColumns = 4;
            this.mEllipsizedWidth = outerwidth;
        }
        this.mLineDirections = ArrayUtils.newUnpaddedArray(Layout.Directions.class, 2 * this.mColumns);
        this.mLines = new int[this.mLineDirections.length];
        this.mMaximumVisibleLineCount = maxLines;
        this.generate(b, b.mIncludePad, b.mIncludePad);
        Builder.recycle(b);
    }

    private void $$robo$$android_text_StaticLayout$__constructor__(CharSequence text) {
        this.mMaxLineHeight = -1;
        this.mMaximumVisibleLineCount = Integer.MAX_VALUE;
        this.mColumns = 6;
        this.mLineDirections = ArrayUtils.newUnpaddedArray(Layout.Directions.class, 2 * this.mColumns);
        this.mLines = new int[this.mLineDirections.length];
    }

    private void $$robo$$android_text_StaticLayout$__constructor__(Builder b) {
        this.mMaxLineHeight = -1;
        this.mMaximumVisibleLineCount = Integer.MAX_VALUE;
        if (b.mEllipsize != null) {
            Layout.Ellipsizer e = (Layout.Ellipsizer)this.getText();
            e.mLayout = this;
            e.mWidth = b.mEllipsizedWidth;
            e.mMethod = b.mEllipsize;
            this.mEllipsizedWidth = b.mEllipsizedWidth;
            this.mColumns = 6;
        } else {
            this.mColumns = 4;
            this.mEllipsizedWidth = b.mWidth;
        }
        this.mLineDirections = ArrayUtils.newUnpaddedArray(Layout.Directions.class, 2 * this.mColumns);
        this.mLines = new int[this.mLineDirections.length];
        this.mMaximumVisibleLineCount = b.mMaxLines;
        this.mLeftIndents = b.mLeftIndents;
        this.mRightIndents = b.mRightIndents;
        this.setJustificationMode(b.mJustificationMode);
        this.generate(b, b.mIncludePad, b.mIncludePad);
    }

    private final void $$robo$$android_text_StaticLayout$generate(Builder b, boolean includepad, boolean trackpad) {
        CharSequence source = b.mText;
        int bufStart = b.mStart;
        int bufEnd = b.mEnd;
        TextPaint paint = b.mPaint;
        int outerWidth = b.mWidth;
        TextDirectionHeuristic textDir = b.mTextDir;
        float spacingmult = b.mSpacingMult;
        float spacingadd = b.mSpacingAdd;
        float ellipsizedWidth = b.mEllipsizedWidth;
        TextUtils.TruncateAt ellipsize = b.mEllipsize;
        LineBreaks lineBreaks = new LineBreaks();
        int[] spanEndCache = new int[4];
        int[] fmCache = new int[16];
        b.setLocales(paint.getTextLocales());
        this.mLineCount = 0;
        this.mEllipsized = false;
        this.mMaxLineHeight = this.mMaximumVisibleLineCount < 1 ? 0 : -1;
        int v = 0;
        boolean needMultiply = spacingmult != 1.0f || spacingadd != 0.0f;
        Paint.FontMetricsInt fm = b.mFontMetricsInt;
        int[] chooseHtv = null;
        MeasuredText measured = b.mMeasuredText;
        Spanned spanned = null;
        if (source instanceof Spanned) {
            spanned = (Spanned)source;
        }
        int paraStart = bufStart;
        while (paraStart <= bufEnd) {
            boolean ellipsisMayBeApplied;
            TabStopSpan[] spans;
            int paraEnd = TextUtils.indexOf(source, '\n', paraStart, bufEnd);
            paraEnd = paraEnd < 0 ? bufEnd : ++paraEnd;
            int firstWidthLineCount = 1;
            int firstWidth = outerWidth;
            int restWidth = outerWidth;
            LineHeightSpan[] chooseHt = null;
            if (spanned != null) {
                int i;
                LeadingMarginSpan[] sp = StaticLayout.getParagraphSpans(spanned, paraStart, paraEnd, LeadingMarginSpan.class);
                for (i = 0; i < sp.length; ++i) {
                    LeadingMarginSpan lms = sp[i];
                    firstWidth -= sp[i].getLeadingMargin(true);
                    restWidth -= sp[i].getLeadingMargin(false);
                    if (!(lms instanceof LeadingMarginSpan.LeadingMarginSpan2)) continue;
                    LeadingMarginSpan.LeadingMarginSpan2 lms2 = (LeadingMarginSpan.LeadingMarginSpan2)lms;
                    firstWidthLineCount = Math.max(firstWidthLineCount, lms2.getLeadingMarginLineCount());
                }
                chooseHt = StaticLayout.getParagraphSpans(spanned, paraStart, paraEnd, LineHeightSpan.class);
                if (chooseHt.length == 0) {
                    chooseHt = null;
                } else {
                    if (chooseHtv == null || chooseHtv.length < chooseHt.length) {
                        chooseHtv = ArrayUtils.newUnpaddedIntArray(chooseHt.length);
                    }
                    for (i = 0; i < chooseHt.length; ++i) {
                        int o = spanned.getSpanStart(chooseHt[i]);
                        chooseHtv[i] = o < paraStart ? this.getLineTop(this.getLineForOffset(o)) : v;
                    }
                }
            }
            measured.setPara(source, paraStart, paraEnd, textDir, b);
            char[] chs = measured.mChars;
            float[] widths = measured.mWidths;
            byte[] chdirs = measured.mLevels;
            int dir = measured.mDir;
            boolean easy = measured.mEasy;
            int[] variableTabStops = null;
            if (spanned != null && (spans = StaticLayout.getParagraphSpans(spanned, paraStart, paraEnd, TabStopSpan.class)).length > 0) {
                int[] stops = new int[spans.length];
                for (int i = 0; i < spans.length; ++i) {
                    stops[i] = spans[i].getTabStop();
                }
                Arrays.sort(stops, 0, stops.length);
                variableTabStops = stops;
            }
            StaticLayout.nSetupParagraph(b.mNativePtr, chs, paraEnd - paraStart, firstWidth, firstWidthLineCount, restWidth, variableTabStops, 20, b.mBreakStrategy, b.mHyphenationFrequency, b.mJustificationMode != 0);
            if (this.mLeftIndents != null || this.mRightIndents != null) {
                int leftLen = this.mLeftIndents == null ? 0 : this.mLeftIndents.length;
                int rightLen = this.mRightIndents == null ? 0 : this.mRightIndents.length;
                int indentsLen = Math.max(1, Math.max(leftLen, rightLen) - this.mLineCount);
                int[] indents = new int[indentsLen];
                for (int i = 0; i < indentsLen; ++i) {
                    int leftMargin = this.mLeftIndents == null ? 0 : this.mLeftIndents[Math.min(i + this.mLineCount, leftLen - 1)];
                    int rightMargin = this.mRightIndents == null ? 0 : this.mRightIndents[Math.min(i + this.mLineCount, rightLen - 1)];
                    indents[i] = leftMargin + rightMargin;
                }
                StaticLayout.nSetIndents(b.mNativePtr, indents);
            }
            int fmCacheCount = 0;
            int spanEndCacheCount = 0;
            int spanStart = paraStart;
            while (spanStart < paraEnd) {
                int spanLen;
                int spanEnd;
                if (fmCacheCount * 4 >= fmCache.length) {
                    int[] grow = new int[fmCacheCount * 4 * 2];
                    InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])fmCache, (int)0, (int[])grow, (int)0, (int)(fmCacheCount * 4));
                    fmCache = grow;
                }
                if (spanEndCacheCount >= spanEndCache.length) {
                    int[] grow = new int[spanEndCacheCount * 2];
                    InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])spanEndCache, (int)0, (int[])grow, (int)0, (int)spanEndCacheCount);
                    spanEndCache = grow;
                }
                if (spanned == null) {
                    spanEnd = paraEnd;
                    spanLen = spanEnd - spanStart;
                    measured.addStyleRun(paint, spanLen, fm);
                } else {
                    spanEnd = spanned.nextSpanTransition(spanStart, paraEnd, MetricAffectingSpan.class);
                    spanLen = spanEnd - spanStart;
                    MetricAffectingSpan[] spans2 = spanned.getSpans(spanStart, spanEnd, MetricAffectingSpan.class);
                    spans2 = TextUtils.removeEmptySpans(spans2, spanned, MetricAffectingSpan.class);
                    measured.addStyleRun(paint, spans2, spanLen, fm);
                }
                fmCache[fmCacheCount * 4 + 0] = fm.top;
                fmCache[fmCacheCount * 4 + 1] = fm.bottom;
                fmCache[fmCacheCount * 4 + 2] = fm.ascent;
                fmCache[fmCacheCount * 4 + 3] = fm.descent;
                ++fmCacheCount;
                spanEndCache[spanEndCacheCount] = spanEnd;
                ++spanEndCacheCount;
                spanStart = spanEnd;
            }
            StaticLayout.nGetWidths(b.mNativePtr, widths);
            int breakCount = StaticLayout.nComputeLineBreaks(b.mNativePtr, lineBreaks, lineBreaks.breaks, lineBreaks.widths, lineBreaks.flags, lineBreaks.breaks.length);
            int[] breaks = lineBreaks.breaks;
            float[] lineWidths = lineBreaks.widths;
            int[] flags = lineBreaks.flags;
            int remainingLineCount = this.mMaximumVisibleLineCount - this.mLineCount;
            boolean bl = ellipsisMayBeApplied = ellipsize != null && (ellipsize == TextUtils.TruncateAt.END || this.mMaximumVisibleLineCount == 1 && ellipsize != TextUtils.TruncateAt.MARQUEE);
            if (remainingLineCount > 0 && remainingLineCount < breakCount && ellipsisMayBeApplied) {
                float width = 0.0f;
                int flag = 0;
                for (int i = remainingLineCount - 1; i < breakCount; ++i) {
                    if (i == breakCount - 1) {
                        width += lineWidths[i];
                    } else {
                        int j;
                        int n = j = i == 0 ? 0 : breaks[i - 1];
                        while (j < breaks[i]) {
                            width += widths[j];
                            ++j;
                        }
                    }
                    flag |= flags[i] & 0x20000000;
                }
                breaks[remainingLineCount - 1] = breaks[breakCount - 1];
                lineWidths[remainingLineCount - 1] = width;
                flags[remainingLineCount - 1] = flag;
                breakCount = remainingLineCount;
            }
            int here = paraStart;
            int fmTop = 0;
            int fmBottom = 0;
            int fmAscent = 0;
            int fmDescent = 0;
            int fmCacheIndex = 0;
            int spanEndCacheIndex = 0;
            int breakIndex = 0;
            int spanStart2 = paraStart;
            while (spanStart2 < paraEnd) {
                int spanEnd = spanEndCache[spanEndCacheIndex++];
                fm.top = fmCache[fmCacheIndex * 4 + 0];
                fm.bottom = fmCache[fmCacheIndex * 4 + 1];
                fm.ascent = fmCache[fmCacheIndex * 4 + 2];
                fm.descent = fmCache[fmCacheIndex * 4 + 3];
                ++fmCacheIndex;
                if (fm.top < fmTop) {
                    fmTop = fm.top;
                }
                if (fm.ascent < fmAscent) {
                    fmAscent = fm.ascent;
                }
                if (fm.descent > fmDescent) {
                    fmDescent = fm.descent;
                }
                if (fm.bottom > fmBottom) {
                    fmBottom = fm.bottom;
                }
                while (breakIndex < breakCount && paraStart + breaks[breakIndex] < spanStart2) {
                    ++breakIndex;
                }
                while (breakIndex < breakCount && paraStart + breaks[breakIndex] <= spanEnd) {
                    int endPos = paraStart + breaks[breakIndex];
                    boolean moreChars = endPos < bufEnd;
                    v = this.out(source, here, endPos, fmAscent, fmDescent, fmTop, fmBottom, v, spacingmult, spacingadd, chooseHt, chooseHtv, fm, flags[breakIndex], needMultiply, chdirs, dir, easy, bufEnd, includepad, trackpad, chs, widths, paraStart, ellipsize, ellipsizedWidth, lineWidths[breakIndex], paint, moreChars);
                    if (endPos < spanEnd) {
                        fmTop = fm.top;
                        fmBottom = fm.bottom;
                        fmAscent = fm.ascent;
                        fmDescent = fm.descent;
                    } else {
                        fmDescent = 0;
                        fmAscent = 0;
                        fmBottom = 0;
                        fmTop = 0;
                    }
                    here = endPos;
                    ++breakIndex;
                    if (this.mLineCount < this.mMaximumVisibleLineCount || !this.mEllipsized) continue;
                    return;
                }
                spanStart2 = spanEnd;
            }
            if (paraEnd == bufEnd) break;
            paraStart = paraEnd;
        }
        if ((bufEnd == bufStart || source.charAt(bufEnd - 1) == '\n') && this.mLineCount < this.mMaximumVisibleLineCount) {
            measured.setPara(source, bufEnd, bufEnd, textDir, b);
            paint.getFontMetricsInt(fm);
            v = this.out(source, bufEnd, bufEnd, fm.ascent, fm.descent, fm.top, fm.bottom, v, spacingmult, spacingadd, null, null, fm, 0, needMultiply, measured.mLevels, measured.mDir, measured.mEasy, bufEnd, includepad, trackpad, null, null, bufStart, ellipsize, ellipsizedWidth, 0.0f, paint, false);
        }
    }

    private final int $$robo$$android_text_StaticLayout$out(CharSequence text, int start, int end, int above, int below, int top, int bottom, int v, float spacingmult, float spacingadd, LineHeightSpan[] chooseHt, int[] chooseHtv, Paint.FontMetricsInt fm, int flags, boolean needMultiply, byte[] chdirs, int dir, boolean easy, int bufEnd, boolean includePad, boolean trackPad, char[] chs, float[] widths, int widthStart, TextUtils.TruncateAt ellipsize, float ellipsisWidth, float textWidth, TextPaint paint, boolean moreChars) {
        double ex;
        boolean lastLine;
        boolean currentLineIsTheLastVisibleOne;
        int j = this.mLineCount;
        int off = j * this.mColumns;
        int want = off + this.mColumns + 1;
        int[] lines = this.mLines;
        if (want >= lines.length) {
            Layout.Directions[] grow2 = ArrayUtils.newUnpaddedArray(Layout.Directions.class, GrowingArrayUtils.growSize(want));
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mLineDirections, (int)0, (Object)grow2, (int)0, (int)this.mLineDirections.length);
            this.mLineDirections = grow2;
            int[] grow = new int[grow2.length];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])lines, (int)0, (int[])grow, (int)0, (int)lines.length);
            this.mLines = grow;
            lines = grow;
        }
        if (chooseHt != null) {
            fm.ascent = above;
            fm.descent = below;
            fm.top = top;
            fm.bottom = bottom;
            for (int i = 0; i < chooseHt.length; ++i) {
                if (chooseHt[i] instanceof LineHeightSpan.WithDensity) {
                    ((LineHeightSpan.WithDensity)chooseHt[i]).chooseHeight(text, start, end, chooseHtv[i], v, fm, paint);
                    continue;
                }
                chooseHt[i].chooseHeight(text, start, end, chooseHtv[i], v, fm);
            }
            above = fm.ascent;
            below = fm.descent;
            top = fm.top;
            bottom = fm.bottom;
        }
        boolean firstLine = j == 0;
        boolean bl = currentLineIsTheLastVisibleOne = j + 1 == this.mMaximumVisibleLineCount;
        if (ellipsize != null) {
            boolean doEllipsis;
            boolean forceEllipsis = moreChars && this.mLineCount + 1 == this.mMaximumVisibleLineCount;
            boolean bl2 = doEllipsis = (this.mMaximumVisibleLineCount == 1 && moreChars || firstLine && !moreChars) && ellipsize != TextUtils.TruncateAt.MARQUEE || !firstLine && (currentLineIsTheLastVisibleOne || !moreChars) && ellipsize == TextUtils.TruncateAt.END;
            if (doEllipsis) {
                this.calculateEllipsis(start, end, widths, widthStart, ellipsisWidth, ellipsize, j, textWidth, paint, forceEllipsis);
            }
        }
        boolean bl3 = lastLine = this.mEllipsized || end == bufEnd;
        if (firstLine) {
            if (trackPad) {
                this.mTopPadding = top - above;
            }
            if (includePad) {
                above = top;
            }
        }
        if (lastLine) {
            if (trackPad) {
                this.mBottomPadding = bottom - below;
            }
            if (includePad) {
                below = bottom;
            }
        }
        int extra = needMultiply && !lastLine ? ((ex = (double)((float)(below - above) * (spacingmult - 1.0f) + spacingadd)) >= 0.0 ? (int)(ex + 0.5) : -((int)(-ex + 0.5))) : 0;
        lines[off + 0] = start;
        lines[off + 1] = v;
        lines[off + 2] = below + extra;
        if (!this.mEllipsized && currentLineIsTheLastVisibleOne) {
            int maxLineBelow = includePad ? bottom : below;
            this.mMaxLineHeight = v + (maxLineBelow - above);
        }
        lines[off + this.mColumns + 0] = end;
        lines[off + this.mColumns + 1] = v += below - above + extra;
        int n = off + 0;
        lines[n] = lines[n] | flags & 0x20000000;
        lines[off + 3] = flags;
        int n2 = off + 0;
        lines[n2] = lines[n2] | dir << 30;
        Layout.Directions linedirs = DIRS_ALL_LEFT_TO_RIGHT;
        this.mLineDirections[j] = easy ? linedirs : AndroidBidi.directions(dir, chdirs, start - widthStart, chs, start - widthStart, end - start);
        ++this.mLineCount;
        return v;
    }

    private final void $$robo$$android_text_StaticLayout$calculateEllipsis(int lineStart, int lineEnd, float[] widths, int widthStart, float avail, TextUtils.TruncateAt where, int line, float textWidth, TextPaint paint, boolean forceEllipsis) {
        if (textWidth <= (avail -= this.getTotalInsets(line)) && !forceEllipsis) {
            this.mLines[this.mColumns * line + 4] = 0;
            this.mLines[this.mColumns * line + 5] = 0;
            return;
        }
        float ellipsisWidth = paint.measureText(where == TextUtils.TruncateAt.END_SMALL ? TextUtils.ELLIPSIS_TWO_DOTS : TextUtils.ELLIPSIS_NORMAL, 0, 1);
        int ellipsisStart = 0;
        int ellipsisCount = 0;
        int len = lineEnd - lineStart;
        if (where == TextUtils.TruncateAt.START) {
            if (this.mMaximumVisibleLineCount == 1) {
                int i;
                float sum = 0.0f;
                for (i = len; i > 0; --i) {
                    float w = widths[i - 1 + lineStart - widthStart];
                    if (w + sum + ellipsisWidth > avail) {
                        while (i < len && widths[i + lineStart - widthStart] == 0.0f) {
                            ++i;
                        }
                        break;
                    }
                    sum += w;
                }
                ellipsisStart = 0;
                ellipsisCount = i;
            } else if (Log.isLoggable("StaticLayout", 5)) {
                Log.w("StaticLayout", "Start Ellipsis only supported with one line");
            }
        } else if (where == TextUtils.TruncateAt.END || where == TextUtils.TruncateAt.MARQUEE || where == TextUtils.TruncateAt.END_SMALL) {
            float w;
            int i;
            float sum = 0.0f;
            for (i = 0; i < len && !((w = widths[i + lineStart - widthStart]) + sum + ellipsisWidth > avail); ++i) {
                sum += w;
            }
            ellipsisStart = i;
            ellipsisCount = len - i;
            if (forceEllipsis && ellipsisCount == 0 && len > 0) {
                ellipsisStart = len - 1;
                ellipsisCount = 1;
            }
        } else if (this.mMaximumVisibleLineCount == 1) {
            float w;
            float lsum = 0.0f;
            float rsum = 0.0f;
            int left = 0;
            int right = len;
            float ravail = (avail - ellipsisWidth) / 2.0f;
            for (right = len; right > 0; --right) {
                float w2 = widths[right - 1 + lineStart - widthStart];
                if (w2 + rsum > ravail) {
                    while (right < len && widths[right + lineStart - widthStart] == 0.0f) {
                        ++right;
                    }
                    break;
                }
                rsum += w2;
            }
            float lavail = avail - ellipsisWidth - rsum;
            for (left = 0; left < right && !((w = widths[left + lineStart - widthStart]) + lsum > lavail); ++left) {
                lsum += w;
            }
            ellipsisStart = left;
            ellipsisCount = right - left;
        } else if (Log.isLoggable("StaticLayout", 5)) {
            Log.w("StaticLayout", "Middle Ellipsis only supported with one line");
        }
        this.mEllipsized = true;
        this.mLines[this.mColumns * line + 4] = ellipsisStart;
        this.mLines[this.mColumns * line + 5] = ellipsisCount;
    }

    private final float $$robo$$android_text_StaticLayout$getTotalInsets(int line) {
        int totalIndent = 0;
        if (this.mLeftIndents != null) {
            totalIndent = this.mLeftIndents[Math.min(line, this.mLeftIndents.length - 1)];
        }
        if (this.mRightIndents != null) {
            totalIndent += this.mRightIndents[Math.min(line, this.mRightIndents.length - 1)];
        }
        return totalIndent;
    }

    private final int $$robo$$android_text_StaticLayout$getLineForVertical(int vertical) {
        int high = this.mLineCount;
        int low = -1;
        int[] lines = this.mLines;
        while (high - low > 1) {
            int guess = high + low >> 1;
            if (lines[this.mColumns * guess + 1] > vertical) {
                high = guess;
                continue;
            }
            low = guess;
        }
        if (low < 0) {
            return 0;
        }
        return low;
    }

    private final int $$robo$$android_text_StaticLayout$getLineCount() {
        return this.mLineCount;
    }

    private final int $$robo$$android_text_StaticLayout$getLineTop(int line) {
        return this.mLines[this.mColumns * line + 1];
    }

    private final int $$robo$$android_text_StaticLayout$getLineDescent(int line) {
        return this.mLines[this.mColumns * line + 2];
    }

    private final int $$robo$$android_text_StaticLayout$getLineStart(int line) {
        return this.mLines[this.mColumns * line + 0] & 0x1FFFFFFF;
    }

    private final int $$robo$$android_text_StaticLayout$getParagraphDirection(int line) {
        return this.mLines[this.mColumns * line + 0] >> 30;
    }

    private final boolean $$robo$$android_text_StaticLayout$getLineContainsTab(int line) {
        return (this.mLines[this.mColumns * line + 0] & 0x20000000) != 0;
    }

    private final Layout.Directions $$robo$$android_text_StaticLayout$getLineDirections(int line) {
        return this.mLineDirections[line];
    }

    private final int $$robo$$android_text_StaticLayout$getTopPadding() {
        return this.mTopPadding;
    }

    private final int $$robo$$android_text_StaticLayout$getBottomPadding() {
        return this.mBottomPadding;
    }

    private final int $$robo$$android_text_StaticLayout$getHyphen(int line) {
        return this.mLines[this.mColumns * line + 3] & 0xFF;
    }

    private final int $$robo$$android_text_StaticLayout$getIndentAdjust(int line, Layout.Alignment align) {
        if (align == Layout.Alignment.ALIGN_LEFT) {
            if (this.mLeftIndents == null) {
                return 0;
            }
            return this.mLeftIndents[Math.min(line, this.mLeftIndents.length - 1)];
        }
        if (align == Layout.Alignment.ALIGN_RIGHT) {
            if (this.mRightIndents == null) {
                return 0;
            }
            return -this.mRightIndents[Math.min(line, this.mRightIndents.length - 1)];
        }
        if (align == Layout.Alignment.ALIGN_CENTER) {
            int left = 0;
            if (this.mLeftIndents != null) {
                left = this.mLeftIndents[Math.min(line, this.mLeftIndents.length - 1)];
            }
            int right = 0;
            if (this.mRightIndents != null) {
                right = this.mRightIndents[Math.min(line, this.mRightIndents.length - 1)];
            }
            return left - right >> 1;
        }
        throw new AssertionError((Object)("unhandled alignment " + (Object)((Object)align)));
    }

    private final int $$robo$$android_text_StaticLayout$getEllipsisCount(int line) {
        if (this.mColumns < 6) {
            return 0;
        }
        return this.mLines[this.mColumns * line + 5];
    }

    private final int $$robo$$android_text_StaticLayout$getEllipsisStart(int line) {
        if (this.mColumns < 6) {
            return 0;
        }
        return this.mLines[this.mColumns * line + 4];
    }

    private final int $$robo$$android_text_StaticLayout$getEllipsizedWidth() {
        return this.mEllipsizedWidth;
    }

    private final int $$robo$$android_text_StaticLayout$getHeight(boolean cap) {
        if (cap && this.mLineCount >= this.mMaximumVisibleLineCount && this.mMaxLineHeight == -1 && Log.isLoggable("StaticLayout", 5)) {
            Log.w("StaticLayout", "maxLineHeight should not be -1.  maxLines:" + this.mMaximumVisibleLineCount + " lineCount:" + this.mLineCount);
        }
        return cap && this.mLineCount >= this.mMaximumVisibleLineCount && this.mMaxLineHeight != -1 ? this.mMaxLineHeight : super.getHeight();
    }

    private static final long $$robo$$android_text_StaticLayout$nNewBuilder() {
        return 0L;
    }

    private static final void $$robo$$android_text_StaticLayout$nFreeBuilder(long l) {
    }

    private static final void $$robo$$android_text_StaticLayout$nFinishBuilder(long l) {
    }

    private static final long $$robo$$android_text_StaticLayout$nLoadHyphenator(ByteBuffer byteBuffer, int n, int n2, int n3) {
        return 0L;
    }

    private static final void $$robo$$android_text_StaticLayout$nSetLocales(long l, String string2, long[] lArray) {
    }

    private static final void $$robo$$android_text_StaticLayout$nSetIndents(long l, int[] nArray) {
    }

    private static final void $$robo$$android_text_StaticLayout$nSetupParagraph(long l, char[] cArray, int n, float f, int n2, float f2, int[] nArray, int n3, int n4, int n5, boolean bl) {
    }

    private static final float $$robo$$android_text_StaticLayout$nAddStyleRun(long l, long l2, long l3, int n, int n2, boolean bl) {
        return 0.0f;
    }

    private static final void $$robo$$android_text_StaticLayout$nAddMeasuredRun(long l, int n, int n2, float[] fArray) {
    }

    private static final void $$robo$$android_text_StaticLayout$nAddReplacementRun(long l, int n, int n2, float f) {
    }

    private static final void $$robo$$android_text_StaticLayout$nGetWidths(long l, float[] fArray) {
    }

    private static final int $$robo$$android_text_StaticLayout$nComputeLineBreaks(long l, LineBreaks lineBreaks, int[] nArray, float[] fArray, int[] nArray2, int n) {
        return 0;
    }

    private /* synthetic */ void $$robo$$android_text_StaticLayout$__constructor__(Builder x0, 1 x1) {
    }

    private void __constructor__(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, boolean bl) {
        this.$$robo$$android_text_StaticLayout$__constructor__(charSequence, textPaint, n, alignment, f, f2, bl);
    }

    public StaticLayout(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, boolean bl) {
        this(charSequence, 0, charSequence.length(), textPaint, n, alignment, f, f2, bl);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_StaticLayout$__constructor__(java.lang.CharSequence android.text.TextPaint int android.text.Layout$Alignment float float boolean ), 0, this, charSequence, textPaint, n, alignment, f, f2, bl);
    }

    private void __constructor__(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, TextDirectionHeuristic textDirectionHeuristic, float f, float f2, boolean bl) {
        this.$$robo$$android_text_StaticLayout$__constructor__(charSequence, textPaint, n, alignment, textDirectionHeuristic, f, f2, bl);
    }

    public StaticLayout(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, TextDirectionHeuristic textDirectionHeuristic, float f, float f2, boolean bl) {
        this(charSequence, 0, charSequence.length(), textPaint, n, alignment, textDirectionHeuristic, f, f2, bl);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_StaticLayout$__constructor__(java.lang.CharSequence android.text.TextPaint int android.text.Layout$Alignment android.text.TextDirectionHeuristic float float boolean ), 0, this, charSequence, textPaint, n, alignment, textDirectionHeuristic, f, f2, bl);
    }

    private void __constructor__(CharSequence charSequence, int n, int n2, TextPaint textPaint, int n3, Layout.Alignment alignment, float f, float f2, boolean bl) {
        this.$$robo$$android_text_StaticLayout$__constructor__(charSequence, n, n2, textPaint, n3, alignment, f, f2, bl);
    }

    public StaticLayout(CharSequence charSequence, int n, int n2, TextPaint textPaint, int n3, Layout.Alignment alignment, float f, float f2, boolean bl) {
        this(charSequence, n, n2, textPaint, n3, alignment, f, f2, bl, null, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_StaticLayout$__constructor__(java.lang.CharSequence int int android.text.TextPaint int android.text.Layout$Alignment float float boolean ), 0, this, charSequence, n, n2, textPaint, n3, alignment, f, f2, bl);
    }

    private void __constructor__(CharSequence charSequence, int n, int n2, TextPaint textPaint, int n3, Layout.Alignment alignment, TextDirectionHeuristic textDirectionHeuristic, float f, float f2, boolean bl) {
        this.$$robo$$android_text_StaticLayout$__constructor__(charSequence, n, n2, textPaint, n3, alignment, textDirectionHeuristic, f, f2, bl);
    }

    public StaticLayout(CharSequence charSequence, int n, int n2, TextPaint textPaint, int n3, Layout.Alignment alignment, TextDirectionHeuristic textDirectionHeuristic, float f, float f2, boolean bl) {
        this(charSequence, n, n2, textPaint, n3, alignment, textDirectionHeuristic, f, f2, bl, null, 0, Integer.MAX_VALUE);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_StaticLayout$__constructor__(java.lang.CharSequence int int android.text.TextPaint int android.text.Layout$Alignment android.text.TextDirectionHeuristic float float boolean ), 0, this, charSequence, n, n2, textPaint, n3, alignment, textDirectionHeuristic, f, f2, bl);
    }

    private void __constructor__(CharSequence charSequence, int n, int n2, TextPaint textPaint, int n3, Layout.Alignment alignment, float f, float f2, boolean bl, TextUtils.TruncateAt truncateAt, int n4) {
        this.$$robo$$android_text_StaticLayout$__constructor__(charSequence, n, n2, textPaint, n3, alignment, f, f2, bl, truncateAt, n4);
    }

    public StaticLayout(CharSequence charSequence, int n, int n2, TextPaint textPaint, int n3, Layout.Alignment alignment, float f, float f2, boolean bl, TextUtils.TruncateAt truncateAt, int n4) {
        this(charSequence, n, n2, textPaint, n3, alignment, TextDirectionHeuristics.FIRSTSTRONG_LTR, f, f2, bl, truncateAt, n4, Integer.MAX_VALUE);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_StaticLayout$__constructor__(java.lang.CharSequence int int android.text.TextPaint int android.text.Layout$Alignment float float boolean android.text.TextUtils$TruncateAt int ), 0, this, charSequence, n, n2, textPaint, n3, alignment, f, f2, bl, truncateAt, n4);
    }

    private void __constructor__(CharSequence charSequence, int n, int n2, TextPaint textPaint, int n3, Layout.Alignment alignment, TextDirectionHeuristic textDirectionHeuristic, float f, float f2, boolean bl, TextUtils.TruncateAt truncateAt, int n4, int n5) {
        this.$$robo$$android_text_StaticLayout$__constructor__(charSequence, n, n2, textPaint, n3, alignment, textDirectionHeuristic, f, f2, bl, truncateAt, n4, n5);
    }

    public StaticLayout(CharSequence charSequence, int n, int n2, TextPaint textPaint, int n3, Layout.Alignment alignment, TextDirectionHeuristic textDirectionHeuristic, float f, float f2, boolean bl, TextUtils.TruncateAt truncateAt, int n4, int n5) {
        super(truncateAt == null ? charSequence : (charSequence instanceof Spanned ? new Layout.SpannedEllipsizer(charSequence) : new Layout.Ellipsizer(charSequence)), textPaint, n3, alignment, textDirectionHeuristic, f, f2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_StaticLayout$__constructor__(java.lang.CharSequence int int android.text.TextPaint int android.text.Layout$Alignment android.text.TextDirectionHeuristic float float boolean android.text.TextUtils$TruncateAt int int ), 0, this, charSequence, n, n2, textPaint, n3, alignment, textDirectionHeuristic, f, f2, bl, truncateAt, n4, n5);
    }

    private void __constructor__(CharSequence charSequence) {
        this.$$robo$$android_text_StaticLayout$__constructor__(charSequence);
    }

    StaticLayout(CharSequence charSequence) {
        super(charSequence, null, 0, null, 0.0f, 0.0f);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_StaticLayout$__constructor__(java.lang.CharSequence ), 0, this, charSequence);
    }

    private void __constructor__(Builder builder) {
        this.$$robo$$android_text_StaticLayout$__constructor__(builder);
    }

    private StaticLayout(Builder builder) {
        super(builder.mEllipsize == null ? builder.mText : (builder.mText instanceof Spanned ? new Layout.SpannedEllipsizer(builder.mText) : new Layout.Ellipsizer(builder.mText)), builder.mPaint, builder.mWidth, builder.mAlignment, builder.mSpacingMult, builder.mSpacingAdd);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_StaticLayout$__constructor__(android.text.StaticLayout$Builder ), 0, this, builder);
    }

    void generate(Builder builder, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("generate", $$robo$$android_text_StaticLayout$generate(android.text.StaticLayout$Builder boolean boolean ), 0, this, builder, bl, bl2);
    }

    private int out(CharSequence charSequence, int n, int n2, int n3, int n4, int n5, int n6, int n7, float f, float f2, LineHeightSpan[] lineHeightSpanArray, int[] nArray, Paint.FontMetricsInt fontMetricsInt, int n8, boolean bl, byte[] byArray, int n9, boolean bl2, int n10, boolean bl3, boolean bl4, char[] cArray, float[] fArray, int n11, TextUtils.TruncateAt truncateAt, float f3, float f4, TextPaint textPaint, boolean bl5) {
        return (int)InvokeDynamicSupport.bootstrap("out", $$robo$$android_text_StaticLayout$out(java.lang.CharSequence int int int int int int int float float android.text.style.LineHeightSpan[] int[] android.graphics.Paint$FontMetricsInt int boolean byte[] int boolean int boolean boolean char[] float[] int android.text.TextUtils$TruncateAt float float android.text.TextPaint boolean ), 0, this, charSequence, n, n2, n3, n4, n5, n6, n7, f, f2, lineHeightSpanArray, nArray, fontMetricsInt, n8, bl, byArray, n9, bl2, n10, bl3, bl4, cArray, fArray, n11, truncateAt, f3, f4, textPaint, bl5);
    }

    private void calculateEllipsis(int n, int n2, float[] fArray, int n3, float f, TextUtils.TruncateAt truncateAt, int n4, float f2, TextPaint textPaint, boolean bl) {
        InvokeDynamicSupport.bootstrap("calculateEllipsis", $$robo$$android_text_StaticLayout$calculateEllipsis(int int float[] int float android.text.TextUtils$TruncateAt int float android.text.TextPaint boolean ), 0, this, n, n2, fArray, n3, f, truncateAt, n4, f2, textPaint, bl);
    }

    private float getTotalInsets(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getTotalInsets", $$robo$$android_text_StaticLayout$getTotalInsets(int ), 0, this, n);
    }

    @Override
    public int getLineForVertical(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLineForVertical", $$robo$$android_text_StaticLayout$getLineForVertical(int ), 0, this, n);
    }

    @Override
    public int getLineCount() {
        return (int)InvokeDynamicSupport.bootstrap("getLineCount", $$robo$$android_text_StaticLayout$getLineCount(), 0, this);
    }

    @Override
    public int getLineTop(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLineTop", $$robo$$android_text_StaticLayout$getLineTop(int ), 0, this, n);
    }

    @Override
    public int getLineDescent(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLineDescent", $$robo$$android_text_StaticLayout$getLineDescent(int ), 0, this, n);
    }

    @Override
    public int getLineStart(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLineStart", $$robo$$android_text_StaticLayout$getLineStart(int ), 0, this, n);
    }

    @Override
    public int getParagraphDirection(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getParagraphDirection", $$robo$$android_text_StaticLayout$getParagraphDirection(int ), 0, this, n);
    }

    @Override
    public boolean getLineContainsTab(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("getLineContainsTab", $$robo$$android_text_StaticLayout$getLineContainsTab(int ), 0, this, n);
    }

    @Override
    public Layout.Directions getLineDirections(int n) {
        return InvokeDynamicSupport.bootstrap("getLineDirections", $$robo$$android_text_StaticLayout$getLineDirections(int ), 0, this, n);
    }

    @Override
    public int getTopPadding() {
        return (int)InvokeDynamicSupport.bootstrap("getTopPadding", $$robo$$android_text_StaticLayout$getTopPadding(), 0, this);
    }

    @Override
    public int getBottomPadding() {
        return (int)InvokeDynamicSupport.bootstrap("getBottomPadding", $$robo$$android_text_StaticLayout$getBottomPadding(), 0, this);
    }

    @Override
    public int getHyphen(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getHyphen", $$robo$$android_text_StaticLayout$getHyphen(int ), 0, this, n);
    }

    @Override
    public int getIndentAdjust(int n, Layout.Alignment alignment) {
        return (int)InvokeDynamicSupport.bootstrap("getIndentAdjust", $$robo$$android_text_StaticLayout$getIndentAdjust(int android.text.Layout$Alignment ), 0, this, n, alignment);
    }

    @Override
    public int getEllipsisCount(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getEllipsisCount", $$robo$$android_text_StaticLayout$getEllipsisCount(int ), 0, this, n);
    }

    @Override
    public int getEllipsisStart(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getEllipsisStart", $$robo$$android_text_StaticLayout$getEllipsisStart(int ), 0, this, n);
    }

    @Override
    public int getEllipsizedWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getEllipsizedWidth", $$robo$$android_text_StaticLayout$getEllipsizedWidth(), 0, this);
    }

    @Override
    public int getHeight(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_text_StaticLayout$getHeight(boolean ), 0, this, bl);
    }

    private static final native /* synthetic */ long $$robo$$nNewBuilder$nativeBinding();

    private static long nNewBuilder() {
        return (long)InvokeDynamicSupport.bootstrapStatic("nNewBuilder", $$robo$$android_text_StaticLayout$nNewBuilder(), 1);
    }

    private static final native /* synthetic */ void $$robo$$nFreeBuilder$nativeBinding(long var0);

    private static void nFreeBuilder(long l) {
        InvokeDynamicSupport.bootstrapStatic("nFreeBuilder", $$robo$$android_text_StaticLayout$nFreeBuilder(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nFinishBuilder$nativeBinding(long var0);

    private static void nFinishBuilder(long l) {
        InvokeDynamicSupport.bootstrapStatic("nFinishBuilder", $$robo$$android_text_StaticLayout$nFinishBuilder(long ), 1, (long)l);
    }

    private static final native /* synthetic */ long $$robo$$nLoadHyphenator$nativeBinding(ByteBuffer var0, int var1, int var2, int var3);

    static long nLoadHyphenator(ByteBuffer byteBuffer, int n, int n2, int n3) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nLoadHyphenator", $$robo$$android_text_StaticLayout$nLoadHyphenator(java.nio.ByteBuffer int int int ), 1, (ByteBuffer)byteBuffer, (int)n, (int)n2, (int)n3);
    }

    private static final native /* synthetic */ void $$robo$$nSetLocales$nativeBinding(long var0, String var2, long[] var3);

    private static void nSetLocales(long l, String string2, long[] lArray) {
        InvokeDynamicSupport.bootstrapStatic("nSetLocales", $$robo$$android_text_StaticLayout$nSetLocales(long java.lang.String long[] ), 1, (long)l, (String)string2, (long[])lArray);
    }

    private static final native /* synthetic */ void $$robo$$nSetIndents$nativeBinding(long var0, int[] var2);

    private static void nSetIndents(long l, int[] nArray) {
        InvokeDynamicSupport.bootstrapStatic("nSetIndents", $$robo$$android_text_StaticLayout$nSetIndents(long int[] ), 1, (long)l, (int[])nArray);
    }

    private static final native /* synthetic */ void $$robo$$nSetupParagraph$nativeBinding(long var0, char[] var2, int var3, float var4, int var5, float var6, int[] var7, int var8, int var9, int var10, boolean var11);

    private static void nSetupParagraph(long l, char[] cArray, int n, float f, int n2, float f2, int[] nArray, int n3, int n4, int n5, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nSetupParagraph", $$robo$$android_text_StaticLayout$nSetupParagraph(long char[] int float int float int[] int int int boolean ), 1, (long)l, (char[])cArray, (int)n, (float)f, (int)n2, (float)f2, (int[])nArray, (int)n3, (int)n4, (int)n5, (boolean)bl);
    }

    private static final native /* synthetic */ float $$robo$$nAddStyleRun$nativeBinding(long var0, long var2, long var4, int var6, int var7, boolean var8);

    private static float nAddStyleRun(long l, long l2, long l3, int n, int n2, boolean bl) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nAddStyleRun", $$robo$$android_text_StaticLayout$nAddStyleRun(long long long int int boolean ), 1, (long)l, (long)l2, (long)l3, (int)n, (int)n2, (boolean)bl);
    }

    private static final native /* synthetic */ void $$robo$$nAddMeasuredRun$nativeBinding(long var0, int var2, int var3, float[] var4);

    private static void nAddMeasuredRun(long l, int n, int n2, float[] fArray) {
        InvokeDynamicSupport.bootstrapStatic("nAddMeasuredRun", $$robo$$android_text_StaticLayout$nAddMeasuredRun(long int int float[] ), 1, (long)l, (int)n, (int)n2, (float[])fArray);
    }

    private static final native /* synthetic */ void $$robo$$nAddReplacementRun$nativeBinding(long var0, int var2, int var3, float var4);

    private static void nAddReplacementRun(long l, int n, int n2, float f) {
        InvokeDynamicSupport.bootstrapStatic("nAddReplacementRun", $$robo$$android_text_StaticLayout$nAddReplacementRun(long int int float ), 1, (long)l, (int)n, (int)n2, (float)f);
    }

    private static final native /* synthetic */ void $$robo$$nGetWidths$nativeBinding(long var0, float[] var2);

    private static void nGetWidths(long l, float[] fArray) {
        InvokeDynamicSupport.bootstrapStatic("nGetWidths", $$robo$$android_text_StaticLayout$nGetWidths(long float[] ), 1, (long)l, (float[])fArray);
    }

    private static final native /* synthetic */ int $$robo$$nComputeLineBreaks$nativeBinding(long var0, LineBreaks var2, int[] var3, float[] var4, int[] var5, int var6);

    private static int nComputeLineBreaks(long l, LineBreaks lineBreaks, int[] nArray, float[] fArray, int[] nArray2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nComputeLineBreaks", $$robo$$android_text_StaticLayout$nComputeLineBreaks(long android.text.StaticLayout$LineBreaks int[] float[] int[] int ), 1, (long)l, (LineBreaks)lineBreaks, (int[])nArray, (float[])fArray, (int[])nArray2, (int)n);
    }

    private /* synthetic */ void __constructor__(Builder builder, 1 var2_2) {
        this.$$robo$$android_text_StaticLayout$__constructor__(builder, var2_2);
    }

    public /* synthetic */ StaticLayout() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StaticLayout)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class LineBreaks
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int INITIAL_SIZE = 16;
        public int[] breaks;
        public float[] widths;
        public int[] flags;

        private void $$robo$$android_text_StaticLayout_LineBreaks$__constructor__() {
            this.breaks = new int[16];
            this.widths = new float[16];
            this.flags = new int[16];
        }

        private void __constructor__() {
            this.$$robo$$android_text_StaticLayout_LineBreaks$__constructor__();
        }

        LineBreaks() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_StaticLayout_LineBreaks$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LineBreaks)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        long mNativePtr;
        CharSequence mText;
        int mStart;
        int mEnd;
        TextPaint mPaint;
        int mWidth;
        Layout.Alignment mAlignment;
        TextDirectionHeuristic mTextDir;
        float mSpacingMult;
        float mSpacingAdd;
        boolean mIncludePad;
        int mEllipsizedWidth;
        TextUtils.TruncateAt mEllipsize;
        int mMaxLines;
        int mBreakStrategy;
        int mHyphenationFrequency;
        int[] mLeftIndents;
        int[] mRightIndents;
        int mJustificationMode;
        Paint.FontMetricsInt mFontMetricsInt;
        MeasuredText mMeasuredText;
        LocaleList mLocales;
        private static Pools.SynchronizedPool<Builder> sPool;

        private void $$robo$$android_text_StaticLayout_Builder$__constructor__() {
            this.mFontMetricsInt = new Paint.FontMetricsInt();
            this.mNativePtr = StaticLayout.nNewBuilder();
        }

        private static final Builder $$robo$$android_text_StaticLayout_Builder$obtain(CharSequence source, int start, int end, TextPaint paint, int width) {
            Builder b = sPool.acquire();
            if (b == null) {
                b = new Builder();
            }
            b.mText = source;
            b.mStart = start;
            b.mEnd = end;
            b.mPaint = paint;
            b.mWidth = width;
            b.mAlignment = Layout.Alignment.ALIGN_NORMAL;
            b.mTextDir = TextDirectionHeuristics.FIRSTSTRONG_LTR;
            b.mSpacingMult = 1.0f;
            b.mSpacingAdd = 0.0f;
            b.mIncludePad = true;
            b.mEllipsizedWidth = width;
            b.mEllipsize = null;
            b.mMaxLines = Integer.MAX_VALUE;
            b.mBreakStrategy = 0;
            b.mHyphenationFrequency = 0;
            b.mJustificationMode = 0;
            b.mMeasuredText = MeasuredText.obtain();
            return b;
        }

        private static final void $$robo$$android_text_StaticLayout_Builder$recycle(Builder b) {
            b.mPaint = null;
            b.mText = null;
            MeasuredText.recycle(b.mMeasuredText);
            b.mMeasuredText = null;
            b.mLeftIndents = null;
            b.mRightIndents = null;
            StaticLayout.nFinishBuilder(b.mNativePtr);
            sPool.release(b);
        }

        private final void $$robo$$android_text_StaticLayout_Builder$finish() {
            StaticLayout.nFinishBuilder(this.mNativePtr);
            this.mText = null;
            this.mPaint = null;
            this.mLeftIndents = null;
            this.mRightIndents = null;
            this.mMeasuredText.finish();
        }

        private final Builder $$robo$$android_text_StaticLayout_Builder$setText(CharSequence source) {
            return this.setText(source, 0, source.length());
        }

        private final Builder $$robo$$android_text_StaticLayout_Builder$setText(CharSequence source, int start, int end) {
            this.mText = source;
            this.mStart = start;
            this.mEnd = end;
            return this;
        }

        private final Builder $$robo$$android_text_StaticLayout_Builder$setPaint(TextPaint paint) {
            this.mPaint = paint;
            return this;
        }

        private final Builder $$robo$$android_text_StaticLayout_Builder$setWidth(int width) {
            this.mWidth = width;
            if (this.mEllipsize == null) {
                this.mEllipsizedWidth = width;
            }
            return this;
        }

        private final Builder $$robo$$android_text_StaticLayout_Builder$setAlignment(Layout.Alignment alignment) {
            this.mAlignment = alignment;
            return this;
        }

        private final Builder $$robo$$android_text_StaticLayout_Builder$setTextDirection(TextDirectionHeuristic textDir) {
            this.mTextDir = textDir;
            return this;
        }

        private final Builder $$robo$$android_text_StaticLayout_Builder$setLineSpacing(float spacingAdd, float spacingMult) {
            this.mSpacingAdd = spacingAdd;
            this.mSpacingMult = spacingMult;
            return this;
        }

        private final Builder $$robo$$android_text_StaticLayout_Builder$setIncludePad(boolean includePad) {
            this.mIncludePad = includePad;
            return this;
        }

        private final Builder $$robo$$android_text_StaticLayout_Builder$setEllipsizedWidth(int ellipsizedWidth) {
            this.mEllipsizedWidth = ellipsizedWidth;
            return this;
        }

        private final Builder $$robo$$android_text_StaticLayout_Builder$setEllipsize(TextUtils.TruncateAt ellipsize) {
            this.mEllipsize = ellipsize;
            return this;
        }

        private final Builder $$robo$$android_text_StaticLayout_Builder$setMaxLines(int maxLines) {
            this.mMaxLines = maxLines;
            return this;
        }

        private final Builder $$robo$$android_text_StaticLayout_Builder$setBreakStrategy(int breakStrategy) {
            this.mBreakStrategy = breakStrategy;
            return this;
        }

        private final Builder $$robo$$android_text_StaticLayout_Builder$setHyphenationFrequency(int hyphenationFrequency) {
            this.mHyphenationFrequency = hyphenationFrequency;
            return this;
        }

        private final Builder $$robo$$android_text_StaticLayout_Builder$setIndents(int[] leftIndents, int[] rightIndents) {
            this.mLeftIndents = leftIndents;
            this.mRightIndents = rightIndents;
            int leftLen = leftIndents == null ? 0 : leftIndents.length;
            int rightLen = rightIndents == null ? 0 : rightIndents.length;
            int[] indents = new int[Math.max(leftLen, rightLen)];
            for (int i = 0; i < indents.length; ++i) {
                int leftMargin = i < leftLen ? leftIndents[i] : 0;
                int rightMargin = i < rightLen ? rightIndents[i] : 0;
                indents[i] = leftMargin + rightMargin;
            }
            StaticLayout.nSetIndents(this.mNativePtr, indents);
            return this;
        }

        private final Builder $$robo$$android_text_StaticLayout_Builder$setJustificationMode(int justificationMode) {
            this.mJustificationMode = justificationMode;
            return this;
        }

        private final long[] $$robo$$android_text_StaticLayout_Builder$getHyphenators(LocaleList locales) {
            int length = locales.size();
            long[] result = new long[length];
            for (int i = 0; i < length; ++i) {
                Locale locale = locales.get(i);
                result[i] = Hyphenator.get(locale).getNativePtr();
            }
            return result;
        }

        private final void $$robo$$android_text_StaticLayout_Builder$setLocales(LocaleList locales) {
            if (!locales.equals(this.mLocales)) {
                StaticLayout.nSetLocales(this.mNativePtr, locales.toLanguageTags(), this.getHyphenators(locales));
                this.mLocales = locales;
            }
        }

        private final float $$robo$$android_text_StaticLayout_Builder$addStyleRun(TextPaint paint, int start, int end, boolean isRtl) {
            this.setLocales(paint.getTextLocales());
            return StaticLayout.nAddStyleRun(this.mNativePtr, paint.getNativeInstance(), paint.mNativeTypeface, start, end, isRtl);
        }

        private final void $$robo$$android_text_StaticLayout_Builder$addMeasuredRun(int start, int end, float[] widths) {
            StaticLayout.nAddMeasuredRun(this.mNativePtr, start, end, widths);
        }

        private final void $$robo$$android_text_StaticLayout_Builder$addReplacementRun(int start, int end, float width) {
            StaticLayout.nAddReplacementRun(this.mNativePtr, start, end, width);
        }

        private final StaticLayout $$robo$$android_text_StaticLayout_Builder$build() {
            StaticLayout result = new StaticLayout(this);
            Builder.recycle(this);
            return result;
        }

        private final void $$robo$$android_text_StaticLayout_Builder$finalize() throws Throwable {
            try {
                StaticLayout.nFreeBuilder(this.mNativePtr);
            }
            finally {
                super.finalize();
            }
        }

        static void __staticInitializer__() {
            sPool = new Pools.SynchronizedPool(3);
        }

        private void __constructor__() {
            this.$$robo$$android_text_StaticLayout_Builder$__constructor__();
        }

        private Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_StaticLayout_Builder$__constructor__(), 0, this);
        }

        public static Builder obtain(CharSequence charSequence, int n, int n2, TextPaint textPaint, int n3) {
            return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_text_StaticLayout_Builder$obtain(java.lang.CharSequence int int android.text.TextPaint int ), 0, (CharSequence)charSequence, (int)n, (int)n2, (TextPaint)textPaint, (int)n3);
        }

        private static void recycle(Builder builder) {
            InvokeDynamicSupport.bootstrapStatic("recycle", $$robo$$android_text_StaticLayout_Builder$recycle(android.text.StaticLayout$Builder ), 0, (Builder)builder);
        }

        void finish() {
            InvokeDynamicSupport.bootstrap("finish", $$robo$$android_text_StaticLayout_Builder$finish(), 0, this);
        }

        public Builder setText(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setText", $$robo$$android_text_StaticLayout_Builder$setText(java.lang.CharSequence ), 0, this, charSequence);
        }

        public Builder setText(CharSequence charSequence, int n, int n2) {
            return InvokeDynamicSupport.bootstrap("setText", $$robo$$android_text_StaticLayout_Builder$setText(java.lang.CharSequence int int ), 0, this, charSequence, n, n2);
        }

        public Builder setPaint(TextPaint textPaint) {
            return InvokeDynamicSupport.bootstrap("setPaint", $$robo$$android_text_StaticLayout_Builder$setPaint(android.text.TextPaint ), 0, this, textPaint);
        }

        public Builder setWidth(int n) {
            return InvokeDynamicSupport.bootstrap("setWidth", $$robo$$android_text_StaticLayout_Builder$setWidth(int ), 0, this, n);
        }

        public Builder setAlignment(Layout.Alignment alignment) {
            return InvokeDynamicSupport.bootstrap("setAlignment", $$robo$$android_text_StaticLayout_Builder$setAlignment(android.text.Layout$Alignment ), 0, this, alignment);
        }

        public Builder setTextDirection(TextDirectionHeuristic textDirectionHeuristic) {
            return InvokeDynamicSupport.bootstrap("setTextDirection", $$robo$$android_text_StaticLayout_Builder$setTextDirection(android.text.TextDirectionHeuristic ), 0, this, textDirectionHeuristic);
        }

        public Builder setLineSpacing(float f, float f2) {
            return InvokeDynamicSupport.bootstrap("setLineSpacing", $$robo$$android_text_StaticLayout_Builder$setLineSpacing(float float ), 0, this, f, f2);
        }

        public Builder setIncludePad(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setIncludePad", $$robo$$android_text_StaticLayout_Builder$setIncludePad(boolean ), 0, this, bl);
        }

        public Builder setEllipsizedWidth(int n) {
            return InvokeDynamicSupport.bootstrap("setEllipsizedWidth", $$robo$$android_text_StaticLayout_Builder$setEllipsizedWidth(int ), 0, this, n);
        }

        public Builder setEllipsize(TextUtils.TruncateAt truncateAt) {
            return InvokeDynamicSupport.bootstrap("setEllipsize", $$robo$$android_text_StaticLayout_Builder$setEllipsize(android.text.TextUtils$TruncateAt ), 0, this, truncateAt);
        }

        public Builder setMaxLines(int n) {
            return InvokeDynamicSupport.bootstrap("setMaxLines", $$robo$$android_text_StaticLayout_Builder$setMaxLines(int ), 0, this, n);
        }

        public Builder setBreakStrategy(int n) {
            return InvokeDynamicSupport.bootstrap("setBreakStrategy", $$robo$$android_text_StaticLayout_Builder$setBreakStrategy(int ), 0, this, n);
        }

        public Builder setHyphenationFrequency(int n) {
            return InvokeDynamicSupport.bootstrap("setHyphenationFrequency", $$robo$$android_text_StaticLayout_Builder$setHyphenationFrequency(int ), 0, this, n);
        }

        public Builder setIndents(int[] nArray, int[] nArray2) {
            return InvokeDynamicSupport.bootstrap("setIndents", $$robo$$android_text_StaticLayout_Builder$setIndents(int[] int[] ), 0, this, nArray, nArray2);
        }

        public Builder setJustificationMode(int n) {
            return InvokeDynamicSupport.bootstrap("setJustificationMode", $$robo$$android_text_StaticLayout_Builder$setJustificationMode(int ), 0, this, n);
        }

        private long[] getHyphenators(LocaleList localeList) {
            return InvokeDynamicSupport.bootstrap("getHyphenators", $$robo$$android_text_StaticLayout_Builder$getHyphenators(android.os.LocaleList ), 0, this, localeList);
        }

        private void setLocales(LocaleList localeList) {
            InvokeDynamicSupport.bootstrap("setLocales", $$robo$$android_text_StaticLayout_Builder$setLocales(android.os.LocaleList ), 0, this, localeList);
        }

        float addStyleRun(TextPaint textPaint, int n, int n2, boolean bl) {
            return (float)InvokeDynamicSupport.bootstrap("addStyleRun", $$robo$$android_text_StaticLayout_Builder$addStyleRun(android.text.TextPaint int int boolean ), 0, this, textPaint, n, n2, bl);
        }

        void addMeasuredRun(int n, int n2, float[] fArray) {
            InvokeDynamicSupport.bootstrap("addMeasuredRun", $$robo$$android_text_StaticLayout_Builder$addMeasuredRun(int int float[] ), 0, this, n, n2, fArray);
        }

        void addReplacementRun(int n, int n2, float f) {
            InvokeDynamicSupport.bootstrap("addReplacementRun", $$robo$$android_text_StaticLayout_Builder$addReplacementRun(int int float ), 0, this, n, n2, f);
        }

        public StaticLayout build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_text_StaticLayout_Builder$build(), 0, this);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_text_StaticLayout_Builder$finalize(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(Builder.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

