/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.content.Context;
import android.content.res.Resources;
import android.icu.text.DecimalFormat;
import android.icu.text.MeasureFormat;
import android.icu.text.NumberFormat;
import android.icu.text.UnicodeSet;
import android.icu.text.UnicodeSetSpanner;
import android.icu.util.Measure;
import android.icu.util.MeasureUnit;
import android.net.NetworkUtils;
import android.text.BidiFormatter;
import android.text.TextUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.reflect.Constructor;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class Formatter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int FLAG_DEFAULT = 0;
    public static int FLAG_SHORTER = 1;
    public static int FLAG_CALCULATE_ROUNDED = 2;
    private static UnicodeSetSpanner SPACES_AND_CONTROLS;
    private static MeasureUnit PETABYTE;
    private static int SECONDS_PER_MINUTE = 60;
    private static int SECONDS_PER_HOUR = 3600;
    private static int SECONDS_PER_DAY = 86400;
    private static int MILLIS_PER_MINUTE = 60000;

    private void $$robo$$android_text_format_Formatter$__constructor__() {
    }

    private static final Locale $$robo$$android_text_format_Formatter$localeFromContext(Context context) {
        return context.getResources().getConfiguration().getLocales().get(0);
    }

    private static final String $$robo$$android_text_format_Formatter$bidiWrap(Context context, String source) {
        Locale locale = Formatter.localeFromContext(context);
        if (TextUtils.getLayoutDirectionFromLocale(locale) == 1) {
            return BidiFormatter.getInstance(true).unicodeWrap(source);
        }
        return source;
    }

    private static final String $$robo$$android_text_format_Formatter$formatFileSize(Context context, long sizeBytes) {
        return Formatter.formatFileSize(context, sizeBytes, 0);
    }

    private static final String $$robo$$android_text_format_Formatter$formatShortFileSize(Context context, long sizeBytes) {
        return Formatter.formatFileSize(context, sizeBytes, 1);
    }

    private static final String $$robo$$android_text_format_Formatter$formatFileSize(Context context, long sizeBytes, int flags) {
        if (context == null) {
            return "";
        }
        RoundedBytesResult res = RoundedBytesResult.roundBytes(sizeBytes, flags);
        return Formatter.bidiWrap(context, Formatter.formatRoundedBytesResult(context, res));
    }

    private static final String $$robo$$android_text_format_Formatter$getSuffixOverride(Resources res, MeasureUnit unit) {
        if (unit == MeasureUnit.BYTE) {
            return res.getString(17039581);
        }
        return res.getString(17040581);
    }

    private static final NumberFormat $$robo$$android_text_format_Formatter$getNumberFormatter(Locale locale, int fractionDigits) {
        NumberFormat numberFormatter = NumberFormat.getInstance(locale);
        numberFormatter.setMinimumFractionDigits(fractionDigits);
        numberFormatter.setMaximumFractionDigits(fractionDigits);
        numberFormatter.setGroupingUsed(false);
        if (numberFormatter instanceof DecimalFormat) {
            numberFormatter.setRoundingMode(4);
        }
        return numberFormatter;
    }

    private static final String $$robo$$android_text_format_Formatter$deleteFirstFromString(String source, String toDelete) {
        int location = source.indexOf(toDelete);
        if (location == -1) {
            return source;
        }
        return source.substring(0, location) + source.substring(location + toDelete.length(), source.length());
    }

    private static final String $$robo$$android_text_format_Formatter$formatMeasureShort(Locale locale, NumberFormat numberFormatter, float value, MeasureUnit units) {
        MeasureFormat measureFormatter = MeasureFormat.getInstance(locale, MeasureFormat.FormatWidth.SHORT, numberFormatter);
        return measureFormatter.format(new Measure(Float.valueOf(value), units));
    }

    private static final String $$robo$$android_text_format_Formatter$formatRoundedBytesResult(Context context, RoundedBytesResult input) {
        Locale locale = Formatter.localeFromContext(context);
        NumberFormat numberFormatter = Formatter.getNumberFormatter(locale, input.fractionDigits);
        if (input.units == MeasureUnit.BYTE || input.units == PETABYTE) {
            String formattedNumber = numberFormatter.format(input.value);
            return context.getString(17039857, formattedNumber, Formatter.getSuffixOverride(context.getResources(), input.units));
        }
        return Formatter.formatMeasureShort(locale, numberFormatter, input.value, input.units);
    }

    private static final BytesResult $$robo$$android_text_format_Formatter$formatBytes(Resources res, long sizeBytes, int flags) {
        String units;
        RoundedBytesResult rounded = RoundedBytesResult.roundBytes(sizeBytes, flags);
        Locale locale = res.getConfiguration().getLocales().get(0);
        NumberFormat numberFormatter = Formatter.getNumberFormatter(locale, rounded.fractionDigits);
        String formattedNumber = numberFormatter.format(rounded.value);
        if (rounded.units == MeasureUnit.BYTE || rounded.units == PETABYTE) {
            units = Formatter.getSuffixOverride(res, rounded.units);
        } else {
            String formattedMeasure = Formatter.formatMeasureShort(locale, numberFormatter, rounded.value, rounded.units);
            String numberRemoved = Formatter.deleteFirstFromString(formattedMeasure, formattedNumber);
            units = SPACES_AND_CONTROLS.trim(numberRemoved).toString();
        }
        return new BytesResult(formattedNumber, units, rounded.roundedBytes);
    }

    private static final MeasureUnit $$robo$$android_text_format_Formatter$createPetaByte() {
        try {
            Constructor constructor = MeasureUnit.class.getDeclaredConstructor(String.class, String.class);
            constructor.setAccessible(true);
            return (MeasureUnit)constructor.newInstance("digital", "petabyte");
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to create petabyte MeasureUnit", e);
        }
    }

    @Deprecated
    private static final String $$robo$$android_text_format_Formatter$formatIpAddress(int ipv4Address) {
        return NetworkUtils.intToInetAddress(ipv4Address).getHostAddress();
    }

    private static final String $$robo$$android_text_format_Formatter$formatShortElapsedTime(Context context, long millis) {
        long secondsLong = millis / 1000L;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        if (secondsLong >= 86400L) {
            days = (int)(secondsLong / 86400L);
            secondsLong -= (long)(days * 86400);
        }
        if (secondsLong >= 3600L) {
            hours = (int)(secondsLong / 3600L);
            secondsLong -= (long)(hours * 3600);
        }
        if (secondsLong >= 60L) {
            minutes = (int)(secondsLong / 60L);
            secondsLong -= (long)(minutes * 60);
        }
        int seconds = (int)secondsLong;
        Locale locale = Formatter.localeFromContext(context);
        MeasureFormat measureFormat = MeasureFormat.getInstance(locale, MeasureFormat.FormatWidth.SHORT);
        if (days >= 2) {
            return measureFormat.format(new Measure(days += (hours + 12) / 24, MeasureUnit.DAY));
        }
        if (days > 0) {
            return measureFormat.formatMeasures(new Measure(days, MeasureUnit.DAY), new Measure(hours, MeasureUnit.HOUR));
        }
        if (hours >= 2) {
            return measureFormat.format(new Measure(hours += (minutes + 30) / 60, MeasureUnit.HOUR));
        }
        if (hours > 0) {
            return measureFormat.formatMeasures(new Measure(hours, MeasureUnit.HOUR), new Measure(minutes, MeasureUnit.MINUTE));
        }
        if (minutes >= 2) {
            return measureFormat.format(new Measure(minutes += (seconds + 30) / 60, MeasureUnit.MINUTE));
        }
        if (minutes > 0) {
            return measureFormat.formatMeasures(new Measure(minutes, MeasureUnit.MINUTE), new Measure(seconds, MeasureUnit.SECOND));
        }
        return measureFormat.format(new Measure(seconds, MeasureUnit.SECOND));
    }

    private static final String $$robo$$android_text_format_Formatter$formatShortElapsedTimeRoundingUpToMinutes(Context context, long millis) {
        long minutesRoundedUp = (millis + 60000L - 1L) / 60000L;
        if (minutesRoundedUp == 0L || minutesRoundedUp == 1L) {
            Locale locale = Formatter.localeFromContext(context);
            MeasureFormat measureFormat = MeasureFormat.getInstance(locale, MeasureFormat.FormatWidth.SHORT);
            return measureFormat.format(new Measure(minutesRoundedUp, MeasureUnit.MINUTE));
        }
        return Formatter.formatShortElapsedTime(context, minutesRoundedUp * 60000L);
    }

    static void __staticInitializer__() {
        SPACES_AND_CONTROLS = new UnicodeSetSpanner((UnicodeSet)new UnicodeSet("[[:Zs:][:Cf:]]").freeze());
        PETABYTE = Formatter.createPetaByte();
    }

    private void __constructor__() {
        this.$$robo$$android_text_format_Formatter$__constructor__();
    }

    public Formatter() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_format_Formatter$__constructor__(), 0, this);
    }

    private static Locale localeFromContext(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("localeFromContext", $$robo$$android_text_format_Formatter$localeFromContext(android.content.Context ), 0, (Context)context);
    }

    private static String bidiWrap(Context context, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("bidiWrap", $$robo$$android_text_format_Formatter$bidiWrap(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    public static String formatFileSize(Context context, long l) {
        return InvokeDynamicSupport.bootstrapStatic("formatFileSize", $$robo$$android_text_format_Formatter$formatFileSize(android.content.Context long ), 0, (Context)context, (long)l);
    }

    public static String formatShortFileSize(Context context, long l) {
        return InvokeDynamicSupport.bootstrapStatic("formatShortFileSize", $$robo$$android_text_format_Formatter$formatShortFileSize(android.content.Context long ), 0, (Context)context, (long)l);
    }

    private static String formatFileSize(Context context, long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("formatFileSize", $$robo$$android_text_format_Formatter$formatFileSize(android.content.Context long int ), 0, (Context)context, (long)l, (int)n);
    }

    private static String getSuffixOverride(Resources resources, MeasureUnit measureUnit) {
        return InvokeDynamicSupport.bootstrapStatic("getSuffixOverride", $$robo$$android_text_format_Formatter$getSuffixOverride(android.content.res.Resources android.icu.util.MeasureUnit ), 0, (Resources)resources, (MeasureUnit)measureUnit);
    }

    private static NumberFormat getNumberFormatter(Locale locale, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getNumberFormatter", $$robo$$android_text_format_Formatter$getNumberFormatter(java.util.Locale int ), 0, (Locale)locale, (int)n);
    }

    private static String deleteFirstFromString(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("deleteFirstFromString", $$robo$$android_text_format_Formatter$deleteFirstFromString(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    private static String formatMeasureShort(Locale locale, NumberFormat numberFormat, float f, MeasureUnit measureUnit) {
        return InvokeDynamicSupport.bootstrapStatic("formatMeasureShort", $$robo$$android_text_format_Formatter$formatMeasureShort(java.util.Locale android.icu.text.NumberFormat float android.icu.util.MeasureUnit ), 0, (Locale)locale, (NumberFormat)numberFormat, (float)f, (MeasureUnit)measureUnit);
    }

    private static String formatRoundedBytesResult(Context context, RoundedBytesResult roundedBytesResult) {
        return InvokeDynamicSupport.bootstrapStatic("formatRoundedBytesResult", $$robo$$android_text_format_Formatter$formatRoundedBytesResult(android.content.Context android.text.format.Formatter$RoundedBytesResult ), 0, (Context)context, (RoundedBytesResult)roundedBytesResult);
    }

    public static BytesResult formatBytes(Resources resources, long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("formatBytes", $$robo$$android_text_format_Formatter$formatBytes(android.content.res.Resources long int ), 0, (Resources)resources, (long)l, (int)n);
    }

    private static MeasureUnit createPetaByte() {
        return InvokeDynamicSupport.bootstrapStatic("createPetaByte", $$robo$$android_text_format_Formatter$createPetaByte(), 0);
    }

    @Deprecated
    public static String formatIpAddress(int n) {
        return InvokeDynamicSupport.bootstrapStatic("formatIpAddress", $$robo$$android_text_format_Formatter$formatIpAddress(int ), 0, (int)n);
    }

    public static String formatShortElapsedTime(Context context, long l) {
        return InvokeDynamicSupport.bootstrapStatic("formatShortElapsedTime", $$robo$$android_text_format_Formatter$formatShortElapsedTime(android.content.Context long ), 0, (Context)context, (long)l);
    }

    public static String formatShortElapsedTimeRoundingUpToMinutes(Context context, long l) {
        return InvokeDynamicSupport.bootstrapStatic("formatShortElapsedTimeRoundingUpToMinutes", $$robo$$android_text_format_Formatter$formatShortElapsedTimeRoundingUpToMinutes(android.content.Context long ), 0, (Context)context, (long)l);
    }

    static {
        RobolectricInternals.classInitializing(Formatter.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Formatter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class RoundedBytesResult
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public float value;
        public MeasureUnit units;
        public int fractionDigits;
        public long roundedBytes;

        private void $$robo$$android_text_format_Formatter_RoundedBytesResult$__constructor__(float value, MeasureUnit units, int fractionDigits, long roundedBytes) {
            this.value = value;
            this.units = units;
            this.fractionDigits = fractionDigits;
            this.roundedBytes = roundedBytes;
        }

        private static final RoundedBytesResult $$robo$$android_text_format_Formatter_RoundedBytesResult$roundBytes(long sizeBytes, int flags) {
            int roundDigits;
            int roundFactor;
            boolean isNegative = sizeBytes < 0L;
            float result = isNegative ? (float)(-sizeBytes) : (float)sizeBytes;
            MeasureUnit units = MeasureUnit.BYTE;
            long mult = 1L;
            if (result > 900.0f) {
                units = MeasureUnit.KILOBYTE;
                mult = 1000L;
                result /= 1000.0f;
            }
            if (result > 900.0f) {
                units = MeasureUnit.MEGABYTE;
                mult *= 1000L;
                result /= 1000.0f;
            }
            if (result > 900.0f) {
                units = MeasureUnit.GIGABYTE;
                mult *= 1000L;
                result /= 1000.0f;
            }
            if (result > 900.0f) {
                units = MeasureUnit.TERABYTE;
                mult *= 1000L;
                result /= 1000.0f;
            }
            if (result > 900.0f) {
                units = PETABYTE;
                mult *= 1000L;
                result /= 1000.0f;
            }
            if (mult == 1L || result >= 100.0f) {
                roundFactor = 1;
                roundDigits = 0;
            } else if (result < 1.0f) {
                roundFactor = 100;
                roundDigits = 2;
            } else if (result < 10.0f) {
                if ((flags & 1) != 0) {
                    roundFactor = 10;
                    roundDigits = 1;
                } else {
                    roundFactor = 100;
                    roundDigits = 2;
                }
            } else if ((flags & 1) != 0) {
                roundFactor = 1;
                roundDigits = 0;
            } else {
                roundFactor = 100;
                roundDigits = 2;
            }
            if (isNegative) {
                result = -result;
            }
            long roundedBytes = (flags & 2) == 0 ? 0L : (long)Math.round(result * (float)roundFactor) * mult / (long)roundFactor;
            return new RoundedBytesResult(result, units, roundDigits, roundedBytes);
        }

        private void __constructor__(float f, MeasureUnit measureUnit, int n, long l) {
            this.$$robo$$android_text_format_Formatter_RoundedBytesResult$__constructor__(f, measureUnit, n, l);
        }

        private RoundedBytesResult(float f, MeasureUnit measureUnit, int n, long l) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_format_Formatter_RoundedBytesResult$__constructor__(float android.icu.util.MeasureUnit int long ), 0, this, f, measureUnit, n, l);
        }

        static RoundedBytesResult roundBytes(long l, int n) {
            return InvokeDynamicSupport.bootstrapStatic("roundBytes", $$robo$$android_text_format_Formatter_RoundedBytesResult$roundBytes(long int ), 0, (long)l, (int)n);
        }

        public /* synthetic */ RoundedBytesResult() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RoundedBytesResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class BytesResult
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String value;
        public String units;
        public long roundedBytes;

        private void $$robo$$android_text_format_Formatter_BytesResult$__constructor__(String value, String units, long roundedBytes) {
            this.value = value;
            this.units = units;
            this.roundedBytes = roundedBytes;
        }

        private void __constructor__(String string2, String string3, long l) {
            this.$$robo$$android_text_format_Formatter_BytesResult$__constructor__(string2, string3, l);
        }

        public BytesResult(String string2, String string3, long l) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_format_Formatter_BytesResult$__constructor__(java.lang.String java.lang.String long ), 0, this, string2, string3, l);
        }

        public /* synthetic */ BytesResult() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BytesResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

