/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.icu.lang.UCharacter;
import android.icu.text.DecimalFormatSymbols;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.method.NumberKeyListener;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.ArrayUtils;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DigitsKeyListener
extends NumberKeyListener
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private char[] mAccepted;
    private boolean mNeedsAdvancedInput;
    private boolean mSign;
    private boolean mDecimal;
    private boolean mStringMode;
    private Locale mLocale;
    private static String DEFAULT_DECIMAL_POINT_CHARS = ".";
    private static String DEFAULT_SIGN_CHARS = "-+";
    private static char HYPHEN_MINUS = '-';
    private static char MINUS_SIGN = '\u2212';
    private static char EN_DASH = '\u2013';
    private String mDecimalPointChars;
    private String mSignChars;
    private static int SIGN = 1;
    private static int DECIMAL = 2;
    private static char[][] COMPATIBILITY_CHARACTERS;
    private static Object sLocaleCacheLock;
    @GuardedBy(value="sLocaleCacheLock")
    private static HashMap<Locale, DigitsKeyListener[]> sLocaleInstanceCache;
    private static Object sStringCacheLock;
    @GuardedBy(value="sStringCacheLock")
    private static HashMap<String, DigitsKeyListener> sStringInstanceCache;

    private final char[] $$robo$$android_text_method_DigitsKeyListener$getAcceptedChars() {
        return this.mAccepted;
    }

    private final boolean $$robo$$android_text_method_DigitsKeyListener$isSignChar(char c) {
        return this.mSignChars.indexOf(c) != -1;
    }

    private final boolean $$robo$$android_text_method_DigitsKeyListener$isDecimalPointChar(char c) {
        return this.mDecimalPointChars.indexOf(c) != -1;
    }

    @Deprecated
    private void $$robo$$android_text_method_DigitsKeyListener$__constructor__() {
    }

    @Deprecated
    private void $$robo$$android_text_method_DigitsKeyListener$__constructor__(boolean sign, boolean decimal) {
    }

    private void $$robo$$android_text_method_DigitsKeyListener$__constructor__(Locale locale) {
    }

    private final void $$robo$$android_text_method_DigitsKeyListener$setToCompat() {
        this.mDecimalPointChars = ".";
        this.mSignChars = "-+";
        int kind = (this.mSign ? 1 : 0) | (this.mDecimal ? 2 : 0);
        this.mAccepted = COMPATIBILITY_CHARACTERS[kind];
        this.mNeedsAdvancedInput = false;
    }

    private final void $$robo$$android_text_method_DigitsKeyListener$calculateNeedForAdvancedInput() {
        int kind = (this.mSign ? 1 : 0) | (this.mDecimal ? 2 : 0);
        this.mNeedsAdvancedInput = !ArrayUtils.containsAll(COMPATIBILITY_CHARACTERS[kind], this.mAccepted);
    }

    private static final String $$robo$$android_text_method_DigitsKeyListener$stripBidiControls(String sign) {
        String result = "";
        for (int i = 0; i < sign.length(); ++i) {
            char c = sign.charAt(i);
            if (UCharacter.hasBinaryProperty(c, 2)) continue;
            result = result.isEmpty() ? String.valueOf(c) : result + c;
        }
        return result;
    }

    private void $$robo$$android_text_method_DigitsKeyListener$__constructor__(Locale locale, boolean sign, boolean decimal) {
        this.mDecimalPointChars = ".";
        this.mSignChars = "-+";
        this.mSign = sign;
        this.mDecimal = decimal;
        this.mStringMode = false;
        this.mLocale = locale;
        if (locale == null) {
            this.setToCompat();
            return;
        }
        LinkedHashSet<Character> chars = new LinkedHashSet<Character>();
        boolean success = NumberKeyListener.addDigits(chars, locale);
        if (!success) {
            this.setToCompat();
            return;
        }
        if (sign || decimal) {
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            if (sign) {
                String minusString = DigitsKeyListener.stripBidiControls(symbols.getMinusSignString());
                String plusString = DigitsKeyListener.stripBidiControls(symbols.getPlusSignString());
                if (minusString.length() > 1 || plusString.length() > 1) {
                    this.setToCompat();
                    return;
                }
                char minus = minusString.charAt(0);
                char plus = plusString.charAt(0);
                chars.add(Character.valueOf(minus));
                chars.add(Character.valueOf(plus));
                this.mSignChars = "" + minus + plus;
                if (minus == '\u2212' || minus == '\u2013') {
                    chars.add(Character.valueOf('-'));
                    this.mSignChars = this.mSignChars + '-';
                }
            }
            if (decimal) {
                String separatorString = symbols.getDecimalSeparatorString();
                if (separatorString.length() > 1) {
                    this.setToCompat();
                    return;
                }
                Character separatorChar = Character.valueOf(separatorString.charAt(0));
                chars.add(separatorChar);
                this.mDecimalPointChars = separatorChar.toString();
            }
        }
        this.mAccepted = NumberKeyListener.collectionToArray(chars);
        this.calculateNeedForAdvancedInput();
    }

    private void $$robo$$android_text_method_DigitsKeyListener$__constructor__(String accepted) {
        this.mDecimalPointChars = ".";
        this.mSignChars = "-+";
        this.mSign = false;
        this.mDecimal = false;
        this.mStringMode = true;
        this.mLocale = null;
        this.mAccepted = new char[accepted.length()];
        accepted.getChars(0, accepted.length(), this.mAccepted, 0);
        this.mNeedsAdvancedInput = false;
    }

    @Deprecated
    private static final DigitsKeyListener $$robo$$android_text_method_DigitsKeyListener$getInstance() {
        return DigitsKeyListener.getInstance(false, false);
    }

    @Deprecated
    private static final DigitsKeyListener $$robo$$android_text_method_DigitsKeyListener$getInstance(boolean sign, boolean decimal) {
        return DigitsKeyListener.getInstance(null, sign, decimal);
    }

    private static final DigitsKeyListener $$robo$$android_text_method_DigitsKeyListener$getInstance(Locale locale) {
        return DigitsKeyListener.getInstance(locale, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final DigitsKeyListener $$robo$$android_text_method_DigitsKeyListener$getInstance(Locale locale, boolean sign, boolean decimal) {
        int kind = (sign ? 1 : 0) | (decimal ? 2 : 0);
        Object object = sLocaleCacheLock;
        synchronized (object) {
            DigitsKeyListener[] cachedValue = sLocaleInstanceCache.get(locale);
            if (cachedValue != null && cachedValue[kind] != null) {
                return cachedValue[kind];
            }
            if (cachedValue == null) {
                cachedValue = new DigitsKeyListener[4];
                sLocaleInstanceCache.put(locale, cachedValue);
            }
            cachedValue[kind] = new DigitsKeyListener(locale, sign, decimal);
            return cachedValue[kind];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final DigitsKeyListener $$robo$$android_text_method_DigitsKeyListener$getInstance(String accepted) {
        DigitsKeyListener result;
        Object object = sStringCacheLock;
        synchronized (object) {
            result = sStringInstanceCache.get(accepted);
            if (result == null) {
                result = new DigitsKeyListener(accepted);
                sStringInstanceCache.put(accepted, result);
            }
        }
        return result;
    }

    private static final DigitsKeyListener $$robo$$android_text_method_DigitsKeyListener$getInstance(Locale locale, DigitsKeyListener listener) {
        if (listener.mStringMode) {
            return listener;
        }
        return DigitsKeyListener.getInstance(locale, listener.mSign, listener.mDecimal);
    }

    private final int $$robo$$android_text_method_DigitsKeyListener$getInputType() {
        int contentType;
        if (this.mNeedsAdvancedInput) {
            contentType = 1;
        } else {
            contentType = 2;
            if (this.mSign) {
                contentType |= 0x1000;
            }
            if (this.mDecimal) {
                contentType |= 0x2000;
            }
        }
        return contentType;
    }

    private final CharSequence $$robo$$android_text_method_DigitsKeyListener$filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
        char c;
        int i;
        CharSequence out = super.filter(source, start, end, dest, dstart, dend);
        if (!this.mSign && !this.mDecimal) {
            return out;
        }
        if (out != null) {
            source = out;
            start = 0;
            end = out.length();
        }
        int sign = -1;
        int decimal = -1;
        int dlen = dest.length();
        for (i = 0; i < dstart; ++i) {
            c = dest.charAt(i);
            if (this.isSignChar(c)) {
                sign = i;
                continue;
            }
            if (!this.isDecimalPointChar(c)) continue;
            decimal = i;
        }
        for (i = dend; i < dlen; ++i) {
            c = dest.charAt(i);
            if (this.isSignChar(c)) {
                return "";
            }
            if (!this.isDecimalPointChar(c)) continue;
            decimal = i;
        }
        SpannableStringBuilder stripped = null;
        for (int i2 = end - 1; i2 >= start; --i2) {
            char c2 = source.charAt(i2);
            boolean strip = false;
            if (this.isSignChar(c2)) {
                if (i2 != start || dstart != 0) {
                    strip = true;
                } else if (sign >= 0) {
                    strip = true;
                } else {
                    sign = i2;
                }
            } else if (this.isDecimalPointChar(c2)) {
                if (decimal >= 0) {
                    strip = true;
                } else {
                    decimal = i2;
                }
            }
            if (!strip) continue;
            if (end == start + 1) {
                return "";
            }
            if (stripped == null) {
                stripped = new SpannableStringBuilder(source, start, end);
            }
            stripped.delete(i2 - start, i2 + 1 - start);
        }
        if (stripped != null) {
            return stripped;
        }
        if (out != null) {
            return out;
        }
        return null;
    }

    static void __staticInitializer__() {
        COMPATIBILITY_CHARACTERS = new char[][]{{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'}, {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '+'}, {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.'}, {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '+', '.'}};
        sLocaleCacheLock = new Object();
        sLocaleInstanceCache = new HashMap();
        sStringCacheLock = new Object();
        sStringInstanceCache = new HashMap();
    }

    @Override
    protected char[] getAcceptedChars() {
        return InvokeDynamicSupport.bootstrap("getAcceptedChars", $$robo$$android_text_method_DigitsKeyListener$getAcceptedChars(), 0, this);
    }

    private boolean isSignChar(char c) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSignChar", $$robo$$android_text_method_DigitsKeyListener$isSignChar(char ), 0, this, c);
    }

    private boolean isDecimalPointChar(char c) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDecimalPointChar", $$robo$$android_text_method_DigitsKeyListener$isDecimalPointChar(char ), 0, this, c);
    }

    private void __constructor__() {
        this.$$robo$$android_text_method_DigitsKeyListener$__constructor__();
    }

    public DigitsKeyListener() {
        this(null, false, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_method_DigitsKeyListener$__constructor__(), 0, this);
    }

    private void __constructor__(boolean bl, boolean bl2) {
        this.$$robo$$android_text_method_DigitsKeyListener$__constructor__(bl, bl2);
    }

    public DigitsKeyListener(boolean bl, boolean bl2) {
        this(null, bl, bl2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_method_DigitsKeyListener$__constructor__(boolean boolean ), 0, this, bl, bl2);
    }

    private void __constructor__(Locale locale) {
        this.$$robo$$android_text_method_DigitsKeyListener$__constructor__(locale);
    }

    public DigitsKeyListener(Locale locale) {
        this(locale, false, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_method_DigitsKeyListener$__constructor__(java.util.Locale ), 0, this, locale);
    }

    private void setToCompat() {
        InvokeDynamicSupport.bootstrap("setToCompat", $$robo$$android_text_method_DigitsKeyListener$setToCompat(), 0, this);
    }

    private void calculateNeedForAdvancedInput() {
        InvokeDynamicSupport.bootstrap("calculateNeedForAdvancedInput", $$robo$$android_text_method_DigitsKeyListener$calculateNeedForAdvancedInput(), 0, this);
    }

    private static String stripBidiControls(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("stripBidiControls", $$robo$$android_text_method_DigitsKeyListener$stripBidiControls(java.lang.String ), 0, (String)string2);
    }

    private void __constructor__(Locale locale, boolean bl, boolean bl2) {
        this.$$robo$$android_text_method_DigitsKeyListener$__constructor__(locale, bl, bl2);
    }

    public DigitsKeyListener(Locale locale, boolean bl, boolean bl2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_method_DigitsKeyListener$__constructor__(java.util.Locale boolean boolean ), 0, this, locale, bl, bl2);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_text_method_DigitsKeyListener$__constructor__(string2);
    }

    private DigitsKeyListener(String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_method_DigitsKeyListener$__constructor__(java.lang.String ), 0, this, string2);
    }

    @Deprecated
    public static DigitsKeyListener getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_text_method_DigitsKeyListener$getInstance(), 0);
    }

    @Deprecated
    public static DigitsKeyListener getInstance(boolean bl, boolean bl2) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_text_method_DigitsKeyListener$getInstance(boolean boolean ), 0, (boolean)bl, (boolean)bl2);
    }

    public static DigitsKeyListener getInstance(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_text_method_DigitsKeyListener$getInstance(java.util.Locale ), 0, (Locale)locale);
    }

    public static DigitsKeyListener getInstance(Locale locale, boolean bl, boolean bl2) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_text_method_DigitsKeyListener$getInstance(java.util.Locale boolean boolean ), 0, (Locale)locale, (boolean)bl, (boolean)bl2);
    }

    public static DigitsKeyListener getInstance(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_text_method_DigitsKeyListener$getInstance(java.lang.String ), 0, (String)string2);
    }

    public static DigitsKeyListener getInstance(Locale locale, DigitsKeyListener digitsKeyListener) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_text_method_DigitsKeyListener$getInstance(java.util.Locale android.text.method.DigitsKeyListener ), 0, (Locale)locale, (DigitsKeyListener)digitsKeyListener);
    }

    @Override
    public int getInputType() {
        return (int)InvokeDynamicSupport.bootstrap("getInputType", $$robo$$android_text_method_DigitsKeyListener$getInputType(), 0, this);
    }

    @Override
    public CharSequence filter(CharSequence charSequence, int n, int n2, Spanned spanned, int n3, int n4) {
        return InvokeDynamicSupport.bootstrap("filter", $$robo$$android_text_method_DigitsKeyListener$filter(java.lang.CharSequence int int android.text.Spanned int int ), 0, this, charSequence, n, n2, spanned, n3, n4);
    }

    static {
        RobolectricInternals.classInitializing(DigitsKeyListener.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DigitsKeyListener)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

