/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.graphics.Rect;
import android.transition.PathMotion;
import android.transition.TransitionPropagation;
import android.transition.TransitionSet;
import android.transition.TransitionValues;
import android.transition.TransitionValuesMaps;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.LongSparseArray;
import android.util.SparseArray;
import android.util.SparseLongArray;
import android.view.InflateException;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowId;
import android.view.animation.AnimationUtils;
import android.widget.ListView;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class Transition
implements Cloneable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "Transition";
    static boolean DBG = false;
    public static int MATCH_INSTANCE = 1;
    private static int MATCH_FIRST = 1;
    public static int MATCH_NAME = 2;
    public static int MATCH_ID = 3;
    public static int MATCH_ITEM_ID = 4;
    private static int MATCH_LAST = 4;
    private static String MATCH_INSTANCE_STR = "instance";
    private static String MATCH_NAME_STR = "name";
    private static String MATCH_VIEW_NAME_STR = "viewName";
    private static String MATCH_ID_STR = "id";
    private static String MATCH_ITEM_ID_STR = "itemId";
    private static int[] DEFAULT_MATCH_ORDER;
    private static PathMotion STRAIGHT_PATH_MOTION;
    private String mName;
    long mStartDelay;
    long mDuration;
    TimeInterpolator mInterpolator;
    ArrayList<Integer> mTargetIds;
    ArrayList<View> mTargets;
    ArrayList<String> mTargetNames;
    ArrayList<Class> mTargetTypes;
    ArrayList<Integer> mTargetIdExcludes;
    ArrayList<View> mTargetExcludes;
    ArrayList<Class> mTargetTypeExcludes;
    ArrayList<String> mTargetNameExcludes;
    ArrayList<Integer> mTargetIdChildExcludes;
    ArrayList<View> mTargetChildExcludes;
    ArrayList<Class> mTargetTypeChildExcludes;
    private TransitionValuesMaps mStartValues;
    private TransitionValuesMaps mEndValues;
    TransitionSet mParent;
    int[] mMatchOrder;
    ArrayList<TransitionValues> mStartValuesList;
    ArrayList<TransitionValues> mEndValuesList;
    private static ThreadLocal<ArrayMap<Animator, AnimationInfo>> sRunningAnimators;
    ViewGroup mSceneRoot;
    boolean mCanRemoveViews;
    private ArrayList<Animator> mCurrentAnimators;
    int mNumInstances;
    boolean mPaused;
    private boolean mEnded;
    ArrayList<TransitionListener> mListeners;
    ArrayList<Animator> mAnimators;
    TransitionPropagation mPropagation;
    EpicenterCallback mEpicenterCallback;
    ArrayMap<String, String> mNameOverrides;
    PathMotion mPathMotion;

    private void $$robo$$android_transition_Transition$__constructor__() {
        this.mName = this.getClass().getName();
        this.mStartDelay = -1L;
        this.mDuration = -1L;
        this.mInterpolator = null;
        this.mTargetIds = new ArrayList();
        this.mTargets = new ArrayList();
        this.mTargetNames = null;
        this.mTargetTypes = null;
        this.mTargetIdExcludes = null;
        this.mTargetExcludes = null;
        this.mTargetTypeExcludes = null;
        this.mTargetNameExcludes = null;
        this.mTargetIdChildExcludes = null;
        this.mTargetChildExcludes = null;
        this.mTargetTypeChildExcludes = null;
        this.mStartValues = new TransitionValuesMaps();
        this.mEndValues = new TransitionValuesMaps();
        this.mParent = null;
        this.mMatchOrder = DEFAULT_MATCH_ORDER;
        this.mSceneRoot = null;
        this.mCanRemoveViews = false;
        this.mCurrentAnimators = new ArrayList();
        this.mNumInstances = 0;
        this.mPaused = false;
        this.mEnded = false;
        this.mListeners = null;
        this.mAnimators = new ArrayList();
        this.mPathMotion = STRAIGHT_PATH_MOTION;
    }

    private void $$robo$$android_transition_Transition$__constructor__(Context context, AttributeSet attrs) {
        String matchOrder;
        int resID;
        long startDelay;
        this.mName = this.getClass().getName();
        this.mStartDelay = -1L;
        this.mDuration = -1L;
        this.mInterpolator = null;
        this.mTargetIds = new ArrayList();
        this.mTargets = new ArrayList();
        this.mTargetNames = null;
        this.mTargetTypes = null;
        this.mTargetIdExcludes = null;
        this.mTargetExcludes = null;
        this.mTargetTypeExcludes = null;
        this.mTargetNameExcludes = null;
        this.mTargetIdChildExcludes = null;
        this.mTargetChildExcludes = null;
        this.mTargetTypeChildExcludes = null;
        this.mStartValues = new TransitionValuesMaps();
        this.mEndValues = new TransitionValuesMaps();
        this.mParent = null;
        this.mMatchOrder = DEFAULT_MATCH_ORDER;
        this.mSceneRoot = null;
        this.mCanRemoveViews = false;
        this.mCurrentAnimators = new ArrayList();
        this.mNumInstances = 0;
        this.mPaused = false;
        this.mEnded = false;
        this.mListeners = null;
        this.mAnimators = new ArrayList();
        this.mPathMotion = STRAIGHT_PATH_MOTION;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Transition);
        long duration = a.getInt(1, -1);
        if (duration >= 0L) {
            this.setDuration(duration);
        }
        if ((startDelay = (long)a.getInt(2, -1)) > 0L) {
            this.setStartDelay(startDelay);
        }
        if ((resID = a.getResourceId(0, 0)) > 0) {
            this.setInterpolator(AnimationUtils.loadInterpolator(context, resID));
        }
        if ((matchOrder = a.getString(3)) != null) {
            this.setMatchOrder(Transition.parseMatchOrder(matchOrder));
        }
        a.recycle();
    }

    private static final int[] $$robo$$android_transition_Transition$parseMatchOrder(String matchOrderString) {
        StringTokenizer st = new StringTokenizer(matchOrderString, ",");
        int[] matches = new int[st.countTokens()];
        int index = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if ("id".equalsIgnoreCase(token)) {
                matches[index] = 3;
            } else if ("instance".equalsIgnoreCase(token)) {
                matches[index] = 1;
            } else if ("name".equalsIgnoreCase(token)) {
                matches[index] = 2;
            } else if ("viewName".equalsIgnoreCase(token)) {
                matches[index] = 2;
            } else if ("itemId".equalsIgnoreCase(token)) {
                matches[index] = 4;
            } else if (token.isEmpty()) {
                int[] smallerMatches = new int[matches.length - 1];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])matches, (int)0, (int[])smallerMatches, (int)0, (int)index);
                matches = smallerMatches;
                --index;
            } else {
                throw new InflateException("Unknown match type in matchOrder: '" + token + "'");
            }
            ++index;
        }
        return matches;
    }

    private final Transition $$robo$$android_transition_Transition$setDuration(long duration) {
        this.mDuration = duration;
        return this;
    }

    private final long $$robo$$android_transition_Transition$getDuration() {
        return this.mDuration;
    }

    private final Transition $$robo$$android_transition_Transition$setStartDelay(long startDelay) {
        this.mStartDelay = startDelay;
        return this;
    }

    private final long $$robo$$android_transition_Transition$getStartDelay() {
        return this.mStartDelay;
    }

    private final Transition $$robo$$android_transition_Transition$setInterpolator(TimeInterpolator interpolator2) {
        this.mInterpolator = interpolator2;
        return this;
    }

    private final TimeInterpolator $$robo$$android_transition_Transition$getInterpolator() {
        return this.mInterpolator;
    }

    private final String[] $$robo$$android_transition_Transition$getTransitionProperties() {
        return null;
    }

    private final Animator $$robo$$android_transition_Transition$createAnimator(ViewGroup sceneRoot, TransitionValues startValues, TransitionValues endValues) {
        return null;
    }

    private final void $$robo$$android_transition_Transition$setMatchOrder(int ... matches) {
        if (matches == null || matches.length == 0) {
            this.mMatchOrder = DEFAULT_MATCH_ORDER;
        } else {
            for (int i = 0; i < matches.length; ++i) {
                int match = matches[i];
                if (!Transition.isValidMatch(match)) {
                    throw new IllegalArgumentException("matches contains invalid value");
                }
                if (!Transition.alreadyContains(matches, i)) continue;
                throw new IllegalArgumentException("matches contains a duplicate value");
            }
            this.mMatchOrder = (int[])matches.clone();
        }
    }

    private static final boolean $$robo$$android_transition_Transition$isValidMatch(int match) {
        return match >= 1 && match <= 4;
    }

    private static final boolean $$robo$$android_transition_Transition$alreadyContains(int[] array2, int searchIndex) {
        int value = array2[searchIndex];
        for (int i = 0; i < searchIndex; ++i) {
            if (array2[i] != value) continue;
            return true;
        }
        return false;
    }

    private final void $$robo$$android_transition_Transition$matchInstances(ArrayMap<View, TransitionValues> unmatchedStart, ArrayMap<View, TransitionValues> unmatchedEnd) {
        for (int i = unmatchedStart.size() - 1; i >= 0; --i) {
            TransitionValues end;
            View view = unmatchedStart.keyAt(i);
            if (view == null || !this.isValidTarget(view) || (end = unmatchedEnd.remove(view)) == null || end.view == null || !this.isValidTarget(end.view)) continue;
            TransitionValues start = unmatchedStart.removeAt(i);
            this.mStartValuesList.add(start);
            this.mEndValuesList.add(end);
        }
    }

    private final void $$robo$$android_transition_Transition$matchItemIds(ArrayMap<View, TransitionValues> unmatchedStart, ArrayMap<View, TransitionValues> unmatchedEnd, LongSparseArray<View> startItemIds, LongSparseArray<View> endItemIds) {
        int numStartIds = startItemIds.size();
        for (int i = 0; i < numStartIds; ++i) {
            View endView;
            View startView = startItemIds.valueAt(i);
            if (startView == null || !this.isValidTarget(startView) || (endView = endItemIds.get(startItemIds.keyAt(i))) == null || !this.isValidTarget(endView)) continue;
            TransitionValues startValues = unmatchedStart.get(startView);
            TransitionValues endValues = unmatchedEnd.get(endView);
            if (startValues == null || endValues == null) continue;
            this.mStartValuesList.add(startValues);
            this.mEndValuesList.add(endValues);
            unmatchedStart.remove(startView);
            unmatchedEnd.remove(endView);
        }
    }

    private final void $$robo$$android_transition_Transition$matchIds(ArrayMap<View, TransitionValues> unmatchedStart, ArrayMap<View, TransitionValues> unmatchedEnd, SparseArray<View> startIds, SparseArray<View> endIds) {
        int numStartIds = startIds.size();
        for (int i = 0; i < numStartIds; ++i) {
            View endView;
            View startView = startIds.valueAt(i);
            if (startView == null || !this.isValidTarget(startView) || (endView = endIds.get(startIds.keyAt(i))) == null || !this.isValidTarget(endView)) continue;
            TransitionValues startValues = unmatchedStart.get(startView);
            TransitionValues endValues = unmatchedEnd.get(endView);
            if (startValues == null || endValues == null) continue;
            this.mStartValuesList.add(startValues);
            this.mEndValuesList.add(endValues);
            unmatchedStart.remove(startView);
            unmatchedEnd.remove(endView);
        }
    }

    private final void $$robo$$android_transition_Transition$matchNames(ArrayMap<View, TransitionValues> unmatchedStart, ArrayMap<View, TransitionValues> unmatchedEnd, ArrayMap<String, View> startNames, ArrayMap<String, View> endNames) {
        int numStartNames = startNames.size();
        for (int i = 0; i < numStartNames; ++i) {
            View endView;
            View startView = startNames.valueAt(i);
            if (startView == null || !this.isValidTarget(startView) || (endView = endNames.get(startNames.keyAt(i))) == null || !this.isValidTarget(endView)) continue;
            TransitionValues startValues = unmatchedStart.get(startView);
            TransitionValues endValues = unmatchedEnd.get(endView);
            if (startValues == null || endValues == null) continue;
            this.mStartValuesList.add(startValues);
            this.mEndValuesList.add(endValues);
            unmatchedStart.remove(startView);
            unmatchedEnd.remove(endView);
        }
    }

    private final void $$robo$$android_transition_Transition$addUnmatched(ArrayMap<View, TransitionValues> unmatchedStart, ArrayMap<View, TransitionValues> unmatchedEnd) {
        int i;
        for (i = 0; i < unmatchedStart.size(); ++i) {
            TransitionValues start = unmatchedStart.valueAt(i);
            if (!this.isValidTarget(start.view)) continue;
            this.mStartValuesList.add(start);
            this.mEndValuesList.add(null);
        }
        for (i = 0; i < unmatchedEnd.size(); ++i) {
            TransitionValues end = unmatchedEnd.valueAt(i);
            if (!this.isValidTarget(end.view)) continue;
            this.mEndValuesList.add(end);
            this.mStartValuesList.add(null);
        }
    }

    private final void $$robo$$android_transition_Transition$matchStartAndEnd(TransitionValuesMaps startValues, TransitionValuesMaps endValues) {
        ArrayMap<View, TransitionValues> unmatchedStart = new ArrayMap<View, TransitionValues>(startValues.viewValues);
        ArrayMap<View, TransitionValues> unmatchedEnd = new ArrayMap<View, TransitionValues>(endValues.viewValues);
        block6: for (int i = 0; i < this.mMatchOrder.length; ++i) {
            switch (this.mMatchOrder[i]) {
                case 1: {
                    this.matchInstances(unmatchedStart, unmatchedEnd);
                    continue block6;
                }
                case 2: {
                    this.matchNames(unmatchedStart, unmatchedEnd, startValues.nameValues, endValues.nameValues);
                    continue block6;
                }
                case 3: {
                    this.matchIds(unmatchedStart, unmatchedEnd, startValues.idValues, endValues.idValues);
                    continue block6;
                }
                case 4: {
                    this.matchItemIds(unmatchedStart, unmatchedEnd, startValues.itemIdValues, endValues.itemIdValues);
                }
            }
        }
        this.addUnmatched(unmatchedStart, unmatchedEnd);
    }

    private final void $$robo$$android_transition_Transition$createAnimators(ViewGroup sceneRoot, TransitionValuesMaps startValues, TransitionValuesMaps endValues, ArrayList<TransitionValues> startValuesList, ArrayList<TransitionValues> endValuesList) {
        int i;
        ArrayMap<Animator, AnimationInfo> runningAnimators = Transition.getRunningAnimators();
        long minStartDelay = Long.MAX_VALUE;
        int minAnimator = this.mAnimators.size();
        SparseLongArray startDelays = new SparseLongArray();
        int startValuesListCount = startValuesList.size();
        for (i = 0; i < startValuesListCount; ++i) {
            Animator animator2;
            boolean isChanged;
            TransitionValues start = startValuesList.get(i);
            TransitionValues end = endValuesList.get(i);
            if (start != null && !start.targetedTransitions.contains(this)) {
                start = null;
            }
            if (end != null && !end.targetedTransitions.contains(this)) {
                end = null;
            }
            if (start == null && end == null) continue;
            boolean bl = isChanged = start == null || end == null || this.isTransitionRequired(start, end);
            if (!isChanged || (animator2 = this.createAnimator(sceneRoot, start, end)) == null) continue;
            View view = null;
            TransitionValues infoValues = null;
            if (end != null) {
                view = end.view;
                String[] properties = this.getTransitionProperties();
                if (view != null && properties != null && properties.length > 0) {
                    infoValues = new TransitionValues();
                    infoValues.view = view;
                    TransitionValues newValues = endValues.viewValues.get(view);
                    if (newValues != null) {
                        for (int j = 0; j < properties.length; ++j) {
                            infoValues.values.put(properties[j], newValues.values.get(properties[j]));
                        }
                    }
                    int numExistingAnims = runningAnimators.size();
                    for (int j = 0; j < numExistingAnims; ++j) {
                        Animator anim2 = runningAnimators.keyAt(j);
                        AnimationInfo info = runningAnimators.get(anim2);
                        if (info.values == null || info.view != view || (info.name != null || this.getName() != null) && !info.name.equals(this.getName()) || !info.values.equals(infoValues)) continue;
                        animator2 = null;
                        break;
                    }
                }
            } else {
                View view2 = view = start != null ? start.view : null;
            }
            if (animator2 == null) continue;
            if (this.mPropagation != null) {
                long delay = this.mPropagation.getStartDelay(sceneRoot, this, start, end);
                startDelays.put(this.mAnimators.size(), delay);
                minStartDelay = Math.min(delay, minStartDelay);
            }
            AnimationInfo info = new AnimationInfo(view, this.getName(), this, sceneRoot.getWindowId(), infoValues);
            runningAnimators.put(animator2, info);
            this.mAnimators.add(animator2);
        }
        if (startDelays.size() != 0) {
            for (i = 0; i < startDelays.size(); ++i) {
                int index = startDelays.keyAt(i);
                Animator animator3 = this.mAnimators.get(index);
                long delay = startDelays.valueAt(i) - minStartDelay + animator3.getStartDelay();
                animator3.setStartDelay(delay);
            }
        }
    }

    private final boolean $$robo$$android_transition_Transition$isValidTarget(View target) {
        if (target == null) {
            return false;
        }
        int targetId = target.getId();
        if (this.mTargetIdExcludes != null && this.mTargetIdExcludes.contains(targetId)) {
            return false;
        }
        if (this.mTargetExcludes != null && this.mTargetExcludes.contains(target)) {
            return false;
        }
        if (this.mTargetTypeExcludes != null && target != null) {
            int numTypes = this.mTargetTypeExcludes.size();
            for (int i = 0; i < numTypes; ++i) {
                Class type = this.mTargetTypeExcludes.get(i);
                if (!type.isInstance(target)) continue;
                return false;
            }
        }
        if (this.mTargetNameExcludes != null && target != null && target.getTransitionName() != null && this.mTargetNameExcludes.contains(target.getTransitionName())) {
            return false;
        }
        if (this.mTargetIds.size() == 0 && this.mTargets.size() == 0 && (this.mTargetTypes == null || this.mTargetTypes.isEmpty()) && (this.mTargetNames == null || this.mTargetNames.isEmpty())) {
            return true;
        }
        if (this.mTargetIds.contains(targetId) || this.mTargets.contains(target)) {
            return true;
        }
        if (this.mTargetNames != null && this.mTargetNames.contains(target.getTransitionName())) {
            return true;
        }
        if (this.mTargetTypes != null) {
            for (int i = 0; i < this.mTargetTypes.size(); ++i) {
                if (!this.mTargetTypes.get(i).isInstance(target)) continue;
                return true;
            }
        }
        return false;
    }

    private static final ArrayMap<Animator, AnimationInfo> $$robo$$android_transition_Transition$getRunningAnimators() {
        ArrayMap<Animator, AnimationInfo> runningAnimators = sRunningAnimators.get();
        if (runningAnimators == null) {
            runningAnimators = new ArrayMap();
            sRunningAnimators.set(runningAnimators);
        }
        return runningAnimators;
    }

    private final void $$robo$$android_transition_Transition$runAnimators() {
        this.start();
        ArrayMap<Animator, AnimationInfo> runningAnimators = Transition.getRunningAnimators();
        for (Animator anim2 : this.mAnimators) {
            if (!runningAnimators.containsKey(anim2)) continue;
            this.start();
            this.runAnimator(anim2, runningAnimators);
        }
        this.mAnimators.clear();
        this.end();
    }

    private final void $$robo$$android_transition_Transition$runAnimator(Animator animator2, ArrayMap<Animator, AnimationInfo> runningAnimators) {
        if (animator2 != null) {
            animator2.addListener((Animator.AnimatorListener)new ShadowedObject(this, runningAnimators){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ArrayMap val$runningAnimators;
                /* synthetic */ Transition this$0;

                private void $$robo$$android_transition_Transition_2$__constructor__(Transition this$0, ArrayMap arrayMap) {
                }

                private final void $$robo$$android_transition_Transition_2$onAnimationStart(Animator animation) {
                    this.this$0.mCurrentAnimators.add(animation);
                }

                private final void $$robo$$android_transition_Transition_2$onAnimationEnd(Animator animation) {
                    this.val$runningAnimators.remove(animation);
                    this.this$0.mCurrentAnimators.remove(animation);
                }

                private void __constructor__(Transition transition2, ArrayMap arrayMap) {
                    this.$$robo$$android_transition_Transition_2$__constructor__(transition2, arrayMap);
                }
                {
                    this.this$0 = transition2;
                    this.val$runningAnimators = arrayMap;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_Transition_2$__constructor__(android.transition.Transition android.util.ArrayMap ), 0, this, transition2, arrayMap);
                }

                @Override
                public void onAnimationStart(Animator animator2) {
                    InvokeDynamicSupport.bootstrap("onAnimationStart", $$robo$$android_transition_Transition_2$onAnimationStart(android.animation.Animator ), 0, this, animator2);
                }

                @Override
                public void onAnimationEnd(Animator animator2) {
                    InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_transition_Transition_2$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            this.animate(animator2);
        }
    }

    public abstract void captureStartValues(TransitionValues var1);

    public abstract void captureEndValues(TransitionValues var1);

    private final Transition $$robo$$android_transition_Transition$addTarget(int targetId) {
        if (targetId > 0) {
            this.mTargetIds.add(targetId);
        }
        return this;
    }

    private final Transition $$robo$$android_transition_Transition$addTarget(String targetName) {
        if (targetName != null) {
            if (this.mTargetNames == null) {
                this.mTargetNames = new ArrayList();
            }
            this.mTargetNames.add(targetName);
        }
        return this;
    }

    private final Transition $$robo$$android_transition_Transition$addTarget(Class targetType) {
        if (targetType != null) {
            if (this.mTargetTypes == null) {
                this.mTargetTypes = new ArrayList();
            }
            this.mTargetTypes.add(targetType);
        }
        return this;
    }

    private final Transition $$robo$$android_transition_Transition$removeTarget(int targetId) {
        if (targetId > 0) {
            this.mTargetIds.remove((Object)targetId);
        }
        return this;
    }

    private final Transition $$robo$$android_transition_Transition$removeTarget(String targetName) {
        if (targetName != null && this.mTargetNames != null) {
            this.mTargetNames.remove(targetName);
        }
        return this;
    }

    private final Transition $$robo$$android_transition_Transition$excludeTarget(int targetId, boolean exclude) {
        if (targetId >= 0) {
            this.mTargetIdExcludes = Transition.excludeObject(this.mTargetIdExcludes, targetId, exclude);
        }
        return this;
    }

    private final Transition $$robo$$android_transition_Transition$excludeTarget(String targetName, boolean exclude) {
        this.mTargetNameExcludes = Transition.excludeObject(this.mTargetNameExcludes, targetName, exclude);
        return this;
    }

    private final Transition $$robo$$android_transition_Transition$excludeChildren(int targetId, boolean exclude) {
        if (targetId >= 0) {
            this.mTargetIdChildExcludes = Transition.excludeObject(this.mTargetIdChildExcludes, targetId, exclude);
        }
        return this;
    }

    private final Transition $$robo$$android_transition_Transition$excludeTarget(View target, boolean exclude) {
        this.mTargetExcludes = Transition.excludeObject(this.mTargetExcludes, target, exclude);
        return this;
    }

    private final Transition $$robo$$android_transition_Transition$excludeChildren(View target, boolean exclude) {
        this.mTargetChildExcludes = Transition.excludeObject(this.mTargetChildExcludes, target, exclude);
        return this;
    }

    private static final <T> ArrayList<T> $$robo$$android_transition_Transition$excludeObject(ArrayList<T> list, T target, boolean exclude) {
        if (target != null) {
            list = exclude ? ArrayListManager.add(list, target) : ArrayListManager.remove(list, target);
        }
        return list;
    }

    private final Transition $$robo$$android_transition_Transition$excludeTarget(Class type, boolean exclude) {
        this.mTargetTypeExcludes = Transition.excludeObject(this.mTargetTypeExcludes, type, exclude);
        return this;
    }

    private final Transition $$robo$$android_transition_Transition$excludeChildren(Class type, boolean exclude) {
        this.mTargetTypeChildExcludes = Transition.excludeObject(this.mTargetTypeChildExcludes, type, exclude);
        return this;
    }

    private final Transition $$robo$$android_transition_Transition$addTarget(View target) {
        this.mTargets.add(target);
        return this;
    }

    private final Transition $$robo$$android_transition_Transition$removeTarget(View target) {
        if (target != null) {
            this.mTargets.remove(target);
        }
        return this;
    }

    private final Transition $$robo$$android_transition_Transition$removeTarget(Class target) {
        if (target != null) {
            this.mTargetTypes.remove(target);
        }
        return this;
    }

    private final List<Integer> $$robo$$android_transition_Transition$getTargetIds() {
        return this.mTargetIds;
    }

    private final List<View> $$robo$$android_transition_Transition$getTargets() {
        return this.mTargets;
    }

    private final List<String> $$robo$$android_transition_Transition$getTargetNames() {
        return this.mTargetNames;
    }

    private final List<String> $$robo$$android_transition_Transition$getTargetViewNames() {
        return this.mTargetNames;
    }

    private final List<Class> $$robo$$android_transition_Transition$getTargetTypes() {
        return this.mTargetTypes;
    }

    private final void $$robo$$android_transition_Transition$captureValues(ViewGroup sceneRoot, boolean start) {
        this.clearValues(start);
        if (!(this.mTargetIds.size() <= 0 && this.mTargets.size() <= 0 || this.mTargetNames != null && !this.mTargetNames.isEmpty() || this.mTargetTypes != null && !this.mTargetTypes.isEmpty())) {
            int i;
            for (i = 0; i < this.mTargetIds.size(); ++i) {
                int id2 = this.mTargetIds.get(i);
                Object view = sceneRoot.findViewById(id2);
                if (view == null) continue;
                TransitionValues values = new TransitionValues();
                values.view = view;
                if (start) {
                    this.captureStartValues(values);
                } else {
                    this.captureEndValues(values);
                }
                values.targetedTransitions.add(this);
                this.capturePropagationValues(values);
                if (start) {
                    Transition.addViewValues(this.mStartValues, view, values);
                    continue;
                }
                Transition.addViewValues(this.mEndValues, view, values);
            }
            for (i = 0; i < this.mTargets.size(); ++i) {
                View view = this.mTargets.get(i);
                TransitionValues values = new TransitionValues();
                values.view = view;
                if (start) {
                    this.captureStartValues(values);
                } else {
                    this.captureEndValues(values);
                }
                values.targetedTransitions.add(this);
                this.capturePropagationValues(values);
                if (start) {
                    Transition.addViewValues(this.mStartValues, view, values);
                    continue;
                }
                Transition.addViewValues(this.mEndValues, view, values);
            }
        } else {
            this.captureHierarchy(sceneRoot, start);
        }
        if (!start && this.mNameOverrides != null) {
            int i;
            int numOverrides = this.mNameOverrides.size();
            ArrayList<View> overriddenViews = new ArrayList<View>(numOverrides);
            for (i = 0; i < numOverrides; ++i) {
                String fromName = this.mNameOverrides.keyAt(i);
                overriddenViews.add(this.mStartValues.nameValues.remove(fromName));
            }
            for (i = 0; i < numOverrides; ++i) {
                View view = (View)overriddenViews.get(i);
                if (view == null) continue;
                String toName = this.mNameOverrides.valueAt(i);
                this.mStartValues.nameValues.put(toName, view);
            }
        }
    }

    private static final void $$robo$$android_transition_Transition$addViewValues(TransitionValuesMaps transitionValuesMaps, View view, TransitionValues transitionValues) {
        ListView listview;
        String name;
        transitionValuesMaps.viewValues.put(view, transitionValues);
        int id2 = view.getId();
        if (id2 >= 0) {
            if (transitionValuesMaps.idValues.indexOfKey(id2) >= 0) {
                transitionValuesMaps.idValues.put(id2, null);
            } else {
                transitionValuesMaps.idValues.put(id2, view);
            }
        }
        if ((name = view.getTransitionName()) != null) {
            if (transitionValuesMaps.nameValues.containsKey(name)) {
                transitionValuesMaps.nameValues.put(name, null);
            } else {
                transitionValuesMaps.nameValues.put(name, view);
            }
        }
        if (view.getParent() instanceof ListView && (listview = (ListView)view.getParent()).getAdapter().hasStableIds()) {
            int position = listview.getPositionForView(view);
            long itemId = listview.getItemIdAtPosition(position);
            if (transitionValuesMaps.itemIdValues.indexOfKey(itemId) >= 0) {
                View alreadyMatched = transitionValuesMaps.itemIdValues.get(itemId);
                if (alreadyMatched != null) {
                    alreadyMatched.setHasTransientState(false);
                    transitionValuesMaps.itemIdValues.put(itemId, null);
                }
            } else {
                view.setHasTransientState(true);
                transitionValuesMaps.itemIdValues.put(itemId, view);
            }
        }
    }

    private final void $$robo$$android_transition_Transition$clearValues(boolean start) {
        if (start) {
            this.mStartValues.viewValues.clear();
            this.mStartValues.idValues.clear();
            this.mStartValues.itemIdValues.clear();
            this.mStartValues.nameValues.clear();
            this.mStartValuesList = null;
        } else {
            this.mEndValues.viewValues.clear();
            this.mEndValues.idValues.clear();
            this.mEndValues.itemIdValues.clear();
            this.mEndValues.nameValues.clear();
            this.mEndValuesList = null;
        }
    }

    private final void $$robo$$android_transition_Transition$captureHierarchy(View view, boolean start) {
        int i;
        int numTypes;
        if (view == null) {
            return;
        }
        int id2 = view.getId();
        if (this.mTargetIdExcludes != null && this.mTargetIdExcludes.contains(id2)) {
            return;
        }
        if (this.mTargetExcludes != null && this.mTargetExcludes.contains(view)) {
            return;
        }
        if (this.mTargetTypeExcludes != null && view != null) {
            numTypes = this.mTargetTypeExcludes.size();
            for (i = 0; i < numTypes; ++i) {
                if (!this.mTargetTypeExcludes.get(i).isInstance(view)) continue;
                return;
            }
        }
        if (view.getParent() instanceof ViewGroup) {
            TransitionValues values = new TransitionValues();
            values.view = view;
            if (start) {
                this.captureStartValues(values);
            } else {
                this.captureEndValues(values);
            }
            values.targetedTransitions.add(this);
            this.capturePropagationValues(values);
            if (start) {
                Transition.addViewValues(this.mStartValues, view, values);
            } else {
                Transition.addViewValues(this.mEndValues, view, values);
            }
        }
        if (view instanceof ViewGroup) {
            if (this.mTargetIdChildExcludes != null && this.mTargetIdChildExcludes.contains(id2)) {
                return;
            }
            if (this.mTargetChildExcludes != null && this.mTargetChildExcludes.contains(view)) {
                return;
            }
            if (this.mTargetTypeChildExcludes != null) {
                numTypes = this.mTargetTypeChildExcludes.size();
                for (i = 0; i < numTypes; ++i) {
                    if (!this.mTargetTypeChildExcludes.get(i).isInstance(view)) continue;
                    return;
                }
            }
            ViewGroup parent = (ViewGroup)view;
            for (i = 0; i < parent.getChildCount(); ++i) {
                this.captureHierarchy(parent.getChildAt(i), start);
            }
        }
    }

    private final TransitionValues $$robo$$android_transition_Transition$getTransitionValues(View view, boolean start) {
        if (this.mParent != null) {
            return this.mParent.getTransitionValues(view, start);
        }
        TransitionValuesMaps valuesMaps = start ? this.mStartValues : this.mEndValues;
        return valuesMaps.viewValues.get(view);
    }

    private final TransitionValues $$robo$$android_transition_Transition$getMatchedTransitionValues(View view, boolean viewInStart) {
        ArrayList<TransitionValues> lookIn;
        if (this.mParent != null) {
            return this.mParent.getMatchedTransitionValues(view, viewInStart);
        }
        ArrayList<TransitionValues> arrayList = lookIn = viewInStart ? this.mStartValuesList : this.mEndValuesList;
        if (lookIn == null) {
            return null;
        }
        int count = lookIn.size();
        int index = -1;
        for (int i = 0; i < count; ++i) {
            TransitionValues values = lookIn.get(i);
            if (values == null) {
                return null;
            }
            if (values.view != view) continue;
            index = i;
            break;
        }
        TransitionValues values = null;
        if (index >= 0) {
            ArrayList<TransitionValues> matchIn = viewInStart ? this.mEndValuesList : this.mStartValuesList;
            values = matchIn.get(index);
        }
        return values;
    }

    private final void $$robo$$android_transition_Transition$pause(View sceneRoot) {
        if (!this.mEnded) {
            ArrayMap<Animator, AnimationInfo> runningAnimators = Transition.getRunningAnimators();
            int numOldAnims = runningAnimators.size();
            if (sceneRoot != null) {
                WindowId windowId = sceneRoot.getWindowId();
                for (int i = numOldAnims - 1; i >= 0; --i) {
                    AnimationInfo info = runningAnimators.valueAt(i);
                    if (info.view == null || windowId == null || !windowId.equals(info.windowId)) continue;
                    Animator anim2 = runningAnimators.keyAt(i);
                    anim2.pause();
                }
            }
            if (this.mListeners != null && this.mListeners.size() > 0) {
                ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                int numListeners = tmpListeners.size();
                for (int i = 0; i < numListeners; ++i) {
                    ((TransitionListener)tmpListeners.get(i)).onTransitionPause(this);
                }
            }
            this.mPaused = true;
        }
    }

    private final void $$robo$$android_transition_Transition$resume(View sceneRoot) {
        if (this.mPaused) {
            if (!this.mEnded) {
                ArrayMap<Animator, AnimationInfo> runningAnimators = Transition.getRunningAnimators();
                int numOldAnims = runningAnimators.size();
                WindowId windowId = sceneRoot.getWindowId();
                for (int i = numOldAnims - 1; i >= 0; --i) {
                    AnimationInfo info = runningAnimators.valueAt(i);
                    if (info.view == null || windowId == null || !windowId.equals(info.windowId)) continue;
                    Animator anim2 = runningAnimators.keyAt(i);
                    anim2.resume();
                }
                if (this.mListeners != null && this.mListeners.size() > 0) {
                    ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                    int numListeners = tmpListeners.size();
                    for (int i = 0; i < numListeners; ++i) {
                        ((TransitionListener)tmpListeners.get(i)).onTransitionResume(this);
                    }
                }
            }
            this.mPaused = false;
        }
    }

    private final void $$robo$$android_transition_Transition$playTransition(ViewGroup sceneRoot) {
        this.mStartValuesList = new ArrayList();
        this.mEndValuesList = new ArrayList();
        this.matchStartAndEnd(this.mStartValues, this.mEndValues);
        ArrayMap<Animator, AnimationInfo> runningAnimators = Transition.getRunningAnimators();
        int numOldAnims = runningAnimators.size();
        WindowId windowId = sceneRoot.getWindowId();
        for (int i = numOldAnims - 1; i >= 0; --i) {
            boolean cancel;
            AnimationInfo oldInfo;
            Animator anim2 = runningAnimators.keyAt(i);
            if (anim2 == null || (oldInfo = runningAnimators.get(anim2)) == null || oldInfo.view == null || oldInfo.windowId != windowId) continue;
            TransitionValues oldValues = oldInfo.values;
            View oldView = oldInfo.view;
            TransitionValues startValues = this.getTransitionValues(oldView, true);
            TransitionValues endValues = this.getMatchedTransitionValues(oldView, true);
            if (startValues == null && endValues == null) {
                endValues = this.mEndValues.viewValues.get(oldView);
            }
            boolean bl = cancel = (startValues != null || endValues != null) && oldInfo.transition.isTransitionRequired(oldValues, endValues);
            if (!cancel) continue;
            if (anim2.isRunning() || anim2.isStarted()) {
                anim2.cancel();
                continue;
            }
            runningAnimators.remove(anim2);
        }
        this.createAnimators(sceneRoot, this.mStartValues, this.mEndValues, this.mStartValuesList, this.mEndValuesList);
        this.runAnimators();
    }

    private final boolean $$robo$$android_transition_Transition$isTransitionRequired(TransitionValues startValues, TransitionValues endValues) {
        boolean valuesChanged;
        block4: {
            valuesChanged = false;
            if (startValues == null || endValues == null) break block4;
            String[] properties = this.getTransitionProperties();
            if (properties != null) {
                int count = properties.length;
                for (int i = 0; i < count; ++i) {
                    if (!Transition.isValueChanged(startValues, endValues, properties[i])) continue;
                    valuesChanged = true;
                    break;
                }
            } else {
                for (String key : startValues.values.keySet()) {
                    if (!Transition.isValueChanged(startValues, endValues, key)) continue;
                    valuesChanged = true;
                    break;
                }
            }
        }
        return valuesChanged;
    }

    private static final boolean $$robo$$android_transition_Transition$isValueChanged(TransitionValues oldValues, TransitionValues newValues, String key) {
        if (oldValues.values.containsKey(key) != newValues.values.containsKey(key)) {
            return false;
        }
        Object oldValue = oldValues.values.get(key);
        Object newValue = newValues.values.get(key);
        boolean changed = oldValue == null && newValue == null ? false : (oldValue == null || newValue == null ? true : !oldValue.equals(newValue));
        return changed;
    }

    private final void $$robo$$android_transition_Transition$animate(Animator animator2) {
        if (animator2 == null) {
            this.end();
        } else {
            if (this.getDuration() >= 0L) {
                animator2.setDuration(this.getDuration());
            }
            if (this.getStartDelay() >= 0L) {
                animator2.setStartDelay(this.getStartDelay() + animator2.getStartDelay());
            }
            if (this.getInterpolator() != null) {
                animator2.setInterpolator(this.getInterpolator());
            }
            animator2.addListener((Animator.AnimatorListener)new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Transition this$0;

                private void $$robo$$android_transition_Transition_3$__constructor__(Transition this$0) {
                }

                private final void $$robo$$android_transition_Transition_3$onAnimationEnd(Animator animation) {
                    this.this$0.end();
                    animation.removeListener(this);
                }

                private void __constructor__(Transition transition2) {
                    this.$$robo$$android_transition_Transition_3$__constructor__(transition2);
                }
                {
                    this.this$0 = transition2;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_Transition_3$__constructor__(android.transition.Transition ), 0, this, transition2);
                }

                @Override
                public void onAnimationEnd(Animator animator2) {
                    InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_transition_Transition_3$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            animator2.start();
        }
    }

    private final void $$robo$$android_transition_Transition$start() {
        if (this.mNumInstances == 0) {
            if (this.mListeners != null && this.mListeners.size() > 0) {
                ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                int numListeners = tmpListeners.size();
                for (int i = 0; i < numListeners; ++i) {
                    ((TransitionListener)tmpListeners.get(i)).onTransitionStart(this);
                }
            }
            this.mEnded = false;
        }
        ++this.mNumInstances;
    }

    private final void $$robo$$android_transition_Transition$end() {
        --this.mNumInstances;
        if (this.mNumInstances == 0) {
            int i;
            if (this.mListeners != null && this.mListeners.size() > 0) {
                ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                int numListeners = tmpListeners.size();
                for (int i2 = 0; i2 < numListeners; ++i2) {
                    ((TransitionListener)tmpListeners.get(i2)).onTransitionEnd(this);
                }
            }
            for (i = 0; i < this.mStartValues.itemIdValues.size(); ++i) {
                View view = this.mStartValues.itemIdValues.valueAt(i);
                if (view == null) continue;
                view.setHasTransientState(false);
            }
            for (i = 0; i < this.mEndValues.itemIdValues.size(); ++i) {
                View view = this.mEndValues.itemIdValues.valueAt(i);
                if (view == null) continue;
                view.setHasTransientState(false);
            }
            this.mEnded = true;
        }
    }

    private final void $$robo$$android_transition_Transition$forceToEnd(ViewGroup sceneRoot) {
        ArrayMap<Animator, AnimationInfo> runningAnimators = Transition.getRunningAnimators();
        int numOldAnims = runningAnimators.size();
        if (sceneRoot != null) {
            WindowId windowId = sceneRoot.getWindowId();
            for (int i = numOldAnims - 1; i >= 0; --i) {
                AnimationInfo info = runningAnimators.valueAt(i);
                if (info.view == null || windowId == null || !windowId.equals(info.windowId)) continue;
                Animator anim2 = runningAnimators.keyAt(i);
                anim2.end();
            }
        }
    }

    private final void $$robo$$android_transition_Transition$cancel() {
        int numAnimators = this.mCurrentAnimators.size();
        for (int i = numAnimators - 1; i >= 0; --i) {
            Animator animator2 = this.mCurrentAnimators.get(i);
            animator2.cancel();
        }
        if (this.mListeners != null && this.mListeners.size() > 0) {
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            int numListeners = tmpListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                ((TransitionListener)tmpListeners.get(i)).onTransitionCancel(this);
            }
        }
    }

    private final Transition $$robo$$android_transition_Transition$addListener(TransitionListener listener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        this.mListeners.add(listener);
        return this;
    }

    private final Transition $$robo$$android_transition_Transition$removeListener(TransitionListener listener) {
        if (this.mListeners == null) {
            return this;
        }
        this.mListeners.remove(listener);
        if (this.mListeners.size() == 0) {
            this.mListeners = null;
        }
        return this;
    }

    private final void $$robo$$android_transition_Transition$setEpicenterCallback(EpicenterCallback epicenterCallback) {
        this.mEpicenterCallback = epicenterCallback;
    }

    private final EpicenterCallback $$robo$$android_transition_Transition$getEpicenterCallback() {
        return this.mEpicenterCallback;
    }

    private final Rect $$robo$$android_transition_Transition$getEpicenter() {
        if (this.mEpicenterCallback == null) {
            return null;
        }
        return this.mEpicenterCallback.onGetEpicenter(this);
    }

    private final void $$robo$$android_transition_Transition$setPathMotion(PathMotion pathMotion) {
        this.mPathMotion = pathMotion == null ? STRAIGHT_PATH_MOTION : pathMotion;
    }

    private final PathMotion $$robo$$android_transition_Transition$getPathMotion() {
        return this.mPathMotion;
    }

    private final void $$robo$$android_transition_Transition$setPropagation(TransitionPropagation transitionPropagation) {
        this.mPropagation = transitionPropagation;
    }

    private final TransitionPropagation $$robo$$android_transition_Transition$getPropagation() {
        return this.mPropagation;
    }

    private final void $$robo$$android_transition_Transition$capturePropagationValues(TransitionValues transitionValues) {
        if (this.mPropagation != null && !transitionValues.values.isEmpty()) {
            String[] propertyNames = this.mPropagation.getPropagationProperties();
            if (propertyNames == null) {
                return;
            }
            boolean containsAll = true;
            for (int i = 0; i < propertyNames.length; ++i) {
                if (transitionValues.values.containsKey(propertyNames[i])) continue;
                containsAll = false;
                break;
            }
            if (!containsAll) {
                this.mPropagation.captureValues(transitionValues);
            }
        }
    }

    private final Transition $$robo$$android_transition_Transition$setSceneRoot(ViewGroup sceneRoot) {
        this.mSceneRoot = sceneRoot;
        return this;
    }

    private final void $$robo$$android_transition_Transition$setCanRemoveViews(boolean canRemoveViews) {
        this.mCanRemoveViews = canRemoveViews;
    }

    private final boolean $$robo$$android_transition_Transition$canRemoveViews() {
        return this.mCanRemoveViews;
    }

    private final void $$robo$$android_transition_Transition$setNameOverrides(ArrayMap<String, String> overrides) {
        this.mNameOverrides = overrides;
    }

    private final ArrayMap<String, String> $$robo$$android_transition_Transition$getNameOverrides() {
        return this.mNameOverrides;
    }

    private final String $$robo$$android_transition_Transition$toString() {
        return this.toString("");
    }

    private final Transition $$robo$$android_transition_Transition$clone() {
        Transition clone = null;
        try {
            clone = (Transition)super.clone();
            clone.mAnimators = new ArrayList();
            clone.mStartValues = new TransitionValuesMaps();
            clone.mEndValues = new TransitionValuesMaps();
            clone.mStartValuesList = null;
            clone.mEndValuesList = null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    private final String $$robo$$android_transition_Transition$getName() {
        return this.mName;
    }

    private final String $$robo$$android_transition_Transition$toString(String indent) {
        String result = indent + this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + ": ";
        if (this.mDuration != -1L) {
            result = result + "dur(" + this.mDuration + ") ";
        }
        if (this.mStartDelay != -1L) {
            result = result + "dly(" + this.mStartDelay + ") ";
        }
        if (this.mInterpolator != null) {
            result = result + "interp(" + this.mInterpolator + ") ";
        }
        if (this.mTargetIds.size() > 0 || this.mTargets.size() > 0) {
            int i;
            result = result + "tgts(";
            if (this.mTargetIds.size() > 0) {
                for (i = 0; i < this.mTargetIds.size(); ++i) {
                    if (i > 0) {
                        result = result + ", ";
                    }
                    result = result + this.mTargetIds.get(i);
                }
            }
            if (this.mTargets.size() > 0) {
                for (i = 0; i < this.mTargets.size(); ++i) {
                    if (i > 0) {
                        result = result + ", ";
                    }
                    result = result + this.mTargets.get(i);
                }
            }
            result = result + ")";
        }
        return result;
    }

    static void __staticInitializer__() {
        DEFAULT_MATCH_ORDER = new int[]{2, 1, 3, 4};
        STRAIGHT_PATH_MOTION = new ShadowedObject(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_transition_Transition_1$__constructor__() {
            }

            private final Path $$robo$$android_transition_Transition_1$getPath(float startX, float startY, float endX, float endY) {
                Path path = new Path();
                path.moveTo(startX, startY);
                path.lineTo(endX, endY);
                return path;
            }

            private void __constructor__() {
                this.$$robo$$android_transition_Transition_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_Transition_1$__constructor__(), 0, this);
            }

            @Override
            public Path getPath(float f, float f2, float f3, float f4) {
                return InvokeDynamicSupport.bootstrap("getPath", $$robo$$android_transition_Transition_1$getPath(float float float float ), 0, this, f, f2, f3, f4);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        sRunningAnimators = new ThreadLocal();
    }

    private void __constructor__() {
        this.$$robo$$android_transition_Transition$__constructor__();
    }

    public Transition() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_Transition$__constructor__(), 0, this);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_transition_Transition$__constructor__(context, attributeSet);
    }

    public Transition(Context context, AttributeSet attributeSet) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_Transition$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private static int[] parseMatchOrder(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("parseMatchOrder", $$robo$$android_transition_Transition$parseMatchOrder(java.lang.String ), 0, (String)string2);
    }

    public Transition setDuration(long l) {
        return InvokeDynamicSupport.bootstrap("setDuration", $$robo$$android_transition_Transition$setDuration(long ), 0, this, l);
    }

    public long getDuration() {
        return (long)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$android_transition_Transition$getDuration(), 0, this);
    }

    public Transition setStartDelay(long l) {
        return InvokeDynamicSupport.bootstrap("setStartDelay", $$robo$$android_transition_Transition$setStartDelay(long ), 0, this, l);
    }

    public long getStartDelay() {
        return (long)InvokeDynamicSupport.bootstrap("getStartDelay", $$robo$$android_transition_Transition$getStartDelay(), 0, this);
    }

    public Transition setInterpolator(TimeInterpolator timeInterpolator) {
        return InvokeDynamicSupport.bootstrap("setInterpolator", $$robo$$android_transition_Transition$setInterpolator(android.animation.TimeInterpolator ), 0, this, timeInterpolator);
    }

    public TimeInterpolator getInterpolator() {
        return InvokeDynamicSupport.bootstrap("getInterpolator", $$robo$$android_transition_Transition$getInterpolator(), 0, this);
    }

    public String[] getTransitionProperties() {
        return InvokeDynamicSupport.bootstrap("getTransitionProperties", $$robo$$android_transition_Transition$getTransitionProperties(), 0, this);
    }

    public Animator createAnimator(ViewGroup viewGroup, TransitionValues transitionValues, TransitionValues transitionValues2) {
        return InvokeDynamicSupport.bootstrap("createAnimator", $$robo$$android_transition_Transition$createAnimator(android.view.ViewGroup android.transition.TransitionValues android.transition.TransitionValues ), 0, this, viewGroup, transitionValues, transitionValues2);
    }

    public void setMatchOrder(int ... nArray) {
        InvokeDynamicSupport.bootstrap("setMatchOrder", $$robo$$android_transition_Transition$setMatchOrder(int[] ), 0, this, nArray);
    }

    private static boolean isValidMatch(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidMatch", $$robo$$android_transition_Transition$isValidMatch(int ), 0, (int)n);
    }

    private static boolean alreadyContains(int[] nArray, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("alreadyContains", $$robo$$android_transition_Transition$alreadyContains(int[] int ), 0, (int[])nArray, (int)n);
    }

    private void matchInstances(ArrayMap<View, TransitionValues> arrayMap, ArrayMap<View, TransitionValues> arrayMap2) {
        InvokeDynamicSupport.bootstrap("matchInstances", $$robo$$android_transition_Transition$matchInstances(android.util.ArrayMap<android.view.View, android.transition.TransitionValues> android.util.ArrayMap<android.view.View, android.transition.TransitionValues> ), 0, this, arrayMap, arrayMap2);
    }

    private void matchItemIds(ArrayMap<View, TransitionValues> arrayMap, ArrayMap<View, TransitionValues> arrayMap2, LongSparseArray<View> longSparseArray, LongSparseArray<View> longSparseArray2) {
        InvokeDynamicSupport.bootstrap("matchItemIds", $$robo$$android_transition_Transition$matchItemIds(android.util.ArrayMap<android.view.View, android.transition.TransitionValues> android.util.ArrayMap<android.view.View, android.transition.TransitionValues> android.util.LongSparseArray<android.view.View> android.util.LongSparseArray<android.view.View> ), 0, this, arrayMap, arrayMap2, longSparseArray, longSparseArray2);
    }

    private void matchIds(ArrayMap<View, TransitionValues> arrayMap, ArrayMap<View, TransitionValues> arrayMap2, SparseArray<View> sparseArray, SparseArray<View> sparseArray2) {
        InvokeDynamicSupport.bootstrap("matchIds", $$robo$$android_transition_Transition$matchIds(android.util.ArrayMap<android.view.View, android.transition.TransitionValues> android.util.ArrayMap<android.view.View, android.transition.TransitionValues> android.util.SparseArray<android.view.View> android.util.SparseArray<android.view.View> ), 0, this, arrayMap, arrayMap2, sparseArray, sparseArray2);
    }

    private void matchNames(ArrayMap<View, TransitionValues> arrayMap, ArrayMap<View, TransitionValues> arrayMap2, ArrayMap<String, View> arrayMap3, ArrayMap<String, View> arrayMap4) {
        InvokeDynamicSupport.bootstrap("matchNames", $$robo$$android_transition_Transition$matchNames(android.util.ArrayMap<android.view.View, android.transition.TransitionValues> android.util.ArrayMap<android.view.View, android.transition.TransitionValues> android.util.ArrayMap<java.lang.String, android.view.View> android.util.ArrayMap<java.lang.String, android.view.View> ), 0, this, arrayMap, arrayMap2, arrayMap3, arrayMap4);
    }

    private void addUnmatched(ArrayMap<View, TransitionValues> arrayMap, ArrayMap<View, TransitionValues> arrayMap2) {
        InvokeDynamicSupport.bootstrap("addUnmatched", $$robo$$android_transition_Transition$addUnmatched(android.util.ArrayMap<android.view.View, android.transition.TransitionValues> android.util.ArrayMap<android.view.View, android.transition.TransitionValues> ), 0, this, arrayMap, arrayMap2);
    }

    private void matchStartAndEnd(TransitionValuesMaps transitionValuesMaps, TransitionValuesMaps transitionValuesMaps2) {
        InvokeDynamicSupport.bootstrap("matchStartAndEnd", $$robo$$android_transition_Transition$matchStartAndEnd(android.transition.TransitionValuesMaps android.transition.TransitionValuesMaps ), 0, this, transitionValuesMaps, transitionValuesMaps2);
    }

    protected void createAnimators(ViewGroup viewGroup, TransitionValuesMaps transitionValuesMaps, TransitionValuesMaps transitionValuesMaps2, ArrayList<TransitionValues> arrayList, ArrayList<TransitionValues> arrayList2) {
        InvokeDynamicSupport.bootstrap("createAnimators", $$robo$$android_transition_Transition$createAnimators(android.view.ViewGroup android.transition.TransitionValuesMaps android.transition.TransitionValuesMaps java.util.ArrayList<android.transition.TransitionValues> java.util.ArrayList<android.transition.TransitionValues> ), 0, this, viewGroup, transitionValuesMaps, transitionValuesMaps2, arrayList, arrayList2);
    }

    public boolean isValidTarget(View view) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValidTarget", $$robo$$android_transition_Transition$isValidTarget(android.view.View ), 0, this, view);
    }

    private static ArrayMap<Animator, AnimationInfo> getRunningAnimators() {
        return InvokeDynamicSupport.bootstrapStatic("getRunningAnimators", $$robo$$android_transition_Transition$getRunningAnimators(), 0);
    }

    protected void runAnimators() {
        InvokeDynamicSupport.bootstrap("runAnimators", $$robo$$android_transition_Transition$runAnimators(), 0, this);
    }

    private void runAnimator(Animator animator2, ArrayMap<Animator, AnimationInfo> arrayMap) {
        InvokeDynamicSupport.bootstrap("runAnimator", $$robo$$android_transition_Transition$runAnimator(android.animation.Animator android.util.ArrayMap<android.animation.Animator, android.transition.Transition$AnimationInfo> ), 0, this, animator2, arrayMap);
    }

    public Transition addTarget(int n) {
        return InvokeDynamicSupport.bootstrap("addTarget", $$robo$$android_transition_Transition$addTarget(int ), 0, this, n);
    }

    public Transition addTarget(String string2) {
        return InvokeDynamicSupport.bootstrap("addTarget", $$robo$$android_transition_Transition$addTarget(java.lang.String ), 0, this, string2);
    }

    public Transition addTarget(Class clazz) {
        return InvokeDynamicSupport.bootstrap("addTarget", $$robo$$android_transition_Transition$addTarget(java.lang.Class ), 0, this, clazz);
    }

    public Transition removeTarget(int n) {
        return InvokeDynamicSupport.bootstrap("removeTarget", $$robo$$android_transition_Transition$removeTarget(int ), 0, this, n);
    }

    public Transition removeTarget(String string2) {
        return InvokeDynamicSupport.bootstrap("removeTarget", $$robo$$android_transition_Transition$removeTarget(java.lang.String ), 0, this, string2);
    }

    public Transition excludeTarget(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("excludeTarget", $$robo$$android_transition_Transition$excludeTarget(int boolean ), 0, this, n, bl);
    }

    public Transition excludeTarget(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrap("excludeTarget", $$robo$$android_transition_Transition$excludeTarget(java.lang.String boolean ), 0, this, string2, bl);
    }

    public Transition excludeChildren(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("excludeChildren", $$robo$$android_transition_Transition$excludeChildren(int boolean ), 0, this, n, bl);
    }

    public Transition excludeTarget(View view, boolean bl) {
        return InvokeDynamicSupport.bootstrap("excludeTarget", $$robo$$android_transition_Transition$excludeTarget(android.view.View boolean ), 0, this, view, bl);
    }

    public Transition excludeChildren(View view, boolean bl) {
        return InvokeDynamicSupport.bootstrap("excludeChildren", $$robo$$android_transition_Transition$excludeChildren(android.view.View boolean ), 0, this, view, bl);
    }

    private static <T> ArrayList<T> excludeObject(ArrayList<T> arrayList, T t, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("excludeObject", $$robo$$android_transition_Transition$excludeObject(java.util.ArrayList<T> T boolean ), 0, arrayList, t, (boolean)bl);
    }

    public Transition excludeTarget(Class clazz, boolean bl) {
        return InvokeDynamicSupport.bootstrap("excludeTarget", $$robo$$android_transition_Transition$excludeTarget(java.lang.Class boolean ), 0, this, clazz, bl);
    }

    public Transition excludeChildren(Class clazz, boolean bl) {
        return InvokeDynamicSupport.bootstrap("excludeChildren", $$robo$$android_transition_Transition$excludeChildren(java.lang.Class boolean ), 0, this, clazz, bl);
    }

    public Transition addTarget(View view) {
        return InvokeDynamicSupport.bootstrap("addTarget", $$robo$$android_transition_Transition$addTarget(android.view.View ), 0, this, view);
    }

    public Transition removeTarget(View view) {
        return InvokeDynamicSupport.bootstrap("removeTarget", $$robo$$android_transition_Transition$removeTarget(android.view.View ), 0, this, view);
    }

    public Transition removeTarget(Class clazz) {
        return InvokeDynamicSupport.bootstrap("removeTarget", $$robo$$android_transition_Transition$removeTarget(java.lang.Class ), 0, this, clazz);
    }

    public List<Integer> getTargetIds() {
        return InvokeDynamicSupport.bootstrap("getTargetIds", $$robo$$android_transition_Transition$getTargetIds(), 0, this);
    }

    public List<View> getTargets() {
        return InvokeDynamicSupport.bootstrap("getTargets", $$robo$$android_transition_Transition$getTargets(), 0, this);
    }

    public List<String> getTargetNames() {
        return InvokeDynamicSupport.bootstrap("getTargetNames", $$robo$$android_transition_Transition$getTargetNames(), 0, this);
    }

    public List<String> getTargetViewNames() {
        return InvokeDynamicSupport.bootstrap("getTargetViewNames", $$robo$$android_transition_Transition$getTargetViewNames(), 0, this);
    }

    public List<Class> getTargetTypes() {
        return InvokeDynamicSupport.bootstrap("getTargetTypes", $$robo$$android_transition_Transition$getTargetTypes(), 0, this);
    }

    void captureValues(ViewGroup viewGroup, boolean bl) {
        InvokeDynamicSupport.bootstrap("captureValues", $$robo$$android_transition_Transition$captureValues(android.view.ViewGroup boolean ), 0, this, viewGroup, bl);
    }

    static void addViewValues(TransitionValuesMaps transitionValuesMaps, View view, TransitionValues transitionValues) {
        InvokeDynamicSupport.bootstrapStatic("addViewValues", $$robo$$android_transition_Transition$addViewValues(android.transition.TransitionValuesMaps android.view.View android.transition.TransitionValues ), 0, (TransitionValuesMaps)transitionValuesMaps, (View)view, (TransitionValues)transitionValues);
    }

    void clearValues(boolean bl) {
        InvokeDynamicSupport.bootstrap("clearValues", $$robo$$android_transition_Transition$clearValues(boolean ), 0, this, bl);
    }

    private void captureHierarchy(View view, boolean bl) {
        InvokeDynamicSupport.bootstrap("captureHierarchy", $$robo$$android_transition_Transition$captureHierarchy(android.view.View boolean ), 0, this, view, bl);
    }

    public TransitionValues getTransitionValues(View view, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getTransitionValues", $$robo$$android_transition_Transition$getTransitionValues(android.view.View boolean ), 0, this, view, bl);
    }

    TransitionValues getMatchedTransitionValues(View view, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getMatchedTransitionValues", $$robo$$android_transition_Transition$getMatchedTransitionValues(android.view.View boolean ), 0, this, view, bl);
    }

    public void pause(View view) {
        InvokeDynamicSupport.bootstrap("pause", $$robo$$android_transition_Transition$pause(android.view.View ), 0, this, view);
    }

    public void resume(View view) {
        InvokeDynamicSupport.bootstrap("resume", $$robo$$android_transition_Transition$resume(android.view.View ), 0, this, view);
    }

    void playTransition(ViewGroup viewGroup) {
        InvokeDynamicSupport.bootstrap("playTransition", $$robo$$android_transition_Transition$playTransition(android.view.ViewGroup ), 0, this, viewGroup);
    }

    public boolean isTransitionRequired(TransitionValues transitionValues, TransitionValues transitionValues2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isTransitionRequired", $$robo$$android_transition_Transition$isTransitionRequired(android.transition.TransitionValues android.transition.TransitionValues ), 0, this, transitionValues, transitionValues2);
    }

    private static boolean isValueChanged(TransitionValues transitionValues, TransitionValues transitionValues2, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValueChanged", $$robo$$android_transition_Transition$isValueChanged(android.transition.TransitionValues android.transition.TransitionValues java.lang.String ), 0, (TransitionValues)transitionValues, (TransitionValues)transitionValues2, (String)string2);
    }

    protected void animate(Animator animator2) {
        InvokeDynamicSupport.bootstrap("animate", $$robo$$android_transition_Transition$animate(android.animation.Animator ), 0, this, animator2);
    }

    protected void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_transition_Transition$start(), 0, this);
    }

    protected void end() {
        InvokeDynamicSupport.bootstrap("end", $$robo$$android_transition_Transition$end(), 0, this);
    }

    void forceToEnd(ViewGroup viewGroup) {
        InvokeDynamicSupport.bootstrap("forceToEnd", $$robo$$android_transition_Transition$forceToEnd(android.view.ViewGroup ), 0, this, viewGroup);
    }

    protected void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_transition_Transition$cancel(), 0, this);
    }

    public Transition addListener(TransitionListener transitionListener) {
        return InvokeDynamicSupport.bootstrap("addListener", $$robo$$android_transition_Transition$addListener(android.transition.Transition$TransitionListener ), 0, this, transitionListener);
    }

    public Transition removeListener(TransitionListener transitionListener) {
        return InvokeDynamicSupport.bootstrap("removeListener", $$robo$$android_transition_Transition$removeListener(android.transition.Transition$TransitionListener ), 0, this, transitionListener);
    }

    public void setEpicenterCallback(EpicenterCallback epicenterCallback) {
        InvokeDynamicSupport.bootstrap("setEpicenterCallback", $$robo$$android_transition_Transition$setEpicenterCallback(android.transition.Transition$EpicenterCallback ), 0, this, epicenterCallback);
    }

    public EpicenterCallback getEpicenterCallback() {
        return InvokeDynamicSupport.bootstrap("getEpicenterCallback", $$robo$$android_transition_Transition$getEpicenterCallback(), 0, this);
    }

    public Rect getEpicenter() {
        return InvokeDynamicSupport.bootstrap("getEpicenter", $$robo$$android_transition_Transition$getEpicenter(), 0, this);
    }

    public void setPathMotion(PathMotion pathMotion) {
        InvokeDynamicSupport.bootstrap("setPathMotion", $$robo$$android_transition_Transition$setPathMotion(android.transition.PathMotion ), 0, this, pathMotion);
    }

    public PathMotion getPathMotion() {
        return InvokeDynamicSupport.bootstrap("getPathMotion", $$robo$$android_transition_Transition$getPathMotion(), 0, this);
    }

    public void setPropagation(TransitionPropagation transitionPropagation) {
        InvokeDynamicSupport.bootstrap("setPropagation", $$robo$$android_transition_Transition$setPropagation(android.transition.TransitionPropagation ), 0, this, transitionPropagation);
    }

    public TransitionPropagation getPropagation() {
        return InvokeDynamicSupport.bootstrap("getPropagation", $$robo$$android_transition_Transition$getPropagation(), 0, this);
    }

    void capturePropagationValues(TransitionValues transitionValues) {
        InvokeDynamicSupport.bootstrap("capturePropagationValues", $$robo$$android_transition_Transition$capturePropagationValues(android.transition.TransitionValues ), 0, this, transitionValues);
    }

    Transition setSceneRoot(ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("setSceneRoot", $$robo$$android_transition_Transition$setSceneRoot(android.view.ViewGroup ), 0, this, viewGroup);
    }

    void setCanRemoveViews(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCanRemoveViews", $$robo$$android_transition_Transition$setCanRemoveViews(boolean ), 0, this, bl);
    }

    public boolean canRemoveViews() {
        return (boolean)InvokeDynamicSupport.bootstrap("canRemoveViews", $$robo$$android_transition_Transition$canRemoveViews(), 0, this);
    }

    public void setNameOverrides(ArrayMap<String, String> arrayMap) {
        InvokeDynamicSupport.bootstrap("setNameOverrides", $$robo$$android_transition_Transition$setNameOverrides(android.util.ArrayMap<java.lang.String, java.lang.String> ), 0, this, arrayMap);
    }

    public ArrayMap<String, String> getNameOverrides() {
        return InvokeDynamicSupport.bootstrap("getNameOverrides", $$robo$$android_transition_Transition$getNameOverrides(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_transition_Transition$toString(), 0, this);
    }

    public Transition clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_transition_Transition$clone(), 0, this);
    }

    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_transition_Transition$getName(), 0, this);
    }

    String toString(String string2) {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_transition_Transition$toString(java.lang.String ), 0, this, string2);
    }

    static {
        RobolectricInternals.classInitializing(Transition.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Transition)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class EpicenterCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_transition_Transition_EpicenterCallback$__constructor__() {
        }

        public abstract Rect onGetEpicenter(Transition var1);

        private void __constructor__() {
            this.$$robo$$android_transition_Transition_EpicenterCallback$__constructor__();
        }

        public EpicenterCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_Transition_EpicenterCallback$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EpicenterCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ArrayListManager
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_transition_Transition_ArrayListManager$__constructor__() {
        }

        private static final <T> ArrayList<T> $$robo$$android_transition_Transition_ArrayListManager$add(ArrayList<T> list, T item) {
            if (list == null) {
                list = new ArrayList();
            }
            if (!list.contains(item)) {
                list.add(item);
            }
            return list;
        }

        private static final <T> ArrayList<T> $$robo$$android_transition_Transition_ArrayListManager$remove(ArrayList<T> list, T item) {
            if (list != null) {
                list.remove(item);
                if (list.isEmpty()) {
                    list = null;
                }
            }
            return list;
        }

        private void __constructor__() {
            this.$$robo$$android_transition_Transition_ArrayListManager$__constructor__();
        }

        private ArrayListManager() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_Transition_ArrayListManager$__constructor__(), 0, this);
        }

        static <T> ArrayList<T> add(ArrayList<T> arrayList, T t) {
            return InvokeDynamicSupport.bootstrapStatic("add", $$robo$$android_transition_Transition_ArrayListManager$add(java.util.ArrayList<T> T ), 0, arrayList, t);
        }

        static <T> ArrayList<T> remove(ArrayList<T> arrayList, T t) {
            return InvokeDynamicSupport.bootstrapStatic("remove", $$robo$$android_transition_Transition_ArrayListManager$remove(java.util.ArrayList<T> T ), 0, arrayList, t);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ArrayListManager)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class AnimationInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public View view;
        String name;
        TransitionValues values;
        WindowId windowId;
        Transition transition;

        private void $$robo$$android_transition_Transition_AnimationInfo$__constructor__(View view, String name, Transition transition2, WindowId windowId, TransitionValues values) {
            this.view = view;
            this.name = name;
            this.values = values;
            this.windowId = windowId;
            this.transition = transition2;
        }

        private void __constructor__(View view, String string2, Transition transition2, WindowId windowId, TransitionValues transitionValues) {
            this.$$robo$$android_transition_Transition_AnimationInfo$__constructor__(view, string2, transition2, windowId, transitionValues);
        }

        AnimationInfo(View view, String string2, Transition transition2, WindowId windowId, TransitionValues transitionValues) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_Transition_AnimationInfo$__constructor__(android.view.View java.lang.String android.transition.Transition android.view.WindowId android.transition.TransitionValues ), 0, this, view, string2, transition2, windowId, transitionValues);
        }

        public /* synthetic */ AnimationInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimationInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface TransitionListener
    extends InstrumentedInterface {
        public void onTransitionStart(Transition var1);

        public void onTransitionEnd(Transition var1);

        public void onTransitionCancel(Transition var1);

        public void onTransitionPause(Transition var1);

        public void onTransitionResume(Transition var1);
    }
}

