/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import java.util.Arrays;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LongArray
implements Cloneable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int MIN_CAPACITY_INCREMENT = 12;
    private long[] mValues;
    private int mSize;

    private void $$robo$$android_util_LongArray$__constructor__(long[] array2, int size) {
        this.mValues = array2;
        this.mSize = Preconditions.checkArgumentInRange(size, 0, array2.length, "size");
    }

    private void $$robo$$android_util_LongArray$__constructor__() {
    }

    private void $$robo$$android_util_LongArray$__constructor__(int initialCapacity) {
        this.mValues = initialCapacity == 0 ? EmptyArray.LONG : ArrayUtils.newUnpaddedLongArray(initialCapacity);
        this.mSize = 0;
    }

    private static final LongArray $$robo$$android_util_LongArray$wrap(long[] array2) {
        return new LongArray(array2, array2.length);
    }

    private static final LongArray $$robo$$android_util_LongArray$fromArray(long[] array2, int size) {
        return LongArray.wrap(Arrays.copyOf(array2, size));
    }

    private final void $$robo$$android_util_LongArray$resize(int newSize) {
        Preconditions.checkArgumentNonnegative(newSize);
        if (newSize <= this.mValues.length) {
            Arrays.fill(this.mValues, newSize, this.mValues.length, 0L);
        } else {
            this.ensureCapacity(newSize - this.mSize);
        }
        this.mSize = newSize;
    }

    private final void $$robo$$android_util_LongArray$add(long value) {
        this.add(this.mSize, value);
    }

    private final void $$robo$$android_util_LongArray$add(int index, long value) {
        this.ensureCapacity(1);
        int rightSegment = this.mSize - index;
        ++this.mSize;
        this.checkBounds(index);
        if (rightSegment != 0) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (long[])this.mValues, (int)index, (long[])this.mValues, (int)(index + 1), (int)rightSegment);
        }
        this.mValues[index] = value;
    }

    private final void $$robo$$android_util_LongArray$addAll(LongArray values) {
        int count = values.mSize;
        this.ensureCapacity(count);
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (long[])values.mValues, (int)0, (long[])this.mValues, (int)this.mSize, (int)count);
        this.mSize += count;
    }

    private final void $$robo$$android_util_LongArray$ensureCapacity(int count) {
        int currentSize = this.mSize;
        int minCapacity = currentSize + count;
        if (minCapacity >= this.mValues.length) {
            int targetCap = currentSize + (currentSize < 6 ? 12 : currentSize >> 1);
            int newCapacity = targetCap > minCapacity ? targetCap : minCapacity;
            long[] newValues = ArrayUtils.newUnpaddedLongArray(newCapacity);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (long[])this.mValues, (int)0, (long[])newValues, (int)0, (int)currentSize);
            this.mValues = newValues;
        }
    }

    private final void $$robo$$android_util_LongArray$clear() {
        this.mSize = 0;
    }

    private final LongArray $$robo$$android_util_LongArray$clone() {
        LongArray clone = null;
        try {
            clone = (LongArray)super.clone();
            clone.mValues = (long[])this.mValues.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    private final long $$robo$$android_util_LongArray$get(int index) {
        this.checkBounds(index);
        return this.mValues[index];
    }

    private final void $$robo$$android_util_LongArray$set(int index, long value) {
        this.checkBounds(index);
        this.mValues[index] = value;
    }

    private final int $$robo$$android_util_LongArray$indexOf(long value) {
        int n = this.mSize;
        for (int i = 0; i < n; ++i) {
            if (this.mValues[i] != value) continue;
            return i;
        }
        return -1;
    }

    private final void $$robo$$android_util_LongArray$remove(int index) {
        this.checkBounds(index);
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (long[])this.mValues, (int)(index + 1), (long[])this.mValues, (int)index, (int)(this.mSize - index - 1));
        --this.mSize;
    }

    private final int $$robo$$android_util_LongArray$size() {
        return this.mSize;
    }

    private final long[] $$robo$$android_util_LongArray$toArray() {
        return Arrays.copyOf(this.mValues, this.mSize);
    }

    private final void $$robo$$android_util_LongArray$checkBounds(int index) {
        if (index < 0 || this.mSize <= index) {
            throw new ArrayIndexOutOfBoundsException(this.mSize, index);
        }
    }

    private void __constructor__(long[] lArray, int n) {
        this.$$robo$$android_util_LongArray$__constructor__(lArray, n);
    }

    private LongArray(long[] lArray, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_LongArray$__constructor__(long[] int ), 0, this, lArray, n);
    }

    private void __constructor__() {
        this.$$robo$$android_util_LongArray$__constructor__();
    }

    public LongArray() {
        this(10);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_LongArray$__constructor__(), 0, this);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_util_LongArray$__constructor__(n);
    }

    public LongArray(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_LongArray$__constructor__(int ), 0, this, n);
    }

    public static LongArray wrap(long[] lArray) {
        return InvokeDynamicSupport.bootstrapStatic("wrap", $$robo$$android_util_LongArray$wrap(long[] ), 0, (long[])lArray);
    }

    public static LongArray fromArray(long[] lArray, int n) {
        return InvokeDynamicSupport.bootstrapStatic("fromArray", $$robo$$android_util_LongArray$fromArray(long[] int ), 0, (long[])lArray, (int)n);
    }

    public void resize(int n) {
        InvokeDynamicSupport.bootstrap("resize", $$robo$$android_util_LongArray$resize(int ), 0, this, n);
    }

    public void add(long l) {
        InvokeDynamicSupport.bootstrap("add", $$robo$$android_util_LongArray$add(long ), 0, this, l);
    }

    public void add(int n, long l) {
        InvokeDynamicSupport.bootstrap("add", $$robo$$android_util_LongArray$add(int long ), 0, this, n, l);
    }

    public void addAll(LongArray longArray) {
        InvokeDynamicSupport.bootstrap("addAll", $$robo$$android_util_LongArray$addAll(android.util.LongArray ), 0, this, longArray);
    }

    private void ensureCapacity(int n) {
        InvokeDynamicSupport.bootstrap("ensureCapacity", $$robo$$android_util_LongArray$ensureCapacity(int ), 0, this, n);
    }

    public void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_util_LongArray$clear(), 0, this);
    }

    public LongArray clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_util_LongArray$clone(), 0, this);
    }

    public long get(int n) {
        return (long)InvokeDynamicSupport.bootstrap("get", $$robo$$android_util_LongArray$get(int ), 0, this, n);
    }

    public void set(int n, long l) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_util_LongArray$set(int long ), 0, this, n, l);
    }

    public int indexOf(long l) {
        return (int)InvokeDynamicSupport.bootstrap("indexOf", $$robo$$android_util_LongArray$indexOf(long ), 0, this, l);
    }

    public void remove(int n) {
        InvokeDynamicSupport.bootstrap("remove", $$robo$$android_util_LongArray$remove(int ), 0, this, n);
    }

    public int size() {
        return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_util_LongArray$size(), 0, this);
    }

    public long[] toArray() {
        return InvokeDynamicSupport.bootstrap("toArray", $$robo$$android_util_LongArray$toArray(), 0, this);
    }

    private void checkBounds(int n) {
        InvokeDynamicSupport.bootstrap("checkBounds", $$robo$$android_util_LongArray$checkBounds(int ), 0, this, n);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LongArray)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

