/*
 * Decompiled with CFR 0.152.
 */
package android.util.jar;

import android.util.jar.StrictJarManifest;
import android.util.jar.StrictJarManifestReader;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import sun.security.jca.Providers;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;

public class StrictJarVerifier
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String[] DIGEST_ALGORITHMS;
    private String jarName;
    private StrictJarManifest manifest;
    private HashMap<String, byte[]> metaEntries;
    private int mainAttributesEnd;
    private boolean signatureSchemeRollbackProtectionsEnforced;
    private Hashtable<String, HashMap<String, Attributes>> signatures;
    private Hashtable<String, Certificate[]> certificates;
    private Hashtable<String, Certificate[][]> verifiedEntries;

    private static final SecurityException $$robo$$android_util_jar_StrictJarVerifier$invalidDigest(String signatureFile, String name, String jarName) {
        throw new SecurityException(signatureFile + " has invalid digest for " + name + " in " + jarName);
    }

    private static final SecurityException $$robo$$android_util_jar_StrictJarVerifier$failedVerification(String jarName, String signatureFile) {
        throw new SecurityException(jarName + " failed verification of " + signatureFile);
    }

    private static final SecurityException $$robo$$android_util_jar_StrictJarVerifier$failedVerification(String jarName, String signatureFile, Throwable e) {
        throw new SecurityException(jarName + " failed verification of " + signatureFile, e);
    }

    private void $$robo$$android_util_jar_StrictJarVerifier$__constructor__(String name, StrictJarManifest manifest, HashMap<String, byte[]> metaEntries, boolean signatureSchemeRollbackProtectionsEnforced) {
        this.signatures = new Hashtable(5);
        this.certificates = new Hashtable(5);
        this.verifiedEntries = new Hashtable();
        this.jarName = name;
        this.manifest = manifest;
        this.metaEntries = metaEntries;
        this.mainAttributesEnd = manifest.getMainAttributesEnd();
        this.signatureSchemeRollbackProtectionsEnforced = signatureSchemeRollbackProtectionsEnforced;
    }

    private final VerifierEntry $$robo$$android_util_jar_StrictJarVerifier$initEntry(String name) {
        if (this.manifest == null || this.signatures.isEmpty()) {
            return null;
        }
        Attributes attributes = this.manifest.getAttributes(name);
        if (attributes == null) {
            return null;
        }
        ArrayList<Certificate[]> certChains = new ArrayList<Certificate[]>();
        for (Map.Entry<String, HashMap<String, Attributes>> entry : this.signatures.entrySet()) {
            String signatureFile;
            Certificate[] certChain;
            HashMap<String, Attributes> hm = entry.getValue();
            if (hm.get(name) == null || (certChain = this.certificates.get(signatureFile = entry.getKey())) == null) continue;
            certChains.add(certChain);
        }
        if (certChains.isEmpty()) {
            return null;
        }
        Certificate[][] certChainsArray = (Certificate[][])certChains.toArray((T[])new Certificate[certChains.size()][]);
        for (int i = 0; i < DIGEST_ALGORITHMS.length; ++i) {
            String algorithm = DIGEST_ALGORITHMS[i];
            String hash = attributes.getValue(algorithm + "-Digest");
            if (hash == null) continue;
            byte[] hashBytes = hash.getBytes(StandardCharsets.ISO_8859_1);
            try {
                return new VerifierEntry(name, MessageDigest.getInstance(algorithm), hashBytes, certChainsArray, this.verifiedEntries);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return null;
    }

    private final void $$robo$$android_util_jar_StrictJarVerifier$addMetaEntry(String name, byte[] buf) {
        this.metaEntries.put(name.toUpperCase(Locale.US), buf);
    }

    private final synchronized boolean $$robo$$android_util_jar_StrictJarVerifier$readCertificates() {
        if (this.metaEntries.isEmpty()) {
            return false;
        }
        Iterator<String> it = this.metaEntries.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            if (!key.endsWith(".DSA") && !key.endsWith(".RSA") && !key.endsWith(".EC")) continue;
            this.verifyCertificate(key);
            it.remove();
        }
        return true;
    }

    private static final Certificate[] $$robo$$android_util_jar_StrictJarVerifier$verifyBytes(byte[] blockBytes, byte[] sfBytes) throws GeneralSecurityException {
        Object obj = null;
        try {
            obj = Providers.startJarVerification();
            PKCS7 block = new PKCS7(blockBytes);
            SignerInfo[] verifiedSignerInfos = block.verify(sfBytes);
            if (verifiedSignerInfos == null || verifiedSignerInfos.length == 0) {
                throw new GeneralSecurityException("Failed to verify signature: no verified SignerInfos");
            }
            SignerInfo verifiedSignerInfo = verifiedSignerInfos[0];
            ArrayList<X509Certificate> verifiedSignerCertChain = verifiedSignerInfo.getCertificateChain(block);
            if (verifiedSignerCertChain == null) {
                throw new GeneralSecurityException("Failed to find verified SignerInfo certificate chain");
            }
            if (verifiedSignerCertChain.isEmpty()) {
                throw new GeneralSecurityException("Verified SignerInfo certificate chain is emtpy");
            }
            Certificate[] certificateArray = verifiedSignerCertChain.toArray(new X509Certificate[verifiedSignerCertChain.size()]);
            return certificateArray;
        }
        catch (IOException e) {
            throw new GeneralSecurityException("IO exception verifying jar cert", e);
        }
        finally {
            Providers.stopJarVerification(obj);
        }
    }

    private final void $$robo$$android_util_jar_StrictJarVerifier$verifyCertificate(String certFile) {
        String digestAttribute;
        String apkSignatureSchemeIdList;
        String signatureFile = certFile.substring(0, certFile.lastIndexOf(46)) + ".SF";
        byte[] sfBytes = this.metaEntries.get(signatureFile);
        if (sfBytes == null) {
            return;
        }
        byte[] manifestBytes = this.metaEntries.get("META-INF/MANIFEST.MF");
        if (manifestBytes == null) {
            return;
        }
        byte[] sBlockBytes = this.metaEntries.get(certFile);
        try {
            Certificate[] signerCertChain = StrictJarVerifier.verifyBytes(sBlockBytes, sfBytes);
            if (signerCertChain != null) {
                this.certificates.put(signatureFile, signerCertChain);
            }
        }
        catch (GeneralSecurityException e) {
            throw StrictJarVerifier.failedVerification(this.jarName, signatureFile, e);
        }
        Attributes attributes = new Attributes();
        HashMap<String, Attributes> entries = new HashMap<String, Attributes>();
        try {
            StrictJarManifestReader im = new StrictJarManifestReader(sfBytes, attributes);
            im.readEntries(entries, null);
        }
        catch (IOException e) {
            return;
        }
        if (this.signatureSchemeRollbackProtectionsEnforced && (apkSignatureSchemeIdList = attributes.getValue("X-Android-APK-Signed")) != null) {
            boolean v2SignatureGenerated = false;
            StringTokenizer tokenizer = new StringTokenizer(apkSignatureSchemeIdList, ",");
            while (tokenizer.hasMoreTokens()) {
                int id2;
                String idText = tokenizer.nextToken().trim();
                if (idText.isEmpty()) continue;
                try {
                    id2 = Integer.parseInt(idText);
                }
                catch (Exception ignored) {
                    continue;
                }
                if (id2 != 2) continue;
                v2SignatureGenerated = true;
                break;
            }
            if (v2SignatureGenerated) {
                throw new SecurityException(signatureFile + " indicates " + this.jarName + " is signed using APK Signature Scheme v2, but no such signature was" + " found. Signature stripped?");
            }
        }
        if (attributes.get(Attributes.Name.SIGNATURE_VERSION) == null) {
            return;
        }
        boolean createdBySigntool = false;
        String createdBy = attributes.getValue("Created-By");
        if (createdBy != null) {
            boolean bl = createdBySigntool = createdBy.indexOf("signtool") != -1;
        }
        if (this.mainAttributesEnd > 0 && !createdBySigntool && !this.verify(attributes, digestAttribute = "-Digest-Manifest-Main-Attributes", manifestBytes, 0, this.mainAttributesEnd, false, true)) {
            throw StrictJarVerifier.failedVerification(this.jarName, signatureFile);
        }
        String string2 = digestAttribute = createdBySigntool ? "-Digest" : "-Digest-Manifest";
        if (!this.verify(attributes, digestAttribute, manifestBytes, 0, manifestBytes.length, false, false)) {
            for (Map.Entry<String, Attributes> entry : entries.entrySet()) {
                StrictJarManifest.Chunk chunk = this.manifest.getChunk(entry.getKey());
                if (chunk == null) {
                    return;
                }
                if (this.verify(entry.getValue(), "-Digest", manifestBytes, chunk.start, chunk.end, createdBySigntool, false)) continue;
                throw StrictJarVerifier.invalidDigest(signatureFile, entry.getKey(), this.jarName);
            }
        }
        this.metaEntries.put(signatureFile, null);
        this.signatures.put(signatureFile, entries);
    }

    private final boolean $$robo$$android_util_jar_StrictJarVerifier$isSignedJar() {
        return this.certificates.size() > 0;
    }

    private final boolean $$robo$$android_util_jar_StrictJarVerifier$verify(Attributes attributes, String entry, byte[] data, int start, int end, boolean ignoreSecondEndline, boolean ignorable) {
        for (int i = 0; i < DIGEST_ALGORITHMS.length; ++i) {
            MessageDigest md;
            String algorithm = DIGEST_ALGORITHMS[i];
            String hash = attributes.getValue(algorithm + entry);
            if (hash == null) continue;
            try {
                md = MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                continue;
            }
            if (ignoreSecondEndline && data[end - 1] == 10 && data[end - 2] == 10) {
                md.update(data, start, end - 1 - start);
            } else {
                md.update(data, start, end - start);
            }
            byte[] b = md.digest();
            byte[] encodedHashBytes = hash.getBytes(StandardCharsets.ISO_8859_1);
            return StrictJarVerifier.verifyMessageDigest(b, encodedHashBytes);
        }
        return ignorable;
    }

    private static final boolean $$robo$$android_util_jar_StrictJarVerifier$verifyMessageDigest(byte[] expected, byte[] encodedActual) {
        byte[] actual;
        try {
            actual = Base64.getDecoder().decode(encodedActual);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return MessageDigest.isEqual(expected, actual);
    }

    private final Certificate[][] $$robo$$android_util_jar_StrictJarVerifier$getCertificateChains(String name) {
        return this.verifiedEntries.get(name);
    }

    private final void $$robo$$android_util_jar_StrictJarVerifier$removeMetaEntries() {
        this.metaEntries.clear();
    }

    static void __staticInitializer__() {
        DIGEST_ALGORITHMS = new String[]{"SHA-512", "SHA-384", "SHA-256", "SHA1"};
    }

    private static SecurityException invalidDigest(String string2, String string3, String string4) {
        return InvokeDynamicSupport.bootstrapStatic("invalidDigest", $$robo$$android_util_jar_StrictJarVerifier$invalidDigest(java.lang.String java.lang.String java.lang.String ), 0, (String)string2, (String)string3, (String)string4);
    }

    private static SecurityException failedVerification(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("failedVerification", $$robo$$android_util_jar_StrictJarVerifier$failedVerification(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    private static SecurityException failedVerification(String string2, String string3, Throwable throwable) {
        return InvokeDynamicSupport.bootstrapStatic("failedVerification", $$robo$$android_util_jar_StrictJarVerifier$failedVerification(java.lang.String java.lang.String java.lang.Throwable ), 0, (String)string2, (String)string3, (Throwable)throwable);
    }

    private void __constructor__(String string2, StrictJarManifest strictJarManifest, HashMap<String, byte[]> hashMap, boolean bl) {
        this.$$robo$$android_util_jar_StrictJarVerifier$__constructor__(string2, strictJarManifest, hashMap, bl);
    }

    StrictJarVerifier(String string2, StrictJarManifest strictJarManifest, HashMap<String, byte[]> hashMap, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_jar_StrictJarVerifier$__constructor__(java.lang.String android.util.jar.StrictJarManifest java.util.HashMap<java.lang.String, byte[]> boolean ), 0, this, string2, strictJarManifest, hashMap, bl);
    }

    VerifierEntry initEntry(String string2) {
        return InvokeDynamicSupport.bootstrap("initEntry", $$robo$$android_util_jar_StrictJarVerifier$initEntry(java.lang.String ), 0, this, string2);
    }

    void addMetaEntry(String string2, byte[] byArray) {
        InvokeDynamicSupport.bootstrap("addMetaEntry", $$robo$$android_util_jar_StrictJarVerifier$addMetaEntry(java.lang.String byte[] ), 0, this, string2, byArray);
    }

    synchronized boolean readCertificates() {
        return (boolean)InvokeDynamicSupport.bootstrap("readCertificates", $$robo$$android_util_jar_StrictJarVerifier$readCertificates(), 0, this);
    }

    static Certificate[] verifyBytes(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        return InvokeDynamicSupport.bootstrapStatic("verifyBytes", $$robo$$android_util_jar_StrictJarVerifier$verifyBytes(byte[] byte[] ), 0, (byte[])byArray, (byte[])byArray2);
    }

    private void verifyCertificate(String string2) {
        InvokeDynamicSupport.bootstrap("verifyCertificate", $$robo$$android_util_jar_StrictJarVerifier$verifyCertificate(java.lang.String ), 0, this, string2);
    }

    boolean isSignedJar() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSignedJar", $$robo$$android_util_jar_StrictJarVerifier$isSignedJar(), 0, this);
    }

    private boolean verify(Attributes attributes, String string2, byte[] byArray, int n, int n2, boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("verify", $$robo$$android_util_jar_StrictJarVerifier$verify(java.util.jar.Attributes java.lang.String byte[] int int boolean boolean ), 0, this, attributes, string2, byArray, n, n2, bl, bl2);
    }

    private static boolean verifyMessageDigest(byte[] byArray, byte[] byArray2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("verifyMessageDigest", $$robo$$android_util_jar_StrictJarVerifier$verifyMessageDigest(byte[] byte[] ), 0, (byte[])byArray, (byte[])byArray2);
    }

    Certificate[][] getCertificateChains(String string2) {
        return InvokeDynamicSupport.bootstrap("getCertificateChains", $$robo$$android_util_jar_StrictJarVerifier$getCertificateChains(java.lang.String ), 0, this, string2);
    }

    void removeMetaEntries() {
        InvokeDynamicSupport.bootstrap("removeMetaEntries", $$robo$$android_util_jar_StrictJarVerifier$removeMetaEntries(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(StrictJarVerifier.class);
    }

    public /* synthetic */ StrictJarVerifier() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StrictJarVerifier)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class VerifierEntry
    extends OutputStream
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String name;
        private MessageDigest digest;
        private byte[] hash;
        private Certificate[][] certChains;
        private Hashtable<String, Certificate[][]> verifiedEntries;

        private void $$robo$$android_util_jar_StrictJarVerifier_VerifierEntry$__constructor__(String name, MessageDigest digest, byte[] hash, Certificate[][] certChains, Hashtable<String, Certificate[][]> verifedEntries) {
            this.name = name;
            this.digest = digest;
            this.hash = hash;
            this.certChains = certChains;
            this.verifiedEntries = verifedEntries;
        }

        private final void $$robo$$android_util_jar_StrictJarVerifier_VerifierEntry$write(int value) {
            this.digest.update((byte)value);
        }

        private final void $$robo$$android_util_jar_StrictJarVerifier_VerifierEntry$write(byte[] buf, int off, int nbytes) {
            this.digest.update(buf, off, nbytes);
        }

        private final void $$robo$$android_util_jar_StrictJarVerifier_VerifierEntry$verify() {
            byte[] d = this.digest.digest();
            if (!StrictJarVerifier.verifyMessageDigest(d, this.hash)) {
                throw StrictJarVerifier.invalidDigest("META-INF/MANIFEST.MF", this.name, this.name);
            }
            this.verifiedEntries.put(this.name, this.certChains);
        }

        private void __constructor__(String string2, MessageDigest messageDigest, byte[] byArray, Certificate[][] certificateArray, Hashtable<String, Certificate[][]> hashtable) {
            this.$$robo$$android_util_jar_StrictJarVerifier_VerifierEntry$__constructor__(string2, messageDigest, byArray, certificateArray, hashtable);
        }

        VerifierEntry(String string2, MessageDigest messageDigest, byte[] byArray, Certificate[][] certificateArray, Hashtable<String, Certificate[][]> hashtable) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_jar_StrictJarVerifier_VerifierEntry$__constructor__(java.lang.String java.security.MessageDigest byte[] java.security.cert.Certificate[][] java.util.Hashtable<java.lang.String, java.security.cert.Certificate[][]> ), 0, this, string2, messageDigest, byArray, certificateArray, hashtable);
        }

        @Override
        public void write(int n) {
            InvokeDynamicSupport.bootstrap("write", $$robo$$android_util_jar_StrictJarVerifier_VerifierEntry$write(int ), 0, this, n);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            InvokeDynamicSupport.bootstrap("write", $$robo$$android_util_jar_StrictJarVerifier_VerifierEntry$write(byte[] int int ), 0, this, byArray, n, n2);
        }

        void verify() {
            InvokeDynamicSupport.bootstrap("verify", $$robo$$android_util_jar_StrictJarVerifier_VerifierEntry$verify(), 0, this);
        }

        public /* synthetic */ VerifierEntry() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VerifierEntry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

