/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.ValueAnimator;
import android.app.ActivityManager;
import android.content.Context;
import android.content.res.Configuration;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.util.ArraySet;
import android.util.Log;
import android.view.Display;
import android.view.IWindowManager;
import android.view.IWindowSession;
import android.view.IWindowSessionCallback;
import android.view.ThreadedRenderer;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import android.view.Window;
import android.view.WindowLeaked;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import com.android.internal.util.FastPrintWriter;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class WindowManagerGlobal
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "WindowManager";
    public static int RELAYOUT_RES_IN_TOUCH_MODE = 1;
    public static int RELAYOUT_RES_FIRST_TIME = 2;
    public static int RELAYOUT_RES_SURFACE_CHANGED = 4;
    public static int RELAYOUT_RES_DRAG_RESIZING_DOCKED = 8;
    public static int RELAYOUT_RES_DRAG_RESIZING_FREEFORM = 16;
    public static int RELAYOUT_RES_SURFACE_RESIZED = 32;
    public static int RELAYOUT_RES_CONSUME_ALWAYS_NAV_BAR = 64;
    public static int RELAYOUT_INSETS_PENDING = 1;
    public static int RELAYOUT_DEFER_SURFACE_DESTROY = 2;
    public static int ADD_FLAG_APP_VISIBLE = 2;
    public static int ADD_FLAG_IN_TOUCH_MODE = 1;
    public static int ADD_FLAG_ALWAYS_CONSUME_NAV_BAR = 4;
    public static int ADD_OKAY = 0;
    public static int ADD_BAD_APP_TOKEN = -1;
    public static int ADD_BAD_SUBWINDOW_TOKEN = -2;
    public static int ADD_NOT_APP_TOKEN = -3;
    public static int ADD_APP_EXITING = -4;
    public static int ADD_DUPLICATE_ADD = -5;
    public static int ADD_STARTING_NOT_NEEDED = -6;
    public static int ADD_MULTIPLE_SINGLETON = -7;
    public static int ADD_PERMISSION_DENIED = -8;
    public static int ADD_INVALID_DISPLAY = -9;
    public static int ADD_INVALID_TYPE = -10;
    private static WindowManagerGlobal sDefaultWindowManager;
    private static IWindowManager sWindowManagerService;
    private static IWindowSession sWindowSession;
    private Object mLock;
    private ArrayList<View> mViews;
    private ArrayList<ViewRootImpl> mRoots;
    private ArrayList<WindowManager.LayoutParams> mParams;
    private ArraySet<View> mDyingViews;
    private Runnable mSystemPropertyUpdater;

    private void $$robo$$android_view_WindowManagerGlobal$__constructor__() {
        this.mLock = new Object();
        this.mViews = new ArrayList();
        this.mRoots = new ArrayList();
        this.mParams = new ArrayList();
        this.mDyingViews = new ArraySet();
    }

    private static final void $$robo$$android_view_WindowManagerGlobal$initialize() {
        WindowManagerGlobal.getWindowManagerService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final WindowManagerGlobal $$robo$$android_view_WindowManagerGlobal$getInstance() {
        Class<WindowManagerGlobal> clazz = WindowManagerGlobal.class;
        synchronized (WindowManagerGlobal.class) {
            if (sDefaultWindowManager == null) {
                sDefaultWindowManager = new WindowManagerGlobal();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sDefaultWindowManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final IWindowManager $$robo$$android_view_WindowManagerGlobal$getWindowManagerService() {
        Class<WindowManagerGlobal> clazz = WindowManagerGlobal.class;
        synchronized (WindowManagerGlobal.class) {
            if (sWindowManagerService == null) {
                sWindowManagerService = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
                try {
                    if (sWindowManagerService != null) {
                        ValueAnimator.setDurationScale(sWindowManagerService.getCurrentAnimatorScale());
                    }
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sWindowManagerService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final IWindowSession $$robo$$android_view_WindowManagerGlobal$getWindowSession() {
        Class<WindowManagerGlobal> clazz = WindowManagerGlobal.class;
        synchronized (WindowManagerGlobal.class) {
            if (sWindowSession == null) {
                try {
                    InputMethodManager imm = InputMethodManager.getInstance();
                    IWindowManager windowManager = WindowManagerGlobal.getWindowManagerService();
                    sWindowSession = windowManager.openSession((IWindowSessionCallback)new ShadowedObject(){
                        public transient /* synthetic */ Object __robo_data__;

                        private void $$robo$$android_view_WindowManagerGlobal_1$__constructor__() {
                        }

                        private final void $$robo$$android_view_WindowManagerGlobal_1$onAnimatorScaleChanged(float scale) {
                            ValueAnimator.setDurationScale(scale);
                        }

                        private void __constructor__() {
                            this.$$robo$$android_view_WindowManagerGlobal_1$__constructor__();
                        }
                        {
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_WindowManagerGlobal_1$__constructor__(), 0, this);
                        }

                        @Override
                        public void onAnimatorScaleChanged(float f) {
                            InvokeDynamicSupport.bootstrap("onAnimatorScaleChanged", $$robo$$android_view_WindowManagerGlobal_1$onAnimatorScaleChanged(float ), 0, this, f);
                        }

                        @Override
                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        @Override
                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    }, imm.getClient(), imm.getInputContext());
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sWindowSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final IWindowSession $$robo$$android_view_WindowManagerGlobal$peekWindowSession() {
        Class<WindowManagerGlobal> clazz = WindowManagerGlobal.class;
        synchronized (WindowManagerGlobal.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sWindowSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String[] $$robo$$android_view_WindowManagerGlobal$getViewRootNames() {
        Object object = this.mLock;
        synchronized (object) {
            int numRoots = this.mRoots.size();
            String[] mViewRoots = new String[numRoots];
            for (int i = 0; i < numRoots; ++i) {
                mViewRoots[i] = WindowManagerGlobal.getWindowName(this.mRoots.get(i));
            }
            return mViewRoots;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ArrayList<ViewRootImpl> $$robo$$android_view_WindowManagerGlobal$getRootViews(IBinder token) {
        ArrayList<ViewRootImpl> views = new ArrayList<ViewRootImpl>();
        Object object = this.mLock;
        synchronized (object) {
            int numRoots = this.mRoots.size();
            for (int i = 0; i < numRoots; ++i) {
                WindowManager.LayoutParams params = this.mParams.get(i);
                if (params.token == null) continue;
                if (params.token != token) {
                    boolean isChild = false;
                    if (params.type >= 1000 && params.type <= 1999) {
                        for (int j = 0; j < numRoots; ++j) {
                            View viewj = this.mViews.get(j);
                            WindowManager.LayoutParams paramsj = this.mParams.get(j);
                            if (params.token != viewj.getWindowToken() || paramsj.token != token) continue;
                            isChild = true;
                            break;
                        }
                    }
                    if (!isChild) continue;
                }
                views.add(this.mRoots.get(i));
            }
        }
        return views;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final View $$robo$$android_view_WindowManagerGlobal$getWindowView(IBinder windowToken) {
        Object object = this.mLock;
        synchronized (object) {
            int numViews = this.mViews.size();
            for (int i = 0; i < numViews; ++i) {
                View view = this.mViews.get(i);
                if (view.getWindowToken() != windowToken) continue;
                return view;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final View $$robo$$android_view_WindowManagerGlobal$getRootView(String name) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mRoots.size() - 1; i >= 0; --i) {
                ViewRootImpl root = this.mRoots.get(i);
                if (!name.equals(WindowManagerGlobal.getWindowName(root))) continue;
                return root.getView();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_WindowManagerGlobal$addView(View view, ViewGroup.LayoutParams params, Display display, Window parentWindow) {
        if (view == null) {
            throw new IllegalArgumentException("view must not be null");
        }
        if (display == null) {
            throw new IllegalArgumentException("display must not be null");
        }
        if (!(params instanceof WindowManager.LayoutParams)) {
            throw new IllegalArgumentException("Params must be WindowManager.LayoutParams");
        }
        WindowManager.LayoutParams wparams = (WindowManager.LayoutParams)params;
        if (parentWindow != null) {
            parentWindow.adjustLayoutParamsForSubWindow(wparams);
        } else {
            Context context = view.getContext();
            if (context != null && (context.getApplicationInfo().flags & 0x20000000) != 0) {
                wparams.flags |= 0x1000000;
            }
        }
        View panelParentView = null;
        Object object = this.mLock;
        synchronized (object) {
            int index;
            if (this.mSystemPropertyUpdater == null) {
                this.mSystemPropertyUpdater = new Runnable(this){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ WindowManagerGlobal this$0;

                    private void $$robo$$android_view_WindowManagerGlobal_2$__constructor__(WindowManagerGlobal this$0) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private final void $$robo$$android_view_WindowManagerGlobal_2$run() {
                        Object object = this.this$0.mLock;
                        synchronized (object) {
                            for (int i = this.this$0.mRoots.size() - 1; i >= 0; --i) {
                                ((ViewRootImpl)this.this$0.mRoots.get(i)).loadSystemProperties();
                            }
                        }
                    }

                    private void __constructor__(WindowManagerGlobal windowManagerGlobal) {
                        this.$$robo$$android_view_WindowManagerGlobal_2$__constructor__(windowManagerGlobal);
                    }
                    {
                        this.this$0 = windowManagerGlobal;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_WindowManagerGlobal_2$__constructor__(android.view.WindowManagerGlobal ), 0, this, windowManagerGlobal);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_view_WindowManagerGlobal_2$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
                SystemProperties.addChangeCallback(this.mSystemPropertyUpdater);
            }
            if ((index = this.findViewLocked(view, false)) >= 0) {
                if (this.mDyingViews.contains(view)) {
                    this.mRoots.get(index).doDie();
                } else {
                    throw new IllegalStateException("View " + view + " has already been added to the window manager.");
                }
            }
            if (wparams.type >= 1000 && wparams.type <= 1999) {
                int count = this.mViews.size();
                for (int i = 0; i < count; ++i) {
                    if (this.mRoots.get((int)i).mWindow.asBinder() != wparams.token) continue;
                    panelParentView = this.mViews.get(i);
                }
            }
            ViewRootImpl root = new ViewRootImpl(view.getContext(), display);
            view.setLayoutParams(wparams);
            this.mViews.add(view);
            this.mRoots.add(root);
            this.mParams.add(wparams);
            try {
                root.setView(view, wparams, panelParentView);
            }
            catch (RuntimeException e) {
                if (index >= 0) {
                    this.removeViewLocked(index, true);
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_WindowManagerGlobal$updateViewLayout(View view, ViewGroup.LayoutParams params) {
        if (view == null) {
            throw new IllegalArgumentException("view must not be null");
        }
        if (!(params instanceof WindowManager.LayoutParams)) {
            throw new IllegalArgumentException("Params must be WindowManager.LayoutParams");
        }
        WindowManager.LayoutParams wparams = (WindowManager.LayoutParams)params;
        view.setLayoutParams(wparams);
        Object object = this.mLock;
        synchronized (object) {
            int index = this.findViewLocked(view, true);
            ViewRootImpl root = this.mRoots.get(index);
            this.mParams.remove(index);
            this.mParams.add(index, wparams);
            root.setLayoutParams(wparams, false);
        }
    }

    private final void $$robo$$android_view_WindowManagerGlobal$removeView(View view, boolean immediate) {
        if (view == null) {
            throw new IllegalArgumentException("view must not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            int index = this.findViewLocked(view, true);
            View curView = this.mRoots.get(index).getView();
            this.removeViewLocked(index, immediate);
            if (curView == view) {
                return;
            }
            throw new IllegalStateException("Calling with view " + view + " but the ViewAncestor is attached to " + curView);
        }
    }

    private final void $$robo$$android_view_WindowManagerGlobal$closeAll(IBinder token, String who, String what) {
        this.closeAllExceptView(token, null, who, what);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_WindowManagerGlobal$closeAllExceptView(IBinder token, View view, String who, String what) {
        Object object = this.mLock;
        synchronized (object) {
            int count = this.mViews.size();
            for (int i = 0; i < count; ++i) {
                if (view != null && this.mViews.get(i) == view || token != null && this.mParams.get((int)i).token != token) continue;
                ViewRootImpl root = this.mRoots.get(i);
                if (who != null) {
                    WindowLeaked leak = new WindowLeaked(what + " " + who + " has leaked window " + root.getView() + " that was originally added here");
                    leak.setStackTrace(root.getLocation().getStackTrace());
                    Log.e("WindowManager", "", leak);
                }
                this.removeViewLocked(i, false);
            }
        }
    }

    private final void $$robo$$android_view_WindowManagerGlobal$removeViewLocked(int index, boolean immediate) {
        InputMethodManager imm;
        ViewRootImpl root = this.mRoots.get(index);
        View view = root.getView();
        if (view != null && (imm = InputMethodManager.getInstance()) != null) {
            imm.windowDismissed(this.mViews.get(index).getWindowToken());
        }
        boolean deferred = root.die(immediate);
        if (view != null) {
            view.assignParent(null);
            if (deferred) {
                this.mDyingViews.add(view);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_WindowManagerGlobal$doRemoveView(ViewRootImpl root) {
        Object object = this.mLock;
        synchronized (object) {
            int index = this.mRoots.indexOf(root);
            if (index >= 0) {
                this.mRoots.remove(index);
                this.mParams.remove(index);
                View view = this.mViews.remove(index);
                this.mDyingViews.remove(view);
            }
        }
        if (ThreadedRenderer.sTrimForeground && ThreadedRenderer.isAvailable()) {
            this.doTrimForeground();
        }
    }

    private final int $$robo$$android_view_WindowManagerGlobal$findViewLocked(View view, boolean required) {
        int index = this.mViews.indexOf(view);
        if (required && index < 0) {
            throw new IllegalArgumentException("View=" + view + " not attached to window manager");
        }
        return index;
    }

    private static final boolean $$robo$$android_view_WindowManagerGlobal$shouldDestroyEglContext(int trimLevel) {
        if (trimLevel >= 80) {
            return true;
        }
        return trimLevel >= 60 && !ActivityManager.isHighEndGfx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_WindowManagerGlobal$trimMemory(int level) {
        if (ThreadedRenderer.isAvailable()) {
            if (WindowManagerGlobal.shouldDestroyEglContext(level)) {
                Object object = this.mLock;
                synchronized (object) {
                    for (int i = this.mRoots.size() - 1; i >= 0; --i) {
                        this.mRoots.get(i).destroyHardwareResources();
                    }
                }
                level = 80;
            }
            ThreadedRenderer.trimMemory(level);
            if (ThreadedRenderer.sTrimForeground) {
                this.doTrimForeground();
            }
        }
    }

    private static final void $$robo$$android_view_WindowManagerGlobal$trimForeground() {
        if (ThreadedRenderer.sTrimForeground && ThreadedRenderer.isAvailable()) {
            WindowManagerGlobal wm = WindowManagerGlobal.getInstance();
            wm.doTrimForeground();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_WindowManagerGlobal$doTrimForeground() {
        boolean hasVisibleWindows = false;
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mRoots.size() - 1; i >= 0; --i) {
                ViewRootImpl root = this.mRoots.get(i);
                if (root.mView != null && root.getHostVisibility() == 0 && root.mAttachInfo.mThreadedRenderer != null) {
                    hasVisibleWindows = true;
                    continue;
                }
                root.destroyHardwareResources();
            }
        }
        if (!hasVisibleWindows) {
            ThreadedRenderer.trimMemory(80);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_WindowManagerGlobal$dumpGfxInfo(FileDescriptor fd, String[] args) {
        FileOutputStream fout = new FileOutputStream(fd);
        FastPrintWriter pw = new FastPrintWriter(fout);
        try {
            Object object = this.mLock;
            synchronized (object) {
                int count = this.mViews.size();
                pw.println("Profile data in ms:");
                for (int i = 0; i < count; ++i) {
                    ViewRootImpl root = this.mRoots.get(i);
                    String name = WindowManagerGlobal.getWindowName(root);
                    pw.printf("\n\t%s (visibility=%d)", name, root.getHostVisibility());
                    ThreadedRenderer renderer = root.getView().mAttachInfo.mThreadedRenderer;
                    if (renderer == null) continue;
                    renderer.dumpGfxInfo(pw, fd, args);
                }
                pw.println("\nView hierarchy:\n");
                int viewsCount = 0;
                int displayListsSize = 0;
                int[] info = new int[2];
                for (int i = 0; i < count; ++i) {
                    ViewRootImpl root = this.mRoots.get(i);
                    root.dumpGfxInfo(info);
                    String name = WindowManagerGlobal.getWindowName(root);
                    pw.printf("  %s\n  %d views, %.2f kB of display lists", name, info[0], Float.valueOf((float)info[1] / 1024.0f));
                    pw.printf("\n\n", new Object[0]);
                    viewsCount += info[0];
                    displayListsSize += info[1];
                }
                pw.printf("\nTotal ViewRootImpl: %d\n", count);
                pw.printf("Total Views:        %d\n", viewsCount);
                pw.printf("Total DisplayList:  %.2f kB\n\n", Float.valueOf((float)displayListsSize / 1024.0f));
            }
        }
        finally {
            ((PrintWriter)pw).flush();
        }
    }

    private static final String $$robo$$android_view_WindowManagerGlobal$getWindowName(ViewRootImpl root) {
        return root.mWindowAttributes.getTitle() + "/" + root.getClass().getName() + '@' + Integer.toHexString(root.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_WindowManagerGlobal$setStoppedState(IBinder token, boolean stopped) {
        Object object = this.mLock;
        synchronized (object) {
            int count = this.mViews.size();
            for (int i = 0; i < count; ++i) {
                if (token != null && this.mParams.get((int)i).token != token) continue;
                ViewRootImpl root = this.mRoots.get(i);
                root.setWindowStopped(stopped);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_WindowManagerGlobal$reportNewConfiguration(Configuration config) {
        Object object = this.mLock;
        synchronized (object) {
            int count = this.mViews.size();
            config = new Configuration(config);
            for (int i = 0; i < count; ++i) {
                ViewRootImpl root = this.mRoots.get(i);
                root.requestUpdateConfiguration(config);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_WindowManagerGlobal$changeCanvasOpacity(IBinder token, boolean opaque) {
        if (token == null) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mParams.size() - 1; i >= 0; --i) {
                if (this.mParams.get((int)i).token != token) continue;
                this.mRoots.get(i).changeCanvasOpacity(opaque);
                return;
            }
        }
    }

    private void __constructor__() {
        this.$$robo$$android_view_WindowManagerGlobal$__constructor__();
    }

    private WindowManagerGlobal() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_WindowManagerGlobal$__constructor__(), 0, this);
    }

    public static void initialize() {
        InvokeDynamicSupport.bootstrapStatic("initialize", $$robo$$android_view_WindowManagerGlobal$initialize(), 0);
    }

    public static WindowManagerGlobal getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_view_WindowManagerGlobal$getInstance(), 0);
    }

    public static IWindowManager getWindowManagerService() {
        return InvokeDynamicSupport.bootstrapStatic("getWindowManagerService", $$robo$$android_view_WindowManagerGlobal$getWindowManagerService(), 0);
    }

    public static IWindowSession getWindowSession() {
        return InvokeDynamicSupport.bootstrapStatic("getWindowSession", $$robo$$android_view_WindowManagerGlobal$getWindowSession(), 0);
    }

    public static IWindowSession peekWindowSession() {
        return InvokeDynamicSupport.bootstrapStatic("peekWindowSession", $$robo$$android_view_WindowManagerGlobal$peekWindowSession(), 0);
    }

    public String[] getViewRootNames() {
        return InvokeDynamicSupport.bootstrap("getViewRootNames", $$robo$$android_view_WindowManagerGlobal$getViewRootNames(), 0, this);
    }

    public ArrayList<ViewRootImpl> getRootViews(IBinder iBinder) {
        return InvokeDynamicSupport.bootstrap("getRootViews", $$robo$$android_view_WindowManagerGlobal$getRootViews(android.os.IBinder ), 0, this, iBinder);
    }

    public View getWindowView(IBinder iBinder) {
        return InvokeDynamicSupport.bootstrap("getWindowView", $$robo$$android_view_WindowManagerGlobal$getWindowView(android.os.IBinder ), 0, this, iBinder);
    }

    public View getRootView(String string2) {
        return InvokeDynamicSupport.bootstrap("getRootView", $$robo$$android_view_WindowManagerGlobal$getRootView(java.lang.String ), 0, this, string2);
    }

    public void addView(View view, ViewGroup.LayoutParams layoutParams, Display display, Window window) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_view_WindowManagerGlobal$addView(android.view.View android.view.ViewGroup$LayoutParams android.view.Display android.view.Window ), 0, this, view, layoutParams, display, window);
    }

    public void updateViewLayout(View view, ViewGroup.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("updateViewLayout", $$robo$$android_view_WindowManagerGlobal$updateViewLayout(android.view.View android.view.ViewGroup$LayoutParams ), 0, this, view, layoutParams);
    }

    public void removeView(View view, boolean bl) {
        InvokeDynamicSupport.bootstrap("removeView", $$robo$$android_view_WindowManagerGlobal$removeView(android.view.View boolean ), 0, this, view, bl);
    }

    public void closeAll(IBinder iBinder, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("closeAll", $$robo$$android_view_WindowManagerGlobal$closeAll(android.os.IBinder java.lang.String java.lang.String ), 0, this, iBinder, string2, string3);
    }

    public void closeAllExceptView(IBinder iBinder, View view, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("closeAllExceptView", $$robo$$android_view_WindowManagerGlobal$closeAllExceptView(android.os.IBinder android.view.View java.lang.String java.lang.String ), 0, this, iBinder, view, string2, string3);
    }

    private void removeViewLocked(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("removeViewLocked", $$robo$$android_view_WindowManagerGlobal$removeViewLocked(int boolean ), 0, this, n, bl);
    }

    void doRemoveView(ViewRootImpl viewRootImpl) {
        InvokeDynamicSupport.bootstrap("doRemoveView", $$robo$$android_view_WindowManagerGlobal$doRemoveView(android.view.ViewRootImpl ), 0, this, viewRootImpl);
    }

    private int findViewLocked(View view, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("findViewLocked", $$robo$$android_view_WindowManagerGlobal$findViewLocked(android.view.View boolean ), 0, this, view, bl);
    }

    public static boolean shouldDestroyEglContext(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("shouldDestroyEglContext", $$robo$$android_view_WindowManagerGlobal$shouldDestroyEglContext(int ), 0, (int)n);
    }

    public void trimMemory(int n) {
        InvokeDynamicSupport.bootstrap("trimMemory", $$robo$$android_view_WindowManagerGlobal$trimMemory(int ), 0, this, n);
    }

    public static void trimForeground() {
        InvokeDynamicSupport.bootstrapStatic("trimForeground", $$robo$$android_view_WindowManagerGlobal$trimForeground(), 0);
    }

    private void doTrimForeground() {
        InvokeDynamicSupport.bootstrap("doTrimForeground", $$robo$$android_view_WindowManagerGlobal$doTrimForeground(), 0, this);
    }

    public void dumpGfxInfo(FileDescriptor fileDescriptor, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dumpGfxInfo", $$robo$$android_view_WindowManagerGlobal$dumpGfxInfo(java.io.FileDescriptor java.lang.String[] ), 0, this, fileDescriptor, stringArray);
    }

    private static String getWindowName(ViewRootImpl viewRootImpl) {
        return InvokeDynamicSupport.bootstrapStatic("getWindowName", $$robo$$android_view_WindowManagerGlobal$getWindowName(android.view.ViewRootImpl ), 0, (ViewRootImpl)viewRootImpl);
    }

    public void setStoppedState(IBinder iBinder, boolean bl) {
        InvokeDynamicSupport.bootstrap("setStoppedState", $$robo$$android_view_WindowManagerGlobal$setStoppedState(android.os.IBinder boolean ), 0, this, iBinder, bl);
    }

    public void reportNewConfiguration(Configuration configuration) {
        InvokeDynamicSupport.bootstrap("reportNewConfiguration", $$robo$$android_view_WindowManagerGlobal$reportNewConfiguration(android.content.res.Configuration ), 0, this, configuration);
    }

    public void changeCanvasOpacity(IBinder iBinder, boolean bl) {
        InvokeDynamicSupport.bootstrap("changeCanvasOpacity", $$robo$$android_view_WindowManagerGlobal$changeCanvasOpacity(android.os.IBinder boolean ), 0, this, iBinder, bl);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WindowManagerGlobal)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

