/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.LayoutAnimationController;
import android.view.animation.LinearInterpolator;
import com.android.internal.R;
import java.util.Random;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GridLayoutAnimationController
extends LayoutAnimationController
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int DIRECTION_LEFT_TO_RIGHT = 0;
    public static int DIRECTION_RIGHT_TO_LEFT = 1;
    public static int DIRECTION_TOP_TO_BOTTOM = 0;
    public static int DIRECTION_BOTTOM_TO_TOP = 2;
    public static int DIRECTION_HORIZONTAL_MASK = 1;
    public static int DIRECTION_VERTICAL_MASK = 2;
    public static int PRIORITY_NONE = 0;
    public static int PRIORITY_COLUMN = 1;
    public static int PRIORITY_ROW = 2;
    private float mColumnDelay;
    private float mRowDelay;
    private int mDirection;
    private int mDirectionPriority;

    private void $$robo$$android_view_animation_GridLayoutAnimationController$__constructor__(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.GridLayoutAnimation);
        Animation.Description d = Animation.Description.parseValue(a.peekValue(0));
        this.mColumnDelay = d.value;
        d = Animation.Description.parseValue(a.peekValue(1));
        this.mRowDelay = d.value;
        this.mDirection = a.getInt(2, 0);
        this.mDirectionPriority = a.getInt(3, 0);
        a.recycle();
    }

    private void $$robo$$android_view_animation_GridLayoutAnimationController$__constructor__(Animation animation) {
    }

    private void $$robo$$android_view_animation_GridLayoutAnimationController$__constructor__(Animation animation, float columnDelay, float rowDelay) {
        this.mColumnDelay = columnDelay;
        this.mRowDelay = rowDelay;
    }

    private final float $$robo$$android_view_animation_GridLayoutAnimationController$getColumnDelay() {
        return this.mColumnDelay;
    }

    private final void $$robo$$android_view_animation_GridLayoutAnimationController$setColumnDelay(float columnDelay) {
        this.mColumnDelay = columnDelay;
    }

    private final float $$robo$$android_view_animation_GridLayoutAnimationController$getRowDelay() {
        return this.mRowDelay;
    }

    private final void $$robo$$android_view_animation_GridLayoutAnimationController$setRowDelay(float rowDelay) {
        this.mRowDelay = rowDelay;
    }

    private final int $$robo$$android_view_animation_GridLayoutAnimationController$getDirection() {
        return this.mDirection;
    }

    private final void $$robo$$android_view_animation_GridLayoutAnimationController$setDirection(int direction) {
        this.mDirection = direction;
    }

    private final int $$robo$$android_view_animation_GridLayoutAnimationController$getDirectionPriority() {
        return this.mDirectionPriority;
    }

    private final void $$robo$$android_view_animation_GridLayoutAnimationController$setDirectionPriority(int directionPriority) {
        this.mDirectionPriority = directionPriority;
    }

    private final boolean $$robo$$android_view_animation_GridLayoutAnimationController$willOverlap() {
        return this.mColumnDelay < 1.0f || this.mRowDelay < 1.0f;
    }

    private final long $$robo$$android_view_animation_GridLayoutAnimationController$getDelayForView(View view) {
        float totalDelay;
        long viewDelay;
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        AnimationParameters params = (AnimationParameters)lp.layoutAnimationParameters;
        if (params == null) {
            return 0L;
        }
        int column = this.getTransformedColumnIndex(params);
        int row = this.getTransformedRowIndex(params);
        int rowsCount = params.rowsCount;
        int columnsCount = params.columnsCount;
        long duration = this.mAnimation.getDuration();
        float columnDelay = this.mColumnDelay * (float)duration;
        float rowDelay = this.mRowDelay * (float)duration;
        if (this.mInterpolator == null) {
            this.mInterpolator = new LinearInterpolator();
        }
        switch (this.mDirectionPriority) {
            case 1: {
                viewDelay = (long)((float)row * rowDelay + (float)(column * rowsCount) * rowDelay);
                totalDelay = (float)rowsCount * rowDelay + (float)(columnsCount * rowsCount) * rowDelay;
                break;
            }
            case 2: {
                viewDelay = (long)((float)column * columnDelay + (float)(row * columnsCount) * columnDelay);
                totalDelay = (float)columnsCount * columnDelay + (float)(rowsCount * columnsCount) * columnDelay;
                break;
            }
            default: {
                viewDelay = (long)((float)column * columnDelay + (float)row * rowDelay);
                totalDelay = (float)columnsCount * columnDelay + (float)rowsCount * rowDelay;
            }
        }
        float normalizedDelay = (float)viewDelay / totalDelay;
        normalizedDelay = this.mInterpolator.getInterpolation(normalizedDelay);
        return (long)(normalizedDelay * totalDelay);
    }

    private final int $$robo$$android_view_animation_GridLayoutAnimationController$getTransformedColumnIndex(AnimationParameters params) {
        int index;
        switch (this.getOrder()) {
            case 1: {
                index = params.columnsCount - 1 - params.column;
                break;
            }
            case 2: {
                if (this.mRandomizer == null) {
                    this.mRandomizer = new Random();
                }
                index = (int)((float)params.columnsCount * this.mRandomizer.nextFloat());
                break;
            }
            default: {
                index = params.column;
            }
        }
        int direction = this.mDirection & 1;
        if (direction == 1) {
            index = params.columnsCount - 1 - index;
        }
        return index;
    }

    private final int $$robo$$android_view_animation_GridLayoutAnimationController$getTransformedRowIndex(AnimationParameters params) {
        int index;
        switch (this.getOrder()) {
            case 1: {
                index = params.rowsCount - 1 - params.row;
                break;
            }
            case 2: {
                if (this.mRandomizer == null) {
                    this.mRandomizer = new Random();
                }
                index = (int)((float)params.rowsCount * this.mRandomizer.nextFloat());
                break;
            }
            default: {
                index = params.row;
            }
        }
        int direction = this.mDirection & 2;
        if (direction == 2) {
            index = params.rowsCount - 1 - index;
        }
        return index;
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_view_animation_GridLayoutAnimationController$__constructor__(context, attributeSet);
    }

    public GridLayoutAnimationController(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_GridLayoutAnimationController$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Animation animation) {
        this.$$robo$$android_view_animation_GridLayoutAnimationController$__constructor__(animation);
    }

    public GridLayoutAnimationController(Animation animation) {
        this(animation, 0.5f, 0.5f);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_GridLayoutAnimationController$__constructor__(android.view.animation.Animation ), 0, this, animation);
    }

    private void __constructor__(Animation animation, float f, float f2) {
        this.$$robo$$android_view_animation_GridLayoutAnimationController$__constructor__(animation, f, f2);
    }

    public GridLayoutAnimationController(Animation animation, float f, float f2) {
        super(animation);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_GridLayoutAnimationController$__constructor__(android.view.animation.Animation float float ), 0, this, animation, f, f2);
    }

    public float getColumnDelay() {
        return (float)InvokeDynamicSupport.bootstrap("getColumnDelay", $$robo$$android_view_animation_GridLayoutAnimationController$getColumnDelay(), 0, this);
    }

    public void setColumnDelay(float f) {
        InvokeDynamicSupport.bootstrap("setColumnDelay", $$robo$$android_view_animation_GridLayoutAnimationController$setColumnDelay(float ), 0, this, f);
    }

    public float getRowDelay() {
        return (float)InvokeDynamicSupport.bootstrap("getRowDelay", $$robo$$android_view_animation_GridLayoutAnimationController$getRowDelay(), 0, this);
    }

    public void setRowDelay(float f) {
        InvokeDynamicSupport.bootstrap("setRowDelay", $$robo$$android_view_animation_GridLayoutAnimationController$setRowDelay(float ), 0, this, f);
    }

    public int getDirection() {
        return (int)InvokeDynamicSupport.bootstrap("getDirection", $$robo$$android_view_animation_GridLayoutAnimationController$getDirection(), 0, this);
    }

    public void setDirection(int n) {
        InvokeDynamicSupport.bootstrap("setDirection", $$robo$$android_view_animation_GridLayoutAnimationController$setDirection(int ), 0, this, n);
    }

    public int getDirectionPriority() {
        return (int)InvokeDynamicSupport.bootstrap("getDirectionPriority", $$robo$$android_view_animation_GridLayoutAnimationController$getDirectionPriority(), 0, this);
    }

    public void setDirectionPriority(int n) {
        InvokeDynamicSupport.bootstrap("setDirectionPriority", $$robo$$android_view_animation_GridLayoutAnimationController$setDirectionPriority(int ), 0, this, n);
    }

    @Override
    public boolean willOverlap() {
        return (boolean)InvokeDynamicSupport.bootstrap("willOverlap", $$robo$$android_view_animation_GridLayoutAnimationController$willOverlap(), 0, this);
    }

    @Override
    protected long getDelayForView(View view) {
        return (long)InvokeDynamicSupport.bootstrap("getDelayForView", $$robo$$android_view_animation_GridLayoutAnimationController$getDelayForView(android.view.View ), 0, this, view);
    }

    private int getTransformedColumnIndex(AnimationParameters animationParameters) {
        return (int)InvokeDynamicSupport.bootstrap("getTransformedColumnIndex", $$robo$$android_view_animation_GridLayoutAnimationController$getTransformedColumnIndex(android.view.animation.GridLayoutAnimationController$AnimationParameters ), 0, this, animationParameters);
    }

    private int getTransformedRowIndex(AnimationParameters animationParameters) {
        return (int)InvokeDynamicSupport.bootstrap("getTransformedRowIndex", $$robo$$android_view_animation_GridLayoutAnimationController$getTransformedRowIndex(android.view.animation.GridLayoutAnimationController$AnimationParameters ), 0, this, animationParameters);
    }

    public /* synthetic */ GridLayoutAnimationController() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GridLayoutAnimationController)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class AnimationParameters
    extends LayoutAnimationController.AnimationParameters
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int column;
        public int row;
        public int columnsCount;
        public int rowsCount;

        private void $$robo$$android_view_animation_GridLayoutAnimationController_AnimationParameters$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_view_animation_GridLayoutAnimationController_AnimationParameters$__constructor__();
        }

        public AnimationParameters() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_GridLayoutAnimationController_AnimationParameters$__constructor__(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimationParameters)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

