/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.graphics.Matrix;
import android.graphics.Rect;
import java.io.PrintWriter;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Transformation
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int TYPE_IDENTITY = 0;
    public static int TYPE_ALPHA = 1;
    public static int TYPE_MATRIX = 2;
    public static int TYPE_BOTH = 3;
    protected Matrix mMatrix;
    protected float mAlpha;
    protected int mTransformationType;
    private boolean mHasClipRect;
    private Rect mClipRect;

    private void $$robo$$android_view_animation_Transformation$__constructor__() {
        this.mClipRect = new Rect();
        this.clear();
    }

    private final void $$robo$$android_view_animation_Transformation$clear() {
        if (this.mMatrix == null) {
            this.mMatrix = new Matrix();
        } else {
            this.mMatrix.reset();
        }
        this.mClipRect.setEmpty();
        this.mHasClipRect = false;
        this.mAlpha = 1.0f;
        this.mTransformationType = 3;
    }

    private final int $$robo$$android_view_animation_Transformation$getTransformationType() {
        return this.mTransformationType;
    }

    private final void $$robo$$android_view_animation_Transformation$setTransformationType(int transformationType) {
        this.mTransformationType = transformationType;
    }

    private final void $$robo$$android_view_animation_Transformation$set(Transformation t) {
        this.mAlpha = t.getAlpha();
        this.mMatrix.set(t.getMatrix());
        if (t.mHasClipRect) {
            this.setClipRect(t.getClipRect());
        } else {
            this.mHasClipRect = false;
            this.mClipRect.setEmpty();
        }
        this.mTransformationType = t.getTransformationType();
    }

    private final void $$robo$$android_view_animation_Transformation$compose(Transformation t) {
        this.mAlpha *= t.getAlpha();
        this.mMatrix.preConcat(t.getMatrix());
        if (t.mHasClipRect) {
            Rect bounds = t.getClipRect();
            if (this.mHasClipRect) {
                this.setClipRect(this.mClipRect.left + bounds.left, this.mClipRect.top + bounds.top, this.mClipRect.right + bounds.right, this.mClipRect.bottom + bounds.bottom);
            } else {
                this.setClipRect(bounds);
            }
        }
    }

    private final void $$robo$$android_view_animation_Transformation$postCompose(Transformation t) {
        this.mAlpha *= t.getAlpha();
        this.mMatrix.postConcat(t.getMatrix());
        if (t.mHasClipRect) {
            Rect bounds = t.getClipRect();
            if (this.mHasClipRect) {
                this.setClipRect(this.mClipRect.left + bounds.left, this.mClipRect.top + bounds.top, this.mClipRect.right + bounds.right, this.mClipRect.bottom + bounds.bottom);
            } else {
                this.setClipRect(bounds);
            }
        }
    }

    private final Matrix $$robo$$android_view_animation_Transformation$getMatrix() {
        return this.mMatrix;
    }

    private final void $$robo$$android_view_animation_Transformation$setAlpha(float alpha) {
        this.mAlpha = alpha;
    }

    private final void $$robo$$android_view_animation_Transformation$setClipRect(Rect r) {
        this.setClipRect(r.left, r.top, r.right, r.bottom);
    }

    private final void $$robo$$android_view_animation_Transformation$setClipRect(int l, int t, int r, int b) {
        this.mClipRect.set(l, t, r, b);
        this.mHasClipRect = true;
    }

    private final Rect $$robo$$android_view_animation_Transformation$getClipRect() {
        return this.mClipRect;
    }

    private final boolean $$robo$$android_view_animation_Transformation$hasClipRect() {
        return this.mHasClipRect;
    }

    private final float $$robo$$android_view_animation_Transformation$getAlpha() {
        return this.mAlpha;
    }

    private final String $$robo$$android_view_animation_Transformation$toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Transformation");
        this.toShortString(sb);
        return sb.toString();
    }

    private final String $$robo$$android_view_animation_Transformation$toShortString() {
        StringBuilder sb = new StringBuilder(64);
        this.toShortString(sb);
        return sb.toString();
    }

    private final void $$robo$$android_view_animation_Transformation$toShortString(StringBuilder sb) {
        sb.append("{alpha=");
        sb.append(this.mAlpha);
        sb.append(" matrix=");
        this.mMatrix.toShortString(sb);
        sb.append('}');
    }

    private final void $$robo$$android_view_animation_Transformation$printShortString(PrintWriter pw) {
        pw.print("{alpha=");
        pw.print(this.mAlpha);
        pw.print(" matrix=");
        this.mMatrix.printShortString(pw);
        pw.print('}');
    }

    private void __constructor__() {
        this.$$robo$$android_view_animation_Transformation$__constructor__();
    }

    public Transformation() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_Transformation$__constructor__(), 0, this);
    }

    public void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_view_animation_Transformation$clear(), 0, this);
    }

    public int getTransformationType() {
        return (int)InvokeDynamicSupport.bootstrap("getTransformationType", $$robo$$android_view_animation_Transformation$getTransformationType(), 0, this);
    }

    public void setTransformationType(int n) {
        InvokeDynamicSupport.bootstrap("setTransformationType", $$robo$$android_view_animation_Transformation$setTransformationType(int ), 0, this, n);
    }

    public void set(Transformation transformation) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_view_animation_Transformation$set(android.view.animation.Transformation ), 0, this, transformation);
    }

    public void compose(Transformation transformation) {
        InvokeDynamicSupport.bootstrap("compose", $$robo$$android_view_animation_Transformation$compose(android.view.animation.Transformation ), 0, this, transformation);
    }

    public void postCompose(Transformation transformation) {
        InvokeDynamicSupport.bootstrap("postCompose", $$robo$$android_view_animation_Transformation$postCompose(android.view.animation.Transformation ), 0, this, transformation);
    }

    public Matrix getMatrix() {
        return InvokeDynamicSupport.bootstrap("getMatrix", $$robo$$android_view_animation_Transformation$getMatrix(), 0, this);
    }

    public void setAlpha(float f) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_view_animation_Transformation$setAlpha(float ), 0, this, f);
    }

    public void setClipRect(Rect rect) {
        InvokeDynamicSupport.bootstrap("setClipRect", $$robo$$android_view_animation_Transformation$setClipRect(android.graphics.Rect ), 0, this, rect);
    }

    public void setClipRect(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setClipRect", $$robo$$android_view_animation_Transformation$setClipRect(int int int int ), 0, this, n, n2, n3, n4);
    }

    public Rect getClipRect() {
        return InvokeDynamicSupport.bootstrap("getClipRect", $$robo$$android_view_animation_Transformation$getClipRect(), 0, this);
    }

    public boolean hasClipRect() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasClipRect", $$robo$$android_view_animation_Transformation$hasClipRect(), 0, this);
    }

    public float getAlpha() {
        return (float)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_view_animation_Transformation$getAlpha(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_animation_Transformation$toString(), 0, this);
    }

    public String toShortString() {
        return InvokeDynamicSupport.bootstrap("toShortString", $$robo$$android_view_animation_Transformation$toShortString(), 0, this);
    }

    public void toShortString(StringBuilder stringBuilder) {
        InvokeDynamicSupport.bootstrap("toShortString", $$robo$$android_view_animation_Transformation$toShortString(java.lang.StringBuilder ), 0, this, stringBuilder);
    }

    public void printShortString(PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("printShortString", $$robo$$android_view_animation_Transformation$printShortString(java.io.PrintWriter ), 0, this, printWriter);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Transformation)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

