/*
 * Decompiled with CFR 0.152.
 */
package android.view.autofill;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.graphics.Rect;
import android.metrics.LogMaker;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.RemoteException;
import android.service.autofill.FillEventHistory;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillValue;
import android.view.autofill.Helper;
import android.view.autofill.IAutoFillManager;
import android.view.autofill.IAutoFillManagerClient;
import android.view.autofill.IAutofillWindowPresenter;
import android.view.autofill.ParcelableMap;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class AutofillManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "AutofillManager";
    public static String EXTRA_ASSIST_STRUCTURE = "android.view.autofill.extra.ASSIST_STRUCTURE";
    public static String EXTRA_AUTHENTICATION_RESULT = "android.view.autofill.extra.AUTHENTICATION_RESULT";
    public static String EXTRA_CLIENT_STATE = "android.view.autofill.extra.CLIENT_STATE";
    public static String EXTRA_RESTORE_SESSION_TOKEN = "android.view.autofill.extra.RESTORE_SESSION_TOKEN";
    private static String SESSION_ID_TAG = "android:sessionId";
    private static String STATE_TAG = "android:state";
    private static String LAST_AUTOFILLED_DATA_TAG = "android:lastAutoFilledData";
    public static int ACTION_START_SESSION = 1;
    public static int ACTION_VIEW_ENTERED = 2;
    public static int ACTION_VIEW_EXITED = 3;
    public static int ACTION_VALUE_CHANGED = 4;
    public static int FLAG_ADD_CLIENT_ENABLED = 1;
    public static int FLAG_ADD_CLIENT_DEBUG = 2;
    public static int FLAG_ADD_CLIENT_VERBOSE = 4;
    private static int AUTHENTICATION_ID_DATASET_ID_MASK = 65535;
    private static int AUTHENTICATION_ID_DATASET_ID_SHIFT = 16;
    public static int AUTHENTICATION_ID_DATASET_ID_UNDEFINED = 65535;
    public static int PENDING_UI_OPERATION_CANCEL = 1;
    public static int PENDING_UI_OPERATION_RESTORE = 2;
    public static int STATE_UNKNOWN = 0;
    public static int STATE_ACTIVE = 1;
    public static int STATE_FINISHED = 2;
    public static int STATE_SHOWING_SAVE_UI = 3;
    private MetricsLogger mMetricsLogger;
    public static int NO_SESSION = Integer.MIN_VALUE;
    private IAutoFillManager mService;
    private Object mLock;
    @GuardedBy(value="mLock")
    private IAutoFillManagerClient mServiceClient;
    @GuardedBy(value="mLock")
    private AutofillCallback mCallback;
    private Context mContext;
    @GuardedBy(value="mLock")
    private int mSessionId;
    @GuardedBy(value="mLock")
    private int mState;
    @GuardedBy(value="mLock")
    private boolean mEnabled;
    @GuardedBy(value="mLock")
    private ParcelableMap mLastAutofilledData;
    @GuardedBy(value="mLock")
    private TrackedViews mTrackedViews;
    @GuardedBy(value="mLock")
    private ArraySet<AutofillId> mFillableIds;

    private static final int $$robo$$android_view_autofill_AutofillManager$makeAuthenticationId(int requestId, int datasetId) {
        return requestId << 16 | datasetId & 0xFFFF;
    }

    private static final int $$robo$$android_view_autofill_AutofillManager$getRequestIdFromAuthenticationId(int authRequestId) {
        return authRequestId >> 16;
    }

    private static final int $$robo$$android_view_autofill_AutofillManager$getDatasetIdFromAuthenticationId(int authRequestId) {
        return authRequestId & 0xFFFF;
    }

    private void $$robo$$android_view_autofill_AutofillManager$__constructor__(Context context, IAutoFillManager service) {
        this.mMetricsLogger = new MetricsLogger();
        this.mLock = new Object();
        this.mSessionId = Integer.MIN_VALUE;
        this.mState = 0;
        this.mContext = Preconditions.checkNotNull(context, "context cannot be null");
        this.mService = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$onCreate(Bundle savedInstanceState) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mLastAutofilledData = (ParcelableMap)savedInstanceState.getParcelable("android:lastAutoFilledData");
            if (this.isActiveLocked()) {
                Log.w("AutofillManager", "New session was started before onCreate()");
                return;
            }
            this.mSessionId = savedInstanceState.getInt("android:sessionId", Integer.MIN_VALUE);
            this.mState = savedInstanceState.getInt("android:state", 0);
            if (this.mSessionId != Integer.MIN_VALUE) {
                this.ensureServiceClientAddedIfNeededLocked();
                AutofillClient client = this.getClientLocked();
                if (client != null) {
                    try {
                        boolean sessionWasRestored = this.mService.restoreSession(this.mSessionId, this.mContext.getActivityToken(), this.mServiceClient.asBinder());
                        if (!sessionWasRestored) {
                            Log.w("AutofillManager", "Session " + this.mSessionId + " could not be restored");
                            this.mSessionId = Integer.MIN_VALUE;
                            this.mState = 0;
                        } else {
                            if (Helper.sDebug) {
                                Log.d("AutofillManager", "session " + this.mSessionId + " was restored");
                            }
                            client.autofillCallbackResetableStateAvailable();
                        }
                    }
                    catch (RemoteException e) {
                        Log.e("AutofillManager", "Could not figure out if there was an autofill session", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$onVisibleForAutofill() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mEnabled && this.isActiveLocked() && this.mTrackedViews != null) {
                this.mTrackedViews.onVisibleForAutofillLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$onSaveInstanceState(Bundle outState) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSessionId != Integer.MIN_VALUE) {
                outState.putInt("android:sessionId", this.mSessionId);
            }
            if (this.mState != 0) {
                outState.putInt("android:state", this.mState);
            }
            if (this.mLastAutofilledData != null) {
                outState.putParcelable("android:lastAutoFilledData", this.mLastAutofilledData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_autofill_AutofillManager$isEnabled() {
        if (!this.hasAutofillFeature()) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.ensureServiceClientAddedIfNeededLocked();
            return this.mEnabled;
        }
    }

    private final FillEventHistory $$robo$$android_view_autofill_AutofillManager$getFillEventHistory() {
        try {
            return this.mService.getFillEventHistory();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return null;
        }
    }

    private final void $$robo$$android_view_autofill_AutofillManager$requestAutofill(View view) {
        this.notifyViewEntered(view, 1);
    }

    private final void $$robo$$android_view_autofill_AutofillManager$requestAutofill(View view, int virtualId, Rect absBounds) {
        this.notifyViewEntered(view, virtualId, absBounds, 1);
    }

    private final void $$robo$$android_view_autofill_AutofillManager$notifyViewEntered(View view) {
        this.notifyViewEntered(view, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$notifyViewEntered(View view, int flags) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        AutofillCallback callback = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.isFinishedLocked() && (flags & 1) == 0) {
                if (Helper.sVerbose) {
                    Log.v("AutofillManager", "notifyViewEntered(flags=" + flags + ", view=" + view + "): ignored on state " + this.getStateAsStringLocked());
                }
                return;
            }
            this.ensureServiceClientAddedIfNeededLocked();
            if (!this.mEnabled) {
                if (this.mCallback != null) {
                    callback = this.mCallback;
                }
            } else {
                AutofillId id2 = AutofillManager.getAutofillId(view);
                AutofillValue value = view.getAutofillValue();
                if (!this.isActiveLocked()) {
                    this.startSessionLocked(id2, null, value, flags);
                } else {
                    this.updateSessionLocked(id2, null, value, 2, flags);
                }
            }
        }
        if (callback != null) {
            this.mCallback.onAutofillEvent(view, 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$notifyViewExited(View view) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.ensureServiceClientAddedIfNeededLocked();
            if (this.mEnabled && this.isActiveLocked()) {
                AutofillId id2 = AutofillManager.getAutofillId(view);
                this.updateSessionLocked(id2, null, null, 3, 0);
            }
        }
    }

    private final void $$robo$$android_view_autofill_AutofillManager$notifyViewVisibilityChanged(View view, boolean isVisible) {
        this.notifyViewVisibilityChangedInternal(view, 0, isVisible, false);
    }

    private final void $$robo$$android_view_autofill_AutofillManager$notifyViewVisibilityChanged(View view, int virtualId, boolean isVisible) {
        this.notifyViewVisibilityChangedInternal(view, virtualId, isVisible, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$notifyViewVisibilityChangedInternal(View view, int virtualId, boolean isVisible, boolean virtual) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mEnabled && this.isActiveLocked()) {
                AutofillId id2;
                AutofillId autofillId = id2 = virtual ? AutofillManager.getAutofillId(view, virtualId) : view.getAutofillId();
                if (!isVisible && this.mFillableIds != null && this.mFillableIds.contains(id2)) {
                    if (Helper.sDebug) {
                        Log.d("AutofillManager", "Hidding UI when view " + id2 + " became invisible");
                    }
                    this.requestHideFillUi(id2, view);
                }
                if (this.mTrackedViews != null) {
                    this.mTrackedViews.notifyViewVisibilityChanged(id2, isVisible);
                }
            }
        }
    }

    private final void $$robo$$android_view_autofill_AutofillManager$notifyViewEntered(View view, int virtualId, Rect absBounds) {
        this.notifyViewEntered(view, virtualId, absBounds, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$notifyViewEntered(View view, int virtualId, Rect bounds, int flags) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        AutofillCallback callback = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.isFinishedLocked() && (flags & 1) == 0) {
                if (Helper.sVerbose) {
                    Log.v("AutofillManager", "notifyViewEntered(flags=" + flags + ", view=" + view + ", virtualId=" + virtualId + "): ignored on state " + this.getStateAsStringLocked());
                }
                return;
            }
            this.ensureServiceClientAddedIfNeededLocked();
            if (!this.mEnabled) {
                if (this.mCallback != null) {
                    callback = this.mCallback;
                }
            } else {
                AutofillId id2 = AutofillManager.getAutofillId(view, virtualId);
                if (!this.isActiveLocked()) {
                    this.startSessionLocked(id2, bounds, null, flags);
                } else {
                    this.updateSessionLocked(id2, bounds, null, 2, flags);
                }
            }
        }
        if (callback != null) {
            callback.onAutofillEvent(view, virtualId, 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$notifyViewExited(View view, int virtualId) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.ensureServiceClientAddedIfNeededLocked();
            if (this.mEnabled && this.isActiveLocked()) {
                AutofillId id2 = AutofillManager.getAutofillId(view, virtualId);
                this.updateSessionLocked(id2, null, null, 3, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$notifyValueChanged(View view) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        AutofillId id2 = null;
        boolean valueWasRead = false;
        AutofillValue value = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLastAutofilledData == null) {
                view.setAutofilled(false);
            } else {
                id2 = AutofillManager.getAutofillId(view);
                if (this.mLastAutofilledData.containsKey(id2)) {
                    value = view.getAutofillValue();
                    valueWasRead = true;
                    if (Objects.equals(this.mLastAutofilledData.get(id2), value)) {
                        view.setAutofilled(true);
                    } else {
                        view.setAutofilled(false);
                        this.mLastAutofilledData.remove(id2);
                    }
                } else {
                    view.setAutofilled(false);
                }
            }
            if (!this.mEnabled || !this.isActiveLocked()) {
                if (Helper.sVerbose && this.mEnabled) {
                    Log.v("AutofillManager", "notifyValueChanged(" + view + "): ignoring on state " + this.getStateAsStringLocked());
                }
                return;
            }
            if (id2 == null) {
                id2 = AutofillManager.getAutofillId(view);
            }
            if (!valueWasRead) {
                value = view.getAutofillValue();
            }
            this.updateSessionLocked(id2, null, value, 4, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$notifyValueChanged(View view, int virtualId, AutofillValue value) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mEnabled || !this.isActiveLocked()) {
                return;
            }
            AutofillId id2 = AutofillManager.getAutofillId(view, virtualId);
            this.updateSessionLocked(id2, null, value, 4, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$commit() {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mEnabled && !this.isActiveLocked()) {
                return;
            }
            this.finishSessionLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$cancel() {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mEnabled && !this.isActiveLocked()) {
                return;
            }
            this.cancelSessionLocked();
        }
    }

    private final void $$robo$$android_view_autofill_AutofillManager$disableOwnedAutofillServices() {
        this.disableAutofillServices();
    }

    private final void $$robo$$android_view_autofill_AutofillManager$disableAutofillServices() {
        if (!this.hasAutofillFeature()) {
            return;
        }
        try {
            this.mService.disableOwnedAutofillServices(this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_view_autofill_AutofillManager$hasEnabledAutofillServices() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.isServiceEnabled(this.mContext.getUserId(), this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_view_autofill_AutofillManager$isAutofillSupported() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.isServiceSupported(this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final AutofillClient $$robo$$android_view_autofill_AutofillManager$getClientLocked() {
        return this.mContext.getAutofillClient();
    }

    private final ComponentName $$robo$$android_view_autofill_AutofillManager$getComponentNameFromContext(AutofillClient client) {
        return client == null ? null : client.getComponentNameForAutofill();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$onAuthenticationResult(int authenticationId, Intent data) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        if (Helper.sDebug) {
            Log.d("AutofillManager", "onAuthenticationResult(): d=" + data);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isActiveLocked() || data == null) {
                return;
            }
            Object result = data.getParcelableExtra("android.view.autofill.extra.AUTHENTICATION_RESULT");
            Bundle responseData = new Bundle();
            responseData.putParcelable("android.view.autofill.extra.AUTHENTICATION_RESULT", (Parcelable)result);
            try {
                this.mService.setAuthenticationResult(responseData, this.mSessionId, authenticationId, this.mContext.getUserId());
            }
            catch (RemoteException e) {
                Log.e("AutofillManager", "Error delivering authentication result", e);
            }
        }
    }

    private static final AutofillId $$robo$$android_view_autofill_AutofillManager$getAutofillId(View view) {
        return new AutofillId(view.getAutofillViewId());
    }

    private static final AutofillId $$robo$$android_view_autofill_AutofillManager$getAutofillId(View parent, int virtualId) {
        return new AutofillId(parent.getAutofillViewId(), virtualId);
    }

    private final void $$robo$$android_view_autofill_AutofillManager$startSessionLocked(AutofillId id2, Rect bounds, AutofillValue value, int flags) {
        if (Helper.sVerbose) {
            Log.v("AutofillManager", "startSessionLocked(): id=" + id2 + ", bounds=" + bounds + ", value=" + value + ", flags=" + flags + ", state=" + this.getStateAsStringLocked());
        }
        if (this.mState != 0 && (flags & 1) == 0) {
            if (Helper.sVerbose) {
                Log.v("AutofillManager", "not automatically starting session for " + id2 + " on state " + this.getStateAsStringLocked());
            }
            return;
        }
        try {
            AutofillClient client = this.getClientLocked();
            ComponentName componentName = this.getComponentNameFromContext(client);
            if (componentName == null) {
                Log.w("AutofillManager", "startSessionLocked(): context is not activity: " + this.mContext);
                return;
            }
            this.mSessionId = this.mService.startSession(this.mContext.getActivityToken(), this.mServiceClient.asBinder(), id2, bounds, value, this.mContext.getUserId(), this.mCallback != null, flags, componentName);
            if (this.mSessionId != Integer.MIN_VALUE) {
                this.mState = 1;
            }
            if (client != null) {
                client.autofillCallbackResetableStateAvailable();
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_view_autofill_AutofillManager$finishSessionLocked() {
        if (Helper.sVerbose) {
            Log.v("AutofillManager", "finishSessionLocked(): " + this.getStateAsStringLocked());
        }
        if (!this.isActiveLocked()) {
            return;
        }
        try {
            this.mService.finishSession(this.mSessionId, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        this.resetSessionLocked();
    }

    private final void $$robo$$android_view_autofill_AutofillManager$cancelSessionLocked() {
        if (Helper.sVerbose) {
            Log.v("AutofillManager", "cancelSessionLocked(): " + this.getStateAsStringLocked());
        }
        if (!this.isActiveLocked()) {
            return;
        }
        try {
            this.mService.cancelSession(this.mSessionId, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        this.resetSessionLocked();
    }

    private final void $$robo$$android_view_autofill_AutofillManager$resetSessionLocked() {
        this.mSessionId = Integer.MIN_VALUE;
        this.mState = 0;
        this.mTrackedViews = null;
        this.mFillableIds = null;
    }

    private final void $$robo$$android_view_autofill_AutofillManager$updateSessionLocked(AutofillId id2, Rect bounds, AutofillValue value, int action, int flags) {
        if (Helper.sVerbose && action != 3) {
            Log.v("AutofillManager", "updateSessionLocked(): id=" + id2 + ", bounds=" + bounds + ", value=" + value + ", action=" + action + ", flags=" + flags);
        }
        boolean restartIfNecessary = (flags & 1) != 0;
        try {
            if (restartIfNecessary) {
                AutofillClient client = this.getClientLocked();
                ComponentName componentName = this.getComponentNameFromContext(client);
                if (componentName == null) {
                    Log.w("AutofillManager", "startSessionLocked(): context is not activity: " + this.mContext);
                    return;
                }
                int newId = this.mService.updateOrRestartSession(this.mContext.getActivityToken(), this.mServiceClient.asBinder(), id2, bounds, value, this.mContext.getUserId(), this.mCallback != null, flags, componentName, this.mSessionId, action);
                if (newId != this.mSessionId) {
                    if (Helper.sDebug) {
                        Log.d("AutofillManager", "Session restarted: " + this.mSessionId + "=>" + newId);
                    }
                    this.mSessionId = newId;
                    int n = this.mState = this.mSessionId == Integer.MIN_VALUE ? 0 : 1;
                    if (client != null) {
                        client.autofillCallbackResetableStateAvailable();
                    }
                }
            } else {
                this.mService.updateSession(this.mSessionId, id2, bounds, value, action, flags, this.mContext.getUserId());
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_view_autofill_AutofillManager$ensureServiceClientAddedIfNeededLocked() {
        if (this.getClientLocked() == null) {
            return;
        }
        if (this.mServiceClient == null) {
            this.mServiceClient = new AutofillManagerClient(this);
            try {
                int flags = this.mService.addClient(this.mServiceClient, this.mContext.getUserId());
                this.mEnabled = (flags & 1) != 0;
                Helper.sDebug = (flags & 2) != 0;
                Helper.sVerbose = (flags & 4) != 0;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$registerCallback(AutofillCallback callback) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (callback == null) {
                return;
            }
            boolean hadCallback = this.mCallback != null;
            this.mCallback = callback;
            if (!hadCallback) {
                try {
                    this.mService.setHasCallback(this.mSessionId, this.mContext.getUserId(), true);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$unregisterCallback(AutofillCallback callback) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (callback == null || this.mCallback == null || callback != this.mCallback) {
                return;
            }
            this.mCallback = null;
            try {
                this.mService.setHasCallback(this.mSessionId, this.mContext.getUserId(), false);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$requestShowFillUi(int sessionId, AutofillId id2, int width, int height, Rect anchorBounds, IAutofillWindowPresenter presenter) {
        View anchor = this.findView(id2);
        if (anchor == null) {
            return;
        }
        AutofillCallback callback = null;
        Object object = this.mLock;
        synchronized (object) {
            AutofillClient client;
            if (this.mSessionId == sessionId && (client = this.getClientLocked()) != null && client.autofillCallbackRequestShowFillUi(anchor, width, height, anchorBounds, presenter) && this.mCallback != null) {
                callback = this.mCallback;
            }
        }
        if (callback != null) {
            if (id2.isVirtual()) {
                callback.onAutofillEvent(anchor, id2.getVirtualChildId(), 1);
            } else {
                callback.onAutofillEvent(anchor, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$authenticate(int sessionId, int authenticationId, IntentSender intent, Intent fillInIntent) {
        Object object = this.mLock;
        synchronized (object) {
            AutofillClient client;
            if (sessionId == this.mSessionId && (client = this.getClientLocked()) != null) {
                client.autofillCallbackAuthenticate(authenticationId, intent, fillInIntent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$setState(boolean enabled, boolean resetSession, boolean resetClient) {
        Object object = this.mLock;
        synchronized (object) {
            this.mEnabled = enabled;
            if (!this.mEnabled || resetSession) {
                this.resetSessionLocked();
            }
            if (resetClient) {
                this.mServiceClient = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$setAutofilledIfValuesIs(View view, AutofillValue targetValue) {
        AutofillValue currentValue = view.getAutofillValue();
        if (Objects.equals(currentValue, targetValue)) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mLastAutofilledData == null) {
                    this.mLastAutofilledData = new ParcelableMap(1);
                }
                this.mLastAutofilledData.put(AutofillManager.getAutofillId(view), targetValue);
            }
            view.setAutofilled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$autofill(int sessionId, List<AutofillId> ids, List<AutofillValue> values) {
        Object object = this.mLock;
        synchronized (object) {
            int i;
            if (sessionId != this.mSessionId) {
                return;
            }
            AutofillClient client = this.getClientLocked();
            if (client == null) {
                return;
            }
            int itemCount = ids.size();
            int numApplied = 0;
            ArrayMap<View, SparseArray<AutofillValue>> virtualValues = null;
            View[] views = client.findViewsByAutofillIdTraversal(this.getViewIds(ids));
            for (i = 0; i < itemCount; ++i) {
                AutofillId id2 = ids.get(i);
                AutofillValue value = values.get(i);
                int viewId = id2.getViewId();
                View view = views[i];
                if (view == null) {
                    Log.w("AutofillManager", "autofill(): no View with id " + viewId);
                    continue;
                }
                if (id2.isVirtual()) {
                    SparseArray<AutofillValue> valuesByParent;
                    if (virtualValues == null) {
                        virtualValues = new ArrayMap<View, SparseArray<AutofillValue>>(1);
                    }
                    if ((valuesByParent = (SparseArray<AutofillValue>)virtualValues.get(view)) == null) {
                        valuesByParent = new SparseArray<AutofillValue>(5);
                        virtualValues.put(view, valuesByParent);
                    }
                    valuesByParent.put(id2.getVirtualChildId(), value);
                    continue;
                }
                if (this.mLastAutofilledData == null) {
                    this.mLastAutofilledData = new ParcelableMap(itemCount - i);
                }
                this.mLastAutofilledData.put(id2, value);
                view.autofill(value);
                this.setAutofilledIfValuesIs(view, value);
                ++numApplied;
            }
            if (virtualValues != null) {
                for (i = 0; i < virtualValues.size(); ++i) {
                    View parent = (View)virtualValues.keyAt(i);
                    SparseArray childrenValues = (SparseArray)virtualValues.valueAt(i);
                    parent.autofill(childrenValues);
                    numApplied += childrenValues.size();
                }
            }
            LogMaker log = new LogMaker(913).setPackageName(this.mContext.getPackageName()).addTaggedData(914, itemCount).addTaggedData(915, numApplied);
            this.mMetricsLogger.write(log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$setTrackedViews(int sessionId, AutofillId[] trackedIds, boolean saveOnAllViewsInvisible, AutofillId[] fillableIds) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mEnabled && this.mSessionId == sessionId) {
                this.mTrackedViews = saveOnAllViewsInvisible ? new TrackedViews(this, trackedIds) : null;
                if (fillableIds != null) {
                    if (this.mFillableIds == null) {
                        this.mFillableIds = new ArraySet(fillableIds.length);
                    }
                    for (AutofillId id2 : fillableIds) {
                        this.mFillableIds.add(id2);
                    }
                    if (Helper.sVerbose) {
                        Log.v("AutofillManager", "setTrackedViews(): fillableIds=" + fillableIds + ", mFillableIds" + this.mFillableIds);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$setSaveUiState(int sessionId, boolean shown) {
        if (Helper.sDebug) {
            Log.d("AutofillManager", "setSaveUiState(" + sessionId + "): " + shown);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSessionId != Integer.MIN_VALUE) {
                Log.w("AutofillManager", "setSaveUiState(" + sessionId + ", " + shown + ") called on existing session " + this.mSessionId + "; cancelling it");
                this.cancelSessionLocked();
            }
            if (shown) {
                this.mSessionId = sessionId;
                this.mState = 3;
            } else {
                this.mSessionId = Integer.MIN_VALUE;
                this.mState = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$setSessionFinished(int newState) {
        Object object = this.mLock;
        synchronized (object) {
            if (Helper.sVerbose) {
                Log.v("AutofillManager", "setSessionFinished(): from " + this.mState + " to " + newState);
            }
            this.resetSessionLocked();
            this.mState = newState;
        }
    }

    private final void $$robo$$android_view_autofill_AutofillManager$requestHideFillUi(AutofillId id2) {
        View anchor = this.findView(id2);
        if (Helper.sVerbose) {
            Log.v("AutofillManager", "requestHideFillUi(" + id2 + "): anchor = " + anchor);
        }
        if (anchor == null) {
            return;
        }
        this.requestHideFillUi(id2, anchor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$requestHideFillUi(AutofillId id2, View anchor) {
        AutofillCallback callback = null;
        Object object = this.mLock;
        synchronized (object) {
            AutofillClient client = this.getClientLocked();
            if (client != null && client.autofillCallbackRequestHideFillUi() && this.mCallback != null) {
                callback = this.mCallback;
            }
        }
        if (callback != null) {
            if (id2.isVirtual()) {
                callback.onAutofillEvent(anchor, id2.getVirtualChildId(), 2);
            } else {
                callback.onAutofillEvent(anchor, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$notifyNoFillUi(int sessionId, AutofillId id2, boolean sessionFinished) {
        View anchor;
        if (Helper.sVerbose) {
            Log.v("AutofillManager", "notifyNoFillUi(): sessionId=" + sessionId + ", autofillId=" + id2 + ", finished=" + sessionFinished);
        }
        if ((anchor = this.findView(id2)) == null) {
            return;
        }
        AutofillCallback callback = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSessionId == sessionId && this.getClientLocked() != null) {
                callback = this.mCallback;
            }
        }
        if (callback != null) {
            if (id2.isVirtual()) {
                callback.onAutofillEvent(anchor, id2.getVirtualChildId(), 3);
            } else {
                callback.onAutofillEvent(anchor, 3);
            }
        }
        if (sessionFinished) {
            this.setSessionFinished(2);
        }
    }

    private final int[] $$robo$$android_view_autofill_AutofillManager$getViewIds(AutofillId[] autofillIds) {
        int numIds = autofillIds.length;
        int[] viewIds = new int[numIds];
        for (int i = 0; i < numIds; ++i) {
            viewIds[i] = autofillIds[i].getViewId();
        }
        return viewIds;
    }

    private final int[] $$robo$$android_view_autofill_AutofillManager$getViewIds(List<AutofillId> autofillIds) {
        int numIds = autofillIds.size();
        int[] viewIds = new int[numIds];
        for (int i = 0; i < numIds; ++i) {
            viewIds[i] = autofillIds.get(i).getViewId();
        }
        return viewIds;
    }

    private final View $$robo$$android_view_autofill_AutofillManager$findView(AutofillId autofillId) {
        AutofillClient client = this.getClientLocked();
        if (client == null) {
            return null;
        }
        return client.findViewByAutofillIdTraversal(autofillId.getViewId());
    }

    private final boolean $$robo$$android_view_autofill_AutofillManager$hasAutofillFeature() {
        return this.mService != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_autofill_AutofillManager$onPendingSaveUi(int operation, IBinder token) {
        if (Helper.sVerbose) {
            Log.v("AutofillManager", "onPendingSaveUi(" + operation + "): " + token);
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mService.onPendingSaveUi(operation, token);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_view_autofill_AutofillManager$dump(String outerPrefix, PrintWriter pw) {
        pw.print(outerPrefix);
        pw.println("AutofillManager:");
        String pfx = outerPrefix + "  ";
        pw.print(pfx);
        pw.print("sessionId: ");
        pw.println(this.mSessionId);
        pw.print(pfx);
        pw.print("state: ");
        pw.println(this.getStateAsStringLocked());
        pw.print(pfx);
        pw.print("enabled: ");
        pw.println(this.mEnabled);
        pw.print(pfx);
        pw.print("hasService: ");
        pw.println(this.mService != null);
        pw.print(pfx);
        pw.print("hasCallback: ");
        pw.println(this.mCallback != null);
        pw.print(pfx);
        pw.print("last autofilled data: ");
        pw.println(this.mLastAutofilledData);
        pw.print(pfx);
        pw.print("tracked views: ");
        if (this.mTrackedViews == null) {
            pw.println("null");
        } else {
            String pfx2 = pfx + "  ";
            pw.println();
            pw.print(pfx2);
            pw.print("visible:");
            pw.println(this.mTrackedViews.mVisibleTrackedIds);
            pw.print(pfx2);
            pw.print("invisible:");
            pw.println(this.mTrackedViews.mInvisibleTrackedIds);
        }
        pw.print(pfx);
        pw.print("fillable ids: ");
        pw.println(this.mFillableIds);
    }

    private final String $$robo$$android_view_autofill_AutofillManager$getStateAsStringLocked() {
        switch (this.mState) {
            case 0: {
                return "STATE_UNKNOWN";
            }
            case 1: {
                return "STATE_ACTIVE";
            }
            case 2: {
                return "STATE_FINISHED";
            }
            case 3: {
                return "STATE_SHOWING_SAVE_UI";
            }
        }
        return "INVALID:" + this.mState;
    }

    private final boolean $$robo$$android_view_autofill_AutofillManager$isActiveLocked() {
        return this.mState == 1;
    }

    private final boolean $$robo$$android_view_autofill_AutofillManager$isFinishedLocked() {
        return this.mState == 2;
    }

    private final void $$robo$$android_view_autofill_AutofillManager$post(Runnable runnable) {
        AutofillClient client = this.getClientLocked();
        if (client == null) {
            if (Helper.sVerbose) {
                Log.v("AutofillManager", "ignoring post() because client is null");
            }
            return;
        }
        client.runOnUiThread(runnable);
    }

    public static int makeAuthenticationId(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("makeAuthenticationId", $$robo$$android_view_autofill_AutofillManager$makeAuthenticationId(int int ), 0, (int)n, (int)n2);
    }

    public static int getRequestIdFromAuthenticationId(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getRequestIdFromAuthenticationId", $$robo$$android_view_autofill_AutofillManager$getRequestIdFromAuthenticationId(int ), 0, (int)n);
    }

    public static int getDatasetIdFromAuthenticationId(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDatasetIdFromAuthenticationId", $$robo$$android_view_autofill_AutofillManager$getDatasetIdFromAuthenticationId(int ), 0, (int)n);
    }

    private void __constructor__(Context context, IAutoFillManager iAutoFillManager) {
        this.$$robo$$android_view_autofill_AutofillManager$__constructor__(context, iAutoFillManager);
    }

    public AutofillManager(Context context, IAutoFillManager iAutoFillManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_autofill_AutofillManager$__constructor__(android.content.Context android.view.autofill.IAutoFillManager ), 0, this, context, iAutoFillManager);
    }

    public void onCreate(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$android_view_autofill_AutofillManager$onCreate(android.os.Bundle ), 0, this, bundle);
    }

    public void onVisibleForAutofill() {
        InvokeDynamicSupport.bootstrap("onVisibleForAutofill", $$robo$$android_view_autofill_AutofillManager$onVisibleForAutofill(), 0, this);
    }

    public void onSaveInstanceState(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_view_autofill_AutofillManager$onSaveInstanceState(android.os.Bundle ), 0, this, bundle);
    }

    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_view_autofill_AutofillManager$isEnabled(), 0, this);
    }

    public FillEventHistory getFillEventHistory() {
        return InvokeDynamicSupport.bootstrap("getFillEventHistory", $$robo$$android_view_autofill_AutofillManager$getFillEventHistory(), 0, this);
    }

    public void requestAutofill(View view) {
        InvokeDynamicSupport.bootstrap("requestAutofill", $$robo$$android_view_autofill_AutofillManager$requestAutofill(android.view.View ), 0, this, view);
    }

    public void requestAutofill(View view, int n, Rect rect) {
        InvokeDynamicSupport.bootstrap("requestAutofill", $$robo$$android_view_autofill_AutofillManager$requestAutofill(android.view.View int android.graphics.Rect ), 0, this, view, n, rect);
    }

    public void notifyViewEntered(View view) {
        InvokeDynamicSupport.bootstrap("notifyViewEntered", $$robo$$android_view_autofill_AutofillManager$notifyViewEntered(android.view.View ), 0, this, view);
    }

    private void notifyViewEntered(View view, int n) {
        InvokeDynamicSupport.bootstrap("notifyViewEntered", $$robo$$android_view_autofill_AutofillManager$notifyViewEntered(android.view.View int ), 0, this, view, n);
    }

    public void notifyViewExited(View view) {
        InvokeDynamicSupport.bootstrap("notifyViewExited", $$robo$$android_view_autofill_AutofillManager$notifyViewExited(android.view.View ), 0, this, view);
    }

    public void notifyViewVisibilityChanged(View view, boolean bl) {
        InvokeDynamicSupport.bootstrap("notifyViewVisibilityChanged", $$robo$$android_view_autofill_AutofillManager$notifyViewVisibilityChanged(android.view.View boolean ), 0, this, view, bl);
    }

    public void notifyViewVisibilityChanged(View view, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("notifyViewVisibilityChanged", $$robo$$android_view_autofill_AutofillManager$notifyViewVisibilityChanged(android.view.View int boolean ), 0, this, view, n, bl);
    }

    private void notifyViewVisibilityChangedInternal(View view, int n, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("notifyViewVisibilityChangedInternal", $$robo$$android_view_autofill_AutofillManager$notifyViewVisibilityChangedInternal(android.view.View int boolean boolean ), 0, this, view, n, bl, bl2);
    }

    public void notifyViewEntered(View view, int n, Rect rect) {
        InvokeDynamicSupport.bootstrap("notifyViewEntered", $$robo$$android_view_autofill_AutofillManager$notifyViewEntered(android.view.View int android.graphics.Rect ), 0, this, view, n, rect);
    }

    private void notifyViewEntered(View view, int n, Rect rect, int n2) {
        InvokeDynamicSupport.bootstrap("notifyViewEntered", $$robo$$android_view_autofill_AutofillManager$notifyViewEntered(android.view.View int android.graphics.Rect int ), 0, this, view, n, rect, n2);
    }

    public void notifyViewExited(View view, int n) {
        InvokeDynamicSupport.bootstrap("notifyViewExited", $$robo$$android_view_autofill_AutofillManager$notifyViewExited(android.view.View int ), 0, this, view, n);
    }

    public void notifyValueChanged(View view) {
        InvokeDynamicSupport.bootstrap("notifyValueChanged", $$robo$$android_view_autofill_AutofillManager$notifyValueChanged(android.view.View ), 0, this, view);
    }

    public void notifyValueChanged(View view, int n, AutofillValue autofillValue) {
        InvokeDynamicSupport.bootstrap("notifyValueChanged", $$robo$$android_view_autofill_AutofillManager$notifyValueChanged(android.view.View int android.view.autofill.AutofillValue ), 0, this, view, n, autofillValue);
    }

    public void commit() {
        InvokeDynamicSupport.bootstrap("commit", $$robo$$android_view_autofill_AutofillManager$commit(), 0, this);
    }

    public void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_view_autofill_AutofillManager$cancel(), 0, this);
    }

    public void disableOwnedAutofillServices() {
        InvokeDynamicSupport.bootstrap("disableOwnedAutofillServices", $$robo$$android_view_autofill_AutofillManager$disableOwnedAutofillServices(), 0, this);
    }

    public void disableAutofillServices() {
        InvokeDynamicSupport.bootstrap("disableAutofillServices", $$robo$$android_view_autofill_AutofillManager$disableAutofillServices(), 0, this);
    }

    public boolean hasEnabledAutofillServices() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasEnabledAutofillServices", $$robo$$android_view_autofill_AutofillManager$hasEnabledAutofillServices(), 0, this);
    }

    public boolean isAutofillSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAutofillSupported", $$robo$$android_view_autofill_AutofillManager$isAutofillSupported(), 0, this);
    }

    private AutofillClient getClientLocked() {
        return InvokeDynamicSupport.bootstrap("getClientLocked", $$robo$$android_view_autofill_AutofillManager$getClientLocked(), 0, this);
    }

    private ComponentName getComponentNameFromContext(AutofillClient autofillClient) {
        return InvokeDynamicSupport.bootstrap("getComponentNameFromContext", $$robo$$android_view_autofill_AutofillManager$getComponentNameFromContext(android.view.autofill.AutofillManager$AutofillClient ), 0, this, autofillClient);
    }

    public void onAuthenticationResult(int n, Intent intent) {
        InvokeDynamicSupport.bootstrap("onAuthenticationResult", $$robo$$android_view_autofill_AutofillManager$onAuthenticationResult(int android.content.Intent ), 0, this, n, intent);
    }

    private static AutofillId getAutofillId(View view) {
        return InvokeDynamicSupport.bootstrapStatic("getAutofillId", $$robo$$android_view_autofill_AutofillManager$getAutofillId(android.view.View ), 0, (View)view);
    }

    private static AutofillId getAutofillId(View view, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getAutofillId", $$robo$$android_view_autofill_AutofillManager$getAutofillId(android.view.View int ), 0, (View)view, (int)n);
    }

    private void startSessionLocked(AutofillId autofillId, Rect rect, AutofillValue autofillValue, int n) {
        InvokeDynamicSupport.bootstrap("startSessionLocked", $$robo$$android_view_autofill_AutofillManager$startSessionLocked(android.view.autofill.AutofillId android.graphics.Rect android.view.autofill.AutofillValue int ), 0, this, autofillId, rect, autofillValue, n);
    }

    private void finishSessionLocked() {
        InvokeDynamicSupport.bootstrap("finishSessionLocked", $$robo$$android_view_autofill_AutofillManager$finishSessionLocked(), 0, this);
    }

    private void cancelSessionLocked() {
        InvokeDynamicSupport.bootstrap("cancelSessionLocked", $$robo$$android_view_autofill_AutofillManager$cancelSessionLocked(), 0, this);
    }

    private void resetSessionLocked() {
        InvokeDynamicSupport.bootstrap("resetSessionLocked", $$robo$$android_view_autofill_AutofillManager$resetSessionLocked(), 0, this);
    }

    private void updateSessionLocked(AutofillId autofillId, Rect rect, AutofillValue autofillValue, int n, int n2) {
        InvokeDynamicSupport.bootstrap("updateSessionLocked", $$robo$$android_view_autofill_AutofillManager$updateSessionLocked(android.view.autofill.AutofillId android.graphics.Rect android.view.autofill.AutofillValue int int ), 0, this, autofillId, rect, autofillValue, n, n2);
    }

    private void ensureServiceClientAddedIfNeededLocked() {
        InvokeDynamicSupport.bootstrap("ensureServiceClientAddedIfNeededLocked", $$robo$$android_view_autofill_AutofillManager$ensureServiceClientAddedIfNeededLocked(), 0, this);
    }

    public void registerCallback(AutofillCallback autofillCallback) {
        InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_view_autofill_AutofillManager$registerCallback(android.view.autofill.AutofillManager$AutofillCallback ), 0, this, autofillCallback);
    }

    public void unregisterCallback(AutofillCallback autofillCallback) {
        InvokeDynamicSupport.bootstrap("unregisterCallback", $$robo$$android_view_autofill_AutofillManager$unregisterCallback(android.view.autofill.AutofillManager$AutofillCallback ), 0, this, autofillCallback);
    }

    private void requestShowFillUi(int n, AutofillId autofillId, int n2, int n3, Rect rect, IAutofillWindowPresenter iAutofillWindowPresenter) {
        InvokeDynamicSupport.bootstrap("requestShowFillUi", $$robo$$android_view_autofill_AutofillManager$requestShowFillUi(int android.view.autofill.AutofillId int int android.graphics.Rect android.view.autofill.IAutofillWindowPresenter ), 0, this, n, autofillId, n2, n3, rect, iAutofillWindowPresenter);
    }

    private void authenticate(int n, int n2, IntentSender intentSender, Intent intent) {
        InvokeDynamicSupport.bootstrap("authenticate", $$robo$$android_view_autofill_AutofillManager$authenticate(int int android.content.IntentSender android.content.Intent ), 0, this, n, n2, intentSender, intent);
    }

    private void setState(boolean bl, boolean bl2, boolean bl3) {
        InvokeDynamicSupport.bootstrap("setState", $$robo$$android_view_autofill_AutofillManager$setState(boolean boolean boolean ), 0, this, bl, bl2, bl3);
    }

    private void setAutofilledIfValuesIs(View view, AutofillValue autofillValue) {
        InvokeDynamicSupport.bootstrap("setAutofilledIfValuesIs", $$robo$$android_view_autofill_AutofillManager$setAutofilledIfValuesIs(android.view.View android.view.autofill.AutofillValue ), 0, this, view, autofillValue);
    }

    private void autofill(int n, List<AutofillId> list, List<AutofillValue> list2) {
        InvokeDynamicSupport.bootstrap("autofill", $$robo$$android_view_autofill_AutofillManager$autofill(int java.util.List<android.view.autofill.AutofillId> java.util.List<android.view.autofill.AutofillValue> ), 0, this, n, list, list2);
    }

    private void setTrackedViews(int n, AutofillId[] autofillIdArray, boolean bl, AutofillId[] autofillIdArray2) {
        InvokeDynamicSupport.bootstrap("setTrackedViews", $$robo$$android_view_autofill_AutofillManager$setTrackedViews(int android.view.autofill.AutofillId[] boolean android.view.autofill.AutofillId[] ), 0, this, n, autofillIdArray, bl, autofillIdArray2);
    }

    private void setSaveUiState(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setSaveUiState", $$robo$$android_view_autofill_AutofillManager$setSaveUiState(int boolean ), 0, this, n, bl);
    }

    private void setSessionFinished(int n) {
        InvokeDynamicSupport.bootstrap("setSessionFinished", $$robo$$android_view_autofill_AutofillManager$setSessionFinished(int ), 0, this, n);
    }

    private void requestHideFillUi(AutofillId autofillId) {
        InvokeDynamicSupport.bootstrap("requestHideFillUi", $$robo$$android_view_autofill_AutofillManager$requestHideFillUi(android.view.autofill.AutofillId ), 0, this, autofillId);
    }

    private void requestHideFillUi(AutofillId autofillId, View view) {
        InvokeDynamicSupport.bootstrap("requestHideFillUi", $$robo$$android_view_autofill_AutofillManager$requestHideFillUi(android.view.autofill.AutofillId android.view.View ), 0, this, autofillId, view);
    }

    private void notifyNoFillUi(int n, AutofillId autofillId, boolean bl) {
        InvokeDynamicSupport.bootstrap("notifyNoFillUi", $$robo$$android_view_autofill_AutofillManager$notifyNoFillUi(int android.view.autofill.AutofillId boolean ), 0, this, n, autofillId, bl);
    }

    private int[] getViewIds(AutofillId[] autofillIdArray) {
        return InvokeDynamicSupport.bootstrap("getViewIds", $$robo$$android_view_autofill_AutofillManager$getViewIds(android.view.autofill.AutofillId[] ), 0, this, autofillIdArray);
    }

    private int[] getViewIds(List<AutofillId> list) {
        return InvokeDynamicSupport.bootstrap("getViewIds", $$robo$$android_view_autofill_AutofillManager$getViewIds(java.util.List<android.view.autofill.AutofillId> ), 0, this, list);
    }

    private View findView(AutofillId autofillId) {
        return InvokeDynamicSupport.bootstrap("findView", $$robo$$android_view_autofill_AutofillManager$findView(android.view.autofill.AutofillId ), 0, this, autofillId);
    }

    public boolean hasAutofillFeature() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasAutofillFeature", $$robo$$android_view_autofill_AutofillManager$hasAutofillFeature(), 0, this);
    }

    public void onPendingSaveUi(int n, IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("onPendingSaveUi", $$robo$$android_view_autofill_AutofillManager$onPendingSaveUi(int android.os.IBinder ), 0, this, n, iBinder);
    }

    public void dump(String string2, PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_view_autofill_AutofillManager$dump(java.lang.String java.io.PrintWriter ), 0, this, string2, printWriter);
    }

    private String getStateAsStringLocked() {
        return InvokeDynamicSupport.bootstrap("getStateAsStringLocked", $$robo$$android_view_autofill_AutofillManager$getStateAsStringLocked(), 0, this);
    }

    private boolean isActiveLocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isActiveLocked", $$robo$$android_view_autofill_AutofillManager$isActiveLocked(), 0, this);
    }

    private boolean isFinishedLocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFinishedLocked", $$robo$$android_view_autofill_AutofillManager$isFinishedLocked(), 0, this);
    }

    private void post(Runnable runnable) {
        InvokeDynamicSupport.bootstrap("post", $$robo$$android_view_autofill_AutofillManager$post(java.lang.Runnable ), 0, this, runnable);
    }

    public /* synthetic */ AutofillManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AutofillManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class AutofillManagerClient
    extends IAutoFillManagerClient.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private WeakReference<AutofillManager> mAfm;

        private void $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$__constructor__(AutofillManager autofillManager) {
            this.mAfm = new WeakReference<AutofillManager>(autofillManager);
        }

        private final void $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$setState(boolean enabled, boolean resetSession, boolean resetClient) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.setState(enabled, resetSession, resetClient));
            }
        }

        private final void $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$autofill(int sessionId, List<AutofillId> ids, List<AutofillValue> values) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.autofill(sessionId, ids, values));
            }
        }

        private final void $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$authenticate(int sessionId, int authenticationId, IntentSender intent, Intent fillInIntent) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.authenticate(sessionId, authenticationId, intent, fillInIntent));
            }
        }

        private final void $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$requestShowFillUi(int sessionId, AutofillId id2, int width, int height, Rect anchorBounds, IAutofillWindowPresenter presenter) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.requestShowFillUi(sessionId, id2, width, height, anchorBounds, presenter));
            }
        }

        private final void $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$requestHideFillUi(int sessionId, AutofillId id2) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.requestHideFillUi(id2));
            }
        }

        private final void $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$notifyNoFillUi(int sessionId, AutofillId id2, boolean sessionFinished) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.notifyNoFillUi(sessionId, id2, sessionFinished));
            }
        }

        private final void $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$startIntentSender(IntentSender intentSender, Intent intent) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> {
                    try {
                        afm.mContext.startIntentSender(intentSender, intent, 0, 0, 0);
                    }
                    catch (IntentSender.SendIntentException e) {
                        Log.e("AutofillManager", "startIntentSender() failed for intent:" + intentSender, e);
                    }
                });
            }
        }

        private final void $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$setTrackedViews(int sessionId, AutofillId[] ids, boolean saveOnAllViewsInvisible, AutofillId[] fillableIds) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.setTrackedViews(sessionId, ids, saveOnAllViewsInvisible, fillableIds));
            }
        }

        private final void $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$setSaveUiState(int sessionId, boolean shown) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.setSaveUiState(sessionId, shown));
            }
        }

        private final void $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$setSessionFinished(int newState) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.setSessionFinished(newState));
            }
        }

        private void __constructor__(AutofillManager autofillManager) {
            this.$$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$__constructor__(autofillManager);
        }

        AutofillManagerClient(AutofillManager autofillManager) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$__constructor__(android.view.autofill.AutofillManager ), 0, this, autofillManager);
        }

        @Override
        public void setState(boolean bl, boolean bl2, boolean bl3) {
            InvokeDynamicSupport.bootstrap("setState", $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$setState(boolean boolean boolean ), 0, this, bl, bl2, bl3);
        }

        @Override
        public void autofill(int n, List<AutofillId> list, List<AutofillValue> list2) {
            InvokeDynamicSupport.bootstrap("autofill", $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$autofill(int java.util.List<android.view.autofill.AutofillId> java.util.List<android.view.autofill.AutofillValue> ), 0, this, n, list, list2);
        }

        @Override
        public void authenticate(int n, int n2, IntentSender intentSender, Intent intent) {
            InvokeDynamicSupport.bootstrap("authenticate", $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$authenticate(int int android.content.IntentSender android.content.Intent ), 0, this, n, n2, intentSender, intent);
        }

        @Override
        public void requestShowFillUi(int n, AutofillId autofillId, int n2, int n3, Rect rect, IAutofillWindowPresenter iAutofillWindowPresenter) {
            InvokeDynamicSupport.bootstrap("requestShowFillUi", $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$requestShowFillUi(int android.view.autofill.AutofillId int int android.graphics.Rect android.view.autofill.IAutofillWindowPresenter ), 0, this, n, autofillId, n2, n3, rect, iAutofillWindowPresenter);
        }

        @Override
        public void requestHideFillUi(int n, AutofillId autofillId) {
            InvokeDynamicSupport.bootstrap("requestHideFillUi", $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$requestHideFillUi(int android.view.autofill.AutofillId ), 0, this, n, autofillId);
        }

        @Override
        public void notifyNoFillUi(int n, AutofillId autofillId, boolean bl) {
            InvokeDynamicSupport.bootstrap("notifyNoFillUi", $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$notifyNoFillUi(int android.view.autofill.AutofillId boolean ), 0, this, n, autofillId, bl);
        }

        @Override
        public void startIntentSender(IntentSender intentSender, Intent intent) {
            InvokeDynamicSupport.bootstrap("startIntentSender", $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$startIntentSender(android.content.IntentSender android.content.Intent ), 0, this, intentSender, intent);
        }

        @Override
        public void setTrackedViews(int n, AutofillId[] autofillIdArray, boolean bl, AutofillId[] autofillIdArray2) {
            InvokeDynamicSupport.bootstrap("setTrackedViews", $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$setTrackedViews(int android.view.autofill.AutofillId[] boolean android.view.autofill.AutofillId[] ), 0, this, n, autofillIdArray, bl, autofillIdArray2);
        }

        @Override
        public void setSaveUiState(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("setSaveUiState", $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$setSaveUiState(int boolean ), 0, this, n, bl);
        }

        @Override
        public void setSessionFinished(int n) {
            InvokeDynamicSupport.bootstrap("setSessionFinished", $$robo$$android_view_autofill_AutofillManager_AutofillManagerClient$setSessionFinished(int ), 0, this, n);
        }

        public /* synthetic */ AutofillManagerClient() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AutofillManagerClient)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class AutofillCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int EVENT_INPUT_SHOWN = 1;
        public static int EVENT_INPUT_HIDDEN = 2;
        public static int EVENT_INPUT_UNAVAILABLE = 3;

        private void $$robo$$android_view_autofill_AutofillManager_AutofillCallback$__constructor__() {
        }

        private final void $$robo$$android_view_autofill_AutofillManager_AutofillCallback$onAutofillEvent(View view, int event) {
        }

        private final void $$robo$$android_view_autofill_AutofillManager_AutofillCallback$onAutofillEvent(View view, int virtualId, int event) {
        }

        private void __constructor__() {
            this.$$robo$$android_view_autofill_AutofillManager_AutofillCallback$__constructor__();
        }

        public AutofillCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_autofill_AutofillManager_AutofillCallback$__constructor__(), 0, this);
        }

        public void onAutofillEvent(View view, int n) {
            InvokeDynamicSupport.bootstrap("onAutofillEvent", $$robo$$android_view_autofill_AutofillManager_AutofillCallback$onAutofillEvent(android.view.View int ), 0, this, view, n);
        }

        public void onAutofillEvent(View view, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onAutofillEvent", $$robo$$android_view_autofill_AutofillManager_AutofillCallback$onAutofillEvent(android.view.View int int ), 0, this, view, n, n2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AutofillCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface AutofillEventType {
        }
    }

    private class TrackedViews
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ArraySet<AutofillId> mVisibleTrackedIds;
        private ArraySet<AutofillId> mInvisibleTrackedIds;
        /* synthetic */ AutofillManager this$0;

        private final <T> boolean $$robo$$android_view_autofill_AutofillManager_TrackedViews$isInSet(ArraySet<T> set, T value) {
            return set != null && set.contains(value);
        }

        private final <T> ArraySet<T> $$robo$$android_view_autofill_AutofillManager_TrackedViews$addToSet(ArraySet<T> set, T valueToAdd) {
            if (set == null) {
                set = new ArraySet(1);
            }
            set.add(valueToAdd);
            return set;
        }

        private final <T> ArraySet<T> $$robo$$android_view_autofill_AutofillManager_TrackedViews$removeFromSet(ArraySet<T> set, T valueToRemove) {
            if (set == null) {
                return null;
            }
            set.remove(valueToRemove);
            if (set.isEmpty()) {
                return null;
            }
            return set;
        }

        private void $$robo$$android_view_autofill_AutofillManager_TrackedViews$__constructor__(AutofillManager autofillManager, AutofillId[] trackedIds) {
            AutofillClient client = autofillManager.getClientLocked();
            if (trackedIds != null && client != null) {
                boolean[] isVisible = client.isVisibleForAutofill() ? client.getViewVisibility(autofillManager.getViewIds(trackedIds)) : new boolean[trackedIds.length];
                int numIds = trackedIds.length;
                for (int i = 0; i < numIds; ++i) {
                    AutofillId id2 = trackedIds[i];
                    if (isVisible[i]) {
                        this.mVisibleTrackedIds = this.addToSet(this.mVisibleTrackedIds, id2);
                        continue;
                    }
                    this.mInvisibleTrackedIds = this.addToSet(this.mInvisibleTrackedIds, id2);
                }
            }
            if (Helper.sVerbose) {
                Log.v("AutofillManager", "TrackedViews(trackedIds=" + trackedIds + "): " + " mVisibleTrackedIds=" + this.mVisibleTrackedIds + " mInvisibleTrackedIds=" + this.mInvisibleTrackedIds);
            }
            if (this.mVisibleTrackedIds == null) {
                autofillManager.finishSessionLocked();
            }
        }

        private final void $$robo$$android_view_autofill_AutofillManager_TrackedViews$notifyViewVisibilityChanged(AutofillId id2, boolean isVisible) {
            AutofillClient client = this.this$0.getClientLocked();
            if (Helper.sDebug) {
                Log.d("AutofillManager", "notifyViewVisibilityChanged(): id=" + id2 + " isVisible=" + isVisible);
            }
            if (client != null && client.isVisibleForAutofill()) {
                if (isVisible) {
                    if (this.isInSet(this.mInvisibleTrackedIds, id2)) {
                        this.mInvisibleTrackedIds = this.removeFromSet(this.mInvisibleTrackedIds, id2);
                        this.mVisibleTrackedIds = this.addToSet(this.mVisibleTrackedIds, id2);
                    }
                } else if (this.isInSet(this.mVisibleTrackedIds, id2)) {
                    this.mVisibleTrackedIds = this.removeFromSet(this.mVisibleTrackedIds, id2);
                    this.mInvisibleTrackedIds = this.addToSet(this.mInvisibleTrackedIds, id2);
                }
            }
            if (this.mVisibleTrackedIds == null) {
                if (Helper.sVerbose) {
                    Log.v("AutofillManager", "No more visible ids. Invisibile = " + this.mInvisibleTrackedIds);
                }
                this.this$0.finishSessionLocked();
            }
        }

        private final void $$robo$$android_view_autofill_AutofillManager_TrackedViews$onVisibleForAutofillLocked() {
            AutofillClient client = this.this$0.getClientLocked();
            ArraySet<AutofillId> updatedVisibleTrackedIds = null;
            ArraySet<AutofillId> updatedInvisibleTrackedIds = null;
            if (client != null) {
                AutofillId id2;
                int i;
                boolean[] isVisible;
                if (this.mInvisibleTrackedIds != null) {
                    ArrayList<AutofillId> orderedInvisibleIds = new ArrayList<AutofillId>(this.mInvisibleTrackedIds);
                    isVisible = client.getViewVisibility(this.this$0.getViewIds(orderedInvisibleIds));
                    int numInvisibleTrackedIds = orderedInvisibleIds.size();
                    for (i = 0; i < numInvisibleTrackedIds; ++i) {
                        id2 = orderedInvisibleIds.get(i);
                        if (isVisible[i]) {
                            updatedVisibleTrackedIds = this.addToSet(updatedVisibleTrackedIds, id2);
                            if (!Helper.sDebug) continue;
                            Log.d("AutofillManager", "onVisibleForAutofill() " + id2 + " became visible");
                            continue;
                        }
                        updatedInvisibleTrackedIds = this.addToSet(updatedInvisibleTrackedIds, id2);
                    }
                }
                if (this.mVisibleTrackedIds != null) {
                    ArrayList<AutofillId> orderedVisibleIds = new ArrayList<AutofillId>(this.mVisibleTrackedIds);
                    isVisible = client.getViewVisibility(this.this$0.getViewIds(orderedVisibleIds));
                    int numVisibleTrackedIds = orderedVisibleIds.size();
                    for (i = 0; i < numVisibleTrackedIds; ++i) {
                        id2 = orderedVisibleIds.get(i);
                        if (isVisible[i]) {
                            updatedVisibleTrackedIds = this.addToSet(updatedVisibleTrackedIds, id2);
                            continue;
                        }
                        updatedInvisibleTrackedIds = this.addToSet(updatedInvisibleTrackedIds, id2);
                        if (!Helper.sDebug) continue;
                        Log.d("AutofillManager", "onVisibleForAutofill() " + id2 + " became invisible");
                    }
                }
                this.mInvisibleTrackedIds = updatedInvisibleTrackedIds;
                this.mVisibleTrackedIds = updatedVisibleTrackedIds;
            }
            if (this.mVisibleTrackedIds == null) {
                this.this$0.finishSessionLocked();
            }
        }

        private <T> boolean isInSet(ArraySet<T> arraySet, T t) {
            return (boolean)InvokeDynamicSupport.bootstrap("isInSet", $$robo$$android_view_autofill_AutofillManager_TrackedViews$isInSet(android.util.ArraySet<T> T ), 0, this, arraySet, t);
        }

        private <T> ArraySet<T> addToSet(ArraySet<T> arraySet, T t) {
            return InvokeDynamicSupport.bootstrap("addToSet", $$robo$$android_view_autofill_AutofillManager_TrackedViews$addToSet(android.util.ArraySet<T> T ), 0, this, arraySet, t);
        }

        private <T> ArraySet<T> removeFromSet(ArraySet<T> arraySet, T t) {
            return InvokeDynamicSupport.bootstrap("removeFromSet", $$robo$$android_view_autofill_AutofillManager_TrackedViews$removeFromSet(android.util.ArraySet<T> T ), 0, this, arraySet, t);
        }

        private void __constructor__(AutofillManager autofillManager, AutofillId[] autofillIdArray) {
            this.$$robo$$android_view_autofill_AutofillManager_TrackedViews$__constructor__(autofillManager, autofillIdArray);
        }

        TrackedViews(AutofillManager autofillManager, AutofillId[] autofillIdArray) {
            this.this$0 = autofillManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_autofill_AutofillManager_TrackedViews$__constructor__(android.view.autofill.AutofillManager android.view.autofill.AutofillId[] ), 0, this, autofillManager, autofillIdArray);
        }

        void notifyViewVisibilityChanged(AutofillId autofillId, boolean bl) {
            InvokeDynamicSupport.bootstrap("notifyViewVisibilityChanged", $$robo$$android_view_autofill_AutofillManager_TrackedViews$notifyViewVisibilityChanged(android.view.autofill.AutofillId boolean ), 0, this, autofillId, bl);
        }

        void onVisibleForAutofillLocked() {
            InvokeDynamicSupport.bootstrap("onVisibleForAutofillLocked", $$robo$$android_view_autofill_AutofillManager_TrackedViews$onVisibleForAutofillLocked(), 0, this);
        }

        public /* synthetic */ TrackedViews() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TrackedViews)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface AutofillClient
    extends InstrumentedInterface {
        public void autofillCallbackAuthenticate(int var1, IntentSender var2, Intent var3);

        public void autofillCallbackResetableStateAvailable();

        public boolean autofillCallbackRequestShowFillUi(View var1, int var2, int var3, Rect var4, IAutofillWindowPresenter var5);

        public boolean autofillCallbackRequestHideFillUi();

        public boolean[] getViewVisibility(int[] var1);

        public boolean isVisibleForAutofill();

        public View[] findViewsByAutofillIdTraversal(int[] var1);

        public View findViewByAutofillIdTraversal(int var1);

        public void runOnUiThread(Runnable var1);

        public ComponentName getComponentNameForAutofill();
    }
}

