/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Printer;
import android.util.Slog;
import android.util.Xml;
import android.view.inputmethod.InputMethodSubtype;
import android.view.inputmethod.InputMethodSubtypeArray;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParserException;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class InputMethodInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "InputMethodInfo";
    ResolveInfo mService;
    String mId;
    String mSettingsActivityName;
    int mIsDefaultResId;
    private InputMethodSubtypeArray mSubtypes;
    private boolean mIsAuxIme;
    private boolean mForceDefault;
    private boolean mSupportsSwitchingToNextInputMethod;
    public static Parcelable.Creator<InputMethodInfo> CREATOR;

    private static final String $$robo$$android_view_inputmethod_InputMethodInfo$computeId(ResolveInfo service) {
        ServiceInfo si = service.serviceInfo;
        return new ComponentName(si.packageName, si.name).flattenToShortString();
    }

    private void $$robo$$android_view_inputmethod_InputMethodInfo$__constructor__(Context context, ResolveInfo service) throws XmlPullParserException, IOException {
    }

    private void $$robo$$android_view_inputmethod_InputMethodInfo$__constructor__(Context context, ResolveInfo service, List<InputMethodSubtype> additionalSubtypes) throws XmlPullParserException, IOException {
        this.mService = service;
        ServiceInfo si = service.serviceInfo;
        this.mId = InputMethodInfo.computeId(service);
        boolean isAuxIme = true;
        boolean supportsSwitchingToNextInputMethod = false;
        this.mForceDefault = false;
        PackageManager pm = context.getPackageManager();
        String settingsActivityComponent = null;
        int isDefaultResId = 0;
        ArrayList<InputMethodSubtype> subtypes = new ArrayList<InputMethodSubtype>();
        try (XmlResourceParser parser = null;){
            int type;
            parser = si.loadXmlMetaData(pm, "android.view.im");
            if (parser == null) {
                throw new XmlPullParserException("No android.view.im meta-data");
            }
            Resources res = pm.getResourcesForApplication(si.applicationInfo);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!"input-method".equals(nodeName)) {
                throw new XmlPullParserException("Meta-data does not start with input-method tag");
            }
            TypedArray sa = res.obtainAttributes(attrs, R.styleable.InputMethod);
            settingsActivityComponent = sa.getString(1);
            isDefaultResId = sa.getResourceId(0, 0);
            supportsSwitchingToNextInputMethod = sa.getBoolean(2, false);
            sa.recycle();
            int depth = parser.getDepth();
            while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
                if (type != 2) continue;
                nodeName = parser.getName();
                if (!"subtype".equals(nodeName)) {
                    throw new XmlPullParserException("Meta-data in input-method does not start with subtype tag");
                }
                TypedArray a = res.obtainAttributes(attrs, R.styleable.InputMethod_Subtype);
                InputMethodSubtype subtype = new InputMethodSubtype.InputMethodSubtypeBuilder().setSubtypeNameResId(a.getResourceId(0, 0)).setSubtypeIconResId(a.getResourceId(1, 0)).setLanguageTag(a.getString(9)).setSubtypeLocale(a.getString(2)).setSubtypeMode(a.getString(3)).setSubtypeExtraValue(a.getString(4)).setIsAuxiliary(a.getBoolean(5, false)).setOverridesImplicitlyEnabledSubtype(a.getBoolean(6, false)).setSubtypeId(a.getInt(7, 0)).setIsAsciiCapable(a.getBoolean(8, false)).build();
                if (!subtype.isAuxiliary()) {
                    isAuxIme = false;
                }
                subtypes.add(subtype);
            }
        }
        if (subtypes.size() == 0) {
            isAuxIme = false;
        }
        if (additionalSubtypes != null) {
            int N = additionalSubtypes.size();
            for (int i = 0; i < N; ++i) {
                InputMethodSubtype subtype = additionalSubtypes.get(i);
                if (!subtypes.contains(subtype)) {
                    subtypes.add(subtype);
                    continue;
                }
                Slog.w("InputMethodInfo", "Duplicated subtype definition found: " + subtype.getLocale() + ", " + subtype.getMode());
            }
        }
        this.mSubtypes = new InputMethodSubtypeArray(subtypes);
        this.mSettingsActivityName = settingsActivityComponent;
        this.mIsDefaultResId = isDefaultResId;
        this.mIsAuxIme = isAuxIme;
        this.mSupportsSwitchingToNextInputMethod = supportsSwitchingToNextInputMethod;
    }

    private void $$robo$$android_view_inputmethod_InputMethodInfo$__constructor__(Parcel source) {
        this.mId = source.readString();
        this.mSettingsActivityName = source.readString();
        this.mIsDefaultResId = source.readInt();
        this.mIsAuxIme = source.readInt() == 1;
        this.mSupportsSwitchingToNextInputMethod = source.readInt() == 1;
        this.mService = ResolveInfo.CREATOR.createFromParcel(source);
        this.mSubtypes = new InputMethodSubtypeArray(source);
        this.mForceDefault = false;
    }

    private void $$robo$$android_view_inputmethod_InputMethodInfo$__constructor__(String packageName, String className, CharSequence label, String settingsActivity) {
    }

    private void $$robo$$android_view_inputmethod_InputMethodInfo$__constructor__(ResolveInfo ri, boolean isAuxIme, String settingsActivity, List<InputMethodSubtype> subtypes, int isDefaultResId, boolean forceDefault) {
    }

    private void $$robo$$android_view_inputmethod_InputMethodInfo$__constructor__(ResolveInfo ri, boolean isAuxIme, String settingsActivity, List<InputMethodSubtype> subtypes, int isDefaultResId, boolean forceDefault, boolean supportsSwitchingToNextInputMethod) {
        ServiceInfo si = ri.serviceInfo;
        this.mService = ri;
        this.mId = new ComponentName(si.packageName, si.name).flattenToShortString();
        this.mSettingsActivityName = settingsActivity;
        this.mIsDefaultResId = isDefaultResId;
        this.mIsAuxIme = isAuxIme;
        this.mSubtypes = new InputMethodSubtypeArray(subtypes);
        this.mForceDefault = forceDefault;
        this.mSupportsSwitchingToNextInputMethod = supportsSwitchingToNextInputMethod;
    }

    private static final ResolveInfo $$robo$$android_view_inputmethod_InputMethodInfo$buildDummyResolveInfo(String packageName, String className, CharSequence label) {
        ResolveInfo ri = new ResolveInfo();
        ServiceInfo si = new ServiceInfo();
        ApplicationInfo ai = new ApplicationInfo();
        ai.packageName = packageName;
        ai.enabled = true;
        si.applicationInfo = ai;
        si.enabled = true;
        si.packageName = packageName;
        si.name = className;
        si.exported = true;
        si.nonLocalizedLabel = label;
        ri.serviceInfo = si;
        return ri;
    }

    private final String $$robo$$android_view_inputmethod_InputMethodInfo$getId() {
        return this.mId;
    }

    private final String $$robo$$android_view_inputmethod_InputMethodInfo$getPackageName() {
        return this.mService.serviceInfo.packageName;
    }

    private final String $$robo$$android_view_inputmethod_InputMethodInfo$getServiceName() {
        return this.mService.serviceInfo.name;
    }

    private final ServiceInfo $$robo$$android_view_inputmethod_InputMethodInfo$getServiceInfo() {
        return this.mService.serviceInfo;
    }

    private final ComponentName $$robo$$android_view_inputmethod_InputMethodInfo$getComponent() {
        return new ComponentName(this.mService.serviceInfo.packageName, this.mService.serviceInfo.name);
    }

    private final CharSequence $$robo$$android_view_inputmethod_InputMethodInfo$loadLabel(PackageManager pm) {
        return this.mService.loadLabel(pm);
    }

    private final Drawable $$robo$$android_view_inputmethod_InputMethodInfo$loadIcon(PackageManager pm) {
        return this.mService.loadIcon(pm);
    }

    private final String $$robo$$android_view_inputmethod_InputMethodInfo$getSettingsActivity() {
        return this.mSettingsActivityName;
    }

    private final int $$robo$$android_view_inputmethod_InputMethodInfo$getSubtypeCount() {
        return this.mSubtypes.getCount();
    }

    private final InputMethodSubtype $$robo$$android_view_inputmethod_InputMethodInfo$getSubtypeAt(int index) {
        return this.mSubtypes.get(index);
    }

    private final int $$robo$$android_view_inputmethod_InputMethodInfo$getIsDefaultResourceId() {
        return this.mIsDefaultResId;
    }

    private final boolean $$robo$$android_view_inputmethod_InputMethodInfo$isDefault(Context context) {
        if (this.mForceDefault) {
            return true;
        }
        try {
            if (this.getIsDefaultResourceId() == 0) {
                return false;
            }
            Resources res = context.createPackageContext(this.getPackageName(), 0).getResources();
            return res.getBoolean(this.getIsDefaultResourceId());
        }
        catch (PackageManager.NameNotFoundException | Resources.NotFoundException e) {
            return false;
        }
    }

    private final void $$robo$$android_view_inputmethod_InputMethodInfo$dump(Printer pw, String prefix) {
        pw.println(prefix + "mId=" + this.mId + " mSettingsActivityName=" + this.mSettingsActivityName + " mSupportsSwitchingToNextInputMethod=" + this.mSupportsSwitchingToNextInputMethod);
        pw.println(prefix + "mIsDefaultResId=0x" + Integer.toHexString(this.mIsDefaultResId));
        pw.println(prefix + "Service:");
        this.mService.dump(pw, prefix + "  ");
    }

    private final String $$robo$$android_view_inputmethod_InputMethodInfo$toString() {
        return "InputMethodInfo{" + this.mId + ", settings: " + this.mSettingsActivityName + "}";
    }

    private final boolean $$robo$$android_view_inputmethod_InputMethodInfo$equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof InputMethodInfo)) {
            return false;
        }
        InputMethodInfo obj = (InputMethodInfo)o;
        return this.mId.equals(obj.mId);
    }

    private final int $$robo$$android_view_inputmethod_InputMethodInfo$hashCode() {
        return this.mId.hashCode();
    }

    private final boolean $$robo$$android_view_inputmethod_InputMethodInfo$isAuxiliaryIme() {
        return this.mIsAuxIme;
    }

    private final boolean $$robo$$android_view_inputmethod_InputMethodInfo$supportsSwitchingToNextInputMethod() {
        return this.mSupportsSwitchingToNextInputMethod;
    }

    private final void $$robo$$android_view_inputmethod_InputMethodInfo$writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mId);
        dest.writeString(this.mSettingsActivityName);
        dest.writeInt(this.mIsDefaultResId);
        dest.writeInt(this.mIsAuxIme ? 1 : 0);
        dest.writeInt(this.mSupportsSwitchingToNextInputMethod ? 1 : 0);
        this.mService.writeToParcel(dest, flags);
        this.mSubtypes.writeToParcel(dest);
    }

    private final int $$robo$$android_view_inputmethod_InputMethodInfo$describeContents() {
        return 0;
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<InputMethodInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_inputmethod_InputMethodInfo_1$__constructor__() {
            }

            private final InputMethodInfo $$robo$$android_view_inputmethod_InputMethodInfo_1$createFromParcel(Parcel source) {
                return new InputMethodInfo(source);
            }

            private final InputMethodInfo[] $$robo$$android_view_inputmethod_InputMethodInfo_1$newArray(int size) {
                return new InputMethodInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_view_inputmethod_InputMethodInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_InputMethodInfo_1$__constructor__(), 0, this);
            }

            @Override
            public InputMethodInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_inputmethod_InputMethodInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public InputMethodInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_inputmethod_InputMethodInfo_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static String computeId(ResolveInfo resolveInfo) {
        return InvokeDynamicSupport.bootstrapStatic("computeId", $$robo$$android_view_inputmethod_InputMethodInfo$computeId(android.content.pm.ResolveInfo ), 0, (ResolveInfo)resolveInfo);
    }

    private void __constructor__(Context context, ResolveInfo resolveInfo) throws XmlPullParserException, IOException {
        this.$$robo$$android_view_inputmethod_InputMethodInfo$__constructor__(context, resolveInfo);
    }

    public InputMethodInfo(Context context, ResolveInfo resolveInfo) throws XmlPullParserException, IOException {
        this(context, resolveInfo, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_InputMethodInfo$__constructor__(android.content.Context android.content.pm.ResolveInfo ), 0, this, context, resolveInfo);
    }

    private void __constructor__(Context context, ResolveInfo resolveInfo, List<InputMethodSubtype> list) throws XmlPullParserException, IOException {
        this.$$robo$$android_view_inputmethod_InputMethodInfo$__constructor__(context, resolveInfo, list);
    }

    public InputMethodInfo(Context context, ResolveInfo resolveInfo, List<InputMethodSubtype> list) throws XmlPullParserException, IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_InputMethodInfo$__constructor__(android.content.Context android.content.pm.ResolveInfo java.util.List<android.view.inputmethod.InputMethodSubtype> ), 0, this, context, resolveInfo, list);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_view_inputmethod_InputMethodInfo$__constructor__(parcel);
    }

    InputMethodInfo(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_InputMethodInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    private void __constructor__(String string2, String string3, CharSequence charSequence, String string4) {
        this.$$robo$$android_view_inputmethod_InputMethodInfo$__constructor__(string2, string3, charSequence, string4);
    }

    public InputMethodInfo(String string2, String string3, CharSequence charSequence, String string4) {
        this(InputMethodInfo.buildDummyResolveInfo(string2, string3, charSequence), false, string4, null, 0, false, true);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_InputMethodInfo$__constructor__(java.lang.String java.lang.String java.lang.CharSequence java.lang.String ), 0, this, string2, string3, charSequence, string4);
    }

    private void __constructor__(ResolveInfo resolveInfo, boolean bl, String string2, List<InputMethodSubtype> list, int n, boolean bl2) {
        this.$$robo$$android_view_inputmethod_InputMethodInfo$__constructor__(resolveInfo, bl, string2, list, n, bl2);
    }

    public InputMethodInfo(ResolveInfo resolveInfo, boolean bl, String string2, List<InputMethodSubtype> list, int n, boolean bl2) {
        this(resolveInfo, bl, string2, list, n, bl2, true);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_InputMethodInfo$__constructor__(android.content.pm.ResolveInfo boolean java.lang.String java.util.List<android.view.inputmethod.InputMethodSubtype> int boolean ), 0, this, resolveInfo, bl, string2, list, n, bl2);
    }

    private void __constructor__(ResolveInfo resolveInfo, boolean bl, String string2, List<InputMethodSubtype> list, int n, boolean bl2, boolean bl3) {
        this.$$robo$$android_view_inputmethod_InputMethodInfo$__constructor__(resolveInfo, bl, string2, list, n, bl2, bl3);
    }

    public InputMethodInfo(ResolveInfo resolveInfo, boolean bl, String string2, List<InputMethodSubtype> list, int n, boolean bl2, boolean bl3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_InputMethodInfo$__constructor__(android.content.pm.ResolveInfo boolean java.lang.String java.util.List<android.view.inputmethod.InputMethodSubtype> int boolean boolean ), 0, this, resolveInfo, bl, string2, list, n, bl2, bl3);
    }

    private static ResolveInfo buildDummyResolveInfo(String string2, String string3, CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrapStatic("buildDummyResolveInfo", $$robo$$android_view_inputmethod_InputMethodInfo$buildDummyResolveInfo(java.lang.String java.lang.String java.lang.CharSequence ), 0, (String)string2, (String)string3, (CharSequence)charSequence);
    }

    public String getId() {
        return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_view_inputmethod_InputMethodInfo$getId(), 0, this);
    }

    public String getPackageName() {
        return InvokeDynamicSupport.bootstrap("getPackageName", $$robo$$android_view_inputmethod_InputMethodInfo$getPackageName(), 0, this);
    }

    public String getServiceName() {
        return InvokeDynamicSupport.bootstrap("getServiceName", $$robo$$android_view_inputmethod_InputMethodInfo$getServiceName(), 0, this);
    }

    public ServiceInfo getServiceInfo() {
        return InvokeDynamicSupport.bootstrap("getServiceInfo", $$robo$$android_view_inputmethod_InputMethodInfo$getServiceInfo(), 0, this);
    }

    public ComponentName getComponent() {
        return InvokeDynamicSupport.bootstrap("getComponent", $$robo$$android_view_inputmethod_InputMethodInfo$getComponent(), 0, this);
    }

    public CharSequence loadLabel(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadLabel", $$robo$$android_view_inputmethod_InputMethodInfo$loadLabel(android.content.pm.PackageManager ), 0, this, packageManager);
    }

    public Drawable loadIcon(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadIcon", $$robo$$android_view_inputmethod_InputMethodInfo$loadIcon(android.content.pm.PackageManager ), 0, this, packageManager);
    }

    public String getSettingsActivity() {
        return InvokeDynamicSupport.bootstrap("getSettingsActivity", $$robo$$android_view_inputmethod_InputMethodInfo$getSettingsActivity(), 0, this);
    }

    public int getSubtypeCount() {
        return (int)InvokeDynamicSupport.bootstrap("getSubtypeCount", $$robo$$android_view_inputmethod_InputMethodInfo$getSubtypeCount(), 0, this);
    }

    public InputMethodSubtype getSubtypeAt(int n) {
        return InvokeDynamicSupport.bootstrap("getSubtypeAt", $$robo$$android_view_inputmethod_InputMethodInfo$getSubtypeAt(int ), 0, this, n);
    }

    public int getIsDefaultResourceId() {
        return (int)InvokeDynamicSupport.bootstrap("getIsDefaultResourceId", $$robo$$android_view_inputmethod_InputMethodInfo$getIsDefaultResourceId(), 0, this);
    }

    public boolean isDefault(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDefault", $$robo$$android_view_inputmethod_InputMethodInfo$isDefault(android.content.Context ), 0, this, context);
    }

    public void dump(Printer printer, String string2) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_view_inputmethod_InputMethodInfo$dump(android.util.Printer java.lang.String ), 0, this, printer, string2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_inputmethod_InputMethodInfo$toString(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_view_inputmethod_InputMethodInfo$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_view_inputmethod_InputMethodInfo$hashCode(), 0, this);
    }

    public boolean isAuxiliaryIme() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAuxiliaryIme", $$robo$$android_view_inputmethod_InputMethodInfo$isAuxiliaryIme(), 0, this);
    }

    public boolean supportsSwitchingToNextInputMethod() {
        return (boolean)InvokeDynamicSupport.bootstrap("supportsSwitchingToNextInputMethod", $$robo$$android_view_inputmethod_InputMethodInfo$supportsSwitchingToNextInputMethod(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_inputmethod_InputMethodInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_inputmethod_InputMethodInfo$describeContents(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(InputMethodInfo.class);
    }

    public /* synthetic */ InputMethodInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputMethodInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

