/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.view.textclassifier.EntityConfidence;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class TextSelection
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private int mStartIndex;
    private int mEndIndex;
    private EntityConfidence<String> mEntityConfidence;
    private List<String> mEntities;
    private String mLogSource;
    private String mVersionInfo;

    private void $$robo$$android_view_textclassifier_TextSelection$__constructor__(int startIndex, int endIndex, EntityConfidence<String> entityConfidence, String logSource, String versionInfo) {
        this.mStartIndex = startIndex;
        this.mEndIndex = endIndex;
        this.mEntityConfidence = new EntityConfidence<String>(entityConfidence);
        this.mEntities = this.mEntityConfidence.getEntities();
        this.mLogSource = logSource;
        this.mVersionInfo = versionInfo;
    }

    private final int $$robo$$android_view_textclassifier_TextSelection$getSelectionStartIndex() {
        return this.mStartIndex;
    }

    private final int $$robo$$android_view_textclassifier_TextSelection$getSelectionEndIndex() {
        return this.mEndIndex;
    }

    private final int $$robo$$android_view_textclassifier_TextSelection$getEntityCount() {
        return this.mEntities.size();
    }

    private final String $$robo$$android_view_textclassifier_TextSelection$getEntity(int index) {
        return this.mEntities.get(index);
    }

    private final float $$robo$$android_view_textclassifier_TextSelection$getConfidenceScore(String entity) {
        return this.mEntityConfidence.getConfidenceScore(entity);
    }

    private final String $$robo$$android_view_textclassifier_TextSelection$getSourceClassifier() {
        return this.mLogSource;
    }

    private final String $$robo$$android_view_textclassifier_TextSelection$getVersionInfo() {
        return this.mVersionInfo;
    }

    private final String $$robo$$android_view_textclassifier_TextSelection$toString() {
        return String.format("TextSelection {%d, %d, %s}", this.mStartIndex, this.mEndIndex, this.mEntityConfidence);
    }

    private /* synthetic */ void $$robo$$android_view_textclassifier_TextSelection$__constructor__(int x0, int x1, EntityConfidence x2, String x3, String x4, 1 x5) {
    }

    private void __constructor__(int n, int n2, EntityConfidence<String> entityConfidence, String string2, String string3) {
        this.$$robo$$android_view_textclassifier_TextSelection$__constructor__(n, n2, entityConfidence, string2, string3);
    }

    private TextSelection(int n, int n2, EntityConfidence<String> entityConfidence, String string2, String string3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextSelection$__constructor__(int int android.view.textclassifier.EntityConfidence<java.lang.String> java.lang.String java.lang.String ), 0, this, n, n2, entityConfidence, string2, string3);
    }

    public int getSelectionStartIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getSelectionStartIndex", $$robo$$android_view_textclassifier_TextSelection$getSelectionStartIndex(), 0, this);
    }

    public int getSelectionEndIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getSelectionEndIndex", $$robo$$android_view_textclassifier_TextSelection$getSelectionEndIndex(), 0, this);
    }

    public int getEntityCount() {
        return (int)InvokeDynamicSupport.bootstrap("getEntityCount", $$robo$$android_view_textclassifier_TextSelection$getEntityCount(), 0, this);
    }

    public String getEntity(int n) {
        return InvokeDynamicSupport.bootstrap("getEntity", $$robo$$android_view_textclassifier_TextSelection$getEntity(int ), 0, this, n);
    }

    public float getConfidenceScore(String string2) {
        return (float)InvokeDynamicSupport.bootstrap("getConfidenceScore", $$robo$$android_view_textclassifier_TextSelection$getConfidenceScore(java.lang.String ), 0, this, string2);
    }

    public String getSourceClassifier() {
        return InvokeDynamicSupport.bootstrap("getSourceClassifier", $$robo$$android_view_textclassifier_TextSelection$getSourceClassifier(), 0, this);
    }

    public String getVersionInfo() {
        return InvokeDynamicSupport.bootstrap("getVersionInfo", $$robo$$android_view_textclassifier_TextSelection$getVersionInfo(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_textclassifier_TextSelection$toString(), 0, this);
    }

    private /* synthetic */ void __constructor__(int n, int n2, EntityConfidence entityConfidence, String string2, String string3, 1 var6_6) {
        this.$$robo$$android_view_textclassifier_TextSelection$__constructor__(n, n2, entityConfidence, string2, string3, var6_6);
    }

    public /* synthetic */ TextSelection() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextSelection)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mStartIndex;
        private int mEndIndex;
        private EntityConfidence<String> mEntityConfidence;
        private String mLogSource;
        private String mVersionInfo;

        private void $$robo$$android_view_textclassifier_TextSelection_Builder$__constructor__(int startIndex, int endIndex) {
            this.mEntityConfidence = new EntityConfidence();
            this.mLogSource = "";
            this.mVersionInfo = "";
            Preconditions.checkArgument(startIndex >= 0);
            Preconditions.checkArgument(endIndex > startIndex);
            this.mStartIndex = startIndex;
            this.mEndIndex = endIndex;
        }

        private final Builder $$robo$$android_view_textclassifier_TextSelection_Builder$setEntityType(String type, float confidenceScore) {
            this.mEntityConfidence.setEntityType(type, confidenceScore);
            return this;
        }

        private final Builder $$robo$$android_view_textclassifier_TextSelection_Builder$setLogSource(String logSource) {
            this.mLogSource = Preconditions.checkNotNull(logSource);
            return this;
        }

        private final Builder $$robo$$android_view_textclassifier_TextSelection_Builder$setVersionInfo(String versionInfo) {
            this.mVersionInfo = Preconditions.checkNotNull(versionInfo);
            return this;
        }

        private final TextSelection $$robo$$android_view_textclassifier_TextSelection_Builder$build() {
            return new TextSelection(this.mStartIndex, this.mEndIndex, this.mEntityConfidence, this.mLogSource, this.mVersionInfo);
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_view_textclassifier_TextSelection_Builder$__constructor__(n, n2);
        }

        public Builder(int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextSelection_Builder$__constructor__(int int ), 0, this, n, n2);
        }

        public Builder setEntityType(String string2, float f) {
            return InvokeDynamicSupport.bootstrap("setEntityType", $$robo$$android_view_textclassifier_TextSelection_Builder$setEntityType(java.lang.String float ), 0, this, string2, f);
        }

        Builder setLogSource(String string2) {
            return InvokeDynamicSupport.bootstrap("setLogSource", $$robo$$android_view_textclassifier_TextSelection_Builder$setLogSource(java.lang.String ), 0, this, string2);
        }

        Builder setVersionInfo(String string2) {
            return InvokeDynamicSupport.bootstrap("setVersionInfo", $$robo$$android_view_textclassifier_TextSelection_Builder$setVersionInfo(java.lang.String ), 0, this, string2);
        }

        public TextSelection build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_view_textclassifier_TextSelection_Builder$build(), 0, this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

