/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier.logging;

import android.content.Context;
import android.metrics.LogMaker;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextSelection;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.invoke.CallSite;
import java.util.Objects;
import java.util.UUID;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class SmartSelectionEventTracker
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "SmartSelectEventTracker";
    private static boolean DEBUG_LOG_ENABLED = false;
    private static int START_EVENT_DELTA = 1117;
    private static int PREV_EVENT_DELTA = 1118;
    private static int INDEX = 1120;
    private static int VERSION_TAG = 1121;
    private static int SMART_INDICES = 1123;
    private static int EVENT_INDICES = 1122;
    private static int SESSION_ID = 1119;
    private static String ZERO = "0";
    private static String TEXTVIEW = "textview";
    private static String EDITTEXT = "edittext";
    private static String WEBVIEW = "webview";
    private static String EDIT_WEBVIEW = "edit-webview";
    private static String UNKNOWN = "unknown";
    private MetricsLogger mMetricsLogger;
    private int mWidgetType;
    private Context mContext;
    private String mSessionId;
    private int[] mSmartIndices;
    private int[] mPrevIndices;
    private int mOrigStart;
    private int mIndex;
    private long mSessionStartTime;
    private long mLastEventTime;
    private boolean mSmartSelectionTriggered;
    private String mVersionTag;

    private void $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$__constructor__(Context context, int widgetType) {
        this.mMetricsLogger = new MetricsLogger();
        this.mSmartIndices = new int[2];
        this.mPrevIndices = new int[2];
        this.mWidgetType = widgetType;
        this.mContext = Preconditions.checkNotNull(context);
    }

    private final void $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$logEvent(SelectionEvent event) {
        Preconditions.checkNotNull(event);
        if (event.mEventType == 1 || this.mSessionId == null) {
            // empty if block
        }
        CallSite now = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        switch (event.mEventType) {
            case 1: {
                this.mSessionId = this.startNewSession();
                Preconditions.checkArgument(event.mEnd == event.mStart + 1);
                this.mOrigStart = event.mStart;
                this.mSessionStartTime = (long)now;
                break;
            }
            case 3: 
            case 4: {
                this.mSmartSelectionTriggered = true;
                this.mVersionTag = this.getVersionTag(event);
                this.mSmartIndices[0] = event.mStart;
                this.mSmartIndices[1] = event.mEnd;
                break;
            }
            case 2: 
            case 5: {
                if (this.mPrevIndices[0] != event.mStart || this.mPrevIndices[1] != event.mEnd) break;
                return;
            }
        }
        this.writeEvent(event, (long)now);
        if (event.isTerminal()) {
            this.endSession();
        }
    }

    private final void $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$writeEvent(SelectionEvent event, long now) {
        long prevEventDelta = this.mLastEventTime == 0L ? 0L : now - this.mLastEventTime;
        LogMaker log = new LogMaker(1100).setType(SmartSelectionEventTracker.getLogType(event)).setSubtype(SmartSelectionEventTracker.getLogSubType(event)).setPackageName(this.mContext.getPackageName()).setTimestamp(now).addTaggedData(1117, now - this.mSessionStartTime).addTaggedData(1118, prevEventDelta).addTaggedData(1120, this.mIndex).addTaggedData(1121, this.mVersionTag).addTaggedData(1123, this.getSmartDelta()).addTaggedData(1122, this.getEventDelta(event)).addTaggedData(1119, this.mSessionId);
        this.mMetricsLogger.write(log);
        SmartSelectionEventTracker.debugLog(log);
        this.mLastEventTime = now;
        this.mPrevIndices[0] = event.mStart;
        this.mPrevIndices[1] = event.mEnd;
        ++this.mIndex;
    }

    private final String $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$startNewSession() {
        this.endSession();
        this.mSessionId = SmartSelectionEventTracker.createSessionId();
        return this.mSessionId;
    }

    private final void $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$endSession() {
        this.mOrigStart = 0;
        this.mSmartIndices[1] = 0;
        this.mSmartIndices[0] = 0;
        this.mPrevIndices[1] = 0;
        this.mPrevIndices[0] = 0;
        this.mIndex = 0;
        this.mSessionStartTime = 0L;
        this.mLastEventTime = 0L;
        this.mSmartSelectionTriggered = false;
        this.mVersionTag = this.getVersionTag(null);
        this.mSessionId = null;
    }

    private static final int $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$getLogType(SelectionEvent event) {
        switch (event.mEventType) {
            case 100: {
                return 1108;
            }
            case 101: {
                return 1109;
            }
            case 102: {
                return 1110;
            }
            case 103: {
                return 1111;
            }
            case 104: {
                return 1112;
            }
            case 105: {
                return 1113;
            }
            case 106: {
                return 1114;
            }
            case 107: {
                return 1115;
            }
            case 108: {
                return 1116;
            }
            case 200: {
                return 1103;
            }
            case 201: {
                return 1104;
            }
            case 1: {
                return 1101;
            }
            case 2: {
                return 1102;
            }
            case 3: {
                return 1105;
            }
            case 4: {
                return 1106;
            }
            case 5: {
                return 1107;
            }
        }
        return 0;
    }

    private static final String $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$getLogTypeString(int logType) {
        switch (logType) {
            case 1108: {
                return "OVERTYPE";
            }
            case 1109: {
                return "COPY";
            }
            case 1110: {
                return "PASTE";
            }
            case 1111: {
                return "CUT";
            }
            case 1112: {
                return "SHARE";
            }
            case 1113: {
                return "SMART_SHARE";
            }
            case 1114: {
                return "DRAG";
            }
            case 1115: {
                return "ABANDON";
            }
            case 1116: {
                return "OTHER";
            }
            case 1103: {
                return "SELECT_ALL";
            }
            case 1104: {
                return "RESET";
            }
            case 1101: {
                return "SELECTION_STARTED";
            }
            case 1102: {
                return "SELECTION_MODIFIED";
            }
            case 1105: {
                return "SMART_SELECTION_SINGLE";
            }
            case 1106: {
                return "SMART_SELECTION_MULTI";
            }
            case 1107: {
                return "AUTO_SELECTION";
            }
        }
        return "unknown";
    }

    private static final int $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$getLogSubType(SelectionEvent event) {
        switch (event.mEntityType) {
            case "other": {
                return 2;
            }
            case "email": {
                return 3;
            }
            case "phone": {
                return 4;
            }
            case "address": {
                return 5;
            }
            case "url": {
                return 6;
            }
        }
        return 1;
    }

    private static final String $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$getLogSubTypeString(int logSubType) {
        switch (logSubType) {
            case 2: {
                return "other";
            }
            case 3: {
                return "email";
            }
            case 4: {
                return "phone";
            }
            case 5: {
                return "address";
            }
            case 6: {
                return "url";
            }
        }
        return "";
    }

    private final int $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$getSmartDelta() {
        if (this.mSmartSelectionTriggered) {
            return SmartSelectionEventTracker.clamp(this.mSmartIndices[0] - this.mOrigStart) << 16 | SmartSelectionEventTracker.clamp(this.mSmartIndices[1] - this.mOrigStart) & 0xFFFF;
        }
        return 0;
    }

    private final int $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$getEventDelta(SelectionEvent event) {
        return SmartSelectionEventTracker.clamp(event.mStart - this.mOrigStart) << 16 | SmartSelectionEventTracker.clamp(event.mEnd - this.mOrigStart) & 0xFFFF;
    }

    private final String $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$getVersionTag(SelectionEvent event) {
        String widgetType;
        switch (this.mWidgetType) {
            case 1: {
                widgetType = "textview";
                break;
            }
            case 2: {
                widgetType = "webview";
                break;
            }
            case 3: {
                widgetType = "edittext";
                break;
            }
            case 4: {
                widgetType = "edit-webview";
                break;
            }
            default: {
                widgetType = "unknown";
            }
        }
        String version = event == null ? "" : Objects.toString(event.mVersionTag, "");
        return String.format("%s/%s", widgetType, version);
    }

    private static final String $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$createSessionId() {
        return UUID.randomUUID().toString();
    }

    private static final int $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$clamp(int val) {
        return Math.max(Math.min(val, Short.MAX_VALUE), Short.MIN_VALUE);
    }

    private static final void $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$debugLog(LogMaker log) {
    }

    private void __constructor__(Context context, int n) {
        this.$$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$__constructor__(context, n);
    }

    public SmartSelectionEventTracker(Context context, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$__constructor__(android.content.Context int ), 0, this, context, n);
    }

    public void logEvent(SelectionEvent selectionEvent) {
        InvokeDynamicSupport.bootstrap("logEvent", $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$logEvent(android.view.textclassifier.logging.SmartSelectionEventTracker$SelectionEvent ), 0, this, selectionEvent);
    }

    private void writeEvent(SelectionEvent selectionEvent, long l) {
        InvokeDynamicSupport.bootstrap("writeEvent", $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$writeEvent(android.view.textclassifier.logging.SmartSelectionEventTracker$SelectionEvent long ), 0, this, selectionEvent, l);
    }

    private String startNewSession() {
        return InvokeDynamicSupport.bootstrap("startNewSession", $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$startNewSession(), 0, this);
    }

    private void endSession() {
        InvokeDynamicSupport.bootstrap("endSession", $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$endSession(), 0, this);
    }

    private static int getLogType(SelectionEvent selectionEvent) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getLogType", $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$getLogType(android.view.textclassifier.logging.SmartSelectionEventTracker$SelectionEvent ), 0, (SelectionEvent)selectionEvent);
    }

    private static String getLogTypeString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getLogTypeString", $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$getLogTypeString(int ), 0, (int)n);
    }

    private static int getLogSubType(SelectionEvent selectionEvent) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getLogSubType", $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$getLogSubType(android.view.textclassifier.logging.SmartSelectionEventTracker$SelectionEvent ), 0, (SelectionEvent)selectionEvent);
    }

    private static String getLogSubTypeString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getLogSubTypeString", $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$getLogSubTypeString(int ), 0, (int)n);
    }

    private int getSmartDelta() {
        return (int)InvokeDynamicSupport.bootstrap("getSmartDelta", $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$getSmartDelta(), 0, this);
    }

    private int getEventDelta(SelectionEvent selectionEvent) {
        return (int)InvokeDynamicSupport.bootstrap("getEventDelta", $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$getEventDelta(android.view.textclassifier.logging.SmartSelectionEventTracker$SelectionEvent ), 0, this, selectionEvent);
    }

    private String getVersionTag(SelectionEvent selectionEvent) {
        return InvokeDynamicSupport.bootstrap("getVersionTag", $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$getVersionTag(android.view.textclassifier.logging.SmartSelectionEventTracker$SelectionEvent ), 0, this, selectionEvent);
    }

    private static String createSessionId() {
        return InvokeDynamicSupport.bootstrapStatic("createSessionId", $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$createSessionId(), 0);
    }

    private static int clamp(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("clamp", $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$clamp(int ), 0, (int)n);
    }

    private static void debugLog(LogMaker logMaker) {
        InvokeDynamicSupport.bootstrapStatic("debugLog", $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker$debugLog(android.metrics.LogMaker ), 0, (LogMaker)logMaker);
    }

    public /* synthetic */ SmartSelectionEventTracker() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmartSelectionEventTracker)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class SelectionEvent
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int OUT_OF_BOUNDS = Short.MAX_VALUE;
        public static int OUT_OF_BOUNDS_NEGATIVE = Short.MIN_VALUE;
        private static String NO_VERSION_TAG = "";
        private int mStart;
        private int mEnd;
        private int mEventType;
        private String mEntityType;
        private String mVersionTag;

        private void $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker_SelectionEvent$__constructor__(int start, int end, int eventType, String entityType, String versionTag) {
            Preconditions.checkArgument(end >= start, "end cannot be less than start");
            this.mStart = start;
            this.mEnd = end;
            this.mEventType = eventType;
            this.mEntityType = Preconditions.checkNotNull(entityType);
            this.mVersionTag = Preconditions.checkNotNull(versionTag);
        }

        private static final SelectionEvent $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker_SelectionEvent$selectionStarted(int start) {
            return new SelectionEvent(start, start + 1, 1, "", "");
        }

        private static final SelectionEvent $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker_SelectionEvent$selectionModified(int start, int end) {
            return new SelectionEvent(start, end, 2, "", "");
        }

        private static final SelectionEvent $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker_SelectionEvent$selectionModified(int start, int end, TextClassification classification) {
            String entityType = classification.getEntityCount() > 0 ? classification.getEntity(0) : "";
            String versionTag = classification.getVersionInfo();
            return new SelectionEvent(start, end, 2, entityType, versionTag);
        }

        private static final SelectionEvent $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker_SelectionEvent$selectionModified(int start, int end, TextSelection selection) {
            boolean smartSelection = selection.getSourceClassifier().equals("TextClassifierImpl");
            int eventType = smartSelection ? (end - start > 1 ? 4 : 3) : 5;
            String entityType = selection.getEntityCount() > 0 ? selection.getEntity(0) : "";
            String versionTag = selection.getVersionInfo();
            return new SelectionEvent(start, end, eventType, entityType, versionTag);
        }

        private static final SelectionEvent $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker_SelectionEvent$selectionAction(int start, int end, int actionType) {
            return new SelectionEvent(start, end, actionType, "", "");
        }

        private static final SelectionEvent $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker_SelectionEvent$selectionAction(int start, int end, int actionType, TextClassification classification) {
            String entityType = classification.getEntityCount() > 0 ? classification.getEntity(0) : "";
            String versionTag = classification.getVersionInfo();
            return new SelectionEvent(start, end, actionType, entityType, versionTag);
        }

        private final boolean $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker_SelectionEvent$isActionType() {
            switch (this.mEventType) {
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 200: 
                case 201: {
                    return true;
                }
            }
            return false;
        }

        private final boolean $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker_SelectionEvent$isTerminal() {
            switch (this.mEventType) {
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: {
                    return true;
                }
            }
            return false;
        }

        private void __constructor__(int n, int n2, int n3, String string2, String string3) {
            this.$$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker_SelectionEvent$__constructor__(n, n2, n3, string2, string3);
        }

        private SelectionEvent(int n, int n2, int n3, String string2, String string3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker_SelectionEvent$__constructor__(int int int java.lang.String java.lang.String ), 0, this, n, n2, n3, string2, string3);
        }

        public static SelectionEvent selectionStarted(int n) {
            return InvokeDynamicSupport.bootstrapStatic("selectionStarted", $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker_SelectionEvent$selectionStarted(int ), 0, (int)n);
        }

        public static SelectionEvent selectionModified(int n, int n2) {
            return InvokeDynamicSupport.bootstrapStatic("selectionModified", $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker_SelectionEvent$selectionModified(int int ), 0, (int)n, (int)n2);
        }

        public static SelectionEvent selectionModified(int n, int n2, TextClassification textClassification) {
            return InvokeDynamicSupport.bootstrapStatic("selectionModified", $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker_SelectionEvent$selectionModified(int int android.view.textclassifier.TextClassification ), 0, (int)n, (int)n2, (TextClassification)textClassification);
        }

        public static SelectionEvent selectionModified(int n, int n2, TextSelection textSelection) {
            return InvokeDynamicSupport.bootstrapStatic("selectionModified", $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker_SelectionEvent$selectionModified(int int android.view.textclassifier.TextSelection ), 0, (int)n, (int)n2, (TextSelection)textSelection);
        }

        public static SelectionEvent selectionAction(int n, int n2, int n3) {
            return InvokeDynamicSupport.bootstrapStatic("selectionAction", $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker_SelectionEvent$selectionAction(int int int ), 0, (int)n, (int)n2, (int)n3);
        }

        public static SelectionEvent selectionAction(int n, int n2, int n3, TextClassification textClassification) {
            return InvokeDynamicSupport.bootstrapStatic("selectionAction", $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker_SelectionEvent$selectionAction(int int int android.view.textclassifier.TextClassification ), 0, (int)n, (int)n2, (int)n3, (TextClassification)textClassification);
        }

        private boolean isActionType() {
            return (boolean)InvokeDynamicSupport.bootstrap("isActionType", $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker_SelectionEvent$isActionType(), 0, this);
        }

        private boolean isTerminal() {
            return (boolean)InvokeDynamicSupport.bootstrap("isTerminal", $$robo$$android_view_textclassifier_logging_SmartSelectionEventTracker_SelectionEvent$isTerminal(), 0, this);
        }

        public /* synthetic */ SelectionEvent() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SelectionEvent)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        private static @interface EventType {
            public static final int SELECTION_STARTED = 1;
            public static final int SELECTION_MODIFIED = 2;
            public static final int SMART_SELECTION_SINGLE = 3;
            public static final int SMART_SELECTION_MULTI = 4;
            public static final int AUTO_SELECTION = 5;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ActionType {
            public static final int OVERTYPE = 100;
            public static final int COPY = 101;
            public static final int PASTE = 102;
            public static final int CUT = 103;
            public static final int SHARE = 104;
            public static final int SMART_SHARE = 105;
            public static final int DRAG = 106;
            public static final int ABANDON = 107;
            public static final int OTHER = 108;
            public static final int SELECT_ALL = 200;
            public static final int RESET = 201;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WidgetType {
        public static final int UNSPECIFIED = 0;
        public static final int TEXTVIEW = 1;
        public static final int WEBVIEW = 2;
        public static final int EDITTEXT = 3;
        public static final int EDIT_WEBVIEW = 4;
    }
}

