/*
 * Decompiled with CFR 0.152.
 */
package android.view.textservice;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.PrintWriterPrinter;
import android.util.Xml;
import android.view.textservice.SpellCheckerSubtype;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParserException;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class SpellCheckerInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private ResolveInfo mService;
    private String mId;
    private int mLabel;
    private String mSettingsActivityName;
    private ArrayList<SpellCheckerSubtype> mSubtypes;
    public static Parcelable.Creator<SpellCheckerInfo> CREATOR;

    private void $$robo$$android_view_textservice_SpellCheckerInfo$__constructor__(Context context, ResolveInfo service) throws XmlPullParserException, IOException {
        this.mSubtypes = new ArrayList();
        this.mService = service;
        ServiceInfo si = service.serviceInfo;
        this.mId = new ComponentName(si.packageName, si.name).flattenToShortString();
        PackageManager pm = context.getPackageManager();
        int label = 0;
        String settingsActivityComponent = null;
        try (XmlResourceParser parser = null;){
            int type;
            parser = si.loadXmlMetaData(pm, "android.view.textservice.scs");
            if (parser == null) {
                throw new XmlPullParserException("No android.view.textservice.scs meta-data");
            }
            Resources res = pm.getResourcesForApplication(si.applicationInfo);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!"spell-checker".equals(nodeName)) {
                throw new XmlPullParserException("Meta-data does not start with spell-checker tag");
            }
            TypedArray sa = res.obtainAttributes(attrs, R.styleable.SpellChecker);
            label = sa.getResourceId(0, 0);
            settingsActivityComponent = sa.getString(1);
            sa.recycle();
            int depth = parser.getDepth();
            while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
                if (type != 2) continue;
                String subtypeNodeName = parser.getName();
                if (!"subtype".equals(subtypeNodeName)) {
                    throw new XmlPullParserException("Meta-data in spell-checker does not start with subtype tag");
                }
                TypedArray a = res.obtainAttributes(attrs, R.styleable.SpellChecker_Subtype);
                SpellCheckerSubtype subtype = new SpellCheckerSubtype(a.getResourceId(0, 0), a.getString(1), a.getString(4), a.getString(2), a.getInt(3, 0));
                this.mSubtypes.add(subtype);
            }
        }
        this.mLabel = label;
        this.mSettingsActivityName = settingsActivityComponent;
    }

    private void $$robo$$android_view_textservice_SpellCheckerInfo$__constructor__(Parcel source) {
        this.mSubtypes = new ArrayList();
        this.mLabel = source.readInt();
        this.mId = source.readString();
        this.mSettingsActivityName = source.readString();
        this.mService = ResolveInfo.CREATOR.createFromParcel(source);
        source.readTypedList(this.mSubtypes, SpellCheckerSubtype.CREATOR);
    }

    private final String $$robo$$android_view_textservice_SpellCheckerInfo$getId() {
        return this.mId;
    }

    private final ComponentName $$robo$$android_view_textservice_SpellCheckerInfo$getComponent() {
        return new ComponentName(this.mService.serviceInfo.packageName, this.mService.serviceInfo.name);
    }

    private final String $$robo$$android_view_textservice_SpellCheckerInfo$getPackageName() {
        return this.mService.serviceInfo.packageName;
    }

    private final void $$robo$$android_view_textservice_SpellCheckerInfo$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mLabel);
        dest.writeString(this.mId);
        dest.writeString(this.mSettingsActivityName);
        this.mService.writeToParcel(dest, flags);
        dest.writeTypedList(this.mSubtypes);
    }

    private final CharSequence $$robo$$android_view_textservice_SpellCheckerInfo$loadLabel(PackageManager pm) {
        if (this.mLabel == 0 || pm == null) {
            return "";
        }
        return pm.getText(this.getPackageName(), this.mLabel, this.mService.serviceInfo.applicationInfo);
    }

    private final Drawable $$robo$$android_view_textservice_SpellCheckerInfo$loadIcon(PackageManager pm) {
        return this.mService.loadIcon(pm);
    }

    private final ServiceInfo $$robo$$android_view_textservice_SpellCheckerInfo$getServiceInfo() {
        return this.mService.serviceInfo;
    }

    private final String $$robo$$android_view_textservice_SpellCheckerInfo$getSettingsActivity() {
        return this.mSettingsActivityName;
    }

    private final int $$robo$$android_view_textservice_SpellCheckerInfo$getSubtypeCount() {
        return this.mSubtypes.size();
    }

    private final SpellCheckerSubtype $$robo$$android_view_textservice_SpellCheckerInfo$getSubtypeAt(int index) {
        return this.mSubtypes.get(index);
    }

    private final int $$robo$$android_view_textservice_SpellCheckerInfo$describeContents() {
        return 0;
    }

    private final void $$robo$$android_view_textservice_SpellCheckerInfo$dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "mId=" + this.mId);
        pw.println(prefix + "mSettingsActivityName=" + this.mSettingsActivityName);
        pw.println(prefix + "Service:");
        this.mService.dump(new PrintWriterPrinter(pw), prefix + "  ");
        int N = this.getSubtypeCount();
        for (int i = 0; i < N; ++i) {
            SpellCheckerSubtype st = this.getSubtypeAt(i);
            pw.println(prefix + "  " + "Subtype #" + i + ":");
            pw.println(prefix + "    " + "locale=" + st.getLocale() + " languageTag=" + st.getLanguageTag());
            pw.println(prefix + "    " + "extraValue=" + st.getExtraValue());
        }
    }

    static void __staticInitializer__() {
        TAG = SpellCheckerInfo.class.getSimpleName();
        CREATOR = new Parcelable.Creator<SpellCheckerInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_textservice_SpellCheckerInfo_1$__constructor__() {
            }

            private final SpellCheckerInfo $$robo$$android_view_textservice_SpellCheckerInfo_1$createFromParcel(Parcel source) {
                return new SpellCheckerInfo(source);
            }

            private final SpellCheckerInfo[] $$robo$$android_view_textservice_SpellCheckerInfo_1$newArray(int size) {
                return new SpellCheckerInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_view_textservice_SpellCheckerInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textservice_SpellCheckerInfo_1$__constructor__(), 0, this);
            }

            @Override
            public SpellCheckerInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_textservice_SpellCheckerInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public SpellCheckerInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_textservice_SpellCheckerInfo_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Context context, ResolveInfo resolveInfo) throws XmlPullParserException, IOException {
        this.$$robo$$android_view_textservice_SpellCheckerInfo$__constructor__(context, resolveInfo);
    }

    public SpellCheckerInfo(Context context, ResolveInfo resolveInfo) throws XmlPullParserException, IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textservice_SpellCheckerInfo$__constructor__(android.content.Context android.content.pm.ResolveInfo ), 0, this, context, resolveInfo);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_view_textservice_SpellCheckerInfo$__constructor__(parcel);
    }

    public SpellCheckerInfo(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textservice_SpellCheckerInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public String getId() {
        return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_view_textservice_SpellCheckerInfo$getId(), 0, this);
    }

    public ComponentName getComponent() {
        return InvokeDynamicSupport.bootstrap("getComponent", $$robo$$android_view_textservice_SpellCheckerInfo$getComponent(), 0, this);
    }

    public String getPackageName() {
        return InvokeDynamicSupport.bootstrap("getPackageName", $$robo$$android_view_textservice_SpellCheckerInfo$getPackageName(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_textservice_SpellCheckerInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public CharSequence loadLabel(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadLabel", $$robo$$android_view_textservice_SpellCheckerInfo$loadLabel(android.content.pm.PackageManager ), 0, this, packageManager);
    }

    public Drawable loadIcon(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadIcon", $$robo$$android_view_textservice_SpellCheckerInfo$loadIcon(android.content.pm.PackageManager ), 0, this, packageManager);
    }

    public ServiceInfo getServiceInfo() {
        return InvokeDynamicSupport.bootstrap("getServiceInfo", $$robo$$android_view_textservice_SpellCheckerInfo$getServiceInfo(), 0, this);
    }

    public String getSettingsActivity() {
        return InvokeDynamicSupport.bootstrap("getSettingsActivity", $$robo$$android_view_textservice_SpellCheckerInfo$getSettingsActivity(), 0, this);
    }

    public int getSubtypeCount() {
        return (int)InvokeDynamicSupport.bootstrap("getSubtypeCount", $$robo$$android_view_textservice_SpellCheckerInfo$getSubtypeCount(), 0, this);
    }

    public SpellCheckerSubtype getSubtypeAt(int n) {
        return InvokeDynamicSupport.bootstrap("getSubtypeAt", $$robo$$android_view_textservice_SpellCheckerInfo$getSubtypeAt(int ), 0, this, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_textservice_SpellCheckerInfo$describeContents(), 0, this);
    }

    public void dump(PrintWriter printWriter, String string2) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_view_textservice_SpellCheckerInfo$dump(java.io.PrintWriter java.lang.String ), 0, this, printWriter, string2);
    }

    static {
        RobolectricInternals.classInitializing(SpellCheckerInfo.class);
    }

    public /* synthetic */ SpellCheckerInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SpellCheckerInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

