/*
 * Decompiled with CFR 0.152.
 */
package android.view.textservice;

import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.view.textservice.SpellCheckerInfo;
import android.view.textservice.SpellCheckerSession;
import android.view.textservice.SpellCheckerSubtype;
import com.android.internal.textservice.ITextServicesManager;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class TextServicesManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static boolean DBG = false;
    private static TextServicesManager sInstance;
    private ITextServicesManager mService;

    private void $$robo$$android_view_textservice_TextServicesManager$__constructor__() throws ServiceManager.ServiceNotFoundException {
        this.mService = ITextServicesManager.Stub.asInterface(ServiceManager.getServiceOrThrow("textservices"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final TextServicesManager $$robo$$android_view_textservice_TextServicesManager$getInstance() {
        Class<TextServicesManager> clazz = TextServicesManager.class;
        synchronized (TextServicesManager.class) {
            if (sInstance == null) {
                try {
                    sInstance = new TextServicesManager();
                }
                catch (ServiceManager.ServiceNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private static final String $$robo$$android_view_textservice_TextServicesManager$parseLanguageFromLocaleString(String locale) {
        int idx = locale.indexOf(95);
        if (idx < 0) {
            return locale;
        }
        return locale.substring(0, idx);
    }

    private final SpellCheckerSession $$robo$$android_view_textservice_TextServicesManager$newSpellCheckerSession(Bundle bundle, Locale locale, SpellCheckerSession.SpellCheckerSessionListener listener, boolean referToSpellCheckerLanguageSettings) {
        SpellCheckerInfo sci;
        if (listener == null) {
            throw new NullPointerException();
        }
        if (!referToSpellCheckerLanguageSettings && locale == null) {
            throw new IllegalArgumentException("Locale should not be null if you don't refer settings.");
        }
        if (referToSpellCheckerLanguageSettings && !this.isSpellCheckerEnabled()) {
            return null;
        }
        try {
            sci = this.mService.getCurrentSpellChecker(null);
        }
        catch (RemoteException e) {
            return null;
        }
        if (sci == null) {
            return null;
        }
        SpellCheckerSubtype subtypeInUse = null;
        if (referToSpellCheckerLanguageSettings) {
            String subtypeLocale;
            String subtypeLanguage;
            subtypeInUse = this.getCurrentSpellCheckerSubtype(true);
            if (subtypeInUse == null) {
                return null;
            }
            if (!(locale == null || (subtypeLanguage = TextServicesManager.parseLanguageFromLocaleString(subtypeLocale = subtypeInUse.getLocale())).length() >= 2 && locale.getLanguage().equals(subtypeLanguage))) {
                return null;
            }
        } else {
            String localeStr = locale.toString();
            for (int i = 0; i < sci.getSubtypeCount(); ++i) {
                SpellCheckerSubtype subtype = sci.getSubtypeAt(i);
                String tempSubtypeLocale = subtype.getLocale();
                String tempSubtypeLanguage = TextServicesManager.parseLanguageFromLocaleString(tempSubtypeLocale);
                if (tempSubtypeLocale.equals(localeStr)) {
                    subtypeInUse = subtype;
                    break;
                }
                if (tempSubtypeLanguage.length() < 2 || !locale.getLanguage().equals(tempSubtypeLanguage)) continue;
                subtypeInUse = subtype;
            }
        }
        if (subtypeInUse == null) {
            return null;
        }
        SpellCheckerSession session = new SpellCheckerSession(sci, this.mService, listener);
        try {
            this.mService.getSpellCheckerService(sci.getId(), subtypeInUse.getLocale(), session.getTextServicesSessionListener(), session.getSpellCheckerSessionListener(), bundle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return session;
    }

    private final SpellCheckerInfo[] $$robo$$android_view_textservice_TextServicesManager$getEnabledSpellCheckers() {
        try {
            SpellCheckerInfo[] retval = this.mService.getEnabledSpellCheckers();
            return retval;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final SpellCheckerInfo $$robo$$android_view_textservice_TextServicesManager$getCurrentSpellChecker() {
        try {
            return this.mService.getCurrentSpellChecker(null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final SpellCheckerSubtype $$robo$$android_view_textservice_TextServicesManager$getCurrentSpellCheckerSubtype(boolean allowImplicitlySelectedSubtype) {
        try {
            return this.mService.getCurrentSpellCheckerSubtype(null, allowImplicitlySelectedSubtype);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_view_textservice_TextServicesManager$isSpellCheckerEnabled() {
        try {
            return this.mService.isSpellCheckerEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static void __staticInitializer__() {
        TAG = TextServicesManager.class.getSimpleName();
    }

    private void __constructor__() throws ServiceManager.ServiceNotFoundException {
        this.$$robo$$android_view_textservice_TextServicesManager$__constructor__();
    }

    private TextServicesManager() throws ServiceManager.ServiceNotFoundException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textservice_TextServicesManager$__constructor__(), 0, this);
    }

    public static TextServicesManager getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_view_textservice_TextServicesManager$getInstance(), 0);
    }

    private static String parseLanguageFromLocaleString(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("parseLanguageFromLocaleString", $$robo$$android_view_textservice_TextServicesManager$parseLanguageFromLocaleString(java.lang.String ), 0, (String)string2);
    }

    public SpellCheckerSession newSpellCheckerSession(Bundle bundle, Locale locale, SpellCheckerSession.SpellCheckerSessionListener spellCheckerSessionListener, boolean bl) {
        return InvokeDynamicSupport.bootstrap("newSpellCheckerSession", $$robo$$android_view_textservice_TextServicesManager$newSpellCheckerSession(android.os.Bundle java.util.Locale android.view.textservice.SpellCheckerSession$SpellCheckerSessionListener boolean ), 0, this, bundle, locale, spellCheckerSessionListener, bl);
    }

    public SpellCheckerInfo[] getEnabledSpellCheckers() {
        return InvokeDynamicSupport.bootstrap("getEnabledSpellCheckers", $$robo$$android_view_textservice_TextServicesManager$getEnabledSpellCheckers(), 0, this);
    }

    public SpellCheckerInfo getCurrentSpellChecker() {
        return InvokeDynamicSupport.bootstrap("getCurrentSpellChecker", $$robo$$android_view_textservice_TextServicesManager$getCurrentSpellChecker(), 0, this);
    }

    public SpellCheckerSubtype getCurrentSpellCheckerSubtype(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getCurrentSpellCheckerSubtype", $$robo$$android_view_textservice_TextServicesManager$getCurrentSpellCheckerSubtype(boolean ), 0, this, bl);
    }

    public boolean isSpellCheckerEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSpellCheckerEnabled", $$robo$$android_view_textservice_TextServicesManager$isSpellCheckerEnabled(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(TextServicesManager.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextServicesManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

