/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.ActivityManager;
import android.app.AppGlobals;
import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.Trace;
import android.util.AndroidRuntimeException;
import android.util.ArraySet;
import android.util.Log;
import android.webkit.IWebViewUpdateService;
import android.webkit.WebViewDelegate;
import android.webkit.WebViewFactoryProvider;
import android.webkit.WebViewLibraryLoader;
import android.webkit.WebViewProviderResponse;
import android.webkit.WebViewZygote;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.reflect.Method;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class WebViewFactory
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String CHROMIUM_WEBVIEW_FACTORY = "com.android.webview.chromium.WebViewChromiumFactoryProviderForOMR1";
    private static String CHROMIUM_WEBVIEW_FACTORY_METHOD = "create";
    private static String NULL_WEBVIEW_FACTORY = "com.android.webview.nullwebview.NullWebViewFactoryProvider";
    public static String CHROMIUM_WEBVIEW_VMSIZE_SIZE_PROPERTY = "persist.sys.webview.vmsize";
    private static String LOGTAG = "WebViewFactory";
    private static boolean DEBUG = false;
    private static WebViewFactoryProvider sProviderInstance;
    private static Object sProviderLock;
    private static PackageInfo sPackageInfo;
    public static int LIBLOAD_SUCCESS = 0;
    public static int LIBLOAD_WRONG_PACKAGE_NAME = 1;
    public static int LIBLOAD_ADDRESS_SPACE_NOT_RESERVED = 2;
    public static int LIBLOAD_FAILED_WAITING_FOR_RELRO = 3;
    public static int LIBLOAD_FAILED_LISTING_WEBVIEW_PACKAGES = 4;
    public static int LIBLOAD_FAILED_TO_OPEN_RELRO_FILE = 5;
    public static int LIBLOAD_FAILED_TO_LOAD_LIBRARY = 6;
    public static int LIBLOAD_FAILED_JNI_CALL = 7;
    public static int LIBLOAD_FAILED_WAITING_FOR_WEBVIEW_REASON_UNKNOWN = 8;
    public static int LIBLOAD_FAILED_TO_FIND_NAMESPACE = 10;
    private static String WEBVIEW_UPDATE_SERVICE_NAME;

    private void $$robo$$android_webkit_WebViewFactory$__constructor__() {
    }

    private static final String $$robo$$android_webkit_WebViewFactory$getWebViewPreparationErrorReason(int error) {
        switch (error) {
            case 3: {
                return "Time out waiting for Relro files being created";
            }
            case 4: {
                return "No WebView installed";
            }
            case 8: {
                return "Crashed for unknown reason";
            }
        }
        return "Unknown";
    }

    private static final String $$robo$$android_webkit_WebViewFactory$getWebViewLibrary(ApplicationInfo ai) {
        if (ai.metaData != null) {
            return ai.metaData.getString("com.android.webview.WebViewLibrary");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final PackageInfo $$robo$$android_webkit_WebViewFactory$getLoadedPackageInfo() {
        Object object = sProviderLock;
        synchronized (object) {
            return sPackageInfo;
        }
    }

    private static final Class<WebViewFactoryProvider> $$robo$$android_webkit_WebViewFactory$getWebViewProviderClass(ClassLoader clazzLoader) throws ClassNotFoundException {
        return Class.forName("com.android.webview.chromium.WebViewChromiumFactoryProviderForOMR1", true, clazzLoader);
    }

    private static final int $$robo$$android_webkit_WebViewFactory$loadWebViewNativeLibraryFromPackage(String packageName, ClassLoader clazzLoader) {
        PackageInfo packageInfo;
        WebViewProviderResponse response = null;
        try {
            response = WebViewFactory.getUpdateService().waitForAndGetProvider();
        }
        catch (RemoteException e) {
            Log.e("WebViewFactory", "error waiting for relro creation", e);
            return 8;
        }
        if (response.status != 0 && response.status != 3) {
            return response.status;
        }
        if (!response.packageInfo.packageName.equals(packageName)) {
            return 1;
        }
        PackageManager packageManager = AppGlobals.getInitialApplication().getPackageManager();
        try {
            packageInfo = packageManager.getPackageInfo(packageName, 0x10000080);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e("WebViewFactory", "Couldn't find package " + packageName);
            return 1;
        }
        try {
            int loadNativeRet = WebViewLibraryLoader.loadNativeLibrary(clazzLoader, packageInfo);
            if (loadNativeRet == 0) {
                return response.status;
            }
            return loadNativeRet;
        }
        catch (MissingWebViewPackageException e) {
            Log.e("WebViewFactory", "Couldn't load native library: " + e);
            return 6;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private static final WebViewFactoryProvider $$robo$$android_webkit_WebViewFactory$getProvider() {
        Object object = sProviderLock;
        synchronized (object) {
            if (sProviderInstance != null) {
                return sProviderInstance;
            }
            int uid = Process.myUid();
            if (uid == 0 || uid == 1000 || uid == 1001 || uid == 1027 || uid == 1002) {
                throw new UnsupportedOperationException("For security reasons, WebView is not allowed in privileged processes");
            }
            StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
            Trace.traceBegin(16L, "WebViewFactory.getProvider()");
            try {
                WebViewFactoryProvider webViewFactoryProvider;
                Class<WebViewFactoryProvider> providerClass = WebViewFactory.getProviderClass();
                Method staticFactory = null;
                try {
                    staticFactory = providerClass.getMethod("create", WebViewDelegate.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Trace.traceBegin(16L, "WebViewFactoryProvider invocation");
                try {
                    webViewFactoryProvider = sProviderInstance = (WebViewFactoryProvider)staticFactory.invoke(null, new WebViewDelegate());
                }
                catch (Exception e) {
                    Log.e("WebViewFactory", "error instantiating provider", e);
                    throw new AndroidRuntimeException(e);
                }
                finally {
                    Trace.traceEnd(16L);
                }
                return webViewFactoryProvider;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Trace.traceEnd(16L);
                StrictMode.setThreadPolicy(oldPolicy);
            }
        }
    }

    private static final boolean $$robo$$android_webkit_WebViewFactory$signaturesEquals(Signature[] s1, Signature[] s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        ArraySet<Signature> set1 = new ArraySet<Signature>();
        for (Signature signature : s1) {
            set1.add(signature);
        }
        ArraySet<Signature> set2 = new ArraySet<Signature>();
        for (Signature signature : s2) {
            set2.add(signature);
        }
        return set1.equals(set2);
    }

    private static final void $$robo$$android_webkit_WebViewFactory$verifyPackageInfo(PackageInfo chosen, PackageInfo toUse) throws MissingWebViewPackageException {
        if (!chosen.packageName.equals(toUse.packageName)) {
            throw new MissingWebViewPackageException("Failed to verify WebView provider, packageName mismatch, expected: " + chosen.packageName + " actual: " + toUse.packageName);
        }
        if (chosen.versionCode > toUse.versionCode) {
            throw new MissingWebViewPackageException("Failed to verify WebView provider, version code is lower than expected: " + chosen.versionCode + " actual: " + toUse.versionCode);
        }
        if (WebViewFactory.getWebViewLibrary(toUse.applicationInfo) == null) {
            throw new MissingWebViewPackageException("Tried to load an invalid WebView provider: " + toUse.packageName);
        }
        if (!WebViewFactory.signaturesEquals(chosen.signatures, toUse.signatures)) {
            throw new MissingWebViewPackageException("Failed to verify WebView provider, signature mismatch");
        }
    }

    private static final void $$robo$$android_webkit_WebViewFactory$fixupStubApplicationInfo(ApplicationInfo ai, PackageManager pm) throws MissingWebViewPackageException {
        String donorPackageName = null;
        if (ai.metaData != null) {
            donorPackageName = ai.metaData.getString("com.android.webview.WebViewDonorPackage");
        }
        if (donorPackageName != null) {
            PackageInfo donorPackage;
            try {
                donorPackage = pm.getPackageInfo(donorPackageName, 270541824);
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new MissingWebViewPackageException("Failed to find donor package: " + donorPackageName);
            }
            ApplicationInfo donorInfo = donorPackage.applicationInfo;
            ai.sourceDir = donorInfo.sourceDir;
            ai.splitSourceDirs = donorInfo.splitSourceDirs;
            ai.nativeLibraryDir = donorInfo.nativeLibraryDir;
            ai.secondaryNativeLibraryDir = donorInfo.secondaryNativeLibraryDir;
            ai.primaryCpuAbi = donorInfo.primaryCpuAbi;
            ai.secondaryCpuAbi = donorInfo.secondaryCpuAbi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Context $$robo$$android_webkit_WebViewFactory$getWebViewContextAndSetProvider() throws MissingWebViewPackageException {
        Context context;
        Application initialApplication = AppGlobals.getInitialApplication();
        WebViewProviderResponse response = null;
        Trace.traceBegin(16L, "WebViewUpdateService.waitForAndGetProvider()");
        try {
            response = WebViewFactory.getUpdateService().waitForAndGetProvider();
        }
        finally {
            Trace.traceEnd(16L);
        }
        if (response.status != 0 && response.status != 3) {
            throw new MissingWebViewPackageException("Failed to load WebView provider: " + WebViewFactory.getWebViewPreparationErrorReason(response.status));
        }
        Trace.traceBegin(16L, "ActivityManager.addPackageDependency()");
        try {
            ActivityManager.getService().addPackageDependency(response.packageInfo.packageName);
        }
        finally {
            Trace.traceEnd(16L);
        }
        PackageInfo newPackageInfo = null;
        PackageManager pm = initialApplication.getPackageManager();
        Trace.traceBegin(16L, "PackageManager.getPackageInfo()");
        try {
            newPackageInfo = pm.getPackageInfo(response.packageInfo.packageName, 268444864);
        }
        finally {
            Trace.traceEnd(16L);
        }
        WebViewFactory.verifyPackageInfo(response.packageInfo, newPackageInfo);
        ApplicationInfo ai = newPackageInfo.applicationInfo;
        WebViewFactory.fixupStubApplicationInfo(ai, pm);
        Trace.traceBegin(16L, "initialApplication.createApplicationContext");
        try {
            Context webViewContext = initialApplication.createApplicationContext(ai, 3);
            sPackageInfo = newPackageInfo;
            context = webViewContext;
        }
        catch (Throwable throwable) {
            try {
                Trace.traceEnd(16L);
                throw throwable;
            }
            catch (PackageManager.NameNotFoundException | RemoteException e) {
                throw new MissingWebViewPackageException("Failed to load WebView provider: " + e);
            }
        }
        Trace.traceEnd(16L);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static final Class<WebViewFactoryProvider> $$robo$$android_webkit_WebViewFactory$getProviderClass() {
        Context webViewContext = null;
        Application initialApplication = AppGlobals.getInitialApplication();
        try {
            Trace.traceBegin(16L, "WebViewFactory.getWebViewContextAndSetProvider()");
            try {
                webViewContext = WebViewFactory.getWebViewContextAndSetProvider();
            }
            finally {
                Trace.traceEnd(16L);
            }
            Log.i("WebViewFactory", "Loading " + WebViewFactory.sPackageInfo.packageName + " version " + WebViewFactory.sPackageInfo.versionName + " (code " + WebViewFactory.sPackageInfo.versionCode + ")");
            Trace.traceBegin(16L, "WebViewFactory.getChromiumProviderClass()");
            try {
                Class<WebViewFactoryProvider> clazz;
                initialApplication.getAssets().addAssetPathAsSharedLibrary(webViewContext.getApplicationInfo().sourceDir);
                ClassLoader clazzLoader = webViewContext.getClassLoader();
                Trace.traceBegin(16L, "WebViewFactory.loadNativeLibrary()");
                WebViewLibraryLoader.loadNativeLibrary(clazzLoader, sPackageInfo);
                Trace.traceEnd(16L);
                Trace.traceBegin(16L, "Class.forName()");
                try {
                    clazz = WebViewFactory.getWebViewProviderClass(clazzLoader);
                }
                catch (Throwable throwable) {
                    try {
                        Trace.traceEnd(16L);
                        throw throwable;
                    }
                    catch (ClassNotFoundException e) {
                        Log.e("WebViewFactory", "error loading provider", e);
                        throw new AndroidRuntimeException(e);
                    }
                }
                Trace.traceEnd(16L);
                return clazz;
            }
            finally {
                Trace.traceEnd(16L);
            }
        }
        catch (MissingWebViewPackageException e) {
            try {
                return Class.forName("com.android.webview.nullwebview.NullWebViewFactoryProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                Log.e("WebViewFactory", "Chromium WebView package does not exist", e);
                throw new AndroidRuntimeException(e);
            }
        }
    }

    private static final void $$robo$$android_webkit_WebViewFactory$prepareWebViewInZygote() {
        try {
            WebViewLibraryLoader.reserveAddressSpaceInZygote();
        }
        catch (Throwable t) {
            Log.e("WebViewFactory", "error preparing native loader", t);
        }
    }

    private static final int $$robo$$android_webkit_WebViewFactory$prepareWebViewInSystemServer(String[] nativeLibraryPaths) {
        int numRelros = 0;
        if (Build.SUPPORTED_32_BIT_ABIS.length > 0) {
            WebViewLibraryLoader.createRelroFile(false, nativeLibraryPaths);
            ++numRelros;
        }
        if (Build.SUPPORTED_64_BIT_ABIS.length > 0) {
            WebViewLibraryLoader.createRelroFile(true, nativeLibraryPaths);
            ++numRelros;
        }
        return numRelros;
    }

    private static final int $$robo$$android_webkit_WebViewFactory$onWebViewProviderChanged(PackageInfo packageInfo) {
        String[] nativeLibs = null;
        String originalSourceDir = packageInfo.applicationInfo.sourceDir;
        try {
            WebViewFactory.fixupStubApplicationInfo(packageInfo.applicationInfo, AppGlobals.getInitialApplication().getPackageManager());
            nativeLibs = WebViewLibraryLoader.updateWebViewZygoteVmSize(packageInfo);
        }
        catch (Throwable t) {
            Log.e("WebViewFactory", "error preparing webview native library", t);
        }
        WebViewZygote.onWebViewProviderChanged(packageInfo, originalSourceDir);
        return WebViewFactory.prepareWebViewInSystemServer(nativeLibs);
    }

    private static final IWebViewUpdateService $$robo$$android_webkit_WebViewFactory$getUpdateService() {
        return IWebViewUpdateService.Stub.asInterface(ServiceManager.getService(WEBVIEW_UPDATE_SERVICE_NAME));
    }

    static void __staticInitializer__() {
        sProviderLock = new Object();
        WEBVIEW_UPDATE_SERVICE_NAME = "webviewupdate";
    }

    private void __constructor__() {
        this.$$robo$$android_webkit_WebViewFactory$__constructor__();
    }

    public WebViewFactory() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebViewFactory$__constructor__(), 0, this);
    }

    private static String getWebViewPreparationErrorReason(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getWebViewPreparationErrorReason", $$robo$$android_webkit_WebViewFactory$getWebViewPreparationErrorReason(int ), 0, (int)n);
    }

    public static String getWebViewLibrary(ApplicationInfo applicationInfo) {
        return InvokeDynamicSupport.bootstrapStatic("getWebViewLibrary", $$robo$$android_webkit_WebViewFactory$getWebViewLibrary(android.content.pm.ApplicationInfo ), 0, (ApplicationInfo)applicationInfo);
    }

    public static PackageInfo getLoadedPackageInfo() {
        return InvokeDynamicSupport.bootstrapStatic("getLoadedPackageInfo", $$robo$$android_webkit_WebViewFactory$getLoadedPackageInfo(), 0);
    }

    public static Class<WebViewFactoryProvider> getWebViewProviderClass(ClassLoader classLoader) throws ClassNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("getWebViewProviderClass", $$robo$$android_webkit_WebViewFactory$getWebViewProviderClass(java.lang.ClassLoader ), 0, (ClassLoader)classLoader);
    }

    public static int loadWebViewNativeLibraryFromPackage(String string2, ClassLoader classLoader) {
        return (int)InvokeDynamicSupport.bootstrapStatic("loadWebViewNativeLibraryFromPackage", $$robo$$android_webkit_WebViewFactory$loadWebViewNativeLibraryFromPackage(java.lang.String java.lang.ClassLoader ), 0, (String)string2, (ClassLoader)classLoader);
    }

    static WebViewFactoryProvider getProvider() {
        return InvokeDynamicSupport.bootstrapStatic("getProvider", $$robo$$android_webkit_WebViewFactory$getProvider(), 0);
    }

    private static boolean signaturesEquals(Signature[] signatureArray, Signature[] signatureArray2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("signaturesEquals", $$robo$$android_webkit_WebViewFactory$signaturesEquals(android.content.pm.Signature[] android.content.pm.Signature[] ), 0, (Signature[])signatureArray, (Signature[])signatureArray2);
    }

    private static void verifyPackageInfo(PackageInfo packageInfo, PackageInfo packageInfo2) throws MissingWebViewPackageException {
        InvokeDynamicSupport.bootstrapStatic("verifyPackageInfo", $$robo$$android_webkit_WebViewFactory$verifyPackageInfo(android.content.pm.PackageInfo android.content.pm.PackageInfo ), 0, (PackageInfo)packageInfo, (PackageInfo)packageInfo2);
    }

    private static void fixupStubApplicationInfo(ApplicationInfo applicationInfo, PackageManager packageManager) throws MissingWebViewPackageException {
        InvokeDynamicSupport.bootstrapStatic("fixupStubApplicationInfo", $$robo$$android_webkit_WebViewFactory$fixupStubApplicationInfo(android.content.pm.ApplicationInfo android.content.pm.PackageManager ), 0, (ApplicationInfo)applicationInfo, (PackageManager)packageManager);
    }

    private static Context getWebViewContextAndSetProvider() throws MissingWebViewPackageException {
        return InvokeDynamicSupport.bootstrapStatic("getWebViewContextAndSetProvider", $$robo$$android_webkit_WebViewFactory$getWebViewContextAndSetProvider(), 0);
    }

    private static Class<WebViewFactoryProvider> getProviderClass() {
        return InvokeDynamicSupport.bootstrapStatic("getProviderClass", $$robo$$android_webkit_WebViewFactory$getProviderClass(), 0);
    }

    public static void prepareWebViewInZygote() {
        InvokeDynamicSupport.bootstrapStatic("prepareWebViewInZygote", $$robo$$android_webkit_WebViewFactory$prepareWebViewInZygote(), 0);
    }

    private static int prepareWebViewInSystemServer(String[] stringArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("prepareWebViewInSystemServer", $$robo$$android_webkit_WebViewFactory$prepareWebViewInSystemServer(java.lang.String[] ), 0, (String[])stringArray);
    }

    public static int onWebViewProviderChanged(PackageInfo packageInfo) {
        return (int)InvokeDynamicSupport.bootstrapStatic("onWebViewProviderChanged", $$robo$$android_webkit_WebViewFactory$onWebViewProviderChanged(android.content.pm.PackageInfo ), 0, (PackageInfo)packageInfo);
    }

    public static IWebViewUpdateService getUpdateService() {
        return InvokeDynamicSupport.bootstrapStatic("getUpdateService", $$robo$$android_webkit_WebViewFactory$getUpdateService(), 0);
    }

    static {
        RobolectricInternals.classInitializing(WebViewFactory.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WebViewFactory)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class MissingWebViewPackageException
    extends Exception
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_webkit_WebViewFactory_MissingWebViewPackageException$__constructor__(String message) {
        }

        private void $$robo$$android_webkit_WebViewFactory_MissingWebViewPackageException$__constructor__(Exception e) {
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_webkit_WebViewFactory_MissingWebViewPackageException$__constructor__(string2);
        }

        public MissingWebViewPackageException(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebViewFactory_MissingWebViewPackageException$__constructor__(java.lang.String ), 0, this, string2);
        }

        private void __constructor__(Exception exception) {
            this.$$robo$$android_webkit_WebViewFactory_MissingWebViewPackageException$__constructor__(exception);
        }

        public MissingWebViewPackageException(Exception exception) {
            super(exception);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebViewFactory_MissingWebViewPackageException$__constructor__(java.lang.Exception ), 0, this, exception);
        }

        public /* synthetic */ MissingWebViewPackageException() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MissingWebViewPackageException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

