/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.ActivityManagerInternal;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebViewFactory;
import com.android.server.LocalServices;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WebViewLibraryLoader
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOGTAG;
    private static String CHROMIUM_WEBVIEW_NATIVE_RELRO_32 = "/data/misc/shared_relro/libwebviewchromium32.relro";
    private static String CHROMIUM_WEBVIEW_NATIVE_RELRO_64 = "/data/misc/shared_relro/libwebviewchromium64.relro";
    private static long CHROMIUM_WEBVIEW_DEFAULT_VMSIZE_BYTES = 0x6400000L;
    private static boolean DEBUG = false;
    private static boolean sAddressSpaceReserved;

    private void $$robo$$android_webkit_WebViewLibraryLoader$__constructor__() {
    }

    private static final void $$robo$$android_webkit_WebViewLibraryLoader$createRelroFile(boolean is64Bit, String[] nativeLibraryPaths) {
        String abi = is64Bit ? Build.SUPPORTED_64_BIT_ABIS[0] : Build.SUPPORTED_32_BIT_ABIS[0];
        Runnable crashHandler = new Runnable(abi){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ String val$abi;

            private void $$robo$$android_webkit_WebViewLibraryLoader_1$__constructor__(String string2) {
            }

            private final void $$robo$$android_webkit_WebViewLibraryLoader_1$run() {
                try {
                    Log.e(LOGTAG, "relro file creator for " + this.val$abi + " crashed. Proceeding without");
                    WebViewFactory.getUpdateService().notifyRelroCreationCompleted();
                }
                catch (RemoteException e) {
                    Log.e(LOGTAG, "Cannot reach WebViewUpdateService. " + e.getMessage());
                }
            }

            private void __constructor__(String string2) {
                this.$$robo$$android_webkit_WebViewLibraryLoader_1$__constructor__(string2);
            }
            {
                this.val$abi = string2;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebViewLibraryLoader_1$__constructor__(java.lang.String ), 0, this, string2);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_webkit_WebViewLibraryLoader_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        try {
            if (nativeLibraryPaths == null || nativeLibraryPaths[0] == null || nativeLibraryPaths[1] == null) {
                throw new IllegalArgumentException("Native library paths to the WebView RelRo process must not be null!");
            }
            int pid = LocalServices.getService(ActivityManagerInternal.class).startIsolatedProcess(RelroFileCreator.class.getName(), nativeLibraryPaths, "WebViewLoader-" + abi, abi, 1037, crashHandler);
            if (pid <= 0) {
                throw new Exception("Failed to start the relro file creator process");
            }
        }
        catch (Throwable t) {
            Log.e(LOGTAG, "error starting relro file creator for abi " + abi, t);
            crashHandler.run();
        }
    }

    private static final String[] $$robo$$android_webkit_WebViewLibraryLoader$updateWebViewZygoteVmSize(PackageInfo packageInfo) throws WebViewFactory.MissingWebViewPackageException {
        String[] nativeLibs = WebViewLibraryLoader.getWebViewNativeLibraryPaths(packageInfo);
        if (nativeLibs != null) {
            long newVmSize = 0L;
            for (String path : nativeLibs) {
                String[] split;
                if (path == null || TextUtils.isEmpty(path)) continue;
                File f = new File(path);
                if (f.exists()) {
                    newVmSize = Math.max(newVmSize, f.length());
                    continue;
                }
                if (path.contains("!/") && (split = TextUtils.split(path, "!/")).length == 2) {
                    try (ZipFile z = new ZipFile(split[0]);){
                        ZipEntry e = z.getEntry(split[1]);
                        if (e != null && e.getMethod() == 0) {
                            newVmSize = Math.max(newVmSize, e.getSize());
                            continue;
                        }
                    }
                    catch (IOException e) {
                        Log.e(LOGTAG, "error reading APK file " + split[0] + ", ", e);
                    }
                }
                Log.e(LOGTAG, "error sizing load for " + path);
            }
            newVmSize = Math.max(2L * newVmSize, 0x6400000L);
            Log.d(LOGTAG, "Setting new address space to " + newVmSize);
            WebViewLibraryLoader.setWebViewZygoteVmSize(newVmSize);
        }
        return nativeLibs;
    }

    private static final void $$robo$$android_webkit_WebViewLibraryLoader$reserveAddressSpaceInZygote() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"webviewchromium_loader");
        long addressSpaceToReserve = SystemProperties.getLong("persist.sys.webview.vmsize", 0x6400000L);
        sAddressSpaceReserved = WebViewLibraryLoader.nativeReserveAddressSpace(addressSpaceToReserve);
        if (!sAddressSpaceReserved) {
            Log.e(LOGTAG, "reserving " + addressSpaceToReserve + " bytes of address space failed");
        }
    }

    private static final int $$robo$$android_webkit_WebViewLibraryLoader$loadNativeLibrary(ClassLoader clazzLoader, PackageInfo packageInfo) throws WebViewFactory.MissingWebViewPackageException {
        if (!sAddressSpaceReserved) {
            Log.e(LOGTAG, "can't load with relro file; address space not reserved");
            return 2;
        }
        String libraryFileName = WebViewFactory.getWebViewLibrary(packageInfo.applicationInfo);
        int result = WebViewLibraryLoader.nativeLoadWithRelroFile(libraryFileName, "/data/misc/shared_relro/libwebviewchromium32.relro", "/data/misc/shared_relro/libwebviewchromium64.relro", clazzLoader);
        if (result != 0) {
            Log.w(LOGTAG, "failed to load with relro file, proceeding without");
        }
        return result;
    }

    private static final String[] $$robo$$android_webkit_WebViewLibraryLoader$getWebViewNativeLibraryPaths(PackageInfo packageInfo) throws WebViewFactory.MissingWebViewPackageException {
        File f;
        String path32;
        String path64;
        ApplicationInfo ai = packageInfo.applicationInfo;
        String nativeLibFileName = WebViewFactory.getWebViewLibrary(ai);
        boolean primaryArchIs64bit = VMRuntime.is64BitAbi(ai.primaryCpuAbi);
        if (!TextUtils.isEmpty(ai.secondaryCpuAbi)) {
            if (primaryArchIs64bit) {
                path64 = ai.nativeLibraryDir;
                path32 = ai.secondaryNativeLibraryDir;
            } else {
                path64 = ai.secondaryNativeLibraryDir;
                path32 = ai.nativeLibraryDir;
            }
        } else if (primaryArchIs64bit) {
            path64 = ai.nativeLibraryDir;
            path32 = "";
        } else {
            path32 = ai.nativeLibraryDir;
            path64 = "";
        }
        if (!TextUtils.isEmpty(path32) && !(f = new File(path32 = path32 + "/" + nativeLibFileName)).exists()) {
            path32 = WebViewLibraryLoader.getLoadFromApkPath(ai.sourceDir, Build.SUPPORTED_32_BIT_ABIS, nativeLibFileName);
        }
        if (!TextUtils.isEmpty(path64) && !(f = new File(path64 = path64 + "/" + nativeLibFileName)).exists()) {
            path64 = WebViewLibraryLoader.getLoadFromApkPath(ai.sourceDir, Build.SUPPORTED_64_BIT_ABIS, nativeLibFileName);
        }
        return new String[]{path32, path64};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final String $$robo$$android_webkit_WebViewLibraryLoader$getLoadFromApkPath(String apkPath, String[] abiList, String nativeLibFileName) throws WebViewFactory.MissingWebViewPackageException {
        try (ZipFile z = new ZipFile(apkPath);){
            String[] stringArray = abiList;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String abi = stringArray[n2];
                String entry = "lib/" + abi + "/" + nativeLibFileName;
                ZipEntry e = z.getEntry(entry);
                if (e != null && e.getMethod() == 0) {
                    String string2 = apkPath + "!/" + entry;
                    return string2;
                }
                ++n2;
            }
            return "";
        }
        catch (IOException e) {
            throw new WebViewFactory.MissingWebViewPackageException(e);
        }
    }

    private static final void $$robo$$android_webkit_WebViewLibraryLoader$setWebViewZygoteVmSize(long vmSize) {
        SystemProperties.set("persist.sys.webview.vmsize", Long.toString(vmSize));
    }

    private static final boolean $$robo$$android_webkit_WebViewLibraryLoader$nativeReserveAddressSpace(long l) {
        return false;
    }

    private static final boolean $$robo$$android_webkit_WebViewLibraryLoader$nativeCreateRelroFile(String string2, String string3, String string4, String string5) {
        return false;
    }

    private static final int $$robo$$android_webkit_WebViewLibraryLoader$nativeLoadWithRelroFile(String string2, String string3, String string4, ClassLoader classLoader) {
        return 0;
    }

    static void __staticInitializer__() {
        LOGTAG = WebViewLibraryLoader.class.getSimpleName();
        sAddressSpaceReserved = false;
    }

    private void __constructor__() {
        this.$$robo$$android_webkit_WebViewLibraryLoader$__constructor__();
    }

    WebViewLibraryLoader() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebViewLibraryLoader$__constructor__(), 0, this);
    }

    static void createRelroFile(boolean bl, String[] stringArray) {
        InvokeDynamicSupport.bootstrapStatic("createRelroFile", $$robo$$android_webkit_WebViewLibraryLoader$createRelroFile(boolean java.lang.String[] ), 0, (boolean)bl, (String[])stringArray);
    }

    static String[] updateWebViewZygoteVmSize(PackageInfo packageInfo) throws WebViewFactory.MissingWebViewPackageException {
        return InvokeDynamicSupport.bootstrapStatic("updateWebViewZygoteVmSize", $$robo$$android_webkit_WebViewLibraryLoader$updateWebViewZygoteVmSize(android.content.pm.PackageInfo ), 0, (PackageInfo)packageInfo);
    }

    static void reserveAddressSpaceInZygote() {
        InvokeDynamicSupport.bootstrapStatic("reserveAddressSpaceInZygote", $$robo$$android_webkit_WebViewLibraryLoader$reserveAddressSpaceInZygote(), 0);
    }

    static int loadNativeLibrary(ClassLoader classLoader, PackageInfo packageInfo) throws WebViewFactory.MissingWebViewPackageException {
        return (int)InvokeDynamicSupport.bootstrapStatic("loadNativeLibrary", $$robo$$android_webkit_WebViewLibraryLoader$loadNativeLibrary(java.lang.ClassLoader android.content.pm.PackageInfo ), 0, (ClassLoader)classLoader, (PackageInfo)packageInfo);
    }

    static String[] getWebViewNativeLibraryPaths(PackageInfo packageInfo) throws WebViewFactory.MissingWebViewPackageException {
        return InvokeDynamicSupport.bootstrapStatic("getWebViewNativeLibraryPaths", $$robo$$android_webkit_WebViewLibraryLoader$getWebViewNativeLibraryPaths(android.content.pm.PackageInfo ), 0, (PackageInfo)packageInfo);
    }

    private static String getLoadFromApkPath(String string2, String[] stringArray, String string3) throws WebViewFactory.MissingWebViewPackageException {
        return InvokeDynamicSupport.bootstrapStatic("getLoadFromApkPath", $$robo$$android_webkit_WebViewLibraryLoader$getLoadFromApkPath(java.lang.String java.lang.String[] java.lang.String ), 0, (String)string2, (String[])stringArray, (String)string3);
    }

    private static void setWebViewZygoteVmSize(long l) {
        InvokeDynamicSupport.bootstrapStatic("setWebViewZygoteVmSize", $$robo$$android_webkit_WebViewLibraryLoader$setWebViewZygoteVmSize(long ), 0, (long)l);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeReserveAddressSpace$nativeBinding(long var0);

    static boolean nativeReserveAddressSpace(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeReserveAddressSpace", $$robo$$android_webkit_WebViewLibraryLoader$nativeReserveAddressSpace(long ), 1, (long)l);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeCreateRelroFile$nativeBinding(String var0, String var1, String var2, String var3);

    static boolean nativeCreateRelroFile(String string2, String string3, String string4, String string5) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeCreateRelroFile", $$robo$$android_webkit_WebViewLibraryLoader$nativeCreateRelroFile(java.lang.String java.lang.String java.lang.String java.lang.String ), 1, (String)string2, (String)string3, (String)string4, (String)string5);
    }

    private static final native /* synthetic */ int $$robo$$nativeLoadWithRelroFile$nativeBinding(String var0, String var1, String var2, ClassLoader var3);

    static int nativeLoadWithRelroFile(String string2, String string3, String string4, ClassLoader classLoader) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeLoadWithRelroFile", $$robo$$android_webkit_WebViewLibraryLoader$nativeLoadWithRelroFile(java.lang.String java.lang.String java.lang.String java.lang.ClassLoader ), 1, (String)string2, (String)string3, (String)string4, (ClassLoader)classLoader);
    }

    static {
        RobolectricInternals.classInitializing(WebViewLibraryLoader.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WebViewLibraryLoader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class RelroFileCreator
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_webkit_WebViewLibraryLoader_RelroFileCreator$__constructor__() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void $$robo$$android_webkit_WebViewLibraryLoader_RelroFileCreator$main(String[] args) {
            boolean result = false;
            boolean is64Bit = VMRuntime.getRuntime().is64Bit();
            try {
                if (args.length != 2 || args[0] == null || args[1] == null) {
                    Log.e(LOGTAG, "Invalid RelroFileCreator args: " + Arrays.toString(args));
                    return;
                }
                Log.v(LOGTAG, "RelroFileCreator (64bit = " + is64Bit + "), " + " 32-bit lib: " + args[0] + ", 64-bit lib: " + args[1]);
                if (!sAddressSpaceReserved) {
                    Log.e(LOGTAG, "can't create relro file; address space not reserved");
                    return;
                }
                result = WebViewLibraryLoader.nativeCreateRelroFile(args[0], args[1], "/data/misc/shared_relro/libwebviewchromium32.relro", "/data/misc/shared_relro/libwebviewchromium64.relro");
                if (result) {
                    // empty if block
                }
            }
            finally {
                try {
                    WebViewFactory.getUpdateService().notifyRelroCreationCompleted();
                }
                catch (RemoteException e) {
                    Log.e(LOGTAG, "error notifying update service", e);
                }
                if (!result) {
                    Log.e(LOGTAG, "failed to create relro file");
                }
                System.exit(0);
            }
        }

        private void __constructor__() {
            this.$$robo$$android_webkit_WebViewLibraryLoader_RelroFileCreator$__constructor__();
        }

        private RelroFileCreator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebViewLibraryLoader_RelroFileCreator$__constructor__(), 0, this);
        }

        public static void main(String[] stringArray) {
            InvokeDynamicSupport.bootstrapStatic("main", $$robo$$android_webkit_WebViewLibraryLoader_RelroFileCreator$main(java.lang.String[] ), 0, (String[])stringArray);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RelroFileCreator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

