/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.LoadedApk;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.os.SystemService;
import android.os.ZygoteProcess;
import android.text.TextUtils;
import android.util.AndroidRuntimeException;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeoutException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WebViewZygote
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOGTAG = "WebViewZygote";
    private static String WEBVIEW_ZYGOTE_SERVICE_32 = "webview_zygote32";
    private static String WEBVIEW_ZYGOTE_SERVICE_64 = "webview_zygote64";
    private static String WEBVIEW_ZYGOTE_SOCKET = "webview_zygote";
    private static Object sLock;
    @GuardedBy(value="sLock")
    private static ZygoteProcess sZygote;
    @GuardedBy(value="sLock")
    private static boolean sStartedService;
    @GuardedBy(value="sLock")
    private static PackageInfo sPackage;
    @GuardedBy(value="sLock")
    private static String sPackageCacheKey;
    @GuardedBy(value="sLock")
    private static boolean sMultiprocessEnabled;

    private void $$robo$$android_webkit_WebViewZygote$__constructor__() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ZygoteProcess $$robo$$android_webkit_WebViewZygote$getProcess() {
        Object object = sLock;
        synchronized (object) {
            if (sZygote != null) {
                return sZygote;
            }
            WebViewZygote.waitForServiceStartAndConnect();
            return sZygote;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String $$robo$$android_webkit_WebViewZygote$getPackageName() {
        Object object = sLock;
        synchronized (object) {
            return WebViewZygote.sPackage.packageName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean $$robo$$android_webkit_WebViewZygote$isMultiprocessEnabled() {
        Object object = sLock;
        synchronized (object) {
            return sMultiprocessEnabled && sPackage != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_webkit_WebViewZygote$setMultiprocessEnabled(boolean enabled) {
        Object object = sLock;
        synchronized (object) {
            sMultiprocessEnabled = enabled;
            String serviceName = WebViewZygote.getServiceNameLocked();
            if (serviceName == null) {
                return;
            }
            if (enabled) {
                if (!sStartedService) {
                    SystemService.start(serviceName);
                    sStartedService = true;
                }
            } else {
                SystemService.stop(serviceName);
                sStartedService = false;
                sZygote = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_webkit_WebViewZygote$onWebViewProviderChanged(PackageInfo packageInfo, String cacheKey) {
        Object object = sLock;
        synchronized (object) {
            sPackage = packageInfo;
            sPackageCacheKey = cacheKey;
            if (!sMultiprocessEnabled) {
                return;
            }
            String serviceName = WebViewZygote.getServiceNameLocked();
            sZygote = null;
            if (SystemService.isStopped(serviceName)) {
                SystemService.start(serviceName);
            } else {
                SystemService.restart(serviceName);
            }
            sStartedService = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_webkit_WebViewZygote$waitForServiceStartAndConnect() {
        String serviceName;
        if (!sStartedService) {
            throw new AndroidRuntimeException("Tried waiting for the WebView Zygote Service to start running without first starting the service.");
        }
        Object object = sLock;
        synchronized (object) {
            serviceName = WebViewZygote.getServiceNameLocked();
        }
        try {
            SystemService.waitForState(serviceName, SystemService.State.RUNNING, 5000L);
        }
        catch (TimeoutException e) {
            Log.e("WebViewZygote", "Timed out waiting for " + serviceName);
            return;
        }
        object = sLock;
        synchronized (object) {
            WebViewZygote.connectToZygoteIfNeededLocked();
        }
    }

    @GuardedBy(value="sLock")
    private static final String $$robo$$android_webkit_WebViewZygote$getServiceNameLocked() {
        if (sPackage == null) {
            return null;
        }
        if (Arrays.asList(Build.SUPPORTED_64_BIT_ABIS).contains(WebViewZygote.sPackage.applicationInfo.primaryCpuAbi)) {
            return "webview_zygote64";
        }
        return "webview_zygote32";
    }

    @GuardedBy(value="sLock")
    private static final void $$robo$$android_webkit_WebViewZygote$connectToZygoteIfNeededLocked() {
        if (sZygote != null) {
            return;
        }
        if (sPackage == null) {
            Log.e("WebViewZygote", "Cannot connect to zygote, no package specified");
            return;
        }
        String serviceName = WebViewZygote.getServiceNameLocked();
        if (!SystemService.isRunning(serviceName)) {
            Log.e("WebViewZygote", serviceName + " is not running");
            return;
        }
        try {
            sZygote = new ZygoteProcess("webview_zygote", null);
            ArrayList<String> zipPaths = new ArrayList<String>(10);
            ArrayList<String> libPaths = new ArrayList<String>(10);
            LoadedApk.makePaths(null, false, WebViewZygote.sPackage.applicationInfo, zipPaths, libPaths);
            String librarySearchPath = TextUtils.join((CharSequence)File.pathSeparator, libPaths);
            String zip = zipPaths.size() == 1 ? (String)zipPaths.get(0) : TextUtils.join((CharSequence)File.pathSeparator, zipPaths);
            ZygoteProcess.waitForConnectionToZygote("webview_zygote");
            Log.d("WebViewZygote", "Preloading package " + zip + " " + librarySearchPath);
            sZygote.preloadPackageForAbi(zip, librarySearchPath, sPackageCacheKey, Build.SUPPORTED_ABIS[0]);
        }
        catch (Exception e) {
            Log.e("WebViewZygote", "Error connecting to " + serviceName, e);
            sZygote = null;
        }
    }

    static void __staticInitializer__() {
        sLock = new Object();
        sStartedService = false;
        sMultiprocessEnabled = false;
    }

    private void __constructor__() {
        this.$$robo$$android_webkit_WebViewZygote$__constructor__();
    }

    public WebViewZygote() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebViewZygote$__constructor__(), 0, this);
    }

    public static ZygoteProcess getProcess() {
        return InvokeDynamicSupport.bootstrapStatic("getProcess", $$robo$$android_webkit_WebViewZygote$getProcess(), 0);
    }

    public static String getPackageName() {
        return InvokeDynamicSupport.bootstrapStatic("getPackageName", $$robo$$android_webkit_WebViewZygote$getPackageName(), 0);
    }

    public static boolean isMultiprocessEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isMultiprocessEnabled", $$robo$$android_webkit_WebViewZygote$isMultiprocessEnabled(), 0);
    }

    public static void setMultiprocessEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("setMultiprocessEnabled", $$robo$$android_webkit_WebViewZygote$setMultiprocessEnabled(boolean ), 0, (boolean)bl);
    }

    public static void onWebViewProviderChanged(PackageInfo packageInfo, String string2) {
        InvokeDynamicSupport.bootstrapStatic("onWebViewProviderChanged", $$robo$$android_webkit_WebViewZygote$onWebViewProviderChanged(android.content.pm.PackageInfo java.lang.String ), 0, (PackageInfo)packageInfo, (String)string2);
    }

    private static void waitForServiceStartAndConnect() {
        InvokeDynamicSupport.bootstrapStatic("waitForServiceStartAndConnect", $$robo$$android_webkit_WebViewZygote$waitForServiceStartAndConnect(), 0);
    }

    private static String getServiceNameLocked() {
        return InvokeDynamicSupport.bootstrapStatic("getServiceNameLocked", $$robo$$android_webkit_WebViewZygote$getServiceNameLocked(), 0);
    }

    private static void connectToZygoteIfNeededLocked() {
        InvokeDynamicSupport.bootstrapStatic("connectToZygoteIfNeededLocked", $$robo$$android_webkit_WebViewZygote$connectToZygoteIfNeededLocked(), 0);
    }

    static {
        RobolectricInternals.classInitializing(WebViewZygote.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WebViewZygote)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

