/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.ContextThemeWrapper;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.android.internal.R;
import java.lang.ref.WeakReference;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AutoCompleteTextView
extends EditText
implements Filter.FilterListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static boolean DEBUG = false;
    static String TAG = "AutoCompleteTextView";
    static int EXPAND_MAX = 3;
    private Context mPopupContext;
    private ListPopupWindow mPopup;
    private PassThroughClickListener mPassThroughClickListener;
    private CharSequence mHintText;
    private TextView mHintView;
    private int mHintResource;
    private ListAdapter mAdapter;
    private Filter mFilter;
    private int mThreshold;
    private int mDropDownAnchorId;
    private AdapterView.OnItemClickListener mItemClickListener;
    private AdapterView.OnItemSelectedListener mItemSelectedListener;
    private boolean mDropDownDismissedOnCompletion;
    private int mLastKeyCode;
    private boolean mOpenBefore;
    private Validator mValidator;
    private boolean mBlockCompletion;
    private boolean mPopupCanBeUpdated;
    private PopupDataSetObserver mObserver;

    private void $$robo$$android_widget_AutoCompleteTextView$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_AutoCompleteTextView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_AutoCompleteTextView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_AutoCompleteTextView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
    }

    private void $$robo$$android_widget_AutoCompleteTextView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes, Resources.Theme popupTheme) {
        int popupThemeResId;
        this.mDropDownDismissedOnCompletion = true;
        this.mLastKeyCode = 0;
        this.mValidator = null;
        this.mPopupCanBeUpdated = true;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AutoCompleteTextView, defStyleAttr, defStyleRes);
        this.mPopupContext = popupTheme != null ? new ContextThemeWrapper(context, popupTheme) : ((popupThemeResId = a.getResourceId(8, 0)) != 0 ? new ContextThemeWrapper(context, popupThemeResId) : context);
        TypedArray pa = this.mPopupContext != context ? this.mPopupContext.obtainStyledAttributes(attrs, R.styleable.AutoCompleteTextView, defStyleAttr, defStyleRes) : a;
        Drawable popupListSelector = pa.getDrawable(3);
        int popupWidth = pa.getLayoutDimension(5, -2);
        int popupHeight = pa.getLayoutDimension(7, -2);
        int popupHintLayoutResId = pa.getResourceId(1, 17367270);
        CharSequence popupHintText = pa.getText(0);
        if (pa != a) {
            pa.recycle();
        }
        this.mPopup = new ListPopupWindow(this.mPopupContext, attrs, defStyleAttr, defStyleRes);
        this.mPopup.setSoftInputMode(16);
        this.mPopup.setPromptPosition(1);
        this.mPopup.setListSelector(popupListSelector);
        this.mPopup.setOnItemClickListener(new DropDownItemClickListener(this));
        this.mPopup.setWidth(popupWidth);
        this.mPopup.setHeight(popupHeight);
        this.mHintResource = popupHintLayoutResId;
        this.setCompletionHint(popupHintText);
        this.mDropDownAnchorId = a.getResourceId(6, -1);
        this.mThreshold = a.getInt(2, 2);
        a.recycle();
        int inputType = this.getInputType();
        if ((inputType & 0xF) == 1) {
            this.setRawInputType(inputType |= 0x10000);
        }
        this.setFocusable(true);
        this.addTextChangedListener(new MyWatcher(this));
        this.mPassThroughClickListener = new PassThroughClickListener(this);
        super.setOnClickListener(this.mPassThroughClickListener);
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$setOnClickListener(View.OnClickListener listener) {
        this.mPassThroughClickListener.mWrapped = listener;
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$onClickImpl() {
        if (this.isPopupShowing()) {
            this.ensureImeVisible(true);
        }
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$setCompletionHint(CharSequence hint) {
        this.mHintText = hint;
        if (hint != null) {
            if (this.mHintView == null) {
                TextView hintView = (TextView)LayoutInflater.from(this.mPopupContext).inflate(this.mHintResource, null).findViewById(16908308);
                hintView.setText(this.mHintText);
                this.mHintView = hintView;
                this.mPopup.setPromptView(hintView);
            } else {
                this.mHintView.setText(hint);
            }
        } else {
            this.mPopup.setPromptView(null);
            this.mHintView = null;
        }
    }

    private final CharSequence $$robo$$android_widget_AutoCompleteTextView$getCompletionHint() {
        return this.mHintText;
    }

    private final int $$robo$$android_widget_AutoCompleteTextView$getDropDownWidth() {
        return this.mPopup.getWidth();
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$setDropDownWidth(int width) {
        this.mPopup.setWidth(width);
    }

    private final int $$robo$$android_widget_AutoCompleteTextView$getDropDownHeight() {
        return this.mPopup.getHeight();
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$setDropDownHeight(int height) {
        this.mPopup.setHeight(height);
    }

    private final int $$robo$$android_widget_AutoCompleteTextView$getDropDownAnchor() {
        return this.mDropDownAnchorId;
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$setDropDownAnchor(int id2) {
        this.mDropDownAnchorId = id2;
        this.mPopup.setAnchorView(null);
    }

    private final Drawable $$robo$$android_widget_AutoCompleteTextView$getDropDownBackground() {
        return this.mPopup.getBackground();
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$setDropDownBackgroundDrawable(Drawable d) {
        this.mPopup.setBackgroundDrawable(d);
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$setDropDownBackgroundResource(int id2) {
        this.mPopup.setBackgroundDrawable(this.getContext().getDrawable(id2));
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$setDropDownVerticalOffset(int offset) {
        this.mPopup.setVerticalOffset(offset);
    }

    private final int $$robo$$android_widget_AutoCompleteTextView$getDropDownVerticalOffset() {
        return this.mPopup.getVerticalOffset();
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$setDropDownHorizontalOffset(int offset) {
        this.mPopup.setHorizontalOffset(offset);
    }

    private final int $$robo$$android_widget_AutoCompleteTextView$getDropDownHorizontalOffset() {
        return this.mPopup.getHorizontalOffset();
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$setDropDownAnimationStyle(int animationStyle) {
        this.mPopup.setAnimationStyle(animationStyle);
    }

    private final int $$robo$$android_widget_AutoCompleteTextView$getDropDownAnimationStyle() {
        return this.mPopup.getAnimationStyle();
    }

    private final boolean $$robo$$android_widget_AutoCompleteTextView$isDropDownAlwaysVisible() {
        return this.mPopup.isDropDownAlwaysVisible();
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$setDropDownAlwaysVisible(boolean dropDownAlwaysVisible) {
        this.mPopup.setDropDownAlwaysVisible(dropDownAlwaysVisible);
    }

    private final boolean $$robo$$android_widget_AutoCompleteTextView$isDropDownDismissedOnCompletion() {
        return this.mDropDownDismissedOnCompletion;
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$setDropDownDismissedOnCompletion(boolean dropDownDismissedOnCompletion) {
        this.mDropDownDismissedOnCompletion = dropDownDismissedOnCompletion;
    }

    private final int $$robo$$android_widget_AutoCompleteTextView$getThreshold() {
        return this.mThreshold;
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$setThreshold(int threshold) {
        if (threshold <= 0) {
            threshold = 1;
        }
        this.mThreshold = threshold;
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$setOnItemClickListener(AdapterView.OnItemClickListener l) {
        this.mItemClickListener = l;
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$setOnItemSelectedListener(AdapterView.OnItemSelectedListener l) {
        this.mItemSelectedListener = l;
    }

    @Deprecated
    private final AdapterView.OnItemClickListener $$robo$$android_widget_AutoCompleteTextView$getItemClickListener() {
        return this.mItemClickListener;
    }

    @Deprecated
    private final AdapterView.OnItemSelectedListener $$robo$$android_widget_AutoCompleteTextView$getItemSelectedListener() {
        return this.mItemSelectedListener;
    }

    private final AdapterView.OnItemClickListener $$robo$$android_widget_AutoCompleteTextView$getOnItemClickListener() {
        return this.mItemClickListener;
    }

    private final AdapterView.OnItemSelectedListener $$robo$$android_widget_AutoCompleteTextView$getOnItemSelectedListener() {
        return this.mItemSelectedListener;
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$setOnDismissListener(OnDismissListener dismissListener) {
        PopupWindow.OnDismissListener wrappedListener = null;
        if (dismissListener != null) {
            wrappedListener = new PopupWindow.OnDismissListener(this, dismissListener){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ OnDismissListener val$dismissListener;
                /* synthetic */ AutoCompleteTextView this$0;

                private void $$robo$$android_widget_AutoCompleteTextView_1$__constructor__(AutoCompleteTextView this$0, OnDismissListener onDismissListener) {
                }

                private final void $$robo$$android_widget_AutoCompleteTextView_1$onDismiss() {
                    this.val$dismissListener.onDismiss();
                }

                private void __constructor__(AutoCompleteTextView autoCompleteTextView, OnDismissListener onDismissListener) {
                    this.$$robo$$android_widget_AutoCompleteTextView_1$__constructor__(autoCompleteTextView, onDismissListener);
                }
                {
                    this.this$0 = autoCompleteTextView;
                    this.val$dismissListener = onDismissListener;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AutoCompleteTextView_1$__constructor__(android.widget.AutoCompleteTextView android.widget.AutoCompleteTextView$OnDismissListener ), 0, this, autoCompleteTextView, onDismissListener);
                }

                @Override
                public void onDismiss() {
                    InvokeDynamicSupport.bootstrap("onDismiss", $$robo$$android_widget_AutoCompleteTextView_1$onDismiss(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }
        this.mPopup.setOnDismissListener(wrappedListener);
    }

    private final ListAdapter $$robo$$android_widget_AutoCompleteTextView$getAdapter() {
        return this.mAdapter;
    }

    private final <T extends ListAdapter & Filterable> void $$robo$$android_widget_AutoCompleteTextView$setAdapter(T adapter) {
        if (this.mObserver == null) {
            this.mObserver = new PopupDataSetObserver(this);
        } else if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(this.mObserver);
        }
        this.mAdapter = adapter;
        if (this.mAdapter != null) {
            this.mFilter = ((Filterable)((Object)this.mAdapter)).getFilter();
            adapter.registerDataSetObserver(this.mObserver);
        } else {
            this.mFilter = null;
        }
        this.mPopup.setAdapter(this.mAdapter);
    }

    private final boolean $$robo$$android_widget_AutoCompleteTextView$onKeyPreIme(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.isPopupShowing() && !this.mPopup.isDropDownAlwaysVisible()) {
            if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                KeyEvent.DispatcherState state = this.getKeyDispatcherState();
                if (state != null) {
                    state.startTracking(event, this);
                }
                return true;
            }
            if (event.getAction() == 1) {
                KeyEvent.DispatcherState state = this.getKeyDispatcherState();
                if (state != null) {
                    state.handleUpEvent(event);
                }
                if (event.isTracking() && !event.isCanceled()) {
                    this.dismissDropDown();
                    return true;
                }
            }
        }
        return super.onKeyPreIme(keyCode, event);
    }

    private final boolean $$robo$$android_widget_AutoCompleteTextView$onKeyUp(int keyCode, KeyEvent event) {
        boolean consumed = this.mPopup.onKeyUp(keyCode, event);
        if (consumed) {
            switch (keyCode) {
                case 23: 
                case 61: 
                case 66: {
                    if (event.hasNoModifiers()) {
                        this.performCompletion();
                    }
                    return true;
                }
            }
        }
        if (this.isPopupShowing() && keyCode == 61 && event.hasNoModifiers()) {
            this.performCompletion();
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    private final boolean $$robo$$android_widget_AutoCompleteTextView$onKeyDown(int keyCode, KeyEvent event) {
        if (this.mPopup.onKeyDown(keyCode, event)) {
            return true;
        }
        if (!this.isPopupShowing()) {
            switch (keyCode) {
                case 20: {
                    if (!event.hasNoModifiers()) break;
                    this.performValidation();
                }
            }
        }
        if (this.isPopupShowing() && keyCode == 61 && event.hasNoModifiers()) {
            return true;
        }
        this.mLastKeyCode = keyCode;
        boolean handled = super.onKeyDown(keyCode, event);
        this.mLastKeyCode = 0;
        if (handled && this.isPopupShowing()) {
            this.clearListSelection();
        }
        return handled;
    }

    private final boolean $$robo$$android_widget_AutoCompleteTextView$enoughToFilter() {
        return this.getText().length() >= this.mThreshold;
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$doBeforeTextChanged() {
        if (this.mBlockCompletion) {
            return;
        }
        this.mOpenBefore = this.isPopupShowing();
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$doAfterTextChanged() {
        if (this.mBlockCompletion) {
            return;
        }
        if (this.mOpenBefore && !this.isPopupShowing()) {
            return;
        }
        if (this.enoughToFilter()) {
            if (this.mFilter != null) {
                this.mPopupCanBeUpdated = true;
                this.performFiltering(this.getText(), this.mLastKeyCode);
            }
        } else {
            if (!this.mPopup.isDropDownAlwaysVisible()) {
                this.dismissDropDown();
            }
            if (this.mFilter != null) {
                this.mFilter.filter(null);
            }
        }
    }

    private final boolean $$robo$$android_widget_AutoCompleteTextView$isPopupShowing() {
        return this.mPopup.isShowing();
    }

    private final CharSequence $$robo$$android_widget_AutoCompleteTextView$convertSelectionToString(Object selectedItem) {
        return this.mFilter.convertResultToString(selectedItem);
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$clearListSelection() {
        this.mPopup.clearListSelection();
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$setListSelection(int position) {
        this.mPopup.setSelection(position);
    }

    private final int $$robo$$android_widget_AutoCompleteTextView$getListSelection() {
        return this.mPopup.getSelectedItemPosition();
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$performFiltering(CharSequence text, int keyCode) {
        this.mFilter.filter(text, this);
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$performCompletion() {
        this.performCompletion(null, -1, -1L);
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$onCommitCompletion(CompletionInfo completion) {
        if (this.isPopupShowing()) {
            this.mPopup.performItemClick(completion.getPosition());
        }
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$performCompletion(View selectedView, int position, long id2) {
        if (this.isPopupShowing()) {
            Object selectedItem = position < 0 ? this.mPopup.getSelectedItem() : this.mAdapter.getItem(position);
            if (selectedItem == null) {
                Log.w("AutoCompleteTextView", "performCompletion: no selected item");
                return;
            }
            this.mBlockCompletion = true;
            this.replaceText(this.convertSelectionToString(selectedItem));
            this.mBlockCompletion = false;
            if (this.mItemClickListener != null) {
                ListPopupWindow list = this.mPopup;
                if (selectedView == null || position < 0) {
                    selectedView = list.getSelectedView();
                    position = list.getSelectedItemPosition();
                    id2 = list.getSelectedItemId();
                }
                this.mItemClickListener.onItemClick(list.getListView(), selectedView, position, id2);
            }
        }
        if (this.mDropDownDismissedOnCompletion && !this.mPopup.isDropDownAlwaysVisible()) {
            this.dismissDropDown();
        }
    }

    private final boolean $$robo$$android_widget_AutoCompleteTextView$isPerformingCompletion() {
        return this.mBlockCompletion;
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$setText(CharSequence text, boolean filter) {
        if (filter) {
            this.setText(text);
        } else {
            this.mBlockCompletion = true;
            this.setText(text);
            this.mBlockCompletion = false;
        }
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$replaceText(CharSequence text) {
        this.clearComposingText();
        this.setText(text);
        CharSequence spannable = this.getText();
        Selection.setSelection((Spannable)spannable, spannable.length());
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$onFilterComplete(int count) {
        this.updateDropDownForFilter(count);
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$updateDropDownForFilter(int count) {
        if (this.getWindowVisibility() == 8) {
            return;
        }
        boolean dropDownAlwaysVisible = this.mPopup.isDropDownAlwaysVisible();
        boolean enoughToFilter = this.enoughToFilter();
        if ((count > 0 || dropDownAlwaysVisible) && enoughToFilter) {
            if (this.hasFocus() && this.hasWindowFocus() && this.mPopupCanBeUpdated) {
                this.showDropDown();
            }
        } else if (!dropDownAlwaysVisible && this.isPopupShowing()) {
            this.dismissDropDown();
            this.mPopupCanBeUpdated = true;
        }
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (!hasWindowFocus && !this.mPopup.isDropDownAlwaysVisible()) {
            this.dismissDropDown();
        }
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$onDisplayHint(int hint) {
        super.onDisplayHint(hint);
        switch (hint) {
            case 4: {
                if (this.mPopup.isDropDownAlwaysVisible()) break;
                this.dismissDropDown();
            }
        }
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (this.isTemporarilyDetached()) {
            return;
        }
        if (!focused) {
            this.performValidation();
        }
        if (!focused && !this.mPopup.isDropDownAlwaysVisible()) {
            this.dismissDropDown();
        }
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$onDetachedFromWindow() {
        this.dismissDropDown();
        super.onDetachedFromWindow();
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$dismissDropDown() {
        InputMethodManager imm = InputMethodManager.peekInstance();
        if (imm != null) {
            imm.displayCompletions(this, null);
        }
        this.mPopup.dismiss();
        this.mPopupCanBeUpdated = false;
    }

    private final boolean $$robo$$android_widget_AutoCompleteTextView$setFrame(int l, int t, int r, int b) {
        boolean result = super.setFrame(l, t, r, b);
        if (this.isPopupShowing()) {
            this.showDropDown();
        }
        return result;
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$showDropDownAfterLayout() {
        this.mPopup.postShow();
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$ensureImeVisible(boolean visible) {
        this.mPopup.setInputMethodMode(visible ? 1 : 2);
        if (this.mPopup.isDropDownAlwaysVisible() || this.mFilter != null && this.enoughToFilter()) {
            this.showDropDown();
        }
    }

    private final boolean $$robo$$android_widget_AutoCompleteTextView$isInputMethodNotNeeded() {
        return this.mPopup.getInputMethodMode() == 2;
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$showDropDown() {
        this.buildImeCompletions();
        if (this.mPopup.getAnchorView() == null) {
            if (this.mDropDownAnchorId != -1) {
                this.mPopup.setAnchorView((View)this.getRootView().findViewById(this.mDropDownAnchorId));
            } else {
                this.mPopup.setAnchorView(this);
            }
        }
        if (!this.isPopupShowing()) {
            this.mPopup.setInputMethodMode(1);
            this.mPopup.setListItemExpandMax(3);
        }
        this.mPopup.show();
        this.mPopup.getListView().setOverScrollMode(0);
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$setForceIgnoreOutsideTouch(boolean forceIgnoreOutsideTouch) {
        this.mPopup.setForceIgnoreOutsideTouch(forceIgnoreOutsideTouch);
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$buildImeCompletions() {
        InputMethodManager imm;
        ListAdapter adapter = this.mAdapter;
        if (adapter != null && (imm = InputMethodManager.peekInstance()) != null) {
            int count = Math.min(adapter.getCount(), 20);
            CompletionInfo[] completions = new CompletionInfo[count];
            int realCount = 0;
            for (int i = 0; i < count; ++i) {
                if (!adapter.isEnabled(i)) continue;
                Object item = adapter.getItem(i);
                long id2 = adapter.getItemId(i);
                completions[realCount] = new CompletionInfo(id2, realCount, this.convertSelectionToString(item));
                ++realCount;
            }
            if (realCount != count) {
                CompletionInfo[] tmp = new CompletionInfo[realCount];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)completions, (int)0, (Object)tmp, (int)0, (int)realCount);
                completions = tmp;
            }
            imm.displayCompletions(this, completions);
        }
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$setValidator(Validator validator) {
        this.mValidator = validator;
    }

    private final Validator $$robo$$android_widget_AutoCompleteTextView$getValidator() {
        return this.mValidator;
    }

    private final void $$robo$$android_widget_AutoCompleteTextView$performValidation() {
        if (this.mValidator == null) {
            return;
        }
        CharSequence text = this.getText();
        if (!TextUtils.isEmpty(text) && !this.mValidator.isValid(text)) {
            this.setText(this.mValidator.fixText(text));
        }
    }

    private final Filter $$robo$$android_widget_AutoCompleteTextView$getFilter() {
        return this.mFilter;
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_AutoCompleteTextView$__constructor__(context);
    }

    public AutoCompleteTextView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AutoCompleteTextView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_AutoCompleteTextView$__constructor__(context, attributeSet);
    }

    public AutoCompleteTextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842859);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AutoCompleteTextView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_AutoCompleteTextView$__constructor__(context, attributeSet, n);
    }

    public AutoCompleteTextView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AutoCompleteTextView$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_AutoCompleteTextView$__constructor__(context, attributeSet, n, n2);
    }

    public AutoCompleteTextView(Context context, AttributeSet attributeSet, int n, int n2) {
        this(context, attributeSet, n, n2, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AutoCompleteTextView$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2, Resources.Theme theme) {
        this.$$robo$$android_widget_AutoCompleteTextView$__constructor__(context, attributeSet, n, n2, theme);
    }

    public AutoCompleteTextView(Context context, AttributeSet attributeSet, int n, int n2, Resources.Theme theme) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AutoCompleteTextView$__constructor__(android.content.Context android.util.AttributeSet int int android.content.res.Resources$Theme ), 0, this, context, attributeSet, n, n2, theme);
    }

    @Override
    public void setOnClickListener(View.OnClickListener onClickListener) {
        InvokeDynamicSupport.bootstrap("setOnClickListener", $$robo$$android_widget_AutoCompleteTextView$setOnClickListener(android.view.View$OnClickListener ), 0, this, onClickListener);
    }

    private void onClickImpl() {
        InvokeDynamicSupport.bootstrap("onClickImpl", $$robo$$android_widget_AutoCompleteTextView$onClickImpl(), 0, this);
    }

    public void setCompletionHint(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setCompletionHint", $$robo$$android_widget_AutoCompleteTextView$setCompletionHint(java.lang.CharSequence ), 0, this, charSequence);
    }

    public CharSequence getCompletionHint() {
        return InvokeDynamicSupport.bootstrap("getCompletionHint", $$robo$$android_widget_AutoCompleteTextView$getCompletionHint(), 0, this);
    }

    public int getDropDownWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getDropDownWidth", $$robo$$android_widget_AutoCompleteTextView$getDropDownWidth(), 0, this);
    }

    public void setDropDownWidth(int n) {
        InvokeDynamicSupport.bootstrap("setDropDownWidth", $$robo$$android_widget_AutoCompleteTextView$setDropDownWidth(int ), 0, this, n);
    }

    public int getDropDownHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getDropDownHeight", $$robo$$android_widget_AutoCompleteTextView$getDropDownHeight(), 0, this);
    }

    public void setDropDownHeight(int n) {
        InvokeDynamicSupport.bootstrap("setDropDownHeight", $$robo$$android_widget_AutoCompleteTextView$setDropDownHeight(int ), 0, this, n);
    }

    public int getDropDownAnchor() {
        return (int)InvokeDynamicSupport.bootstrap("getDropDownAnchor", $$robo$$android_widget_AutoCompleteTextView$getDropDownAnchor(), 0, this);
    }

    public void setDropDownAnchor(int n) {
        InvokeDynamicSupport.bootstrap("setDropDownAnchor", $$robo$$android_widget_AutoCompleteTextView$setDropDownAnchor(int ), 0, this, n);
    }

    public Drawable getDropDownBackground() {
        return InvokeDynamicSupport.bootstrap("getDropDownBackground", $$robo$$android_widget_AutoCompleteTextView$getDropDownBackground(), 0, this);
    }

    public void setDropDownBackgroundDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setDropDownBackgroundDrawable", $$robo$$android_widget_AutoCompleteTextView$setDropDownBackgroundDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public void setDropDownBackgroundResource(int n) {
        InvokeDynamicSupport.bootstrap("setDropDownBackgroundResource", $$robo$$android_widget_AutoCompleteTextView$setDropDownBackgroundResource(int ), 0, this, n);
    }

    public void setDropDownVerticalOffset(int n) {
        InvokeDynamicSupport.bootstrap("setDropDownVerticalOffset", $$robo$$android_widget_AutoCompleteTextView$setDropDownVerticalOffset(int ), 0, this, n);
    }

    public int getDropDownVerticalOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getDropDownVerticalOffset", $$robo$$android_widget_AutoCompleteTextView$getDropDownVerticalOffset(), 0, this);
    }

    public void setDropDownHorizontalOffset(int n) {
        InvokeDynamicSupport.bootstrap("setDropDownHorizontalOffset", $$robo$$android_widget_AutoCompleteTextView$setDropDownHorizontalOffset(int ), 0, this, n);
    }

    public int getDropDownHorizontalOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getDropDownHorizontalOffset", $$robo$$android_widget_AutoCompleteTextView$getDropDownHorizontalOffset(), 0, this);
    }

    public void setDropDownAnimationStyle(int n) {
        InvokeDynamicSupport.bootstrap("setDropDownAnimationStyle", $$robo$$android_widget_AutoCompleteTextView$setDropDownAnimationStyle(int ), 0, this, n);
    }

    public int getDropDownAnimationStyle() {
        return (int)InvokeDynamicSupport.bootstrap("getDropDownAnimationStyle", $$robo$$android_widget_AutoCompleteTextView$getDropDownAnimationStyle(), 0, this);
    }

    public boolean isDropDownAlwaysVisible() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDropDownAlwaysVisible", $$robo$$android_widget_AutoCompleteTextView$isDropDownAlwaysVisible(), 0, this);
    }

    public void setDropDownAlwaysVisible(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDropDownAlwaysVisible", $$robo$$android_widget_AutoCompleteTextView$setDropDownAlwaysVisible(boolean ), 0, this, bl);
    }

    public boolean isDropDownDismissedOnCompletion() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDropDownDismissedOnCompletion", $$robo$$android_widget_AutoCompleteTextView$isDropDownDismissedOnCompletion(), 0, this);
    }

    public void setDropDownDismissedOnCompletion(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDropDownDismissedOnCompletion", $$robo$$android_widget_AutoCompleteTextView$setDropDownDismissedOnCompletion(boolean ), 0, this, bl);
    }

    public int getThreshold() {
        return (int)InvokeDynamicSupport.bootstrap("getThreshold", $$robo$$android_widget_AutoCompleteTextView$getThreshold(), 0, this);
    }

    public void setThreshold(int n) {
        InvokeDynamicSupport.bootstrap("setThreshold", $$robo$$android_widget_AutoCompleteTextView$setThreshold(int ), 0, this, n);
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        InvokeDynamicSupport.bootstrap("setOnItemClickListener", $$robo$$android_widget_AutoCompleteTextView$setOnItemClickListener(android.widget.AdapterView$OnItemClickListener ), 0, this, onItemClickListener);
    }

    public void setOnItemSelectedListener(AdapterView.OnItemSelectedListener onItemSelectedListener) {
        InvokeDynamicSupport.bootstrap("setOnItemSelectedListener", $$robo$$android_widget_AutoCompleteTextView$setOnItemSelectedListener(android.widget.AdapterView$OnItemSelectedListener ), 0, this, onItemSelectedListener);
    }

    @Deprecated
    public AdapterView.OnItemClickListener getItemClickListener() {
        return InvokeDynamicSupport.bootstrap("getItemClickListener", $$robo$$android_widget_AutoCompleteTextView$getItemClickListener(), 0, this);
    }

    @Deprecated
    public AdapterView.OnItemSelectedListener getItemSelectedListener() {
        return InvokeDynamicSupport.bootstrap("getItemSelectedListener", $$robo$$android_widget_AutoCompleteTextView$getItemSelectedListener(), 0, this);
    }

    public AdapterView.OnItemClickListener getOnItemClickListener() {
        return InvokeDynamicSupport.bootstrap("getOnItemClickListener", $$robo$$android_widget_AutoCompleteTextView$getOnItemClickListener(), 0, this);
    }

    public AdapterView.OnItemSelectedListener getOnItemSelectedListener() {
        return InvokeDynamicSupport.bootstrap("getOnItemSelectedListener", $$robo$$android_widget_AutoCompleteTextView$getOnItemSelectedListener(), 0, this);
    }

    public void setOnDismissListener(OnDismissListener onDismissListener) {
        InvokeDynamicSupport.bootstrap("setOnDismissListener", $$robo$$android_widget_AutoCompleteTextView$setOnDismissListener(android.widget.AutoCompleteTextView$OnDismissListener ), 0, this, onDismissListener);
    }

    public ListAdapter getAdapter() {
        return InvokeDynamicSupport.bootstrap("getAdapter", $$robo$$android_widget_AutoCompleteTextView$getAdapter(), 0, this);
    }

    public <T extends ListAdapter & Filterable> void setAdapter(T t) {
        InvokeDynamicSupport.bootstrap("setAdapter", $$robo$$android_widget_AutoCompleteTextView$setAdapter(T ), 0, this, t);
    }

    @Override
    public boolean onKeyPreIme(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyPreIme", $$robo$$android_widget_AutoCompleteTextView$onKeyPreIme(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyUp", $$robo$$android_widget_AutoCompleteTextView$onKeyUp(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyDown", $$robo$$android_widget_AutoCompleteTextView$onKeyDown(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    public boolean enoughToFilter() {
        return (boolean)InvokeDynamicSupport.bootstrap("enoughToFilter", $$robo$$android_widget_AutoCompleteTextView$enoughToFilter(), 0, this);
    }

    void doBeforeTextChanged() {
        InvokeDynamicSupport.bootstrap("doBeforeTextChanged", $$robo$$android_widget_AutoCompleteTextView$doBeforeTextChanged(), 0, this);
    }

    void doAfterTextChanged() {
        InvokeDynamicSupport.bootstrap("doAfterTextChanged", $$robo$$android_widget_AutoCompleteTextView$doAfterTextChanged(), 0, this);
    }

    public boolean isPopupShowing() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPopupShowing", $$robo$$android_widget_AutoCompleteTextView$isPopupShowing(), 0, this);
    }

    protected CharSequence convertSelectionToString(Object object) {
        return InvokeDynamicSupport.bootstrap("convertSelectionToString", $$robo$$android_widget_AutoCompleteTextView$convertSelectionToString(java.lang.Object ), 0, this, object);
    }

    public void clearListSelection() {
        InvokeDynamicSupport.bootstrap("clearListSelection", $$robo$$android_widget_AutoCompleteTextView$clearListSelection(), 0, this);
    }

    public void setListSelection(int n) {
        InvokeDynamicSupport.bootstrap("setListSelection", $$robo$$android_widget_AutoCompleteTextView$setListSelection(int ), 0, this, n);
    }

    public int getListSelection() {
        return (int)InvokeDynamicSupport.bootstrap("getListSelection", $$robo$$android_widget_AutoCompleteTextView$getListSelection(), 0, this);
    }

    protected void performFiltering(CharSequence charSequence, int n) {
        InvokeDynamicSupport.bootstrap("performFiltering", $$robo$$android_widget_AutoCompleteTextView$performFiltering(java.lang.CharSequence int ), 0, this, charSequence, n);
    }

    public void performCompletion() {
        InvokeDynamicSupport.bootstrap("performCompletion", $$robo$$android_widget_AutoCompleteTextView$performCompletion(), 0, this);
    }

    @Override
    public void onCommitCompletion(CompletionInfo completionInfo) {
        InvokeDynamicSupport.bootstrap("onCommitCompletion", $$robo$$android_widget_AutoCompleteTextView$onCommitCompletion(android.view.inputmethod.CompletionInfo ), 0, this, completionInfo);
    }

    private void performCompletion(View view, int n, long l) {
        InvokeDynamicSupport.bootstrap("performCompletion", $$robo$$android_widget_AutoCompleteTextView$performCompletion(android.view.View int long ), 0, this, view, n, l);
    }

    public boolean isPerformingCompletion() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPerformingCompletion", $$robo$$android_widget_AutoCompleteTextView$isPerformingCompletion(), 0, this);
    }

    public void setText(CharSequence charSequence, boolean bl) {
        InvokeDynamicSupport.bootstrap("setText", $$robo$$android_widget_AutoCompleteTextView$setText(java.lang.CharSequence boolean ), 0, this, charSequence, bl);
    }

    protected void replaceText(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("replaceText", $$robo$$android_widget_AutoCompleteTextView$replaceText(java.lang.CharSequence ), 0, this, charSequence);
    }

    @Override
    public void onFilterComplete(int n) {
        InvokeDynamicSupport.bootstrap("onFilterComplete", $$robo$$android_widget_AutoCompleteTextView$onFilterComplete(int ), 0, this, n);
    }

    private void updateDropDownForFilter(int n) {
        InvokeDynamicSupport.bootstrap("updateDropDownForFilter", $$robo$$android_widget_AutoCompleteTextView$updateDropDownForFilter(int ), 0, this, n);
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("onWindowFocusChanged", $$robo$$android_widget_AutoCompleteTextView$onWindowFocusChanged(boolean ), 0, this, bl);
    }

    @Override
    protected void onDisplayHint(int n) {
        InvokeDynamicSupport.bootstrap("onDisplayHint", $$robo$$android_widget_AutoCompleteTextView$onDisplayHint(int ), 0, this, n);
    }

    @Override
    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        InvokeDynamicSupport.bootstrap("onFocusChanged", $$robo$$android_widget_AutoCompleteTextView$onFocusChanged(boolean int android.graphics.Rect ), 0, this, bl, n, rect);
    }

    @Override
    protected void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$android_widget_AutoCompleteTextView$onAttachedToWindow(), 0, this);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_widget_AutoCompleteTextView$onDetachedFromWindow(), 0, this);
    }

    public void dismissDropDown() {
        InvokeDynamicSupport.bootstrap("dismissDropDown", $$robo$$android_widget_AutoCompleteTextView$dismissDropDown(), 0, this);
    }

    @Override
    protected boolean setFrame(int n, int n2, int n3, int n4) {
        return (boolean)InvokeDynamicSupport.bootstrap("setFrame", $$robo$$android_widget_AutoCompleteTextView$setFrame(int int int int ), 0, this, n, n2, n3, n4);
    }

    public void showDropDownAfterLayout() {
        InvokeDynamicSupport.bootstrap("showDropDownAfterLayout", $$robo$$android_widget_AutoCompleteTextView$showDropDownAfterLayout(), 0, this);
    }

    public void ensureImeVisible(boolean bl) {
        InvokeDynamicSupport.bootstrap("ensureImeVisible", $$robo$$android_widget_AutoCompleteTextView$ensureImeVisible(boolean ), 0, this, bl);
    }

    public boolean isInputMethodNotNeeded() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInputMethodNotNeeded", $$robo$$android_widget_AutoCompleteTextView$isInputMethodNotNeeded(), 0, this);
    }

    public void showDropDown() {
        InvokeDynamicSupport.bootstrap("showDropDown", $$robo$$android_widget_AutoCompleteTextView$showDropDown(), 0, this);
    }

    public void setForceIgnoreOutsideTouch(boolean bl) {
        InvokeDynamicSupport.bootstrap("setForceIgnoreOutsideTouch", $$robo$$android_widget_AutoCompleteTextView$setForceIgnoreOutsideTouch(boolean ), 0, this, bl);
    }

    private void buildImeCompletions() {
        InvokeDynamicSupport.bootstrap("buildImeCompletions", $$robo$$android_widget_AutoCompleteTextView$buildImeCompletions(), 0, this);
    }

    public void setValidator(Validator validator) {
        InvokeDynamicSupport.bootstrap("setValidator", $$robo$$android_widget_AutoCompleteTextView$setValidator(android.widget.AutoCompleteTextView$Validator ), 0, this, validator);
    }

    public Validator getValidator() {
        return InvokeDynamicSupport.bootstrap("getValidator", $$robo$$android_widget_AutoCompleteTextView$getValidator(), 0, this);
    }

    public void performValidation() {
        InvokeDynamicSupport.bootstrap("performValidation", $$robo$$android_widget_AutoCompleteTextView$performValidation(), 0, this);
    }

    protected Filter getFilter() {
        return InvokeDynamicSupport.bootstrap("getFilter", $$robo$$android_widget_AutoCompleteTextView$getFilter(), 0, this);
    }

    public /* synthetic */ AutoCompleteTextView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AutoCompleteTextView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class PopupDataSetObserver
    extends DataSetObserver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private WeakReference<AutoCompleteTextView> mViewReference;
        private Runnable updateRunnable;

        private void $$robo$$android_widget_AutoCompleteTextView_PopupDataSetObserver$__constructor__(AutoCompleteTextView view) {
            this.updateRunnable = new Runnable(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ PopupDataSetObserver this$0;

                private void $$robo$$android_widget_AutoCompleteTextView_PopupDataSetObserver_1$__constructor__(PopupDataSetObserver this$0) {
                }

                private final void $$robo$$android_widget_AutoCompleteTextView_PopupDataSetObserver_1$run() {
                    AutoCompleteTextView textView = (AutoCompleteTextView)this.this$0.mViewReference.get();
                    if (textView == null) {
                        return;
                    }
                    ListAdapter adapter = textView.mAdapter;
                    if (adapter == null) {
                        return;
                    }
                    textView.updateDropDownForFilter(adapter.getCount());
                }

                private void __constructor__(PopupDataSetObserver popupDataSetObserver) {
                    this.$$robo$$android_widget_AutoCompleteTextView_PopupDataSetObserver_1$__constructor__(popupDataSetObserver);
                }
                {
                    this.this$0 = popupDataSetObserver;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AutoCompleteTextView_PopupDataSetObserver_1$__constructor__(android.widget.AutoCompleteTextView$PopupDataSetObserver ), 0, this, popupDataSetObserver);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_AutoCompleteTextView_PopupDataSetObserver_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mViewReference = new WeakReference<AutoCompleteTextView>(view);
        }

        private final void $$robo$$android_widget_AutoCompleteTextView_PopupDataSetObserver$onChanged() {
            AutoCompleteTextView textView = (AutoCompleteTextView)this.mViewReference.get();
            if (textView != null && textView.mAdapter != null) {
                textView.post(this.updateRunnable);
            }
        }

        private /* synthetic */ void $$robo$$android_widget_AutoCompleteTextView_PopupDataSetObserver$__constructor__(AutoCompleteTextView x0, 1 x1) {
        }

        private void __constructor__(AutoCompleteTextView autoCompleteTextView) {
            this.$$robo$$android_widget_AutoCompleteTextView_PopupDataSetObserver$__constructor__(autoCompleteTextView);
        }

        private PopupDataSetObserver(AutoCompleteTextView autoCompleteTextView) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AutoCompleteTextView_PopupDataSetObserver$__constructor__(android.widget.AutoCompleteTextView ), 0, this, autoCompleteTextView);
        }

        @Override
        public void onChanged() {
            InvokeDynamicSupport.bootstrap("onChanged", $$robo$$android_widget_AutoCompleteTextView_PopupDataSetObserver$onChanged(), 0, this);
        }

        private /* synthetic */ void __constructor__(AutoCompleteTextView autoCompleteTextView, 1 var2_2) {
            this.$$robo$$android_widget_AutoCompleteTextView_PopupDataSetObserver$__constructor__(autoCompleteTextView, var2_2);
        }

        public /* synthetic */ PopupDataSetObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PopupDataSetObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class PassThroughClickListener
    implements View.OnClickListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private View.OnClickListener mWrapped;
        /* synthetic */ AutoCompleteTextView this$0;

        private void $$robo$$android_widget_AutoCompleteTextView_PassThroughClickListener$__constructor__(AutoCompleteTextView autoCompleteTextView) {
        }

        private final void $$robo$$android_widget_AutoCompleteTextView_PassThroughClickListener$onClick(View v) {
            this.this$0.onClickImpl();
            if (this.mWrapped != null) {
                this.mWrapped.onClick(v);
            }
        }

        private /* synthetic */ void $$robo$$android_widget_AutoCompleteTextView_PassThroughClickListener$__constructor__(AutoCompleteTextView x0, 1 x1) {
        }

        private void __constructor__(AutoCompleteTextView autoCompleteTextView) {
            this.$$robo$$android_widget_AutoCompleteTextView_PassThroughClickListener$__constructor__(autoCompleteTextView);
        }

        private PassThroughClickListener(AutoCompleteTextView autoCompleteTextView) {
            this.this$0 = autoCompleteTextView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AutoCompleteTextView_PassThroughClickListener$__constructor__(android.widget.AutoCompleteTextView ), 0, this, autoCompleteTextView);
        }

        @Override
        public void onClick(View view) {
            InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_AutoCompleteTextView_PassThroughClickListener$onClick(android.view.View ), 0, this, view);
        }

        private /* synthetic */ void __constructor__(AutoCompleteTextView autoCompleteTextView, 1 var2_2) {
            this.$$robo$$android_widget_AutoCompleteTextView_PassThroughClickListener$__constructor__(autoCompleteTextView, var2_2);
        }

        public /* synthetic */ PassThroughClickListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PassThroughClickListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnDismissListener
    extends InstrumentedInterface {
        public void onDismiss();
    }

    public static interface Validator
    extends InstrumentedInterface {
        public boolean isValid(CharSequence var1);

        public CharSequence fixText(CharSequence var1);
    }

    private class DropDownItemClickListener
    implements AdapterView.OnItemClickListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ AutoCompleteTextView this$0;

        private void $$robo$$android_widget_AutoCompleteTextView_DropDownItemClickListener$__constructor__(AutoCompleteTextView autoCompleteTextView) {
        }

        private final void $$robo$$android_widget_AutoCompleteTextView_DropDownItemClickListener$onItemClick(AdapterView parent, View v, int position, long id2) {
            this.this$0.performCompletion(v, position, id2);
        }

        private /* synthetic */ void $$robo$$android_widget_AutoCompleteTextView_DropDownItemClickListener$__constructor__(AutoCompleteTextView x0, 1 x1) {
        }

        private void __constructor__(AutoCompleteTextView autoCompleteTextView) {
            this.$$robo$$android_widget_AutoCompleteTextView_DropDownItemClickListener$__constructor__(autoCompleteTextView);
        }

        private DropDownItemClickListener(AutoCompleteTextView autoCompleteTextView) {
            this.this$0 = autoCompleteTextView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AutoCompleteTextView_DropDownItemClickListener$__constructor__(android.widget.AutoCompleteTextView ), 0, this, autoCompleteTextView);
        }

        public void onItemClick(AdapterView adapterView, View view, int n, long l) {
            InvokeDynamicSupport.bootstrap("onItemClick", $$robo$$android_widget_AutoCompleteTextView_DropDownItemClickListener$onItemClick(android.widget.AdapterView android.view.View int long ), 0, this, adapterView, view, n, l);
        }

        private /* synthetic */ void __constructor__(AutoCompleteTextView autoCompleteTextView, 1 var2_2) {
            this.$$robo$$android_widget_AutoCompleteTextView_DropDownItemClickListener$__constructor__(autoCompleteTextView, var2_2);
        }

        public /* synthetic */ DropDownItemClickListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DropDownItemClickListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class MyWatcher
    implements TextWatcher,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ AutoCompleteTextView this$0;

        private void $$robo$$android_widget_AutoCompleteTextView_MyWatcher$__constructor__(AutoCompleteTextView autoCompleteTextView) {
        }

        private final void $$robo$$android_widget_AutoCompleteTextView_MyWatcher$afterTextChanged(Editable s) {
            this.this$0.doAfterTextChanged();
        }

        private final void $$robo$$android_widget_AutoCompleteTextView_MyWatcher$beforeTextChanged(CharSequence s, int start, int count, int after) {
            this.this$0.doBeforeTextChanged();
        }

        private final void $$robo$$android_widget_AutoCompleteTextView_MyWatcher$onTextChanged(CharSequence s, int start, int before, int count) {
        }

        private /* synthetic */ void $$robo$$android_widget_AutoCompleteTextView_MyWatcher$__constructor__(AutoCompleteTextView x0, 1 x1) {
        }

        private void __constructor__(AutoCompleteTextView autoCompleteTextView) {
            this.$$robo$$android_widget_AutoCompleteTextView_MyWatcher$__constructor__(autoCompleteTextView);
        }

        private MyWatcher(AutoCompleteTextView autoCompleteTextView) {
            this.this$0 = autoCompleteTextView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AutoCompleteTextView_MyWatcher$__constructor__(android.widget.AutoCompleteTextView ), 0, this, autoCompleteTextView);
        }

        @Override
        public void afterTextChanged(Editable editable) {
            InvokeDynamicSupport.bootstrap("afterTextChanged", $$robo$$android_widget_AutoCompleteTextView_MyWatcher$afterTextChanged(android.text.Editable ), 0, this, editable);
        }

        @Override
        public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("beforeTextChanged", $$robo$$android_widget_AutoCompleteTextView_MyWatcher$beforeTextChanged(java.lang.CharSequence int int int ), 0, this, charSequence, n, n2, n3);
        }

        @Override
        public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("onTextChanged", $$robo$$android_widget_AutoCompleteTextView_MyWatcher$onTextChanged(java.lang.CharSequence int int int ), 0, this, charSequence, n, n2, n3);
        }

        private /* synthetic */ void __constructor__(AutoCompleteTextView autoCompleteTextView, 1 var2_2) {
            this.$$robo$$android_widget_AutoCompleteTextView_MyWatcher$__constructor__(autoCompleteTextView, var2_2);
        }

        public /* synthetic */ MyWatcher() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyWatcher)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

