/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.ActivityThread;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.database.ContentObserver;
import android.icu.util.Calendar;
import android.os.Handler;
import android.text.format.DateFormat;
import android.text.format.Time;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.android.internal.R;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import libcore.icu.DateUtilsBridge;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@RemoteViews.RemoteView
public class DateTimeView
extends TextView
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int SHOW_TIME = 0;
    private static int SHOW_MONTH_DAY_YEAR = 1;
    Date mTime;
    long mTimeMillis;
    int mLastDisplay;
    java.text.DateFormat mLastFormat;
    private long mUpdateTimeMillis;
    private static ThreadLocal<ReceiverInfo> sReceiverInfo;
    private String mNowText;
    private boolean mShowRelativeTime;

    private void $$robo$$android_widget_DateTimeView$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_DateTimeView$__constructor__(Context context, AttributeSet attrs) {
        this.mLastDisplay = -1;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DateTimeView, 0, 0);
        int N = a.getIndexCount();
        for (int i = 0; i < N; ++i) {
            int attr2 = a.getIndex(i);
            switch (attr2) {
                case 0: {
                    boolean relative = a.getBoolean(i, false);
                    this.setShowRelativeTime(relative);
                }
            }
        }
        a.recycle();
    }

    private final void $$robo$$android_widget_DateTimeView$onAttachedToWindow() {
        super.onAttachedToWindow();
        ReceiverInfo ri = sReceiverInfo.get();
        if (ri == null) {
            ri = new ReceiverInfo();
            sReceiverInfo.set(ri);
        }
        ri.addView(this);
    }

    private final void $$robo$$android_widget_DateTimeView$onDetachedFromWindow() {
        super.onDetachedFromWindow();
        ReceiverInfo ri = sReceiverInfo.get();
        if (ri != null) {
            ri.removeView(this);
        }
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_DateTimeView$setTime(long time) {
        Time t = new Time();
        t.set(time);
        this.mTimeMillis = t.toMillis(false);
        this.mTime = new Date(t.year - 1900, t.month, t.monthDay, t.hour, t.minute, 0);
        this.update();
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_DateTimeView$setShowRelativeTime(boolean showRelativeTime) {
        this.mShowRelativeTime = showRelativeTime;
        this.updateNowText();
        this.update();
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_DateTimeView$setVisibility(int visibility) {
        boolean gotVisible = visibility != 8 && this.getVisibility() == 8;
        super.setVisibility(visibility);
        if (gotVisible) {
            this.update();
        }
    }

    private final void $$robo$$android_widget_DateTimeView$update() {
        java.text.DateFormat format;
        if (this.mTime == null || this.getVisibility() == 8) {
            return;
        }
        if (this.mShowRelativeTime) {
            this.updateRelativeTime();
            return;
        }
        Date time = this.mTime;
        Time t = new Time();
        t.set(this.mTimeMillis);
        t.second = 0;
        t.hour -= 12;
        long twelveHoursBefore = t.toMillis(false);
        t.hour += 12;
        long twelveHoursAfter = t.toMillis(false);
        t.hour = 0;
        t.minute = 0;
        long midnightBefore = t.toMillis(false);
        ++t.monthDay;
        long midnightAfter = t.toMillis(false);
        Object nowMillis = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        t.set((long)nowMillis);
        t.second = 0;
        nowMillis = t.normalize(false);
        int display = nowMillis >= midnightBefore && nowMillis < midnightAfter || nowMillis >= twelveHoursBefore && nowMillis < twelveHoursAfter ? 0 : 1;
        if (display == this.mLastDisplay && this.mLastFormat != null) {
            format = this.mLastFormat;
        } else {
            switch (display) {
                case 0: {
                    format = this.getTimeFormat();
                    break;
                }
                case 1: {
                    format = java.text.DateFormat.getDateInstance(3);
                    break;
                }
                default: {
                    throw new RuntimeException("unknown display value: " + display);
                }
            }
            this.mLastFormat = format;
        }
        String text = format.format(this.mTime);
        this.setText(text);
        this.mUpdateTimeMillis = display == 0 ? (twelveHoursAfter > midnightAfter ? twelveHoursAfter : midnightAfter) : (this.mTimeMillis < nowMillis ? 0L : (twelveHoursBefore < midnightBefore ? twelveHoursBefore : midnightBefore));
    }

    private final void $$robo$$android_widget_DateTimeView$updateRelativeTime() {
        long millisIncrease;
        String result;
        int count;
        boolean past;
        CallSite now = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        long duration = Math.abs((long)(now - this.mTimeMillis));
        boolean bl = past = now >= this.mTimeMillis;
        if (duration < 60000L) {
            this.setText(this.mNowText);
            this.mUpdateTimeMillis = this.mTimeMillis + 60000L + 1L;
            return;
        }
        if (duration < 3600000L) {
            count = (int)(duration / 60000L);
            result = String.format(this.getContext().getResources().getQuantityString(past ? 18153484 : 18153485, count), count);
            millisIncrease = 60000L;
        } else if (duration < 86400000L) {
            count = (int)(duration / 3600000L);
            result = String.format(this.getContext().getResources().getQuantityString(past ? 18153480 : 18153481, count), count);
            millisIncrease = 3600000L;
        } else if (duration < 31449600000L) {
            TimeZone timeZone = TimeZone.getDefault();
            count = Math.max(Math.abs(DateTimeView.dayDistance(timeZone, this.mTimeMillis, (long)now)), 1);
            result = String.format(this.getContext().getResources().getQuantityString(past ? 18153476 : 0x1150005, count), count);
            if (past || count != 1) {
                this.mUpdateTimeMillis = this.computeNextMidnight(timeZone);
                millisIncrease = -1L;
            } else {
                millisIncrease = 86400000L;
            }
        } else {
            count = (int)(duration / 31449600000L);
            result = String.format(this.getContext().getResources().getQuantityString(past ? 0x1150010 : 0x1150011, count), count);
            millisIncrease = 31449600000L;
        }
        if (millisIncrease != -1L) {
            this.mUpdateTimeMillis = past ? this.mTimeMillis + millisIncrease * (long)(count + 1) + 1L : this.mTimeMillis - millisIncrease * (long)count + 1L;
        }
        this.setText(result);
    }

    private final long $$robo$$android_widget_DateTimeView$computeNextMidnight(TimeZone timeZone) {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(DateUtilsBridge.icuTimeZone(timeZone));
        c.add(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTimeInMillis();
    }

    private final void $$robo$$android_widget_DateTimeView$onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.updateNowText();
        this.update();
    }

    private final void $$robo$$android_widget_DateTimeView$updateNowText() {
        if (!this.mShowRelativeTime) {
            return;
        }
        this.mNowText = this.getContext().getResources().getString(17040319);
    }

    private static final int $$robo$$android_widget_DateTimeView$dayDistance(TimeZone timeZone, long startTime, long endTime) {
        return Time.getJulianDay(endTime, timeZone.getOffset(endTime) / 1000) - Time.getJulianDay(startTime, timeZone.getOffset(startTime) / 1000);
    }

    private final java.text.DateFormat $$robo$$android_widget_DateTimeView$getTimeFormat() {
        return DateFormat.getTimeFormat(this.getContext());
    }

    private final void $$robo$$android_widget_DateTimeView$clearFormatAndUpdate() {
        this.mLastFormat = null;
        this.update();
    }

    private final void $$robo$$android_widget_DateTimeView$onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        if (this.mShowRelativeTime) {
            String result;
            boolean past;
            CallSite now = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            long duration = Math.abs((long)(now - this.mTimeMillis));
            boolean bl = past = now >= this.mTimeMillis;
            if (duration < 60000L) {
                result = this.mNowText;
            } else if (duration < 3600000L) {
                int count = (int)(duration / 60000L);
                result = String.format(this.getContext().getResources().getQuantityString(past ? 18153482 : 18153483, count), count);
            } else if (duration < 86400000L) {
                int count = (int)(duration / 3600000L);
                result = String.format(this.getContext().getResources().getQuantityString(past ? 18153478 : 18153479, count), count);
            } else if (duration < 31449600000L) {
                TimeZone timeZone = TimeZone.getDefault();
                int count = Math.max(Math.abs(DateTimeView.dayDistance(timeZone, this.mTimeMillis, (long)now)), 1);
                result = String.format(this.getContext().getResources().getQuantityString(past ? 18153474 : 18153475, count), count);
            } else {
                int count = (int)(duration / 31449600000L);
                result = String.format(this.getContext().getResources().getQuantityString(past ? 18153486 : 18153487, count), count);
            }
            info.setText(result);
        }
    }

    private static final void $$robo$$android_widget_DateTimeView$setReceiverHandler(Handler handler) {
        ReceiverInfo ri = sReceiverInfo.get();
        if (ri == null) {
            ri = new ReceiverInfo();
            sReceiverInfo.set(ri);
        }
        ri.setHandler(handler);
    }

    static void __staticInitializer__() {
        sReceiverInfo = new ThreadLocal();
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_DateTimeView$__constructor__(context);
    }

    public DateTimeView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DateTimeView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_DateTimeView$__constructor__(context, attributeSet);
    }

    public DateTimeView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DateTimeView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    @Override
    protected void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$android_widget_DateTimeView$onAttachedToWindow(), 0, this);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_widget_DateTimeView$onDetachedFromWindow(), 0, this);
    }

    @RemotableViewMethod
    public void setTime(long l) {
        InvokeDynamicSupport.bootstrap("setTime", $$robo$$android_widget_DateTimeView$setTime(long ), 0, this, l);
    }

    @RemotableViewMethod
    public void setShowRelativeTime(boolean bl) {
        InvokeDynamicSupport.bootstrap("setShowRelativeTime", $$robo$$android_widget_DateTimeView$setShowRelativeTime(boolean ), 0, this, bl);
    }

    @Override
    @RemotableViewMethod
    public void setVisibility(int n) {
        InvokeDynamicSupport.bootstrap("setVisibility", $$robo$$android_widget_DateTimeView$setVisibility(int ), 0, this, n);
    }

    void update() {
        InvokeDynamicSupport.bootstrap("update", $$robo$$android_widget_DateTimeView$update(), 0, this);
    }

    private void updateRelativeTime() {
        InvokeDynamicSupport.bootstrap("updateRelativeTime", $$robo$$android_widget_DateTimeView$updateRelativeTime(), 0, this);
    }

    private long computeNextMidnight(TimeZone timeZone) {
        return (long)InvokeDynamicSupport.bootstrap("computeNextMidnight", $$robo$$android_widget_DateTimeView$computeNextMidnight(java.util.TimeZone ), 0, this, timeZone);
    }

    @Override
    protected void onConfigurationChanged(Configuration configuration) {
        InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$android_widget_DateTimeView$onConfigurationChanged(android.content.res.Configuration ), 0, this, configuration);
    }

    private void updateNowText() {
        InvokeDynamicSupport.bootstrap("updateNowText", $$robo$$android_widget_DateTimeView$updateNowText(), 0, this);
    }

    private static int dayDistance(TimeZone timeZone, long l, long l2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("dayDistance", $$robo$$android_widget_DateTimeView$dayDistance(java.util.TimeZone long long ), 0, (TimeZone)timeZone, (long)l, (long)l2);
    }

    private java.text.DateFormat getTimeFormat() {
        return InvokeDynamicSupport.bootstrap("getTimeFormat", $$robo$$android_widget_DateTimeView$getTimeFormat(), 0, this);
    }

    void clearFormatAndUpdate() {
        InvokeDynamicSupport.bootstrap("clearFormatAndUpdate", $$robo$$android_widget_DateTimeView$clearFormatAndUpdate(), 0, this);
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfoInternal", $$robo$$android_widget_DateTimeView$onInitializeAccessibilityNodeInfoInternal(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    public static void setReceiverHandler(Handler handler) {
        InvokeDynamicSupport.bootstrapStatic("setReceiverHandler", $$robo$$android_widget_DateTimeView$setReceiverHandler(android.os.Handler ), 0, (Handler)handler);
    }

    static {
        RobolectricInternals.classInitializing(DateTimeView.class);
    }

    public /* synthetic */ DateTimeView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DateTimeView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class ReceiverInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ArrayList<DateTimeView> mAttachedViews;
        private BroadcastReceiver mReceiver;
        private ContentObserver mObserver;
        private Handler mHandler;

        private void $$robo$$android_widget_DateTimeView_ReceiverInfo$__constructor__() {
            this.mAttachedViews = new ArrayList();
            this.mReceiver = new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ReceiverInfo this$0;

                private void $$robo$$android_widget_DateTimeView_ReceiverInfo_1$__constructor__(ReceiverInfo this$0) {
                }

                private final void $$robo$$android_widget_DateTimeView_ReceiverInfo_1$onReceive(Context context, Intent intent) {
                    String action = intent.getAction();
                    if ("android.intent.action.TIME_TICK".equals(action) && InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") < this.this$0.getSoonestUpdateTime()) {
                        return;
                    }
                    this.this$0.updateAll();
                }

                private void __constructor__(ReceiverInfo receiverInfo) {
                    this.$$robo$$android_widget_DateTimeView_ReceiverInfo_1$__constructor__(receiverInfo);
                }
                {
                    this.this$0 = receiverInfo;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DateTimeView_ReceiverInfo_1$__constructor__(android.widget.DateTimeView$ReceiverInfo ), 0, this, receiverInfo);
                }

                @Override
                public void onReceive(Context context, Intent intent) {
                    InvokeDynamicSupport.bootstrap("onReceive", $$robo$$android_widget_DateTimeView_ReceiverInfo_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mObserver = new ShadowedObject(this, new Handler()){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ReceiverInfo this$0;

                private void $$robo$$android_widget_DateTimeView_ReceiverInfo_2$__constructor__(ReceiverInfo this$0, Handler handler) {
                }

                private final void $$robo$$android_widget_DateTimeView_ReceiverInfo_2$onChange(boolean selfChange) {
                    this.this$0.updateAll();
                }

                private void __constructor__(ReceiverInfo receiverInfo, Handler handler) {
                    this.$$robo$$android_widget_DateTimeView_ReceiverInfo_2$__constructor__(receiverInfo, handler);
                }
                {
                    this.this$0 = receiverInfo;
                    super(handler);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DateTimeView_ReceiverInfo_2$__constructor__(android.widget.DateTimeView$ReceiverInfo android.os.Handler ), 0, this, receiverInfo, handler);
                }

                @Override
                public void onChange(boolean bl) {
                    InvokeDynamicSupport.bootstrap("onChange", $$robo$$android_widget_DateTimeView_ReceiverInfo_2$onChange(boolean ), 0, this, bl);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mHandler = new Handler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_widget_DateTimeView_ReceiverInfo$addView(DateTimeView v) {
            ArrayList<DateTimeView> arrayList = this.mAttachedViews;
            synchronized (arrayList) {
                boolean register = this.mAttachedViews.isEmpty();
                this.mAttachedViews.add(v);
                if (register) {
                    this.register(ReceiverInfo.getApplicationContextIfAvailable(v.getContext()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_widget_DateTimeView_ReceiverInfo$removeView(DateTimeView v) {
            ArrayList<DateTimeView> arrayList = this.mAttachedViews;
            synchronized (arrayList) {
                this.mAttachedViews.remove(v);
                if (this.mAttachedViews.isEmpty()) {
                    this.unregister(ReceiverInfo.getApplicationContextIfAvailable(v.getContext()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_widget_DateTimeView_ReceiverInfo$updateAll() {
            ArrayList<DateTimeView> arrayList = this.mAttachedViews;
            synchronized (arrayList) {
                int count = this.mAttachedViews.size();
                for (int i = 0; i < count; ++i) {
                    DateTimeView view = this.mAttachedViews.get(i);
                    view.post(() -> view.clearFormatAndUpdate());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final long $$robo$$android_widget_DateTimeView_ReceiverInfo$getSoonestUpdateTime() {
            long result = Long.MAX_VALUE;
            ArrayList<DateTimeView> arrayList = this.mAttachedViews;
            synchronized (arrayList) {
                int count = this.mAttachedViews.size();
                for (int i = 0; i < count; ++i) {
                    long time = this.mAttachedViews.get(i).mUpdateTimeMillis;
                    if (time >= result) continue;
                    result = time;
                }
            }
            return result;
        }

        private static final Context $$robo$$android_widget_DateTimeView_ReceiverInfo$getApplicationContextIfAvailable(Context context) {
            Context ac = context.getApplicationContext();
            return ac != null ? ac : ActivityThread.currentApplication().getApplicationContext();
        }

        private final void $$robo$$android_widget_DateTimeView_ReceiverInfo$register(Context context) {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.TIME_TICK");
            filter.addAction("android.intent.action.TIME_SET");
            filter.addAction("android.intent.action.CONFIGURATION_CHANGED");
            filter.addAction("android.intent.action.TIMEZONE_CHANGED");
            context.registerReceiver(this.mReceiver, filter, null, this.mHandler);
        }

        private final void $$robo$$android_widget_DateTimeView_ReceiverInfo$unregister(Context context) {
            context.unregisterReceiver(this.mReceiver);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_widget_DateTimeView_ReceiverInfo$setHandler(Handler handler) {
            this.mHandler = handler;
            ArrayList<DateTimeView> arrayList = this.mAttachedViews;
            synchronized (arrayList) {
                if (!this.mAttachedViews.isEmpty()) {
                    this.unregister(this.mAttachedViews.get(0).getContext());
                    this.register(this.mAttachedViews.get(0).getContext());
                }
            }
        }

        private /* synthetic */ void $$robo$$android_widget_DateTimeView_ReceiverInfo$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_widget_DateTimeView_ReceiverInfo$__constructor__();
        }

        private ReceiverInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DateTimeView_ReceiverInfo$__constructor__(), 0, this);
        }

        public void addView(DateTimeView dateTimeView) {
            InvokeDynamicSupport.bootstrap("addView", $$robo$$android_widget_DateTimeView_ReceiverInfo$addView(android.widget.DateTimeView ), 0, this, dateTimeView);
        }

        public void removeView(DateTimeView dateTimeView) {
            InvokeDynamicSupport.bootstrap("removeView", $$robo$$android_widget_DateTimeView_ReceiverInfo$removeView(android.widget.DateTimeView ), 0, this, dateTimeView);
        }

        void updateAll() {
            InvokeDynamicSupport.bootstrap("updateAll", $$robo$$android_widget_DateTimeView_ReceiverInfo$updateAll(), 0, this);
        }

        long getSoonestUpdateTime() {
            return (long)InvokeDynamicSupport.bootstrap("getSoonestUpdateTime", $$robo$$android_widget_DateTimeView_ReceiverInfo$getSoonestUpdateTime(), 0, this);
        }

        static Context getApplicationContextIfAvailable(Context context) {
            return InvokeDynamicSupport.bootstrapStatic("getApplicationContextIfAvailable", $$robo$$android_widget_DateTimeView_ReceiverInfo$getApplicationContextIfAvailable(android.content.Context ), 0, (Context)context);
        }

        void register(Context context) {
            InvokeDynamicSupport.bootstrap("register", $$robo$$android_widget_DateTimeView_ReceiverInfo$register(android.content.Context ), 0, this, context);
        }

        void unregister(Context context) {
            InvokeDynamicSupport.bootstrap("unregister", $$robo$$android_widget_DateTimeView_ReceiverInfo$unregister(android.content.Context ), 0, this, context);
        }

        public void setHandler(Handler handler) {
            InvokeDynamicSupport.bootstrap("setHandler", $$robo$$android_widget_DateTimeView_ReceiverInfo$setHandler(android.os.Handler ), 0, this, handler);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_widget_DateTimeView_ReceiverInfo$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ReceiverInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

