/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.icu.util.Calendar;
import android.util.AttributeSet;
import android.util.MathUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityManager;
import android.widget.CalendarView;
import android.widget.DayPickerPagerAdapter;
import android.widget.ImageButton;
import android.widget.SimpleMonthView;
import com.android.internal.R;
import com.android.internal.widget.ViewPager;
import java.util.Locale;
import libcore.icu.LocaleData;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DayPickerView
extends ViewGroup
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int DEFAULT_LAYOUT = 17367121;
    private static int DEFAULT_START_YEAR = 1900;
    private static int DEFAULT_END_YEAR = 2100;
    private static int[] ATTRS_TEXT_COLOR;
    private Calendar mSelectedDay;
    private Calendar mMinDate;
    private Calendar mMaxDate;
    private AccessibilityManager mAccessibilityManager;
    private ViewPager mViewPager;
    private ImageButton mPrevButton;
    private ImageButton mNextButton;
    private DayPickerPagerAdapter mAdapter;
    private Calendar mTempCalendar;
    private OnDaySelectedListener mOnDaySelectedListener;
    private ViewPager.OnPageChangeListener mOnPageChangedListener;
    private View.OnClickListener mOnClickListener;

    private void $$robo$$android_widget_DayPickerView$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_DayPickerView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_DayPickerView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_DayPickerView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        long maxDateMillis;
        Calendar tempDate;
        this.mSelectedDay = Calendar.getInstance();
        this.mMinDate = Calendar.getInstance();
        this.mMaxDate = Calendar.getInstance();
        this.mOnPageChangedListener = new ViewPager.OnPageChangeListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ DayPickerView this$0;

            private void $$robo$$android_widget_DayPickerView_2$__constructor__(DayPickerView this$0) {
            }

            private final void $$robo$$android_widget_DayPickerView_2$onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                float alpha = Math.abs(0.5f - positionOffset) * 2.0f;
                this.this$0.mPrevButton.setAlpha(alpha);
                this.this$0.mNextButton.setAlpha(alpha);
            }

            private final void $$robo$$android_widget_DayPickerView_2$onPageScrollStateChanged(int state) {
            }

            private final void $$robo$$android_widget_DayPickerView_2$onPageSelected(int position) {
                this.this$0.updateButtonVisibility(position);
            }

            private void __constructor__(DayPickerView dayPickerView) {
                this.$$robo$$android_widget_DayPickerView_2$__constructor__(dayPickerView);
            }
            {
                this.this$0 = dayPickerView;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DayPickerView_2$__constructor__(android.widget.DayPickerView ), 0, this, dayPickerView);
            }

            @Override
            public void onPageScrolled(int n, float f, int n2) {
                InvokeDynamicSupport.bootstrap("onPageScrolled", $$robo$$android_widget_DayPickerView_2$onPageScrolled(int float int ), 0, this, n, f, n2);
            }

            @Override
            public void onPageScrollStateChanged(int n) {
                InvokeDynamicSupport.bootstrap("onPageScrollStateChanged", $$robo$$android_widget_DayPickerView_2$onPageScrollStateChanged(int ), 0, this, n);
            }

            @Override
            public void onPageSelected(int n) {
                InvokeDynamicSupport.bootstrap("onPageSelected", $$robo$$android_widget_DayPickerView_2$onPageSelected(int ), 0, this, n);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mOnClickListener = new View.OnClickListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ DayPickerView this$0;

            private void $$robo$$android_widget_DayPickerView_3$__constructor__(DayPickerView this$0) {
            }

            private final void $$robo$$android_widget_DayPickerView_3$onClick(View v) {
                int direction;
                if (v == this.this$0.mPrevButton) {
                    direction = -1;
                } else if (v == this.this$0.mNextButton) {
                    direction = 1;
                } else {
                    return;
                }
                boolean animate = !this.this$0.mAccessibilityManager.isEnabled();
                int nextItem = this.this$0.mViewPager.getCurrentItem() + direction;
                this.this$0.mViewPager.setCurrentItem(nextItem, animate);
            }

            private void __constructor__(DayPickerView dayPickerView) {
                this.$$robo$$android_widget_DayPickerView_3$__constructor__(dayPickerView);
            }
            {
                this.this$0 = dayPickerView;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DayPickerView_3$__constructor__(android.widget.DayPickerView ), 0, this, dayPickerView);
            }

            @Override
            public void onClick(View view) {
                InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_DayPickerView_3$onClick(android.view.View ), 0, this, view);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mAccessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CalendarView, defStyleAttr, defStyleRes);
        int firstDayOfWeek = a.getInt(0, LocaleData.get((Locale)Locale.getDefault()).firstDayOfWeek);
        String minDate = a.getString(2);
        String maxDate = a.getString(3);
        int monthTextAppearanceResId = a.getResourceId(16, 16974746);
        int dayOfWeekTextAppearanceResId = a.getResourceId(11, 16974745);
        int dayTextAppearanceResId = a.getResourceId(12, 16974744);
        ColorStateList daySelectorColor = a.getColorStateList(15);
        a.recycle();
        this.mAdapter = new DayPickerPagerAdapter(context, 17367119, 16909060);
        this.mAdapter.setMonthTextAppearance(monthTextAppearanceResId);
        this.mAdapter.setDayOfWeekTextAppearance(dayOfWeekTextAppearanceResId);
        this.mAdapter.setDayTextAppearance(dayTextAppearanceResId);
        this.mAdapter.setDaySelectorColor(daySelectorColor);
        LayoutInflater inflater = LayoutInflater.from(context);
        ViewGroup content = (ViewGroup)inflater.inflate(17367121, (ViewGroup)this, false);
        while (content.getChildCount() > 0) {
            View child = content.getChildAt(0);
            content.removeViewAt(0);
            this.addView(child);
        }
        this.mPrevButton = (ImageButton)this.findViewById(16909171);
        this.mPrevButton.setOnClickListener(this.mOnClickListener);
        this.mNextButton = (ImageButton)this.findViewById(16909075);
        this.mNextButton.setOnClickListener(this.mOnClickListener);
        this.mViewPager = (ViewPager)this.findViewById(16908821);
        this.mViewPager.setAdapter(this.mAdapter);
        this.mViewPager.setOnPageChangeListener(this.mOnPageChangedListener);
        if (monthTextAppearanceResId != 0) {
            TypedArray ta = this.mContext.obtainStyledAttributes(null, ATTRS_TEXT_COLOR, 0, monthTextAppearanceResId);
            ColorStateList monthColor = ta.getColorStateList(0);
            if (monthColor != null) {
                this.mPrevButton.setImageTintList(monthColor);
                this.mNextButton.setImageTintList(monthColor);
            }
            ta.recycle();
        }
        if (!CalendarView.parseDate(minDate, tempDate = Calendar.getInstance())) {
            tempDate.set(1900, 0, 1);
        }
        long minDateMillis = tempDate.getTimeInMillis();
        if (!CalendarView.parseDate(maxDate, tempDate)) {
            tempDate.set(2100, 11, 31);
        }
        if ((maxDateMillis = tempDate.getTimeInMillis()) < minDateMillis) {
            throw new IllegalArgumentException("maxDate must be >= minDate");
        }
        long setDateMillis = MathUtils.constrain((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"), minDateMillis, maxDateMillis);
        this.setFirstDayOfWeek(firstDayOfWeek);
        this.setMinDate(minDateMillis);
        this.setMaxDate(maxDateMillis);
        this.setDate(setDateMillis, false);
        this.mAdapter.setOnDaySelectedListener(new DayPickerPagerAdapter.OnDaySelectedListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ DayPickerView this$0;

            private void $$robo$$android_widget_DayPickerView_1$__constructor__(DayPickerView this$0) {
            }

            private final void $$robo$$android_widget_DayPickerView_1$onDaySelected(DayPickerPagerAdapter adapter, Calendar day) {
                if (this.this$0.mOnDaySelectedListener != null) {
                    this.this$0.mOnDaySelectedListener.onDaySelected(this.this$0, day);
                }
            }

            private void __constructor__(DayPickerView dayPickerView) {
                this.$$robo$$android_widget_DayPickerView_1$__constructor__(dayPickerView);
            }
            {
                this.this$0 = dayPickerView;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DayPickerView_1$__constructor__(android.widget.DayPickerView ), 0, this, dayPickerView);
            }

            @Override
            public void onDaySelected(DayPickerPagerAdapter dayPickerPagerAdapter, Calendar calendar) {
                InvokeDynamicSupport.bootstrap("onDaySelected", $$robo$$android_widget_DayPickerView_1$onDaySelected(android.widget.DayPickerPagerAdapter android.icu.util.Calendar ), 0, this, dayPickerPagerAdapter, calendar);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_widget_DayPickerView$updateButtonVisibility(int position) {
        boolean hasPrev = position > 0;
        boolean hasNext = position < this.mAdapter.getCount() - 1;
        this.mPrevButton.setVisibility(hasPrev ? 0 : 4);
        this.mNextButton.setVisibility(hasNext ? 0 : 4);
    }

    private final void $$robo$$android_widget_DayPickerView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        ViewPager viewPager = this.mViewPager;
        this.measureChild(viewPager, widthMeasureSpec, heightMeasureSpec);
        int measuredWidthAndState = viewPager.getMeasuredWidthAndState();
        int measuredHeightAndState = viewPager.getMeasuredHeightAndState();
        this.setMeasuredDimension(measuredWidthAndState, measuredHeightAndState);
        int pagerWidth = viewPager.getMeasuredWidth();
        int pagerHeight = viewPager.getMeasuredHeight();
        int buttonWidthSpec = View.MeasureSpec.makeMeasureSpec(pagerWidth, Integer.MIN_VALUE);
        int buttonHeightSpec = View.MeasureSpec.makeMeasureSpec(pagerHeight, Integer.MIN_VALUE);
        this.mPrevButton.measure(buttonWidthSpec, buttonHeightSpec);
        this.mNextButton.measure(buttonWidthSpec, buttonHeightSpec);
    }

    private final void $$robo$$android_widget_DayPickerView$onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        this.requestLayout();
    }

    private final void $$robo$$android_widget_DayPickerView$onLayout(boolean changed, int left, int top, int right, int bottom) {
        ImageButton rightButton;
        ImageButton leftButton;
        if (this.isLayoutRtl()) {
            leftButton = this.mNextButton;
            rightButton = this.mPrevButton;
        } else {
            leftButton = this.mPrevButton;
            rightButton = this.mNextButton;
        }
        int width = right - left;
        int height = bottom - top;
        this.mViewPager.layout(0, 0, width, height);
        SimpleMonthView monthView = (SimpleMonthView)this.mViewPager.getChildAt(0);
        int monthHeight = monthView.getMonthHeight();
        int cellWidth = monthView.getCellWidth();
        int leftDW = leftButton.getMeasuredWidth();
        int leftDH = leftButton.getMeasuredHeight();
        int leftIconTop = monthView.getPaddingTop() + (monthHeight - leftDH) / 2;
        int leftIconLeft = monthView.getPaddingLeft() + (cellWidth - leftDW) / 2;
        leftButton.layout(leftIconLeft, leftIconTop, leftIconLeft + leftDW, leftIconTop + leftDH);
        int rightDW = rightButton.getMeasuredWidth();
        int rightDH = rightButton.getMeasuredHeight();
        int rightIconTop = monthView.getPaddingTop() + (monthHeight - rightDH) / 2;
        int rightIconRight = width - monthView.getPaddingRight() - (cellWidth - rightDW) / 2;
        rightButton.layout(rightIconRight - rightDW, rightIconTop, rightIconRight, rightIconTop + rightDH);
    }

    private final void $$robo$$android_widget_DayPickerView$setDayOfWeekTextAppearance(int resId) {
        this.mAdapter.setDayOfWeekTextAppearance(resId);
    }

    private final int $$robo$$android_widget_DayPickerView$getDayOfWeekTextAppearance() {
        return this.mAdapter.getDayOfWeekTextAppearance();
    }

    private final void $$robo$$android_widget_DayPickerView$setDayTextAppearance(int resId) {
        this.mAdapter.setDayTextAppearance(resId);
    }

    private final int $$robo$$android_widget_DayPickerView$getDayTextAppearance() {
        return this.mAdapter.getDayTextAppearance();
    }

    private final void $$robo$$android_widget_DayPickerView$setDate(long timeInMillis) {
        this.setDate(timeInMillis, false);
    }

    private final void $$robo$$android_widget_DayPickerView$setDate(long timeInMillis, boolean animate) {
        this.setDate(timeInMillis, animate, true);
    }

    private final void $$robo$$android_widget_DayPickerView$setDate(long timeInMillis, boolean animate, boolean setSelected) {
        int position;
        boolean dateClamped = false;
        if (timeInMillis < this.mMinDate.getTimeInMillis()) {
            timeInMillis = this.mMinDate.getTimeInMillis();
            dateClamped = true;
        } else if (timeInMillis > this.mMaxDate.getTimeInMillis()) {
            timeInMillis = this.mMaxDate.getTimeInMillis();
            dateClamped = true;
        }
        this.getTempCalendarForTime(timeInMillis);
        if (setSelected || dateClamped) {
            this.mSelectedDay.setTimeInMillis(timeInMillis);
        }
        if ((position = this.getPositionFromDay(timeInMillis)) != this.mViewPager.getCurrentItem()) {
            this.mViewPager.setCurrentItem(position, animate);
        }
        this.mAdapter.setSelectedDay(this.mTempCalendar);
    }

    private final long $$robo$$android_widget_DayPickerView$getDate() {
        return this.mSelectedDay.getTimeInMillis();
    }

    private final boolean $$robo$$android_widget_DayPickerView$getBoundsForDate(long timeInMillis, Rect outBounds) {
        int position = this.getPositionFromDay(timeInMillis);
        if (position != this.mViewPager.getCurrentItem()) {
            return false;
        }
        this.mTempCalendar.setTimeInMillis(timeInMillis);
        return this.mAdapter.getBoundsForDate(this.mTempCalendar, outBounds);
    }

    private final void $$robo$$android_widget_DayPickerView$setFirstDayOfWeek(int firstDayOfWeek) {
        this.mAdapter.setFirstDayOfWeek(firstDayOfWeek);
    }

    private final int $$robo$$android_widget_DayPickerView$getFirstDayOfWeek() {
        return this.mAdapter.getFirstDayOfWeek();
    }

    private final void $$robo$$android_widget_DayPickerView$setMinDate(long timeInMillis) {
        this.mMinDate.setTimeInMillis(timeInMillis);
        this.onRangeChanged();
    }

    private final long $$robo$$android_widget_DayPickerView$getMinDate() {
        return this.mMinDate.getTimeInMillis();
    }

    private final void $$robo$$android_widget_DayPickerView$setMaxDate(long timeInMillis) {
        this.mMaxDate.setTimeInMillis(timeInMillis);
        this.onRangeChanged();
    }

    private final long $$robo$$android_widget_DayPickerView$getMaxDate() {
        return this.mMaxDate.getTimeInMillis();
    }

    private final void $$robo$$android_widget_DayPickerView$onRangeChanged() {
        this.mAdapter.setRange(this.mMinDate, this.mMaxDate);
        this.setDate(this.mSelectedDay.getTimeInMillis(), false, false);
        this.updateButtonVisibility(this.mViewPager.getCurrentItem());
    }

    private final void $$robo$$android_widget_DayPickerView$setOnDaySelectedListener(OnDaySelectedListener listener) {
        this.mOnDaySelectedListener = listener;
    }

    private final int $$robo$$android_widget_DayPickerView$getDiffMonths(Calendar start, Calendar end) {
        int diffYears = end.get(1) - start.get(1);
        return end.get(2) - start.get(2) + 12 * diffYears;
    }

    private final int $$robo$$android_widget_DayPickerView$getPositionFromDay(long timeInMillis) {
        int diffMonthMax = this.getDiffMonths(this.mMinDate, this.mMaxDate);
        int diffMonth = this.getDiffMonths(this.mMinDate, this.getTempCalendarForTime(timeInMillis));
        return MathUtils.constrain(diffMonth, 0, diffMonthMax);
    }

    private final Calendar $$robo$$android_widget_DayPickerView$getTempCalendarForTime(long timeInMillis) {
        if (this.mTempCalendar == null) {
            this.mTempCalendar = Calendar.getInstance();
        }
        this.mTempCalendar.setTimeInMillis(timeInMillis);
        return this.mTempCalendar;
    }

    private final int $$robo$$android_widget_DayPickerView$getMostVisiblePosition() {
        return this.mViewPager.getCurrentItem();
    }

    private final void $$robo$$android_widget_DayPickerView$setPosition(int position) {
        this.mViewPager.setCurrentItem(position, false);
    }

    static void __staticInitializer__() {
        ATTRS_TEXT_COLOR = new int[]{16842904};
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_DayPickerView$__constructor__(context);
    }

    public DayPickerView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DayPickerView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_DayPickerView$__constructor__(context, attributeSet);
    }

    public DayPickerView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843613);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DayPickerView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_DayPickerView$__constructor__(context, attributeSet, n);
    }

    public DayPickerView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DayPickerView$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_DayPickerView$__constructor__(context, attributeSet, n, n2);
    }

    public DayPickerView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DayPickerView$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    private void updateButtonVisibility(int n) {
        InvokeDynamicSupport.bootstrap("updateButtonVisibility", $$robo$$android_widget_DayPickerView$updateButtonVisibility(int ), 0, this, n);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_DayPickerView$onMeasure(int int ), 0, this, n, n2);
    }

    @Override
    public void onRtlPropertiesChanged(int n) {
        InvokeDynamicSupport.bootstrap("onRtlPropertiesChanged", $$robo$$android_widget_DayPickerView$onRtlPropertiesChanged(int ), 0, this, n);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_widget_DayPickerView$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    public void setDayOfWeekTextAppearance(int n) {
        InvokeDynamicSupport.bootstrap("setDayOfWeekTextAppearance", $$robo$$android_widget_DayPickerView$setDayOfWeekTextAppearance(int ), 0, this, n);
    }

    public int getDayOfWeekTextAppearance() {
        return (int)InvokeDynamicSupport.bootstrap("getDayOfWeekTextAppearance", $$robo$$android_widget_DayPickerView$getDayOfWeekTextAppearance(), 0, this);
    }

    public void setDayTextAppearance(int n) {
        InvokeDynamicSupport.bootstrap("setDayTextAppearance", $$robo$$android_widget_DayPickerView$setDayTextAppearance(int ), 0, this, n);
    }

    public int getDayTextAppearance() {
        return (int)InvokeDynamicSupport.bootstrap("getDayTextAppearance", $$robo$$android_widget_DayPickerView$getDayTextAppearance(), 0, this);
    }

    public void setDate(long l) {
        InvokeDynamicSupport.bootstrap("setDate", $$robo$$android_widget_DayPickerView$setDate(long ), 0, this, l);
    }

    public void setDate(long l, boolean bl) {
        InvokeDynamicSupport.bootstrap("setDate", $$robo$$android_widget_DayPickerView$setDate(long boolean ), 0, this, l, bl);
    }

    private void setDate(long l, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("setDate", $$robo$$android_widget_DayPickerView$setDate(long boolean boolean ), 0, this, l, bl, bl2);
    }

    public long getDate() {
        return (long)InvokeDynamicSupport.bootstrap("getDate", $$robo$$android_widget_DayPickerView$getDate(), 0, this);
    }

    public boolean getBoundsForDate(long l, Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("getBoundsForDate", $$robo$$android_widget_DayPickerView$getBoundsForDate(long android.graphics.Rect ), 0, this, l, rect);
    }

    public void setFirstDayOfWeek(int n) {
        InvokeDynamicSupport.bootstrap("setFirstDayOfWeek", $$robo$$android_widget_DayPickerView$setFirstDayOfWeek(int ), 0, this, n);
    }

    public int getFirstDayOfWeek() {
        return (int)InvokeDynamicSupport.bootstrap("getFirstDayOfWeek", $$robo$$android_widget_DayPickerView$getFirstDayOfWeek(), 0, this);
    }

    public void setMinDate(long l) {
        InvokeDynamicSupport.bootstrap("setMinDate", $$robo$$android_widget_DayPickerView$setMinDate(long ), 0, this, l);
    }

    public long getMinDate() {
        return (long)InvokeDynamicSupport.bootstrap("getMinDate", $$robo$$android_widget_DayPickerView$getMinDate(), 0, this);
    }

    public void setMaxDate(long l) {
        InvokeDynamicSupport.bootstrap("setMaxDate", $$robo$$android_widget_DayPickerView$setMaxDate(long ), 0, this, l);
    }

    public long getMaxDate() {
        return (long)InvokeDynamicSupport.bootstrap("getMaxDate", $$robo$$android_widget_DayPickerView$getMaxDate(), 0, this);
    }

    public void onRangeChanged() {
        InvokeDynamicSupport.bootstrap("onRangeChanged", $$robo$$android_widget_DayPickerView$onRangeChanged(), 0, this);
    }

    public void setOnDaySelectedListener(OnDaySelectedListener onDaySelectedListener) {
        InvokeDynamicSupport.bootstrap("setOnDaySelectedListener", $$robo$$android_widget_DayPickerView$setOnDaySelectedListener(android.widget.DayPickerView$OnDaySelectedListener ), 0, this, onDaySelectedListener);
    }

    private int getDiffMonths(Calendar calendar, Calendar calendar2) {
        return (int)InvokeDynamicSupport.bootstrap("getDiffMonths", $$robo$$android_widget_DayPickerView$getDiffMonths(android.icu.util.Calendar android.icu.util.Calendar ), 0, this, calendar, calendar2);
    }

    private int getPositionFromDay(long l) {
        return (int)InvokeDynamicSupport.bootstrap("getPositionFromDay", $$robo$$android_widget_DayPickerView$getPositionFromDay(long ), 0, this, l);
    }

    private Calendar getTempCalendarForTime(long l) {
        return InvokeDynamicSupport.bootstrap("getTempCalendarForTime", $$robo$$android_widget_DayPickerView$getTempCalendarForTime(long ), 0, this, l);
    }

    public int getMostVisiblePosition() {
        return (int)InvokeDynamicSupport.bootstrap("getMostVisiblePosition", $$robo$$android_widget_DayPickerView$getMostVisiblePosition(), 0, this);
    }

    public void setPosition(int n) {
        InvokeDynamicSupport.bootstrap("setPosition", $$robo$$android_widget_DayPickerView$setPosition(int ), 0, this, n);
    }

    static {
        RobolectricInternals.classInitializing(DayPickerView.class);
    }

    public /* synthetic */ DayPickerView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DayPickerView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface OnDaySelectedListener
    extends InstrumentedInterface {
        public void onDaySelected(DayPickerView var1, Calendar var2);
    }
}

