/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewHierarchyEncoder;
import android.widget.RemoteViews;
import com.android.internal.R;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@RemoteViews.RemoteView
public class FrameLayout
extends ViewGroup
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int DEFAULT_CHILD_GRAVITY = 0x800033;
    @ViewDebug.ExportedProperty(category="measurement")
    boolean mMeasureAllChildren;
    @ViewDebug.ExportedProperty(category="padding")
    private int mForegroundPaddingLeft;
    @ViewDebug.ExportedProperty(category="padding")
    private int mForegroundPaddingTop;
    @ViewDebug.ExportedProperty(category="padding")
    private int mForegroundPaddingRight;
    @ViewDebug.ExportedProperty(category="padding")
    private int mForegroundPaddingBottom;
    private ArrayList<View> mMatchParentChildren;

    private void $$robo$$android_widget_FrameLayout$__constructor__(Context context) {
        this.mMeasureAllChildren = false;
        this.mForegroundPaddingLeft = 0;
        this.mForegroundPaddingTop = 0;
        this.mForegroundPaddingRight = 0;
        this.mForegroundPaddingBottom = 0;
        this.mMatchParentChildren = new ArrayList(1);
    }

    private void $$robo$$android_widget_FrameLayout$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_FrameLayout$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_FrameLayout$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mMeasureAllChildren = false;
        this.mForegroundPaddingLeft = 0;
        this.mForegroundPaddingTop = 0;
        this.mForegroundPaddingRight = 0;
        this.mForegroundPaddingBottom = 0;
        this.mMatchParentChildren = new ArrayList(1);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FrameLayout, defStyleAttr, defStyleRes);
        if (a.getBoolean(0, false)) {
            this.setMeasureAllChildren(true);
        }
        a.recycle();
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_FrameLayout$setForegroundGravity(int foregroundGravity) {
        if (this.getForegroundGravity() != foregroundGravity) {
            super.setForegroundGravity(foregroundGravity);
            Drawable foreground = this.getForeground();
            if (this.getForegroundGravity() == 119 && foreground != null) {
                Rect padding = new Rect();
                if (foreground.getPadding(padding)) {
                    this.mForegroundPaddingLeft = padding.left;
                    this.mForegroundPaddingTop = padding.top;
                    this.mForegroundPaddingRight = padding.right;
                    this.mForegroundPaddingBottom = padding.bottom;
                }
            } else {
                this.mForegroundPaddingLeft = 0;
                this.mForegroundPaddingTop = 0;
                this.mForegroundPaddingRight = 0;
                this.mForegroundPaddingBottom = 0;
            }
            this.requestLayout();
        }
    }

    private final LayoutParams $$robo$$android_widget_FrameLayout$generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    private final int $$robo$$android_widget_FrameLayout$getPaddingLeftWithForeground() {
        return this.isForegroundInsidePadding() ? Math.max(this.mPaddingLeft, this.mForegroundPaddingLeft) : this.mPaddingLeft + this.mForegroundPaddingLeft;
    }

    private final int $$robo$$android_widget_FrameLayout$getPaddingRightWithForeground() {
        return this.isForegroundInsidePadding() ? Math.max(this.mPaddingRight, this.mForegroundPaddingRight) : this.mPaddingRight + this.mForegroundPaddingRight;
    }

    private final int $$robo$$android_widget_FrameLayout$getPaddingTopWithForeground() {
        return this.isForegroundInsidePadding() ? Math.max(this.mPaddingTop, this.mForegroundPaddingTop) : this.mPaddingTop + this.mForegroundPaddingTop;
    }

    private final int $$robo$$android_widget_FrameLayout$getPaddingBottomWithForeground() {
        return this.isForegroundInsidePadding() ? Math.max(this.mPaddingBottom, this.mForegroundPaddingBottom) : this.mPaddingBottom + this.mForegroundPaddingBottom;
    }

    private final void $$robo$$android_widget_FrameLayout$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int count = this.getChildCount();
        boolean measureMatchParentChildren = View.MeasureSpec.getMode(widthMeasureSpec) != 0x40000000 || View.MeasureSpec.getMode(heightMeasureSpec) != 0x40000000;
        this.mMatchParentChildren.clear();
        int maxHeight = 0;
        int maxWidth = 0;
        int childState = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!this.mMeasureAllChildren && child.getVisibility() == 8) continue;
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
            maxHeight = Math.max(maxHeight, child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
            childState = FrameLayout.combineMeasuredStates(childState, child.getMeasuredState());
            if (!measureMatchParentChildren || lp.width != -1 && lp.height != -1) continue;
            this.mMatchParentChildren.add(child);
        }
        maxWidth += this.getPaddingLeftWithForeground() + this.getPaddingRightWithForeground();
        maxHeight += this.getPaddingTopWithForeground() + this.getPaddingBottomWithForeground();
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        Drawable drawable2 = this.getForeground();
        if (drawable2 != null) {
            maxHeight = Math.max(maxHeight, drawable2.getMinimumHeight());
            maxWidth = Math.max(maxWidth, drawable2.getMinimumWidth());
        }
        this.setMeasuredDimension(FrameLayout.resolveSizeAndState(maxWidth, widthMeasureSpec, childState), FrameLayout.resolveSizeAndState(maxHeight, heightMeasureSpec, childState << 16));
        count = this.mMatchParentChildren.size();
        if (count > 1) {
            for (int i = 0; i < count; ++i) {
                int childHeightMeasureSpec;
                int childWidthMeasureSpec;
                View child = this.mMatchParentChildren.get(i);
                ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
                if (lp.width == -1) {
                    int width = Math.max(0, this.getMeasuredWidth() - this.getPaddingLeftWithForeground() - this.getPaddingRightWithForeground() - lp.leftMargin - lp.rightMargin);
                    childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec(width, 0x40000000);
                } else {
                    childWidthMeasureSpec = FrameLayout.getChildMeasureSpec(widthMeasureSpec, this.getPaddingLeftWithForeground() + this.getPaddingRightWithForeground() + lp.leftMargin + lp.rightMargin, lp.width);
                }
                if (lp.height == -1) {
                    int height = Math.max(0, this.getMeasuredHeight() - this.getPaddingTopWithForeground() - this.getPaddingBottomWithForeground() - lp.topMargin - lp.bottomMargin);
                    childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec(height, 0x40000000);
                } else {
                    childHeightMeasureSpec = FrameLayout.getChildMeasureSpec(heightMeasureSpec, this.getPaddingTopWithForeground() + this.getPaddingBottomWithForeground() + lp.topMargin + lp.bottomMargin, lp.height);
                }
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            }
        }
    }

    private final void $$robo$$android_widget_FrameLayout$onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.layoutChildren(left, top, right, bottom, false);
    }

    private final void $$robo$$android_widget_FrameLayout$layoutChildren(int left, int top, int right, int bottom, boolean forceLeftGravity) {
        int count = this.getChildCount();
        int parentLeft = this.getPaddingLeftWithForeground();
        int parentRight = right - left - this.getPaddingRightWithForeground();
        int parentTop = this.getPaddingTopWithForeground();
        int parentBottom = bottom - top - this.getPaddingBottomWithForeground();
        for (int i = 0; i < count; ++i) {
            int childTop;
            int childLeft;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            int gravity = lp.gravity;
            if (gravity == -1) {
                gravity = 0x800033;
            }
            int layoutDirection = this.getLayoutDirection();
            int absoluteGravity = Gravity.getAbsoluteGravity(gravity, layoutDirection);
            int verticalGravity = gravity & 0x70;
            switch (absoluteGravity & 7) {
                case 1: {
                    childLeft = parentLeft + (parentRight - parentLeft - width) / 2 + lp.leftMargin - lp.rightMargin;
                    break;
                }
                case 5: {
                    if (!forceLeftGravity) {
                        childLeft = parentRight - width - lp.rightMargin;
                        break;
                    }
                }
                default: {
                    childLeft = parentLeft + lp.leftMargin;
                }
            }
            switch (verticalGravity) {
                case 48: {
                    childTop = parentTop + lp.topMargin;
                    break;
                }
                case 16: {
                    childTop = parentTop + (parentBottom - parentTop - height) / 2 + lp.topMargin - lp.bottomMargin;
                    break;
                }
                case 80: {
                    childTop = parentBottom - height - lp.bottomMargin;
                    break;
                }
                default: {
                    childTop = parentTop + lp.topMargin;
                }
            }
            child.layout(childLeft, childTop, childLeft + width, childTop + height);
        }
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_FrameLayout$setMeasureAllChildren(boolean measureAll) {
        this.mMeasureAllChildren = measureAll;
    }

    @Deprecated
    private final boolean $$robo$$android_widget_FrameLayout$getConsiderGoneChildrenWhenMeasuring() {
        return this.getMeasureAllChildren();
    }

    private final boolean $$robo$$android_widget_FrameLayout$getMeasureAllChildren() {
        return this.mMeasureAllChildren;
    }

    private final LayoutParams $$robo$$android_widget_FrameLayout$generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    private final boolean $$robo$$android_widget_FrameLayout$shouldDelayChildPressedState() {
        return false;
    }

    private final boolean $$robo$$android_widget_FrameLayout$checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    private final ViewGroup.LayoutParams $$robo$$android_widget_FrameLayout$generateLayoutParams(ViewGroup.LayoutParams lp) {
        if (sPreserveMarginParamsInLayoutParamConversion) {
            if (lp instanceof LayoutParams) {
                return new LayoutParams((LayoutParams)lp);
            }
            if (lp instanceof ViewGroup.MarginLayoutParams) {
                return new LayoutParams((ViewGroup.MarginLayoutParams)lp);
            }
        }
        return new LayoutParams(lp);
    }

    private final CharSequence $$robo$$android_widget_FrameLayout$getAccessibilityClassName() {
        return FrameLayout.class.getName();
    }

    private final void $$robo$$android_widget_FrameLayout$encodeProperties(ViewHierarchyEncoder encoder) {
        super.encodeProperties(encoder);
        encoder.addProperty("measurement:measureAllChildren", this.mMeasureAllChildren);
        encoder.addProperty("padding:foregroundPaddingLeft", this.mForegroundPaddingLeft);
        encoder.addProperty("padding:foregroundPaddingTop", this.mForegroundPaddingTop);
        encoder.addProperty("padding:foregroundPaddingRight", this.mForegroundPaddingRight);
        encoder.addProperty("padding:foregroundPaddingBottom", this.mForegroundPaddingBottom);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_FrameLayout$__constructor__(context);
    }

    public FrameLayout(Context context) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_FrameLayout$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_FrameLayout$__constructor__(context, attributeSet);
    }

    public FrameLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_FrameLayout$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_FrameLayout$__constructor__(context, attributeSet, n);
    }

    public FrameLayout(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_FrameLayout$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_FrameLayout$__constructor__(context, attributeSet, n, n2);
    }

    public FrameLayout(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_FrameLayout$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    @Override
    @RemotableViewMethod
    public void setForegroundGravity(int n) {
        InvokeDynamicSupport.bootstrap("setForegroundGravity", $$robo$$android_widget_FrameLayout$setForegroundGravity(int ), 0, this, n);
    }

    @Override
    protected LayoutParams generateDefaultLayoutParams() {
        return InvokeDynamicSupport.bootstrap("generateDefaultLayoutParams", $$robo$$android_widget_FrameLayout$generateDefaultLayoutParams(), 0, this);
    }

    int getPaddingLeftWithForeground() {
        return (int)InvokeDynamicSupport.bootstrap("getPaddingLeftWithForeground", $$robo$$android_widget_FrameLayout$getPaddingLeftWithForeground(), 0, this);
    }

    int getPaddingRightWithForeground() {
        return (int)InvokeDynamicSupport.bootstrap("getPaddingRightWithForeground", $$robo$$android_widget_FrameLayout$getPaddingRightWithForeground(), 0, this);
    }

    private int getPaddingTopWithForeground() {
        return (int)InvokeDynamicSupport.bootstrap("getPaddingTopWithForeground", $$robo$$android_widget_FrameLayout$getPaddingTopWithForeground(), 0, this);
    }

    private int getPaddingBottomWithForeground() {
        return (int)InvokeDynamicSupport.bootstrap("getPaddingBottomWithForeground", $$robo$$android_widget_FrameLayout$getPaddingBottomWithForeground(), 0, this);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_FrameLayout$onMeasure(int int ), 0, this, n, n2);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_widget_FrameLayout$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    void layoutChildren(int n, int n2, int n3, int n4, boolean bl) {
        InvokeDynamicSupport.bootstrap("layoutChildren", $$robo$$android_widget_FrameLayout$layoutChildren(int int int int boolean ), 0, this, n, n2, n3, n4, bl);
    }

    @RemotableViewMethod
    public void setMeasureAllChildren(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMeasureAllChildren", $$robo$$android_widget_FrameLayout$setMeasureAllChildren(boolean ), 0, this, bl);
    }

    @Deprecated
    public boolean getConsiderGoneChildrenWhenMeasuring() {
        return (boolean)InvokeDynamicSupport.bootstrap("getConsiderGoneChildrenWhenMeasuring", $$robo$$android_widget_FrameLayout$getConsiderGoneChildrenWhenMeasuring(), 0, this);
    }

    public boolean getMeasureAllChildren() {
        return (boolean)InvokeDynamicSupport.bootstrap("getMeasureAllChildren", $$robo$$android_widget_FrameLayout$getMeasureAllChildren(), 0, this);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$android_widget_FrameLayout$generateLayoutParams(android.util.AttributeSet ), 0, this, attributeSet);
    }

    @Override
    public boolean shouldDelayChildPressedState() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldDelayChildPressedState", $$robo$$android_widget_FrameLayout$shouldDelayChildPressedState(), 0, this);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkLayoutParams", $$robo$$android_widget_FrameLayout$checkLayoutParams(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
    }

    @Override
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$android_widget_FrameLayout$generateLayoutParams(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_widget_FrameLayout$getAccessibilityClassName(), 0, this);
    }

    @Override
    protected void encodeProperties(ViewHierarchyEncoder viewHierarchyEncoder) {
        InvokeDynamicSupport.bootstrap("encodeProperties", $$robo$$android_widget_FrameLayout$encodeProperties(android.view.ViewHierarchyEncoder ), 0, this, viewHierarchyEncoder);
    }

    public /* synthetic */ FrameLayout() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FrameLayout)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int UNSPECIFIED_GRAVITY = -1;
        public int gravity;

        private void $$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(Context c, AttributeSet attrs) {
            this.gravity = -1;
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.FrameLayout_Layout);
            this.gravity = a.getInt(0, -1);
            a.recycle();
        }

        private void $$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(int width, int height) {
            this.gravity = -1;
        }

        private void $$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(int width, int height, int gravity) {
            this.gravity = -1;
            this.gravity = gravity;
        }

        private void $$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(ViewGroup.LayoutParams source) {
            this.gravity = -1;
        }

        private void $$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(ViewGroup.MarginLayoutParams source) {
            this.gravity = -1;
        }

        private void $$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(LayoutParams source) {
            this.gravity = -1;
            this.gravity = source.gravity;
        }

        private void __constructor__(Context context, AttributeSet attributeSet) {
            this.$$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(context, attributeSet);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(n, n2);
        }

        public LayoutParams(int n, int n2) {
            super(n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(int int ), 0, this, n, n2);
        }

        private void __constructor__(int n, int n2, int n3) {
            this.$$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(n, n2, n3);
        }

        public LayoutParams(int n, int n2, int n3) {
            super(n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(int int int ), 0, this, n, n2, n3);
        }

        private void __constructor__(ViewGroup.LayoutParams layoutParams) {
            this.$$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(layoutParams);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
        }

        private void __constructor__(ViewGroup.MarginLayoutParams marginLayoutParams) {
            this.$$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(marginLayoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(android.view.ViewGroup$MarginLayoutParams ), 0, this, marginLayoutParams);
        }

        private void __constructor__(LayoutParams layoutParams) {
            this.$$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(layoutParams);
        }

        public LayoutParams(LayoutParams layoutParams) {
            super(layoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(android.widget.FrameLayout$LayoutParams ), 0, this, layoutParams);
        }

        public /* synthetic */ LayoutParams() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayoutParams)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

