/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.os.AsyncTask;
import android.os.LocaleList;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.util.Log;
import android.view.ActionMode;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextSelection;
import android.view.textclassifier.logging.SmartSelectionEventTracker;
import android.widget.Editor;
import android.widget.TextView;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.text.BreakIterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class SelectionActionModeHelper
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "SelectActionModeHelper";
    private Editor mEditor;
    private TextView mTextView;
    private TextClassificationHelper mTextClassificationHelper;
    private TextClassification mTextClassification;
    private AsyncTask mTextClassificationAsyncTask;
    private SelectionTracker mSelectionTracker;

    private void $$robo$$android_widget_SelectionActionModeHelper$__constructor__(Editor editor) {
        this.mEditor = Preconditions.checkNotNull(editor);
        this.mTextView = this.mEditor.getTextView();
        this.mTextClassificationHelper = new TextClassificationHelper(this.mTextView.getTextClassifier(), SelectionActionModeHelper.getText(this.mTextView), 0, 1, this.mTextView.getTextLocales());
        this.mSelectionTracker = new SelectionTracker(this.mTextView);
    }

    private final void $$robo$$android_widget_SelectionActionModeHelper$startActionModeAsync(boolean adjustSelection) {
        adjustSelection &= !this.mTextView.isTextEditable() || this.mTextView.getTextClassifier().getSettings().isSuggestSelectionEnabledForEditableText();
        this.mSelectionTracker.onOriginalSelection(SelectionActionModeHelper.getText(this.mTextView), this.mTextView.getSelectionStart(), this.mTextView.getSelectionEnd());
        this.cancelAsyncTask();
        if (this.skipTextClassification()) {
            this.startActionMode(null);
        } else {
            this.resetTextClassificationHelper();
            this.mTextClassificationAsyncTask = new TextClassificationAsyncTask(this.mTextView, this.mTextClassificationHelper.getTimeoutDuration(), adjustSelection ? this.mTextClassificationHelper::suggestSelection : this.mTextClassificationHelper::classifyText, this::startActionMode).execute(new Void[0]);
        }
    }

    private final void $$robo$$android_widget_SelectionActionModeHelper$invalidateActionModeAsync() {
        this.cancelAsyncTask();
        if (this.skipTextClassification()) {
            this.invalidateActionMode(null);
        } else {
            this.resetTextClassificationHelper();
            this.mTextClassificationAsyncTask = new TextClassificationAsyncTask(this.mTextView, this.mTextClassificationHelper.getTimeoutDuration(), this.mTextClassificationHelper::classifyText, this::invalidateActionMode).execute(new Void[0]);
        }
    }

    private final void $$robo$$android_widget_SelectionActionModeHelper$onSelectionAction(int menuItemId) {
        this.mSelectionTracker.onSelectionAction(this.mTextView.getSelectionStart(), this.mTextView.getSelectionEnd(), SelectionActionModeHelper.getActionType(menuItemId), this.mTextClassification);
    }

    private final void $$robo$$android_widget_SelectionActionModeHelper$onSelectionDrag() {
        this.mSelectionTracker.onSelectionAction(this.mTextView.getSelectionStart(), this.mTextView.getSelectionEnd(), 106, this.mTextClassification);
    }

    private final void $$robo$$android_widget_SelectionActionModeHelper$onTextChanged(int start, int end) {
        this.mSelectionTracker.onTextChanged(start, end, this.mTextClassification);
    }

    private final boolean $$robo$$android_widget_SelectionActionModeHelper$resetSelection(int textIndex) {
        if (this.mSelectionTracker.resetSelection(textIndex, this.mEditor)) {
            this.invalidateActionModeAsync();
            return true;
        }
        return false;
    }

    private final TextClassification $$robo$$android_widget_SelectionActionModeHelper$getTextClassification() {
        return this.mTextClassification;
    }

    private final void $$robo$$android_widget_SelectionActionModeHelper$onDestroyActionMode() {
        this.mSelectionTracker.onSelectionDestroyed();
        this.cancelAsyncTask();
    }

    private final void $$robo$$android_widget_SelectionActionModeHelper$cancelAsyncTask() {
        if (this.mTextClassificationAsyncTask != null) {
            this.mTextClassificationAsyncTask.cancel(true);
            this.mTextClassificationAsyncTask = null;
        }
        this.mTextClassification = null;
    }

    private final boolean $$robo$$android_widget_SelectionActionModeHelper$skipTextClassification() {
        boolean noOpTextClassifier = this.mTextView.getTextClassifier() == TextClassifier.NO_OP;
        boolean noSelection = this.mTextView.getSelectionEnd() == this.mTextView.getSelectionStart();
        boolean password = this.mTextView.hasPasswordTransformationMethod() || TextView.isPasswordInputType(this.mTextView.getInputType());
        return noOpTextClassifier || noSelection || password;
    }

    private final void $$robo$$android_widget_SelectionActionModeHelper$startActionMode(SelectionResult result) {
        CharSequence text = SelectionActionModeHelper.getText(this.mTextView);
        if (result != null && text instanceof Spannable) {
            if (!this.mTextView.getTextClassifier().getSettings().isDarkLaunch()) {
                Selection.setSelection((Spannable)text, result.mStart, result.mEnd);
            }
            this.mTextClassification = result.mClassification;
        } else {
            this.mTextClassification = null;
        }
        if (this.mEditor.startSelectionActionModeInternal()) {
            Editor.SelectionModifierCursorController controller = this.mEditor.getSelectionController();
            if (controller != null) {
                controller.show();
            }
            if (result != null) {
                this.mSelectionTracker.onSmartSelection(result);
            }
        }
        this.mEditor.setRestartActionModeOnNextRefresh(false);
        this.mTextClassificationAsyncTask = null;
    }

    private final void $$robo$$android_widget_SelectionActionModeHelper$invalidateActionMode(SelectionResult result) {
        this.mTextClassification = result != null ? result.mClassification : null;
        ActionMode actionMode = this.mEditor.getTextActionMode();
        if (actionMode != null) {
            actionMode.invalidate();
        }
        this.mSelectionTracker.onSelectionUpdated(this.mTextView.getSelectionStart(), this.mTextView.getSelectionEnd(), this.mTextClassification);
        this.mTextClassificationAsyncTask = null;
    }

    private final void $$robo$$android_widget_SelectionActionModeHelper$resetTextClassificationHelper() {
        this.mTextClassificationHelper.init(this.mTextView.getTextClassifier(), SelectionActionModeHelper.getText(this.mTextView), this.mTextView.getSelectionStart(), this.mTextView.getSelectionEnd(), this.mTextView.getTextLocales());
    }

    private static final int $$robo$$android_widget_SelectionActionModeHelper$getActionType(int menuItemId) {
        switch (menuItemId) {
            case 16908319: {
                return 200;
            }
            case 0x1020020: {
                return 103;
            }
            case 0x1020021: {
                return 101;
            }
            case 0x1020022: 
            case 16908337: {
                return 102;
            }
            case 16908341: {
                return 104;
            }
            case 16908353: {
                return 105;
            }
        }
        return 108;
    }

    private static final CharSequence $$robo$$android_widget_SelectionActionModeHelper$getText(TextView textView) {
        CharSequence text = textView.getText();
        if (text != null) {
            return text;
        }
        return "";
    }

    private void __constructor__(Editor editor) {
        this.$$robo$$android_widget_SelectionActionModeHelper$__constructor__(editor);
    }

    SelectionActionModeHelper(Editor editor) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SelectionActionModeHelper$__constructor__(android.widget.Editor ), 0, this, editor);
    }

    public void startActionModeAsync(boolean bl) {
        InvokeDynamicSupport.bootstrap("startActionModeAsync", $$robo$$android_widget_SelectionActionModeHelper$startActionModeAsync(boolean ), 0, this, bl);
    }

    public void invalidateActionModeAsync() {
        InvokeDynamicSupport.bootstrap("invalidateActionModeAsync", $$robo$$android_widget_SelectionActionModeHelper$invalidateActionModeAsync(), 0, this);
    }

    public void onSelectionAction(int n) {
        InvokeDynamicSupport.bootstrap("onSelectionAction", $$robo$$android_widget_SelectionActionModeHelper$onSelectionAction(int ), 0, this, n);
    }

    public void onSelectionDrag() {
        InvokeDynamicSupport.bootstrap("onSelectionDrag", $$robo$$android_widget_SelectionActionModeHelper$onSelectionDrag(), 0, this);
    }

    public void onTextChanged(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onTextChanged", $$robo$$android_widget_SelectionActionModeHelper$onTextChanged(int int ), 0, this, n, n2);
    }

    public boolean resetSelection(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("resetSelection", $$robo$$android_widget_SelectionActionModeHelper$resetSelection(int ), 0, this, n);
    }

    public TextClassification getTextClassification() {
        return InvokeDynamicSupport.bootstrap("getTextClassification", $$robo$$android_widget_SelectionActionModeHelper$getTextClassification(), 0, this);
    }

    public void onDestroyActionMode() {
        InvokeDynamicSupport.bootstrap("onDestroyActionMode", $$robo$$android_widget_SelectionActionModeHelper$onDestroyActionMode(), 0, this);
    }

    private void cancelAsyncTask() {
        InvokeDynamicSupport.bootstrap("cancelAsyncTask", $$robo$$android_widget_SelectionActionModeHelper$cancelAsyncTask(), 0, this);
    }

    private boolean skipTextClassification() {
        return (boolean)InvokeDynamicSupport.bootstrap("skipTextClassification", $$robo$$android_widget_SelectionActionModeHelper$skipTextClassification(), 0, this);
    }

    private void startActionMode(SelectionResult selectionResult) {
        InvokeDynamicSupport.bootstrap("startActionMode", $$robo$$android_widget_SelectionActionModeHelper$startActionMode(android.widget.SelectionActionModeHelper$SelectionResult ), 0, this, selectionResult);
    }

    private void invalidateActionMode(SelectionResult selectionResult) {
        InvokeDynamicSupport.bootstrap("invalidateActionMode", $$robo$$android_widget_SelectionActionModeHelper$invalidateActionMode(android.widget.SelectionActionModeHelper$SelectionResult ), 0, this, selectionResult);
    }

    private void resetTextClassificationHelper() {
        InvokeDynamicSupport.bootstrap("resetTextClassificationHelper", $$robo$$android_widget_SelectionActionModeHelper$resetTextClassificationHelper(), 0, this);
    }

    private static int getActionType(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getActionType", $$robo$$android_widget_SelectionActionModeHelper$getActionType(int ), 0, (int)n);
    }

    private static CharSequence getText(TextView textView) {
        return InvokeDynamicSupport.bootstrapStatic("getText", $$robo$$android_widget_SelectionActionModeHelper$getText(android.widget.TextView ), 0, (TextView)textView);
    }

    public /* synthetic */ SelectionActionModeHelper() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SelectionActionModeHelper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class SelectionResult
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mStart;
        private int mEnd;
        private TextClassification mClassification;
        private TextSelection mSelection;

        private void $$robo$$android_widget_SelectionActionModeHelper_SelectionResult$__constructor__(int start, int end, TextClassification classification, TextSelection selection) {
            this.mStart = start;
            this.mEnd = end;
            this.mClassification = Preconditions.checkNotNull(classification);
            this.mSelection = selection;
        }

        private void __constructor__(int n, int n2, TextClassification textClassification, TextSelection textSelection) {
            this.$$robo$$android_widget_SelectionActionModeHelper_SelectionResult$__constructor__(n, n2, textClassification, textSelection);
        }

        SelectionResult(int n, int n2, TextClassification textClassification, TextSelection textSelection) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SelectionActionModeHelper_SelectionResult$__constructor__(int int android.view.textclassifier.TextClassification android.view.textclassifier.TextSelection ), 0, this, n, n2, textClassification, textSelection);
        }

        public /* synthetic */ SelectionResult() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SelectionResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class TextClassificationHelper
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int TRIM_DELTA = 120;
        private TextClassifier mTextClassifier;
        private String mText;
        private int mSelectionStart;
        private int mSelectionEnd;
        private LocaleList mLocales;
        private CharSequence mTrimmedText;
        private int mTrimStart;
        private int mRelativeStart;
        private int mRelativeEnd;
        private CharSequence mLastClassificationText;
        private int mLastClassificationSelectionStart;
        private int mLastClassificationSelectionEnd;
        private LocaleList mLastClassificationLocales;
        private SelectionResult mLastClassificationResult;
        private boolean mHot;

        private void $$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$__constructor__(TextClassifier textClassifier, CharSequence text, int selectionStart, int selectionEnd, LocaleList locales) {
            this.init(textClassifier, text, selectionStart, selectionEnd, locales);
        }

        private final void $$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$init(TextClassifier textClassifier, CharSequence text, int selectionStart, int selectionEnd, LocaleList locales) {
            this.mTextClassifier = Preconditions.checkNotNull(textClassifier);
            this.mText = Preconditions.checkNotNull(text).toString();
            this.mLastClassificationText = null;
            Preconditions.checkArgument(selectionEnd > selectionStart);
            this.mSelectionStart = selectionStart;
            this.mSelectionEnd = selectionEnd;
            this.mLocales = locales;
        }

        private final SelectionResult $$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$classifyText() {
            this.mHot = true;
            return this.performClassification(null);
        }

        private final SelectionResult $$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$suggestSelection() {
            this.mHot = true;
            this.trimText();
            TextSelection selection = this.mTextClassifier.suggestSelection(this.mTrimmedText, this.mRelativeStart, this.mRelativeEnd, this.mLocales);
            if (!this.mTextClassifier.getSettings().isDarkLaunch()) {
                this.mSelectionStart = Math.max(0, selection.getSelectionStartIndex() + this.mTrimStart);
                this.mSelectionEnd = Math.min(this.mText.length(), selection.getSelectionEndIndex() + this.mTrimStart);
            }
            return this.performClassification(selection);
        }

        private final long $$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$getTimeoutDuration() {
            if (this.mHot) {
                return 200L;
            }
            return 500L;
        }

        private final SelectionResult $$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$performClassification(TextSelection selection) {
            if (!Objects.equals(this.mText, this.mLastClassificationText) || this.mSelectionStart != this.mLastClassificationSelectionStart || this.mSelectionEnd != this.mLastClassificationSelectionEnd || !Objects.equals(this.mLocales, this.mLastClassificationLocales)) {
                this.mLastClassificationText = this.mText;
                this.mLastClassificationSelectionStart = this.mSelectionStart;
                this.mLastClassificationSelectionEnd = this.mSelectionEnd;
                this.mLastClassificationLocales = this.mLocales;
                this.trimText();
                this.mLastClassificationResult = new SelectionResult(this.mSelectionStart, this.mSelectionEnd, this.mTextClassifier.classifyText(this.mTrimmedText, this.mRelativeStart, this.mRelativeEnd, this.mLocales), selection);
            }
            return this.mLastClassificationResult;
        }

        private final void $$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$trimText() {
            this.mTrimStart = Math.max(0, this.mSelectionStart - 120);
            int referenceEnd = Math.min(this.mText.length(), this.mSelectionEnd + 120);
            this.mTrimmedText = this.mText.subSequence(this.mTrimStart, referenceEnd);
            this.mRelativeStart = this.mSelectionStart - this.mTrimStart;
            this.mRelativeEnd = this.mSelectionEnd - this.mTrimStart;
        }

        private void __constructor__(TextClassifier textClassifier, CharSequence charSequence, int n, int n2, LocaleList localeList) {
            this.$$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$__constructor__(textClassifier, charSequence, n, n2, localeList);
        }

        TextClassificationHelper(TextClassifier textClassifier, CharSequence charSequence, int n, int n2, LocaleList localeList) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$__constructor__(android.view.textclassifier.TextClassifier java.lang.CharSequence int int android.os.LocaleList ), 0, this, textClassifier, charSequence, n, n2, localeList);
        }

        public void init(TextClassifier textClassifier, CharSequence charSequence, int n, int n2, LocaleList localeList) {
            InvokeDynamicSupport.bootstrap("init", $$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$init(android.view.textclassifier.TextClassifier java.lang.CharSequence int int android.os.LocaleList ), 0, this, textClassifier, charSequence, n, n2, localeList);
        }

        public SelectionResult classifyText() {
            return InvokeDynamicSupport.bootstrap("classifyText", $$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$classifyText(), 0, this);
        }

        public SelectionResult suggestSelection() {
            return InvokeDynamicSupport.bootstrap("suggestSelection", $$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$suggestSelection(), 0, this);
        }

        public long getTimeoutDuration() {
            return (long)InvokeDynamicSupport.bootstrap("getTimeoutDuration", $$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$getTimeoutDuration(), 0, this);
        }

        private SelectionResult performClassification(TextSelection textSelection) {
            return InvokeDynamicSupport.bootstrap("performClassification", $$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$performClassification(android.view.textclassifier.TextSelection ), 0, this, textSelection);
        }

        private void trimText() {
            InvokeDynamicSupport.bootstrap("trimText", $$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$trimText(), 0, this);
        }

        public /* synthetic */ TextClassificationHelper() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextClassificationHelper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class TextClassificationAsyncTask
    extends AsyncTask<Void, Void, SelectionResult> {
        public transient /* synthetic */ Object __robo_data__;
        private long mTimeOutDuration;
        private Supplier<SelectionResult> mSelectionResultSupplier;
        private Consumer<SelectionResult> mSelectionResultCallback;
        private TextView mTextView;
        private String mOriginalText;

        private void $$robo$$android_widget_SelectionActionModeHelper_TextClassificationAsyncTask$__constructor__(TextView textView, long timeOut, Supplier<SelectionResult> selectionResultSupplier, Consumer<SelectionResult> selectionResultCallback) {
            this.mTextView = Preconditions.checkNotNull(textView);
            this.mTimeOutDuration = timeOut;
            this.mSelectionResultSupplier = Preconditions.checkNotNull(selectionResultSupplier);
            this.mSelectionResultCallback = Preconditions.checkNotNull(selectionResultCallback);
            this.mOriginalText = SelectionActionModeHelper.getText(this.mTextView).toString();
        }

        private final SelectionResult $$robo$$android_widget_SelectionActionModeHelper_TextClassificationAsyncTask$doInBackground(Void ... params) {
            Runnable onTimeOut = this::onTimeOut;
            this.mTextView.postDelayed(onTimeOut, this.mTimeOutDuration);
            SelectionResult result = this.mSelectionResultSupplier.get();
            this.mTextView.removeCallbacks(onTimeOut);
            return result;
        }

        private final void $$robo$$android_widget_SelectionActionModeHelper_TextClassificationAsyncTask$onPostExecute(SelectionResult result) {
            result = TextUtils.equals(this.mOriginalText, SelectionActionModeHelper.getText(this.mTextView)) ? result : null;
            this.mSelectionResultCallback.accept(result);
        }

        private final void $$robo$$android_widget_SelectionActionModeHelper_TextClassificationAsyncTask$onTimeOut() {
            if (this.getStatus() == AsyncTask.Status.RUNNING) {
                this.onPostExecute(null);
            }
            this.cancel(true);
        }

        private void __constructor__(TextView textView, long l, Supplier<SelectionResult> supplier, Consumer<SelectionResult> consumer) {
            this.$$robo$$android_widget_SelectionActionModeHelper_TextClassificationAsyncTask$__constructor__(textView, l, supplier, consumer);
        }

        TextClassificationAsyncTask(TextView textView, long l, Supplier<SelectionResult> supplier, Consumer<SelectionResult> consumer) {
            super(textView != null ? textView.getHandler() : null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SelectionActionModeHelper_TextClassificationAsyncTask$__constructor__(android.widget.TextView long java.util.function.Supplier<android.widget.SelectionActionModeHelper$SelectionResult> java.util.function.Consumer<android.widget.SelectionActionModeHelper$SelectionResult> ), 0, this, textView, l, supplier, consumer);
        }

        protected SelectionResult doInBackground(Void ... voidArray) {
            return InvokeDynamicSupport.bootstrap("doInBackground", $$robo$$android_widget_SelectionActionModeHelper_TextClassificationAsyncTask$doInBackground(java.lang.Void[] ), 0, this, voidArray);
        }

        @Override
        protected void onPostExecute(SelectionResult selectionResult) {
            InvokeDynamicSupport.bootstrap("onPostExecute", $$robo$$android_widget_SelectionActionModeHelper_TextClassificationAsyncTask$onPostExecute(android.widget.SelectionActionModeHelper$SelectionResult ), 0, this, selectionResult);
        }

        private void onTimeOut() {
            InvokeDynamicSupport.bootstrap("onTimeOut", $$robo$$android_widget_SelectionActionModeHelper_TextClassificationAsyncTask$onTimeOut(), 0, this);
        }

        public /* synthetic */ TextClassificationAsyncTask() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextClassificationAsyncTask)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class SelectionMetricsLogger
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String LOG_TAG = "SelectionMetricsLogger";
        private static Pattern PATTERN_WHITESPACE;
        private SmartSelectionEventTracker mDelegate;
        private boolean mEditTextLogger;
        private BreakIterator mWordIterator;
        private int mStartIndex;
        private String mText;

        private void $$robo$$android_widget_SelectionActionModeHelper_SelectionMetricsLogger$__constructor__(TextView textView) {
            Preconditions.checkNotNull(textView);
            int widgetType = textView.isTextEditable() ? 3 : 1;
            this.mDelegate = new SmartSelectionEventTracker(textView.getContext(), widgetType);
            this.mEditTextLogger = textView.isTextEditable();
            this.mWordIterator = BreakIterator.getWordInstance(textView.getTextLocale());
        }

        private final void $$robo$$android_widget_SelectionActionModeHelper_SelectionMetricsLogger$logSelectionStarted(CharSequence text, int index) {
            try {
                Preconditions.checkNotNull(text);
                Preconditions.checkArgumentInRange(index, 0, text.length(), "index");
                if (this.mText == null || !this.mText.contentEquals(text)) {
                    this.mText = text.toString();
                }
                this.mWordIterator.setText(this.mText);
                this.mStartIndex = index;
                this.mDelegate.logEvent(SmartSelectionEventTracker.SelectionEvent.selectionStarted(0));
            }
            catch (Exception e) {
                Log.d("SelectionMetricsLogger", e.getMessage());
            }
        }

        private final void $$robo$$android_widget_SelectionActionModeHelper_SelectionMetricsLogger$logSelectionModified(int start, int end, TextClassification classification, TextSelection selection) {
            try {
                Preconditions.checkArgumentInRange(start, 0, this.mText.length(), "start");
                Preconditions.checkArgumentInRange(end, start, this.mText.length(), "end");
                int[] wordIndices = this.getWordDelta(start, end);
                if (selection != null) {
                    this.mDelegate.logEvent(SmartSelectionEventTracker.SelectionEvent.selectionModified(wordIndices[0], wordIndices[1], selection));
                } else if (classification != null) {
                    this.mDelegate.logEvent(SmartSelectionEventTracker.SelectionEvent.selectionModified(wordIndices[0], wordIndices[1], classification));
                } else {
                    this.mDelegate.logEvent(SmartSelectionEventTracker.SelectionEvent.selectionModified(wordIndices[0], wordIndices[1]));
                }
            }
            catch (Exception e) {
                Log.d("SelectionMetricsLogger", e.getMessage());
            }
        }

        private final void $$robo$$android_widget_SelectionActionModeHelper_SelectionMetricsLogger$logSelectionAction(int start, int end, int action, TextClassification classification) {
            try {
                Preconditions.checkArgumentInRange(start, 0, this.mText.length(), "start");
                Preconditions.checkArgumentInRange(end, start, this.mText.length(), "end");
                int[] wordIndices = this.getWordDelta(start, end);
                if (classification != null) {
                    this.mDelegate.logEvent(SmartSelectionEventTracker.SelectionEvent.selectionAction(wordIndices[0], wordIndices[1], action, classification));
                } else {
                    this.mDelegate.logEvent(SmartSelectionEventTracker.SelectionEvent.selectionAction(wordIndices[0], wordIndices[1], action));
                }
            }
            catch (Exception e) {
                Log.d("SelectionMetricsLogger", e.getMessage());
            }
        }

        private final boolean $$robo$$android_widget_SelectionActionModeHelper_SelectionMetricsLogger$isEditTextLogger() {
            return this.mEditTextLogger;
        }

        private final int[] $$robo$$android_widget_SelectionActionModeHelper_SelectionMetricsLogger$getWordDelta(int start, int end) {
            int[] wordIndices = new int[2];
            if (start == this.mStartIndex) {
                wordIndices[0] = 0;
            } else if (start < this.mStartIndex) {
                wordIndices[0] = -this.countWordsForward(start);
            } else {
                wordIndices[0] = this.countWordsBackward(start);
                if (!this.mWordIterator.isBoundary(start) && !this.isWhitespace(this.mWordIterator.preceding(start), this.mWordIterator.following(start))) {
                    wordIndices[0] = wordIndices[0] - 1;
                }
            }
            wordIndices[1] = end == this.mStartIndex ? 0 : (end < this.mStartIndex ? -this.countWordsForward(end) : this.countWordsBackward(end));
            return wordIndices;
        }

        private final int $$robo$$android_widget_SelectionActionModeHelper_SelectionMetricsLogger$countWordsBackward(int from) {
            Preconditions.checkArgument(from >= this.mStartIndex);
            int wordCount = 0;
            int offset = from;
            while (offset > this.mStartIndex) {
                int start = this.mWordIterator.preceding(offset);
                if (!this.isWhitespace(start, offset)) {
                    ++wordCount;
                }
                offset = start;
            }
            return wordCount;
        }

        private final int $$robo$$android_widget_SelectionActionModeHelper_SelectionMetricsLogger$countWordsForward(int from) {
            Preconditions.checkArgument(from <= this.mStartIndex);
            int wordCount = 0;
            int offset = from;
            while (offset < this.mStartIndex) {
                int end = this.mWordIterator.following(offset);
                if (!this.isWhitespace(offset, end)) {
                    ++wordCount;
                }
                offset = end;
            }
            return wordCount;
        }

        private final boolean $$robo$$android_widget_SelectionActionModeHelper_SelectionMetricsLogger$isWhitespace(int start, int end) {
            return PATTERN_WHITESPACE.matcher(this.mText.substring(start, end)).matches();
        }

        static void __staticInitializer__() {
            PATTERN_WHITESPACE = Pattern.compile("\\s+");
        }

        private void __constructor__(TextView textView) {
            this.$$robo$$android_widget_SelectionActionModeHelper_SelectionMetricsLogger$__constructor__(textView);
        }

        SelectionMetricsLogger(TextView textView) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SelectionActionModeHelper_SelectionMetricsLogger$__constructor__(android.widget.TextView ), 0, this, textView);
        }

        public void logSelectionStarted(CharSequence charSequence, int n) {
            InvokeDynamicSupport.bootstrap("logSelectionStarted", $$robo$$android_widget_SelectionActionModeHelper_SelectionMetricsLogger$logSelectionStarted(java.lang.CharSequence int ), 0, this, charSequence, n);
        }

        public void logSelectionModified(int n, int n2, TextClassification textClassification, TextSelection textSelection) {
            InvokeDynamicSupport.bootstrap("logSelectionModified", $$robo$$android_widget_SelectionActionModeHelper_SelectionMetricsLogger$logSelectionModified(int int android.view.textclassifier.TextClassification android.view.textclassifier.TextSelection ), 0, this, n, n2, textClassification, textSelection);
        }

        public void logSelectionAction(int n, int n2, int n3, TextClassification textClassification) {
            InvokeDynamicSupport.bootstrap("logSelectionAction", $$robo$$android_widget_SelectionActionModeHelper_SelectionMetricsLogger$logSelectionAction(int int int android.view.textclassifier.TextClassification ), 0, this, n, n2, n3, textClassification);
        }

        public boolean isEditTextLogger() {
            return (boolean)InvokeDynamicSupport.bootstrap("isEditTextLogger", $$robo$$android_widget_SelectionActionModeHelper_SelectionMetricsLogger$isEditTextLogger(), 0, this);
        }

        private int[] getWordDelta(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("getWordDelta", $$robo$$android_widget_SelectionActionModeHelper_SelectionMetricsLogger$getWordDelta(int int ), 0, this, n, n2);
        }

        private int countWordsBackward(int n) {
            return (int)InvokeDynamicSupport.bootstrap("countWordsBackward", $$robo$$android_widget_SelectionActionModeHelper_SelectionMetricsLogger$countWordsBackward(int ), 0, this, n);
        }

        private int countWordsForward(int n) {
            return (int)InvokeDynamicSupport.bootstrap("countWordsForward", $$robo$$android_widget_SelectionActionModeHelper_SelectionMetricsLogger$countWordsForward(int ), 0, this, n);
        }

        private boolean isWhitespace(int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("isWhitespace", $$robo$$android_widget_SelectionActionModeHelper_SelectionMetricsLogger$isWhitespace(int int ), 0, this, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(SelectionMetricsLogger.class);
        }

        public /* synthetic */ SelectionMetricsLogger() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SelectionMetricsLogger)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class SelectionTracker
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private TextView mTextView;
        private SelectionMetricsLogger mLogger;
        private int mOriginalStart;
        private int mOriginalEnd;
        private int mSelectionStart;
        private int mSelectionEnd;
        private boolean mAllowReset;
        private LogAbandonRunnable mDelayedLogAbandon;

        private void $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$__constructor__(TextView textView) {
            this.mDelayedLogAbandon = new LogAbandonRunnable(this);
            this.mTextView = Preconditions.checkNotNull(textView);
            this.mLogger = new SelectionMetricsLogger(textView);
        }

        private final void $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$onOriginalSelection(CharSequence text, int selectionStart, int selectionEnd) {
            this.mDelayedLogAbandon.flush();
            this.mOriginalStart = this.mSelectionStart = selectionStart;
            this.mOriginalEnd = this.mSelectionEnd = selectionEnd;
            this.mAllowReset = false;
            this.maybeInvalidateLogger();
            this.mLogger.logSelectionStarted(text, selectionStart);
        }

        private final void $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$onSmartSelection(SelectionResult result) {
            if (this.isSelectionStarted()) {
                this.mSelectionStart = result.mStart;
                this.mSelectionEnd = result.mEnd;
                this.mAllowReset = this.mSelectionStart != this.mOriginalStart || this.mSelectionEnd != this.mOriginalEnd;
                this.mLogger.logSelectionModified(result.mStart, result.mEnd, result.mClassification, result.mSelection);
            }
        }

        private final void $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$onSelectionUpdated(int selectionStart, int selectionEnd, TextClassification classification) {
            if (this.isSelectionStarted()) {
                this.mSelectionStart = selectionStart;
                this.mSelectionEnd = selectionEnd;
                this.mAllowReset = false;
                this.mLogger.logSelectionModified(selectionStart, selectionEnd, classification, null);
            }
        }

        private final void $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$onSelectionDestroyed() {
            this.mAllowReset = false;
            this.mDelayedLogAbandon.schedule(100);
        }

        private final void $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$onSelectionAction(int selectionStart, int selectionEnd, int action, TextClassification classification) {
            if (this.isSelectionStarted()) {
                this.mAllowReset = false;
                this.mLogger.logSelectionAction(selectionStart, selectionEnd, action, classification);
            }
        }

        private final boolean $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$resetSelection(int textIndex, Editor editor) {
            TextView textView = editor.getTextView();
            if (this.isSelectionStarted() && this.mAllowReset && textIndex >= this.mSelectionStart && textIndex <= this.mSelectionEnd && SelectionActionModeHelper.getText(textView) instanceof Spannable) {
                this.mAllowReset = false;
                boolean selected = editor.selectCurrentWord();
                if (selected) {
                    this.mSelectionStart = editor.getTextView().getSelectionStart();
                    this.mSelectionEnd = editor.getTextView().getSelectionEnd();
                    this.mLogger.logSelectionAction(textView.getSelectionStart(), textView.getSelectionEnd(), 201, null);
                }
                return selected;
            }
            return false;
        }

        private final void $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$onTextChanged(int start, int end, TextClassification classification) {
            if (this.isSelectionStarted() && start == this.mSelectionStart && end == this.mSelectionEnd) {
                this.onSelectionAction(start, end, 100, classification);
            }
        }

        private final void $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$maybeInvalidateLogger() {
            if (this.mLogger.isEditTextLogger() != this.mTextView.isTextEditable()) {
                this.mLogger = new SelectionMetricsLogger(this.mTextView);
            }
        }

        private final boolean $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$isSelectionStarted() {
            return this.mSelectionStart >= 0 && this.mSelectionEnd >= 0 && this.mSelectionStart != this.mSelectionEnd;
        }

        private void __constructor__(TextView textView) {
            this.$$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$__constructor__(textView);
        }

        SelectionTracker(TextView textView) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$__constructor__(android.widget.TextView ), 0, this, textView);
        }

        public void onOriginalSelection(CharSequence charSequence, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onOriginalSelection", $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$onOriginalSelection(java.lang.CharSequence int int ), 0, this, charSequence, n, n2);
        }

        public void onSmartSelection(SelectionResult selectionResult) {
            InvokeDynamicSupport.bootstrap("onSmartSelection", $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$onSmartSelection(android.widget.SelectionActionModeHelper$SelectionResult ), 0, this, selectionResult);
        }

        public void onSelectionUpdated(int n, int n2, TextClassification textClassification) {
            InvokeDynamicSupport.bootstrap("onSelectionUpdated", $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$onSelectionUpdated(int int android.view.textclassifier.TextClassification ), 0, this, n, n2, textClassification);
        }

        public void onSelectionDestroyed() {
            InvokeDynamicSupport.bootstrap("onSelectionDestroyed", $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$onSelectionDestroyed(), 0, this);
        }

        public void onSelectionAction(int n, int n2, int n3, TextClassification textClassification) {
            InvokeDynamicSupport.bootstrap("onSelectionAction", $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$onSelectionAction(int int int android.view.textclassifier.TextClassification ), 0, this, n, n2, n3, textClassification);
        }

        public boolean resetSelection(int n, Editor editor) {
            return (boolean)InvokeDynamicSupport.bootstrap("resetSelection", $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$resetSelection(int android.widget.Editor ), 0, this, n, editor);
        }

        public void onTextChanged(int n, int n2, TextClassification textClassification) {
            InvokeDynamicSupport.bootstrap("onTextChanged", $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$onTextChanged(int int android.view.textclassifier.TextClassification ), 0, this, n, n2, textClassification);
        }

        private void maybeInvalidateLogger() {
            InvokeDynamicSupport.bootstrap("maybeInvalidateLogger", $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$maybeInvalidateLogger(), 0, this);
        }

        private boolean isSelectionStarted() {
            return (boolean)InvokeDynamicSupport.bootstrap("isSelectionStarted", $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$isSelectionStarted(), 0, this);
        }

        public /* synthetic */ SelectionTracker() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SelectionTracker)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        private final class LogAbandonRunnable
        implements Runnable,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private boolean mIsPending;
            /* synthetic */ SelectionTracker this$0;

            private void $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker_LogAbandonRunnable$__constructor__(SelectionTracker selectionTracker) {
            }

            private final void $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker_LogAbandonRunnable$schedule(int delayMillis) {
                if (this.mIsPending) {
                    Log.e("SelectActionModeHelper", "Force flushing abandon due to new scheduling request");
                    this.flush();
                }
                this.mIsPending = true;
                this.this$0.mTextView.postDelayed(this, delayMillis);
            }

            private final void $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker_LogAbandonRunnable$flush() {
                this.this$0.mTextView.removeCallbacks(this);
                this.run();
            }

            private final void $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker_LogAbandonRunnable$run() {
                if (this.mIsPending) {
                    this.this$0.mLogger.logSelectionAction(this.this$0.mSelectionStart, this.this$0.mSelectionEnd, 107, null);
                    this.this$0.mSelectionStart = (this.this$0.mSelectionEnd = -1);
                    this.mIsPending = false;
                }
            }

            private /* synthetic */ void $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker_LogAbandonRunnable$__constructor__(SelectionTracker x0, 1 x1) {
            }

            private void __constructor__(SelectionTracker selectionTracker) {
                this.$$robo$$android_widget_SelectionActionModeHelper_SelectionTracker_LogAbandonRunnable$__constructor__(selectionTracker);
            }

            private LogAbandonRunnable(SelectionTracker selectionTracker) {
                this.this$0 = selectionTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker_LogAbandonRunnable$__constructor__(android.widget.SelectionActionModeHelper$SelectionTracker ), 0, this, selectionTracker);
            }

            void schedule(int n) {
                InvokeDynamicSupport.bootstrap("schedule", $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker_LogAbandonRunnable$schedule(int ), 0, this, n);
            }

            void flush() {
                InvokeDynamicSupport.bootstrap("flush", $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker_LogAbandonRunnable$flush(), 0, this);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker_LogAbandonRunnable$run(), 0, this);
            }

            private /* synthetic */ void __constructor__(SelectionTracker selectionTracker, 1 var2_2) {
                this.$$robo$$android_widget_SelectionActionModeHelper_SelectionTracker_LogAbandonRunnable$__constructor__(selectionTracker, var2_2);
            }

            public /* synthetic */ LogAbandonRunnable() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LogAbandonRunnable)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

