/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.icu.text.DisplayContext;
import android.icu.text.SimpleDateFormat;
import android.icu.util.Calendar;
import android.os.Bundle;
import android.text.TextPaint;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.util.IntArray;
import android.util.MathUtils;
import android.util.StateSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.PointerIcon;
import android.view.View;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import com.android.internal.R;
import com.android.internal.widget.ExploreByTouchHelper;
import java.text.NumberFormat;
import java.util.Locale;
import libcore.icu.LocaleData;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SimpleMonthView
extends View
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int DAYS_IN_WEEK = 7;
    private static int MAX_WEEKS_IN_MONTH = 6;
    private static int DEFAULT_SELECTED_DAY = -1;
    private static int DEFAULT_WEEK_START = 1;
    private static String MONTH_YEAR_FORMAT = "MMMMy";
    private static int SELECTED_HIGHLIGHT_ALPHA = 176;
    private TextPaint mMonthPaint;
    private TextPaint mDayOfWeekPaint;
    private TextPaint mDayPaint;
    private Paint mDaySelectorPaint;
    private Paint mDayHighlightPaint;
    private Paint mDayHighlightSelectorPaint;
    private String[] mDayOfWeekLabels;
    private Calendar mCalendar;
    private Locale mLocale;
    private MonthViewTouchHelper mTouchHelper;
    private NumberFormat mDayFormatter;
    private int mDesiredMonthHeight;
    private int mDesiredDayOfWeekHeight;
    private int mDesiredDayHeight;
    private int mDesiredCellWidth;
    private int mDesiredDaySelectorRadius;
    private String mMonthYearLabel;
    private int mMonth;
    private int mYear;
    private int mMonthHeight;
    private int mDayOfWeekHeight;
    private int mDayHeight;
    private int mCellWidth;
    private int mDaySelectorRadius;
    private int mPaddedWidth;
    private int mPaddedHeight;
    private int mActivatedDay;
    private int mToday;
    private int mWeekStart;
    private int mDaysInMonth;
    private int mDayOfWeekStart;
    private int mEnabledDayStart;
    private int mEnabledDayEnd;
    private OnDayClickListener mOnDayClickListener;
    private ColorStateList mDayTextColor;
    private int mHighlightedDay;
    private int mPreviouslyHighlightedDay;
    private boolean mIsTouchHighlighted;

    private void $$robo$$android_widget_SimpleMonthView$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_SimpleMonthView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_SimpleMonthView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_SimpleMonthView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mMonthPaint = new TextPaint();
        this.mDayOfWeekPaint = new TextPaint();
        this.mDayPaint = new TextPaint();
        this.mDaySelectorPaint = new Paint();
        this.mDayHighlightPaint = new Paint();
        this.mDayHighlightSelectorPaint = new Paint();
        this.mDayOfWeekLabels = new String[7];
        this.mActivatedDay = -1;
        this.mToday = -1;
        this.mWeekStart = 1;
        this.mEnabledDayStart = 1;
        this.mEnabledDayEnd = 31;
        this.mHighlightedDay = -1;
        this.mPreviouslyHighlightedDay = -1;
        this.mIsTouchHighlighted = false;
        Resources res = context.getResources();
        this.mDesiredMonthHeight = res.getDimensionPixelSize(17104980);
        this.mDesiredDayOfWeekHeight = res.getDimensionPixelSize(17104975);
        this.mDesiredDayHeight = res.getDimensionPixelSize(17104974);
        this.mDesiredCellWidth = res.getDimensionPixelSize(17104979);
        this.mDesiredDaySelectorRadius = res.getDimensionPixelSize(0x1050051);
        this.mTouchHelper = new MonthViewTouchHelper(this, this);
        this.setAccessibilityDelegate(this.mTouchHelper);
        this.setImportantForAccessibility(1);
        this.mLocale = res.getConfiguration().locale;
        this.mCalendar = Calendar.getInstance(this.mLocale);
        this.mDayFormatter = NumberFormat.getIntegerInstance(this.mLocale);
        this.updateMonthYearLabel();
        this.updateDayOfWeekLabels();
        this.initPaints(res);
    }

    private final void $$robo$$android_widget_SimpleMonthView$updateMonthYearLabel() {
        String format = DateFormat.getBestDateTimePattern(this.mLocale, "MMMMy");
        SimpleDateFormat formatter = new SimpleDateFormat(format, this.mLocale);
        formatter.setContext(DisplayContext.CAPITALIZATION_FOR_STANDALONE);
        this.mMonthYearLabel = formatter.format(this.mCalendar.getTime());
    }

    private final void $$robo$$android_widget_SimpleMonthView$updateDayOfWeekLabels() {
        String[] tinyWeekdayNames = LocaleData.get((Locale)this.mLocale).tinyWeekdayNames;
        for (int i = 0; i < 7; ++i) {
            this.mDayOfWeekLabels[i] = tinyWeekdayNames[(this.mWeekStart + i - 1) % 7 + 1];
        }
    }

    private final ColorStateList $$robo$$android_widget_SimpleMonthView$applyTextAppearance(Paint p, int resId) {
        TypedArray ta = this.mContext.obtainStyledAttributes(null, R.styleable.TextAppearance, 0, resId);
        String fontFamily = ta.getString(12);
        if (fontFamily != null) {
            p.setTypeface(Typeface.create(fontFamily, 0));
        }
        p.setTextSize(ta.getDimensionPixelSize(0, (int)p.getTextSize()));
        ColorStateList textColor = ta.getColorStateList(3);
        if (textColor != null) {
            int enabledColor = textColor.getColorForState(ENABLED_STATE_SET, 0);
            p.setColor(enabledColor);
        }
        ta.recycle();
        return textColor;
    }

    private final int $$robo$$android_widget_SimpleMonthView$getMonthHeight() {
        return this.mMonthHeight;
    }

    private final int $$robo$$android_widget_SimpleMonthView$getCellWidth() {
        return this.mCellWidth;
    }

    private final void $$robo$$android_widget_SimpleMonthView$setMonthTextAppearance(int resId) {
        this.applyTextAppearance(this.mMonthPaint, resId);
        this.invalidate();
    }

    private final void $$robo$$android_widget_SimpleMonthView$setDayOfWeekTextAppearance(int resId) {
        this.applyTextAppearance(this.mDayOfWeekPaint, resId);
        this.invalidate();
    }

    private final void $$robo$$android_widget_SimpleMonthView$setDayTextAppearance(int resId) {
        ColorStateList textColor = this.applyTextAppearance(this.mDayPaint, resId);
        if (textColor != null) {
            this.mDayTextColor = textColor;
        }
        this.invalidate();
    }

    private final void $$robo$$android_widget_SimpleMonthView$initPaints(Resources res) {
        String monthTypeface = res.getString(17039735);
        String dayOfWeekTypeface = res.getString(17039725);
        String dayTypeface = res.getString(17039726);
        int monthTextSize = res.getDimensionPixelSize(0x1050055);
        int dayOfWeekTextSize = res.getDimensionPixelSize(0x1050050);
        int dayTextSize = res.getDimensionPixelSize(17104978);
        this.mMonthPaint.setAntiAlias(true);
        this.mMonthPaint.setTextSize(monthTextSize);
        this.mMonthPaint.setTypeface(Typeface.create(monthTypeface, 0));
        this.mMonthPaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthPaint.setStyle(Paint.Style.FILL);
        this.mDayOfWeekPaint.setAntiAlias(true);
        this.mDayOfWeekPaint.setTextSize(dayOfWeekTextSize);
        this.mDayOfWeekPaint.setTypeface(Typeface.create(dayOfWeekTypeface, 0));
        this.mDayOfWeekPaint.setTextAlign(Paint.Align.CENTER);
        this.mDayOfWeekPaint.setStyle(Paint.Style.FILL);
        this.mDaySelectorPaint.setAntiAlias(true);
        this.mDaySelectorPaint.setStyle(Paint.Style.FILL);
        this.mDayHighlightPaint.setAntiAlias(true);
        this.mDayHighlightPaint.setStyle(Paint.Style.FILL);
        this.mDayHighlightSelectorPaint.setAntiAlias(true);
        this.mDayHighlightSelectorPaint.setStyle(Paint.Style.FILL);
        this.mDayPaint.setAntiAlias(true);
        this.mDayPaint.setTextSize(dayTextSize);
        this.mDayPaint.setTypeface(Typeface.create(dayTypeface, 0));
        this.mDayPaint.setTextAlign(Paint.Align.CENTER);
        this.mDayPaint.setStyle(Paint.Style.FILL);
    }

    private final void $$robo$$android_widget_SimpleMonthView$setMonthTextColor(ColorStateList monthTextColor) {
        int enabledColor = monthTextColor.getColorForState(ENABLED_STATE_SET, 0);
        this.mMonthPaint.setColor(enabledColor);
        this.invalidate();
    }

    private final void $$robo$$android_widget_SimpleMonthView$setDayOfWeekTextColor(ColorStateList dayOfWeekTextColor) {
        int enabledColor = dayOfWeekTextColor.getColorForState(ENABLED_STATE_SET, 0);
        this.mDayOfWeekPaint.setColor(enabledColor);
        this.invalidate();
    }

    private final void $$robo$$android_widget_SimpleMonthView$setDayTextColor(ColorStateList dayTextColor) {
        this.mDayTextColor = dayTextColor;
        this.invalidate();
    }

    private final void $$robo$$android_widget_SimpleMonthView$setDaySelectorColor(ColorStateList dayBackgroundColor) {
        int activatedColor = dayBackgroundColor.getColorForState(StateSet.get(40), 0);
        this.mDaySelectorPaint.setColor(activatedColor);
        this.mDayHighlightSelectorPaint.setColor(activatedColor);
        this.mDayHighlightSelectorPaint.setAlpha(176);
        this.invalidate();
    }

    private final void $$robo$$android_widget_SimpleMonthView$setDayHighlightColor(ColorStateList dayHighlightColor) {
        int pressedColor = dayHighlightColor.getColorForState(StateSet.get(24), 0);
        this.mDayHighlightPaint.setColor(pressedColor);
        this.invalidate();
    }

    private final void $$robo$$android_widget_SimpleMonthView$setOnDayClickListener(OnDayClickListener listener) {
        this.mOnDayClickListener = listener;
    }

    private final boolean $$robo$$android_widget_SimpleMonthView$dispatchHoverEvent(MotionEvent event) {
        return this.mTouchHelper.dispatchHoverEvent(event) || super.dispatchHoverEvent(event);
    }

    private final boolean $$robo$$android_widget_SimpleMonthView$onTouchEvent(MotionEvent event) {
        int x = (int)(event.getX() + 0.5f);
        int y = (int)(event.getY() + 0.5f);
        int action = event.getAction();
        switch (action) {
            case 0: 
            case 2: {
                int touchedItem = this.getDayAtLocation(x, y);
                this.mIsTouchHighlighted = true;
                if (this.mHighlightedDay != touchedItem) {
                    this.mHighlightedDay = touchedItem;
                    this.mPreviouslyHighlightedDay = touchedItem;
                    this.invalidate();
                }
                if (action != 0 || touchedItem >= 0) break;
                return false;
            }
            case 1: {
                int clickedDay = this.getDayAtLocation(x, y);
                this.onDayClicked(clickedDay);
            }
            case 3: {
                this.mHighlightedDay = -1;
                this.mIsTouchHighlighted = false;
                this.invalidate();
            }
        }
        return true;
    }

    private final boolean $$robo$$android_widget_SimpleMonthView$onKeyDown(int keyCode, KeyEvent event) {
        boolean focusChanged = false;
        switch (event.getKeyCode()) {
            case 21: {
                if (!event.hasNoModifiers()) break;
                focusChanged = this.moveOneDay(this.isLayoutRtl());
                break;
            }
            case 22: {
                if (!event.hasNoModifiers()) break;
                focusChanged = this.moveOneDay(!this.isLayoutRtl());
                break;
            }
            case 19: {
                if (!event.hasNoModifiers()) break;
                this.ensureFocusedDay();
                if (this.mHighlightedDay <= 7) break;
                this.mHighlightedDay -= 7;
                focusChanged = true;
                break;
            }
            case 20: {
                if (!event.hasNoModifiers()) break;
                this.ensureFocusedDay();
                if (this.mHighlightedDay > this.mDaysInMonth - 7) break;
                this.mHighlightedDay += 7;
                focusChanged = true;
                break;
            }
            case 23: 
            case 66: {
                if (this.mHighlightedDay == -1) break;
                this.onDayClicked(this.mHighlightedDay);
                return true;
            }
            case 61: {
                int focusChangeDirection = 0;
                if (event.hasNoModifiers()) {
                    focusChangeDirection = 2;
                } else if (event.hasModifiers(1)) {
                    focusChangeDirection = 1;
                }
                if (focusChangeDirection == 0) break;
                ViewParent parent = this.getParent();
                View nextFocus = this;
                while ((nextFocus = nextFocus.focusSearch(focusChangeDirection)) != null && nextFocus != this && nextFocus.getParent() == parent) {
                }
                if (nextFocus == null) break;
                nextFocus.requestFocus();
                return true;
            }
        }
        if (focusChanged) {
            this.invalidate();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    private final boolean $$robo$$android_widget_SimpleMonthView$moveOneDay(boolean positive) {
        this.ensureFocusedDay();
        boolean focusChanged = false;
        if (positive) {
            if (!this.isLastDayOfWeek(this.mHighlightedDay) && this.mHighlightedDay < this.mDaysInMonth) {
                ++this.mHighlightedDay;
                focusChanged = true;
            }
        } else if (!this.isFirstDayOfWeek(this.mHighlightedDay) && this.mHighlightedDay > 1) {
            --this.mHighlightedDay;
            focusChanged = true;
        }
        return focusChanged;
    }

    private final void $$robo$$android_widget_SimpleMonthView$onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        if (gainFocus) {
            int offset = this.findDayOffset();
            switch (direction) {
                case 66: {
                    int row = this.findClosestRow(previouslyFocusedRect);
                    this.mHighlightedDay = row == 0 ? 1 : row * 7 - offset + 1;
                    break;
                }
                case 17: {
                    int row = this.findClosestRow(previouslyFocusedRect) + 1;
                    this.mHighlightedDay = Math.min(this.mDaysInMonth, row * 7 - offset);
                    break;
                }
                case 130: {
                    int col = this.findClosestColumn(previouslyFocusedRect);
                    int day = col - offset + 1;
                    this.mHighlightedDay = day < 1 ? day + 7 : day;
                    break;
                }
                case 33: {
                    int col = this.findClosestColumn(previouslyFocusedRect);
                    int maxWeeks = (offset + this.mDaysInMonth) / 7;
                    int day = col - offset + 7 * maxWeeks + 1;
                    this.mHighlightedDay = day > this.mDaysInMonth ? day - 7 : day;
                    break;
                }
            }
            this.ensureFocusedDay();
            this.invalidate();
        }
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
    }

    private final int $$robo$$android_widget_SimpleMonthView$findClosestRow(Rect previouslyFocusedRect) {
        if (previouslyFocusedRect == null) {
            return 3;
        }
        int centerY = previouslyFocusedRect.centerY();
        TextPaint p = this.mDayPaint;
        int headerHeight = this.mMonthHeight + this.mDayOfWeekHeight;
        int rowHeight = this.mDayHeight;
        float halfLineHeight = (p.ascent() + p.descent()) / 2.0f;
        int rowCenter = headerHeight + rowHeight / 2;
        centerY = (int)((float)centerY - ((float)rowCenter - halfLineHeight));
        int row = Math.round((float)centerY / (float)rowHeight);
        int maxDay = this.findDayOffset() + this.mDaysInMonth;
        int maxRows = maxDay / 7 - (maxDay % 7 == 0 ? 1 : 0);
        row = MathUtils.constrain(row, 0, maxRows);
        return row;
    }

    private final int $$robo$$android_widget_SimpleMonthView$findClosestColumn(Rect previouslyFocusedRect) {
        if (previouslyFocusedRect == null) {
            return 3;
        }
        int centerX = previouslyFocusedRect.centerX() - this.mPaddingLeft;
        int columnFromLeft = MathUtils.constrain(centerX / this.mCellWidth, 0, 6);
        return this.isLayoutRtl() ? 7 - columnFromLeft - 1 : columnFromLeft;
    }

    private final void $$robo$$android_widget_SimpleMonthView$getFocusedRect(Rect r) {
        if (this.mHighlightedDay > 0) {
            this.getBoundsForDay(this.mHighlightedDay, r);
        } else {
            super.getFocusedRect(r);
        }
    }

    private final void $$robo$$android_widget_SimpleMonthView$onFocusLost() {
        if (!this.mIsTouchHighlighted) {
            this.mPreviouslyHighlightedDay = this.mHighlightedDay;
            this.mHighlightedDay = -1;
            this.invalidate();
        }
        super.onFocusLost();
    }

    private final void $$robo$$android_widget_SimpleMonthView$ensureFocusedDay() {
        if (this.mHighlightedDay != -1) {
            return;
        }
        if (this.mPreviouslyHighlightedDay != -1) {
            this.mHighlightedDay = this.mPreviouslyHighlightedDay;
            return;
        }
        if (this.mActivatedDay != -1) {
            this.mHighlightedDay = this.mActivatedDay;
            return;
        }
        this.mHighlightedDay = 1;
    }

    private final boolean $$robo$$android_widget_SimpleMonthView$isFirstDayOfWeek(int day) {
        int offset = this.findDayOffset();
        return (offset + day - 1) % 7 == 0;
    }

    private final boolean $$robo$$android_widget_SimpleMonthView$isLastDayOfWeek(int day) {
        int offset = this.findDayOffset();
        return (offset + day) % 7 == 0;
    }

    private final void $$robo$$android_widget_SimpleMonthView$onDraw(Canvas canvas) {
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        canvas.translate(paddingLeft, paddingTop);
        this.drawMonth(canvas);
        this.drawDaysOfWeek(canvas);
        this.drawDays(canvas);
        canvas.translate(-paddingLeft, -paddingTop);
    }

    private final void $$robo$$android_widget_SimpleMonthView$drawMonth(Canvas canvas) {
        float x = (float)this.mPaddedWidth / 2.0f;
        float lineHeight = this.mMonthPaint.ascent() + this.mMonthPaint.descent();
        float y = ((float)this.mMonthHeight - lineHeight) / 2.0f;
        canvas.drawText(this.mMonthYearLabel, x, y, this.mMonthPaint);
    }

    private final String $$robo$$android_widget_SimpleMonthView$getMonthYearLabel() {
        return this.mMonthYearLabel;
    }

    private final void $$robo$$android_widget_SimpleMonthView$drawDaysOfWeek(Canvas canvas) {
        TextPaint p = this.mDayOfWeekPaint;
        int headerHeight = this.mMonthHeight;
        int rowHeight = this.mDayOfWeekHeight;
        int colWidth = this.mCellWidth;
        float halfLineHeight = (p.ascent() + p.descent()) / 2.0f;
        int rowCenter = headerHeight + rowHeight / 2;
        for (int col = 0; col < 7; ++col) {
            int colCenter = colWidth * col + colWidth / 2;
            int colCenterRtl = this.isLayoutRtl() ? this.mPaddedWidth - colCenter : colCenter;
            String label = this.mDayOfWeekLabels[col];
            canvas.drawText(label, colCenterRtl, (float)rowCenter - halfLineHeight, p);
        }
    }

    private final void $$robo$$android_widget_SimpleMonthView$drawDays(Canvas canvas) {
        TextPaint p = this.mDayPaint;
        int headerHeight = this.mMonthHeight + this.mDayOfWeekHeight;
        int rowHeight = this.mDayHeight;
        int colWidth = this.mCellWidth;
        float halfLineHeight = (p.ascent() + p.descent()) / 2.0f;
        int rowCenter = headerHeight + rowHeight / 2;
        int col = this.findDayOffset();
        for (int day = 1; day <= this.mDaysInMonth; ++day) {
            int dayTextColor;
            boolean isDayToday;
            boolean isDayHighlighted;
            int colCenter = colWidth * col + colWidth / 2;
            int colCenterRtl = this.isLayoutRtl() ? this.mPaddedWidth - colCenter : colCenter;
            int stateMask = 0;
            boolean isDayEnabled = this.isDayEnabled(day);
            if (isDayEnabled) {
                stateMask |= 8;
            }
            boolean isDayActivated = this.mActivatedDay == day;
            boolean bl = isDayHighlighted = this.mHighlightedDay == day;
            if (isDayActivated) {
                stateMask |= 0x20;
                Paint paint = isDayHighlighted ? this.mDayHighlightSelectorPaint : this.mDaySelectorPaint;
                canvas.drawCircle(colCenterRtl, rowCenter, this.mDaySelectorRadius, paint);
            } else if (isDayHighlighted) {
                stateMask |= 0x10;
                if (isDayEnabled) {
                    canvas.drawCircle(colCenterRtl, rowCenter, this.mDaySelectorRadius, this.mDayHighlightPaint);
                }
            }
            boolean bl2 = isDayToday = this.mToday == day;
            if (isDayToday && !isDayActivated) {
                dayTextColor = this.mDaySelectorPaint.getColor();
            } else {
                int[] stateSet = StateSet.get(stateMask);
                dayTextColor = this.mDayTextColor.getColorForState(stateSet, 0);
            }
            p.setColor(dayTextColor);
            canvas.drawText(this.mDayFormatter.format(day), colCenterRtl, (float)rowCenter - halfLineHeight, p);
            if (++col != 7) continue;
            col = 0;
            rowCenter += rowHeight;
        }
    }

    private final boolean $$robo$$android_widget_SimpleMonthView$isDayEnabled(int day) {
        return day >= this.mEnabledDayStart && day <= this.mEnabledDayEnd;
    }

    private final boolean $$robo$$android_widget_SimpleMonthView$isValidDayOfMonth(int day) {
        return day >= 1 && day <= this.mDaysInMonth;
    }

    private static final boolean $$robo$$android_widget_SimpleMonthView$isValidDayOfWeek(int day) {
        return day >= 1 && day <= 7;
    }

    private static final boolean $$robo$$android_widget_SimpleMonthView$isValidMonth(int month) {
        return month >= 0 && month <= 11;
    }

    private final void $$robo$$android_widget_SimpleMonthView$setSelectedDay(int dayOfMonth) {
        this.mActivatedDay = dayOfMonth;
        this.mTouchHelper.invalidateRoot();
        this.invalidate();
    }

    private final void $$robo$$android_widget_SimpleMonthView$setFirstDayOfWeek(int weekStart) {
        this.mWeekStart = SimpleMonthView.isValidDayOfWeek(weekStart) ? weekStart : this.mCalendar.getFirstDayOfWeek();
        this.updateDayOfWeekLabels();
        this.mTouchHelper.invalidateRoot();
        this.invalidate();
    }

    private final void $$robo$$android_widget_SimpleMonthView$setMonthParams(int selectedDay, int month, int year, int weekStart, int enabledDayStart, int enabledDayEnd) {
        this.mActivatedDay = selectedDay;
        if (SimpleMonthView.isValidMonth(month)) {
            this.mMonth = month;
        }
        this.mYear = year;
        this.mCalendar.set(2, this.mMonth);
        this.mCalendar.set(1, this.mYear);
        this.mCalendar.set(5, 1);
        this.mDayOfWeekStart = this.mCalendar.get(7);
        this.mWeekStart = SimpleMonthView.isValidDayOfWeek(weekStart) ? weekStart : this.mCalendar.getFirstDayOfWeek();
        Calendar today = Calendar.getInstance();
        this.mToday = -1;
        this.mDaysInMonth = SimpleMonthView.getDaysInMonth(this.mMonth, this.mYear);
        for (int i = 0; i < this.mDaysInMonth; ++i) {
            int day = i + 1;
            if (!this.sameDay(day, today)) continue;
            this.mToday = day;
        }
        this.mEnabledDayStart = MathUtils.constrain(enabledDayStart, 1, this.mDaysInMonth);
        this.mEnabledDayEnd = MathUtils.constrain(enabledDayEnd, this.mEnabledDayStart, this.mDaysInMonth);
        this.updateMonthYearLabel();
        this.updateDayOfWeekLabels();
        this.mTouchHelper.invalidateRoot();
        this.invalidate();
    }

    private static final int $$robo$$android_widget_SimpleMonthView$getDaysInMonth(int month, int year) {
        switch (month) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return 31;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
            case 1: {
                return year % 4 == 0 ? 29 : 28;
            }
        }
        throw new IllegalArgumentException("Invalid Month");
    }

    private final boolean $$robo$$android_widget_SimpleMonthView$sameDay(int day, Calendar today) {
        return this.mYear == today.get(1) && this.mMonth == today.get(2) && day == today.get(5);
    }

    private final void $$robo$$android_widget_SimpleMonthView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int preferredHeight = this.mDesiredDayHeight * 6 + this.mDesiredDayOfWeekHeight + this.mDesiredMonthHeight + this.getPaddingTop() + this.getPaddingBottom();
        int preferredWidth = this.mDesiredCellWidth * 7 + this.getPaddingStart() + this.getPaddingEnd();
        int resolvedWidth = SimpleMonthView.resolveSize(preferredWidth, widthMeasureSpec);
        int resolvedHeight = SimpleMonthView.resolveSize(preferredHeight, heightMeasureSpec);
        this.setMeasuredDimension(resolvedWidth, resolvedHeight);
    }

    private final void $$robo$$android_widget_SimpleMonthView$onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        this.requestLayout();
    }

    private final void $$robo$$android_widget_SimpleMonthView$onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (!changed) {
            return;
        }
        int w = right - left;
        int h = bottom - top;
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingRight = this.getPaddingRight();
        int paddingBottom = this.getPaddingBottom();
        int paddedRight = w - paddingRight;
        int paddedBottom = h - paddingBottom;
        int paddedWidth = paddedRight - paddingLeft;
        int paddedHeight = paddedBottom - paddingTop;
        if (paddedWidth == this.mPaddedWidth || paddedHeight == this.mPaddedHeight) {
            return;
        }
        this.mPaddedWidth = paddedWidth;
        this.mPaddedHeight = paddedHeight;
        int measuredPaddedHeight = this.getMeasuredHeight() - paddingTop - paddingBottom;
        float scaleH = (float)paddedHeight / (float)measuredPaddedHeight;
        int monthHeight = (int)((float)this.mDesiredMonthHeight * scaleH);
        int cellWidth = this.mPaddedWidth / 7;
        this.mMonthHeight = monthHeight;
        this.mDayOfWeekHeight = (int)((float)this.mDesiredDayOfWeekHeight * scaleH);
        this.mDayHeight = (int)((float)this.mDesiredDayHeight * scaleH);
        this.mCellWidth = cellWidth;
        int maxSelectorWidth = cellWidth / 2 + Math.min(paddingLeft, paddingRight);
        int maxSelectorHeight = this.mDayHeight / 2 + paddingBottom;
        this.mDaySelectorRadius = Math.min(this.mDesiredDaySelectorRadius, Math.min(maxSelectorWidth, maxSelectorHeight));
        this.mTouchHelper.invalidateRoot();
    }

    private final int $$robo$$android_widget_SimpleMonthView$findDayOffset() {
        int offset = this.mDayOfWeekStart - this.mWeekStart;
        if (this.mDayOfWeekStart < this.mWeekStart) {
            return offset + 7;
        }
        return offset;
    }

    private final int $$robo$$android_widget_SimpleMonthView$getDayAtLocation(int x, int y) {
        int row;
        int paddedX = x - this.getPaddingLeft();
        if (paddedX < 0 || paddedX >= this.mPaddedWidth) {
            return -1;
        }
        int headerHeight = this.mMonthHeight + this.mDayOfWeekHeight;
        int paddedY = y - this.getPaddingTop();
        if (paddedY < headerHeight || paddedY >= this.mPaddedHeight) {
            return -1;
        }
        int paddedXRtl = this.isLayoutRtl() ? this.mPaddedWidth - paddedX : paddedX;
        int col = paddedXRtl * 7 / this.mPaddedWidth;
        int index = col + (row = (paddedY - headerHeight) / this.mDayHeight) * 7;
        int day = index + 1 - this.findDayOffset();
        if (!this.isValidDayOfMonth(day)) {
            return -1;
        }
        return day;
    }

    private final boolean $$robo$$android_widget_SimpleMonthView$getBoundsForDay(int id2, Rect outBounds) {
        if (!this.isValidDayOfMonth(id2)) {
            return false;
        }
        int index = id2 - 1 + this.findDayOffset();
        int col = index % 7;
        int colWidth = this.mCellWidth;
        int left = this.isLayoutRtl() ? this.getWidth() - this.getPaddingRight() - (col + 1) * colWidth : this.getPaddingLeft() + col * colWidth;
        int row = index / 7;
        int rowHeight = this.mDayHeight;
        int headerHeight = this.mMonthHeight + this.mDayOfWeekHeight;
        int top = this.getPaddingTop() + headerHeight + row * rowHeight;
        outBounds.set(left, top, left + colWidth, top + rowHeight);
        return true;
    }

    private final boolean $$robo$$android_widget_SimpleMonthView$onDayClicked(int day) {
        if (!this.isValidDayOfMonth(day) || !this.isDayEnabled(day)) {
            return false;
        }
        if (this.mOnDayClickListener != null) {
            Calendar date = Calendar.getInstance();
            date.set(this.mYear, this.mMonth, day);
            this.mOnDayClickListener.onDayClick(this, date);
        }
        this.mTouchHelper.sendEventForVirtualView(day, 1);
        return true;
    }

    private final PointerIcon $$robo$$android_widget_SimpleMonthView$onResolvePointerIcon(MotionEvent event, int pointerIndex) {
        int y;
        if (!this.isEnabled()) {
            return null;
        }
        int x = (int)(event.getX() + 0.5f);
        int dayUnderPointer = this.getDayAtLocation(x, y = (int)(event.getY() + 0.5f));
        if (dayUnderPointer >= 0) {
            return PointerIcon.getSystemIcon(this.getContext(), 1002);
        }
        return super.onResolvePointerIcon(event, pointerIndex);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_SimpleMonthView$__constructor__(context);
    }

    public SimpleMonthView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SimpleMonthView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_SimpleMonthView$__constructor__(context, attributeSet);
    }

    public SimpleMonthView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843612);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SimpleMonthView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_SimpleMonthView$__constructor__(context, attributeSet, n);
    }

    public SimpleMonthView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SimpleMonthView$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_SimpleMonthView$__constructor__(context, attributeSet, n, n2);
    }

    public SimpleMonthView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SimpleMonthView$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    private void updateMonthYearLabel() {
        InvokeDynamicSupport.bootstrap("updateMonthYearLabel", $$robo$$android_widget_SimpleMonthView$updateMonthYearLabel(), 0, this);
    }

    private void updateDayOfWeekLabels() {
        InvokeDynamicSupport.bootstrap("updateDayOfWeekLabels", $$robo$$android_widget_SimpleMonthView$updateDayOfWeekLabels(), 0, this);
    }

    private ColorStateList applyTextAppearance(Paint paint, int n) {
        return InvokeDynamicSupport.bootstrap("applyTextAppearance", $$robo$$android_widget_SimpleMonthView$applyTextAppearance(android.graphics.Paint int ), 0, this, paint, n);
    }

    public int getMonthHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getMonthHeight", $$robo$$android_widget_SimpleMonthView$getMonthHeight(), 0, this);
    }

    public int getCellWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getCellWidth", $$robo$$android_widget_SimpleMonthView$getCellWidth(), 0, this);
    }

    public void setMonthTextAppearance(int n) {
        InvokeDynamicSupport.bootstrap("setMonthTextAppearance", $$robo$$android_widget_SimpleMonthView$setMonthTextAppearance(int ), 0, this, n);
    }

    public void setDayOfWeekTextAppearance(int n) {
        InvokeDynamicSupport.bootstrap("setDayOfWeekTextAppearance", $$robo$$android_widget_SimpleMonthView$setDayOfWeekTextAppearance(int ), 0, this, n);
    }

    public void setDayTextAppearance(int n) {
        InvokeDynamicSupport.bootstrap("setDayTextAppearance", $$robo$$android_widget_SimpleMonthView$setDayTextAppearance(int ), 0, this, n);
    }

    private void initPaints(Resources resources) {
        InvokeDynamicSupport.bootstrap("initPaints", $$robo$$android_widget_SimpleMonthView$initPaints(android.content.res.Resources ), 0, this, resources);
    }

    void setMonthTextColor(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setMonthTextColor", $$robo$$android_widget_SimpleMonthView$setMonthTextColor(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    void setDayOfWeekTextColor(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setDayOfWeekTextColor", $$robo$$android_widget_SimpleMonthView$setDayOfWeekTextColor(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    void setDayTextColor(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setDayTextColor", $$robo$$android_widget_SimpleMonthView$setDayTextColor(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    void setDaySelectorColor(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setDaySelectorColor", $$robo$$android_widget_SimpleMonthView$setDaySelectorColor(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    void setDayHighlightColor(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setDayHighlightColor", $$robo$$android_widget_SimpleMonthView$setDayHighlightColor(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    public void setOnDayClickListener(OnDayClickListener onDayClickListener) {
        InvokeDynamicSupport.bootstrap("setOnDayClickListener", $$robo$$android_widget_SimpleMonthView$setOnDayClickListener(android.widget.SimpleMonthView$OnDayClickListener ), 0, this, onDayClickListener);
    }

    @Override
    public boolean dispatchHoverEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchHoverEvent", $$robo$$android_widget_SimpleMonthView$dispatchHoverEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_widget_SimpleMonthView$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyDown", $$robo$$android_widget_SimpleMonthView$onKeyDown(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    private boolean moveOneDay(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("moveOneDay", $$robo$$android_widget_SimpleMonthView$moveOneDay(boolean ), 0, this, bl);
    }

    @Override
    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        InvokeDynamicSupport.bootstrap("onFocusChanged", $$robo$$android_widget_SimpleMonthView$onFocusChanged(boolean int android.graphics.Rect ), 0, this, bl, n, rect);
    }

    private int findClosestRow(Rect rect) {
        return (int)InvokeDynamicSupport.bootstrap("findClosestRow", $$robo$$android_widget_SimpleMonthView$findClosestRow(android.graphics.Rect ), 0, this, rect);
    }

    private int findClosestColumn(Rect rect) {
        return (int)InvokeDynamicSupport.bootstrap("findClosestColumn", $$robo$$android_widget_SimpleMonthView$findClosestColumn(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public void getFocusedRect(Rect rect) {
        InvokeDynamicSupport.bootstrap("getFocusedRect", $$robo$$android_widget_SimpleMonthView$getFocusedRect(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    protected void onFocusLost() {
        InvokeDynamicSupport.bootstrap("onFocusLost", $$robo$$android_widget_SimpleMonthView$onFocusLost(), 0, this);
    }

    private void ensureFocusedDay() {
        InvokeDynamicSupport.bootstrap("ensureFocusedDay", $$robo$$android_widget_SimpleMonthView$ensureFocusedDay(), 0, this);
    }

    private boolean isFirstDayOfWeek(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isFirstDayOfWeek", $$robo$$android_widget_SimpleMonthView$isFirstDayOfWeek(int ), 0, this, n);
    }

    private boolean isLastDayOfWeek(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isLastDayOfWeek", $$robo$$android_widget_SimpleMonthView$isLastDayOfWeek(int ), 0, this, n);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$android_widget_SimpleMonthView$onDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    private void drawMonth(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("drawMonth", $$robo$$android_widget_SimpleMonthView$drawMonth(android.graphics.Canvas ), 0, this, canvas);
    }

    public String getMonthYearLabel() {
        return InvokeDynamicSupport.bootstrap("getMonthYearLabel", $$robo$$android_widget_SimpleMonthView$getMonthYearLabel(), 0, this);
    }

    private void drawDaysOfWeek(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("drawDaysOfWeek", $$robo$$android_widget_SimpleMonthView$drawDaysOfWeek(android.graphics.Canvas ), 0, this, canvas);
    }

    private void drawDays(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("drawDays", $$robo$$android_widget_SimpleMonthView$drawDays(android.graphics.Canvas ), 0, this, canvas);
    }

    private boolean isDayEnabled(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDayEnabled", $$robo$$android_widget_SimpleMonthView$isDayEnabled(int ), 0, this, n);
    }

    private boolean isValidDayOfMonth(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValidDayOfMonth", $$robo$$android_widget_SimpleMonthView$isValidDayOfMonth(int ), 0, this, n);
    }

    private static boolean isValidDayOfWeek(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidDayOfWeek", $$robo$$android_widget_SimpleMonthView$isValidDayOfWeek(int ), 0, (int)n);
    }

    private static boolean isValidMonth(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidMonth", $$robo$$android_widget_SimpleMonthView$isValidMonth(int ), 0, (int)n);
    }

    public void setSelectedDay(int n) {
        InvokeDynamicSupport.bootstrap("setSelectedDay", $$robo$$android_widget_SimpleMonthView$setSelectedDay(int ), 0, this, n);
    }

    public void setFirstDayOfWeek(int n) {
        InvokeDynamicSupport.bootstrap("setFirstDayOfWeek", $$robo$$android_widget_SimpleMonthView$setFirstDayOfWeek(int ), 0, this, n);
    }

    void setMonthParams(int n, int n2, int n3, int n4, int n5, int n6) {
        InvokeDynamicSupport.bootstrap("setMonthParams", $$robo$$android_widget_SimpleMonthView$setMonthParams(int int int int int int ), 0, this, n, n2, n3, n4, n5, n6);
    }

    private static int getDaysInMonth(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDaysInMonth", $$robo$$android_widget_SimpleMonthView$getDaysInMonth(int int ), 0, (int)n, (int)n2);
    }

    private boolean sameDay(int n, Calendar calendar) {
        return (boolean)InvokeDynamicSupport.bootstrap("sameDay", $$robo$$android_widget_SimpleMonthView$sameDay(int android.icu.util.Calendar ), 0, this, n, calendar);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_SimpleMonthView$onMeasure(int int ), 0, this, n, n2);
    }

    @Override
    public void onRtlPropertiesChanged(int n) {
        InvokeDynamicSupport.bootstrap("onRtlPropertiesChanged", $$robo$$android_widget_SimpleMonthView$onRtlPropertiesChanged(int ), 0, this, n);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_widget_SimpleMonthView$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    private int findDayOffset() {
        return (int)InvokeDynamicSupport.bootstrap("findDayOffset", $$robo$$android_widget_SimpleMonthView$findDayOffset(), 0, this);
    }

    private int getDayAtLocation(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getDayAtLocation", $$robo$$android_widget_SimpleMonthView$getDayAtLocation(int int ), 0, this, n, n2);
    }

    public boolean getBoundsForDay(int n, Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("getBoundsForDay", $$robo$$android_widget_SimpleMonthView$getBoundsForDay(int android.graphics.Rect ), 0, this, n, rect);
    }

    private boolean onDayClicked(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onDayClicked", $$robo$$android_widget_SimpleMonthView$onDayClicked(int ), 0, this, n);
    }

    @Override
    public PointerIcon onResolvePointerIcon(MotionEvent motionEvent, int n) {
        return InvokeDynamicSupport.bootstrap("onResolvePointerIcon", $$robo$$android_widget_SimpleMonthView$onResolvePointerIcon(android.view.MotionEvent int ), 0, this, motionEvent, n);
    }

    public /* synthetic */ SimpleMonthView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SimpleMonthView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface OnDayClickListener
    extends InstrumentedInterface {
        public void onDayClick(SimpleMonthView var1, Calendar var2);
    }

    private class MonthViewTouchHelper
    extends ExploreByTouchHelper
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String DATE_FORMAT = "dd MMMM yyyy";
        private Rect mTempRect;
        private Calendar mTempCalendar;
        /* synthetic */ SimpleMonthView this$0;

        private void $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$__constructor__(SimpleMonthView simpleMonthView, View host) {
            this.mTempRect = new Rect();
            this.mTempCalendar = Calendar.getInstance();
        }

        private final int $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$getVirtualViewAt(float x, float y) {
            int day = this.this$0.getDayAtLocation((int)(x + 0.5f), (int)(y + 0.5f));
            if (day != -1) {
                return day;
            }
            return Integer.MIN_VALUE;
        }

        private final void $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$getVisibleVirtualViews(IntArray virtualViewIds) {
            for (int day = 1; day <= this.this$0.mDaysInMonth; ++day) {
                virtualViewIds.add(day);
            }
        }

        private final void $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$onPopulateEventForVirtualView(int virtualViewId, AccessibilityEvent event) {
            event.setContentDescription(this.getDayDescription(virtualViewId));
        }

        private final void $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$onPopulateNodeForVirtualView(int virtualViewId, AccessibilityNodeInfo node) {
            boolean hasBounds = this.this$0.getBoundsForDay(virtualViewId, this.mTempRect);
            if (!hasBounds) {
                this.mTempRect.setEmpty();
                node.setContentDescription("");
                node.setBoundsInParent(this.mTempRect);
                node.setVisibleToUser(false);
                return;
            }
            node.setText(this.getDayText(virtualViewId));
            node.setContentDescription(this.getDayDescription(virtualViewId));
            node.setBoundsInParent(this.mTempRect);
            boolean isDayEnabled = this.this$0.isDayEnabled(virtualViewId);
            if (isDayEnabled) {
                node.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_CLICK);
            }
            node.setEnabled(isDayEnabled);
            if (virtualViewId == this.this$0.mActivatedDay) {
                node.setChecked(true);
            }
        }

        private final boolean $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$onPerformActionForVirtualView(int virtualViewId, int action, Bundle arguments) {
            switch (action) {
                case 16: {
                    return this.this$0.onDayClicked(virtualViewId);
                }
            }
            return false;
        }

        private final CharSequence $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$getDayDescription(int id2) {
            if (this.this$0.isValidDayOfMonth(id2)) {
                this.mTempCalendar.set(this.this$0.mYear, this.this$0.mMonth, id2);
                return DateFormat.format((CharSequence)"dd MMMM yyyy", this.mTempCalendar.getTimeInMillis());
            }
            return "";
        }

        private final CharSequence $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$getDayText(int id2) {
            if (this.this$0.isValidDayOfMonth(id2)) {
                return this.this$0.mDayFormatter.format(id2);
            }
            return null;
        }

        private void __constructor__(SimpleMonthView simpleMonthView, View view) {
            this.$$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$__constructor__(simpleMonthView, view);
        }

        public MonthViewTouchHelper(SimpleMonthView simpleMonthView, View view) {
            this.this$0 = simpleMonthView;
            super(view);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$__constructor__(android.widget.SimpleMonthView android.view.View ), 0, this, simpleMonthView, view);
        }

        @Override
        protected int getVirtualViewAt(float f, float f2) {
            return (int)InvokeDynamicSupport.bootstrap("getVirtualViewAt", $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$getVirtualViewAt(float float ), 0, this, f, f2);
        }

        @Override
        protected void getVisibleVirtualViews(IntArray intArray) {
            InvokeDynamicSupport.bootstrap("getVisibleVirtualViews", $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$getVisibleVirtualViews(android.util.IntArray ), 0, this, intArray);
        }

        @Override
        protected void onPopulateEventForVirtualView(int n, AccessibilityEvent accessibilityEvent) {
            InvokeDynamicSupport.bootstrap("onPopulateEventForVirtualView", $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$onPopulateEventForVirtualView(int android.view.accessibility.AccessibilityEvent ), 0, this, n, accessibilityEvent);
        }

        @Override
        protected void onPopulateNodeForVirtualView(int n, AccessibilityNodeInfo accessibilityNodeInfo) {
            InvokeDynamicSupport.bootstrap("onPopulateNodeForVirtualView", $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$onPopulateNodeForVirtualView(int android.view.accessibility.AccessibilityNodeInfo ), 0, this, n, accessibilityNodeInfo);
        }

        @Override
        protected boolean onPerformActionForVirtualView(int n, int n2, Bundle bundle) {
            return (boolean)InvokeDynamicSupport.bootstrap("onPerformActionForVirtualView", $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$onPerformActionForVirtualView(int int android.os.Bundle ), 0, this, n, n2, bundle);
        }

        private CharSequence getDayDescription(int n) {
            return InvokeDynamicSupport.bootstrap("getDayDescription", $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$getDayDescription(int ), 0, this, n);
        }

        private CharSequence getDayText(int n) {
            return InvokeDynamicSupport.bootstrap("getDayText", $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$getDayText(int ), 0, this, n);
        }

        public /* synthetic */ MonthViewTouchHelper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MonthViewTouchHelper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

