/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.TableMaskFilter;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.RemotableViewMethod;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.LinearInterpolator;
import android.widget.AdapterViewAnimator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RemoteViews;
import com.android.internal.R;
import java.lang.ref.WeakReference;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@RemoteViews.RemoteView
public class StackView
extends AdapterViewAnimator
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String TAG = "StackView";
    private static int DEFAULT_ANIMATION_DURATION = 400;
    private static int MINIMUM_ANIMATION_DURATION = 50;
    private static int STACK_RELAYOUT_DURATION = 100;
    private static float PERSPECTIVE_SHIFT_FACTOR_Y = 0.1f;
    private static float PERSPECTIVE_SHIFT_FACTOR_X = 0.1f;
    private float mPerspectiveShiftX;
    private float mPerspectiveShiftY;
    private float mNewPerspectiveShiftX;
    private float mNewPerspectiveShiftY;
    private static float PERSPECTIVE_SCALE_FACTOR = 0.0f;
    private static int ITEMS_SLIDE_UP = 0;
    private static int ITEMS_SLIDE_DOWN = 1;
    private static int GESTURE_NONE = 0;
    private static int GESTURE_SLIDE_UP = 1;
    private static int GESTURE_SLIDE_DOWN = 2;
    private static float SWIPE_THRESHOLD_RATIO = 0.2f;
    private static float SLIDE_UP_RATIO = 0.7f;
    private static int INVALID_POINTER = -1;
    private static int NUM_ACTIVE_VIEWS = 5;
    private static int FRAME_PADDING = 4;
    private Rect mTouchRect;
    private static int MIN_TIME_BETWEEN_INTERACTION_AND_AUTOADVANCE = 5000;
    private static long MIN_TIME_BETWEEN_SCROLLS = 100L;
    private float mInitialY;
    private float mInitialX;
    private int mActivePointerId;
    private int mYVelocity;
    private int mSwipeGestureType;
    private int mSlideAmount;
    private int mSwipeThreshold;
    private int mTouchSlop;
    private int mMaximumVelocity;
    private VelocityTracker mVelocityTracker;
    private boolean mTransitionIsSetup;
    private int mResOutColor;
    private int mClickColor;
    private static HolographicHelper sHolographicHelper;
    private ImageView mHighlight;
    private ImageView mClickFeedback;
    private boolean mClickFeedbackIsValid;
    private StackSlider mStackSlider;
    private boolean mFirstLayoutHappened;
    private long mLastInteractionTime;
    private long mLastScrollTime;
    private int mStackMode;
    private int mFramePadding;
    private Rect stackInvalidateRect;

    private void $$robo$$android_widget_StackView$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_StackView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_StackView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_StackView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.TAG = "StackView";
        this.mTouchRect = new Rect();
        this.mYVelocity = 0;
        this.mSwipeGestureType = 0;
        this.mTransitionIsSetup = false;
        this.mClickFeedbackIsValid = false;
        this.mFirstLayoutHappened = false;
        this.mLastInteractionTime = 0L;
        this.stackInvalidateRect = new Rect();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.StackView, defStyleAttr, defStyleRes);
        this.mResOutColor = a.getColor(1, 0);
        this.mClickColor = a.getColor(0, 0);
        a.recycle();
        this.initStackView();
    }

    private final void $$robo$$android_widget_StackView$initStackView() {
        this.configureViewAnimator(5, 1);
        this.setStaticTransformationsEnabled(true);
        ViewConfiguration configuration = ViewConfiguration.get(this.getContext());
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mActivePointerId = -1;
        this.mHighlight = new ImageView(this.getContext());
        this.mHighlight.setLayoutParams(new LayoutParams(this, this.mHighlight));
        this.addViewInLayout(this.mHighlight, -1, new LayoutParams(this, this.mHighlight));
        this.mClickFeedback = new ImageView(this.getContext());
        this.mClickFeedback.setLayoutParams(new LayoutParams(this, this.mClickFeedback));
        this.addViewInLayout(this.mClickFeedback, -1, new LayoutParams(this, this.mClickFeedback));
        this.mClickFeedback.setVisibility(4);
        this.mStackSlider = new StackSlider(this);
        if (sHolographicHelper == null) {
            sHolographicHelper = new HolographicHelper(this.mContext);
        }
        this.setClipChildren(false);
        this.setClipToPadding(false);
        this.mStackMode = 1;
        this.mWhichChild = -1;
        float density = this.mContext.getResources().getDisplayMetrics().density;
        this.mFramePadding = (int)Math.ceil(density * 4.0f);
    }

    private final void $$robo$$android_widget_StackView$transformViewForTransition(int fromIndex, int toIndex, View view, boolean animate) {
        LayoutParams lp;
        if (!animate) {
            ((StackFrame)view).cancelSliderAnimator();
            view.setRotationX(0.0f);
            lp = (LayoutParams)view.getLayoutParams();
            lp.setVerticalOffset(0);
            lp.setHorizontalOffset(0);
        }
        if (fromIndex == -1 && toIndex == this.getNumActiveViews() - 1) {
            this.transformViewAtIndex(toIndex, view, false);
            view.setVisibility(0);
            view.setAlpha(1.0f);
        } else if (fromIndex == 0 && toIndex == 1) {
            ((StackFrame)view).cancelSliderAnimator();
            view.setVisibility(0);
            int duration = Math.round(this.mStackSlider.getDurationForNeutralPosition(this.mYVelocity));
            StackSlider animationSlider = new StackSlider(this, this.mStackSlider);
            animationSlider.setView(view);
            if (animate) {
                PropertyValuesHolder slideInY = PropertyValuesHolder.ofFloat("YProgress", 0.0f);
                PropertyValuesHolder slideInX = PropertyValuesHolder.ofFloat("XProgress", 0.0f);
                ObjectAnimator slideIn = ObjectAnimator.ofPropertyValuesHolder(animationSlider, slideInX, slideInY);
                slideIn.setDuration(duration);
                slideIn.setInterpolator(new LinearInterpolator());
                ((StackFrame)view).setSliderAnimator(slideIn);
                slideIn.start();
            } else {
                animationSlider.setYProgress(0.0f);
                animationSlider.setXProgress(0.0f);
            }
        } else if (fromIndex == 1 && toIndex == 0) {
            ((StackFrame)view).cancelSliderAnimator();
            int duration = Math.round(this.mStackSlider.getDurationForOffscreenPosition(this.mYVelocity));
            StackSlider animationSlider = new StackSlider(this, this.mStackSlider);
            animationSlider.setView(view);
            if (animate) {
                PropertyValuesHolder slideOutY = PropertyValuesHolder.ofFloat("YProgress", 1.0f);
                PropertyValuesHolder slideOutX = PropertyValuesHolder.ofFloat("XProgress", 0.0f);
                ObjectAnimator slideOut = ObjectAnimator.ofPropertyValuesHolder(animationSlider, slideOutX, slideOutY);
                slideOut.setDuration(duration);
                slideOut.setInterpolator(new LinearInterpolator());
                ((StackFrame)view).setSliderAnimator(slideOut);
                slideOut.start();
            } else {
                animationSlider.setYProgress(1.0f);
                animationSlider.setXProgress(0.0f);
            }
        } else if (toIndex == 0) {
            view.setAlpha(0.0f);
            view.setVisibility(4);
        } else if ((fromIndex == 0 || fromIndex == 1) && toIndex > 1) {
            view.setVisibility(0);
            view.setAlpha(1.0f);
            view.setRotationX(0.0f);
            lp = (LayoutParams)view.getLayoutParams();
            lp.setVerticalOffset(0);
            lp.setHorizontalOffset(0);
        } else if (fromIndex == -1) {
            view.setAlpha(1.0f);
            view.setVisibility(0);
        } else if (toIndex == -1) {
            if (animate) {
                this.postDelayed(new Runnable(this, view){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ View val$view;
                    /* synthetic */ StackView this$0;

                    private void $$robo$$android_widget_StackView_1$__constructor__(StackView this$0, View view) {
                    }

                    private final void $$robo$$android_widget_StackView_1$run() {
                        this.val$view.setAlpha(0.0f);
                    }

                    private void __constructor__(StackView stackView, View view) {
                        this.$$robo$$android_widget_StackView_1$__constructor__(stackView, view);
                    }
                    {
                        this.this$0 = stackView;
                        this.val$view = view;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_StackView_1$__constructor__(android.widget.StackView android.view.View ), 0, this, stackView, view);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_StackView_1$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                }, 100L);
            } else {
                view.setAlpha(0.0f);
            }
        }
        if (toIndex != -1) {
            this.transformViewAtIndex(toIndex, view, animate);
        }
    }

    private final void $$robo$$android_widget_StackView$transformViewAtIndex(int index, View view, boolean animate) {
        float maxPerspectiveShiftY = this.mPerspectiveShiftY;
        float maxPerspectiveShiftX = this.mPerspectiveShiftX;
        if (this.mStackMode == 1) {
            if ((index = this.mMaxNumActiveViews - index - 1) == this.mMaxNumActiveViews - 1) {
                --index;
            }
        } else if (--index < 0) {
            ++index;
        }
        float r = (float)index * 1.0f / (float)(this.mMaxNumActiveViews - 2);
        float scale = 1.0f - 0.0f * (1.0f - r);
        float perspectiveTranslationY = r * maxPerspectiveShiftY;
        float scaleShiftCorrectionY = (scale - 1.0f) * ((float)this.getMeasuredHeight() * 0.9f / 2.0f);
        float transY = perspectiveTranslationY + scaleShiftCorrectionY;
        float perspectiveTranslationX = (1.0f - r) * maxPerspectiveShiftX;
        float scaleShiftCorrectionX = (1.0f - scale) * ((float)this.getMeasuredWidth() * 0.9f / 2.0f);
        float transX = perspectiveTranslationX + scaleShiftCorrectionX;
        if (view instanceof StackFrame) {
            ((StackFrame)view).cancelTransformAnimator();
        }
        if (animate) {
            PropertyValuesHolder translationX = PropertyValuesHolder.ofFloat("translationX", transX);
            PropertyValuesHolder translationY = PropertyValuesHolder.ofFloat("translationY", transY);
            PropertyValuesHolder scalePropX = PropertyValuesHolder.ofFloat("scaleX", scale);
            PropertyValuesHolder scalePropY = PropertyValuesHolder.ofFloat("scaleY", scale);
            ObjectAnimator oa = ObjectAnimator.ofPropertyValuesHolder(view, scalePropX, scalePropY, translationY, translationX);
            oa.setDuration(100L);
            if (view instanceof StackFrame) {
                ((StackFrame)view).setTransformAnimator(oa);
            }
            oa.start();
        } else {
            view.setTranslationX(transX);
            view.setTranslationY(transY);
            view.setScaleX(scale);
            view.setScaleY(scale);
        }
    }

    private final void $$robo$$android_widget_StackView$setupStackSlider(View v, int mode) {
        this.mStackSlider.setMode(mode);
        if (v != null) {
            this.mHighlight.setImageBitmap(sHolographicHelper.createResOutline(v, this.mResOutColor));
            this.mHighlight.setRotation(v.getRotation());
            this.mHighlight.setTranslationY(v.getTranslationY());
            this.mHighlight.setTranslationX(v.getTranslationX());
            this.mHighlight.bringToFront();
            v.bringToFront();
            this.mStackSlider.setView(v);
            v.setVisibility(0);
        }
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_StackView$showNext() {
        View v;
        if (this.mSwipeGestureType != 0) {
            return;
        }
        if (!this.mTransitionIsSetup && (v = this.getViewAtRelativeIndex(1)) != null) {
            this.setupStackSlider(v, 0);
            this.mStackSlider.setYProgress(0.0f);
            this.mStackSlider.setXProgress(0.0f);
        }
        super.showNext();
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_StackView$showPrevious() {
        View v;
        if (this.mSwipeGestureType != 0) {
            return;
        }
        if (!this.mTransitionIsSetup && (v = this.getViewAtRelativeIndex(0)) != null) {
            this.setupStackSlider(v, 0);
            this.mStackSlider.setYProgress(1.0f);
            this.mStackSlider.setXProgress(0.0f);
        }
        super.showPrevious();
    }

    private final void $$robo$$android_widget_StackView$showOnly(int childIndex, boolean animate) {
        super.showOnly(childIndex, animate);
        for (int i = this.mCurrentWindowEnd; i >= this.mCurrentWindowStart; --i) {
            View v;
            int index = this.modulo(i, this.getWindowSize());
            AdapterViewAnimator.ViewAndMetaData vm = (AdapterViewAnimator.ViewAndMetaData)this.mViewsMap.get(index);
            if (vm == null || (v = ((AdapterViewAnimator.ViewAndMetaData)this.mViewsMap.get((Object)Integer.valueOf((int)index))).view) == null) continue;
            v.bringToFront();
        }
        if (this.mHighlight != null) {
            this.mHighlight.bringToFront();
        }
        this.mTransitionIsSetup = false;
        this.mClickFeedbackIsValid = false;
    }

    private final void $$robo$$android_widget_StackView$updateClickFeedback() {
        if (!this.mClickFeedbackIsValid) {
            View v = this.getViewAtRelativeIndex(1);
            if (v != null) {
                this.mClickFeedback.setImageBitmap(sHolographicHelper.createClickOutline(v, this.mClickColor));
                this.mClickFeedback.setTranslationX(v.getTranslationX());
                this.mClickFeedback.setTranslationY(v.getTranslationY());
            }
            this.mClickFeedbackIsValid = true;
        }
    }

    private final void $$robo$$android_widget_StackView$showTapFeedback(View v) {
        this.updateClickFeedback();
        this.mClickFeedback.setVisibility(0);
        this.mClickFeedback.bringToFront();
        this.invalidate();
    }

    private final void $$robo$$android_widget_StackView$hideTapFeedback(View v) {
        this.mClickFeedback.setVisibility(4);
        this.invalidate();
    }

    private final void $$robo$$android_widget_StackView$updateChildTransforms() {
        for (int i = 0; i < this.getNumActiveViews(); ++i) {
            View v = this.getViewAtRelativeIndex(i);
            if (v == null) continue;
            this.transformViewAtIndex(i, v, false);
        }
    }

    private final FrameLayout $$robo$$android_widget_StackView$getFrameForChild() {
        StackFrame fl = new StackFrame(this.mContext);
        fl.setPadding(this.mFramePadding, this.mFramePadding, this.mFramePadding, this.mFramePadding);
        return fl;
    }

    private final void $$robo$$android_widget_StackView$applyTransformForChildAtIndex(View child, int relativeIndex) {
    }

    private final void $$robo$$android_widget_StackView$dispatchDraw(Canvas canvas) {
        boolean expandClipRegion = false;
        canvas.getClipBounds(this.stackInvalidateRect);
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Rect childInvalidateRect;
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.horizontalOffset == 0 && lp.verticalOffset == 0 || child.getAlpha() == 0.0f || child.getVisibility() != 0) {
                lp.resetInvalidateRect();
            }
            if ((childInvalidateRect = lp.getInvalidateRect()).isEmpty()) continue;
            expandClipRegion = true;
            this.stackInvalidateRect.union(childInvalidateRect);
        }
        if (expandClipRegion) {
            canvas.save(2);
            canvas.clipRect(this.stackInvalidateRect, Region.Op.UNION);
            super.dispatchDraw(canvas);
            canvas.restore();
        } else {
            super.dispatchDraw(canvas);
        }
    }

    private final void $$robo$$android_widget_StackView$onLayout() {
        int newSlideAmount;
        if (!this.mFirstLayoutHappened) {
            this.mFirstLayoutHappened = true;
            this.updateChildTransforms();
        }
        if (this.mSlideAmount != (newSlideAmount = Math.round(0.7f * (float)this.getMeasuredHeight()))) {
            this.mSlideAmount = newSlideAmount;
            this.mSwipeThreshold = Math.round(0.2f * (float)newSlideAmount);
        }
        if (Float.compare(this.mPerspectiveShiftY, this.mNewPerspectiveShiftY) != 0 || Float.compare(this.mPerspectiveShiftX, this.mNewPerspectiveShiftX) != 0) {
            this.mPerspectiveShiftY = this.mNewPerspectiveShiftY;
            this.mPerspectiveShiftX = this.mNewPerspectiveShiftX;
            this.updateChildTransforms();
        }
    }

    private final boolean $$robo$$android_widget_StackView$onGenericMotionEvent(MotionEvent event) {
        if ((event.getSource() & 2) != 0) {
            switch (event.getAction()) {
                case 8: {
                    float vscroll = event.getAxisValue(9);
                    if (vscroll < 0.0f) {
                        this.pacedScroll(false);
                        return true;
                    }
                    if (!(vscroll > 0.0f)) break;
                    this.pacedScroll(true);
                    return true;
                }
            }
        }
        return super.onGenericMotionEvent(event);
    }

    private final void $$robo$$android_widget_StackView$pacedScroll(boolean up) {
        reference var2_2 = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") - this.mLastScrollTime;
        if (var2_2 > 100L) {
            if (up) {
                this.showPrevious();
            } else {
                this.showNext();
            }
            this.mLastScrollTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        }
    }

    private final boolean $$robo$$android_widget_StackView$onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        switch (action & 0xFF) {
            case 0: {
                if (this.mActivePointerId != -1) break;
                this.mInitialX = ev.getX();
                this.mInitialY = ev.getY();
                this.mActivePointerId = ev.getPointerId(0);
                break;
            }
            case 2: {
                int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                if (pointerIndex == -1) {
                    Log.d("StackView", "Error: No data for our primary pointer.");
                    return false;
                }
                float newY = ev.getY(pointerIndex);
                float deltaY = newY - this.mInitialY;
                this.beginGestureIfNeeded(deltaY);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: 
            case 3: {
                this.mActivePointerId = -1;
                this.mSwipeGestureType = 0;
            }
        }
        return this.mSwipeGestureType != 0;
    }

    private final void $$robo$$android_widget_StackView$beginGestureIfNeeded(float deltaY) {
        if ((int)Math.abs(deltaY) > this.mTouchSlop && this.mSwipeGestureType == 0) {
            int stackMode;
            boolean beginningOfStack;
            int swipeGestureType = deltaY < 0.0f ? 1 : 2;
            this.cancelLongPress();
            this.requestDisallowInterceptTouchEvent(true);
            if (this.mAdapter == null) {
                return;
            }
            int adapterCount = this.getCount();
            int activeIndex = this.mStackMode == 0 ? (swipeGestureType == 2 ? 0 : 1) : (swipeGestureType == 2 ? 1 : 0);
            boolean endOfStack = this.mLoopViews && adapterCount == 1 && (this.mStackMode == 0 && swipeGestureType == 1 || this.mStackMode == 1 && swipeGestureType == 2);
            boolean bl = beginningOfStack = this.mLoopViews && adapterCount == 1 && (this.mStackMode == 1 && swipeGestureType == 1 || this.mStackMode == 0 && swipeGestureType == 2);
            if (this.mLoopViews && !beginningOfStack && !endOfStack) {
                stackMode = 0;
            } else if (this.mCurrentWindowStartUnbounded + activeIndex == -1 || beginningOfStack) {
                ++activeIndex;
                stackMode = 1;
            } else {
                stackMode = this.mCurrentWindowStartUnbounded + activeIndex == adapterCount - 1 || endOfStack ? 2 : 0;
            }
            this.mTransitionIsSetup = stackMode == 0;
            View v = this.getViewAtRelativeIndex(activeIndex);
            if (v == null) {
                return;
            }
            this.setupStackSlider(v, stackMode);
            this.mSwipeGestureType = swipeGestureType;
            this.cancelHandleClick();
        }
    }

    private final boolean $$robo$$android_widget_StackView$onTouchEvent(MotionEvent ev) {
        super.onTouchEvent(ev);
        int action = ev.getAction();
        int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
        if (pointerIndex == -1) {
            Log.d("StackView", "Error: No data for our primary pointer.");
            return false;
        }
        float newY = ev.getY(pointerIndex);
        float newX = ev.getX(pointerIndex);
        float deltaY = newY - this.mInitialY;
        float deltaX = newX - this.mInitialX;
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        switch (action & 0xFF) {
            case 2: {
                this.beginGestureIfNeeded(deltaY);
                float rx = deltaX / ((float)this.mSlideAmount * 1.0f);
                if (this.mSwipeGestureType == 2) {
                    float r = (deltaY - (float)this.mTouchSlop * 1.0f) / (float)this.mSlideAmount * 1.0f;
                    if (this.mStackMode == 1) {
                        r = 1.0f - r;
                    }
                    this.mStackSlider.setYProgress(1.0f - r);
                    this.mStackSlider.setXProgress(rx);
                    return true;
                }
                if (this.mSwipeGestureType != 1) break;
                float r = -(deltaY + (float)this.mTouchSlop * 1.0f) / (float)this.mSlideAmount * 1.0f;
                if (this.mStackMode == 1) {
                    r = 1.0f - r;
                }
                this.mStackSlider.setYProgress(r);
                this.mStackSlider.setXProgress(rx);
                return true;
            }
            case 1: {
                this.handlePointerUp(ev);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 3: {
                this.mActivePointerId = -1;
                this.mSwipeGestureType = 0;
            }
        }
        return true;
    }

    private final void $$robo$$android_widget_StackView$onSecondaryPointerUp(MotionEvent ev) {
        int activePointerIndex = ev.getActionIndex();
        int pointerId = ev.getPointerId(activePointerIndex);
        if (pointerId == this.mActivePointerId) {
            int activeViewIndex = this.mSwipeGestureType == 2 ? 0 : 1;
            View v = this.getViewAtRelativeIndex(activeViewIndex);
            if (v == null) {
                return;
            }
            for (int index = 0; index < ev.getPointerCount(); ++index) {
                if (index == activePointerIndex) continue;
                float x = ev.getX(index);
                float y = ev.getY(index);
                this.mTouchRect.set(v.getLeft(), v.getTop(), v.getRight(), v.getBottom());
                if (!this.mTouchRect.contains(Math.round(x), Math.round(y))) continue;
                float oldX = ev.getX(activePointerIndex);
                float oldY = ev.getY(activePointerIndex);
                this.mInitialY += y - oldY;
                this.mInitialX += x - oldX;
                this.mActivePointerId = ev.getPointerId(index);
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.clear();
                }
                return;
            }
            this.handlePointerUp(ev);
        }
    }

    private final void $$robo$$android_widget_StackView$handlePointerUp(MotionEvent ev) {
        int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
        float newY = ev.getY(pointerIndex);
        int deltaY = (int)(newY - this.mInitialY);
        this.mLastInteractionTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
            this.mYVelocity = (int)this.mVelocityTracker.getYVelocity(this.mActivePointerId);
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
        if (deltaY > this.mSwipeThreshold && this.mSwipeGestureType == 2 && this.mStackSlider.mMode == 0) {
            this.mSwipeGestureType = 0;
            if (this.mStackMode == 0) {
                this.showPrevious();
            } else {
                this.showNext();
            }
            this.mHighlight.bringToFront();
        } else if (deltaY < -this.mSwipeThreshold && this.mSwipeGestureType == 1 && this.mStackSlider.mMode == 0) {
            this.mSwipeGestureType = 0;
            if (this.mStackMode == 0) {
                this.showNext();
            } else {
                this.showPrevious();
            }
            this.mHighlight.bringToFront();
        } else if (this.mSwipeGestureType == 1) {
            float finalYProgress = this.mStackMode == 1 ? 1.0f : 0.0f;
            int duration = this.mStackMode == 0 || this.mStackSlider.mMode != 0 ? Math.round(this.mStackSlider.getDurationForNeutralPosition()) : Math.round(this.mStackSlider.getDurationForOffscreenPosition());
            StackSlider animationSlider = new StackSlider(this, this.mStackSlider);
            PropertyValuesHolder snapBackY = PropertyValuesHolder.ofFloat("YProgress", finalYProgress);
            PropertyValuesHolder snapBackX = PropertyValuesHolder.ofFloat("XProgress", 0.0f);
            ObjectAnimator pa = ObjectAnimator.ofPropertyValuesHolder(animationSlider, snapBackX, snapBackY);
            pa.setDuration(duration);
            pa.setInterpolator(new LinearInterpolator());
            pa.start();
        } else if (this.mSwipeGestureType == 2) {
            float finalYProgress = this.mStackMode == 1 ? 0.0f : 1.0f;
            int duration = this.mStackMode == 1 || this.mStackSlider.mMode != 0 ? Math.round(this.mStackSlider.getDurationForNeutralPosition()) : Math.round(this.mStackSlider.getDurationForOffscreenPosition());
            StackSlider animationSlider = new StackSlider(this, this.mStackSlider);
            PropertyValuesHolder snapBackY = PropertyValuesHolder.ofFloat("YProgress", finalYProgress);
            PropertyValuesHolder snapBackX = PropertyValuesHolder.ofFloat("XProgress", 0.0f);
            ObjectAnimator pa = ObjectAnimator.ofPropertyValuesHolder(animationSlider, snapBackX, snapBackY);
            pa.setDuration(duration);
            pa.start();
        }
        this.mActivePointerId = -1;
        this.mSwipeGestureType = 0;
    }

    private final LayoutParams $$robo$$android_widget_StackView$createOrReuseLayoutParams(View v) {
        ViewGroup.LayoutParams currentLp = v.getLayoutParams();
        if (currentLp instanceof LayoutParams) {
            LayoutParams lp = (LayoutParams)currentLp;
            lp.setHorizontalOffset(0);
            lp.setVerticalOffset(0);
            lp.width = 0;
            lp.width = 0;
            return lp;
        }
        return new LayoutParams(this, v);
    }

    private final void $$robo$$android_widget_StackView$onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.checkForAndHandleDataChanged();
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            int childRight = this.mPaddingLeft + child.getMeasuredWidth();
            int childBottom = this.mPaddingTop + child.getMeasuredHeight();
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            child.layout(this.mPaddingLeft + lp.horizontalOffset, this.mPaddingTop + lp.verticalOffset, childRight + lp.horizontalOffset, childBottom + lp.verticalOffset);
        }
        this.onLayout();
    }

    private final void $$robo$$android_widget_StackView$advance() {
        reference var1_1 = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") - this.mLastInteractionTime;
        if (this.mAdapter == null) {
            return;
        }
        int adapterCount = this.getCount();
        if (adapterCount == 1 && this.mLoopViews) {
            return;
        }
        if (this.mSwipeGestureType == 0 && var1_1 > 5000L) {
            this.showNext();
        }
    }

    private final void $$robo$$android_widget_StackView$measureChildren() {
        int count = this.getChildCount();
        int measuredWidth = this.getMeasuredWidth();
        int measuredHeight = this.getMeasuredHeight();
        int childWidth = Math.round((float)measuredWidth * 0.9f) - this.mPaddingLeft - this.mPaddingRight;
        int childHeight = Math.round((float)measuredHeight * 0.9f) - this.mPaddingTop - this.mPaddingBottom;
        int maxWidth = 0;
        int maxHeight = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            child.measure(View.MeasureSpec.makeMeasureSpec(childWidth, Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(childHeight, Integer.MIN_VALUE));
            if (child == this.mHighlight || child == this.mClickFeedback) continue;
            int childMeasuredWidth = child.getMeasuredWidth();
            int childMeasuredHeight = child.getMeasuredHeight();
            if (childMeasuredWidth > maxWidth) {
                maxWidth = childMeasuredWidth;
            }
            if (childMeasuredHeight <= maxHeight) continue;
            maxHeight = childMeasuredHeight;
        }
        this.mNewPerspectiveShiftX = 0.1f * (float)measuredWidth;
        this.mNewPerspectiveShiftY = 0.1f * (float)measuredHeight;
        if (maxWidth > 0 && count > 0 && maxWidth < childWidth) {
            this.mNewPerspectiveShiftX = measuredWidth - maxWidth;
        }
        if (maxHeight > 0 && count > 0 && maxHeight < childHeight) {
            this.mNewPerspectiveShiftY = measuredHeight - maxHeight;
        }
    }

    private final void $$robo$$android_widget_StackView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSpecSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize(heightMeasureSpec);
        int widthSpecMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode(heightMeasureSpec);
        boolean haveChildRefSize = this.mReferenceChildWidth != -1 && this.mReferenceChildHeight != -1;
        float factorY = 1.1111112f;
        if (heightSpecMode == 0) {
            heightSpecSize = haveChildRefSize ? Math.round((float)this.mReferenceChildHeight * (1.0f + factorY)) + this.mPaddingTop + this.mPaddingBottom : 0;
        } else if (heightSpecMode == Integer.MIN_VALUE) {
            int height;
            heightSpecSize = haveChildRefSize ? ((height = Math.round((float)this.mReferenceChildHeight * (1.0f + factorY)) + this.mPaddingTop + this.mPaddingBottom) <= heightSpecSize ? height : (heightSpecSize |= 0x1000000)) : 0;
        }
        float factorX = 1.1111112f;
        if (widthSpecMode == 0) {
            widthSpecSize = haveChildRefSize ? Math.round((float)this.mReferenceChildWidth * (1.0f + factorX)) + this.mPaddingLeft + this.mPaddingRight : 0;
        } else if (heightSpecMode == Integer.MIN_VALUE) {
            int width;
            widthSpecSize = haveChildRefSize ? ((width = this.mReferenceChildWidth + this.mPaddingLeft + this.mPaddingRight) <= widthSpecSize ? width : (widthSpecSize |= 0x1000000)) : 0;
        }
        this.setMeasuredDimension(widthSpecSize, heightSpecSize);
        this.measureChildren();
    }

    private final CharSequence $$robo$$android_widget_StackView$getAccessibilityClassName() {
        return StackView.class.getName();
    }

    private final void $$robo$$android_widget_StackView$onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        info.setScrollable(this.getChildCount() > 1);
        if (this.isEnabled()) {
            if (this.getDisplayedChild() < this.getChildCount() - 1) {
                info.addAction(4096);
            }
            if (this.getDisplayedChild() > 0) {
                info.addAction(8192);
            }
        }
    }

    private final boolean $$robo$$android_widget_StackView$performAccessibilityActionInternal(int action, Bundle arguments) {
        if (super.performAccessibilityActionInternal(action, arguments)) {
            return true;
        }
        if (!this.isEnabled()) {
            return false;
        }
        switch (action) {
            case 4096: {
                if (this.getDisplayedChild() < this.getChildCount() - 1) {
                    this.showNext();
                    return true;
                }
                return false;
            }
            case 8192: {
                if (this.getDisplayedChild() > 0) {
                    this.showPrevious();
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_StackView$__constructor__(context);
    }

    public StackView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_StackView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_StackView$__constructor__(context, attributeSet);
    }

    public StackView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843838);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_StackView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_StackView$__constructor__(context, attributeSet, n);
    }

    public StackView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_StackView$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_StackView$__constructor__(context, attributeSet, n, n2);
    }

    public StackView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_StackView$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    private void initStackView() {
        InvokeDynamicSupport.bootstrap("initStackView", $$robo$$android_widget_StackView$initStackView(), 0, this);
    }

    @Override
    void transformViewForTransition(int n, int n2, View view, boolean bl) {
        InvokeDynamicSupport.bootstrap("transformViewForTransition", $$robo$$android_widget_StackView$transformViewForTransition(int int android.view.View boolean ), 0, this, n, n2, view, bl);
    }

    private void transformViewAtIndex(int n, View view, boolean bl) {
        InvokeDynamicSupport.bootstrap("transformViewAtIndex", $$robo$$android_widget_StackView$transformViewAtIndex(int android.view.View boolean ), 0, this, n, view, bl);
    }

    private void setupStackSlider(View view, int n) {
        InvokeDynamicSupport.bootstrap("setupStackSlider", $$robo$$android_widget_StackView$setupStackSlider(android.view.View int ), 0, this, view, n);
    }

    @Override
    @RemotableViewMethod
    public void showNext() {
        InvokeDynamicSupport.bootstrap("showNext", $$robo$$android_widget_StackView$showNext(), 0, this);
    }

    @Override
    @RemotableViewMethod
    public void showPrevious() {
        InvokeDynamicSupport.bootstrap("showPrevious", $$robo$$android_widget_StackView$showPrevious(), 0, this);
    }

    @Override
    void showOnly(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("showOnly", $$robo$$android_widget_StackView$showOnly(int boolean ), 0, this, n, bl);
    }

    void updateClickFeedback() {
        InvokeDynamicSupport.bootstrap("updateClickFeedback", $$robo$$android_widget_StackView$updateClickFeedback(), 0, this);
    }

    @Override
    void showTapFeedback(View view) {
        InvokeDynamicSupport.bootstrap("showTapFeedback", $$robo$$android_widget_StackView$showTapFeedback(android.view.View ), 0, this, view);
    }

    @Override
    void hideTapFeedback(View view) {
        InvokeDynamicSupport.bootstrap("hideTapFeedback", $$robo$$android_widget_StackView$hideTapFeedback(android.view.View ), 0, this, view);
    }

    private void updateChildTransforms() {
        InvokeDynamicSupport.bootstrap("updateChildTransforms", $$robo$$android_widget_StackView$updateChildTransforms(), 0, this);
    }

    @Override
    FrameLayout getFrameForChild() {
        return InvokeDynamicSupport.bootstrap("getFrameForChild", $$robo$$android_widget_StackView$getFrameForChild(), 0, this);
    }

    @Override
    void applyTransformForChildAtIndex(View view, int n) {
        InvokeDynamicSupport.bootstrap("applyTransformForChildAtIndex", $$robo$$android_widget_StackView$applyTransformForChildAtIndex(android.view.View int ), 0, this, view, n);
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("dispatchDraw", $$robo$$android_widget_StackView$dispatchDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    private void onLayout() {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_widget_StackView$onLayout(), 0, this);
    }

    @Override
    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onGenericMotionEvent", $$robo$$android_widget_StackView$onGenericMotionEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void pacedScroll(boolean bl) {
        InvokeDynamicSupport.bootstrap("pacedScroll", $$robo$$android_widget_StackView$pacedScroll(boolean ), 0, this, bl);
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onInterceptTouchEvent", $$robo$$android_widget_StackView$onInterceptTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void beginGestureIfNeeded(float f) {
        InvokeDynamicSupport.bootstrap("beginGestureIfNeeded", $$robo$$android_widget_StackView$beginGestureIfNeeded(float ), 0, this, f);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_widget_StackView$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void onSecondaryPointerUp(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("onSecondaryPointerUp", $$robo$$android_widget_StackView$onSecondaryPointerUp(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void handlePointerUp(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("handlePointerUp", $$robo$$android_widget_StackView$handlePointerUp(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    LayoutParams createOrReuseLayoutParams(View view) {
        return InvokeDynamicSupport.bootstrap("createOrReuseLayoutParams", $$robo$$android_widget_StackView$createOrReuseLayoutParams(android.view.View ), 0, this, view);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_widget_StackView$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    @Override
    public void advance() {
        InvokeDynamicSupport.bootstrap("advance", $$robo$$android_widget_StackView$advance(), 0, this);
    }

    private void measureChildren() {
        InvokeDynamicSupport.bootstrap("measureChildren", $$robo$$android_widget_StackView$measureChildren(), 0, this);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_StackView$onMeasure(int int ), 0, this, n, n2);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_widget_StackView$getAccessibilityClassName(), 0, this);
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfoInternal", $$robo$$android_widget_StackView$onInitializeAccessibilityNodeInfoInternal(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    @Override
    public boolean performAccessibilityActionInternal(int n, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("performAccessibilityActionInternal", $$robo$$android_widget_StackView$performAccessibilityActionInternal(int android.os.Bundle ), 0, this, n, bundle);
    }

    public /* synthetic */ StackView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StackView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class HolographicHelper
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Paint mHolographicPaint;
        private Paint mErasePaint;
        private Paint mBlurPaint;
        private static int RES_OUT = 0;
        private static int CLICK_FEEDBACK = 1;
        private float mDensity;
        private BlurMaskFilter mSmallBlurMaskFilter;
        private BlurMaskFilter mLargeBlurMaskFilter;
        private Canvas mCanvas;
        private Canvas mMaskCanvas;
        private int[] mTmpXY;
        private Matrix mIdentityMatrix;

        private void $$robo$$android_widget_StackView_HolographicHelper$__constructor__(Context context) {
            this.mHolographicPaint = new Paint();
            this.mErasePaint = new Paint();
            this.mBlurPaint = new Paint();
            this.mCanvas = new Canvas();
            this.mMaskCanvas = new Canvas();
            this.mTmpXY = new int[2];
            this.mIdentityMatrix = new Matrix();
            this.mDensity = context.getResources().getDisplayMetrics().density;
            this.mHolographicPaint.setFilterBitmap(true);
            this.mHolographicPaint.setMaskFilter(TableMaskFilter.CreateClipTable(0, 30));
            this.mErasePaint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
            this.mErasePaint.setFilterBitmap(true);
            this.mSmallBlurMaskFilter = new BlurMaskFilter(2.0f * this.mDensity, BlurMaskFilter.Blur.NORMAL);
            this.mLargeBlurMaskFilter = new BlurMaskFilter(4.0f * this.mDensity, BlurMaskFilter.Blur.NORMAL);
        }

        private final Bitmap $$robo$$android_widget_StackView_HolographicHelper$createClickOutline(View v, int color2) {
            return this.createOutline(v, 1, color2);
        }

        private final Bitmap $$robo$$android_widget_StackView_HolographicHelper$createResOutline(View v, int color2) {
            return this.createOutline(v, 0, color2);
        }

        private final Bitmap $$robo$$android_widget_StackView_HolographicHelper$createOutline(View v, int type, int color2) {
            this.mHolographicPaint.setColor(color2);
            if (type == 0) {
                this.mBlurPaint.setMaskFilter(this.mSmallBlurMaskFilter);
            } else if (type == 1) {
                this.mBlurPaint.setMaskFilter(this.mLargeBlurMaskFilter);
            }
            if (v.getMeasuredWidth() == 0 || v.getMeasuredHeight() == 0) {
                return null;
            }
            Bitmap bitmap = Bitmap.createBitmap(v.getResources().getDisplayMetrics(), v.getMeasuredWidth(), v.getMeasuredHeight(), Bitmap.Config.ARGB_8888);
            this.mCanvas.setBitmap(bitmap);
            float rotationX = v.getRotationX();
            float rotation = v.getRotation();
            float translationY = v.getTranslationY();
            float translationX = v.getTranslationX();
            v.setRotationX(0.0f);
            v.setRotation(0.0f);
            v.setTranslationY(0.0f);
            v.setTranslationX(0.0f);
            v.draw(this.mCanvas);
            v.setRotationX(rotationX);
            v.setRotation(rotation);
            v.setTranslationY(translationY);
            v.setTranslationX(translationX);
            this.drawOutline(this.mCanvas, bitmap);
            this.mCanvas.setBitmap(null);
            return bitmap;
        }

        private final void $$robo$$android_widget_StackView_HolographicHelper$drawOutline(Canvas dest, Bitmap src) {
            int[] xy = this.mTmpXY;
            Bitmap mask = src.extractAlpha(this.mBlurPaint, xy);
            this.mMaskCanvas.setBitmap(mask);
            this.mMaskCanvas.drawBitmap(src, -xy[0], -xy[1], this.mErasePaint);
            dest.drawColor(0, PorterDuff.Mode.CLEAR);
            dest.setMatrix(this.mIdentityMatrix);
            dest.drawBitmap(mask, xy[0], xy[1], this.mHolographicPaint);
            this.mMaskCanvas.setBitmap(null);
            mask.recycle();
        }

        private void __constructor__(Context context) {
            this.$$robo$$android_widget_StackView_HolographicHelper$__constructor__(context);
        }

        HolographicHelper(Context context) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_StackView_HolographicHelper$__constructor__(android.content.Context ), 0, this, context);
        }

        Bitmap createClickOutline(View view, int n) {
            return InvokeDynamicSupport.bootstrap("createClickOutline", $$robo$$android_widget_StackView_HolographicHelper$createClickOutline(android.view.View int ), 0, this, view, n);
        }

        Bitmap createResOutline(View view, int n) {
            return InvokeDynamicSupport.bootstrap("createResOutline", $$robo$$android_widget_StackView_HolographicHelper$createResOutline(android.view.View int ), 0, this, view, n);
        }

        Bitmap createOutline(View view, int n, int n2) {
            return InvokeDynamicSupport.bootstrap("createOutline", $$robo$$android_widget_StackView_HolographicHelper$createOutline(android.view.View int int ), 0, this, view, n, n2);
        }

        void drawOutline(Canvas canvas, Bitmap bitmap) {
            InvokeDynamicSupport.bootstrap("drawOutline", $$robo$$android_widget_StackView_HolographicHelper$drawOutline(android.graphics.Canvas android.graphics.Bitmap ), 0, this, canvas, bitmap);
        }

        public /* synthetic */ HolographicHelper() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HolographicHelper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class LayoutParams
    extends ViewGroup.LayoutParams
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int horizontalOffset;
        int verticalOffset;
        View mView;
        private Rect parentRect;
        private Rect invalidateRect;
        private RectF invalidateRectf;
        private Rect globalInvalidateRect;
        /* synthetic */ StackView this$0;

        private void $$robo$$android_widget_StackView_LayoutParams$__constructor__(StackView this$0, View view) {
            this.parentRect = new Rect();
            this.invalidateRect = new Rect();
            this.invalidateRectf = new RectF();
            this.globalInvalidateRect = new Rect();
            this.width = 0;
            this.height = 0;
            this.horizontalOffset = 0;
            this.verticalOffset = 0;
            this.mView = view;
        }

        private void $$robo$$android_widget_StackView_LayoutParams$__constructor__(StackView this$0, Context c, AttributeSet attrs) {
            this.parentRect = new Rect();
            this.invalidateRect = new Rect();
            this.invalidateRectf = new RectF();
            this.globalInvalidateRect = new Rect();
            this.horizontalOffset = 0;
            this.verticalOffset = 0;
            this.width = 0;
            this.height = 0;
        }

        private final void $$robo$$android_widget_StackView_LayoutParams$invalidateGlobalRegion(View v, Rect r) {
            this.globalInvalidateRect.set(r);
            this.globalInvalidateRect.union(0, 0, this.this$0.getWidth(), this.this$0.getHeight());
            View p = v;
            if (v.getParent() == null || !(v.getParent() instanceof View)) {
                return;
            }
            boolean firstPass = true;
            this.parentRect.set(0, 0, 0, 0);
            while (p.getParent() != null && p.getParent() instanceof View && !this.parentRect.contains(this.globalInvalidateRect)) {
                if (!firstPass) {
                    this.globalInvalidateRect.offset(p.getLeft() - p.getScrollX(), p.getTop() - p.getScrollY());
                }
                firstPass = false;
                p = (View)((Object)p.getParent());
                this.parentRect.set(p.getScrollX(), p.getScrollY(), p.getWidth() + p.getScrollX(), p.getHeight() + p.getScrollY());
                p.invalidate(this.globalInvalidateRect.left, this.globalInvalidateRect.top, this.globalInvalidateRect.right, this.globalInvalidateRect.bottom);
            }
            p.invalidate(this.globalInvalidateRect.left, this.globalInvalidateRect.top, this.globalInvalidateRect.right, this.globalInvalidateRect.bottom);
        }

        private final Rect $$robo$$android_widget_StackView_LayoutParams$getInvalidateRect() {
            return this.invalidateRect;
        }

        private final void $$robo$$android_widget_StackView_LayoutParams$resetInvalidateRect() {
            this.invalidateRect.set(0, 0, 0, 0);
        }

        private final void $$robo$$android_widget_StackView_LayoutParams$setVerticalOffset(int newVerticalOffset) {
            this.setOffsets(this.horizontalOffset, newVerticalOffset);
        }

        private final void $$robo$$android_widget_StackView_LayoutParams$setHorizontalOffset(int newHorizontalOffset) {
            this.setOffsets(newHorizontalOffset, this.verticalOffset);
        }

        private final void $$robo$$android_widget_StackView_LayoutParams$setOffsets(int newHorizontalOffset, int newVerticalOffset) {
            int horizontalOffsetDelta = newHorizontalOffset - this.horizontalOffset;
            this.horizontalOffset = newHorizontalOffset;
            int verticalOffsetDelta = newVerticalOffset - this.verticalOffset;
            this.verticalOffset = newVerticalOffset;
            if (this.mView != null) {
                this.mView.requestLayout();
                int left = Math.min(this.mView.getLeft() + horizontalOffsetDelta, this.mView.getLeft());
                int right = Math.max(this.mView.getRight() + horizontalOffsetDelta, this.mView.getRight());
                int top = Math.min(this.mView.getTop() + verticalOffsetDelta, this.mView.getTop());
                int bottom = Math.max(this.mView.getBottom() + verticalOffsetDelta, this.mView.getBottom());
                this.invalidateRectf.set(left, top, right, bottom);
                float xoffset = -this.invalidateRectf.left;
                float yoffset = -this.invalidateRectf.top;
                this.invalidateRectf.offset(xoffset, yoffset);
                this.mView.getMatrix().mapRect(this.invalidateRectf);
                this.invalidateRectf.offset(-xoffset, -yoffset);
                this.invalidateRect.set((int)Math.floor(this.invalidateRectf.left), (int)Math.floor(this.invalidateRectf.top), (int)Math.ceil(this.invalidateRectf.right), (int)Math.ceil(this.invalidateRectf.bottom));
                this.invalidateGlobalRegion(this.mView, this.invalidateRect);
            }
        }

        private void __constructor__(StackView stackView, View view) {
            this.$$robo$$android_widget_StackView_LayoutParams$__constructor__(stackView, view);
        }

        LayoutParams(StackView stackView, View view) {
            this.this$0 = stackView;
            super(0, 0);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_StackView_LayoutParams$__constructor__(android.widget.StackView android.view.View ), 0, this, stackView, view);
        }

        private void __constructor__(StackView stackView, Context context, AttributeSet attributeSet) {
            this.$$robo$$android_widget_StackView_LayoutParams$__constructor__(stackView, context, attributeSet);
        }

        LayoutParams(StackView stackView, Context context, AttributeSet attributeSet) {
            this.this$0 = stackView;
            super(context, attributeSet);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_StackView_LayoutParams$__constructor__(android.widget.StackView android.content.Context android.util.AttributeSet ), 0, this, stackView, context, attributeSet);
        }

        void invalidateGlobalRegion(View view, Rect rect) {
            InvokeDynamicSupport.bootstrap("invalidateGlobalRegion", $$robo$$android_widget_StackView_LayoutParams$invalidateGlobalRegion(android.view.View android.graphics.Rect ), 0, this, view, rect);
        }

        Rect getInvalidateRect() {
            return InvokeDynamicSupport.bootstrap("getInvalidateRect", $$robo$$android_widget_StackView_LayoutParams$getInvalidateRect(), 0, this);
        }

        void resetInvalidateRect() {
            InvokeDynamicSupport.bootstrap("resetInvalidateRect", $$robo$$android_widget_StackView_LayoutParams$resetInvalidateRect(), 0, this);
        }

        public void setVerticalOffset(int n) {
            InvokeDynamicSupport.bootstrap("setVerticalOffset", $$robo$$android_widget_StackView_LayoutParams$setVerticalOffset(int ), 0, this, n);
        }

        public void setHorizontalOffset(int n) {
            InvokeDynamicSupport.bootstrap("setHorizontalOffset", $$robo$$android_widget_StackView_LayoutParams$setHorizontalOffset(int ), 0, this, n);
        }

        public void setOffsets(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setOffsets", $$robo$$android_widget_StackView_LayoutParams$setOffsets(int int ), 0, this, n, n2);
        }

        public /* synthetic */ LayoutParams() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayoutParams)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class StackSlider
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        View mView;
        float mYProgress;
        float mXProgress;
        static int NORMAL_MODE = 0;
        static int BEGINNING_OF_STACK_MODE = 1;
        static int END_OF_STACK_MODE = 2;
        int mMode;
        /* synthetic */ StackView this$0;

        private void $$robo$$android_widget_StackView_StackSlider$__constructor__(StackView stackView) {
            this.mMode = 0;
        }

        private void $$robo$$android_widget_StackView_StackSlider$__constructor__(StackView stackView, StackSlider copy) {
            this.mMode = 0;
            this.mView = copy.mView;
            this.mYProgress = copy.mYProgress;
            this.mXProgress = copy.mXProgress;
            this.mMode = copy.mMode;
        }

        private final float $$robo$$android_widget_StackView_StackSlider$cubic(float r) {
            return (float)(Math.pow(2.0f * r - 1.0f, 3.0) + 1.0) / 2.0f;
        }

        private final float $$robo$$android_widget_StackView_StackSlider$highlightAlphaInterpolator(float r) {
            float pivot = 0.4f;
            if (r < pivot) {
                return 0.85f * this.cubic(r / pivot);
            }
            return 0.85f * this.cubic(1.0f - (r - pivot) / (1.0f - pivot));
        }

        private final float $$robo$$android_widget_StackView_StackSlider$viewAlphaInterpolator(float r) {
            float pivot = 0.3f;
            if (r > pivot) {
                return (r - pivot) / (1.0f - pivot);
            }
            return 0.0f;
        }

        private final float $$robo$$android_widget_StackView_StackSlider$rotationInterpolator(float r) {
            float pivot = 0.2f;
            if (r < pivot) {
                return 0.0f;
            }
            return (r - pivot) / (1.0f - pivot);
        }

        private final void $$robo$$android_widget_StackView_StackSlider$setView(View v) {
            this.mView = v;
        }

        private final void $$robo$$android_widget_StackView_StackSlider$setYProgress(float r) {
            int stackDirection;
            r = Math.min(1.0f, r);
            this.mYProgress = r = Math.max(0.0f, r);
            if (this.mView == null) {
                return;
            }
            LayoutParams viewLp = (LayoutParams)this.mView.getLayoutParams();
            LayoutParams highlightLp = (LayoutParams)this.this$0.mHighlight.getLayoutParams();
            int n = stackDirection = this.this$0.mStackMode == 0 ? 1 : -1;
            if (Float.compare(0.0f, this.mYProgress) != 0 && Float.compare(1.0f, this.mYProgress) != 0) {
                if (this.mView.getLayerType() == 0) {
                    this.mView.setLayerType(2, null);
                }
            } else if (this.mView.getLayerType() != 0) {
                this.mView.setLayerType(0, null);
            }
            switch (this.mMode) {
                case 0: {
                    viewLp.setVerticalOffset(Math.round(-r * (float)stackDirection * (float)this.this$0.mSlideAmount));
                    highlightLp.setVerticalOffset(Math.round(-r * (float)stackDirection * (float)this.this$0.mSlideAmount));
                    this.this$0.mHighlight.setAlpha(this.highlightAlphaInterpolator(r));
                    float alpha = this.viewAlphaInterpolator(1.0f - r);
                    if (this.mView.getAlpha() == 0.0f && alpha != 0.0f && this.mView.getVisibility() != 0) {
                        this.mView.setVisibility(0);
                    } else if (alpha == 0.0f && this.mView.getAlpha() != 0.0f && this.mView.getVisibility() == 0) {
                        this.mView.setVisibility(4);
                    }
                    this.mView.setAlpha(alpha);
                    this.mView.setRotationX((float)stackDirection * 90.0f * this.rotationInterpolator(r));
                    this.this$0.mHighlight.setRotationX((float)stackDirection * 90.0f * this.rotationInterpolator(r));
                    break;
                }
                case 2: {
                    viewLp.setVerticalOffset(Math.round((float)(-stackDirection) * (r *= 0.2f) * (float)this.this$0.mSlideAmount));
                    highlightLp.setVerticalOffset(Math.round((float)(-stackDirection) * r * (float)this.this$0.mSlideAmount));
                    this.this$0.mHighlight.setAlpha(this.highlightAlphaInterpolator(r));
                    break;
                }
                case 1: {
                    r = (1.0f - r) * 0.2f;
                    viewLp.setVerticalOffset(Math.round((float)stackDirection * r * (float)this.this$0.mSlideAmount));
                    highlightLp.setVerticalOffset(Math.round((float)stackDirection * r * (float)this.this$0.mSlideAmount));
                    this.this$0.mHighlight.setAlpha(this.highlightAlphaInterpolator(r));
                }
            }
        }

        private final void $$robo$$android_widget_StackView_StackSlider$setXProgress(float r) {
            r = Math.min(2.0f, r);
            this.mXProgress = r = Math.max(-2.0f, r);
            if (this.mView == null) {
                return;
            }
            LayoutParams viewLp = (LayoutParams)this.mView.getLayoutParams();
            LayoutParams highlightLp = (LayoutParams)this.this$0.mHighlight.getLayoutParams();
            viewLp.setHorizontalOffset(Math.round((r *= 0.2f) * (float)this.this$0.mSlideAmount));
            highlightLp.setHorizontalOffset(Math.round(r * (float)this.this$0.mSlideAmount));
        }

        private final void $$robo$$android_widget_StackView_StackSlider$setMode(int mode) {
            this.mMode = mode;
        }

        private final float $$robo$$android_widget_StackView_StackSlider$getDurationForNeutralPosition() {
            return this.getDuration(false, 0.0f);
        }

        private final float $$robo$$android_widget_StackView_StackSlider$getDurationForOffscreenPosition() {
            return this.getDuration(true, 0.0f);
        }

        private final float $$robo$$android_widget_StackView_StackSlider$getDurationForNeutralPosition(float velocity) {
            return this.getDuration(false, velocity);
        }

        private final float $$robo$$android_widget_StackView_StackSlider$getDurationForOffscreenPosition(float velocity) {
            return this.getDuration(true, velocity);
        }

        private final float $$robo$$android_widget_StackView_StackSlider$getDuration(boolean invert, float velocity) {
            if (this.mView != null) {
                float duration;
                float maxd;
                LayoutParams viewLp = (LayoutParams)this.mView.getLayoutParams();
                float d = (float)Math.hypot(viewLp.horizontalOffset, viewLp.verticalOffset);
                if (d > (maxd = (float)Math.hypot(this.this$0.mSlideAmount, 0.4f * (float)this.this$0.mSlideAmount))) {
                    d = maxd;
                }
                if (velocity == 0.0f) {
                    return (invert ? 1.0f - d / maxd : d / maxd) * 400.0f;
                }
                float f = duration = invert ? d / Math.abs(velocity) : (maxd - d) / Math.abs(velocity);
                if (duration < 50.0f || duration > 400.0f) {
                    return this.getDuration(invert, 0.0f);
                }
                return duration;
            }
            return 0.0f;
        }

        private final float $$robo$$android_widget_StackView_StackSlider$getYProgress() {
            return this.mYProgress;
        }

        private final float $$robo$$android_widget_StackView_StackSlider$getXProgress() {
            return this.mXProgress;
        }

        private void __constructor__(StackView stackView) {
            this.$$robo$$android_widget_StackView_StackSlider$__constructor__(stackView);
        }

        public StackSlider(StackView stackView) {
            this.this$0 = stackView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_StackView_StackSlider$__constructor__(android.widget.StackView ), 0, this, stackView);
        }

        private void __constructor__(StackView stackView, StackSlider stackSlider) {
            this.$$robo$$android_widget_StackView_StackSlider$__constructor__(stackView, stackSlider);
        }

        public StackSlider(StackView stackView, StackSlider stackSlider) {
            this.this$0 = stackView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_StackView_StackSlider$__constructor__(android.widget.StackView android.widget.StackView$StackSlider ), 0, this, stackView, stackSlider);
        }

        private float cubic(float f) {
            return (float)InvokeDynamicSupport.bootstrap("cubic", $$robo$$android_widget_StackView_StackSlider$cubic(float ), 0, this, f);
        }

        private float highlightAlphaInterpolator(float f) {
            return (float)InvokeDynamicSupport.bootstrap("highlightAlphaInterpolator", $$robo$$android_widget_StackView_StackSlider$highlightAlphaInterpolator(float ), 0, this, f);
        }

        private float viewAlphaInterpolator(float f) {
            return (float)InvokeDynamicSupport.bootstrap("viewAlphaInterpolator", $$robo$$android_widget_StackView_StackSlider$viewAlphaInterpolator(float ), 0, this, f);
        }

        private float rotationInterpolator(float f) {
            return (float)InvokeDynamicSupport.bootstrap("rotationInterpolator", $$robo$$android_widget_StackView_StackSlider$rotationInterpolator(float ), 0, this, f);
        }

        void setView(View view) {
            InvokeDynamicSupport.bootstrap("setView", $$robo$$android_widget_StackView_StackSlider$setView(android.view.View ), 0, this, view);
        }

        public void setYProgress(float f) {
            InvokeDynamicSupport.bootstrap("setYProgress", $$robo$$android_widget_StackView_StackSlider$setYProgress(float ), 0, this, f);
        }

        public void setXProgress(float f) {
            InvokeDynamicSupport.bootstrap("setXProgress", $$robo$$android_widget_StackView_StackSlider$setXProgress(float ), 0, this, f);
        }

        void setMode(int n) {
            InvokeDynamicSupport.bootstrap("setMode", $$robo$$android_widget_StackView_StackSlider$setMode(int ), 0, this, n);
        }

        float getDurationForNeutralPosition() {
            return (float)InvokeDynamicSupport.bootstrap("getDurationForNeutralPosition", $$robo$$android_widget_StackView_StackSlider$getDurationForNeutralPosition(), 0, this);
        }

        float getDurationForOffscreenPosition() {
            return (float)InvokeDynamicSupport.bootstrap("getDurationForOffscreenPosition", $$robo$$android_widget_StackView_StackSlider$getDurationForOffscreenPosition(), 0, this);
        }

        float getDurationForNeutralPosition(float f) {
            return (float)InvokeDynamicSupport.bootstrap("getDurationForNeutralPosition", $$robo$$android_widget_StackView_StackSlider$getDurationForNeutralPosition(float ), 0, this, f);
        }

        float getDurationForOffscreenPosition(float f) {
            return (float)InvokeDynamicSupport.bootstrap("getDurationForOffscreenPosition", $$robo$$android_widget_StackView_StackSlider$getDurationForOffscreenPosition(float ), 0, this, f);
        }

        private float getDuration(boolean bl, float f) {
            return (float)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$android_widget_StackView_StackSlider$getDuration(boolean float ), 0, this, bl, f);
        }

        public float getYProgress() {
            return (float)InvokeDynamicSupport.bootstrap("getYProgress", $$robo$$android_widget_StackView_StackSlider$getYProgress(), 0, this);
        }

        public float getXProgress() {
            return (float)InvokeDynamicSupport.bootstrap("getXProgress", $$robo$$android_widget_StackView_StackSlider$getXProgress(), 0, this);
        }

        public /* synthetic */ StackSlider() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StackSlider)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class StackFrame
    extends FrameLayout
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        WeakReference<ObjectAnimator> transformAnimator;
        WeakReference<ObjectAnimator> sliderAnimator;

        private void $$robo$$android_widget_StackView_StackFrame$__constructor__(Context context) {
        }

        private final void $$robo$$android_widget_StackView_StackFrame$setTransformAnimator(ObjectAnimator oa) {
            this.transformAnimator = new WeakReference<ObjectAnimator>(oa);
        }

        private final void $$robo$$android_widget_StackView_StackFrame$setSliderAnimator(ObjectAnimator oa) {
            this.sliderAnimator = new WeakReference<ObjectAnimator>(oa);
        }

        private final boolean $$robo$$android_widget_StackView_StackFrame$cancelTransformAnimator() {
            ObjectAnimator oa;
            if (this.transformAnimator != null && (oa = (ObjectAnimator)this.transformAnimator.get()) != null) {
                oa.cancel();
                return true;
            }
            return false;
        }

        private final boolean $$robo$$android_widget_StackView_StackFrame$cancelSliderAnimator() {
            ObjectAnimator oa;
            if (this.sliderAnimator != null && (oa = (ObjectAnimator)this.sliderAnimator.get()) != null) {
                oa.cancel();
                return true;
            }
            return false;
        }

        private void __constructor__(Context context) {
            this.$$robo$$android_widget_StackView_StackFrame$__constructor__(context);
        }

        public StackFrame(Context context) {
            super(context);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_StackView_StackFrame$__constructor__(android.content.Context ), 0, this, context);
        }

        void setTransformAnimator(ObjectAnimator objectAnimator) {
            InvokeDynamicSupport.bootstrap("setTransformAnimator", $$robo$$android_widget_StackView_StackFrame$setTransformAnimator(android.animation.ObjectAnimator ), 0, this, objectAnimator);
        }

        void setSliderAnimator(ObjectAnimator objectAnimator) {
            InvokeDynamicSupport.bootstrap("setSliderAnimator", $$robo$$android_widget_StackView_StackFrame$setSliderAnimator(android.animation.ObjectAnimator ), 0, this, objectAnimator);
        }

        boolean cancelTransformAnimator() {
            return (boolean)InvokeDynamicSupport.bootstrap("cancelTransformAnimator", $$robo$$android_widget_StackView_StackFrame$cancelTransformAnimator(), 0, this);
        }

        boolean cancelSliderAnimator() {
            return (boolean)InvokeDynamicSupport.bootstrap("cancelSliderAnimator", $$robo$$android_widget_StackView_StackFrame$cancelSliderAnimator(), 0, this);
        }

        public /* synthetic */ StackFrame() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StackFrame)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

