/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.alsa;

import android.util.Slog;
import com.android.internal.alsa.LineTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AlsaCardsParser
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "AlsaCardsParser";
    protected static boolean DEBUG = false;
    private static String kCardsFilePath = "/proc/asound/cards";
    private static LineTokenizer mTokenizer;
    private ArrayList<AlsaCardRecord> mCardRecords;

    private void $$robo$$com_android_internal_alsa_AlsaCardsParser$__constructor__() {
        this.mCardRecords = new ArrayList();
    }

    private final void $$robo$$com_android_internal_alsa_AlsaCardsParser$scan() {
        this.mCardRecords = new ArrayList();
        File cardsFile = new File("/proc/asound/cards");
        try {
            FileReader reader = new FileReader(cardsFile);
            BufferedReader bufferedReader = new BufferedReader(reader);
            String line = "";
            while ((line = bufferedReader.readLine()) != null) {
                AlsaCardRecord cardRecord = new AlsaCardRecord(this);
                cardRecord.parse(line, 0);
                line = bufferedReader.readLine();
                if (line == null) break;
                cardRecord.parse(line, 1);
                this.mCardRecords.add(cardRecord);
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private final ArrayList<AlsaCardRecord> $$robo$$com_android_internal_alsa_AlsaCardsParser$getScanRecords() {
        return this.mCardRecords;
    }

    private final AlsaCardRecord $$robo$$com_android_internal_alsa_AlsaCardsParser$getCardRecordAt(int index) {
        return this.mCardRecords.get(index);
    }

    private final AlsaCardRecord $$robo$$com_android_internal_alsa_AlsaCardsParser$getCardRecordFor(int cardNum) {
        for (AlsaCardRecord rec : this.mCardRecords) {
            if (rec.mCardNum != cardNum) continue;
            return rec;
        }
        return null;
    }

    private final int $$robo$$com_android_internal_alsa_AlsaCardsParser$getNumCardRecords() {
        return this.mCardRecords.size();
    }

    private final boolean $$robo$$com_android_internal_alsa_AlsaCardsParser$isCardUsb(int cardNum) {
        for (AlsaCardRecord rec : this.mCardRecords) {
            if (rec.mCardNum != cardNum) continue;
            return rec.mIsUsb;
        }
        return false;
    }

    private final int $$robo$$com_android_internal_alsa_AlsaCardsParser$getDefaultUsbCard() {
        ArrayList<AlsaCardRecord> prevRecs = this.mCardRecords;
        this.scan();
        ArrayList<AlsaCardRecord> newRecs = this.getNewCardRecords(prevRecs);
        for (AlsaCardRecord rec : newRecs) {
            if (!rec.mIsUsb) continue;
            return rec.mCardNum;
        }
        for (AlsaCardRecord rec : prevRecs) {
            if (!rec.mIsUsb) continue;
            return rec.mCardNum;
        }
        return -1;
    }

    private final int $$robo$$com_android_internal_alsa_AlsaCardsParser$getDefaultCard() {
        int card = this.getDefaultUsbCard();
        if (card < 0 && this.getNumCardRecords() > 0) {
            card = this.getCardRecordAt((int)(this.getNumCardRecords() - 1)).mCardNum;
        }
        return card;
    }

    private static final boolean $$robo$$com_android_internal_alsa_AlsaCardsParser$hasCardNumber(ArrayList<AlsaCardRecord> recs, int cardNum) {
        for (AlsaCardRecord cardRec : recs) {
            if (cardRec.mCardNum != cardNum) continue;
            return true;
        }
        return false;
    }

    private final ArrayList<AlsaCardRecord> $$robo$$com_android_internal_alsa_AlsaCardsParser$getNewCardRecords(ArrayList<AlsaCardRecord> prevScanRecs) {
        ArrayList<AlsaCardRecord> newRecs = new ArrayList<AlsaCardRecord>();
        for (AlsaCardRecord rec : this.mCardRecords) {
            if (AlsaCardsParser.hasCardNumber(prevScanRecs, rec.mCardNum)) continue;
            newRecs.add(rec);
        }
        return newRecs;
    }

    private final void $$robo$$com_android_internal_alsa_AlsaCardsParser$Log(String heading) {
    }

    private static final void $$robo$$com_android_internal_alsa_AlsaCardsParser$LogDevices(String caption, ArrayList<AlsaCardRecord> deviceList) {
        Slog.d("AlsaCardsParser", caption + " ----------------");
        int listIndex = 0;
        for (AlsaCardRecord device : deviceList) {
            device.log(listIndex++);
        }
        Slog.d("AlsaCardsParser", "----------------");
    }

    static void __staticInitializer__() {
        mTokenizer = new LineTokenizer(" :[]");
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_alsa_AlsaCardsParser$__constructor__();
    }

    public AlsaCardsParser() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_alsa_AlsaCardsParser$__constructor__(), 0, this);
    }

    public void scan() {
        InvokeDynamicSupport.bootstrap("scan", $$robo$$com_android_internal_alsa_AlsaCardsParser$scan(), 0, this);
    }

    public ArrayList<AlsaCardRecord> getScanRecords() {
        return InvokeDynamicSupport.bootstrap("getScanRecords", $$robo$$com_android_internal_alsa_AlsaCardsParser$getScanRecords(), 0, this);
    }

    public AlsaCardRecord getCardRecordAt(int n) {
        return InvokeDynamicSupport.bootstrap("getCardRecordAt", $$robo$$com_android_internal_alsa_AlsaCardsParser$getCardRecordAt(int ), 0, this, n);
    }

    public AlsaCardRecord getCardRecordFor(int n) {
        return InvokeDynamicSupport.bootstrap("getCardRecordFor", $$robo$$com_android_internal_alsa_AlsaCardsParser$getCardRecordFor(int ), 0, this, n);
    }

    public int getNumCardRecords() {
        return (int)InvokeDynamicSupport.bootstrap("getNumCardRecords", $$robo$$com_android_internal_alsa_AlsaCardsParser$getNumCardRecords(), 0, this);
    }

    public boolean isCardUsb(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCardUsb", $$robo$$com_android_internal_alsa_AlsaCardsParser$isCardUsb(int ), 0, this, n);
    }

    public int getDefaultUsbCard() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultUsbCard", $$robo$$com_android_internal_alsa_AlsaCardsParser$getDefaultUsbCard(), 0, this);
    }

    public int getDefaultCard() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultCard", $$robo$$com_android_internal_alsa_AlsaCardsParser$getDefaultCard(), 0, this);
    }

    public static boolean hasCardNumber(ArrayList<AlsaCardRecord> arrayList, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasCardNumber", $$robo$$com_android_internal_alsa_AlsaCardsParser$hasCardNumber(java.util.ArrayList<com.android.internal.alsa.AlsaCardsParser$AlsaCardRecord> int ), 0, arrayList, (int)n);
    }

    public ArrayList<AlsaCardRecord> getNewCardRecords(ArrayList<AlsaCardRecord> arrayList) {
        return InvokeDynamicSupport.bootstrap("getNewCardRecords", $$robo$$com_android_internal_alsa_AlsaCardsParser$getNewCardRecords(java.util.ArrayList<com.android.internal.alsa.AlsaCardsParser$AlsaCardRecord> ), 0, this, arrayList);
    }

    private void Log(String string2) {
        InvokeDynamicSupport.bootstrap("Log", $$robo$$com_android_internal_alsa_AlsaCardsParser$Log(java.lang.String ), 0, this, string2);
    }

    private static void LogDevices(String string2, ArrayList<AlsaCardRecord> arrayList) {
        InvokeDynamicSupport.bootstrapStatic("LogDevices", $$robo$$com_android_internal_alsa_AlsaCardsParser$LogDevices(java.lang.String java.util.ArrayList<com.android.internal.alsa.AlsaCardsParser$AlsaCardRecord> ), 0, (String)string2, arrayList);
    }

    static {
        RobolectricInternals.classInitializing(AlsaCardsParser.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AlsaCardsParser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class AlsaCardRecord
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String TAG = "AlsaCardRecord";
        private static String kUsbCardKeyStr = "at usb-";
        public int mCardNum;
        public String mField1;
        public String mCardName;
        public String mCardDescription;
        public boolean mIsUsb;
        /* synthetic */ AlsaCardsParser this$0;

        private void $$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$__constructor__(AlsaCardsParser this$0) {
            this.mCardNum = -1;
            this.mField1 = "";
            this.mCardName = "";
            this.mCardDescription = "";
            this.mIsUsb = false;
        }

        private final boolean $$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$parse(String line, int lineIndex) {
            int tokenIndex = 0;
            int delimIndex = 0;
            if (lineIndex == 0) {
                tokenIndex = mTokenizer.nextToken(line, tokenIndex);
                delimIndex = mTokenizer.nextDelimiter(line, tokenIndex);
                try {
                    this.mCardNum = Integer.parseInt(line.substring(tokenIndex, delimIndex));
                }
                catch (NumberFormatException e) {
                    Slog.e("AlsaCardRecord", "Failed to parse line " + lineIndex + " of " + "/proc/asound/cards" + ": " + line.substring(tokenIndex, delimIndex));
                    return false;
                }
                tokenIndex = mTokenizer.nextToken(line, delimIndex);
                delimIndex = mTokenizer.nextDelimiter(line, tokenIndex);
                this.mField1 = line.substring(tokenIndex, delimIndex);
                tokenIndex = mTokenizer.nextToken(line, delimIndex);
                this.mCardName = line.substring(tokenIndex);
            } else if (lineIndex == 1 && (tokenIndex = mTokenizer.nextToken(line, 0)) != -1) {
                int keyIndex = line.indexOf("at usb-");
                boolean bl = this.mIsUsb = keyIndex != -1;
                if (this.mIsUsb) {
                    this.mCardDescription = line.substring(tokenIndex, keyIndex - 1);
                }
            }
            return true;
        }

        private final String $$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$textFormat() {
            return this.mCardName + " : " + this.mCardDescription;
        }

        private final void $$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$log(int listIndex) {
            Slog.d("AlsaCardRecord", "" + listIndex + " [" + this.mCardNum + " " + this.mCardName + " : " + this.mCardDescription + " usb:" + this.mIsUsb);
        }

        private void __constructor__(AlsaCardsParser alsaCardsParser) {
            this.$$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$__constructor__(alsaCardsParser);
        }

        public AlsaCardRecord(AlsaCardsParser alsaCardsParser) {
            this.this$0 = alsaCardsParser;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$__constructor__(com.android.internal.alsa.AlsaCardsParser ), 0, this, alsaCardsParser);
        }

        private boolean parse(String string2, int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("parse", $$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$parse(java.lang.String int ), 0, this, string2, n);
        }

        public String textFormat() {
            return InvokeDynamicSupport.bootstrap("textFormat", $$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$textFormat(), 0, this);
        }

        public void log(int n) {
            InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$log(int ), 0, this, n);
        }

        public /* synthetic */ AlsaCardRecord() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AlsaCardRecord)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

