/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityThread;
import android.app.AppGlobals;
import android.content.Context;
import android.content.Intent;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.Slog;
import android.widget.Toast;
import com.android.internal.app.ChooserActivity;
import com.android.internal.app.ResolverActivity;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class IntentForwarderActivity
extends Activity
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String TAG;
    public static String FORWARD_INTENT_TO_PARENT;
    public static String FORWARD_INTENT_TO_MANAGED_PROFILE;
    private Injector mInjector;

    private void $$robo$$com_android_internal_app_IntentForwarderActivity$__constructor__() {
    }

    private final void $$robo$$com_android_internal_app_IntentForwarderActivity$onCreate(Bundle savedInstanceState) {
        int targetUserId;
        int userMessageId;
        super.onCreate(savedInstanceState);
        this.mInjector = this.createInjector();
        Intent intentReceived = this.getIntent();
        String className = intentReceived.getComponent().getClassName();
        if (className.equals(FORWARD_INTENT_TO_PARENT)) {
            userMessageId = 17039895;
            targetUserId = this.getProfileParent();
        } else if (className.equals(FORWARD_INTENT_TO_MANAGED_PROFILE)) {
            userMessageId = 17039896;
            targetUserId = this.getManagedProfile();
        } else {
            Slog.wtf(TAG, IntentForwarderActivity.class.getName() + " cannot be called directly");
            userMessageId = -1;
            targetUserId = -10000;
        }
        if (targetUserId == -10000) {
            this.finish();
            return;
        }
        int callingUserId = this.getUserId();
        Intent newIntent = this.canForward(intentReceived, targetUserId);
        if (newIntent != null) {
            if ("android.intent.action.CHOOSER".equals(newIntent.getAction())) {
                Intent innerIntent = (Intent)newIntent.getParcelableExtra("android.intent.extra.INTENT");
                innerIntent.prepareToLeaveUser(callingUserId);
            } else {
                newIntent.prepareToLeaveUser(callingUserId);
            }
            ResolveInfo ri = this.mInjector.getPackageManager().resolveActivityAsUser(newIntent, 65536, targetUserId);
            boolean shouldShowDisclosure = ri == null || ri.activityInfo == null || !"android".equals(ri.activityInfo.packageName) || !ResolverActivity.class.getName().equals(ri.activityInfo.name) && !ChooserActivity.class.getName().equals(ri.activityInfo.name);
            try {
                this.startActivityAsCaller(newIntent, null, false, targetUserId);
            }
            catch (RuntimeException e) {
                int launchedFromUid = -1;
                String launchedFromPackage = "?";
                try {
                    launchedFromUid = ActivityManager.getService().getLaunchedFromUid(this.getActivityToken());
                    launchedFromPackage = ActivityManager.getService().getLaunchedFromPackage(this.getActivityToken());
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                Slog.wtf(TAG, "Unable to launch as UID " + launchedFromUid + " package " + launchedFromPackage + ", while running in " + ActivityThread.currentProcessName(), e);
            }
            if (shouldShowDisclosure) {
                Toast.makeText((Context)this, this.getString(userMessageId), 1).show();
            }
        } else {
            Slog.wtf(TAG, "the intent: " + intentReceived + " cannot be forwarded from user " + callingUserId + " to user " + targetUserId);
        }
        this.finish();
    }

    private final Intent $$robo$$com_android_internal_app_IntentForwarderActivity$canForward(Intent incomingIntent, int targetUserId) {
        Intent forwardIntent = new Intent(incomingIntent);
        forwardIntent.addFlags(0x3000000);
        this.sanitizeIntent(forwardIntent);
        Intent intentToCheck = forwardIntent;
        if ("android.intent.action.CHOOSER".equals(forwardIntent.getAction())) {
            if (forwardIntent.hasExtra("android.intent.extra.INITIAL_INTENTS")) {
                Slog.wtf(TAG, "An chooser intent with extra initial intents cannot be forwarded to a different user");
                return null;
            }
            if (forwardIntent.hasExtra("android.intent.extra.REPLACEMENT_EXTRAS")) {
                Slog.wtf(TAG, "A chooser intent with replacement extras cannot be forwarded to a different user");
                return null;
            }
            intentToCheck = (Intent)forwardIntent.getParcelableExtra("android.intent.extra.INTENT");
            if (intentToCheck == null) {
                Slog.wtf(TAG, "Cannot forward a chooser intent with no extra android.intent.extra.INTENT");
                return null;
            }
        }
        if (forwardIntent.getSelector() != null) {
            intentToCheck = forwardIntent.getSelector();
        }
        String resolvedType = intentToCheck.resolveTypeIfNeeded(this.getContentResolver());
        this.sanitizeIntent(intentToCheck);
        try {
            if (this.mInjector.getIPackageManager().canForwardTo(intentToCheck, resolvedType, this.getUserId(), targetUserId)) {
                return forwardIntent;
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "PackageManagerService is dead?");
        }
        return null;
    }

    private final int $$robo$$com_android_internal_app_IntentForwarderActivity$getManagedProfile() {
        List<UserInfo> relatedUsers = this.mInjector.getUserManager().getProfiles(UserHandle.myUserId());
        for (UserInfo userInfo : relatedUsers) {
            if (!userInfo.isManagedProfile()) continue;
            return userInfo.id;
        }
        Slog.wtf(TAG, FORWARD_INTENT_TO_MANAGED_PROFILE + " has been called, but there is no managed profile");
        return -10000;
    }

    private final int $$robo$$com_android_internal_app_IntentForwarderActivity$getProfileParent() {
        UserInfo parent = this.mInjector.getUserManager().getProfileParent(UserHandle.myUserId());
        if (parent == null) {
            Slog.wtf(TAG, FORWARD_INTENT_TO_PARENT + " has been called, but there is no parent");
            return -10000;
        }
        return parent.id;
    }

    private final void $$robo$$com_android_internal_app_IntentForwarderActivity$sanitizeIntent(Intent intent) {
        intent.setPackage(null);
        intent.setComponent(null);
    }

    private final Injector $$robo$$com_android_internal_app_IntentForwarderActivity$createInjector() {
        return new InjectorImpl(this);
    }

    static void __staticInitializer__() {
        TAG = "IntentForwarderActivity";
        FORWARD_INTENT_TO_PARENT = "com.android.internal.app.ForwardIntentToParent";
        FORWARD_INTENT_TO_MANAGED_PROFILE = "com.android.internal.app.ForwardIntentToManagedProfile";
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_app_IntentForwarderActivity$__constructor__();
    }

    public IntentForwarderActivity() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_IntentForwarderActivity$__constructor__(), 0, this);
    }

    @Override
    protected void onCreate(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$com_android_internal_app_IntentForwarderActivity$onCreate(android.os.Bundle ), 0, this, bundle);
    }

    Intent canForward(Intent intent, int n) {
        return InvokeDynamicSupport.bootstrap("canForward", $$robo$$com_android_internal_app_IntentForwarderActivity$canForward(android.content.Intent int ), 0, this, intent, n);
    }

    private int getManagedProfile() {
        return (int)InvokeDynamicSupport.bootstrap("getManagedProfile", $$robo$$com_android_internal_app_IntentForwarderActivity$getManagedProfile(), 0, this);
    }

    private int getProfileParent() {
        return (int)InvokeDynamicSupport.bootstrap("getProfileParent", $$robo$$com_android_internal_app_IntentForwarderActivity$getProfileParent(), 0, this);
    }

    private void sanitizeIntent(Intent intent) {
        InvokeDynamicSupport.bootstrap("sanitizeIntent", $$robo$$com_android_internal_app_IntentForwarderActivity$sanitizeIntent(android.content.Intent ), 0, this, intent);
    }

    protected Injector createInjector() {
        return InvokeDynamicSupport.bootstrap("createInjector", $$robo$$com_android_internal_app_IntentForwarderActivity$createInjector(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(IntentForwarderActivity.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IntentForwarderActivity)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface Injector
    extends InstrumentedInterface {
        public IPackageManager getIPackageManager();

        public UserManager getUserManager();

        public PackageManager getPackageManager();
    }

    private class InjectorImpl
    implements Injector,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ IntentForwarderActivity this$0;

        private void $$robo$$com_android_internal_app_IntentForwarderActivity_InjectorImpl$__constructor__(IntentForwarderActivity intentForwarderActivity) {
        }

        private final IPackageManager $$robo$$com_android_internal_app_IntentForwarderActivity_InjectorImpl$getIPackageManager() {
            return AppGlobals.getPackageManager();
        }

        private final UserManager $$robo$$com_android_internal_app_IntentForwarderActivity_InjectorImpl$getUserManager() {
            return this.this$0.getSystemService(UserManager.class);
        }

        private final PackageManager $$robo$$com_android_internal_app_IntentForwarderActivity_InjectorImpl$getPackageManager() {
            return this.this$0.getPackageManager();
        }

        private /* synthetic */ void $$robo$$com_android_internal_app_IntentForwarderActivity_InjectorImpl$__constructor__(IntentForwarderActivity x0, 1 x1) {
        }

        private void __constructor__(IntentForwarderActivity intentForwarderActivity) {
            this.$$robo$$com_android_internal_app_IntentForwarderActivity_InjectorImpl$__constructor__(intentForwarderActivity);
        }

        private InjectorImpl(IntentForwarderActivity intentForwarderActivity) {
            this.this$0 = intentForwarderActivity;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_IntentForwarderActivity_InjectorImpl$__constructor__(com.android.internal.app.IntentForwarderActivity ), 0, this, intentForwarderActivity);
        }

        @Override
        public IPackageManager getIPackageManager() {
            return InvokeDynamicSupport.bootstrap("getIPackageManager", $$robo$$com_android_internal_app_IntentForwarderActivity_InjectorImpl$getIPackageManager(), 0, this);
        }

        @Override
        public UserManager getUserManager() {
            return InvokeDynamicSupport.bootstrap("getUserManager", $$robo$$com_android_internal_app_IntentForwarderActivity_InjectorImpl$getUserManager(), 0, this);
        }

        @Override
        public PackageManager getPackageManager() {
            return InvokeDynamicSupport.bootstrap("getPackageManager", $$robo$$com_android_internal_app_IntentForwarderActivity_InjectorImpl$getPackageManager(), 0, this);
        }

        private /* synthetic */ void __constructor__(IntentForwarderActivity intentForwarderActivity, 1 var2_2) {
            this.$$robo$$com_android_internal_app_IntentForwarderActivity_InjectorImpl$__constructor__(intentForwarderActivity, var2_2);
        }

        public /* synthetic */ InjectorImpl() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InjectorImpl)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

