/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.metrics.LogMaker;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.UserHandle;
import android.service.resolver.IResolverRankerResult;
import android.service.resolver.IResolverRankerService;
import android.service.resolver.ResolverTarget;
import android.util.Log;
import com.android.internal.app.ResolverActivity;
import com.android.internal.logging.MetricsLogger;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ResolverComparator
implements Comparator<ResolverActivity.ResolvedComponentInfo> {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ResolverComparator";
    private static boolean DEBUG = false;
    private static int NUM_OF_TOP_ANNOTATIONS_TO_USE = 3;
    private static long USAGE_STATS_PERIOD = 604800000L;
    private static long RECENCY_TIME_PERIOD = 43200000L;
    private static float RECENCY_MULTIPLIER = 2.0f;
    private static int RESOLVER_RANKER_SERVICE_RESULT = 0;
    private static int RESOLVER_RANKER_RESULT_TIMEOUT = 1;
    private static int CONNECTION_COST_TIMEOUT_MILLIS = 200;
    private static int WATCHDOG_TIMEOUT_MILLIS = 500;
    private Collator mCollator;
    private boolean mHttp;
    private PackageManager mPm;
    private UsageStatsManager mUsm;
    private Map<String, UsageStats> mStats;
    private long mCurrentTime;
    private long mSinceTime;
    private LinkedHashMap<ComponentName, ResolverTarget> mTargetsDict;
    private String mReferrerPackage;
    private Object mLock;
    private ArrayList<ResolverTarget> mTargets;
    private String mContentType;
    private String[] mAnnotations;
    private String mAction;
    private ComponentName mResolvedRankerName;
    private ComponentName mRankerServiceName;
    private IResolverRankerService mRanker;
    private ResolverRankerServiceConnection mConnection;
    private AfterCompute mAfterCompute;
    private Context mContext;
    private CountDownLatch mConnectSignal;
    private Handler mHandler;

    private void $$robo$$com_android_internal_app_ResolverComparator$__constructor__(Context context, Intent intent, String referrerPackage, AfterCompute afterCompute) {
        this.mTargetsDict = new LinkedHashMap();
        this.mLock = new Object();
        this.mHandler = new ShadowedObject(this, Looper.getMainLooper()){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ResolverComparator this$0;

            private void $$robo$$com_android_internal_app_ResolverComparator_1$__constructor__(ResolverComparator this$0, Looper looper) {
            }

            private final void $$robo$$com_android_internal_app_ResolverComparator_1$handleMessage(Message msg) {
                switch (msg.what) {
                    case 0: {
                        if (!this.this$0.mHandler.hasMessages(1)) break;
                        if (msg.obj != null) {
                            List receivedTargets = (List)msg.obj;
                            if (receivedTargets != null && this.this$0.mTargets != null && receivedTargets.size() == this.this$0.mTargets.size()) {
                                int size = this.this$0.mTargets.size();
                                boolean isUpdated = false;
                                for (int i = 0; i < size; ++i) {
                                    float predictedProb = ((ResolverTarget)receivedTargets.get(i)).getSelectProbability();
                                    if (predictedProb == ((ResolverTarget)this.this$0.mTargets.get(i)).getSelectProbability()) continue;
                                    ((ResolverTarget)this.this$0.mTargets.get(i)).setSelectProbability(predictedProb);
                                    isUpdated = true;
                                }
                                if (isUpdated) {
                                    this.this$0.mRankerServiceName = this.this$0.mResolvedRankerName;
                                }
                            } else {
                                Log.e("ResolverComparator", "Sizes of sent and received ResolverTargets diff.");
                            }
                        } else {
                            Log.e("ResolverComparator", "Receiving null prediction results.");
                        }
                        this.this$0.mHandler.removeMessages(1);
                        this.this$0.mAfterCompute.afterCompute();
                        break;
                    }
                    case 1: {
                        this.this$0.mHandler.removeMessages(0);
                        this.this$0.mAfterCompute.afterCompute();
                        break;
                    }
                    default: {
                        super.handleMessage(msg);
                    }
                }
            }

            private void __constructor__(ResolverComparator resolverComparator, Looper looper) {
                this.$$robo$$com_android_internal_app_ResolverComparator_1$__constructor__(resolverComparator, looper);
            }
            {
                this.this$0 = resolverComparator;
                super(looper);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverComparator_1$__constructor__(com.android.internal.app.ResolverComparator android.os.Looper ), 0, this, resolverComparator, looper);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_app_ResolverComparator_1$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCollator = Collator.getInstance(context.getResources().getConfiguration().locale);
        String scheme = intent.getScheme();
        this.mHttp = "http".equals(scheme) || "https".equals(scheme);
        this.mReferrerPackage = referrerPackage;
        this.mAfterCompute = afterCompute;
        this.mContext = context;
        this.mPm = context.getPackageManager();
        this.mUsm = (UsageStatsManager)context.getSystemService("usagestats");
        this.mCurrentTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.mSinceTime = this.mCurrentTime - 604800000L;
        this.mStats = this.mUsm.queryAndAggregateUsageStats(this.mSinceTime, this.mCurrentTime);
        this.mContentType = intent.getType();
        this.getContentAnnotations(intent);
        this.mAction = intent.getAction();
        this.mRankerServiceName = new ComponentName(this.mContext, this.getClass());
    }

    private final void $$robo$$com_android_internal_app_ResolverComparator$getContentAnnotations(Intent intent) {
        ArrayList<String> annotations = intent.getStringArrayListExtra("android.intent.extra.CONTENT_ANNOTATIONS");
        if (annotations != null) {
            int size = annotations.size();
            if (size > 3) {
                size = 3;
            }
            this.mAnnotations = new String[size];
            for (int i = 0; i < size; ++i) {
                this.mAnnotations[i] = annotations.get(i);
            }
        }
    }

    private final void $$robo$$com_android_internal_app_ResolverComparator$setCallBack(AfterCompute afterCompute) {
        this.mAfterCompute = afterCompute;
    }

    private final void $$robo$$com_android_internal_app_ResolverComparator$compute(List<ResolverActivity.ResolvedComponentInfo> targets) {
        this.reset();
        long recentSinceTime = this.mCurrentTime - 43200000L;
        float mostRecencyScore = 1.0f;
        float mostTimeSpentScore = 1.0f;
        float mostLaunchScore = 1.0f;
        float mostChooserScore = 1.0f;
        for (ResolverActivity.ResolvedComponentInfo resolvedComponentInfo : targets) {
            ResolverTarget resolverTarget = new ResolverTarget();
            this.mTargetsDict.put(resolvedComponentInfo.name, resolverTarget);
            UsageStats pkStats = this.mStats.get(resolvedComponentInfo.name.getPackageName());
            if (pkStats == null) continue;
            if (!resolvedComponentInfo.name.getPackageName().equals(this.mReferrerPackage) && !ResolverComparator.isPersistentProcess(resolvedComponentInfo)) {
                float recencyScore = Math.max(pkStats.getLastTimeUsed() - recentSinceTime, 0L);
                resolverTarget.setRecencyScore(recencyScore);
                if (recencyScore > mostRecencyScore) {
                    mostRecencyScore = recencyScore;
                }
            }
            float timeSpentScore = pkStats.getTotalTimeInForeground();
            resolverTarget.setTimeSpentScore(timeSpentScore);
            if (timeSpentScore > mostTimeSpentScore) {
                mostTimeSpentScore = timeSpentScore;
            }
            float launchScore = pkStats.mLaunchCount;
            resolverTarget.setLaunchScore(launchScore);
            if (launchScore > mostLaunchScore) {
                mostLaunchScore = launchScore;
            }
            float chooserScore = 0.0f;
            if (pkStats.mChooserCounts != null && this.mAction != null && pkStats.mChooserCounts.get(this.mAction) != null) {
                chooserScore = pkStats.mChooserCounts.get(this.mAction).getOrDefault(this.mContentType, 0).intValue();
                if (this.mAnnotations != null) {
                    int size = this.mAnnotations.length;
                    for (int i = 0; i < size; ++i) {
                        chooserScore += (float)pkStats.mChooserCounts.get(this.mAction).getOrDefault(this.mAnnotations[i], 0).intValue();
                    }
                }
            }
            resolverTarget.setChooserScore(chooserScore);
            if (!(chooserScore > mostChooserScore)) continue;
            mostChooserScore = chooserScore;
        }
        this.mTargets = new ArrayList<ResolverTarget>(this.mTargetsDict.values());
        for (ResolverTarget resolverTarget : this.mTargets) {
            float recency = resolverTarget.getRecencyScore() / mostRecencyScore;
            this.setFeatures(resolverTarget, recency * recency * 2.0f, resolverTarget.getLaunchScore() / mostLaunchScore, resolverTarget.getTimeSpentScore() / mostTimeSpentScore, resolverTarget.getChooserScore() / mostChooserScore);
            this.addDefaultSelectProbability(resolverTarget);
        }
        this.predictSelectProbabilities(this.mTargets);
    }

    private final int $$robo$$com_android_internal_app_ResolverComparator$compare(ResolverActivity.ResolvedComponentInfo lhsp, ResolverActivity.ResolvedComponentInfo rhsp) {
        CharSequence sb;
        CharSequence sa;
        boolean rhsSpecific;
        boolean lhsSpecific;
        ResolveInfo lhs = lhsp.getResolveInfoAt(0);
        ResolveInfo rhs = rhsp.getResolveInfoAt(0);
        if (lhs.targetUserId != -2) {
            return rhs.targetUserId != -2 ? 0 : 1;
        }
        if (rhs.targetUserId != -2) {
            return -1;
        }
        if (this.mHttp && (lhsSpecific = ResolverActivity.isSpecificUriMatch(lhs.match)) != (rhsSpecific = ResolverActivity.isSpecificUriMatch(rhs.match))) {
            return lhsSpecific ? -1 : 1;
        }
        boolean lPinned = lhsp.isPinned();
        boolean rPinned = rhsp.isPinned();
        if (lPinned && !rPinned) {
            return -1;
        }
        if (!lPinned && rPinned) {
            return 1;
        }
        if (!lPinned && !rPinned && this.mStats != null) {
            int selectProbabilityDiff;
            ResolverTarget lhsTarget = this.mTargetsDict.get(new ComponentName(lhs.activityInfo.packageName, lhs.activityInfo.name));
            ResolverTarget rhsTarget = this.mTargetsDict.get(new ComponentName(rhs.activityInfo.packageName, rhs.activityInfo.name));
            if (lhsTarget != null && rhsTarget != null && (selectProbabilityDiff = Float.compare(rhsTarget.getSelectProbability(), lhsTarget.getSelectProbability())) != 0) {
                return selectProbabilityDiff > 0 ? 1 : -1;
            }
        }
        if ((sa = lhs.loadLabel(this.mPm)) == null) {
            sa = lhs.activityInfo.name;
        }
        if ((sb = rhs.loadLabel(this.mPm)) == null) {
            sb = rhs.activityInfo.name;
        }
        return this.mCollator.compare(sa.toString().trim(), sb.toString().trim());
    }

    private final float $$robo$$com_android_internal_app_ResolverComparator$getScore(ComponentName name) {
        ResolverTarget target = this.mTargetsDict.get(name);
        if (target != null) {
            return target.getSelectProbability();
        }
        return 0.0f;
    }

    private final void $$robo$$com_android_internal_app_ResolverComparator$updateChooserCounts(String packageName, int userId, String action) {
        if (this.mUsm != null) {
            this.mUsm.reportChooserSelection(packageName, userId, this.mContentType, this.mAnnotations, action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_app_ResolverComparator$updateModel(ComponentName componentName) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mRanker != null) {
                try {
                    int selectedPos = new ArrayList<ComponentName>(this.mTargetsDict.keySet()).indexOf(componentName);
                    if (selectedPos >= 0 && this.mTargets != null) {
                        float selectedProbability = this.getScore(componentName);
                        int order = 0;
                        for (ResolverTarget target : this.mTargets) {
                            if (!(target.getSelectProbability() > selectedProbability)) continue;
                            ++order;
                        }
                        this.logMetrics(order);
                        this.mRanker.train(this.mTargets, selectedPos);
                    }
                }
                catch (RemoteException e) {
                    Log.e("ResolverComparator", "Error in Train: " + e);
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_app_ResolverComparator$destroy() {
        this.mHandler.removeMessages(0);
        this.mHandler.removeMessages(1);
        if (this.mConnection != null) {
            this.mContext.unbindService(this.mConnection);
            this.mConnection.destroy();
        }
    }

    private final void $$robo$$com_android_internal_app_ResolverComparator$logMetrics(int selectedPos) {
        if (this.mRankerServiceName != null) {
            MetricsLogger metricsLogger = new MetricsLogger();
            LogMaker log = new LogMaker(1085);
            log.setComponentName(this.mRankerServiceName);
            int isCategoryUsed = this.mAnnotations == null ? 0 : 1;
            log.addTaggedData(1086, isCategoryUsed);
            log.addTaggedData(1087, selectedPos);
            metricsLogger.write(log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_app_ResolverComparator$initRanker(Context context) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnection != null && this.mRanker != null) {
                return;
            }
        }
        Intent intent = this.resolveRankerService();
        if (intent == null) {
            return;
        }
        this.mConnectSignal = new CountDownLatch(1);
        this.mConnection = new ResolverRankerServiceConnection(this, this.mConnectSignal);
        context.bindServiceAsUser(intent, this.mConnection, 1, UserHandle.SYSTEM);
    }

    private final Intent $$robo$$com_android_internal_app_ResolverComparator$resolveRankerService() {
        Intent intent = new Intent("android.service.resolver.ResolverRankerService");
        List<ResolveInfo> resolveInfos = this.mPm.queryIntentServices(intent, 0);
        for (ResolveInfo resolveInfo : resolveInfos) {
            ComponentName componentName;
            block5: {
                if (resolveInfo == null || resolveInfo.serviceInfo == null || resolveInfo.serviceInfo.applicationInfo == null) continue;
                componentName = new ComponentName(resolveInfo.serviceInfo.applicationInfo.packageName, resolveInfo.serviceInfo.name);
                try {
                    String perm = this.mPm.getServiceInfo((ComponentName)componentName, (int)0).permission;
                    if (!"android.permission.BIND_RESOLVER_RANKER_SERVICE".equals(perm)) {
                        Log.w("ResolverComparator", "ResolverRankerService " + componentName + " does not require" + " permission " + "android.permission.BIND_RESOLVER_RANKER_SERVICE" + " - this service will not be queried for ResolverComparator." + " add android:permission=\"" + "android.permission.BIND_RESOLVER_RANKER_SERVICE" + "\"" + " to the <service> tag for " + componentName + " in the manifest.");
                        continue;
                    }
                    if (0 != this.mPm.checkPermission("android.permission.PROVIDE_RESOLVER_RANKER_SERVICE", resolveInfo.serviceInfo.packageName)) {
                        Log.w("ResolverComparator", "ResolverRankerService " + componentName + " does not hold" + " permission " + "android.permission.PROVIDE_RESOLVER_RANKER_SERVICE" + " - this service will not be queried for ResolverComparator.");
                    }
                    break block5;
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.e("ResolverComparator", "Could not look up service " + componentName + "; component name not found");
                }
                continue;
            }
            this.mResolvedRankerName = componentName;
            intent.setComponent(componentName);
            return intent;
        }
        return null;
    }

    private final void $$robo$$com_android_internal_app_ResolverComparator$startWatchDog(int timeOutLimit) {
        if (this.mHandler == null) {
            Log.d("ResolverComparator", "Error: Handler is Null; Needs to be initialized.");
        }
        this.mHandler.sendEmptyMessageDelayed(1, timeOutLimit);
    }

    private final void $$robo$$com_android_internal_app_ResolverComparator$reset() {
        this.mTargetsDict.clear();
        this.mTargets = null;
        this.mRankerServiceName = new ComponentName(this.mContext, this.getClass());
        this.mResolvedRankerName = null;
        this.startWatchDog(500);
        this.initRanker(this.mContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_app_ResolverComparator$predictSelectProbabilities(List<ResolverTarget> targets) {
        if (this.mConnection == null) {
            return;
        }
        try {
            this.mConnectSignal.await(200L, TimeUnit.MILLISECONDS);
            Object object = this.mLock;
            synchronized (object) {
                if (this.mRanker != null) {
                    this.mRanker.predict(targets, this.mConnection.resolverRankerResult);
                    return;
                }
            }
        }
        catch (InterruptedException e) {
            Log.e("ResolverComparator", "Error in Wait for Service Connection.");
        }
        catch (RemoteException e) {
            Log.e("ResolverComparator", "Error in Predict: " + e);
        }
        if (this.mAfterCompute != null) {
            this.mAfterCompute.afterCompute();
        }
    }

    private final void $$robo$$com_android_internal_app_ResolverComparator$addDefaultSelectProbability(ResolverTarget target) {
        float sum = 2.5543f * target.getLaunchScore() + 2.8412f * target.getTimeSpentScore() + 0.269f * target.getRecencyScore() + 4.2222f * target.getChooserScore();
        target.setSelectProbability((float)(1.0 / (1.0 + Math.exp(1.6568f - sum))));
    }

    private final void $$robo$$com_android_internal_app_ResolverComparator$setFeatures(ResolverTarget target, float recencyScore, float launchScore, float timeSpentScore, float chooserScore) {
        target.setRecencyScore(recencyScore);
        target.setLaunchScore(launchScore);
        target.setTimeSpentScore(timeSpentScore);
        target.setChooserScore(chooserScore);
    }

    private static final boolean $$robo$$com_android_internal_app_ResolverComparator$isPersistentProcess(ResolverActivity.ResolvedComponentInfo rci) {
        if (rci != null && rci.getCount() > 0) {
            return (rci.getResolveInfoAt((int)0).activityInfo.applicationInfo.flags & 8) != 0;
        }
        return false;
    }

    private void __constructor__(Context context, Intent intent, String string2, AfterCompute afterCompute) {
        this.$$robo$$com_android_internal_app_ResolverComparator$__constructor__(context, intent, string2, afterCompute);
    }

    public ResolverComparator(Context context, Intent intent, String string2, AfterCompute afterCompute) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverComparator$__constructor__(android.content.Context android.content.Intent java.lang.String com.android.internal.app.ResolverComparator$AfterCompute ), 0, this, context, intent, string2, afterCompute);
    }

    public void getContentAnnotations(Intent intent) {
        InvokeDynamicSupport.bootstrap("getContentAnnotations", $$robo$$com_android_internal_app_ResolverComparator$getContentAnnotations(android.content.Intent ), 0, this, intent);
    }

    public void setCallBack(AfterCompute afterCompute) {
        InvokeDynamicSupport.bootstrap("setCallBack", $$robo$$com_android_internal_app_ResolverComparator$setCallBack(com.android.internal.app.ResolverComparator$AfterCompute ), 0, this, afterCompute);
    }

    public void compute(List<ResolverActivity.ResolvedComponentInfo> list) {
        InvokeDynamicSupport.bootstrap("compute", $$robo$$com_android_internal_app_ResolverComparator$compute(java.util.List<com.android.internal.app.ResolverActivity$ResolvedComponentInfo> ), 0, this, list);
    }

    @Override
    public int compare(ResolverActivity.ResolvedComponentInfo resolvedComponentInfo, ResolverActivity.ResolvedComponentInfo resolvedComponentInfo2) {
        return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$com_android_internal_app_ResolverComparator$compare(com.android.internal.app.ResolverActivity$ResolvedComponentInfo com.android.internal.app.ResolverActivity$ResolvedComponentInfo ), 0, this, resolvedComponentInfo, resolvedComponentInfo2);
    }

    public float getScore(ComponentName componentName) {
        return (float)InvokeDynamicSupport.bootstrap("getScore", $$robo$$com_android_internal_app_ResolverComparator$getScore(android.content.ComponentName ), 0, this, componentName);
    }

    public void updateChooserCounts(String string2, int n, String string3) {
        InvokeDynamicSupport.bootstrap("updateChooserCounts", $$robo$$com_android_internal_app_ResolverComparator$updateChooserCounts(java.lang.String int java.lang.String ), 0, this, string2, n, string3);
    }

    public void updateModel(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("updateModel", $$robo$$com_android_internal_app_ResolverComparator$updateModel(android.content.ComponentName ), 0, this, componentName);
    }

    public void destroy() {
        InvokeDynamicSupport.bootstrap("destroy", $$robo$$com_android_internal_app_ResolverComparator$destroy(), 0, this);
    }

    private void logMetrics(int n) {
        InvokeDynamicSupport.bootstrap("logMetrics", $$robo$$com_android_internal_app_ResolverComparator$logMetrics(int ), 0, this, n);
    }

    private void initRanker(Context context) {
        InvokeDynamicSupport.bootstrap("initRanker", $$robo$$com_android_internal_app_ResolverComparator$initRanker(android.content.Context ), 0, this, context);
    }

    private Intent resolveRankerService() {
        return InvokeDynamicSupport.bootstrap("resolveRankerService", $$robo$$com_android_internal_app_ResolverComparator$resolveRankerService(), 0, this);
    }

    private void startWatchDog(int n) {
        InvokeDynamicSupport.bootstrap("startWatchDog", $$robo$$com_android_internal_app_ResolverComparator$startWatchDog(int ), 0, this, n);
    }

    private void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_app_ResolverComparator$reset(), 0, this);
    }

    private void predictSelectProbabilities(List<ResolverTarget> list) {
        InvokeDynamicSupport.bootstrap("predictSelectProbabilities", $$robo$$com_android_internal_app_ResolverComparator$predictSelectProbabilities(java.util.List<android.service.resolver.ResolverTarget> ), 0, this, list);
    }

    private void addDefaultSelectProbability(ResolverTarget resolverTarget) {
        InvokeDynamicSupport.bootstrap("addDefaultSelectProbability", $$robo$$com_android_internal_app_ResolverComparator$addDefaultSelectProbability(android.service.resolver.ResolverTarget ), 0, this, resolverTarget);
    }

    private void setFeatures(ResolverTarget resolverTarget, float f, float f2, float f3, float f4) {
        InvokeDynamicSupport.bootstrap("setFeatures", $$robo$$com_android_internal_app_ResolverComparator$setFeatures(android.service.resolver.ResolverTarget float float float float ), 0, this, resolverTarget, f, f2, f3, f4);
    }

    static boolean isPersistentProcess(ResolverActivity.ResolvedComponentInfo resolvedComponentInfo) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPersistentProcess", $$robo$$com_android_internal_app_ResolverComparator$isPersistentProcess(com.android.internal.app.ResolverActivity$ResolvedComponentInfo ), 0, (ResolverActivity.ResolvedComponentInfo)resolvedComponentInfo);
    }

    public /* synthetic */ ResolverComparator() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResolverComparator)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class ResolverRankerServiceConnection
    implements ServiceConnection,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private CountDownLatch mConnectSignal;
        public IResolverRankerResult resolverRankerResult;
        /* synthetic */ ResolverComparator this$0;

        private void $$robo$$com_android_internal_app_ResolverComparator_ResolverRankerServiceConnection$__constructor__(ResolverComparator resolverComparator, CountDownLatch connectSignal) {
            this.resolverRankerResult = new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ResolverRankerServiceConnection this$1;

                private void $$robo$$com_android_internal_app_ResolverComparator_ResolverRankerServiceConnection_1$__constructor__(ResolverRankerServiceConnection this$1) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$com_android_internal_app_ResolverComparator_ResolverRankerServiceConnection_1$sendResult(List<ResolverTarget> targets) throws RemoteException {
                    Object object = this.this$1.this$0.mLock;
                    synchronized (object) {
                        Message msg = Message.obtain();
                        msg.what = 0;
                        msg.obj = targets;
                        this.this$1.this$0.mHandler.sendMessage(msg);
                    }
                }

                private void __constructor__(ResolverRankerServiceConnection resolverRankerServiceConnection) {
                    this.$$robo$$com_android_internal_app_ResolverComparator_ResolverRankerServiceConnection_1$__constructor__(resolverRankerServiceConnection);
                }
                {
                    this.this$1 = resolverRankerServiceConnection;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverComparator_ResolverRankerServiceConnection_1$__constructor__(com.android.internal.app.ResolverComparator$ResolverRankerServiceConnection ), 0, this, resolverRankerServiceConnection);
                }

                @Override
                public void sendResult(List<ResolverTarget> list) throws RemoteException {
                    InvokeDynamicSupport.bootstrap("sendResult", $$robo$$com_android_internal_app_ResolverComparator_ResolverRankerServiceConnection_1$sendResult(java.util.List<android.service.resolver.ResolverTarget> ), 0, this, list);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mConnectSignal = connectSignal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_app_ResolverComparator_ResolverRankerServiceConnection$onServiceConnected(ComponentName name, IBinder service) {
            Object object = this.this$0.mLock;
            synchronized (object) {
                this.this$0.mRanker = IResolverRankerService.Stub.asInterface(service);
                this.mConnectSignal.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_app_ResolverComparator_ResolverRankerServiceConnection$onServiceDisconnected(ComponentName name) {
            Object object = this.this$0.mLock;
            synchronized (object) {
                this.destroy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_app_ResolverComparator_ResolverRankerServiceConnection$destroy() {
            Object object = this.this$0.mLock;
            synchronized (object) {
                this.this$0.mRanker = null;
            }
        }

        private void __constructor__(ResolverComparator resolverComparator, CountDownLatch countDownLatch) {
            this.$$robo$$com_android_internal_app_ResolverComparator_ResolverRankerServiceConnection$__constructor__(resolverComparator, countDownLatch);
        }

        public ResolverRankerServiceConnection(ResolverComparator resolverComparator, CountDownLatch countDownLatch) {
            this.this$0 = resolverComparator;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverComparator_ResolverRankerServiceConnection$__constructor__(com.android.internal.app.ResolverComparator java.util.concurrent.CountDownLatch ), 0, this, resolverComparator, countDownLatch);
        }

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$com_android_internal_app_ResolverComparator_ResolverRankerServiceConnection$onServiceConnected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$com_android_internal_app_ResolverComparator_ResolverRankerServiceConnection$onServiceDisconnected(android.content.ComponentName ), 0, this, componentName);
        }

        public void destroy() {
            InvokeDynamicSupport.bootstrap("destroy", $$robo$$com_android_internal_app_ResolverComparator_ResolverRankerServiceConnection$destroy(), 0, this);
        }

        public /* synthetic */ ResolverRankerServiceConnection() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResolverRankerServiceConnection)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface AfterCompute
    extends InstrumentedInterface {
        public void afterCompute();
    }
}

