/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app.procstats;

import android.os.Build;
import android.os.Parcel;
import android.util.Slog;
import com.android.internal.util.GrowingArrayUtils;
import java.util.ArrayList;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SparseMappingTable
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SparseMappingTable";
    public static int ARRAY_SIZE = 4096;
    public static int INVALID_KEY = -1;
    private static int ID_SHIFT = 0;
    private static int ID_MASK = 255;
    private static int ARRAY_SHIFT = 8;
    private static int ARRAY_MASK = 255;
    private static int INDEX_SHIFT = 16;
    private static int INDEX_MASK = 65535;
    private int mSequence;
    private int mNextIndex;
    private ArrayList<long[]> mLongs;

    private void $$robo$$com_android_internal_app_procstats_SparseMappingTable$__constructor__() {
        this.mLongs = new ArrayList();
        this.mLongs.add(new long[4096]);
    }

    private final void $$robo$$com_android_internal_app_procstats_SparseMappingTable$reset() {
        this.mLongs.clear();
        this.mLongs.add(new long[4096]);
        this.mNextIndex = 0;
        ++this.mSequence;
    }

    private final void $$robo$$com_android_internal_app_procstats_SparseMappingTable$writeToParcel(Parcel out) {
        out.writeInt(this.mSequence);
        out.writeInt(this.mNextIndex);
        int N = this.mLongs.size();
        out.writeInt(N);
        for (int i = 0; i < N - 1; ++i) {
            long[] array2 = this.mLongs.get(i);
            out.writeInt(array2.length);
            SparseMappingTable.writeCompactedLongArray(out, array2, array2.length);
        }
        long[] lastLongs = this.mLongs.get(N - 1);
        out.writeInt(this.mNextIndex);
        SparseMappingTable.writeCompactedLongArray(out, lastLongs, this.mNextIndex);
    }

    private final void $$robo$$com_android_internal_app_procstats_SparseMappingTable$readFromParcel(Parcel in) {
        this.mSequence = in.readInt();
        this.mNextIndex = in.readInt();
        this.mLongs.clear();
        int N = in.readInt();
        for (int i = 0; i < N; ++i) {
            int size = in.readInt();
            long[] array2 = new long[size];
            SparseMappingTable.readCompactedLongArray(in, array2, size);
            this.mLongs.add(array2);
        }
    }

    private final String $$robo$$com_android_internal_app_procstats_SparseMappingTable$dumpInternalState(boolean includeData) {
        StringBuilder sb = new StringBuilder();
        sb.append("SparseMappingTable{");
        sb.append("mSequence=");
        sb.append(this.mSequence);
        sb.append(" mNextIndex=");
        sb.append(this.mNextIndex);
        sb.append(" mLongs.size=");
        int N = this.mLongs.size();
        sb.append(N);
        sb.append("\n");
        if (includeData) {
            for (int i = 0; i < N; ++i) {
                long[] array2 = this.mLongs.get(i);
                for (int j = 0; j < array2.length && (i != N - 1 || j != this.mNextIndex); ++j) {
                    sb.append(String.format(" %4d %d 0x%016x %-19d\n", i, j, array2[j], array2[j]));
                }
            }
        }
        sb.append("}");
        return sb.toString();
    }

    private static final void $$robo$$com_android_internal_app_procstats_SparseMappingTable$writeCompactedLongArray(Parcel out, long[] array2, int num) {
        for (int i = 0; i < num; ++i) {
            long val = array2[i];
            if (val < 0L) {
                Slog.w("SparseMappingTable", "Time val negative: " + val);
                val = 0L;
            }
            if (val <= Integer.MAX_VALUE) {
                out.writeInt((int)val);
                continue;
            }
            int top = ~((int)(val >> 32 & Integer.MAX_VALUE));
            int bottom = (int)(val & 0xFFFFFFFFL);
            out.writeInt(top);
            out.writeInt(bottom);
        }
    }

    private static final void $$robo$$com_android_internal_app_procstats_SparseMappingTable$readCompactedLongArray(Parcel in, long[] array2, int num) {
        int i;
        int alen = array2.length;
        if (num > alen) {
            SparseMappingTable.logOrThrow("bad array lengths: got " + num + " array is " + alen);
            return;
        }
        for (i = 0; i < num; ++i) {
            int val = in.readInt();
            if (val >= 0) {
                array2[i] = val;
                continue;
            }
            int bottom = in.readInt();
            array2[i] = (long)(~val) << 32 | (long)bottom;
        }
        while (i < alen) {
            array2[i] = 0L;
            ++i;
        }
    }

    private static final byte $$robo$$com_android_internal_app_procstats_SparseMappingTable$getIdFromKey(int key) {
        return (byte)(key >> 0 & 0xFF);
    }

    private static final int $$robo$$com_android_internal_app_procstats_SparseMappingTable$getArrayFromKey(int key) {
        return key >> 8 & 0xFF;
    }

    private static final int $$robo$$com_android_internal_app_procstats_SparseMappingTable$getIndexFromKey(int key) {
        return key >> 16 & 0xFFFF;
    }

    private static final void $$robo$$com_android_internal_app_procstats_SparseMappingTable$logOrThrow(String message) {
        SparseMappingTable.logOrThrow(message, new RuntimeException("Stack trace"));
    }

    private static final void $$robo$$com_android_internal_app_procstats_SparseMappingTable$logOrThrow(String message, Throwable th) {
        Slog.e("SparseMappingTable", message, th);
        if (Build.IS_ENG) {
            throw new RuntimeException(message, th);
        }
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_app_procstats_SparseMappingTable$__constructor__();
    }

    public SparseMappingTable() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_procstats_SparseMappingTable$__constructor__(), 0, this);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_app_procstats_SparseMappingTable$reset(), 0, this);
    }

    public void writeToParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_app_procstats_SparseMappingTable$writeToParcel(android.os.Parcel ), 0, this, parcel);
    }

    public void readFromParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$com_android_internal_app_procstats_SparseMappingTable$readFromParcel(android.os.Parcel ), 0, this, parcel);
    }

    public String dumpInternalState(boolean bl) {
        return InvokeDynamicSupport.bootstrap("dumpInternalState", $$robo$$com_android_internal_app_procstats_SparseMappingTable$dumpInternalState(boolean ), 0, this, bl);
    }

    private static void writeCompactedLongArray(Parcel parcel, long[] lArray, int n) {
        InvokeDynamicSupport.bootstrapStatic("writeCompactedLongArray", $$robo$$com_android_internal_app_procstats_SparseMappingTable$writeCompactedLongArray(android.os.Parcel long[] int ), 0, (Parcel)parcel, (long[])lArray, (int)n);
    }

    private static void readCompactedLongArray(Parcel parcel, long[] lArray, int n) {
        InvokeDynamicSupport.bootstrapStatic("readCompactedLongArray", $$robo$$com_android_internal_app_procstats_SparseMappingTable$readCompactedLongArray(android.os.Parcel long[] int ), 0, (Parcel)parcel, (long[])lArray, (int)n);
    }

    public static byte getIdFromKey(int n) {
        return (byte)InvokeDynamicSupport.bootstrapStatic("getIdFromKey", $$robo$$com_android_internal_app_procstats_SparseMappingTable$getIdFromKey(int ), 0, (int)n);
    }

    public static int getArrayFromKey(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getArrayFromKey", $$robo$$com_android_internal_app_procstats_SparseMappingTable$getArrayFromKey(int ), 0, (int)n);
    }

    public static int getIndexFromKey(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getIndexFromKey", $$robo$$com_android_internal_app_procstats_SparseMappingTable$getIndexFromKey(int ), 0, (int)n);
    }

    private static void logOrThrow(String string2) {
        InvokeDynamicSupport.bootstrapStatic("logOrThrow", $$robo$$com_android_internal_app_procstats_SparseMappingTable$logOrThrow(java.lang.String ), 0, (String)string2);
    }

    private static void logOrThrow(String string2, Throwable throwable) {
        InvokeDynamicSupport.bootstrapStatic("logOrThrow", $$robo$$com_android_internal_app_procstats_SparseMappingTable$logOrThrow(java.lang.String java.lang.Throwable ), 0, (String)string2, (Throwable)throwable);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SparseMappingTable)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Table
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private SparseMappingTable mParent;
        private int mSequence;
        private int[] mTable;
        private int mSize;

        private void $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$__constructor__(SparseMappingTable parent) {
            this.mSequence = 1;
            this.mParent = parent;
            this.mSequence = parent.mSequence;
        }

        private final void $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$copyFrom(Table copyFrom, int valueCount) {
            this.mTable = null;
            this.mSize = 0;
            int N = copyFrom.getKeyCount();
            for (int i = 0; i < N; ++i) {
                int theirKey = copyFrom.getKeyAt(i);
                long[] theirLongs = (long[])copyFrom.mParent.mLongs.get(SparseMappingTable.getArrayFromKey(theirKey));
                byte id2 = SparseMappingTable.getIdFromKey(theirKey);
                int myKey = this.getOrAddKey(id2, valueCount);
                long[] myLongs = (long[])this.mParent.mLongs.get(SparseMappingTable.getArrayFromKey(myKey));
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (long[])theirLongs, (int)SparseMappingTable.getIndexFromKey(theirKey), (long[])myLongs, (int)SparseMappingTable.getIndexFromKey(myKey), (int)valueCount);
            }
        }

        private final int $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$getOrAddKey(byte id2, int count) {
            this.assertConsistency();
            int idx = this.binarySearch(id2);
            if (idx >= 0) {
                return this.mTable[idx];
            }
            ArrayList list = this.mParent.mLongs;
            int whichArray = list.size() - 1;
            long[] array2 = (long[])list.get(whichArray);
            if (this.mParent.mNextIndex + count > array2.length) {
                array2 = new long[4096];
                list.add(array2);
                ++whichArray;
                this.mParent.mNextIndex = 0;
            }
            int key = whichArray << 8 | this.mParent.mNextIndex << 16 | id2 << 0;
            SparseMappingTable sparseMappingTable = this.mParent;
            sparseMappingTable.mNextIndex = sparseMappingTable.mNextIndex + count;
            this.mTable = GrowingArrayUtils.insert(this.mTable != null ? this.mTable : EmptyArray.INT, this.mSize, ~idx, key);
            ++this.mSize;
            return key;
        }

        private final int $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$getKey(byte id2) {
            this.assertConsistency();
            int idx = this.binarySearch(id2);
            if (idx >= 0) {
                return this.mTable[idx];
            }
            return -1;
        }

        private final long $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$getValue(int key) {
            return this.getValue(key, 0);
        }

        private final long $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$getValue(int key, int index) {
            this.assertConsistency();
            try {
                long[] array2 = (long[])this.mParent.mLongs.get(SparseMappingTable.getArrayFromKey(key));
                return array2[SparseMappingTable.getIndexFromKey(key) + index];
            }
            catch (IndexOutOfBoundsException ex) {
                SparseMappingTable.logOrThrow("key=0x" + Integer.toHexString(key) + " index=" + index + " -- " + this.dumpInternalState(), ex);
                return 0L;
            }
        }

        private final long $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$getValueForId(byte id2) {
            return this.getValueForId(id2, 0);
        }

        private final long $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$getValueForId(byte id2, int index) {
            this.assertConsistency();
            int idx = this.binarySearch(id2);
            if (idx >= 0) {
                int key = this.mTable[idx];
                try {
                    long[] array2 = (long[])this.mParent.mLongs.get(SparseMappingTable.getArrayFromKey(key));
                    return array2[SparseMappingTable.getIndexFromKey(key) + index];
                }
                catch (IndexOutOfBoundsException ex) {
                    SparseMappingTable.logOrThrow("id=0x" + Integer.toHexString(id2) + " idx=" + idx + " key=0x" + Integer.toHexString(key) + " index=" + index + " -- " + this.dumpInternalState(), ex);
                    return 0L;
                }
            }
            return 0L;
        }

        private final long[] $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$getArrayForKey(int key) {
            this.assertConsistency();
            return (long[])this.mParent.mLongs.get(SparseMappingTable.getArrayFromKey(key));
        }

        private final void $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$setValue(int key, long value) {
            this.setValue(key, 0, value);
        }

        private final void $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$setValue(int key, int index, long value) {
            this.assertConsistency();
            if (value < 0L) {
                SparseMappingTable.logOrThrow("can't store negative values key=0x" + Integer.toHexString(key) + " index=" + index + " value=" + value + " -- " + this.dumpInternalState());
                return;
            }
            try {
                long[] array2 = (long[])this.mParent.mLongs.get(SparseMappingTable.getArrayFromKey(key));
                array2[SparseMappingTable.getIndexFromKey((int)key) + index] = value;
            }
            catch (IndexOutOfBoundsException ex) {
                SparseMappingTable.logOrThrow("key=0x" + Integer.toHexString(key) + " index=" + index + " value=" + value + " -- " + this.dumpInternalState(), ex);
                return;
            }
        }

        private final void $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$resetTable() {
            this.mTable = null;
            this.mSize = 0;
            this.mSequence = this.mParent.mSequence;
        }

        private final void $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$writeToParcel(Parcel out) {
            out.writeInt(this.mSequence);
            out.writeInt(this.mSize);
            for (int i = 0; i < this.mSize; ++i) {
                out.writeInt(this.mTable[i]);
            }
        }

        private final boolean $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$readFromParcel(Parcel in) {
            this.mSequence = in.readInt();
            this.mSize = in.readInt();
            if (this.mSize != 0) {
                this.mTable = new int[this.mSize];
                for (int i = 0; i < this.mSize; ++i) {
                    this.mTable[i] = in.readInt();
                }
            } else {
                this.mTable = null;
            }
            if (this.validateKeys(true)) {
                return true;
            }
            this.mSize = 0;
            this.mTable = null;
            return false;
        }

        private final int $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$getKeyCount() {
            return this.mSize;
        }

        private final int $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$getKeyAt(int i) {
            return this.mTable[i];
        }

        private final void $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$assertConsistency() {
        }

        private final int $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$binarySearch(byte id2) {
            int lo = 0;
            int hi = this.mSize - 1;
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                byte midId = (byte)(this.mTable[mid] >> 0 & 0xFF);
                if (midId < id2) {
                    lo = mid + 1;
                    continue;
                }
                if (midId > id2) {
                    hi = mid - 1;
                    continue;
                }
                return mid;
            }
            return ~lo;
        }

        private final boolean $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$validateKeys(boolean log) {
            ArrayList longs = this.mParent.mLongs;
            int longsSize = longs.size();
            int N = this.mSize;
            for (int i = 0; i < N; ++i) {
                int key = this.mTable[i];
                int arrayIndex = SparseMappingTable.getArrayFromKey(key);
                int index = SparseMappingTable.getIndexFromKey(key);
                if (arrayIndex < longsSize && index < ((long[])longs.get(arrayIndex)).length) continue;
                if (log) {
                    Slog.w("SparseMappingTable", "Invalid stats at index " + i + " -- " + this.dumpInternalState());
                }
                return false;
            }
            return true;
        }

        private final String $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$dumpInternalState() {
            StringBuilder sb = new StringBuilder();
            sb.append("SparseMappingTable.Table{mSequence=");
            sb.append(this.mSequence);
            sb.append(" mParent.mSequence=");
            sb.append(this.mParent.mSequence);
            sb.append(" mParent.mLongs.size()=");
            sb.append(this.mParent.mLongs.size());
            sb.append(" mSize=");
            sb.append(this.mSize);
            sb.append(" mTable=");
            if (this.mTable == null) {
                sb.append("null");
            } else {
                int N = this.mTable.length;
                sb.append('[');
                for (int i = 0; i < N; ++i) {
                    int key = this.mTable[i];
                    sb.append("0x");
                    sb.append(Integer.toHexString(key >> 0 & 0xFF));
                    sb.append("/0x");
                    sb.append(Integer.toHexString(key >> 8 & 0xFF));
                    sb.append("/0x");
                    sb.append(Integer.toHexString(key >> 16 & 0xFFFF));
                    if (i == N - 1) continue;
                    sb.append(", ");
                }
                sb.append(']');
            }
            sb.append(" clazz=");
            sb.append(this.getClass().getName());
            sb.append('}');
            return sb.toString();
        }

        private void __constructor__(SparseMappingTable sparseMappingTable) {
            this.$$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$__constructor__(sparseMappingTable);
        }

        public Table(SparseMappingTable sparseMappingTable) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$__constructor__(com.android.internal.app.procstats.SparseMappingTable ), 0, this, sparseMappingTable);
        }

        public void copyFrom(Table table, int n) {
            InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$copyFrom(com.android.internal.app.procstats.SparseMappingTable$Table int ), 0, this, table, n);
        }

        public int getOrAddKey(byte by, int n) {
            return (int)InvokeDynamicSupport.bootstrap("getOrAddKey", $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$getOrAddKey(byte int ), 0, this, by, n);
        }

        public int getKey(byte by) {
            return (int)InvokeDynamicSupport.bootstrap("getKey", $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$getKey(byte ), 0, this, by);
        }

        public long getValue(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getValue", $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$getValue(int ), 0, this, n);
        }

        public long getValue(int n, int n2) {
            return (long)InvokeDynamicSupport.bootstrap("getValue", $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$getValue(int int ), 0, this, n, n2);
        }

        public long getValueForId(byte by) {
            return (long)InvokeDynamicSupport.bootstrap("getValueForId", $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$getValueForId(byte ), 0, this, by);
        }

        public long getValueForId(byte by, int n) {
            return (long)InvokeDynamicSupport.bootstrap("getValueForId", $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$getValueForId(byte int ), 0, this, by, n);
        }

        public long[] getArrayForKey(int n) {
            return InvokeDynamicSupport.bootstrap("getArrayForKey", $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$getArrayForKey(int ), 0, this, n);
        }

        public void setValue(int n, long l) {
            InvokeDynamicSupport.bootstrap("setValue", $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$setValue(int long ), 0, this, n, l);
        }

        public void setValue(int n, int n2, long l) {
            InvokeDynamicSupport.bootstrap("setValue", $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$setValue(int int long ), 0, this, n, n2, l);
        }

        public void resetTable() {
            InvokeDynamicSupport.bootstrap("resetTable", $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$resetTable(), 0, this);
        }

        public void writeToParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$writeToParcel(android.os.Parcel ), 0, this, parcel);
        }

        public boolean readFromParcel(Parcel parcel) {
            return (boolean)InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$readFromParcel(android.os.Parcel ), 0, this, parcel);
        }

        public int getKeyCount() {
            return (int)InvokeDynamicSupport.bootstrap("getKeyCount", $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$getKeyCount(), 0, this);
        }

        public int getKeyAt(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getKeyAt", $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$getKeyAt(int ), 0, this, n);
        }

        private void assertConsistency() {
            InvokeDynamicSupport.bootstrap("assertConsistency", $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$assertConsistency(), 0, this);
        }

        private int binarySearch(byte by) {
            return (int)InvokeDynamicSupport.bootstrap("binarySearch", $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$binarySearch(byte ), 0, this, by);
        }

        private boolean validateKeys(boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("validateKeys", $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$validateKeys(boolean ), 0, this, bl);
        }

        public String dumpInternalState() {
            return InvokeDynamicSupport.bootstrap("dumpInternalState", $$robo$$com_android_internal_app_procstats_SparseMappingTable_Table$dumpInternalState(), 0, this);
        }

        public /* synthetic */ Table() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Table)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

