/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.colorextraction.drawable;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.view.animation.DecelerateInterpolator;
import com.android.internal.colorextraction.ColorExtractor;
import com.android.internal.graphics.ColorUtils;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GradientDrawable
extends Drawable
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "GradientDrawable";
    private static float CENTRALIZED_CIRCLE_1 = -2.0f;
    private static int GRADIENT_RADIUS = 480;
    private static long COLOR_ANIMATION_DURATION = 2000L;
    private int mAlpha;
    private float mDensity;
    private Paint mPaint;
    private Rect mWindowBounds;
    private Splat mSplat;
    private int mMainColor;
    private int mSecondaryColor;
    private ValueAnimator mColorAnimation;

    private void $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$__constructor__(Context context) {
        this.mAlpha = 255;
        this.mDensity = context.getResources().getDisplayMetrics().density;
        this.mSplat = new Splat(0.5f, 1.0f, 480.0f, -2.0f);
        this.mWindowBounds = new Rect();
        this.mPaint = new Paint();
        this.mPaint.setStyle(Paint.Style.FILL);
    }

    private final void $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$setColors(ColorExtractor.GradientColors colors) {
        this.setColors(colors.getMainColor(), colors.getSecondaryColor(), true);
    }

    private final void $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$setColors(ColorExtractor.GradientColors colors, boolean animated) {
        this.setColors(colors.getMainColor(), colors.getSecondaryColor(), animated);
    }

    private final void $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$setColors(int mainColor, int secondaryColor, boolean animated) {
        if (mainColor == this.mMainColor && secondaryColor == this.mSecondaryColor) {
            return;
        }
        if (this.mColorAnimation != null && this.mColorAnimation.isRunning()) {
            this.mColorAnimation.cancel();
        }
        if (animated) {
            int mainFrom = this.mMainColor;
            int secFrom = this.mSecondaryColor;
            ValueAnimator anim2 = ValueAnimator.ofFloat(0.0f, 1.0f);
            anim2.setDuration(2000L);
            anim2.addUpdateListener(animation -> {
                float ratio = ((Float)animation.getAnimatedValue()).floatValue();
                this.mMainColor = ColorUtils.blendARGB(mainFrom, mainColor, ratio);
                this.mSecondaryColor = ColorUtils.blendARGB(secFrom, secondaryColor, ratio);
                this.buildPaints();
                this.invalidateSelf();
            });
            anim2.addListener((Animator.AnimatorListener)new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ GradientDrawable this$0;

                private void $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable_1$__constructor__(GradientDrawable this$0) {
                }

                private final void $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable_1$onAnimationEnd(Animator animation, boolean isReverse) {
                    if (this.this$0.mColorAnimation == animation) {
                        this.this$0.mColorAnimation = null;
                    }
                }

                private void __constructor__(GradientDrawable gradientDrawable) {
                    this.$$robo$$com_android_internal_colorextraction_drawable_GradientDrawable_1$__constructor__(gradientDrawable);
                }
                {
                    this.this$0 = gradientDrawable;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable_1$__constructor__(com.android.internal.colorextraction.drawable.GradientDrawable ), 0, this, gradientDrawable);
                }

                @Override
                public void onAnimationEnd(Animator animator2, boolean bl) {
                    InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable_1$onAnimationEnd(android.animation.Animator boolean ), 0, this, animator2, bl);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            anim2.setInterpolator(new DecelerateInterpolator());
            anim2.start();
            this.mColorAnimation = anim2;
        } else {
            this.mMainColor = mainColor;
            this.mSecondaryColor = secondaryColor;
            this.buildPaints();
            this.invalidateSelf();
        }
    }

    private final void $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$setAlpha(int alpha) {
        if (alpha != this.mAlpha) {
            this.mAlpha = alpha;
            this.mPaint.setAlpha(this.mAlpha);
            this.invalidateSelf();
        }
    }

    private final int $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$getAlpha() {
        return this.mAlpha;
    }

    private final void $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$setXfermode(Xfermode mode) {
        this.mPaint.setXfermode(mode);
        this.invalidateSelf();
    }

    private final void $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
    }

    private final ColorFilter $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$getColorFilter() {
        return this.mPaint.getColorFilter();
    }

    private final int $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$getOpacity() {
        return -3;
    }

    private final void $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$setScreenSize(int width, int height) {
        this.mWindowBounds.set(0, 0, width, height);
        this.setBounds(0, 0, width, height);
        this.buildPaints();
    }

    private final void $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$buildPaints() {
        Rect bounds = this.mWindowBounds;
        if (bounds.width() == 0) {
            return;
        }
        float w = bounds.width();
        float h = bounds.height();
        float x = this.mSplat.x * w;
        float y = this.mSplat.y * h;
        float radius = this.mSplat.radius * this.mDensity;
        RadialGradient radialGradient = new RadialGradient(x, y, radius, this.mSecondaryColor, this.mMainColor, Shader.TileMode.CLAMP);
        this.mPaint.setShader(radialGradient);
    }

    private final void $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$draw(Canvas canvas) {
        Rect bounds = this.mWindowBounds;
        if (bounds.width() == 0) {
            throw new IllegalStateException("You need to call setScreenSize before drawing.");
        }
        float w = bounds.width();
        float h = bounds.height();
        float x = this.mSplat.x * w;
        float y = this.mSplat.y * h;
        float radius = Math.max(w, h);
        canvas.drawRect(x - radius, y - radius, x + radius, y + radius, this.mPaint);
    }

    private final int $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$getMainColor() {
        return this.mMainColor;
    }

    private final int $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$getSecondaryColor() {
        return this.mSecondaryColor;
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$__constructor__(context);
    }

    public GradientDrawable(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$__constructor__(android.content.Context ), 0, this, context);
    }

    public void setColors(ColorExtractor.GradientColors gradientColors) {
        InvokeDynamicSupport.bootstrap("setColors", $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$setColors(com.android.internal.colorextraction.ColorExtractor$GradientColors ), 0, this, gradientColors);
    }

    public void setColors(ColorExtractor.GradientColors gradientColors, boolean bl) {
        InvokeDynamicSupport.bootstrap("setColors", $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$setColors(com.android.internal.colorextraction.ColorExtractor$GradientColors boolean ), 0, this, gradientColors, bl);
    }

    public void setColors(int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setColors", $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$setColors(int int boolean ), 0, this, n, n2, bl);
    }

    @Override
    public void setAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$setAlpha(int ), 0, this, n);
    }

    @Override
    public int getAlpha() {
        return (int)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$getAlpha(), 0, this);
    }

    @Override
    public void setXfermode(Xfermode xfermode) {
        InvokeDynamicSupport.bootstrap("setXfermode", $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$setXfermode(android.graphics.Xfermode ), 0, this, xfermode);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$setColorFilter(android.graphics.ColorFilter ), 0, this, colorFilter);
    }

    @Override
    public ColorFilter getColorFilter() {
        return InvokeDynamicSupport.bootstrap("getColorFilter", $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$getColorFilter(), 0, this);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$getOpacity(), 0, this);
    }

    public void setScreenSize(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setScreenSize", $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$setScreenSize(int int ), 0, this, n, n2);
    }

    private void buildPaints() {
        InvokeDynamicSupport.bootstrap("buildPaints", $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$buildPaints(), 0, this);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    public int getMainColor() {
        return (int)InvokeDynamicSupport.bootstrap("getMainColor", $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$getMainColor(), 0, this);
    }

    public int getSecondaryColor() {
        return (int)InvokeDynamicSupport.bootstrap("getSecondaryColor", $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable$getSecondaryColor(), 0, this);
    }

    public /* synthetic */ GradientDrawable() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GradientDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Splat
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        float x;
        float y;
        float radius;
        float colorIndex;

        private void $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable_Splat$__constructor__(float x, float y, float radius, float colorIndex) {
            this.x = x;
            this.y = y;
            this.radius = radius;
            this.colorIndex = colorIndex;
        }

        private void __constructor__(float f, float f2, float f3, float f4) {
            this.$$robo$$com_android_internal_colorextraction_drawable_GradientDrawable_Splat$__constructor__(f, f2, f3, f4);
        }

        Splat(float f, float f2, float f3, float f4) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_colorextraction_drawable_GradientDrawable_Splat$__constructor__(float float float float ), 0, this, f, f2, f3, f4);
        }

        public /* synthetic */ Splat() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Splat)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

