/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.colorextraction.types;

import android.app.WallpaperColors;
import android.content.Context;
import android.content.res.XmlResourceParser;
import android.graphics.Color;
import android.util.Log;
import android.util.MathUtils;
import android.util.Range;
import com.android.internal.colorextraction.ColorExtractor;
import com.android.internal.colorextraction.types.ExtractionType;
import com.android.internal.graphics.ColorUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class Tonal
implements ExtractionType,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Tonal";
    private static float FIT_WEIGHT_H = 1.0f;
    private static float FIT_WEIGHT_S = 1.0f;
    private static float FIT_WEIGHT_L = 10.0f;
    private static boolean DEBUG = true;
    public static int THRESHOLD_COLOR_LIGHT = -2039584;
    public static int MAIN_COLOR_LIGHT = -2039584;
    public static int SECONDARY_COLOR_LIGHT = -6381922;
    public static int THRESHOLD_COLOR_DARK = -14606047;
    public static int MAIN_COLOR_DARK = -16777216;
    public static int SECONDARY_COLOR_DARK = -16777216;
    private TonalPalette mGreyPalette;
    private ArrayList<TonalPalette> mTonalPalettes;
    private ArrayList<ColorRange> mBlacklistedColors;
    private float[] mTmpHSL;

    private void $$robo$$com_android_internal_colorextraction_types_Tonal$__constructor__(Context context) {
        this.mTmpHSL = new float[3];
        ConfigParser parser = new ConfigParser(context);
        this.mTonalPalettes = parser.getTonalPalettes();
        this.mBlacklistedColors = parser.getBlacklistedColors();
        this.mGreyPalette = this.mTonalPalettes.get(0);
        this.mTonalPalettes.remove(0);
    }

    private final void $$robo$$com_android_internal_colorextraction_types_Tonal$extractInto(WallpaperColors inWallpaperColors, ColorExtractor.GradientColors outColorsNormal, ColorExtractor.GradientColors outColorsDark, ColorExtractor.GradientColors outColorsExtraDark) {
        boolean success = this.runTonalExtraction(inWallpaperColors, outColorsNormal, outColorsDark, outColorsExtraDark);
        if (!success) {
            this.applyFallback(inWallpaperColors, outColorsNormal, outColorsDark, outColorsExtraDark);
        }
    }

    private final boolean $$robo$$com_android_internal_colorextraction_types_Tonal$runTonalExtraction(WallpaperColors inWallpaperColors, ColorExtractor.GradientColors outColorsNormal, ColorExtractor.GradientColors outColorsDark, ColorExtractor.GradientColors outColorsExtraDark) {
        boolean generatedFromBitmap;
        if (inWallpaperColors == null) {
            return false;
        }
        List<Color> mainColors = inWallpaperColors.getMainColors();
        int mainColorsSize = mainColors.size();
        int hints = inWallpaperColors.getColorHints();
        boolean supportsDarkText = (hints & 1) != 0;
        boolean bl = generatedFromBitmap = (hints & 4) != 0;
        if (mainColorsSize == 0) {
            return false;
        }
        Color bestColor = null;
        float[] hsl = new float[3];
        for (int i = 0; i < mainColorsSize; ++i) {
            Color color2 = mainColors.get(i);
            int colorValue = color2.toArgb();
            ColorUtils.RGBToHSL(Color.red(colorValue), Color.green(colorValue), Color.blue(colorValue), hsl);
            if (generatedFromBitmap && this.isBlacklisted(hsl)) continue;
            bestColor = color2;
            break;
        }
        if (bestColor == null) {
            return false;
        }
        int colorValue = bestColor.toArgb();
        ColorUtils.RGBToHSL(Color.red(colorValue), Color.green(colorValue), Color.blue(colorValue), hsl);
        hsl[0] = hsl[0] / 360.0f;
        TonalPalette palette = this.findTonalPalette(hsl[0], hsl[1]);
        if (palette == null) {
            Log.w("Tonal", "Could not find a tonal palette!");
            return false;
        }
        int fitIndex = Tonal.bestFit(palette, hsl[0], hsl[1], hsl[2]);
        if (fitIndex == -1) {
            Log.w("Tonal", "Could not find best fit!");
            return false;
        }
        float[] h = Tonal.fit(palette.h, hsl[0], fitIndex, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY);
        float[] s = Tonal.fit(palette.s, hsl[1], fitIndex, 0.0f, 1.0f);
        float[] l = Tonal.fit(palette.l, hsl[2], fitIndex, 0.0f, 1.0f);
        StringBuilder builder = new StringBuilder("Tonal Palette - index: " + fitIndex + ". Main color: " + Integer.toHexString(this.getColorInt(fitIndex, h, s, l)) + "\nColors: ");
        for (int i = 0; i < h.length; ++i) {
            builder.append(Integer.toHexString(this.getColorInt(i, h, s, l)));
            if (i >= h.length - 1) continue;
            builder.append(", ");
        }
        Log.d("Tonal", builder.toString());
        int primaryIndex = fitIndex;
        int mainColor = this.getColorInt(primaryIndex, h, s, l);
        ColorUtils.colorToHSL(mainColor, this.mTmpHSL);
        float mainLuminosity = this.mTmpHSL[2];
        ColorUtils.colorToHSL(-2039584, this.mTmpHSL);
        float lightLuminosity = this.mTmpHSL[2];
        if (mainLuminosity > lightLuminosity) {
            return false;
        }
        ColorUtils.colorToHSL(-14606047, this.mTmpHSL);
        float darkLuminosity = this.mTmpHSL[2];
        if (mainLuminosity < darkLuminosity) {
            return false;
        }
        outColorsNormal.setMainColor(mainColor);
        int secondaryIndex = primaryIndex + (primaryIndex >= 2 ? -2 : 2);
        outColorsNormal.setSecondaryColor(this.getColorInt(secondaryIndex, h, s, l));
        primaryIndex = supportsDarkText ? h.length - 1 : (fitIndex < 2 ? 0 : Math.min(fitIndex, 3));
        secondaryIndex = primaryIndex + (primaryIndex >= 2 ? -2 : 2);
        outColorsDark.setMainColor(this.getColorInt(primaryIndex, h, s, l));
        outColorsDark.setSecondaryColor(this.getColorInt(secondaryIndex, h, s, l));
        primaryIndex = supportsDarkText ? h.length - 1 : (fitIndex < 2 ? 0 : 2);
        secondaryIndex = primaryIndex + (primaryIndex >= 2 ? -2 : 2);
        outColorsExtraDark.setMainColor(this.getColorInt(primaryIndex, h, s, l));
        outColorsExtraDark.setSecondaryColor(this.getColorInt(secondaryIndex, h, s, l));
        outColorsNormal.setSupportsDarkText(supportsDarkText);
        outColorsDark.setSupportsDarkText(supportsDarkText);
        outColorsExtraDark.setSupportsDarkText(supportsDarkText);
        Log.d("Tonal", "Gradients: \n\tNormal " + outColorsNormal + "\n\tDark " + outColorsDark + "\n\tExtra dark: " + outColorsExtraDark);
        return true;
    }

    private final void $$robo$$com_android_internal_colorextraction_types_Tonal$applyFallback(WallpaperColors inWallpaperColors, ColorExtractor.GradientColors outColorsNormal, ColorExtractor.GradientColors outColorsDark, ColorExtractor.GradientColors outColorsExtraDark) {
        Tonal.applyFallback(inWallpaperColors, outColorsNormal);
        Tonal.applyFallback(inWallpaperColors, outColorsDark);
        Tonal.applyFallback(inWallpaperColors, outColorsExtraDark);
    }

    private static final void $$robo$$com_android_internal_colorextraction_types_Tonal$applyFallback(WallpaperColors inWallpaperColors, ColorExtractor.GradientColors outGradientColors) {
        boolean light = inWallpaperColors != null && (inWallpaperColors.getColorHints() & 1) != 0;
        int innerColor = light ? -2039584 : -16777216;
        int outerColor = light ? -6381922 : -16777216;
        outGradientColors.setMainColor(innerColor);
        outGradientColors.setSecondaryColor(outerColor);
        outGradientColors.setSupportsDarkText(light);
    }

    private final int $$robo$$com_android_internal_colorextraction_types_Tonal$getColorInt(int fitIndex, float[] h, float[] s, float[] l) {
        this.mTmpHSL[0] = Tonal.fract(h[fitIndex]) * 360.0f;
        this.mTmpHSL[1] = s[fitIndex];
        this.mTmpHSL[2] = l[fitIndex];
        return ColorUtils.HSLToColor(this.mTmpHSL);
    }

    private final boolean $$robo$$com_android_internal_colorextraction_types_Tonal$isBlacklisted(float[] hsl) {
        for (int i = this.mBlacklistedColors.size() - 1; i >= 0; --i) {
            ColorRange badRange = this.mBlacklistedColors.get(i);
            if (!badRange.containsColor(hsl[0], hsl[1], hsl[2])) continue;
            return true;
        }
        return false;
    }

    private static final float[] $$robo$$com_android_internal_colorextraction_types_Tonal$fit(float[] data, float v, int index, float min, float max) {
        float[] fitData = new float[data.length];
        float delta = v - data[index];
        for (int i = 0; i < data.length; ++i) {
            fitData[i] = MathUtils.constrain(data[i] + delta, min, max);
        }
        return fitData;
    }

    private static final int $$robo$$com_android_internal_colorextraction_types_Tonal$bestFit(TonalPalette palette, float h, float s, float l) {
        int minErrorIndex = -1;
        float minError = Float.POSITIVE_INFINITY;
        for (int i = 0; i < palette.h.length; ++i) {
            float error = 1.0f * Math.abs(h - palette.h[i]) + 1.0f * Math.abs(s - palette.s[i]) + 10.0f * Math.abs(l - palette.l[i]);
            if (!(error < minError)) continue;
            minError = error;
            minErrorIndex = i;
        }
        return minErrorIndex;
    }

    private final List<ColorRange> $$robo$$com_android_internal_colorextraction_types_Tonal$getBlacklistedColors() {
        return this.mBlacklistedColors;
    }

    private final TonalPalette $$robo$$com_android_internal_colorextraction_types_Tonal$findTonalPalette(float h, float s) {
        if (s < 0.05f) {
            return this.mGreyPalette;
        }
        TonalPalette best = null;
        float error = Float.POSITIVE_INFINITY;
        int tonalPalettesCount = this.mTonalPalettes.size();
        for (int i = 0; i < tonalPalettesCount; ++i) {
            TonalPalette candidate = this.mTonalPalettes.get(i);
            if (h >= candidate.minHue && h <= candidate.maxHue) {
                best = candidate;
                break;
            }
            if (candidate.maxHue > 1.0f && h >= 0.0f && h <= Tonal.fract(candidate.maxHue)) {
                best = candidate;
                break;
            }
            if (candidate.minHue < 0.0f && h >= Tonal.fract(candidate.minHue) && h <= 1.0f) {
                best = candidate;
                break;
            }
            if (h <= candidate.minHue && candidate.minHue - h < error) {
                best = candidate;
                error = candidate.minHue - h;
                continue;
            }
            if (h >= candidate.maxHue && h - candidate.maxHue < error) {
                best = candidate;
                error = h - candidate.maxHue;
                continue;
            }
            if (candidate.maxHue > 1.0f && h >= Tonal.fract(candidate.maxHue) && h - Tonal.fract(candidate.maxHue) < error) {
                best = candidate;
                error = h - Tonal.fract(candidate.maxHue);
                continue;
            }
            if (!(candidate.minHue < 0.0f) || !(h <= Tonal.fract(candidate.minHue)) || !(Tonal.fract(candidate.minHue) - h < error)) continue;
            best = candidate;
            error = Tonal.fract(candidate.minHue) - h;
        }
        return best;
    }

    private static final float $$robo$$com_android_internal_colorextraction_types_Tonal$fract(float v) {
        return v - (float)Math.floor(v);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_colorextraction_types_Tonal$__constructor__(context);
    }

    public Tonal(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_colorextraction_types_Tonal$__constructor__(android.content.Context ), 0, this, context);
    }

    @Override
    public void extractInto(WallpaperColors wallpaperColors, ColorExtractor.GradientColors gradientColors, ColorExtractor.GradientColors gradientColors2, ColorExtractor.GradientColors gradientColors3) {
        InvokeDynamicSupport.bootstrap("extractInto", $$robo$$com_android_internal_colorextraction_types_Tonal$extractInto(android.app.WallpaperColors com.android.internal.colorextraction.ColorExtractor$GradientColors com.android.internal.colorextraction.ColorExtractor$GradientColors com.android.internal.colorextraction.ColorExtractor$GradientColors ), 0, this, wallpaperColors, gradientColors, gradientColors2, gradientColors3);
    }

    private boolean runTonalExtraction(WallpaperColors wallpaperColors, ColorExtractor.GradientColors gradientColors, ColorExtractor.GradientColors gradientColors2, ColorExtractor.GradientColors gradientColors3) {
        return (boolean)InvokeDynamicSupport.bootstrap("runTonalExtraction", $$robo$$com_android_internal_colorextraction_types_Tonal$runTonalExtraction(android.app.WallpaperColors com.android.internal.colorextraction.ColorExtractor$GradientColors com.android.internal.colorextraction.ColorExtractor$GradientColors com.android.internal.colorextraction.ColorExtractor$GradientColors ), 0, this, wallpaperColors, gradientColors, gradientColors2, gradientColors3);
    }

    private void applyFallback(WallpaperColors wallpaperColors, ColorExtractor.GradientColors gradientColors, ColorExtractor.GradientColors gradientColors2, ColorExtractor.GradientColors gradientColors3) {
        InvokeDynamicSupport.bootstrap("applyFallback", $$robo$$com_android_internal_colorextraction_types_Tonal$applyFallback(android.app.WallpaperColors com.android.internal.colorextraction.ColorExtractor$GradientColors com.android.internal.colorextraction.ColorExtractor$GradientColors com.android.internal.colorextraction.ColorExtractor$GradientColors ), 0, this, wallpaperColors, gradientColors, gradientColors2, gradientColors3);
    }

    public static void applyFallback(WallpaperColors wallpaperColors, ColorExtractor.GradientColors gradientColors) {
        InvokeDynamicSupport.bootstrapStatic("applyFallback", $$robo$$com_android_internal_colorextraction_types_Tonal$applyFallback(android.app.WallpaperColors com.android.internal.colorextraction.ColorExtractor$GradientColors ), 0, (WallpaperColors)wallpaperColors, (ColorExtractor.GradientColors)gradientColors);
    }

    private int getColorInt(int n, float[] fArray, float[] fArray2, float[] fArray3) {
        return (int)InvokeDynamicSupport.bootstrap("getColorInt", $$robo$$com_android_internal_colorextraction_types_Tonal$getColorInt(int float[] float[] float[] ), 0, this, n, fArray, fArray2, fArray3);
    }

    private boolean isBlacklisted(float[] fArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("isBlacklisted", $$robo$$com_android_internal_colorextraction_types_Tonal$isBlacklisted(float[] ), 0, this, fArray);
    }

    private static float[] fit(float[] fArray, float f, int n, float f2, float f3) {
        return InvokeDynamicSupport.bootstrapStatic("fit", $$robo$$com_android_internal_colorextraction_types_Tonal$fit(float[] float int float float ), 0, (float[])fArray, (float)f, (int)n, (float)f2, (float)f3);
    }

    private static int bestFit(TonalPalette tonalPalette, float f, float f2, float f3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("bestFit", $$robo$$com_android_internal_colorextraction_types_Tonal$bestFit(com.android.internal.colorextraction.types.Tonal$TonalPalette float float float ), 0, (TonalPalette)tonalPalette, (float)f, (float)f2, (float)f3);
    }

    public List<ColorRange> getBlacklistedColors() {
        return InvokeDynamicSupport.bootstrap("getBlacklistedColors", $$robo$$com_android_internal_colorextraction_types_Tonal$getBlacklistedColors(), 0, this);
    }

    private TonalPalette findTonalPalette(float f, float f2) {
        return InvokeDynamicSupport.bootstrap("findTonalPalette", $$robo$$com_android_internal_colorextraction_types_Tonal$findTonalPalette(float float ), 0, this, f, f2);
    }

    private static float fract(float f) {
        return (float)InvokeDynamicSupport.bootstrapStatic("fract", $$robo$$com_android_internal_colorextraction_types_Tonal$fract(float ), 0, (float)f);
    }

    public /* synthetic */ Tonal() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Tonal)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ConfigParser
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ArrayList<TonalPalette> mTonalPalettes;
        private ArrayList<ColorRange> mBlacklistedColors;

        private void $$robo$$com_android_internal_colorextraction_types_Tonal_ConfigParser$__constructor__(Context context) {
            this.mTonalPalettes = new ArrayList();
            this.mBlacklistedColors = new ArrayList();
            try {
                XmlResourceParser parser = context.getResources().getXml(18284548);
                int eventType = parser.getEventType();
                while (eventType != 1) {
                    if (eventType != 0 && eventType != 3) {
                        if (eventType == 2) {
                            String tagName = parser.getName();
                            if (tagName.equals("palettes")) {
                                this.parsePalettes(parser);
                            } else if (tagName.equals("blacklist")) {
                                this.parseBlacklist(parser);
                            }
                        } else {
                            throw new XmlPullParserException("Invalid XML event " + eventType + " - " + parser.getName(), parser, null);
                        }
                    }
                    eventType = parser.next();
                }
            }
            catch (IOException | XmlPullParserException e) {
                throw new RuntimeException(e);
            }
        }

        private final ArrayList<TonalPalette> $$robo$$com_android_internal_colorextraction_types_Tonal_ConfigParser$getTonalPalettes() {
            return this.mTonalPalettes;
        }

        private final ArrayList<ColorRange> $$robo$$com_android_internal_colorextraction_types_Tonal_ConfigParser$getBlacklistedColors() {
            return this.mBlacklistedColors;
        }

        private final void $$robo$$com_android_internal_colorextraction_types_Tonal_ConfigParser$parseBlacklist(XmlPullParser parser) throws XmlPullParserException, IOException {
            parser.require(2, null, "blacklist");
            while (parser.next() != 3) {
                if (parser.getEventType() != 2) continue;
                String name = parser.getName();
                if (name.equals("range")) {
                    this.mBlacklistedColors.add(this.readRange(parser));
                    parser.next();
                    continue;
                }
                throw new XmlPullParserException("Invalid tag: " + name, parser, null);
            }
        }

        private final ColorRange $$robo$$com_android_internal_colorextraction_types_Tonal_ConfigParser$readRange(XmlPullParser parser) throws XmlPullParserException, IOException {
            parser.require(2, null, "range");
            float[] h = this.readFloatArray(parser.getAttributeValue(null, "h"));
            float[] s = this.readFloatArray(parser.getAttributeValue(null, "s"));
            float[] l = this.readFloatArray(parser.getAttributeValue(null, "l"));
            if (h == null || s == null || l == null) {
                throw new XmlPullParserException("Incomplete range tag.", parser, null);
            }
            return new ColorRange(new Range<Float>(Float.valueOf(h[0]), Float.valueOf(h[1])), new Range<Float>(Float.valueOf(s[0]), Float.valueOf(s[1])), new Range<Float>(Float.valueOf(l[0]), Float.valueOf(l[1])));
        }

        private final void $$robo$$com_android_internal_colorextraction_types_Tonal_ConfigParser$parsePalettes(XmlPullParser parser) throws XmlPullParserException, IOException {
            parser.require(2, null, "palettes");
            while (parser.next() != 3) {
                if (parser.getEventType() != 2) continue;
                String name = parser.getName();
                if (name.equals("palette")) {
                    this.mTonalPalettes.add(this.readPalette(parser));
                    parser.next();
                    continue;
                }
                throw new XmlPullParserException("Invalid tag: " + name);
            }
        }

        private final TonalPalette $$robo$$com_android_internal_colorextraction_types_Tonal_ConfigParser$readPalette(XmlPullParser parser) throws XmlPullParserException, IOException {
            parser.require(2, null, "palette");
            float[] h = this.readFloatArray(parser.getAttributeValue(null, "h"));
            float[] s = this.readFloatArray(parser.getAttributeValue(null, "s"));
            float[] l = this.readFloatArray(parser.getAttributeValue(null, "l"));
            if (h == null || s == null || l == null) {
                throw new XmlPullParserException("Incomplete range tag.", parser, null);
            }
            return new TonalPalette(h, s, l);
        }

        private final float[] $$robo$$com_android_internal_colorextraction_types_Tonal_ConfigParser$readFloatArray(String attributeValue) throws IOException, XmlPullParserException {
            String[] tokens = attributeValue.replaceAll(" ", "").replaceAll("\n", "").split(",");
            float[] numbers = new float[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                numbers[i] = Float.parseFloat(tokens[i]);
            }
            return numbers;
        }

        private void __constructor__(Context context) {
            this.$$robo$$com_android_internal_colorextraction_types_Tonal_ConfigParser$__constructor__(context);
        }

        public ConfigParser(Context context) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_colorextraction_types_Tonal_ConfigParser$__constructor__(android.content.Context ), 0, this, context);
        }

        public ArrayList<TonalPalette> getTonalPalettes() {
            return InvokeDynamicSupport.bootstrap("getTonalPalettes", $$robo$$com_android_internal_colorextraction_types_Tonal_ConfigParser$getTonalPalettes(), 0, this);
        }

        public ArrayList<ColorRange> getBlacklistedColors() {
            return InvokeDynamicSupport.bootstrap("getBlacklistedColors", $$robo$$com_android_internal_colorextraction_types_Tonal_ConfigParser$getBlacklistedColors(), 0, this);
        }

        private void parseBlacklist(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
            InvokeDynamicSupport.bootstrap("parseBlacklist", $$robo$$com_android_internal_colorextraction_types_Tonal_ConfigParser$parseBlacklist(org.xmlpull.v1.XmlPullParser ), 0, this, xmlPullParser);
        }

        private ColorRange readRange(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
            return InvokeDynamicSupport.bootstrap("readRange", $$robo$$com_android_internal_colorextraction_types_Tonal_ConfigParser$readRange(org.xmlpull.v1.XmlPullParser ), 0, this, xmlPullParser);
        }

        private void parsePalettes(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
            InvokeDynamicSupport.bootstrap("parsePalettes", $$robo$$com_android_internal_colorextraction_types_Tonal_ConfigParser$parsePalettes(org.xmlpull.v1.XmlPullParser ), 0, this, xmlPullParser);
        }

        private TonalPalette readPalette(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
            return InvokeDynamicSupport.bootstrap("readPalette", $$robo$$com_android_internal_colorextraction_types_Tonal_ConfigParser$readPalette(org.xmlpull.v1.XmlPullParser ), 0, this, xmlPullParser);
        }

        private float[] readFloatArray(String string2) throws IOException, XmlPullParserException {
            return InvokeDynamicSupport.bootstrap("readFloatArray", $$robo$$com_android_internal_colorextraction_types_Tonal_ConfigParser$readFloatArray(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ ConfigParser() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConfigParser)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ColorRange
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Range<Float> mHue;
        private Range<Float> mSaturation;
        private Range<Float> mLightness;

        private void $$robo$$com_android_internal_colorextraction_types_Tonal_ColorRange$__constructor__(Range<Float> hue, Range<Float> saturation, Range<Float> lightness) {
            this.mHue = hue;
            this.mSaturation = saturation;
            this.mLightness = lightness;
        }

        private final boolean $$robo$$com_android_internal_colorextraction_types_Tonal_ColorRange$containsColor(float h, float s, float l) {
            if (!this.mHue.contains(Float.valueOf(h))) {
                return false;
            }
            if (!this.mSaturation.contains(Float.valueOf(s))) {
                return false;
            }
            return this.mLightness.contains(Float.valueOf(l));
        }

        private final float[] $$robo$$com_android_internal_colorextraction_types_Tonal_ColorRange$getCenter() {
            return new float[]{this.mHue.getLower().floatValue() + (this.mHue.getUpper().floatValue() - this.mHue.getLower().floatValue()) / 2.0f, this.mSaturation.getLower().floatValue() + (this.mSaturation.getUpper().floatValue() - this.mSaturation.getLower().floatValue()) / 2.0f, this.mLightness.getLower().floatValue() + (this.mLightness.getUpper().floatValue() - this.mLightness.getLower().floatValue()) / 2.0f};
        }

        private final String $$robo$$com_android_internal_colorextraction_types_Tonal_ColorRange$toString() {
            return String.format("H: %s, S: %s, L %s", this.mHue, this.mSaturation, this.mLightness);
        }

        private void __constructor__(Range<Float> range, Range<Float> range2, Range<Float> range3) {
            this.$$robo$$com_android_internal_colorextraction_types_Tonal_ColorRange$__constructor__(range, range2, range3);
        }

        public ColorRange(Range<Float> range, Range<Float> range2, Range<Float> range3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_colorextraction_types_Tonal_ColorRange$__constructor__(android.util.Range<java.lang.Float> android.util.Range<java.lang.Float> android.util.Range<java.lang.Float> ), 0, this, range, range2, range3);
        }

        public boolean containsColor(float f, float f2, float f3) {
            return (boolean)InvokeDynamicSupport.bootstrap("containsColor", $$robo$$com_android_internal_colorextraction_types_Tonal_ColorRange$containsColor(float float float ), 0, this, f, f2, f3);
        }

        public float[] getCenter() {
            return InvokeDynamicSupport.bootstrap("getCenter", $$robo$$com_android_internal_colorextraction_types_Tonal_ColorRange$getCenter(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_colorextraction_types_Tonal_ColorRange$toString(), 0, this);
        }

        public /* synthetic */ ColorRange() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ColorRange)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class TonalPalette
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        float[] h;
        float[] s;
        float[] l;
        float minHue;
        float maxHue;

        private void $$robo$$com_android_internal_colorextraction_types_Tonal_TonalPalette$__constructor__(float[] h, float[] s, float[] l) {
            if (h.length != s.length || s.length != l.length) {
                throw new IllegalArgumentException("All arrays should have the same size. h: " + Arrays.toString(h) + " s: " + Arrays.toString(s) + " l: " + Arrays.toString(l));
            }
            this.h = h;
            this.s = s;
            this.l = l;
            float minHue = Float.POSITIVE_INFINITY;
            float maxHue = Float.NEGATIVE_INFINITY;
            for (float v : h) {
                minHue = Math.min(v, minHue);
                maxHue = Math.max(v, maxHue);
            }
            this.minHue = minHue;
            this.maxHue = maxHue;
        }

        private void __constructor__(float[] fArray, float[] fArray2, float[] fArray3) {
            this.$$robo$$com_android_internal_colorextraction_types_Tonal_TonalPalette$__constructor__(fArray, fArray2, fArray3);
        }

        TonalPalette(float[] fArray, float[] fArray2, float[] fArray3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_colorextraction_types_Tonal_TonalPalette$__constructor__(float[] float[] float[] ), 0, this, fArray, fArray2, fArray3);
        }

        public /* synthetic */ TonalPalette() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TonalPalette)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

