/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.location.gnssmetrics;

import android.os.SystemClock;
import android.util.Base64;
import android.util.TimeUtils;
import com.android.internal.location.nano.GnssLogsProto;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GnssMetrics
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int DEFAULT_TIME_BETWEEN_FIXES_MILLISECS = 1000;
    private String logStartInElapsedRealTime;
    private Statistics locationFailureStatistics;
    private Statistics timeToFirstFixSecStatistics;
    private Statistics positionAccuracyMeterStatistics;
    private Statistics topFourAverageCn0Statistics;

    private void $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics$__constructor__() {
        this.locationFailureStatistics = new Statistics(this);
        this.timeToFirstFixSecStatistics = new Statistics(this);
        this.positionAccuracyMeterStatistics = new Statistics(this);
        this.topFourAverageCn0Statistics = new Statistics(this);
        this.reset();
    }

    private final void $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics$logReceivedLocationStatus(boolean isSuccessful) {
        if (!isSuccessful) {
            this.locationFailureStatistics.addItem(1.0);
            return;
        }
        this.locationFailureStatistics.addItem(0.0);
    }

    private final void $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics$logMissedReports(int desiredTimeBetweenFixesMilliSeconds, int actualTimeBetweenFixesMilliSeconds) {
        int numReportMissed = actualTimeBetweenFixesMilliSeconds / Math.max(1000, desiredTimeBetweenFixesMilliSeconds) - 1;
        if (numReportMissed > 0) {
            for (int i = 0; i < numReportMissed; ++i) {
                this.locationFailureStatistics.addItem(1.0);
            }
        }
    }

    private final void $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics$logTimeToFirstFixMilliSecs(int timeToFirstFixMilliSeconds) {
        this.timeToFirstFixSecStatistics.addItem(timeToFirstFixMilliSeconds / 1000);
    }

    private final void $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics$logPositionAccuracyMeters(float positionAccuracyMeters) {
        this.positionAccuracyMeterStatistics.addItem(positionAccuracyMeters);
    }

    private final void $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics$logCn0(float[] cn0s, int numSv) {
        if (numSv < 4) {
            return;
        }
        float[] cn0Array = Arrays.copyOf(cn0s, numSv);
        Arrays.sort(cn0Array);
        if ((double)cn0Array[numSv - 4] > 0.0) {
            double top4AvgCn0 = 0.0;
            for (int i = numSv - 4; i < numSv; ++i) {
                top4AvgCn0 += (double)cn0Array[i];
            }
            this.topFourAverageCn0Statistics.addItem(top4AvgCn0 /= 4.0);
        }
    }

    private final String $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics$dumpGnssMetricsAsProtoString() {
        GnssLogsProto.GnssLog msg = new GnssLogsProto.GnssLog();
        if (this.locationFailureStatistics.getCount() > 0) {
            msg.numLocationReportProcessed = this.locationFailureStatistics.getCount();
            msg.percentageLocationFailure = (int)(100.0 * this.locationFailureStatistics.getMean());
        }
        if (this.timeToFirstFixSecStatistics.getCount() > 0) {
            msg.numTimeToFirstFixProcessed = this.timeToFirstFixSecStatistics.getCount();
            msg.meanTimeToFirstFixSecs = (int)this.timeToFirstFixSecStatistics.getMean();
            msg.standardDeviationTimeToFirstFixSecs = (int)this.timeToFirstFixSecStatistics.getStandardDeviation();
        }
        if (this.positionAccuracyMeterStatistics.getCount() > 0) {
            msg.numPositionAccuracyProcessed = this.positionAccuracyMeterStatistics.getCount();
            msg.meanPositionAccuracyMeters = (int)this.positionAccuracyMeterStatistics.getMean();
            msg.standardDeviationPositionAccuracyMeters = (int)this.positionAccuracyMeterStatistics.getStandardDeviation();
        }
        if (this.topFourAverageCn0Statistics.getCount() > 0) {
            msg.numTopFourAverageCn0Processed = this.topFourAverageCn0Statistics.getCount();
            msg.meanTopFourAverageCn0DbHz = this.topFourAverageCn0Statistics.getMean();
            msg.standardDeviationTopFourAverageCn0DbHz = this.topFourAverageCn0Statistics.getStandardDeviation();
        }
        String s = Base64.encodeToString(GnssLogsProto.GnssLog.toByteArray(msg), 0);
        this.reset();
        return s;
    }

    private final String $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics$dumpGnssMetricsAsText() {
        StringBuilder s = new StringBuilder();
        s.append("GNSS_KPI_START").append('\n');
        s.append("  KPI logging start time: ").append(this.logStartInElapsedRealTime).append("\n");
        s.append("  KPI logging end time: ");
        TimeUtils.formatDuration(SystemClock.elapsedRealtimeNanos() / 1000000L, s);
        s.append("\n");
        s.append("  Number of location reports: ").append(this.locationFailureStatistics.getCount()).append("\n");
        if (this.locationFailureStatistics.getCount() > 0) {
            s.append("  Percentage location failure: ").append(100.0 * this.locationFailureStatistics.getMean()).append("\n");
        }
        s.append("  Number of TTFF reports: ").append(this.timeToFirstFixSecStatistics.getCount()).append("\n");
        if (this.timeToFirstFixSecStatistics.getCount() > 0) {
            s.append("  TTFF mean (sec): ").append(this.timeToFirstFixSecStatistics.getMean()).append("\n");
            s.append("  TTFF standard deviation (sec): ").append(this.timeToFirstFixSecStatistics.getStandardDeviation()).append("\n");
        }
        s.append("  Number of position accuracy reports: ").append(this.positionAccuracyMeterStatistics.getCount()).append("\n");
        if (this.positionAccuracyMeterStatistics.getCount() > 0) {
            s.append("  Position accuracy mean (m): ").append(this.positionAccuracyMeterStatistics.getMean()).append("\n");
            s.append("  Position accuracy standard deviation (m): ").append(this.positionAccuracyMeterStatistics.getStandardDeviation()).append("\n");
        }
        s.append("  Number of CN0 reports: ").append(this.topFourAverageCn0Statistics.getCount()).append("\n");
        if (this.topFourAverageCn0Statistics.getCount() > 0) {
            s.append("  Top 4 Avg CN0 mean (dB-Hz): ").append(this.topFourAverageCn0Statistics.getMean()).append("\n");
            s.append("  Top 4 Avg CN0 standard deviation (dB-Hz): ").append(this.topFourAverageCn0Statistics.getStandardDeviation()).append("\n");
        }
        s.append("GNSS_KPI_END").append("\n");
        return s.toString();
    }

    private final void $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics$reset() {
        StringBuilder s = new StringBuilder();
        TimeUtils.formatDuration(SystemClock.elapsedRealtimeNanos() / 1000000L, s);
        this.logStartInElapsedRealTime = s.toString();
        this.locationFailureStatistics.reset();
        this.timeToFirstFixSecStatistics.reset();
        this.positionAccuracyMeterStatistics.reset();
        this.topFourAverageCn0Statistics.reset();
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_location_gnssmetrics_GnssMetrics$__constructor__();
    }

    public GnssMetrics() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics$__constructor__(), 0, this);
    }

    public void logReceivedLocationStatus(boolean bl) {
        InvokeDynamicSupport.bootstrap("logReceivedLocationStatus", $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics$logReceivedLocationStatus(boolean ), 0, this, bl);
    }

    public void logMissedReports(int n, int n2) {
        InvokeDynamicSupport.bootstrap("logMissedReports", $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics$logMissedReports(int int ), 0, this, n, n2);
    }

    public void logTimeToFirstFixMilliSecs(int n) {
        InvokeDynamicSupport.bootstrap("logTimeToFirstFixMilliSecs", $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics$logTimeToFirstFixMilliSecs(int ), 0, this, n);
    }

    public void logPositionAccuracyMeters(float f) {
        InvokeDynamicSupport.bootstrap("logPositionAccuracyMeters", $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics$logPositionAccuracyMeters(float ), 0, this, f);
    }

    public void logCn0(float[] fArray, int n) {
        InvokeDynamicSupport.bootstrap("logCn0", $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics$logCn0(float[] int ), 0, this, fArray, n);
    }

    public String dumpGnssMetricsAsProtoString() {
        return InvokeDynamicSupport.bootstrap("dumpGnssMetricsAsProtoString", $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics$dumpGnssMetricsAsProtoString(), 0, this);
    }

    public String dumpGnssMetricsAsText() {
        return InvokeDynamicSupport.bootstrap("dumpGnssMetricsAsText", $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics$dumpGnssMetricsAsText(), 0, this);
    }

    private void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics$reset(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GnssMetrics)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class Statistics
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int count;
        private double sum;
        private double sumSquare;
        /* synthetic */ GnssMetrics this$0;

        private void $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics_Statistics$__constructor__(GnssMetrics gnssMetrics) {
        }

        private final void $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics_Statistics$reset() {
            this.count = 0;
            this.sum = 0.0;
            this.sumSquare = 0.0;
        }

        private final void $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics_Statistics$addItem(double item) {
            ++this.count;
            this.sum += item;
            this.sumSquare += item * item;
        }

        private final int $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics_Statistics$getCount() {
            return this.count;
        }

        private final double $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics_Statistics$getMean() {
            return this.sum / (double)this.count;
        }

        private final double $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics_Statistics$getStandardDeviation() {
            double m = this.sum / (double)this.count;
            double v = this.sumSquare / (double)this.count;
            if (v > (m *= m)) {
                return Math.sqrt(v - m);
            }
            return 0.0;
        }

        private /* synthetic */ void $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics_Statistics$__constructor__(GnssMetrics x0, 1 x1) {
        }

        private void __constructor__(GnssMetrics gnssMetrics) {
            this.$$robo$$com_android_internal_location_gnssmetrics_GnssMetrics_Statistics$__constructor__(gnssMetrics);
        }

        private Statistics(GnssMetrics gnssMetrics) {
            this.this$0 = gnssMetrics;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics_Statistics$__constructor__(com.android.internal.location.gnssmetrics.GnssMetrics ), 0, this, gnssMetrics);
        }

        public void reset() {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics_Statistics$reset(), 0, this);
        }

        public void addItem(double d) {
            InvokeDynamicSupport.bootstrap("addItem", $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics_Statistics$addItem(double ), 0, this, d);
        }

        public int getCount() {
            return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics_Statistics$getCount(), 0, this);
        }

        public double getMean() {
            return (double)InvokeDynamicSupport.bootstrap("getMean", $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics_Statistics$getMean(), 0, this);
        }

        public double getStandardDeviation() {
            return (double)InvokeDynamicSupport.bootstrap("getStandardDeviation", $$robo$$com_android_internal_location_gnssmetrics_GnssMetrics_Statistics$getStandardDeviation(), 0, this);
        }

        private /* synthetic */ void __constructor__(GnssMetrics gnssMetrics, 1 var2_2) {
            this.$$robo$$com_android_internal_location_gnssmetrics_GnssMetrics_Statistics$__constructor__(gnssMetrics, var2_2);
        }

        public /* synthetic */ Statistics() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Statistics)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

