/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.midi;

import android.media.midi.MidiReceiver;
import android.media.midi.MidiSender;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.util.concurrent.CopyOnWriteArrayList;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class MidiDispatcher
extends MidiReceiver
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private MidiReceiverFailureHandler mFailureHandler;
    private CopyOnWriteArrayList<MidiReceiver> mReceivers;
    private MidiSender mSender;

    private void $$robo$$com_android_internal_midi_MidiDispatcher$__constructor__() {
    }

    private void $$robo$$com_android_internal_midi_MidiDispatcher$__constructor__(MidiReceiverFailureHandler failureHandler) {
        this.mReceivers = new CopyOnWriteArrayList();
        this.mSender = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MidiDispatcher this$0;

            private void $$robo$$com_android_internal_midi_MidiDispatcher_1$__constructor__(MidiDispatcher this$0) {
            }

            private final void $$robo$$com_android_internal_midi_MidiDispatcher_1$onConnect(MidiReceiver receiver) {
                this.this$0.mReceivers.add(receiver);
            }

            private final void $$robo$$com_android_internal_midi_MidiDispatcher_1$onDisconnect(MidiReceiver receiver) {
                this.this$0.mReceivers.remove(receiver);
            }

            private void __constructor__(MidiDispatcher midiDispatcher) {
                this.$$robo$$com_android_internal_midi_MidiDispatcher_1$__constructor__(midiDispatcher);
            }
            {
                this.this$0 = midiDispatcher;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_midi_MidiDispatcher_1$__constructor__(com.android.internal.midi.MidiDispatcher ), 0, this, midiDispatcher);
            }

            @Override
            public void onConnect(MidiReceiver midiReceiver) {
                InvokeDynamicSupport.bootstrap("onConnect", $$robo$$com_android_internal_midi_MidiDispatcher_1$onConnect(android.media.midi.MidiReceiver ), 0, this, midiReceiver);
            }

            @Override
            public void onDisconnect(MidiReceiver midiReceiver) {
                InvokeDynamicSupport.bootstrap("onDisconnect", $$robo$$com_android_internal_midi_MidiDispatcher_1$onDisconnect(android.media.midi.MidiReceiver ), 0, this, midiReceiver);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mFailureHandler = failureHandler;
    }

    private final int $$robo$$com_android_internal_midi_MidiDispatcher$getReceiverCount() {
        return this.mReceivers.size();
    }

    private final MidiSender $$robo$$com_android_internal_midi_MidiDispatcher$getSender() {
        return this.mSender;
    }

    private final void $$robo$$com_android_internal_midi_MidiDispatcher$onSend(byte[] msg, int offset, int count, long timestamp) throws IOException {
        for (MidiReceiver receiver : this.mReceivers) {
            try {
                receiver.send(msg, offset, count, timestamp);
            }
            catch (IOException e) {
                this.mReceivers.remove(receiver);
                if (this.mFailureHandler == null) continue;
                this.mFailureHandler.onReceiverFailure(receiver, e);
            }
        }
    }

    private final void $$robo$$com_android_internal_midi_MidiDispatcher$onFlush() throws IOException {
        for (MidiReceiver receiver : this.mReceivers) {
            try {
                receiver.flush();
            }
            catch (IOException e) {
                this.mReceivers.remove(receiver);
                if (this.mFailureHandler == null) continue;
                this.mFailureHandler.onReceiverFailure(receiver, e);
            }
        }
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_midi_MidiDispatcher$__constructor__();
    }

    public MidiDispatcher() {
        this(null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_midi_MidiDispatcher$__constructor__(), 0, this);
    }

    private void __constructor__(MidiReceiverFailureHandler midiReceiverFailureHandler) {
        this.$$robo$$com_android_internal_midi_MidiDispatcher$__constructor__(midiReceiverFailureHandler);
    }

    public MidiDispatcher(MidiReceiverFailureHandler midiReceiverFailureHandler) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_midi_MidiDispatcher$__constructor__(com.android.internal.midi.MidiDispatcher$MidiReceiverFailureHandler ), 0, this, midiReceiverFailureHandler);
    }

    public int getReceiverCount() {
        return (int)InvokeDynamicSupport.bootstrap("getReceiverCount", $$robo$$com_android_internal_midi_MidiDispatcher$getReceiverCount(), 0, this);
    }

    public MidiSender getSender() {
        return InvokeDynamicSupport.bootstrap("getSender", $$robo$$com_android_internal_midi_MidiDispatcher$getSender(), 0, this);
    }

    @Override
    public void onSend(byte[] byArray, int n, int n2, long l) throws IOException {
        InvokeDynamicSupport.bootstrap("onSend", $$robo$$com_android_internal_midi_MidiDispatcher$onSend(byte[] int int long ), 0, this, byArray, n, n2, l);
    }

    @Override
    public void onFlush() throws IOException {
        InvokeDynamicSupport.bootstrap("onFlush", $$robo$$com_android_internal_midi_MidiDispatcher$onFlush(), 0, this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MidiDispatcher)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface MidiReceiverFailureHandler
    extends InstrumentedInterface {
        public void onReceiverFailure(MidiReceiver var1, IOException var2);
    }
}

