/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.SystemClock;
import android.util.Slog;
import android.util.SparseArray;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class KernelUidCpuFreqTimeReader
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static String TAG = "KernelUidCpuFreqTimeReader";
    private static String UID_TIMES_PROC_FILE = "/proc/uid_time_in_state";
    private long[] mCpuFreqs;
    private int mCpuFreqsCount;
    private long mLastTimeReadMs;
    private long mNowTimeMs;
    private SparseArray<long[]> mLastUidCpuFreqTimeMs;
    private static int TOTAL_READ_ERROR_COUNT = 5;
    private int mReadErrorCounter;
    private boolean mProcFileAvailable;

    private void $$robo$$com_android_internal_os_KernelUidCpuFreqTimeReader$__constructor__() {
        this.mLastUidCpuFreqTimeMs = new SparseArray();
    }

    private final void $$robo$$com_android_internal_os_KernelUidCpuFreqTimeReader$readDelta(Callback callback) {
        if (!this.mProcFileAvailable && this.mReadErrorCounter >= 5) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader("/proc/uid_time_in_state"));){
            this.mNowTimeMs = SystemClock.elapsedRealtime();
            this.readDelta(reader, callback);
            this.mLastTimeReadMs = this.mNowTimeMs;
            this.mProcFileAvailable = true;
        }
        catch (IOException e) {
            ++this.mReadErrorCounter;
            Slog.e("KernelUidCpuFreqTimeReader", "Failed to read /proc/uid_time_in_state: " + e);
        }
    }

    private final void $$robo$$com_android_internal_os_KernelUidCpuFreqTimeReader$removeUid(int uid) {
        this.mLastUidCpuFreqTimeMs.delete(uid);
    }

    private final void $$robo$$com_android_internal_os_KernelUidCpuFreqTimeReader$removeUidsInRange(int startUid, int endUid) {
        if (endUid < startUid) {
            return;
        }
        this.mLastUidCpuFreqTimeMs.put(startUid, null);
        this.mLastUidCpuFreqTimeMs.put(endUid, null);
        int firstIndex = this.mLastUidCpuFreqTimeMs.indexOfKey(startUid);
        int lastIndex = this.mLastUidCpuFreqTimeMs.indexOfKey(endUid);
        this.mLastUidCpuFreqTimeMs.removeAtRange(firstIndex, lastIndex - firstIndex + 1);
    }

    private final void $$robo$$com_android_internal_os_KernelUidCpuFreqTimeReader$readDelta(BufferedReader reader, Callback callback) throws IOException {
        String line = reader.readLine();
        if (line == null) {
            return;
        }
        this.readCpuFreqs(line, callback);
        while ((line = reader.readLine()) != null) {
            int index = line.indexOf(32);
            int uid = Integer.parseInt(line.substring(0, index - 1), 10);
            this.readTimesForUid(uid, line.substring(index + 1, line.length()), callback);
        }
    }

    private final void $$robo$$com_android_internal_os_KernelUidCpuFreqTimeReader$readTimesForUid(int uid, String line, Callback callback) {
        String[] timesStr;
        int size;
        long[] uidTimeMs = this.mLastUidCpuFreqTimeMs.get(uid);
        if (uidTimeMs == null) {
            uidTimeMs = new long[this.mCpuFreqsCount];
            this.mLastUidCpuFreqTimeMs.put(uid, uidTimeMs);
        }
        if ((size = (timesStr = line.split(" ")).length) != uidTimeMs.length) {
            Slog.e("KernelUidCpuFreqTimeReader", "No. of readings don't match cpu freqs, readings: " + size + " cpuFreqsCount: " + uidTimeMs.length);
            return;
        }
        long[] deltaUidTimeMs = new long[size];
        long[] curUidTimeMs = new long[size];
        boolean notify = false;
        for (int i = 0; i < size; ++i) {
            long totalTimeMs = Long.parseLong(timesStr[i], 10) * 10L;
            deltaUidTimeMs[i] = totalTimeMs - uidTimeMs[i];
            if (deltaUidTimeMs[i] < 0L || totalTimeMs < 0L) {
                return;
            }
            curUidTimeMs[i] = totalTimeMs;
            notify = notify || deltaUidTimeMs[i] > 0L;
        }
        if (notify) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (long[])curUidTimeMs, (int)0, (long[])uidTimeMs, (int)0, (int)size);
            if (callback != null) {
                callback.onUidCpuFreqTime(uid, deltaUidTimeMs);
            }
        }
    }

    private final void $$robo$$com_android_internal_os_KernelUidCpuFreqTimeReader$readCpuFreqs(String line, Callback callback) {
        if (this.mCpuFreqs == null) {
            String[] freqStr = line.split(" ");
            this.mCpuFreqsCount = freqStr.length - 1;
            this.mCpuFreqs = new long[this.mCpuFreqsCount];
            for (int i = 0; i < this.mCpuFreqsCount; ++i) {
                this.mCpuFreqs[i] = Long.parseLong(freqStr[i + 1], 10);
            }
        }
        if (callback != null) {
            callback.onCpuFreqs(this.mCpuFreqs);
        }
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_os_KernelUidCpuFreqTimeReader$__constructor__();
    }

    public KernelUidCpuFreqTimeReader() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_KernelUidCpuFreqTimeReader$__constructor__(), 0, this);
    }

    public void readDelta(Callback callback) {
        InvokeDynamicSupport.bootstrap("readDelta", $$robo$$com_android_internal_os_KernelUidCpuFreqTimeReader$readDelta(com.android.internal.os.KernelUidCpuFreqTimeReader$Callback ), 0, this, callback);
    }

    public void removeUid(int n) {
        InvokeDynamicSupport.bootstrap("removeUid", $$robo$$com_android_internal_os_KernelUidCpuFreqTimeReader$removeUid(int ), 0, this, n);
    }

    public void removeUidsInRange(int n, int n2) {
        InvokeDynamicSupport.bootstrap("removeUidsInRange", $$robo$$com_android_internal_os_KernelUidCpuFreqTimeReader$removeUidsInRange(int int ), 0, this, n, n2);
    }

    public void readDelta(BufferedReader bufferedReader, Callback callback) throws IOException {
        InvokeDynamicSupport.bootstrap("readDelta", $$robo$$com_android_internal_os_KernelUidCpuFreqTimeReader$readDelta(java.io.BufferedReader com.android.internal.os.KernelUidCpuFreqTimeReader$Callback ), 0, this, bufferedReader, callback);
    }

    private void readTimesForUid(int n, String string2, Callback callback) {
        InvokeDynamicSupport.bootstrap("readTimesForUid", $$robo$$com_android_internal_os_KernelUidCpuFreqTimeReader$readTimesForUid(int java.lang.String com.android.internal.os.KernelUidCpuFreqTimeReader$Callback ), 0, this, n, string2, callback);
    }

    private void readCpuFreqs(String string2, Callback callback) {
        InvokeDynamicSupport.bootstrap("readCpuFreqs", $$robo$$com_android_internal_os_KernelUidCpuFreqTimeReader$readCpuFreqs(java.lang.String com.android.internal.os.KernelUidCpuFreqTimeReader$Callback ), 0, this, string2, callback);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KernelUidCpuFreqTimeReader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface Callback
    extends InstrumentedInterface {
        public void onCpuFreqs(long[] var1);

        public void onUidCpuFreqTime(int var1, long[] var2);
    }
}

