/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Slog;
import android.util.SparseLongArray;
import android.util.TimeUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class KernelUidCpuTimeReader
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "KernelUidCpuTimeReader";
    private static String sProcFile = "/proc/uid_cputime/show_uid_stat";
    private static String sRemoveUidProcFile = "/proc/uid_cputime/remove_uid_range";
    private SparseLongArray mLastUserTimeUs;
    private SparseLongArray mLastSystemTimeUs;
    private long mLastTimeReadUs;

    private void $$robo$$com_android_internal_os_KernelUidCpuTimeReader$__constructor__() {
        this.mLastUserTimeUs = new SparseLongArray();
        this.mLastSystemTimeUs = new SparseLongArray();
        this.mLastTimeReadUs = 0L;
    }

    private final void $$robo$$com_android_internal_os_KernelUidCpuTimeReader$readDelta(Callback callback) {
        long nowUs = SystemClock.elapsedRealtime() * 1000L;
        try (BufferedReader reader = new BufferedReader(new FileReader("/proc/uid_cputime/show_uid_stat"));){
            String line;
            TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(' ');
            while ((line = reader.readLine()) != null) {
                splitter.setString(line);
                Object uidStr = splitter.next();
                int uid = Integer.parseInt(((String)uidStr).substring(0, ((String)uidStr).length() - 1), 10);
                long userTimeUs = Long.parseLong((String)splitter.next(), 10);
                long systemTimeUs = Long.parseLong((String)splitter.next(), 10);
                if (callback != null && this.mLastTimeReadUs != 0L) {
                    long userTimeDeltaUs = userTimeUs;
                    long systemTimeDeltaUs = systemTimeUs;
                    int index = this.mLastUserTimeUs.indexOfKey(uid);
                    if (index >= 0) {
                        long timeDiffUs = nowUs - this.mLastTimeReadUs;
                        if ((userTimeDeltaUs -= this.mLastUserTimeUs.valueAt(index)) < 0L || (systemTimeDeltaUs -= this.mLastSystemTimeUs.valueAt(index)) < 0L) {
                            StringBuilder sb = new StringBuilder("Malformed cpu data for UID=");
                            sb.append(uid).append("!\n");
                            sb.append("Time between reads: ");
                            TimeUtils.formatDuration(timeDiffUs / 1000L, sb);
                            sb.append("\n");
                            sb.append("Previous times: u=");
                            TimeUtils.formatDuration(this.mLastUserTimeUs.valueAt(index) / 1000L, sb);
                            sb.append(" s=");
                            TimeUtils.formatDuration(this.mLastSystemTimeUs.valueAt(index) / 1000L, sb);
                            sb.append("\nCurrent times: u=");
                            TimeUtils.formatDuration(userTimeUs / 1000L, sb);
                            sb.append(" s=");
                            TimeUtils.formatDuration(systemTimeUs / 1000L, sb);
                            sb.append("\nDelta: u=");
                            TimeUtils.formatDuration(userTimeDeltaUs / 1000L, sb);
                            sb.append(" s=");
                            TimeUtils.formatDuration(systemTimeDeltaUs / 1000L, sb);
                            Slog.e("KernelUidCpuTimeReader", sb.toString());
                            userTimeDeltaUs = 0L;
                            systemTimeDeltaUs = 0L;
                        }
                    }
                    if (userTimeDeltaUs != 0L || systemTimeDeltaUs != 0L) {
                        callback.onUidCpuTime(uid, userTimeDeltaUs, systemTimeDeltaUs);
                    }
                }
                this.mLastUserTimeUs.put(uid, userTimeUs);
                this.mLastSystemTimeUs.put(uid, systemTimeUs);
            }
        }
        catch (IOException e) {
            Slog.e("KernelUidCpuTimeReader", "Failed to read uid_cputime: " + e.getMessage());
        }
        this.mLastTimeReadUs = nowUs;
    }

    private final void $$robo$$com_android_internal_os_KernelUidCpuTimeReader$removeUid(int uid) {
        int index = this.mLastSystemTimeUs.indexOfKey(uid);
        if (index >= 0) {
            this.mLastSystemTimeUs.removeAt(index);
            this.mLastUserTimeUs.removeAt(index);
        }
        this.removeUidsFromKernelModule(uid, uid);
    }

    private final void $$robo$$com_android_internal_os_KernelUidCpuTimeReader$removeUidsInRange(int startUid, int endUid) {
        if (endUid < startUid) {
            return;
        }
        this.mLastSystemTimeUs.put(startUid, 0L);
        this.mLastUserTimeUs.put(startUid, 0L);
        this.mLastSystemTimeUs.put(endUid, 0L);
        this.mLastUserTimeUs.put(endUid, 0L);
        int startIndex = this.mLastSystemTimeUs.indexOfKey(startUid);
        int endIndex = this.mLastSystemTimeUs.indexOfKey(endUid);
        this.mLastSystemTimeUs.removeAtRange(startIndex, endIndex - startIndex + 1);
        this.mLastUserTimeUs.removeAtRange(startIndex, endIndex - startIndex + 1);
        this.removeUidsFromKernelModule(startUid, endUid);
    }

    private final void $$robo$$com_android_internal_os_KernelUidCpuTimeReader$removeUidsFromKernelModule(int startUid, int endUid) {
        Slog.d("KernelUidCpuTimeReader", "Removing uids " + startUid + "-" + endUid);
        try (FileWriter writer = new FileWriter("/proc/uid_cputime/remove_uid_range");){
            writer.write(startUid + "-" + endUid);
            writer.flush();
        }
        catch (IOException e) {
            Slog.e("KernelUidCpuTimeReader", "failed to remove uids " + startUid + " - " + endUid + " from uid_cputime module", e);
        }
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_os_KernelUidCpuTimeReader$__constructor__();
    }

    public KernelUidCpuTimeReader() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_KernelUidCpuTimeReader$__constructor__(), 0, this);
    }

    public void readDelta(Callback callback) {
        InvokeDynamicSupport.bootstrap("readDelta", $$robo$$com_android_internal_os_KernelUidCpuTimeReader$readDelta(com.android.internal.os.KernelUidCpuTimeReader$Callback ), 0, this, callback);
    }

    public void removeUid(int n) {
        InvokeDynamicSupport.bootstrap("removeUid", $$robo$$com_android_internal_os_KernelUidCpuTimeReader$removeUid(int ), 0, this, n);
    }

    public void removeUidsInRange(int n, int n2) {
        InvokeDynamicSupport.bootstrap("removeUidsInRange", $$robo$$com_android_internal_os_KernelUidCpuTimeReader$removeUidsInRange(int int ), 0, this, n, n2);
    }

    private void removeUidsFromKernelModule(int n, int n2) {
        InvokeDynamicSupport.bootstrap("removeUidsFromKernelModule", $$robo$$com_android_internal_os_KernelUidCpuTimeReader$removeUidsFromKernelModule(int int ), 0, this, n, n2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KernelUidCpuTimeReader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface Callback
    extends InstrumentedInterface {
        public void onUidCpuTime(int var1, long var2, long var4);
    }
}

