/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import android.util.LongSparseArray;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MemoryPowerCalculator
extends PowerCalculator
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String TAG = "MemoryPowerCalculator";
    private static boolean DEBUG = false;
    private double[] powerAverages;

    private void $$robo$$com_android_internal_os_MemoryPowerCalculator$__constructor__(PowerProfile profile) {
        int numBuckets = profile.getNumElements("memory.bandwidths");
        this.powerAverages = new double[numBuckets];
        for (int i = 0; i < numBuckets; ++i) {
            this.powerAverages[i] = profile.getAveragePower("memory.bandwidths", i);
            if (this.powerAverages[i] != 0.0) continue;
        }
    }

    private final void $$robo$$com_android_internal_os_MemoryPowerCalculator$calculateApp(BatterySipper app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, int statsType) {
    }

    private final void $$robo$$com_android_internal_os_MemoryPowerCalculator$calculateRemaining(BatterySipper app, BatteryStats stats, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        double totalMah = 0.0;
        long totalTimeMs = 0L;
        LongSparseArray<? extends BatteryStats.Timer> timers = stats.getKernelMemoryStats();
        for (int i = 0; i < timers.size() && i < this.powerAverages.length; ++i) {
            double mAatRail = this.powerAverages[(int)timers.keyAt(i)];
            long timeMs = timers.valueAt(i).getTotalTimeLocked(rawRealtimeUs, statsType);
            double mAm = mAatRail * (double)timeMs / 60000.0;
            totalMah += mAm / 60.0;
            totalTimeMs += timeMs;
        }
        app.usagePowerMah = totalMah;
        app.usageTimeMs = totalTimeMs;
    }

    private void __constructor__(PowerProfile powerProfile) {
        this.$$robo$$com_android_internal_os_MemoryPowerCalculator$__constructor__(powerProfile);
    }

    public MemoryPowerCalculator(PowerProfile powerProfile) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_MemoryPowerCalculator$__constructor__(com.android.internal.os.PowerProfile ), 0, this, powerProfile);
    }

    @Override
    public void calculateApp(BatterySipper batterySipper, BatteryStats.Uid uid, long l, long l2, int n) {
        InvokeDynamicSupport.bootstrap("calculateApp", $$robo$$com_android_internal_os_MemoryPowerCalculator$calculateApp(com.android.internal.os.BatterySipper android.os.BatteryStats$Uid long long int ), 0, this, batterySipper, uid, l, l2, n);
    }

    @Override
    public void calculateRemaining(BatterySipper batterySipper, BatteryStats batteryStats, long l, long l2, int n) {
        InvokeDynamicSupport.bootstrap("calculateRemaining", $$robo$$com_android_internal_os_MemoryPowerCalculator$calculateRemaining(com.android.internal.os.BatterySipper android.os.BatteryStats long long int ), 0, this, batterySipper, batteryStats, l, l2, n);
    }

    public /* synthetic */ MemoryPowerCalculator() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MemoryPowerCalculator)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

